# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_youki_global_optspecs
	string join \n l/log= debug log-format= r/root= s/systemd-cgroup systemd-log log-level= v/version h/help
end

function __fish_youki_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_youki_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_youki_using_subcommand
	set -l cmd (__fish_youki_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c youki -n "__fish_youki_needs_command" -s l -l log -d 'set the log file to write youki logs to (default is \'/dev/stderr\')' -r -F
complete -c youki -n "__fish_youki_needs_command" -l log-format -d 'set the log format (\'text\' (default), or \'json\') (default: "text")' -r
complete -c youki -n "__fish_youki_needs_command" -s r -l root -d 'root directory to store container state' -r -F
complete -c youki -n "__fish_youki_needs_command" -l log-level -d 'set the log level (default is \'error\')' -r
complete -c youki -n "__fish_youki_needs_command" -l debug -d 'change log level to debug, but the `log-level` flag takes precedence'
complete -c youki -n "__fish_youki_needs_command" -s s -l systemd-cgroup -d 'Enable systemd cgroup manager, rather then use the cgroupfs directly'
complete -c youki -n "__fish_youki_needs_command" -l systemd-log -d 'Enable logging to systemd-journald'
complete -c youki -n "__fish_youki_needs_command" -s v -l version -d 'Display youki version and commit hash'
complete -c youki -n "__fish_youki_needs_command" -s h -l help -d 'Print help'
complete -c youki -n "__fish_youki_needs_command" -f -a "create" -d 'Create a container Reference: https://github.com/opencontainers/runc/blob/main/man/runc-create.8.md'
complete -c youki -n "__fish_youki_needs_command" -f -a "start" -d 'Start a previously created container'
complete -c youki -n "__fish_youki_needs_command" -f -a "state" -d 'Show the container state'
complete -c youki -n "__fish_youki_needs_command" -f -a "kill" -d 'Send the specified signal to the container'
complete -c youki -n "__fish_youki_needs_command" -f -a "delete" -d 'Release any resources held by the container'
complete -c youki -n "__fish_youki_needs_command" -f -a "checkpointt" -d 'Checkpoint a running container Reference: https://github.com/opencontainers/runc/blob/main/man/runc-checkpoint.8.md'
complete -c youki -n "__fish_youki_needs_command" -f -a "events" -d 'Show resource statistics for the container'
complete -c youki -n "__fish_youki_needs_command" -f -a "exec" -d 'Execute a process within an existing container Reference: https://github.com/opencontainers/runc/blob/main/man/runc-exec.8.md'
complete -c youki -n "__fish_youki_needs_command" -f -a "features" -d 'Return the features list for a container This subcommand was introduced in runc by https://github.com/opencontainers/runc/pull/3296 It is documented here: https://github.com/opencontainers/runtime-spec/blob/main/features-linux.md'
complete -c youki -n "__fish_youki_needs_command" -f -a "list" -d 'List created containers'
complete -c youki -n "__fish_youki_needs_command" -f -a "pause" -d 'Suspend the processes within the container'
complete -c youki -n "__fish_youki_needs_command" -f -a "ps" -d 'Display the processes inside the container'
complete -c youki -n "__fish_youki_needs_command" -f -a "resume" -d 'Resume the processes within the container'
complete -c youki -n "__fish_youki_needs_command" -f -a "run" -d 'Create a container and immediately start it'
complete -c youki -n "__fish_youki_needs_command" -f -a "update" -d 'Update running container resource constraints'
complete -c youki -n "__fish_youki_needs_command" -f -a "spec" -d 'Command generates a config.json'
complete -c youki -n "__fish_youki_needs_command" -f -a "info" -d 'Show information about the system'
complete -c youki -n "__fish_youki_needs_command" -f -a "completion" -d 'Generate scripts for shell completion'
complete -c youki -n "__fish_youki_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c youki -n "__fish_youki_using_subcommand create" -s b -l bundle -d 'Path to the bundle directory, containing config.json and root filesystem' -r -F
complete -c youki -n "__fish_youki_using_subcommand create" -s c -l console-socket -d 'Unix socket (file) path , which will receive file descriptor of the writing end of the pseudoterminal' -r -F
complete -c youki -n "__fish_youki_using_subcommand create" -s p -l pid-file -d 'File to write pid of the container created' -r -F
complete -c youki -n "__fish_youki_using_subcommand create" -l preserve-fds -d 'Pass N additional file descriptors to the container (stdio + $LISTEN_FDS + N in total)' -r
complete -c youki -n "__fish_youki_using_subcommand create" -l no-pivot -d 'Do not use pivot rool to jail process inside rootfs'
complete -c youki -n "__fish_youki_using_subcommand create" -l no-new-keyring -d 'Do not create a new session keyring for the container'
complete -c youki -n "__fish_youki_using_subcommand create" -s h -l help -d 'Print help'
complete -c youki -n "__fish_youki_using_subcommand start" -s h -l help -d 'Print help'
complete -c youki -n "__fish_youki_using_subcommand state" -s h -l help -d 'Print help'
complete -c youki -n "__fish_youki_using_subcommand kill" -s a -l all
complete -c youki -n "__fish_youki_using_subcommand kill" -s h -l help -d 'Print help'
complete -c youki -n "__fish_youki_using_subcommand delete" -s f -l force -d 'forces deletion of the container if it is still running (using SIGKILL)'
complete -c youki -n "__fish_youki_using_subcommand delete" -s h -l help -d 'Print help'
complete -c youki -n "__fish_youki_using_subcommand checkpointt" -l image-path -d 'Path for saving criu image files' -r -F
complete -c youki -n "__fish_youki_using_subcommand checkpointt" -l work-path -d 'Path for saving work files and logs' -r -F
complete -c youki -n "__fish_youki_using_subcommand checkpointt" -l parent-path -d 'Path for previous criu image file in pre-dump' -r -F
complete -c youki -n "__fish_youki_using_subcommand checkpointt" -l status-fd -d 'Pass a file descriptor fd to criu' -r
complete -c youki -n "__fish_youki_using_subcommand checkpointt" -l page-server -d 'Start a page server at the given URL' -r
complete -c youki -n "__fish_youki_using_subcommand checkpointt" -l manage-cgroups-mode -d 'Cgroups mode' -r
complete -c youki -n "__fish_youki_using_subcommand checkpointt" -l leave-running -d 'Leave the process running after checkpointing'
complete -c youki -n "__fish_youki_using_subcommand checkpointt" -l tcp-established -d 'Allow open tcp connections'
complete -c youki -n "__fish_youki_using_subcommand checkpointt" -l ext-unix-sk -d 'Allow external unix sockets'
complete -c youki -n "__fish_youki_using_subcommand checkpointt" -l shell-job -d 'Allow shell jobs'
complete -c youki -n "__fish_youki_using_subcommand checkpointt" -l lazy-pages -d 'Use lazy migration mechanism'
complete -c youki -n "__fish_youki_using_subcommand checkpointt" -l file-locks -d 'Allow file locks'
complete -c youki -n "__fish_youki_using_subcommand checkpointt" -l pre-dump -d 'Do a pre-dump'
complete -c youki -n "__fish_youki_using_subcommand checkpointt" -l empty-ns -d 'Checkpoint a namespace, but don\'t save its properties'
complete -c youki -n "__fish_youki_using_subcommand checkpointt" -l auto-dedup -d 'Enable auto-deduplication'
complete -c youki -n "__fish_youki_using_subcommand checkpointt" -s h -l help -d 'Print help'
complete -c youki -n "__fish_youki_using_subcommand events" -l interval -d 'Sets the stats collection interval in seconds (default: 5s)' -r
complete -c youki -n "__fish_youki_using_subcommand events" -l stats -d 'Display the container stats only once'
complete -c youki -n "__fish_youki_using_subcommand events" -s h -l help -d 'Print help'
complete -c youki -n "__fish_youki_using_subcommand exec" -l console-socket -d 'Unix socket (file) path , which will receive file descriptor of the writing end of the pseudoterminal' -r -F
complete -c youki -n "__fish_youki_using_subcommand exec" -l cwd -d 'Current working directory of the container' -r -F
complete -c youki -n "__fish_youki_using_subcommand exec" -s e -l env -d 'Environment variables that should be set in the container' -r
complete -c youki -n "__fish_youki_using_subcommand exec" -s u -l user -d 'Run the command as a user' -r
complete -c youki -n "__fish_youki_using_subcommand exec" -s g -l additional-gids -d 'Add additional group IDs. Can be specified multiple times' -r
complete -c youki -n "__fish_youki_using_subcommand exec" -s p -l process -d 'Path to process.json' -r -F
complete -c youki -n "__fish_youki_using_subcommand exec" -l pid-file -d 'The file to which the pid of the container process should be written to' -r -F
complete -c youki -n "__fish_youki_using_subcommand exec" -l process-label -d 'Set the asm process label for the process commonly used with selinux' -r
complete -c youki -n "__fish_youki_using_subcommand exec" -l apparmor -d 'Set the apparmor profile for the process' -r
complete -c youki -n "__fish_youki_using_subcommand exec" -l cap -d 'Add a capability to the bounding set for the process' -r
complete -c youki -n "__fish_youki_using_subcommand exec" -l preserve-fds -d 'Pass N additional file descriptors to the container' -r
complete -c youki -n "__fish_youki_using_subcommand exec" -l cgroup -d 'Execute a process in a sub-cgroup' -r
complete -c youki -n "__fish_youki_using_subcommand exec" -s t -l tty
complete -c youki -n "__fish_youki_using_subcommand exec" -s d -l detach -d 'Detach from the container process'
complete -c youki -n "__fish_youki_using_subcommand exec" -l no-new-privs -d 'Prevent the process from gaining additional privileges'
complete -c youki -n "__fish_youki_using_subcommand exec" -l ignore-paused -d 'Allow exec in a paused container'
complete -c youki -n "__fish_youki_using_subcommand exec" -s h -l help -d 'Print help'
complete -c youki -n "__fish_youki_using_subcommand features" -s h -l help -d 'Print help'
complete -c youki -n "__fish_youki_using_subcommand list" -l format -d 'Specify the format (default or table)' -r
complete -c youki -n "__fish_youki_using_subcommand list" -s q -l quiet -d 'Only display container IDs'
complete -c youki -n "__fish_youki_using_subcommand list" -s h -l help -d 'Print help'
complete -c youki -n "__fish_youki_using_subcommand pause" -s h -l help -d 'Print help'
complete -c youki -n "__fish_youki_using_subcommand ps" -s f -l format -d 'format to display processes: table or json (default: "table")' -r
complete -c youki -n "__fish_youki_using_subcommand ps" -s h -l help -d 'Print help'
complete -c youki -n "__fish_youki_using_subcommand resume" -s h -l help -d 'Print help'
complete -c youki -n "__fish_youki_using_subcommand run" -s b -l bundle -d 'Path to the bundle directory, containing config.json and root filesystem' -r -F
complete -c youki -n "__fish_youki_using_subcommand run" -s c -l console-socket -d 'Unix socket (file) path , which will receive file descriptor of the writing end of the pseudoterminal' -r -F
complete -c youki -n "__fish_youki_using_subcommand run" -s p -l pid-file -d 'File to write pid of the container created' -r -F
complete -c youki -n "__fish_youki_using_subcommand run" -l preserve-fds -d 'Pass N additional file descriptors to the container (stdio + $LISTEN_FDS + N in total)' -r
complete -c youki -n "__fish_youki_using_subcommand run" -l no-subreaper -d 'Disable the use of the subreaper used to reap reparented processes'
complete -c youki -n "__fish_youki_using_subcommand run" -l no-pivot -d 'Do not use pivot root to jail process inside rootfs'
complete -c youki -n "__fish_youki_using_subcommand run" -l no-new-keyring -d 'Do not create a new session keyring for the container. This will cause the container to inherit the calling processes session key'
complete -c youki -n "__fish_youki_using_subcommand run" -l keep
complete -c youki -n "__fish_youki_using_subcommand run" -s d -l detach -d 'Detach from the container process'
complete -c youki -n "__fish_youki_using_subcommand run" -s h -l help -d 'Print help'
complete -c youki -n "__fish_youki_using_subcommand update" -s r -l resources -d 'Read the new resource limits from the given json file. Use - to read from stdin. If this option is used, all other options are ignored' -r -F
complete -c youki -n "__fish_youki_using_subcommand update" -l blkio-weight -d 'Set a new I/O weight' -r
complete -c youki -n "__fish_youki_using_subcommand update" -l cpu-period -d 'Set CPU CFS period to be used for hardcapping (in microseconds)' -r
complete -c youki -n "__fish_youki_using_subcommand update" -l cpu-quota -d 'Set CPU usage limit within a given period (in microseconds)' -r
complete -c youki -n "__fish_youki_using_subcommand update" -l cpu-rt-period -d 'Set CPU realtime period to be used for hardcapping (in microseconds)' -r
complete -c youki -n "__fish_youki_using_subcommand update" -l cpu-rt-runtime -d 'Set CPU realtime hardcap limit (in microseconds)' -r
complete -c youki -n "__fish_youki_using_subcommand update" -l cpu-share -d 'Set CPU shares (relative weight vs. other containers)' -r
complete -c youki -n "__fish_youki_using_subcommand update" -l cpuset-cpus -d 'Set CPU(s) to use. The list can contain commas and ranges. For example: 0-3,7' -r
complete -c youki -n "__fish_youki_using_subcommand update" -l cpuset-mems -d 'Set memory node(s) to use. The list format is the same as for --cpuset-cpus' -r
complete -c youki -n "__fish_youki_using_subcommand update" -l memory -d 'Set memory limit to num bytes' -r
complete -c youki -n "__fish_youki_using_subcommand update" -l memory-reservation -d 'Set memory reservation (or soft limit) to num bytes' -r
complete -c youki -n "__fish_youki_using_subcommand update" -l memory-swap -d 'Set total memory + swap usage to num bytes. Use -1 to unset the limit (i.e. use unlimited swap)' -r
complete -c youki -n "__fish_youki_using_subcommand update" -l pids-limit -d 'Set the maximum number of processes allowed in the container' -r
complete -c youki -n "__fish_youki_using_subcommand update" -l l3-cache-schema -d 'Set the value for Intel RDT/CAT L3 cache schema' -r
complete -c youki -n "__fish_youki_using_subcommand update" -l mem-bw-schema -d 'Set the Intel RDT/MBA memory bandwidth schema' -r
complete -c youki -n "__fish_youki_using_subcommand update" -s h -l help -d 'Print help'
complete -c youki -n "__fish_youki_using_subcommand spec" -s b -l bundle -d 'Set path to the root of the bundle directory' -r -F
complete -c youki -n "__fish_youki_using_subcommand spec" -l rootless -d 'Generate a configuration for a rootless container'
complete -c youki -n "__fish_youki_using_subcommand spec" -s h -l help -d 'Print help'
complete -c youki -n "__fish_youki_using_subcommand info" -s h -l help -d 'Print help'
complete -c youki -n "__fish_youki_using_subcommand completion" -s s -l shell -r -f -a "{bash\t'',elvish\t'',fish\t'',powershell\t'',zsh\t''}"
complete -c youki -n "__fish_youki_using_subcommand completion" -s h -l help -d 'Print help'
complete -c youki -n "__fish_youki_using_subcommand help; and not __fish_seen_subcommand_from create start state kill delete checkpointt events exec features list pause ps resume run update spec info completion help" -f -a "create" -d 'Create a container Reference: https://github.com/opencontainers/runc/blob/main/man/runc-create.8.md'
complete -c youki -n "__fish_youki_using_subcommand help; and not __fish_seen_subcommand_from create start state kill delete checkpointt events exec features list pause ps resume run update spec info completion help" -f -a "start" -d 'Start a previously created container'
complete -c youki -n "__fish_youki_using_subcommand help; and not __fish_seen_subcommand_from create start state kill delete checkpointt events exec features list pause ps resume run update spec info completion help" -f -a "state" -d 'Show the container state'
complete -c youki -n "__fish_youki_using_subcommand help; and not __fish_seen_subcommand_from create start state kill delete checkpointt events exec features list pause ps resume run update spec info completion help" -f -a "kill" -d 'Send the specified signal to the container'
complete -c youki -n "__fish_youki_using_subcommand help; and not __fish_seen_subcommand_from create start state kill delete checkpointt events exec features list pause ps resume run update spec info completion help" -f -a "delete" -d 'Release any resources held by the container'
complete -c youki -n "__fish_youki_using_subcommand help; and not __fish_seen_subcommand_from create start state kill delete checkpointt events exec features list pause ps resume run update spec info completion help" -f -a "checkpointt" -d 'Checkpoint a running container Reference: https://github.com/opencontainers/runc/blob/main/man/runc-checkpoint.8.md'
complete -c youki -n "__fish_youki_using_subcommand help; and not __fish_seen_subcommand_from create start state kill delete checkpointt events exec features list pause ps resume run update spec info completion help" -f -a "events" -d 'Show resource statistics for the container'
complete -c youki -n "__fish_youki_using_subcommand help; and not __fish_seen_subcommand_from create start state kill delete checkpointt events exec features list pause ps resume run update spec info completion help" -f -a "exec" -d 'Execute a process within an existing container Reference: https://github.com/opencontainers/runc/blob/main/man/runc-exec.8.md'
complete -c youki -n "__fish_youki_using_subcommand help; and not __fish_seen_subcommand_from create start state kill delete checkpointt events exec features list pause ps resume run update spec info completion help" -f -a "features" -d 'Return the features list for a container This subcommand was introduced in runc by https://github.com/opencontainers/runc/pull/3296 It is documented here: https://github.com/opencontainers/runtime-spec/blob/main/features-linux.md'
complete -c youki -n "__fish_youki_using_subcommand help; and not __fish_seen_subcommand_from create start state kill delete checkpointt events exec features list pause ps resume run update spec info completion help" -f -a "list" -d 'List created containers'
complete -c youki -n "__fish_youki_using_subcommand help; and not __fish_seen_subcommand_from create start state kill delete checkpointt events exec features list pause ps resume run update spec info completion help" -f -a "pause" -d 'Suspend the processes within the container'
complete -c youki -n "__fish_youki_using_subcommand help; and not __fish_seen_subcommand_from create start state kill delete checkpointt events exec features list pause ps resume run update spec info completion help" -f -a "ps" -d 'Display the processes inside the container'
complete -c youki -n "__fish_youki_using_subcommand help; and not __fish_seen_subcommand_from create start state kill delete checkpointt events exec features list pause ps resume run update spec info completion help" -f -a "resume" -d 'Resume the processes within the container'
complete -c youki -n "__fish_youki_using_subcommand help; and not __fish_seen_subcommand_from create start state kill delete checkpointt events exec features list pause ps resume run update spec info completion help" -f -a "run" -d 'Create a container and immediately start it'
complete -c youki -n "__fish_youki_using_subcommand help; and not __fish_seen_subcommand_from create start state kill delete checkpointt events exec features list pause ps resume run update spec info completion help" -f -a "update" -d 'Update running container resource constraints'
complete -c youki -n "__fish_youki_using_subcommand help; and not __fish_seen_subcommand_from create start state kill delete checkpointt events exec features list pause ps resume run update spec info completion help" -f -a "spec" -d 'Command generates a config.json'
complete -c youki -n "__fish_youki_using_subcommand help; and not __fish_seen_subcommand_from create start state kill delete checkpointt events exec features list pause ps resume run update spec info completion help" -f -a "info" -d 'Show information about the system'
complete -c youki -n "__fish_youki_using_subcommand help; and not __fish_seen_subcommand_from create start state kill delete checkpointt events exec features list pause ps resume run update spec info completion help" -f -a "completion" -d 'Generate scripts for shell completion'
complete -c youki -n "__fish_youki_using_subcommand help; and not __fish_seen_subcommand_from create start state kill delete checkpointt events exec features list pause ps resume run update spec info completion help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
