function __fish_tl_print_command
    set -l cmdline (commandline -poc)
    set -l cmd
    set -e cmdline[1]
    for arg in $cmdline
        switch $arg
            case completion
                set cmd $cmd completion
                break
            case check
                set cmd $cmd check
                break
            case gen
                set cmd $cmd gen
                break
            case run
                set cmd $cmd run
                break
            case warnings
                set cmd $cmd warnings
                break
            case types
                set cmd $cmd types
                break
        end
    end
    echo "$cmd"
end

function __fish_tl_using_command
    test (__fish_tl_print_command) = "$argv"
    and return 0
    or return 1
end

function __fish_tl_seen_command
    string match -q "$argv*" (__fish_tl_print_command)
    and return 0
    or return 1
end

complete -c tl -n '__fish_tl_using_command' -xa 'completion' -d 'Output a shell completion script'
complete -c tl -n '__fish_tl_using_command' -xa 'check' -d 'Type-check one or more Teal files'
complete -c tl -n '__fish_tl_using_command' -xa 'gen' -d 'Generate a Lua file for one or more Teal files'
complete -c tl -n '__fish_tl_using_command' -xa 'run' -d 'Run a Teal script'
complete -c tl -n '__fish_tl_using_command' -xa 'warnings' -d 'List each kind of warning the compiler can produce'
complete -c tl -n '__fish_tl_using_command' -xa 'types' -d 'Report all types found in one or more Teal files'
complete -c tl -s h -l help -d 'Show this help message and exit'
complete -c tl -l global-env-def -r -d 'Predefined types from a custom global environment'
complete -c tl -s I -l include-dir -r -d 'Prepend this directory to the module search path'
complete -c tl -l wdisable -xa 'branch debug hint redeclaration unknown unread unused' -d 'Disable the given kind of warning'
complete -c tl -l werror -xa 'all branch debug hint redeclaration unknown unread unused' -d 'Promote the given kind of warning to an error'
complete -c tl -l feat-arity -xa 'off on' -d 'Define minimum arities for functions based on optional argument annotations'
complete -c tl -l gen-compat -xa 'off optional required' -d 'Generate compatibility code for targeting different Lua VM versions'
complete -c tl -l gen-target -xa '5.1 5.3 5.4' -d 'Minimum targeted Lua version for generated code'
complete -c tl -l skip-compat53 -d 'Skip compat53 insertions'
complete -c tl -l version -d 'Print version and exit'
complete -c tl -s q -l quiet -d 'Do not print information messages to stdout'
complete -c tl -s p -l pretend -d 'Do not write to any files, type check and output what files would be generated'

complete -c tl -n '__fish_tl_seen_command completion' -s h -l help -d 'Show this help message and exit'

complete -c tl -n '__fish_tl_seen_command check' -s h -l help -d 'Show this help message and exit'

complete -c tl -n '__fish_tl_seen_command gen' -s h -l help -d 'Show this help message and exit'
complete -c tl -n '__fish_tl_seen_command gen' -s c -l check -d 'Type check and fail on type errors'
complete -c tl -n '__fish_tl_seen_command gen' -l keep-hashbang -d 'Preserve hashbang line (#!) at the top of file if present'
complete -c tl -n '__fish_tl_seen_command gen' -s o -l output -r -d 'Write to <filename> instead'

complete -c tl -n '__fish_tl_seen_command run' -s h -l help -d 'Show this help message and exit'
complete -c tl -n '__fish_tl_seen_command run' -s l -l require -r -d 'Require module for execution'

complete -c tl -n '__fish_tl_seen_command warnings' -s h -l help -d 'Show this help message and exit'

complete -c tl -n '__fish_tl_seen_command types' -s h -l help -d 'Show this help message and exit'
complete -c tl -n '__fish_tl_seen_command types' -s p -l position -r -d 'Report values in scope in position line[:column]'
