/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.zeno;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.ma.zeno.ZenoChainIterator;

public class ZenoChain<T>
implements Iterable<T> {
    private ArrayList<ArrayList<T>> masterList;

    public ZenoChain() {
        this.masterList = new ArrayList(8);
    }

    private ZenoChain(ArrayList<ArrayList<T>> masterList) {
        this.masterList = masterList;
    }

    public ZenoChain<T> add(T item) {
        if (this.masterList.isEmpty()) {
            ArrayList<T> newSegment = new ArrayList<T>(32);
            newSegment.add(item);
            this.masterList.add(newSegment);
            return this;
        }
        int threshold = 32;
        int index = this.masterList.size() - 1;
        ArrayList<T> segment = this.masterList.get(index);
        if (segment.size() < threshold) {
            segment.add(item);
            return this;
        }
        while (true) {
            threshold *= 2;
            if (--index < 0) {
                ArrayList<T> newFinalSegment = new ArrayList<T>();
                newFinalSegment.add(item);
                this.masterList.add(newFinalSegment);
                return this;
            }
            ArrayList<T> priorSegment = this.masterList.get(index);
            if (priorSegment.size() + segment.size() <= threshold) {
                priorSegment.addAll(segment);
                this.masterList.remove(index + 1);
                ArrayList<T> newFinalSegment = new ArrayList<T>();
                newFinalSegment.add(item);
                this.masterList.add(newFinalSegment);
                return this;
            }
            segment = priorSegment;
        }
    }

    public ZenoChain<T> prepend(T item) {
        if (this.masterList.isEmpty()) {
            ArrayList<T> newSegment = new ArrayList<T>(32);
            newSegment.add(item);
            this.masterList.add(newSegment);
            return this;
        }
        int threshold = 32;
        int index = 0;
        ArrayList<T> segment = this.masterList.get(index);
        if (segment.size() < threshold) {
            segment.add(0, item);
            return this;
        }
        while (true) {
            threshold *= 2;
            if (++index <= this.masterList.size()) {
                ArrayList<T> newInitialSegment = new ArrayList<T>();
                newInitialSegment.add(item);
                this.masterList.add(0, newInitialSegment);
                return this;
            }
            ArrayList<T> nextSegment = this.masterList.get(index);
            if (nextSegment.size() + segment.size() <= threshold) {
                nextSegment.addAll(segment);
                this.masterList.remove(index - 1);
                ArrayList<T> newInitialSegment = new ArrayList<T>();
                newInitialSegment.add(0, item);
                this.masterList.add(0, newInitialSegment);
                return this;
            }
            segment = nextSegment;
        }
    }

    public ZenoChain<T> addAll(Iterable<? extends T> items) {
        ZenoChain<T> result = this;
        for (T item : items) {
            result = result.add(item);
        }
        return result;
    }

    public ZenoChain<T> concat(ZenoChain<T> other) {
        ArrayList<ArrayList<T>> newMaster = new ArrayList<ArrayList<T>>(this.masterList.size() + other.masterList.size());
        newMaster.addAll(this.masterList);
        newMaster.addAll(other.masterList);
        return super.reorganize();
    }

    private ZenoChain<T> reorganize() {
        for (int i = this.masterList.size() - 2; i >= 1; --i) {
            int priorSize = this.masterList.get(i - 1).size();
            int segSize = this.masterList.get(i).size();
            int nextSize = this.masterList.get(i + 1).size();
            if (segSize >= priorSize || segSize >= nextSize) continue;
            ArrayList combinedSegment = new ArrayList(priorSize + segSize);
            combinedSegment.addAll(this.masterList.get(i - 1));
            combinedSegment.addAll(this.masterList.get(i));
            this.masterList.set(i - 1, combinedSegment);
            this.masterList.remove(i);
        }
        return new ZenoChain<T>(this.masterList);
    }

    public T get(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Index " + n + " is negative");
        }
        int offset = 0;
        for (ArrayList<T> segment : this.masterList) {
            if (offset + segment.size() > n) {
                return segment.get(n - offset);
            }
            offset += segment.size();
        }
        throw new IndexOutOfBoundsException("Index " + n + " is too large");
    }

    /*
     * Enabled aggressive block sorting
     */
    public ZenoChain<T> subList(int start, int end) {
        ArrayList<ArrayList<T>> newMaster = new ArrayList<ArrayList<T>>();
        int offset = 0;
        int remainingLength = end - start;
        boolean active = false;
        Iterator<ArrayList<T>> iterator = this.masterList.iterator();
        while (iterator.hasNext()) {
            ArrayList<T> segment = iterator.next();
            if (active) {
                if (remainingLength <= segment.size()) {
                    newMaster.add(new ArrayList<T>(segment.subList(0, remainingLength)));
                    return new ZenoChain<T>(newMaster);
                }
                remainingLength -= segment.size();
                newMaster.add(new ArrayList<T>(segment));
            } else if (offset + segment.size() >= start) {
                int localStart = start - offset;
                if (remainingLength <= segment.size() - localStart) {
                    newMaster.add(new ArrayList<T>(segment.subList(localStart, localStart + remainingLength)));
                    return new ZenoChain<T>(newMaster);
                }
                newMaster.add(new ArrayList<T>(segment.subList(localStart, segment.size())));
                remainingLength -= segment.size() - localStart;
                active = true;
            }
            offset += segment.size();
        }
        return new ZenoChain<T>(newMaster);
    }

    public int size() {
        int total = 0;
        for (ArrayList<T> segment : this.masterList) {
            total += segment.size();
        }
        return total;
    }

    public boolean isEmpty() {
        return this.masterList.isEmpty() || this.masterList.size() == 1 && this.masterList.get(0).isEmpty();
    }

    public boolean isSingleton() {
        return this.masterList.size() == 1 && this.masterList.get(0).size() == 1;
    }

    @Override
    public Iterator<T> iterator() {
        return new ZenoChainIterator(this.masterList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (List list : this.masterList) {
            sb.append("(");
            for (Object item : list) {
                sb.append(item).append(",");
            }
            sb.setCharAt(sb.length() - 1, ')');
        }
        return sb.toString();
    }

    public String show() {
        StringBuilder sb = new StringBuilder();
        for (List list : this.masterList) {
            sb.append(list.size()).append(",");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        ZenoChain<Integer> chain = new ZenoChain<Integer>();
        for (int i = 0; i < 20000; ++i) {
            chain.add(i);
            System.err.println(chain.show());
        }
        System.err.println(chain.toString());
        System.err.println("ITER");
        for (Integer integer : chain) {
            System.err.println(integer);
        }
    }
}

