/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.lib.DirectResourceResolver;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.trans.XPathException;

public class StandardModuleURIResolver
implements ModuleURIResolver {
    Configuration config = null;

    public StandardModuleURIResolver() {
    }

    public StandardModuleURIResolver(Configuration config) {
        this.config = config;
    }

    public void setConfiguration(Configuration config) {
        if (this.config == null) {
            this.config = config;
        }
    }

    @Override
    public StreamSource[] resolve(String moduleURI, String baseURI, String[] locations) throws XPathException {
        if (this.config == null) {
            throw new NullPointerException("No Configuration available in StandardModuleResolver");
        }
        StreamSource source = this.resolveModuleURI(moduleURI, baseURI);
        if (source != null) {
            return new StreamSource[]{source};
        }
        if (locations.length == 0) {
            XPathException err = new XPathException("Cannot locate module for namespace " + moduleURI);
            err.setErrorCode("XQST0059");
            err.setIsStaticError(true);
            throw err;
        }
        ArrayList<StreamSource> moduleSources = new ArrayList<StreamSource>();
        for (String hint : locations) {
            StreamSource ss = this.resolveLocationHint(baseURI, hint);
            if (ss == null) continue;
            moduleSources.add(ss);
        }
        return moduleSources.toArray(new StreamSource[0]);
    }

    protected StreamSource resolveModuleURI(String moduleURI, String baseURI) {
        try {
            Source source = null;
            if (this.config != null) {
                ResourceRequest rr = new ResourceRequest();
                rr.uri = moduleURI;
                rr.uriIsNamespace = true;
                rr.baseUri = baseURI;
                rr.nature = "https://www.iana.org/assignments/media-types/application/xquery";
                source = this.config.getResourceResolver().resolve(rr);
                if (source == null && baseURI != null) {
                    rr.uri = new URI(baseURI).resolve(moduleURI).toString();
                    rr.uriIsNamespace = false;
                    source = this.config.getResourceResolver().resolve(rr);
                }
            }
            if (source != null) {
                return this.toStreamSource(source);
            }
        }
        catch (URISyntaxException | TransformerException exception) {
            // empty catch block
        }
        return null;
    }

    private StreamSource toStreamSource(Source src) {
        return (StreamSource)src;
    }

    protected StreamSource resolveLocationHint(String baseURI, String locationHint) throws XPathException {
        ResourceRequest rr = new ResourceRequest();
        rr.baseUri = baseURI;
        rr.relativeUri = locationHint;
        rr.nature = "https://www.iana.org/assignments/media-types/application/xquery";
        try {
            rr.uri = ResolveURI.makeAbsolute(rr.relativeUri, baseURI).toString();
            return (StreamSource)rr.resolve(this.config.getResourceResolver(), new DirectResourceResolver(this.config));
        }
        catch (URISyntaxException err) {
            XPathException se = new XPathException("Cannot resolve relative URI " + rr.relativeUri, err);
            se.setErrorCode("XQST0059");
            se.setIsStaticError(true);
            throw se;
        }
    }
}

