# Contributing guide

Thank you for investing your time in contributing to our project. ❤️

This repository is part of the _re·sil·ient_ ecosystem, with the main project being the [**resilient.sile**](https://github.com/Omikhleia/resilient.sile) collection of classes and packages.

We are excited to have you on board and look forward to your contributions. This guide will help you understand how to contribute effectively and what we expect from you.

## License grants for contributions

### License grants for submitted code

When submitting code, you agree to license your contribution under the same license as the project (the MIT license).
This means that your code will be available for others to use, modify, and distribute under the same terms as the _re·sil·ient_ project itself, and it may be upstreamed to the SILE Typesetter, which is a separate project with its own owners (currently distributed under the MIT license).

The _re·sil·ient_ project owes a lot to the SILE Typesetter project, and we may want to propose improvements and components that were initially developed for the _re·sil·ient_ project, for inclusion up-stream to SILE, when they are deemed useful in its larger context.
This is a way to give back to the SILE community and ensure that the features we develop can benefit a wider audience.

### License grants for submitted documentation

When submitting documentation, you agree to license your contribution under the same license as the project (CC-BY-SA 2.0 or any other license that is compatible with the CC-BY-SA 2.0 license). This means that your documentation will be available for others to use, modify, and distribute under the same terms as the project documentation itself.

By documentation, we mean any text, images, or other content that you submit to the project, including but not limited to README files, user guides, and other in-code documentation content.

### License grants for submitted templates

When submitting templates (notably used for "book matters" such as cover pages, title and half-title pages, endpapers, etc.), you agree to license your contribution under CC0 Universal / Public Domain. This means that your templates will be available for others to use, modify, and distribute unumcumbered of constraints.

The rationale for this is that such templates should be considered as data files, which will likely be copied and used with or without modification by authors and editors in their books, and that users should not be constrained by any license or copyright regarding the output of processing their original content with _re·sil·ient_ when using such templates.

## Issues first, Pull Requests later

Always ensure your issue is not already reported before creating a new one. If you find an existing issue that matches your problem, please add any relevant information to that issue instead of creating a new one.

Please refrain from submitting Pull Requests (PRs) before discussing your ideas in the Issues section. This will help us understand your intentions and provide feedback on your proposed changes.

This is especially important for larger changes or new features, as we want to ensure that your work aligns with the project's goals and direction.

## Code style

- Use spaces instead of tabs for indentation.
- Use 2 spaces for indentation.
- Write clear and concise comments to explain complex code, and use LDoc-style comments for functions and classes.
- Follow the existing code style and conventions in the project.
- When modifying existing code, try to maintain the same style and structure as the surrounding code, and avoid introducing unnecessary changes.
