/**************************************************************************
/* This class adds all the GM methods to an Operation.
/*
/* Copyright (c) 2009 by Bernhard Bablok (mail@bablokb.de)
/*
/* This program is free software; you can redistribute it and/or modify
/* it under the terms of the GNU Library General Public License as published
/* by  the Free Software Foundation; either version 2 of the License or
/* (at your option) any later version.
/*
/* This program is distributed in the hope that it will be useful, but
/* WITHOUT ANY WARRANTY; without even the implied warranty of
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/* GNU Library General Public License for more details.
/*
/* You should have received a copy of the GNU Library General Public License
/* along with this program; see the file COPYING.LIB.  If not, write to
/* the Free Software Foundation Inc., 59 Temple Place - Suite 330,
/* Boston, MA  02111-1307 USA
/**************************************************************************/

package org.im4java.core;

/**
   This class subclasses Operation and adds methods for all commandline
   options of GraphicsMagick.

   <p>This class is automatically generated by the source-code generator of
   im4java.</p>

   @version $Revision: 1.14 $
   @author  $Author: bablokb $
*/

public class GMOps extends Operation {

  //////////////////////////////////////////////////////////////////////////////

  /**
     The protected Constructor. You should only use subclasses of GMOps.
  */

  protected GMOps() {
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -adjoin to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps adjoin() {

    iCmdArgs.add("-adjoin");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +adjoin to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_adjoin() {

    iCmdArgs.add("+adjoin");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -affine to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps affine() {

    iCmdArgs.add("-affine");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -affine to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps affine(Double sx) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-affine");

    if (sx != null) {
      buf.append(sx.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -affine to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps affine(Double sx, Double rx) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-affine");

    if (sx != null) {
      buf.append(sx.toString());
    }
    if (sx != null || rx != null) {
      buf.append(",");
    }
    if (rx != null) {
      buf.append(rx.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -affine to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps affine(Double sx, Double rx, Double ry) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-affine");

    if (sx != null) {
      buf.append(sx.toString());
    }
    if (sx != null || rx != null) {
      buf.append(",");
    }
    if (rx != null) {
      buf.append(rx.toString());
    }
    if (rx != null || ry != null) {
      buf.append(",");
    }
    if (ry != null) {
      buf.append(ry.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -affine to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps affine(Double sx, Double rx, Double ry, Double sy) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-affine");

    if (sx != null) {
      buf.append(sx.toString());
    }
    if (sx != null || rx != null) {
      buf.append(",");
    }
    if (rx != null) {
      buf.append(rx.toString());
    }
    if (rx != null || ry != null) {
      buf.append(",");
    }
    if (ry != null) {
      buf.append(ry.toString());
    }
    if (ry != null || sy != null) {
      buf.append(",");
    }
    if (sy != null) {
      buf.append(sy.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -affine to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps affine(Double sx, Double rx, Double ry, Double sy, Double tx) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-affine");

    if (sx != null) {
      buf.append(sx.toString());
    }
    if (sx != null || rx != null) {
      buf.append(",");
    }
    if (rx != null) {
      buf.append(rx.toString());
    }
    if (rx != null || ry != null) {
      buf.append(",");
    }
    if (ry != null) {
      buf.append(ry.toString());
    }
    if (ry != null || sy != null) {
      buf.append(",");
    }
    if (sy != null) {
      buf.append(sy.toString());
    }
    if (sy != null || tx != null) {
      buf.append(",");
    }
    if (tx != null) {
      buf.append(tx.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -affine to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps affine(Double sx, Double rx, Double ry, Double sy, Double tx, Double ty) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-affine");

    if (sx != null) {
      buf.append(sx.toString());
    }
    if (sx != null || rx != null) {
      buf.append(",");
    }
    if (rx != null) {
      buf.append(rx.toString());
    }
    if (rx != null || ry != null) {
      buf.append(",");
    }
    if (ry != null) {
      buf.append(ry.toString());
    }
    if (ry != null || sy != null) {
      buf.append(",");
    }
    if (sy != null) {
      buf.append(sy.toString());
    }
    if (sy != null || tx != null) {
      buf.append(",");
    }
    if (tx != null) {
      buf.append(tx.toString());
    }
    if (tx != null || ty != null) {
      buf.append(",");
    }
    if (ty != null) {
      buf.append(ty.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -antialias to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps antialias() {

    iCmdArgs.add("-antialias");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +antialias to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_antialias() {

    iCmdArgs.add("+antialias");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -append to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps append() {

    iCmdArgs.add("-append");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +append to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_append() {

    iCmdArgs.add("+append");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -authenticate to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps authenticate() {

    iCmdArgs.add("-authenticate");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -authenticate to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps authenticate(String password) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-authenticate");

    if (password != null) {
      buf.append(password.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -average to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps average() {

    iCmdArgs.add("-average");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -backdrop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps backdrop() {

    iCmdArgs.add("-backdrop");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -background to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps background() {

    iCmdArgs.add("-background");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -background to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps background(String color) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-background");

    if (color != null) {
      buf.append(color.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -black-threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps blackThreshold() {

    iCmdArgs.add("-black-threshold");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -black-threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps blackThreshold(Double threshold) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-black-threshold");

    if (threshold != null) {
      buf.append(threshold.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -black-threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps blackThreshold(Double threshold, Boolean percent) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-black-threshold");

    if (threshold != null) {
      buf.append(threshold.toString());
    }
    if (threshold != null || percent != null) {
    }
    if (percent != null) {
      if (percent.booleanValue())
        buf.append("%");
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -blue-primary to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps bluePrimary() {

    iCmdArgs.add("-blue-primary");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -blue-primary to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps bluePrimary(Double x) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-blue-primary");

    if (x != null) {
      buf.append(x.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -blue-primary to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps bluePrimary(Double x, Double y) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-blue-primary");

    if (x != null) {
      buf.append(x.toString());
    }
    if (x != null || y != null) {
      buf.append(",");
    }
    if (y != null) {
      buf.append(y.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -blur to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps blur() {

    iCmdArgs.add("-blur");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -blur to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps blur(Double radius) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-blur");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -blur to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps blur(Double radius, Double sigma) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-blur");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (radius != null || sigma != null) {
      buf.append("x");
    }
    if (sigma != null) {
      buf.append(sigma.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -bordercolor to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps bordercolor() {

    iCmdArgs.add("-bordercolor");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -bordercolor to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps bordercolor(String color) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-bordercolor");

    if (color != null) {
      buf.append(color.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -borderwidth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps borderwidth() {

    iCmdArgs.add("-borderwidth");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -borderwidth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps borderwidth(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-borderwidth");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -borderwidth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps borderwidth(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-borderwidth");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -borderwidth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps borderwidth(Integer width, Integer height, Integer x) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-borderwidth");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || x != null) {
      oper="+";
      if (x.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (x != null) {
      buf.append(x.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -borderwidth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps borderwidth(Integer width, Integer height, Integer x, Integer y) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-borderwidth");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || x != null) {
      oper="+";
      if (x.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (x != null) {
      buf.append(x.toString());
    }
    if (x != null || y != null) {
      oper="+";
      if (y.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (y != null) {
      buf.append(y.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -borderwidth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps borderwidth(Integer width, Integer height, Integer x, Integer y, Boolean percent) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-borderwidth");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || x != null) {
      oper="+";
      if (x.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (x != null) {
      buf.append(x.toString());
    }
    if (x != null || y != null) {
      oper="+";
      if (y.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (y != null) {
      buf.append(y.toString());
    }
    if (y != null || percent != null) {
    }
    if (percent != null) {
      if (percent.booleanValue())
        buf.append("%");
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +borderwidth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_borderwidth() {

    iCmdArgs.add("+borderwidth");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -border to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps border() {

    iCmdArgs.add("-border");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -border to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps border(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-border");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -border to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps border(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-border");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -box to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps box() {

    iCmdArgs.add("-box");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -box to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps box(String pColor) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-box");

    if (pColor != null) {
      buf.append(pColor.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -channel to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps channel() {

    iCmdArgs.add("-channel");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -channel to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps channel(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-channel");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -charcoal to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps charcoal() {

    iCmdArgs.add("-charcoal");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -charcoal to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps charcoal(Integer factor) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-charcoal");

    if (factor != null) {
      buf.append(factor.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -chop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps chop() {

    iCmdArgs.add("-chop");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -chop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps chop(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-chop");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -chop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps chop(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-chop");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -chop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps chop(Integer width, Integer height, Integer x) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-chop");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || x != null) {
      oper="+";
      if (x.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (x != null) {
      buf.append(x.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -chop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps chop(Integer width, Integer height, Integer x, Integer y) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-chop");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || x != null) {
      oper="+";
      if (x.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (x != null) {
      buf.append(x.toString());
    }
    if (x != null || y != null) {
      oper="+";
      if (y.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (y != null) {
      buf.append(y.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -chop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps chop(Integer width, Integer height, Integer x, Integer y, Boolean percent) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-chop");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || x != null) {
      oper="+";
      if (x.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (x != null) {
      buf.append(x.toString());
    }
    if (x != null || y != null) {
      oper="+";
      if (y.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (y != null) {
      buf.append(y.toString());
    }
    if (y != null || percent != null) {
    }
    if (percent != null) {
      if (percent.booleanValue())
        buf.append("%");
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -clip to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps clip() {

    iCmdArgs.add("-clip");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -clippath to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps clippath() {

    iCmdArgs.add("-clippath");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -coalesce to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps coalesce() {

    iCmdArgs.add("-coalesce");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -colorize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps colorize() {

    iCmdArgs.add("-colorize");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -colorize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps colorize(Integer red) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-colorize");

    if (red != null) {
      buf.append(red.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -colorize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps colorize(Integer red, Integer blue) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-colorize");

    if (red != null) {
      buf.append(red.toString());
    }
    if (red != null || blue != null) {
      buf.append("/");
    }
    if (blue != null) {
      buf.append(blue.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -colorize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps colorize(Integer red, Integer blue, Integer green) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-colorize");

    if (red != null) {
      buf.append(red.toString());
    }
    if (red != null || blue != null) {
      buf.append("/");
    }
    if (blue != null) {
      buf.append(blue.toString());
    }
    if (blue != null || green != null) {
      buf.append("/");
    }
    if (green != null) {
      buf.append(green.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -colors to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps colors() {

    iCmdArgs.add("-colors");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -colors to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps colors(Integer value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-colors");

    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -colorspace to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps colorspace() {

    iCmdArgs.add("-colorspace");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -colorspace to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps colorspace(String value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-colorspace");

    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -comment to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps comment() {

    iCmdArgs.add("-comment");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -comment to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps comment(String text) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-comment");

    if (text != null) {
      buf.append(text.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +compress to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_compress() {

    iCmdArgs.add("+compress");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -compress to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps compress() {

    iCmdArgs.add("-compress");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -compress to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps compress(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-compress");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -contrast to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps contrast() {

    iCmdArgs.add("-contrast");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +contrast to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_contrast() {

    iCmdArgs.add("+contrast");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve() {

    iCmdArgs.add("-convolve");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    if (k1 != null || k2 != null) {
      buf.append(",");
    }
    if (k2 != null) {
      buf.append(k2.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    if (k1 != null || k2 != null) {
      buf.append(",");
    }
    if (k2 != null) {
      buf.append(k2.toString());
    }
    if (k2 != null || k3 != null) {
      buf.append(",");
    }
    if (k3 != null) {
      buf.append(k3.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    if (k1 != null || k2 != null) {
      buf.append(",");
    }
    if (k2 != null) {
      buf.append(k2.toString());
    }
    if (k2 != null || k3 != null) {
      buf.append(",");
    }
    if (k3 != null) {
      buf.append(k3.toString());
    }
    if (k3 != null || k4 != null) {
      buf.append(",");
    }
    if (k4 != null) {
      buf.append(k4.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    if (k1 != null || k2 != null) {
      buf.append(",");
    }
    if (k2 != null) {
      buf.append(k2.toString());
    }
    if (k2 != null || k3 != null) {
      buf.append(",");
    }
    if (k3 != null) {
      buf.append(k3.toString());
    }
    if (k3 != null || k4 != null) {
      buf.append(",");
    }
    if (k4 != null) {
      buf.append(k4.toString());
    }
    if (k4 != null || k5 != null) {
      buf.append(",");
    }
    if (k5 != null) {
      buf.append(k5.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    if (k1 != null || k2 != null) {
      buf.append(",");
    }
    if (k2 != null) {
      buf.append(k2.toString());
    }
    if (k2 != null || k3 != null) {
      buf.append(",");
    }
    if (k3 != null) {
      buf.append(k3.toString());
    }
    if (k3 != null || k4 != null) {
      buf.append(",");
    }
    if (k4 != null) {
      buf.append(k4.toString());
    }
    if (k4 != null || k5 != null) {
      buf.append(",");
    }
    if (k5 != null) {
      buf.append(k5.toString());
    }
    if (k5 != null || k6 != null) {
      buf.append(",");
    }
    if (k6 != null) {
      buf.append(k6.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    if (k1 != null || k2 != null) {
      buf.append(",");
    }
    if (k2 != null) {
      buf.append(k2.toString());
    }
    if (k2 != null || k3 != null) {
      buf.append(",");
    }
    if (k3 != null) {
      buf.append(k3.toString());
    }
    if (k3 != null || k4 != null) {
      buf.append(",");
    }
    if (k4 != null) {
      buf.append(k4.toString());
    }
    if (k4 != null || k5 != null) {
      buf.append(",");
    }
    if (k5 != null) {
      buf.append(k5.toString());
    }
    if (k5 != null || k6 != null) {
      buf.append(",");
    }
    if (k6 != null) {
      buf.append(k6.toString());
    }
    if (k6 != null || k7 != null) {
      buf.append(",");
    }
    if (k7 != null) {
      buf.append(k7.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    if (k1 != null || k2 != null) {
      buf.append(",");
    }
    if (k2 != null) {
      buf.append(k2.toString());
    }
    if (k2 != null || k3 != null) {
      buf.append(",");
    }
    if (k3 != null) {
      buf.append(k3.toString());
    }
    if (k3 != null || k4 != null) {
      buf.append(",");
    }
    if (k4 != null) {
      buf.append(k4.toString());
    }
    if (k4 != null || k5 != null) {
      buf.append(",");
    }
    if (k5 != null) {
      buf.append(k5.toString());
    }
    if (k5 != null || k6 != null) {
      buf.append(",");
    }
    if (k6 != null) {
      buf.append(k6.toString());
    }
    if (k6 != null || k7 != null) {
      buf.append(",");
    }
    if (k7 != null) {
      buf.append(k7.toString());
    }
    if (k7 != null || k8 != null) {
      buf.append(",");
    }
    if (k8 != null) {
      buf.append(k8.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    if (k1 != null || k2 != null) {
      buf.append(",");
    }
    if (k2 != null) {
      buf.append(k2.toString());
    }
    if (k2 != null || k3 != null) {
      buf.append(",");
    }
    if (k3 != null) {
      buf.append(k3.toString());
    }
    if (k3 != null || k4 != null) {
      buf.append(",");
    }
    if (k4 != null) {
      buf.append(k4.toString());
    }
    if (k4 != null || k5 != null) {
      buf.append(",");
    }
    if (k5 != null) {
      buf.append(k5.toString());
    }
    if (k5 != null || k6 != null) {
      buf.append(",");
    }
    if (k6 != null) {
      buf.append(k6.toString());
    }
    if (k6 != null || k7 != null) {
      buf.append(",");
    }
    if (k7 != null) {
      buf.append(k7.toString());
    }
    if (k7 != null || k8 != null) {
      buf.append(",");
    }
    if (k8 != null) {
      buf.append(k8.toString());
    }
    if (k8 != null || k9 != null) {
      buf.append(",");
    }
    if (k9 != null) {
      buf.append(k9.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9, Integer k10) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    if (k1 != null || k2 != null) {
      buf.append(",");
    }
    if (k2 != null) {
      buf.append(k2.toString());
    }
    if (k2 != null || k3 != null) {
      buf.append(",");
    }
    if (k3 != null) {
      buf.append(k3.toString());
    }
    if (k3 != null || k4 != null) {
      buf.append(",");
    }
    if (k4 != null) {
      buf.append(k4.toString());
    }
    if (k4 != null || k5 != null) {
      buf.append(",");
    }
    if (k5 != null) {
      buf.append(k5.toString());
    }
    if (k5 != null || k6 != null) {
      buf.append(",");
    }
    if (k6 != null) {
      buf.append(k6.toString());
    }
    if (k6 != null || k7 != null) {
      buf.append(",");
    }
    if (k7 != null) {
      buf.append(k7.toString());
    }
    if (k7 != null || k8 != null) {
      buf.append(",");
    }
    if (k8 != null) {
      buf.append(k8.toString());
    }
    if (k8 != null || k9 != null) {
      buf.append(",");
    }
    if (k9 != null) {
      buf.append(k9.toString());
    }
    if (k9 != null || k10 != null) {
      buf.append(",");
    }
    if (k10 != null) {
      buf.append(k10.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9, Integer k10, Integer k11) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    if (k1 != null || k2 != null) {
      buf.append(",");
    }
    if (k2 != null) {
      buf.append(k2.toString());
    }
    if (k2 != null || k3 != null) {
      buf.append(",");
    }
    if (k3 != null) {
      buf.append(k3.toString());
    }
    if (k3 != null || k4 != null) {
      buf.append(",");
    }
    if (k4 != null) {
      buf.append(k4.toString());
    }
    if (k4 != null || k5 != null) {
      buf.append(",");
    }
    if (k5 != null) {
      buf.append(k5.toString());
    }
    if (k5 != null || k6 != null) {
      buf.append(",");
    }
    if (k6 != null) {
      buf.append(k6.toString());
    }
    if (k6 != null || k7 != null) {
      buf.append(",");
    }
    if (k7 != null) {
      buf.append(k7.toString());
    }
    if (k7 != null || k8 != null) {
      buf.append(",");
    }
    if (k8 != null) {
      buf.append(k8.toString());
    }
    if (k8 != null || k9 != null) {
      buf.append(",");
    }
    if (k9 != null) {
      buf.append(k9.toString());
    }
    if (k9 != null || k10 != null) {
      buf.append(",");
    }
    if (k10 != null) {
      buf.append(k10.toString());
    }
    if (k10 != null || k11 != null) {
      buf.append(",");
    }
    if (k11 != null) {
      buf.append(k11.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9, Integer k10, Integer k11, Integer k12) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    if (k1 != null || k2 != null) {
      buf.append(",");
    }
    if (k2 != null) {
      buf.append(k2.toString());
    }
    if (k2 != null || k3 != null) {
      buf.append(",");
    }
    if (k3 != null) {
      buf.append(k3.toString());
    }
    if (k3 != null || k4 != null) {
      buf.append(",");
    }
    if (k4 != null) {
      buf.append(k4.toString());
    }
    if (k4 != null || k5 != null) {
      buf.append(",");
    }
    if (k5 != null) {
      buf.append(k5.toString());
    }
    if (k5 != null || k6 != null) {
      buf.append(",");
    }
    if (k6 != null) {
      buf.append(k6.toString());
    }
    if (k6 != null || k7 != null) {
      buf.append(",");
    }
    if (k7 != null) {
      buf.append(k7.toString());
    }
    if (k7 != null || k8 != null) {
      buf.append(",");
    }
    if (k8 != null) {
      buf.append(k8.toString());
    }
    if (k8 != null || k9 != null) {
      buf.append(",");
    }
    if (k9 != null) {
      buf.append(k9.toString());
    }
    if (k9 != null || k10 != null) {
      buf.append(",");
    }
    if (k10 != null) {
      buf.append(k10.toString());
    }
    if (k10 != null || k11 != null) {
      buf.append(",");
    }
    if (k11 != null) {
      buf.append(k11.toString());
    }
    if (k11 != null || k12 != null) {
      buf.append(",");
    }
    if (k12 != null) {
      buf.append(k12.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9, Integer k10, Integer k11, Integer k12, Integer k13) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    if (k1 != null || k2 != null) {
      buf.append(",");
    }
    if (k2 != null) {
      buf.append(k2.toString());
    }
    if (k2 != null || k3 != null) {
      buf.append(",");
    }
    if (k3 != null) {
      buf.append(k3.toString());
    }
    if (k3 != null || k4 != null) {
      buf.append(",");
    }
    if (k4 != null) {
      buf.append(k4.toString());
    }
    if (k4 != null || k5 != null) {
      buf.append(",");
    }
    if (k5 != null) {
      buf.append(k5.toString());
    }
    if (k5 != null || k6 != null) {
      buf.append(",");
    }
    if (k6 != null) {
      buf.append(k6.toString());
    }
    if (k6 != null || k7 != null) {
      buf.append(",");
    }
    if (k7 != null) {
      buf.append(k7.toString());
    }
    if (k7 != null || k8 != null) {
      buf.append(",");
    }
    if (k8 != null) {
      buf.append(k8.toString());
    }
    if (k8 != null || k9 != null) {
      buf.append(",");
    }
    if (k9 != null) {
      buf.append(k9.toString());
    }
    if (k9 != null || k10 != null) {
      buf.append(",");
    }
    if (k10 != null) {
      buf.append(k10.toString());
    }
    if (k10 != null || k11 != null) {
      buf.append(",");
    }
    if (k11 != null) {
      buf.append(k11.toString());
    }
    if (k11 != null || k12 != null) {
      buf.append(",");
    }
    if (k12 != null) {
      buf.append(k12.toString());
    }
    if (k12 != null || k13 != null) {
      buf.append(",");
    }
    if (k13 != null) {
      buf.append(k13.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9, Integer k10, Integer k11, Integer k12, Integer k13, Integer k14) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    if (k1 != null || k2 != null) {
      buf.append(",");
    }
    if (k2 != null) {
      buf.append(k2.toString());
    }
    if (k2 != null || k3 != null) {
      buf.append(",");
    }
    if (k3 != null) {
      buf.append(k3.toString());
    }
    if (k3 != null || k4 != null) {
      buf.append(",");
    }
    if (k4 != null) {
      buf.append(k4.toString());
    }
    if (k4 != null || k5 != null) {
      buf.append(",");
    }
    if (k5 != null) {
      buf.append(k5.toString());
    }
    if (k5 != null || k6 != null) {
      buf.append(",");
    }
    if (k6 != null) {
      buf.append(k6.toString());
    }
    if (k6 != null || k7 != null) {
      buf.append(",");
    }
    if (k7 != null) {
      buf.append(k7.toString());
    }
    if (k7 != null || k8 != null) {
      buf.append(",");
    }
    if (k8 != null) {
      buf.append(k8.toString());
    }
    if (k8 != null || k9 != null) {
      buf.append(",");
    }
    if (k9 != null) {
      buf.append(k9.toString());
    }
    if (k9 != null || k10 != null) {
      buf.append(",");
    }
    if (k10 != null) {
      buf.append(k10.toString());
    }
    if (k10 != null || k11 != null) {
      buf.append(",");
    }
    if (k11 != null) {
      buf.append(k11.toString());
    }
    if (k11 != null || k12 != null) {
      buf.append(",");
    }
    if (k12 != null) {
      buf.append(k12.toString());
    }
    if (k12 != null || k13 != null) {
      buf.append(",");
    }
    if (k13 != null) {
      buf.append(k13.toString());
    }
    if (k13 != null || k14 != null) {
      buf.append(",");
    }
    if (k14 != null) {
      buf.append(k14.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9, Integer k10, Integer k11, Integer k12, Integer k13, Integer k14, Integer k15) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    if (k1 != null || k2 != null) {
      buf.append(",");
    }
    if (k2 != null) {
      buf.append(k2.toString());
    }
    if (k2 != null || k3 != null) {
      buf.append(",");
    }
    if (k3 != null) {
      buf.append(k3.toString());
    }
    if (k3 != null || k4 != null) {
      buf.append(",");
    }
    if (k4 != null) {
      buf.append(k4.toString());
    }
    if (k4 != null || k5 != null) {
      buf.append(",");
    }
    if (k5 != null) {
      buf.append(k5.toString());
    }
    if (k5 != null || k6 != null) {
      buf.append(",");
    }
    if (k6 != null) {
      buf.append(k6.toString());
    }
    if (k6 != null || k7 != null) {
      buf.append(",");
    }
    if (k7 != null) {
      buf.append(k7.toString());
    }
    if (k7 != null || k8 != null) {
      buf.append(",");
    }
    if (k8 != null) {
      buf.append(k8.toString());
    }
    if (k8 != null || k9 != null) {
      buf.append(",");
    }
    if (k9 != null) {
      buf.append(k9.toString());
    }
    if (k9 != null || k10 != null) {
      buf.append(",");
    }
    if (k10 != null) {
      buf.append(k10.toString());
    }
    if (k10 != null || k11 != null) {
      buf.append(",");
    }
    if (k11 != null) {
      buf.append(k11.toString());
    }
    if (k11 != null || k12 != null) {
      buf.append(",");
    }
    if (k12 != null) {
      buf.append(k12.toString());
    }
    if (k12 != null || k13 != null) {
      buf.append(",");
    }
    if (k13 != null) {
      buf.append(k13.toString());
    }
    if (k13 != null || k14 != null) {
      buf.append(",");
    }
    if (k14 != null) {
      buf.append(k14.toString());
    }
    if (k14 != null || k15 != null) {
      buf.append(",");
    }
    if (k15 != null) {
      buf.append(k15.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9, Integer k10, Integer k11, Integer k12, Integer k13, Integer k14, Integer k15, Integer k16) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    if (k1 != null || k2 != null) {
      buf.append(",");
    }
    if (k2 != null) {
      buf.append(k2.toString());
    }
    if (k2 != null || k3 != null) {
      buf.append(",");
    }
    if (k3 != null) {
      buf.append(k3.toString());
    }
    if (k3 != null || k4 != null) {
      buf.append(",");
    }
    if (k4 != null) {
      buf.append(k4.toString());
    }
    if (k4 != null || k5 != null) {
      buf.append(",");
    }
    if (k5 != null) {
      buf.append(k5.toString());
    }
    if (k5 != null || k6 != null) {
      buf.append(",");
    }
    if (k6 != null) {
      buf.append(k6.toString());
    }
    if (k6 != null || k7 != null) {
      buf.append(",");
    }
    if (k7 != null) {
      buf.append(k7.toString());
    }
    if (k7 != null || k8 != null) {
      buf.append(",");
    }
    if (k8 != null) {
      buf.append(k8.toString());
    }
    if (k8 != null || k9 != null) {
      buf.append(",");
    }
    if (k9 != null) {
      buf.append(k9.toString());
    }
    if (k9 != null || k10 != null) {
      buf.append(",");
    }
    if (k10 != null) {
      buf.append(k10.toString());
    }
    if (k10 != null || k11 != null) {
      buf.append(",");
    }
    if (k11 != null) {
      buf.append(k11.toString());
    }
    if (k11 != null || k12 != null) {
      buf.append(",");
    }
    if (k12 != null) {
      buf.append(k12.toString());
    }
    if (k12 != null || k13 != null) {
      buf.append(",");
    }
    if (k13 != null) {
      buf.append(k13.toString());
    }
    if (k13 != null || k14 != null) {
      buf.append(",");
    }
    if (k14 != null) {
      buf.append(k14.toString());
    }
    if (k14 != null || k15 != null) {
      buf.append(",");
    }
    if (k15 != null) {
      buf.append(k15.toString());
    }
    if (k15 != null || k16 != null) {
      buf.append(",");
    }
    if (k16 != null) {
      buf.append(k16.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -crop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps crop() {

    iCmdArgs.add("-crop");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -crop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps crop(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-crop");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -crop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps crop(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-crop");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -crop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps crop(Integer width, Integer height, Integer x) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-crop");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || x != null) {
      oper="+";
      if (x.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (x != null) {
      buf.append(x.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -crop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps crop(Integer width, Integer height, Integer x, Integer y) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-crop");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || x != null) {
      oper="+";
      if (x.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (x != null) {
      buf.append(x.toString());
    }
    if (x != null || y != null) {
      oper="+";
      if (y.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (y != null) {
      buf.append(y.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -crop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps crop(Integer width, Integer height, Integer x, Integer y, Character special) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-crop");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || x != null) {
      oper="+";
      if (x.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (x != null) {
      buf.append(x.toString());
    }
    if (x != null || y != null) {
      oper="+";
      if (y.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (y != null) {
      buf.append(y.toString());
    }
    if (y != null || special != null) {
    }
    if (special != null) {
      buf.append(special.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -cycle to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps cycle() {

    iCmdArgs.add("-cycle");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -cycle to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps cycle(Integer amount) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-cycle");

    if (amount != null) {
      buf.append(amount.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +debug to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_debug() {

    iCmdArgs.add("+debug");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -debug to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps debug() {

    iCmdArgs.add("-debug");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -debug to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps debug(String events) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-debug");

    if (events != null) {
      buf.append(events.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -deconstruct to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps deconstruct() {

    iCmdArgs.add("-deconstruct");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -define to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps define() {

    iCmdArgs.add("-define");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -define to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps define(String keyValue) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-define");

    if (keyValue != null) {
      buf.append(keyValue.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +define to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_define() {

    iCmdArgs.add("+define");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +define to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_define(String keyValue) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+define");

    if (keyValue != null) {
      buf.append(keyValue.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -delay to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps delay() {

    iCmdArgs.add("-delay");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -delay to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps delay(Integer ticks) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-delay");

    if (ticks != null) {
      buf.append(ticks.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -delay to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps delay(Integer ticks, Integer ticksPerSecond) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-delay");

    if (ticks != null) {
      buf.append(ticks.toString());
    }
    if (ticks != null || ticksPerSecond != null) {
      buf.append("x");
    }
    if (ticksPerSecond != null) {
      buf.append(ticksPerSecond.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -delay to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps delay(Integer ticks, Integer ticksPerSecond, Character special) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-delay");

    if (ticks != null) {
      buf.append(ticks.toString());
    }
    if (ticks != null || ticksPerSecond != null) {
      buf.append("x");
    }
    if (ticksPerSecond != null) {
      buf.append(ticksPerSecond.toString());
    }
    if (ticksPerSecond != null || special != null) {
    }
    if (special != null) {
      buf.append(special.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -density to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps density() {

    iCmdArgs.add("-density");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -density to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps density(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-density");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -density to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps density(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-density");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -depth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps depth() {

    iCmdArgs.add("-depth");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -depth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps depth(Integer value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-depth");

    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -despeckle to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps despeckle() {

    iCmdArgs.add("-despeckle");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -display to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps display() {

    iCmdArgs.add("-display");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -display to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps display(String host) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-display");

    if (host != null) {
      buf.append(host.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -display to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps display(String host, Integer display) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-display");

    if (host != null) {
      buf.append(host.toString());
    }
    if (host != null || display != null) {
      buf.append(":");
    }
    if (display != null) {
      buf.append(display.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -display to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps display(String host, Integer display, Integer screen) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-display");

    if (host != null) {
      buf.append(host.toString());
    }
    if (host != null || display != null) {
      buf.append(":");
    }
    if (display != null) {
      buf.append(display.toString());
    }
    if (display != null || screen != null) {
      buf.append(".");
    }
    if (screen != null) {
      buf.append(screen.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -dispose to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps dispose() {

    iCmdArgs.add("-dispose");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -dispose to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps dispose(String method) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-dispose");

    if (method != null) {
      buf.append(method.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +dither to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_dither() {

    iCmdArgs.add("+dither");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -dither to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps dither() {

    iCmdArgs.add("-dither");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -dither to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps dither(String method) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-dither");

    if (method != null) {
      buf.append(method.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -draw to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps draw() {

    iCmdArgs.add("-draw");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -draw to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps draw(String string) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-draw");

    if (string != null) {
      buf.append(string.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -edge to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps edge() {

    iCmdArgs.add("-edge");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -edge to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps edge(Double radius) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-edge");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -emboss to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps emboss() {

    iCmdArgs.add("-emboss");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -emboss to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps emboss(Double radius) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-emboss");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -encoding to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps encoding() {

    iCmdArgs.add("-encoding");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -encoding to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps encoding(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-encoding");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +endian to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_endian() {

    iCmdArgs.add("+endian");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -endian to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps endian() {

    iCmdArgs.add("-endian");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -endian to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps endian(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-endian");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -enhance to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps enhance() {

    iCmdArgs.add("-enhance");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -equalize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps equalize() {

    iCmdArgs.add("-equalize");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -fill to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps fill() {

    iCmdArgs.add("-fill");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -fill to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps fill(String color) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-fill");

    if (color != null) {
      buf.append(color.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -filter to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps filter() {

    iCmdArgs.add("-filter");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -filter to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps filter(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-filter");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -flatten to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps flatten() {

    iCmdArgs.add("-flatten");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -flip to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps flip() {

    iCmdArgs.add("-flip");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -flop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps flop() {

    iCmdArgs.add("-flop");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -font to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps font() {

    iCmdArgs.add("-font");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -font to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps font(String name) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-font");

    if (name != null) {
      buf.append(name.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -frame to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps frame() {

    iCmdArgs.add("-frame");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -frame to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps frame(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-frame");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -frame to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps frame(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-frame");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -frame to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps frame(Integer width, Integer height, Integer outerBevelWidth) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-frame");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || outerBevelWidth != null) {
      oper="+";
      if (outerBevelWidth.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (outerBevelWidth != null) {
      buf.append(outerBevelWidth.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -frame to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps frame(Integer width, Integer height, Integer outerBevelWidth, Integer innerBevelWidth) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-frame");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || outerBevelWidth != null) {
      oper="+";
      if (outerBevelWidth.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (outerBevelWidth != null) {
      buf.append(outerBevelWidth.toString());
    }
    if (outerBevelWidth != null || innerBevelWidth != null) {
      oper="+";
      if (innerBevelWidth.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (innerBevelWidth != null) {
      buf.append(innerBevelWidth.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +frame to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_frame() {

    iCmdArgs.add("+frame");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -fuzz to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps fuzz() {

    iCmdArgs.add("-fuzz");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -fuzz to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps fuzz(Double distance) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-fuzz");

    if (distance != null) {
      buf.append(distance.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -fuzz to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps fuzz(Double distance, Boolean percent) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-fuzz");

    if (distance != null) {
      buf.append(distance.toString());
    }
    if (distance != null || percent != null) {
    }
    if (percent != null) {
      if (percent.booleanValue())
        buf.append("%");
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -gamma to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps gamma() {

    iCmdArgs.add("-gamma");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -gamma to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps gamma(Double value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-gamma");

    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +gamma to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_gamma() {

    iCmdArgs.add("+gamma");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +gamma to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_gamma(Double value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+gamma");

    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -gaussian to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps gaussian() {

    iCmdArgs.add("-gaussian");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -gaussian to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps gaussian(Double radius) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-gaussian");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -gaussian to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps gaussian(Double radius, Double sigma) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-gaussian");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (radius != null || sigma != null) {
      buf.append("x");
    }
    if (sigma != null) {
      buf.append(sigma.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -geometry to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps geometry() {

    iCmdArgs.add("-geometry");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -geometry to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps geometry(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-geometry");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -geometry to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps geometry(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-geometry");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -geometry to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps geometry(Integer width, Integer height, Integer x) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-geometry");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || x != null) {
      oper="+";
      if (x.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (x != null) {
      buf.append(x.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -geometry to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps geometry(Integer width, Integer height, Integer x, Integer y) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-geometry");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || x != null) {
      oper="+";
      if (x.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (x != null) {
      buf.append(x.toString());
    }
    if (x != null || y != null) {
      oper="+";
      if (y.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (y != null) {
      buf.append(y.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -gravity to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps gravity() {

    iCmdArgs.add("-gravity");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -gravity to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps gravity(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-gravity");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -green-primary to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps greenPrimary() {

    iCmdArgs.add("-green-primary");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -green-primary to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps greenPrimary(Double x) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-green-primary");

    if (x != null) {
      buf.append(x.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -green-primary to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps greenPrimary(Double x, Double y) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-green-primary");

    if (x != null) {
      buf.append(x.toString());
    }
    if (x != null || y != null) {
      buf.append(",");
    }
    if (y != null) {
      buf.append(y.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -help to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps help() {

    iCmdArgs.add("-help");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -implode to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps implode() {

    iCmdArgs.add("-implode");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -implode to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps implode(Double factor) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-implode");

    if (factor != null) {
      buf.append(factor.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -intent to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps intent() {

    iCmdArgs.add("-intent");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -intent to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps intent(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-intent");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -interlace to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps interlace() {

    iCmdArgs.add("-interlace");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -interlace to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps interlace(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-interlace");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +label to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_label() {

    iCmdArgs.add("+label");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -label to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps label() {

    iCmdArgs.add("-label");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -label to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps label(String name) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-label");

    if (name != null) {
      buf.append(name.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -lat to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps lat() {

    iCmdArgs.add("-lat");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -lat to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps lat(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-lat");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -lat to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps lat(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-lat");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -lat to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps lat(Integer width, Integer height, Integer offset) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-lat");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || offset != null) {
      oper="+";
      if (offset.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (offset != null) {
      buf.append(offset.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -lat to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps lat(Integer width, Integer height, Integer offset, Boolean percent) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-lat");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || offset != null) {
      oper="+";
      if (offset.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (offset != null) {
      buf.append(offset.toString());
    }
    if (offset != null || percent != null) {
    }
    if (percent != null) {
      if (percent.booleanValue())
        buf.append("%");
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -level to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps level() {

    iCmdArgs.add("-level");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -level to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps level(Double black_point) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-level");

    if (black_point != null) {
      buf.append(black_point.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -level to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps level(Double black_point, Double white_point) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-level");

    if (black_point != null) {
      buf.append(black_point.toString());
    }
    if (black_point != null || white_point != null) {
      buf.append(",");
    }
    if (white_point != null) {
      buf.append(white_point.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -level to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps level(Double black_point, Double white_point, Boolean percent) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-level");

    if (black_point != null) {
      buf.append(black_point.toString());
    }
    if (black_point != null || white_point != null) {
      buf.append(",");
    }
    if (white_point != null) {
      buf.append(white_point.toString());
    }
    if (white_point != null || percent != null) {
    }
    if (percent != null) {
      if (percent.booleanValue())
        buf.append("%");
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -level to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps level(Double black_point, Double white_point, Boolean percent, Double gamma) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-level");

    if (black_point != null) {
      buf.append(black_point.toString());
    }
    if (black_point != null || white_point != null) {
      buf.append(",");
    }
    if (white_point != null) {
      buf.append(white_point.toString());
    }
    if (white_point != null || percent != null) {
    }
    if (percent != null) {
      if (percent.booleanValue())
        buf.append("%");
    }
    if (percent != null || gamma != null) {
      buf.append(",");
    }
    if (gamma != null) {
      buf.append(gamma.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -limit to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps limit() {

    iCmdArgs.add("-limit");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -limit to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps limit(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-limit");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -list to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps list() {

    iCmdArgs.add("-list");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -list to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps list(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-list");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -log to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps log() {

    iCmdArgs.add("-log");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -log to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps log(String text) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-log");

    if (text != null) {
      buf.append(text.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -loop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps loop() {

    iCmdArgs.add("-loop");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -loop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps loop(Integer iterations) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-loop");

    if (iterations != null) {
      buf.append(iterations.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +map to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_map() {

    iCmdArgs.add("+map");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -map to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps map() {

    iCmdArgs.add("-map");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -map to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps map(String filename) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-map");

    if (filename != null) {
      buf.append(filename.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +mask to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_mask() {

    iCmdArgs.add("+mask");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -mask to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps mask() {

    iCmdArgs.add("-mask");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -mask to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps mask(String filename) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-mask");

    if (filename != null) {
      buf.append(filename.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -matte to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps matte() {

    iCmdArgs.add("-matte");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +matte to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_matte() {

    iCmdArgs.add("+matte");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -median to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps median() {

    iCmdArgs.add("-median");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -median to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps median(Double radius) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-median");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -modulate to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps modulate() {

    iCmdArgs.add("-modulate");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -modulate to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps modulate(Double brightness) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-modulate");

    if (brightness != null) {
      buf.append(brightness.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -modulate to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps modulate(Double brightness, Double saturation) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-modulate");

    if (brightness != null) {
      buf.append(brightness.toString());
    }
    if (brightness != null || saturation != null) {
      buf.append(",");
    }
    if (saturation != null) {
      buf.append(saturation.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -modulate to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps modulate(Double brightness, Double saturation, Double hue) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-modulate");

    if (brightness != null) {
      buf.append(brightness.toString());
    }
    if (brightness != null || saturation != null) {
      buf.append(",");
    }
    if (saturation != null) {
      buf.append(saturation.toString());
    }
    if (saturation != null || hue != null) {
      buf.append(",");
    }
    if (hue != null) {
      buf.append(hue.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -monitor to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps monitor() {

    iCmdArgs.add("-monitor");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -monochrome to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps monochrome() {

    iCmdArgs.add("-monochrome");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -morph to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps morph() {

    iCmdArgs.add("-morph");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -morph to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps morph(Integer frames) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-morph");

    if (frames != null) {
      buf.append(frames.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -mosaic to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps mosaic() {

    iCmdArgs.add("-mosaic");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -motion-blur to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps motionBlur() {

    iCmdArgs.add("-motion-blur");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -motion-blur to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps motionBlur(Double radius) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-motion-blur");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -motion-blur to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps motionBlur(Double radius, Double sigma) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-motion-blur");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (radius != null || sigma != null) {
      buf.append("x");
    }
    if (sigma != null) {
      buf.append(sigma.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -motion-blur to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps motionBlur(Double radius, Double sigma, Double angle) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-motion-blur");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (radius != null || sigma != null) {
      buf.append("x");
    }
    if (sigma != null) {
      buf.append(sigma.toString());
    }
    if (sigma != null || angle != null) {
      oper="+";
      if (angle.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (angle != null) {
      buf.append(angle.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -negate to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps negate() {

    iCmdArgs.add("-negate");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +negate to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_negate() {

    iCmdArgs.add("+negate");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -noise to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps noise() {

    iCmdArgs.add("-noise");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -noise to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps noise(Double radius) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-noise");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +noise to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_noise() {

    iCmdArgs.add("+noise");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +noise to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_noise(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+noise");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -noop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps noop() {

    iCmdArgs.add("-noop");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -normalize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps normalize() {

    iCmdArgs.add("-normalize");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -opaque to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps opaque() {

    iCmdArgs.add("-opaque");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -opaque to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps opaque(String color) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-opaque");

    if (color != null) {
      buf.append(color.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -operator to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps operator() {

    iCmdArgs.add("-operator");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -operator to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps operator(String channel) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-operator");

    if (channel != null) {
      buf.append(channel.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -operator to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps operator(String channel, String operator) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-operator");

    if (channel != null) {
      buf.append(channel.toString());
    }
    if (channel != null || operator != null) {
      iCmdArgs.add(buf.toString());
      buf.setLength(0);
    }
    if (operator != null) {
      buf.append(operator.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -operator to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps operator(String channel, String operator, Double rvalue) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-operator");

    if (channel != null) {
      buf.append(channel.toString());
    }
    if (channel != null || operator != null) {
      iCmdArgs.add(buf.toString());
      buf.setLength(0);
    }
    if (operator != null) {
      buf.append(operator.toString());
    }
    if (operator != null || rvalue != null) {
      iCmdArgs.add(buf.toString());
      buf.setLength(0);
    }
    if (rvalue != null) {
      buf.append(rvalue.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -operator to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps operator(String channel, String operator, Double rvalue, Boolean percent) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-operator");

    if (channel != null) {
      buf.append(channel.toString());
    }
    if (channel != null || operator != null) {
      iCmdArgs.add(buf.toString());
      buf.setLength(0);
    }
    if (operator != null) {
      buf.append(operator.toString());
    }
    if (operator != null || rvalue != null) {
      iCmdArgs.add(buf.toString());
      buf.setLength(0);
    }
    if (rvalue != null) {
      buf.append(rvalue.toString());
    }
    if (rvalue != null || percent != null) {
    }
    if (percent != null) {
      if (percent.booleanValue())
        buf.append("%");
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -ordered-dither to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps orderedDither() {

    iCmdArgs.add("-ordered-dither");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -ordered-dither to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps orderedDither(String channelType) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-ordered-dither");

    if (channelType != null) {
      buf.append(channelType.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -ordered-dither to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps orderedDither(String channelType, Integer N) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-ordered-dither");

    if (channelType != null) {
      buf.append(channelType.toString());
    }
    if (channelType != null || N != null) {
      iCmdArgs.add(buf.toString());
      buf.setLength(0);
    }
    if (N != null) {
      buf.append(N.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -output-directory to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps outputDirectory() {

    iCmdArgs.add("-output-directory");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -output-directory to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps outputDirectory(String pDirectory) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-output-directory");

    if (pDirectory != null) {
      buf.append(pDirectory.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +page to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_page() {

    iCmdArgs.add("+page");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -page to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps page() {

    iCmdArgs.add("-page");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -page to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps page(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-page");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -page to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps page(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-page");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -page to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps page(Integer width, Integer height, Integer x) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-page");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || x != null) {
      oper="+";
      if (x.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (x != null) {
      buf.append(x.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -page to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps page(Integer width, Integer height, Integer x, Integer y) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-page");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || x != null) {
      oper="+";
      if (x.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (x != null) {
      buf.append(x.toString());
    }
    if (x != null || y != null) {
      oper="+";
      if (y.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (y != null) {
      buf.append(y.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -page to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps page(Integer width, Integer height, Integer x, Integer y, Character special) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-page");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || x != null) {
      oper="+";
      if (x.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (x != null) {
      buf.append(x.toString());
    }
    if (x != null || y != null) {
      oper="+";
      if (y.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (y != null) {
      buf.append(y.toString());
    }
    if (y != null || special != null) {
    }
    if (special != null) {
      buf.append(special.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -paint to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps paint() {

    iCmdArgs.add("-paint");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -paint to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps paint(Double radius) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-paint");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -pause to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps pause() {

    iCmdArgs.add("-pause");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -pause to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps pause(Integer pSeconds) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-pause");

    if (pSeconds != null) {
      buf.append(pSeconds.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -pen to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps pen() {

    iCmdArgs.add("-pen");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -pen to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps pen(String pColor) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-pen");

    if (pColor != null) {
      buf.append(pColor.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -ping to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps ping() {

    iCmdArgs.add("-ping");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +ping to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_ping() {

    iCmdArgs.add("+ping");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -pointsize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps pointsize() {

    iCmdArgs.add("-pointsize");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -pointsize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps pointsize(Integer value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-pointsize");

    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -preview to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps preview() {

    iCmdArgs.add("-preview");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -preview to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps preview(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-preview");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -process to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps process() {

    iCmdArgs.add("-process");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -process to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps process(String pCommand) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-process");

    if (pCommand != null) {
      buf.append(pCommand.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -profile to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps profile() {

    iCmdArgs.add("-profile");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -profile to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps profile(String filename) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-profile");

    if (filename != null) {
      buf.append(filename.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +profile to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_profile() {

    iCmdArgs.add("+profile");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +profile to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_profile(String profileName) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+profile");

    if (profileName != null) {
      buf.append(profileName.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +progress to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_progress() {

    iCmdArgs.add("+progress");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -quality to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps quality() {

    iCmdArgs.add("-quality");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -quality to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps quality(Double value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-quality");

    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -raise to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps raise() {

    iCmdArgs.add("-raise");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -raise to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps raise(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-raise");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -raise to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps raise(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-raise");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +raise to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_raise() {

    iCmdArgs.add("+raise");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +raise to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_raise(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+raise");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +raise to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_raise(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+raise");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -random-threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps randomThreshold() {

    iCmdArgs.add("-random-threshold");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -random-threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps randomThreshold(String channelType) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-random-threshold");

    if (channelType != null) {
      buf.append(channelType.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -random-threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps randomThreshold(String channelType, Double low) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-random-threshold");

    if (channelType != null) {
      buf.append(channelType.toString());
    }
    if (channelType != null || low != null) {
      iCmdArgs.add(buf.toString());
      buf.setLength(0);
    }
    if (low != null) {
      buf.append(low.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -random-threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps randomThreshold(String channelType, Double low, Double high) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-random-threshold");

    if (channelType != null) {
      buf.append(channelType.toString());
    }
    if (channelType != null || low != null) {
      iCmdArgs.add(buf.toString());
      buf.setLength(0);
    }
    if (low != null) {
      buf.append(low.toString());
    }
    if (low != null || high != null) {
      buf.append("x");
    }
    if (high != null) {
      buf.append(high.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -red-primary to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps redPrimary() {

    iCmdArgs.add("-red-primary");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -red-primary to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps redPrimary(Double x) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-red-primary");

    if (x != null) {
      buf.append(x.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -red-primary to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps redPrimary(Double x, Double y) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-red-primary");

    if (x != null) {
      buf.append(x.toString());
    }
    if (x != null || y != null) {
      buf.append(",");
    }
    if (y != null) {
      buf.append(y.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -region to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps region() {

    iCmdArgs.add("-region");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -region to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps region(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-region");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -region to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps region(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-region");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -region to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps region(Integer width, Integer height, Integer x) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-region");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || x != null) {
      oper="+";
      if (x.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (x != null) {
      buf.append(x.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -region to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps region(Integer width, Integer height, Integer x, Integer y) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-region");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || x != null) {
      oper="+";
      if (x.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (x != null) {
      buf.append(x.toString());
    }
    if (x != null || y != null) {
      oper="+";
      if (y.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (y != null) {
      buf.append(y.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +remap to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_remap() {

    iCmdArgs.add("+remap");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -render to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps render() {

    iCmdArgs.add("-render");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +render to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_render() {

    iCmdArgs.add("+render");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -resample to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps resample() {

    iCmdArgs.add("-resample");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -resample to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps resample(Integer horizontal) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-resample");

    if (horizontal != null) {
      buf.append(horizontal.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -resample to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps resample(Integer horizontal, Integer vertical) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-resample");

    if (horizontal != null) {
      buf.append(horizontal.toString());
    }
    if (horizontal != null || vertical != null) {
      buf.append("x");
    }
    if (vertical != null) {
      buf.append(vertical.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -resize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps resize() {

    iCmdArgs.add("-resize");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -resize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps resize(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-resize");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -resize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps resize(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-resize");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -resize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps resize(Integer width, Integer height, Character special) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-resize");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || special != null) {
    }
    if (special != null) {
      buf.append(special.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -roll to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps roll() {

    iCmdArgs.add("-roll");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -roll to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps roll(Integer x) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-roll");

    if (x != null) {
      buf.append(x.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -roll to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps roll(Integer x, Integer y) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-roll");

    if (x != null) {
      buf.append(x.toString());
    }
    if (x != null || y != null) {
      oper="+";
      if (y.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (y != null) {
      buf.append(y.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -rotate to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps rotate() {

    iCmdArgs.add("-rotate");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -rotate to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps rotate(Double degrees) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-rotate");

    if (degrees != null) {
      buf.append(degrees.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -rotate to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps rotate(Double degrees, Character special) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-rotate");

    if (degrees != null) {
      buf.append(degrees.toString());
    }
    if (degrees != null || special != null) {
    }
    if (special != null) {
      buf.append(special.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -sample to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps sample() {

    iCmdArgs.add("-sample");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -sample to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps sample(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-sample");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -sample to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps sample(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-sample");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -sample to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps sample(Integer width, Integer height, Integer xOffset) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-sample");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || xOffset != null) {
      oper="+";
      if (xOffset.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (xOffset != null) {
      buf.append(xOffset.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -sample to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps sample(Integer width, Integer height, Integer xOffset, Integer yOffset) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-sample");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || xOffset != null) {
      oper="+";
      if (xOffset.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (xOffset != null) {
      buf.append(xOffset.toString());
    }
    if (xOffset != null || yOffset != null) {
      oper="+";
      if (yOffset.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (yOffset != null) {
      buf.append(yOffset.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -sampling-factor to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps samplingFactor() {

    iCmdArgs.add("-sampling-factor");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -sampling-factor to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps samplingFactor(Double horizontalFactor) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-sampling-factor");

    if (horizontalFactor != null) {
      buf.append(horizontalFactor.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -sampling-factor to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps samplingFactor(Double horizontalFactor, Double verticalFactor) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-sampling-factor");

    if (horizontalFactor != null) {
      buf.append(horizontalFactor.toString());
    }
    if (horizontalFactor != null || verticalFactor != null) {
      buf.append("x");
    }
    if (verticalFactor != null) {
      buf.append(verticalFactor.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -scale to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps scale() {

    iCmdArgs.add("-scale");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -scale to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps scale(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-scale");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -scale to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps scale(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-scale");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -scale to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps scale(Integer width, Integer height, Integer xOffset) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-scale");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || xOffset != null) {
      oper="+";
      if (xOffset.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (xOffset != null) {
      buf.append(xOffset.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -scale to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps scale(Integer width, Integer height, Integer xOffset, Integer yOffset) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-scale");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || xOffset != null) {
      oper="+";
      if (xOffset.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (xOffset != null) {
      buf.append(xOffset.toString());
    }
    if (xOffset != null || yOffset != null) {
      oper="+";
      if (yOffset.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (yOffset != null) {
      buf.append(yOffset.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -scene to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps scene() {

    iCmdArgs.add("-scene");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -scene to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps scene(Integer value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-scene");

    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -seed to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps seed() {

    iCmdArgs.add("-seed");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -segment to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps segment() {

    iCmdArgs.add("-segment");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -segment to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps segment(Integer clusterThreshold) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-segment");

    if (clusterThreshold != null) {
      buf.append(clusterThreshold.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -segment to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps segment(Integer clusterThreshold, Double smoothingThreshold) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-segment");

    if (clusterThreshold != null) {
      buf.append(clusterThreshold.toString());
    }
    if (clusterThreshold != null || smoothingThreshold != null) {
      buf.append("x");
    }
    if (smoothingThreshold != null) {
      buf.append(smoothingThreshold.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -set to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps set() {

    iCmdArgs.add("-set");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -set to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps set(String attribute) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-set");

    if (attribute != null) {
      buf.append(attribute.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -set to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps set(String attribute, String value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-set");

    if (attribute != null) {
      buf.append(attribute.toString());
    }
    if (attribute != null || value != null) {
      iCmdArgs.add(buf.toString());
      buf.setLength(0);
    }
    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -shade to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps shade() {

    iCmdArgs.add("-shade");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -shade to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps shade(Double azimuth) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-shade");

    if (azimuth != null) {
      buf.append(azimuth.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -shade to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps shade(Double azimuth, Double elevation) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-shade");

    if (azimuth != null) {
      buf.append(azimuth.toString());
    }
    if (azimuth != null || elevation != null) {
      buf.append("x");
    }
    if (elevation != null) {
      buf.append(elevation.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +shade to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_shade() {

    iCmdArgs.add("+shade");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +shade to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_shade(Double azimuth) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+shade");

    if (azimuth != null) {
      buf.append(azimuth.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +shade to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_shade(Double azimuth, Double elevation) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+shade");

    if (azimuth != null) {
      buf.append(azimuth.toString());
    }
    if (azimuth != null || elevation != null) {
      buf.append("x");
    }
    if (elevation != null) {
      buf.append(elevation.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -sharpen to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps sharpen() {

    iCmdArgs.add("-sharpen");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -sharpen to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps sharpen(Double radius) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-sharpen");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -sharpen to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps sharpen(Double radius, Double sigma) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-sharpen");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (radius != null || sigma != null) {
      buf.append("x");
    }
    if (sigma != null) {
      buf.append(sigma.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -shave to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps shave() {

    iCmdArgs.add("-shave");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -shave to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps shave(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-shave");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -shave to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps shave(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-shave");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -shave to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps shave(Integer width, Integer height, Boolean percent) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-shave");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || percent != null) {
    }
    if (percent != null) {
      if (percent.booleanValue())
        buf.append("%");
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -shear to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps shear() {

    iCmdArgs.add("-shear");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -shear to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps shear(Double xDegrees) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-shear");

    if (xDegrees != null) {
      buf.append(xDegrees.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -shear to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps shear(Double xDegrees, Double yDegrees) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-shear");

    if (xDegrees != null) {
      buf.append(xDegrees.toString());
    }
    if (xDegrees != null || yDegrees != null) {
      buf.append("x");
    }
    if (yDegrees != null) {
      buf.append(yDegrees.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -size to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps size() {

    iCmdArgs.add("-size");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -size to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps size(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-size");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -size to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps size(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-size");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -size to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps size(Integer width, Integer height, Integer offset) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-size");

    if (width != null) {
      buf.append(width.toString());
    }
    if (width != null || height != null) {
      buf.append("x");
    }
    if (height != null) {
      buf.append(height.toString());
    }
    if (height != null || offset != null) {
      oper="+";
      if (offset.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (offset != null) {
      buf.append(offset.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -solarize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps solarize() {

    iCmdArgs.add("-solarize");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -solarize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps solarize(Double threshold) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-solarize");

    if (threshold != null) {
      buf.append(threshold.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -spread to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps spread() {

    iCmdArgs.add("-spread");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -spread to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps spread(Integer amount) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-spread");

    if (amount != null) {
      buf.append(amount.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -stroke to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps stroke() {

    iCmdArgs.add("-stroke");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -stroke to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps stroke(String color) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-stroke");

    if (color != null) {
      buf.append(color.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -strokewidth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps strokewidth() {

    iCmdArgs.add("-strokewidth");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -strokewidth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps strokewidth(Integer value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-strokewidth");

    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -swirl to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps swirl() {

    iCmdArgs.add("-swirl");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -swirl to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps swirl(Double degrees) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-swirl");

    if (degrees != null) {
      buf.append(degrees.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -texture to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps texture() {

    iCmdArgs.add("-texture");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -texture to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps texture(String filename) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-texture");

    if (filename != null) {
      buf.append(filename.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps threshold() {

    iCmdArgs.add("-threshold");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps threshold(Integer value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-threshold");

    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps threshold(Integer value, Boolean percent) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-threshold");

    if (value != null) {
      buf.append(value.toString());
    }
    if (value != null || percent != null) {
    }
    if (percent != null) {
      if (percent.booleanValue())
        buf.append("%");
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -tile to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps tile() {

    iCmdArgs.add("-tile");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -tile to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps tile(String filename) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-tile");

    if (filename != null) {
      buf.append(filename.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -transform to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps transform() {

    iCmdArgs.add("-transform");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -transparent to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps transparent() {

    iCmdArgs.add("-transparent");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -transparent to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps transparent(String color) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-transparent");

    if (color != null) {
      buf.append(color.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -treedepth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps treedepth() {

    iCmdArgs.add("-treedepth");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -treedepth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps treedepth(Integer value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-treedepth");

    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -trim to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps trim() {

    iCmdArgs.add("-trim");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -type to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps type() {

    iCmdArgs.add("-type");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -type to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps type(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-type");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -undercolor to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps undercolor() {

    iCmdArgs.add("-undercolor");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -undercolor to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps undercolor(String color) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-undercolor");

    if (color != null) {
      buf.append(color.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -units to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps units() {

    iCmdArgs.add("-units");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -units to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps units(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-units");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -unsharp to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps unsharp() {

    iCmdArgs.add("-unsharp");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -unsharp to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps unsharp(Double radius) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-unsharp");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -unsharp to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps unsharp(Double radius, Double sigma) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-unsharp");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (radius != null || sigma != null) {
      buf.append("x");
    }
    if (sigma != null) {
      buf.append(sigma.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -unsharp to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps unsharp(Double radius, Double sigma, Double amount) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-unsharp");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (radius != null || sigma != null) {
      buf.append("x");
    }
    if (sigma != null) {
      buf.append(sigma.toString());
    }
    if (sigma != null || amount != null) {
      oper="+";
      if (amount.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (amount != null) {
      buf.append(amount.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -unsharp to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps unsharp(Double radius, Double sigma, Double amount, Double threshold) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-unsharp");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (radius != null || sigma != null) {
      buf.append("x");
    }
    if (sigma != null) {
      buf.append(sigma.toString());
    }
    if (sigma != null || amount != null) {
      oper="+";
      if (amount.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (amount != null) {
      buf.append(amount.toString());
    }
    if (amount != null || threshold != null) {
      oper="+";
      if (threshold.doubleValue() < 0)
        oper="";
      buf.append(oper);
    }
    if (threshold != null) {
      buf.append(threshold.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -verbose to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps verbose() {

    iCmdArgs.add("-verbose");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -version to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps version() {

    iCmdArgs.add("-version");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -view to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps view() {

    iCmdArgs.add("-view");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -view to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps view(String text) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-view");

    if (text != null) {
      buf.append(text.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -virtual-pixel to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps virtualPixel() {

    iCmdArgs.add("-virtual-pixel");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -virtual-pixel to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps virtualPixel(String method) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-virtual-pixel");

    if (method != null) {
      buf.append(method.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -wave to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps wave() {

    iCmdArgs.add("-wave");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -wave to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps wave(Double amplitude) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-wave");

    if (amplitude != null) {
      buf.append(amplitude.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -wave to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps wave(Double amplitude, Double wavelength) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-wave");

    if (amplitude != null) {
      buf.append(amplitude.toString());
    }
    if (amplitude != null || wavelength != null) {
      buf.append("x");
    }
    if (wavelength != null) {
      buf.append(wavelength.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -white-point to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps whitePoint() {

    iCmdArgs.add("-white-point");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -white-point to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps whitePoint(Double x) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-white-point");

    if (x != null) {
      buf.append(x.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -white-point to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps whitePoint(Double x, Double y) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-white-point");

    if (x != null) {
      buf.append(x.toString());
    }
    if (x != null || y != null) {
      buf.append(",");
    }
    if (y != null) {
      buf.append(y.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -white-threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps whiteThreshold() {

    iCmdArgs.add("-white-threshold");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -white-threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps whiteThreshold(Double threshold) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-white-threshold");

    if (threshold != null) {
      buf.append(threshold.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -white-threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps whiteThreshold(Double threshold, Boolean percent) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-white-threshold");

    if (threshold != null) {
      buf.append(threshold.toString());
    }
    if (threshold != null || percent != null) {
    }
    if (percent != null) {
      if (percent.booleanValue())
        buf.append("%");
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -write to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps write() {

    iCmdArgs.add("-write");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -write to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps write(String filename) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-write");

    if (filename != null) {
      buf.append(filename.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +write to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_write() {

    iCmdArgs.add("+write");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +write to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_write(String filename) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+write");

    if (filename != null) {
      buf.append(filename.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }


}
