/**************************************************************************
/* This class adds all the ET methods to an Operation.
/*
/* Copyright (c) 2009 by Bernhard Bablok (mail@bablokb.de)
/*
/* This program is free software; you can redistribute it and/or modify
/* it under the terms of the GNU Library General Public License as published
/* by  the Free Software Foundation; either version 2 of the License or
/* (at your option) any later version.
/*
/* This program is distributed in the hope that it will be useful, but
/* WITHOUT ANY WARRANTY; without even the implied warranty of
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/* GNU Library General Public License for more details.
/*
/* You should have received a copy of the GNU Library General Public License
/* along with this program; see the file COPYING.LIB.  If not, write to
/* the Free Software Foundation Inc., 59 Temple Place - Suite 330,
/* Boston, MA  02111-1307 USA
/**************************************************************************/

package org.im4java.core;

/**
   This class subclasses Operation and adds methods for all commandline
   options of exiftool.

   <p>This class is automatically generated by the source-code generator of
   im4java.</p>

   @version $Revision: 1.14 $
   @author  $Author: bablokb $
*/

public class ETOps extends Operation {

  //////////////////////////////////////////////////////////////////////////////

  /**
     The protected Constructor. You should only use subclasses of ETOps.
  */

  protected ETOps() {
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -@ to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps readArguments(String pFilename) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-@");

    if (pFilename != null) {
      buf.append(pFilename.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -duplicates to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps allowDuplicates() {

    iCmdArgs.add("-duplicates");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option --duplicates to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps supressDuplicates() {

    iCmdArgs.add("--duplicates");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -binary to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps binary() {

    iCmdArgs.add("-binary");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -coordFormat to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps coordFormat(String pFormat) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-coordFormat");

    if (pFormat != null) {
      buf.append(pFormat.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -dateFormat to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps dateFormat(String pFormat) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-dateFormat");

    if (pFormat != null) {
      buf.append(pFormat.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -decimal to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps decimal() {

    iCmdArgs.add("-decimal");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option --composite to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps composite() {

    iCmdArgs.add("--composite");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -escapeHTML to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps escapeHTML() {

    iCmdArgs.add("-escapeHTML");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -extractEmbedded to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps extractEmbedded() {

    iCmdArgs.add("-extractEmbedded");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -extension to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps extension(String pExtension) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-extension");

    if (pExtension != null) {
      buf.append(pExtension.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option --extension to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps ignoreExtension(String pExtension) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("--extension");

    if (pExtension != null) {
      buf.append(pExtension.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -forcePrint to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps forcePrint() {

    iCmdArgs.add("-forcePrint");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -fixBase to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps fixBase(Integer pOffset) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-fixBase");

    if (pOffset != null) {
      buf.append(pOffset.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -fast to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps fast() {

    iCmdArgs.add("-fast");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -groupHeadings to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps groupHeadings(String pHeadings) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    buf.append("-groupHeadings");

    if (pHeadings != null) {
      buf.append(pHeadings.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -groupNames to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps groupNames(String pHeadings) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    buf.append("-groupNames");

    if (pHeadings != null) {
      buf.append(pHeadings.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -htmlFormat to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps htmlFormat() {

    iCmdArgs.add("-htmlFormat");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -hex to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps hex() {

    iCmdArgs.add("-hex");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -htmlDump to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps htmlDump(String pOffset) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    buf.append("-htmlDump");

    if (pOffset != null) {
      buf.append(pOffset.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -ignore to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps ignore(String pDirectory) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-ignore");

    if (pDirectory != null) {
      buf.append(pDirectory.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -if to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps ifCondition(String pExpression) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-if");

    if (pExpression != null) {
      buf.append(pExpression.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -json to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps json() {

    iCmdArgs.add("-json");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -pause to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps pause() {

    iCmdArgs.add("-pause");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -long to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps longOutputFormat() {

    iCmdArgs.add("-long");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -latin to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps latin() {

    iCmdArgs.add("-latin");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -list to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps list() {

    iCmdArgs.add("-list");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -listw to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps listw() {

    iCmdArgs.add("-listw");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -listf to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps listf() {

    iCmdArgs.add("-listf");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -listwf to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps listwf() {

    iCmdArgs.add("-listwf");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -listg to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps listg() {

    iCmdArgs.add("-listg");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -listd to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps listd(String pType) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-listd");

    if (pType != null) {
      buf.append(pType.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -ignoreMinorErrors to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps ignoreMinorErrors() {

    iCmdArgs.add("-ignoreMinorErrors");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -n to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps noPrintConv() {

    iCmdArgs.add("-n");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option --printConv to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps printConv() {

    iCmdArgs.add("--printConv");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -out to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps out(String pFile) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-out");

    if (pFile != null) {
      buf.append(pFile.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -overwrite_original to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps overwrite_original() {

    iCmdArgs.add("-overwrite_original");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -overwrite_original_in_place to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps overwrite_original_in_place() {

    iCmdArgs.add("-overwrite_original_in_place");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -printFormat to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps printFormat(String pFormat) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-printFormat");

    if (pFormat != null) {
      buf.append(pFormat.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -preserve to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps preserve() {

    iCmdArgs.add("-preserve");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -quiet to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps quiet() {

    iCmdArgs.add("-quiet");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -recurse to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps recurse() {

    iCmdArgs.add("-recurse");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -short to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps shortOutputFormat() {

    iCmdArgs.add("-short");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -veryShort to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps veryShortOutputFormat() {

    iCmdArgs.add("-veryShort");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -scanForXMP to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps scanForXMP() {

    iCmdArgs.add("-scanForXMP");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -separator to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps separator(String pSeparator) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-separator");

    if (pSeparator != null) {
      buf.append(pSeparator.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -tab to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps tab() {

    iCmdArgs.add("-tab");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -table to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps table() {

    iCmdArgs.add("-table");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -tagsFromFile to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps tagsFromFile(String pSrcFile) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-tagsFromFile");

    if (pSrcFile != null) {
      buf.append(pSrcFile.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -unknown to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps unknown() {

    iCmdArgs.add("-unknown");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -unknown2 to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps unknown2() {

    iCmdArgs.add("-unknown2");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -verbose to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps verbose() {

    iCmdArgs.add("-verbose");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -ver to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps ver() {

    iCmdArgs.add("-ver");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -textOut to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps textOut(String pOutspec) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-textOut");

    if (pOutspec != null) {
      buf.append(pOutspec.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -exclude to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps exclude(String pTagName) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-exclude");

    if (pTagName != null) {
      buf.append(pTagName.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -xmlFormat to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps xmlFormat() {

    iCmdArgs.add("-xmlFormat");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -zip to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps zip() {

    iCmdArgs.add("-zip");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -common_args to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps common_args() {

    iCmdArgs.add("-common_args");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -execute to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps execute() {

    iCmdArgs.add("-execute");

    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -srcfile to the exiftool commandline
     (see the documentation of exiftool for details).
  */

  public ETOps srcfile(String pFormat) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-srcfile");

    if (pFormat != null) {
      buf.append(pFormat.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }


}
