complete -c mbake -f

# Main commands
complete -c mbake -n "__fish_use_subcommand" -a format -d 
"Format Makefiles according to style rules"
complete -c mbake -n "__fish_use_subcommand" -a validate 
-d "Validate Makefile syntax using GNU make"
complete -c mbake -n "__fish_use_subcommand" -a init -d 
"Initialize configuration file with defaults"
complete -c mbake -n "__fish_use_subcommand" -a config -d 
"Show current configuration"
complete -c mbake -n "__fish_use_subcommand" -a update -d 
"Update mbake to the latest version"
complete -c mbake -n "__fish_use_subcommand" -a 
completions -d "Generate shell completion scripts"

# Global options
complete -c mbake -n "__fish_use_subcommand" -l version -d
"Show version and exit"
complete -c mbake -n "__fish_use_subcommand" -l help -d 
"Show help message and exit"

# Format command options
complete -c mbake -n "__fish_seen_subcommand_from format" 
-l check -d "Check formatting rules without making 
changes"
complete -c mbake -n "__fish_seen_subcommand_from format" 
-l diff -d "Show diff of changes that would be made"
complete -c mbake -n "__fish_seen_subcommand_from format" 
-l backup -d "Create backup files before formatting"
complete -c mbake -n "__fish_seen_subcommand_from format" 
-l validate -d "Validate syntax after formatting"
complete -c mbake -n "__fish_seen_subcommand_from format" 
-l verbose -d "Enable verbose output"
complete -c mbake -n "__fish_seen_subcommand_from format" 
-l config -d "Path to configuration file"
complete -c mbake -n "__fish_seen_subcommand_from format" 
-l stdin -d "Read from stdin and write to stdout"

# Validate command options
complete -c mbake -n "__fish_seen_subcommand_from 
validate" -l verbose -d "Enable verbose output"
complete -c mbake -n "__fish_seen_subcommand_from 
validate" -l config -d "Path to configuration file"

# Completions command options
complete -c mbake -n "__fish_seen_subcommand_from 
completions" -a "bash" -d "Generate Bash completion 
script"
complete -c mbake -n "__fish_seen_subcommand_from 
completions" -a "zsh" -d "Generate Zsh completion script"
complete -c mbake -n "__fish_seen_subcommand_from 
completions" -a "fish" -d "Generate Fish completion 
script"
