# SPDX-FileCopyrightText: © 2020 Caleb Maclennan <caleb@alerque.com>
# SPDX-License-Identifier: GPL-3.0-only

# Mix output messages from parallel targets, will be collated by CLI
MAKEFLAGS += --output-sync=none
# Default to not echoing commands before running
MAKEFLAGS += --silent
# Disable as many built in file type builds as possible
MAKEFLAGS += --no-builtin-rules
# Avoid silent errors to ease debugging
MAKEFLAGS += --warn-undefined-variables

.SUFFIXES:

# Don't drop intermediate artifacts (saves rebuild time and aids debugging)
.SECONDARY:
.PRECIOUS: %
.DELETE_ON_ERROR:

# Deprecate direct usage under `make` without the CLI
ifeq ($(FONTSHIP_CLI),)
$(error Use of fontship rule file inclusion outside of the CLI is deprecated!)
endif

# Run complete recipes in wrapper script that facilitates clean CLI output
SHELL := $(FONTSHIPDIR)/lib/make-shell.zsh

.SHELLFLAGS = -w

DEBUG ?= false # also later set in rules.mk just to be visible with other settings
ifeq ($(DEBUG),true)
.SHELLFLAGS += -x
endif

# We *must* pass at least one argument to our custom shell before make adds the
# shell code it wants to execute. We use this one because its easy to falsify
# in our $(shell) wrapper environment...
.SHELLFLAGS += _WRAPTARGET=true

# Differentiate shells used to run recipes vs. shell wrapper function
# See https://stackoverflow.com/q/65553367/313192
_ENV := _WRAPTARGET=false

.SHELLFLAGS += $(eval @?=)$(and $@,target=$@)
.ONESHELL:
.SECONDEXPANSION:

# Use paths discovered by autoconf by default, but allow projects to override
# with paths of their own.
CMP ?= /usr/bin/cmp
FONTMAKE ?= /usr/bin/fontmake
FONTV ?= /usr/bin/font-v
GFTOOLS ?= /usr/bin/gftools
FIND ?= /usr/bin/find
GIT ?= /usr/bin/git
GREP ?= /usr/bin/grep
PSAUTOHINT ?= /usr/bin/psautohint
PYTHON ?= /usr/bin/python
SED ?= /usr/bin/sed
SFDNORMALIZE ?= /usr/bin/sfdnormalize
SFD2UFO ?= /usr/bin/sfd2ufo
SFNT2WOFF ?= /usr/bin/sfnt2woff-zopfli
TTFAUTOHINT ?= /usr/bin/ttfautohint
TTX ?= /usr/bin/ttx
UFONORMALIZER ?= /usr/bin/ufonormalizer
WOFF2COMPRESS ?= /usr/bin/woff2_compress
ZSH ?= /usr/bin/zsh

.PHONY: default
default: all

NORMALIZE_MODE ?=

include $(FONTSHIPDIR)/rules/functions.mk
