# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_fontship_global_optspecs
	string join \n d/debug l/language= p/passthrough P/project= q/quiet v/verbose h/help
end

function __fish_fontship_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_fontship_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_fontship_using_subcommand
	set -l cmd (__fish_fontship_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c fontship -n "__fish_fontship_needs_command" -s l -l language -d 'Set language' -r
complete -c fontship -n "__fish_fontship_needs_command" -s P -l project -d 'Set project root path' -r -f -a "(__fish_complete_directories)"
complete -c fontship -n "__fish_fontship_needs_command" -s d -l debug -d 'Enable extra debug output from tooling'
complete -c fontship -n "__fish_fontship_needs_command" -s p -l passthrough -d 'Eschew all UI output and just pass the subprocess output through'
complete -c fontship -n "__fish_fontship_needs_command" -s q -l quiet -d 'Discard all non-error output messages'
complete -c fontship -n "__fish_fontship_needs_command" -s v -l verbose -d 'Enable extra verbose output from tooling'
complete -c fontship -n "__fish_fontship_needs_command" -s h -l help -d 'Print help'
complete -c fontship -n "__fish_fontship_needs_command" -f -a "make" -d 'Build specified target(s) with ‘make’'
complete -c fontship -n "__fish_fontship_needs_command" -f -a "setup" -d 'Configure a font project repository'
complete -c fontship -n "__fish_fontship_needs_command" -f -a "status" -d 'Show status information about setup, configuration, and build state'
complete -c fontship -n "__fish_fontship_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c fontship -n "__fish_fontship_using_subcommand make" -s h -l help -d 'Print help'
complete -c fontship -n "__fish_fontship_using_subcommand setup" -s h -l help -d 'Print help'
complete -c fontship -n "__fish_fontship_using_subcommand status" -s h -l help -d 'Print help'
complete -c fontship -n "__fish_fontship_using_subcommand help; and not __fish_seen_subcommand_from make setup status help" -f -a "make" -d 'Build specified target(s) with ‘make’'
complete -c fontship -n "__fish_fontship_using_subcommand help; and not __fish_seen_subcommand_from make setup status help" -f -a "setup" -d 'Configure a font project repository'
complete -c fontship -n "__fish_fontship_using_subcommand help; and not __fish_seen_subcommand_from make setup status help" -f -a "status" -d 'Show status information about setup, configuration, and build state'
complete -c fontship -n "__fish_fontship_using_subcommand help; and not __fish_seen_subcommand_from make setup status help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
