.pragma library

function percentToUnit(v) {
    if (v === undefined || v === null) return undefined;
    return v > 1 ? v / 100 : v;
}

var SPEC = {
    currentThemeName: { def: "purple", onChange: "applyStoredTheme" },
    currentThemeCategory: { def: "generic" },
    customThemeFile: { def: "" },
    registryThemeVariants: { def: {} },
    matugenScheme: { def: "scheme-tonal-spot", onChange: "regenSystemThemes" },
    runUserMatugenTemplates: { def: true, onChange: "regenSystemThemes" },
    matugenTargetMonitor: { def: "", onChange: "regenSystemThemes" },

    popupTransparency: { def: 1.0, coerce: percentToUnit },
    dockTransparency: { def: 1.0, coerce: percentToUnit },

    widgetBackgroundColor: { def: "sch" },
    widgetColorMode: { def: "default" },
    cornerRadius: { def: 12, onChange: "updateCompositorLayout" },
    niriLayoutGapsOverride: { def: -1, onChange: "updateCompositorLayout" },
    niriLayoutRadiusOverride: { def: -1, onChange: "updateCompositorLayout" },
    niriLayoutBorderSize: { def: -1, onChange: "updateCompositorLayout" },
    hyprlandLayoutGapsOverride: { def: -1, onChange: "updateCompositorLayout" },
    hyprlandLayoutRadiusOverride: { def: -1, onChange: "updateCompositorLayout" },
    hyprlandLayoutBorderSize: { def: -1, onChange: "updateCompositorLayout" },
    mangoLayoutGapsOverride: { def: -1, onChange: "updateCompositorLayout" },
    mangoLayoutRadiusOverride: { def: -1, onChange: "updateCompositorLayout" },
    mangoLayoutBorderSize: { def: -1, onChange: "updateCompositorLayout" },

    use24HourClock: { def: true },
    showSeconds: { def: false },
    useFahrenheit: { def: false },
    nightModeEnabled: { def: false },
    animationSpeed: { def: 1 },
    customAnimationDuration: { def: 500 },
    wallpaperFillMode: { def: "Fill" },
    blurredWallpaperLayer: { def: false },
    blurWallpaperOnOverview: { def: false },

    showLauncherButton: { def: true },
    showWorkspaceSwitcher: { def: true },
    showFocusedWindow: { def: true },
    showWeather: { def: true },
    showMusic: { def: true },
    showClipboard: { def: true },
    showCpuUsage: { def: true },
    showMemUsage: { def: true },
    showCpuTemp: { def: true },
    showGpuTemp: { def: true },
    selectedGpuIndex: { def: 0 },
    enabledGpuPciIds: { def: [] },
    showSystemTray: { def: true },
    showClock: { def: true },
    showNotificationButton: { def: true },
    showBattery: { def: true },
    showControlCenterButton: { def: true },
    showCapsLockIndicator: { def: true },

    controlCenterShowNetworkIcon: { def: true },
    controlCenterShowBluetoothIcon: { def: true },
    controlCenterShowAudioIcon: { def: true },
    controlCenterShowAudioPercent: { def: false },
    controlCenterShowVpnIcon: { def: true },
    controlCenterShowBrightnessIcon: { def: false },
    controlCenterShowBrightnessPercent: { def: false },
    controlCenterShowMicIcon: { def: false },
    controlCenterShowMicPercent: { def: false },
    controlCenterShowBatteryIcon: { def: false },
    controlCenterShowPrinterIcon: { def: false },
    controlCenterShowScreenSharingIcon: { def: true },

    showPrivacyButton: { def: true },
    privacyShowMicIcon: { def: false },
    privacyShowCameraIcon: { def: false },
    privacyShowScreenShareIcon: { def: false },

    controlCenterWidgets: { def: [
        { id: "volumeSlider", enabled: true, width: 50 },
        { id: "brightnessSlider", enabled: true, width: 50 },
        { id: "wifi", enabled: true, width: 50 },
        { id: "bluetooth", enabled: true, width: 50 },
        { id: "audioOutput", enabled: true, width: 50 },
        { id: "audioInput", enabled: true, width: 50 },
        { id: "nightMode", enabled: true, width: 50 },
        { id: "darkMode", enabled: true, width: 50 }
    ]},

    showWorkspaceIndex: { def: false },
    showWorkspaceName: { def: false },
    showWorkspacePadding: { def: false },
    workspaceScrolling: { def: false },
    showWorkspaceApps: { def: false },
    maxWorkspaceIcons: { def: 3 },
    groupWorkspaceApps: { def: true },
    workspaceFollowFocus: { def: false },
    showOccupiedWorkspacesOnly: { def: false },
    reverseScrolling: { def: false },
    dwlShowAllTags: { def: false },
    workspaceColorMode: { def: "default" },
    workspaceUnfocusedColorMode: { def: "default" },
    workspaceUrgentColorMode: { def: "default" },
    workspaceFocusedBorderEnabled: { def: false },
    workspaceFocusedBorderColor: { def: "primary" },
    workspaceFocusedBorderThickness: { def: 2 },
    workspaceNameIcons: { def: {} },
    waveProgressEnabled: { def: true },
    scrollTitleEnabled: { def: true },
    audioVisualizerEnabled: { def: true },
    audioScrollMode: { def: "volume" },
    clockCompactMode: { def: false },
    focusedWindowCompactMode: { def: false },
    runningAppsCompactMode: { def: true },
    keyboardLayoutNameCompactMode: { def: false },
    runningAppsCurrentWorkspace: { def: false },
    runningAppsGroupByApp: { def: false },
    appIdSubstitutions: { def: [
        { pattern: "Spotify", replacement: "spotify", type: "exact" },
        { pattern: "beepertexts", replacement: "beeper", type: "exact" },
        { pattern: "home assistant desktop", replacement: "homeassistant-desktop", type: "exact" },
        { pattern: "com.transmissionbt.transmission", replacement: "transmission-gtk", type: "contains" },
        { pattern: "^steam_app_(\\d+)$", replacement: "steam_icon_$1", type: "regex" }
    ]},
    centeringMode: { def: "index" },
    clockDateFormat: { def: "" },
    lockDateFormat: { def: "" },
    mediaSize: { def: 1 },

    appLauncherViewMode: { def: "list" },
    spotlightModalViewMode: { def: "list" },
    sortAppsAlphabetically: { def: false },
    appLauncherGridColumns: { def: 4 },
    spotlightCloseNiriOverview: { def: true },
    niriOverviewOverlayEnabled: { def: true },

    useAutoLocation: { def: false },
    weatherEnabled: { def: true },

    networkPreference: { def: "auto" },
    vpnLastConnected: { def: "" },

    iconTheme: { def: "System Default", onChange: "applyStoredIconTheme" },
    availableIconThemes: { def: ["System Default"], persist: false },
    systemDefaultIconTheme: { def: "", persist: false },
    qt5ctAvailable: { def: false, persist: false },
    qt6ctAvailable: { def: false, persist: false },
    gtkAvailable: { def: false, persist: false },

    cursorSettings: { def: { theme: "System Default", size: 24, niri: { hideWhenTyping: false, hideAfterInactiveMs: 0 }, hyprland: { hideOnKeyPress: false, hideOnTouch: false, inactiveTimeout: 0 }, dwl: { cursorHideTimeout: 0 } }, onChange: "updateCompositorCursor" },
    availableCursorThemes: { def: ["System Default"], persist: false },
    systemDefaultCursorTheme: { def: "", persist: false },

    launcherLogoMode: { def: "apps" },
    launcherLogoCustomPath: { def: "" },
    launcherLogoColorOverride: { def: "" },
    launcherLogoColorInvertOnMode: { def: false },
    launcherLogoBrightness: { def: 0.5 },
    launcherLogoContrast: { def: 1 },
    launcherLogoSizeOffset: { def: 0 },

    fontFamily: { def: "Inter Variable" },
    monoFontFamily: { def: "Fira Code" },
    fontWeight: { def: 400 },
    fontScale: { def: 1.0 },

    notepadUseMonospace: { def: true },
    notepadFontFamily: { def: "" },
    notepadFontSize: { def: 14 },
    notepadShowLineNumbers: { def: false },
    notepadTransparencyOverride: { def: -1 },
    notepadLastCustomTransparency: { def: 0.7 },

    soundsEnabled: { def: true },
    useSystemSoundTheme: { def: false },
    soundNewNotification: { def: true },
    soundVolumeChanged: { def: true },
    soundPluggedIn: { def: true },

    acMonitorTimeout: { def: 0 },
    acLockTimeout: { def: 0 },
    acSuspendTimeout: { def: 0 },
    acSuspendBehavior: { def: 0 },
    acProfileName: { def: "" },
    batteryMonitorTimeout: { def: 0 },
    batteryLockTimeout: { def: 0 },
    batterySuspendTimeout: { def: 0 },
    batterySuspendBehavior: { def: 0 },
    batteryProfileName: { def: "" },
    batteryChargeLimit: { def: 100 },
    lockBeforeSuspend: { def: false },
    loginctlLockIntegration: { def: true },
    fadeToLockEnabled: { def: true },
    fadeToLockGracePeriod: { def: 5 },
    fadeToDpmsEnabled: { def: true },
    fadeToDpmsGracePeriod: { def: 5 },
    launchPrefix: { def: "" },
    brightnessDevicePins: { def: {} },
    wifiNetworkPins: { def: {} },
    bluetoothDevicePins: { def: {} },
    audioInputDevicePins: { def: {} },
    audioOutputDevicePins: { def: {} },

    gtkThemingEnabled: { def: false, onChange: "regenSystemThemes" },
    qtThemingEnabled: { def: false, onChange: "regenSystemThemes" },
    syncModeWithPortal: { def: true },
    terminalsAlwaysDark: { def: false, onChange: "regenSystemThemes" },

    runDmsMatugenTemplates: { def: true },
    matugenTemplateGtk: { def: true },
    matugenTemplateNiri: { def: true },
    matugenTemplateHyprland: { def: true },
    matugenTemplateMangowc: { def: true },
    matugenTemplateQt5ct: { def: true },
    matugenTemplateQt6ct: { def: true },
    matugenTemplateFirefox: { def: true },
    matugenTemplatePywalfox: { def: true },
    matugenTemplateZenBrowser: { def: true },
    matugenTemplateVesktop: { def: true },
    matugenTemplateEquibop: { def: true },
    matugenTemplateGhostty: { def: true },
    matugenTemplateKitty: { def: true },
    matugenTemplateFoot: { def: true },
    matugenTemplateAlacritty: { def: true },
    matugenTemplateNeovim: { def: true },
    matugenTemplateWezterm: { def: true },
    matugenTemplateDgop: { def: true },
    matugenTemplateKcolorscheme: { def: true },
    matugenTemplateVscode: { def: true },

    showDock: { def: false },
    dockAutoHide: { def: false },
    dockGroupByApp: { def: false },
    dockOpenOnOverview: { def: false },
    dockPosition: { def: 1 },
    dockSpacing: { def: 4 },
    dockBottomGap: { def: 0 },
    dockMargin: { def: 0 },
    dockIconSize: { def: 40 },
    dockIndicatorStyle: { def: "circle" },
    dockBorderEnabled: { def: false },
    dockBorderColor: { def: "surfaceText" },
    dockBorderOpacity: { def: 1.0, coerce: percentToUnit },
    dockBorderThickness: { def: 1 },
    dockIsolateDisplays: { def: false },

    notificationOverlayEnabled: { def: false },
    overviewRows: { def: 2, persist: false },
    overviewColumns: { def: 5, persist: false },
    overviewScale: { def: 0.16, persist: false },

    modalDarkenBackground: { def: true },

    lockScreenShowPowerActions: { def: true },
    lockScreenShowSystemIcons: { def: true },
    lockScreenShowTime: { def: true },
    lockScreenShowDate: { def: true },
    lockScreenShowProfileImage: { def: true },
    lockScreenShowPasswordField: { def: true },
    enableFprint: { def: false },
    maxFprintTries: { def: 15 },
    fprintdAvailable: { def: false, persist: false },
    lockScreenActiveMonitor: { def: "all" },
    lockScreenInactiveColor: { def: "#000000" },
    lockScreenNotificationMode: { def: 0 },
    hideBrightnessSlider: { def: false },

    notificationTimeoutLow: { def: 5000 },
    notificationTimeoutNormal: { def: 5000 },
    notificationTimeoutCritical: { def: 0 },
    notificationCompactMode: { def: false },
    notificationPopupPosition: { def: 0 },
    notificationHistoryEnabled: { def: true },
    notificationHistoryMaxCount: { def: 50 },
    notificationHistoryMaxAgeDays: { def: 7 },
    notificationHistorySaveLow: { def: true },
    notificationHistorySaveNormal: { def: true },
    notificationHistorySaveCritical: { def: true },

    osdAlwaysShowValue: { def: false },
    osdPosition: { def: 5 },
    osdVolumeEnabled: { def: true },
    osdMediaVolumeEnabled : { def: true },
    osdBrightnessEnabled: { def: true },
    osdIdleInhibitorEnabled: { def: true },
    osdMicMuteEnabled: { def: true },
    osdCapsLockEnabled: { def: true },
    osdPowerProfileEnabled: { def: false },
    osdAudioOutputEnabled: { def: true },

    powerActionConfirm: { def: true },
    powerActionHoldDuration: { def: 0.5 },
    powerMenuActions: { def: ["reboot", "logout", "poweroff", "lock", "suspend", "restart"] },
    powerMenuDefaultAction: { def: "logout" },
    powerMenuGridLayout: { def: false },
    customPowerActionLock: { def: "" },
    customPowerActionLogout: { def: "" },
    customPowerActionSuspend: { def: "" },
    customPowerActionHibernate: { def: "" },
    customPowerActionReboot: { def: "" },
    customPowerActionPowerOff: { def: "" },

    updaterHideWidget: { def: false },
    updaterUseCustomCommand: { def: false },
    updaterCustomCommand: { def: "" },
    updaterTerminalAdditionalParams: { def: "" },

    displayNameMode: { def: "system" },
    screenPreferences: { def: {} },
    showOnLastDisplay: { def: {} },
    niriOutputSettings: { def: {} },
    hyprlandOutputSettings: { def: {} },

    barConfigs: { def: [{
        id: "default",
        name: "Main Bar",
        enabled: true,
        position: 0,
        screenPreferences: ["all"],
        showOnLastDisplay: true,
        leftWidgets: ["launcherButton", "workspaceSwitcher", "focusedWindow"],
        centerWidgets: ["music", "clock", "weather"],
        rightWidgets: ["systemTray", "clipboard", "cpuUsage", "memUsage", "notificationButton", "battery", "controlCenterButton"],
        spacing: 4,
        innerPadding: 4,
        bottomGap: 0,
        transparency: 1.0,
        widgetTransparency: 1.0,
        squareCorners: false,
        noBackground: false,
        gothCornersEnabled: false,
        gothCornerRadiusOverride: false,
        gothCornerRadiusValue: 12,
        borderEnabled: false,
        borderColor: "surfaceText",
        borderOpacity: 1.0,
        borderThickness: 1,
        widgetOutlineEnabled: false,
        widgetOutlineColor: "primary",
        widgetOutlineOpacity: 1.0,
        widgetOutlineThickness: 1,
        fontScale: 1.0,
        autoHide: false,
        autoHideDelay: 250,
        showOnWindowsOpen: false,
        openOnOverview: false,
        visible: true,
        popupGapsAuto: true,
        popupGapsManual: 4,
        maximizeDetection: true,
        scrollEnabled: true,
        scrollXBehavior: "column",
        scrollYBehavior: "workspace",
        shadowIntensity: 0,
        shadowOpacity: 60,
        shadowColorMode: "text",
        shadowCustomColor: "#000000"
    }], onChange: "updateBarConfigs" },

    desktopClockEnabled: { def: false },
    desktopClockStyle: { def: "analog" },
    desktopClockTransparency: { def: 0.8, coerce: percentToUnit },
    desktopClockColorMode: { def: "primary" },
    desktopClockCustomColor: { def: "#ffffff" },
    desktopClockShowDate: { def: true },
    desktopClockShowAnalogNumbers: { def: false },
    desktopClockShowAnalogSeconds: { def: true },
    desktopClockX: { def: -1 },
    desktopClockY: { def: -1 },
    desktopClockWidth: { def: 280 },
    desktopClockHeight: { def: 180 },
    desktopClockDisplayPreferences: { def: ["all"] },

    systemMonitorEnabled: { def: false },
    systemMonitorShowHeader: { def: true },
    systemMonitorTransparency: { def: 0.8, coerce: percentToUnit },
    systemMonitorColorMode: { def: "primary" },
    systemMonitorCustomColor: { def: "#ffffff" },
    systemMonitorShowCpu: { def: true },
    systemMonitorShowCpuGraph: { def: true },
    systemMonitorShowCpuTemp: { def: true },
    systemMonitorShowGpuTemp: { def: false },
    systemMonitorGpuPciId: { def: "" },
    systemMonitorShowMemory: { def: true },
    systemMonitorShowMemoryGraph: { def: true },
    systemMonitorShowNetwork: { def: true },
    systemMonitorShowNetworkGraph: { def: true },
    systemMonitorShowDisk: { def: true },
    systemMonitorShowTopProcesses: { def: false },
    systemMonitorTopProcessCount: { def: 3 },
    systemMonitorTopProcessSortBy: { def: "cpu" },
    systemMonitorGraphInterval: { def: 60 },
    systemMonitorLayoutMode: { def: "auto" },
    systemMonitorX: { def: -1 },
    systemMonitorY: { def: -1 },
    systemMonitorWidth: { def: 320 },
    systemMonitorHeight: { def: 480 },
    systemMonitorDisplayPreferences: { def: ["all"] },
    systemMonitorVariants: { def: [] },
    desktopWidgetPositions: { def: {} },
    desktopWidgetGridSettings: { def: {} },

    desktopWidgetInstances: { def: [] },

    desktopWidgetGroups: { def: [] },

    builtInPluginSettings: { def: {} }
};

function getValidKeys() {
    return Object.keys(SPEC).filter(function(k) { return SPEC[k].persist !== false; }).concat(["configVersion"]);
}

function set(root, key, value, saveFn, hooks) {
    if (!(key in SPEC)) return;
    root[key] = value;
    var hookName = SPEC[key].onChange;
    if (hookName && hooks && hooks[hookName]) {
        hooks[hookName](root);
    }
    saveFn();
}
