#!/usr/bin/zsh
set -e

source "$CASILEDIR/lib/functions.zsh"

alias casile="${CASILE-:casile}"

bookid=$1
test -n $bookid

awk '/^_flattened/ { print $3 }' $CASILEDIR/rules/$LANGUAGE.mk | read _flattened
flattened="$BUILDDIR/$bookid-$_flattened.md"
casile make -- $flattened
remove_extant_bookid $bookid

# Restore meta-data just (maybe) nuked
git checkout HEAD^ -- $bookid.yml
git commit --amend --no-edit

mv $flattened $bookid.md
track $bookid.md
commit "Flatten $bookid source structure into single file"
