# Mix output messages from parallel targets, will be collated by CLI
MAKEFLAGS += --output-sync=none
# Default to not echoing commands before running
MAKEFLAGS += --silent
# Disable as many built in file type builds as possible
MAKEFLAGS += --no-builtin-rules
# Avoid silent errors to ease debugging
MAKEFLAGS += --warn-undefined-variables

.SUFFIXES:

# Don't drop intermediate artifacts (saves rebuild time and aids debugging)
.SECONDARY:
.PRECIOUS: %
.DELETE_ON_ERROR:

# Deprecate direct usage under `make` without the CLI
ifeq ($(CASILE_CLI),)
$(error Use of CaSILE rule file inclusion outside of the CLI is deprecated!)
endif

# Run complete recipes in wrapper script that facilitates clean CLI output
SHELL := $(CASILEDIR)/lib/make-shell.zsh

.SHELLFLAGS = -w

DEBUG ?= false # also later set in rules.mk just to be visible with other settings
ifeq ($(DEBUG),true)
.SHELLFLAGS += -x
endif

# We *must* pass at least one argument to our custom shell before make adds the
# shell code it wants to execute. We use this one because its easy to falsify
# in our $(shell) wrapper environment...
.SHELLFLAGS += _WRAPTARGET=true

# Differentiate shells used to run recipes vs. shell wrapper function
# See https://stackoverflow.com/q/65553367/313192
_ENV := _WRAPTARGET=false

.SHELLFLAGS += $(eval @?=)$(and $@,target=$@)
.ONESHELL:
.SECONDEXPANSION:

# Use paths discovered by autoconf by default, but allow projects to override
# with paths of their own.
AWK ?= gawk
BC ?= /usr/bin/bc
CMP ?= /usr/bin/cmp
CURL ?= /usr/bin/curl
CUT ?= /usr/bin/cut
DATE ?= /usr/bin/date
DECASIFY ?= /usr/bin/decasify
DEEPL ?= /usr/bin/deepl
DIFF ?= /usr/bin/diff
EGREP ?= /usr/bin/grep -E
ENTR ?= /usr/bin/entr
EPUBCHECK ?= /usr/bin/epubcheck
FC_CONFLIST ?= /usr/bin/fc-conflist
FIND ?= /usr/bin/find
FLOCK ?= /usr/bin/flock
GIT ?= /usr/bin/git
GIT_WARP_TIME ?= /usr/bin/git-warp-time
GREP ?= /usr/bin/grep
GS ?= /usr/bin/gs
HOSTNAMEBIN ?= /usr/bin/hostname
INKSCAPE ?= /usr/bin/inkscape
INSTALL ?= /usr/bin/install -c
JQ ?= /usr/bin/jq
KINDLEGEN ?= /usr/bin/kindlegen
LUA ?= /usr/bin/luajit
LUAROCKS ?= /usr/bin/luarocks
M4 ?= /usr/bin/m4
MAGICK ?= /usr/bin/magick
MDBOOK ?= /usr/bin/mdbook
MKDIR_P ?= /usr/bin/mkdir -p
NODE ?= /usr/bin/node
PANDOC ?= /usr/bin/pandoc
PARALLEL ?= /usr/bin/parallel
PCREGREP ?= /usr/bin/pcregrep
PDFBOOK2 ?= /usr/bin/pdfbook2
PDFINFO ?= /usr/bin/pdfinfo
PDFJAM ?= /usr/bin/pdfjam
PDFTK ?= /usr/bin/pdftk
PERL ?= /usr/bin/perl
PGREP ?= /usr/bin/pgrep
PODOFOBOX ?= /usr/bin/podofobox
POVRAY ?= /usr/bin/povray
PYTHON ?= /usr/bin/python
RG ?= /usr/bin/rg
SASSC ?= /usr/bin/sassc
SED ?= /usr/bin/sed
SILE ?= /usr/bin/sile
SORT ?= /usr/bin/sort
SPONGE ?= /usr/bin/sponge
SQLITE3 ?= /usr/bin/sqlite3
STAT ?= /usr/bin/stat
TRUNCATE ?= /usr/bin/truncate
WC ?= /usr/bin/wc
XARGS ?= /usr/bin/xargs
XCF2PNG ?= /usr/bin/xcf2png
XVFB_RUN ?= /usr/bin/xvfb-run
YQ ?= /usr/bin/yq
ZINT ?= /usr/bin/zint
ZOLA ?= /usr/bin/zola
ZSH ?= /usr/bin/zsh

CASILE_SINGLEPOVJOB ?=
CASILE_SINGLEXVFBJOB ?= true

SILE_PATH ?=

.PHONY: default
default: all

include $(CASILEDIR)/rules/functions.mk
