// Generated by CoffeeScript 1.12.4
(function() {
  var bcv_parser, bcv_passage, bcv_utils, root,
    hasProp = {}.hasOwnProperty;

  root = this;

  bcv_parser = (function() {
    bcv_parser.prototype.s = "";

    bcv_parser.prototype.entities = [];

    bcv_parser.prototype.passage = null;

    bcv_parser.prototype.regexps = {};

    bcv_parser.prototype.options = {
      consecutive_combination_strategy: "combine",
      osis_compaction_strategy: "b",
      book_sequence_strategy: "ignore",
      invalid_sequence_strategy: "ignore",
      sequence_combination_strategy: "combine",
      punctuation_strategy: "us",
      invalid_passage_strategy: "ignore",
      non_latin_digits_strategy: "ignore",
      passage_existence_strategy: "bcv",
      zero_chapter_strategy: "error",
      zero_verse_strategy: "error",
      single_chapter_1_strategy: "chapter",
      book_alone_strategy: "ignore",
      book_range_strategy: "ignore",
      captive_end_digits_strategy: "delete",
      end_range_digits_strategy: "verse",
      include_apocrypha: false,
      ps151_strategy: "c",
      versification_system: "default",
      case_sensitive: "none"
    };

    function bcv_parser() {
      var key, ref, val;
      this.options = {};
      ref = bcv_parser.prototype.options;
      for (key in ref) {
        if (!hasProp.call(ref, key)) continue;
        val = ref[key];
        this.options[key] = val;
      }
      this.versification_system(this.options.versification_system);
    }

    bcv_parser.prototype.parse = function(s) {
      var ref;
      this.reset();
      this.s = s;
      s = this.replace_control_characters(s);
      ref = this.match_books(s), s = ref[0], this.passage.books = ref[1];
      this.entities = this.match_passages(s)[0];
      return this;
    };

    bcv_parser.prototype.parse_with_context = function(s, context) {
      var entities, ref, ref1, ref2;
      this.reset();
      ref = this.match_books(this.replace_control_characters(context)), context = ref[0], this.passage.books = ref[1];
      ref1 = this.match_passages(context), entities = ref1[0], context = ref1[1];
      this.reset();
      this.s = s;
      s = this.replace_control_characters(s);
      ref2 = this.match_books(s), s = ref2[0], this.passage.books = ref2[1];
      this.passage.books.push({
        value: "",
        parsed: [],
        start_index: 0,
        type: "context",
        context: context
      });
      s = "\x1f" + (this.passage.books.length - 1) + "/9\x1f" + s;
      this.entities = this.match_passages(s)[0];
      return this;
    };

    bcv_parser.prototype.reset = function() {
      this.s = "";
      this.entities = [];
      if (this.passage) {
        this.passage.books = [];
        return this.passage.indices = {};
      } else {
        this.passage = new bcv_passage;
        this.passage.options = this.options;
        return this.passage.translations = this.translations;
      }
    };

    bcv_parser.prototype.set_options = function(options) {
      var key, val;
      for (key in options) {
        if (!hasProp.call(options, key)) continue;
        val = options[key];
        if (key === "include_apocrypha" || key === "versification_system" || key === "case_sensitive") {
          this[key](val);
        } else {
          this.options[key] = val;
        }
      }
      return this;
    };

    bcv_parser.prototype.include_apocrypha = function(arg) {
      var base, base1, ref, translation, verse_count;
      if (!((arg != null) && (arg === true || arg === false))) {
        return this;
      }
      this.options.include_apocrypha = arg;
      this.regexps.books = this.regexps.get_books(arg, this.options.case_sensitive);
      ref = this.translations;
      for (translation in ref) {
        if (!hasProp.call(ref, translation)) continue;
        if (translation === "aliases" || translation === "alternates") {
          continue;
        }
        if ((base = this.translations[translation]).chapters == null) {
          base.chapters = {};
        }
        if ((base1 = this.translations[translation].chapters)["Ps"] == null) {
          base1["Ps"] = bcv_utils.shallow_clone_array(this.translations["default"].chapters["Ps"]);
        }
        if (arg === true) {
          if (this.translations[translation].chapters["Ps151"] != null) {
            verse_count = this.translations[translation].chapters["Ps151"][0];
          } else {
            verse_count = this.translations["default"].chapters["Ps151"][0];
          }
          this.translations[translation].chapters["Ps"][150] = verse_count;
        } else {
          if (this.translations[translation].chapters["Ps"].length === 151) {
            this.translations[translation].chapters["Ps"].pop();
          }
        }
      }
      return this;
    };

    bcv_parser.prototype.versification_system = function(system) {
      var base, base1, base2, book, chapter_list, ref, ref1;
      if (!((system != null) && (this.translations[system] != null))) {
        return this;
      }
      if (this.translations.alternates["default"] != null) {
        if (system === "default") {
          if (this.translations.alternates["default"].order != null) {
            this.translations["default"].order = bcv_utils.shallow_clone(this.translations.alternates["default"].order);
          }
          ref = this.translations.alternates["default"].chapters;
          for (book in ref) {
            if (!hasProp.call(ref, book)) continue;
            chapter_list = ref[book];
            this.translations["default"].chapters[book] = bcv_utils.shallow_clone_array(chapter_list);
          }
        } else {
          this.versification_system("default");
        }
      }
      if ((base = this.translations.alternates)["default"] == null) {
        base["default"] = {
          order: null,
          chapters: {}
        };
      }
      if (system !== "default" && (this.translations[system].order != null)) {
        if ((base1 = this.translations.alternates["default"]).order == null) {
          base1.order = bcv_utils.shallow_clone(this.translations["default"].order);
        }
        this.translations["default"].order = bcv_utils.shallow_clone(this.translations[system].order);
      }
      if (system !== "default" && (this.translations[system].chapters != null)) {
        ref1 = this.translations[system].chapters;
        for (book in ref1) {
          if (!hasProp.call(ref1, book)) continue;
          chapter_list = ref1[book];
          if ((base2 = this.translations.alternates["default"].chapters)[book] == null) {
            base2[book] = bcv_utils.shallow_clone_array(this.translations["default"].chapters[book]);
          }
          this.translations["default"].chapters[book] = bcv_utils.shallow_clone_array(chapter_list);
        }
      }
      this.options.versification_system = system;
      this.include_apocrypha(this.options.include_apocrypha);
      return this;
    };

    bcv_parser.prototype.case_sensitive = function(arg) {
      if (!((arg != null) && (arg === "none" || arg === "books"))) {
        return this;
      }
      if (arg === this.options.case_sensitive) {
        return this;
      }
      this.options.case_sensitive = arg;
      this.regexps.books = this.regexps.get_books(this.options.include_apocrypha, arg);
      return this;
    };

    bcv_parser.prototype.translation_info = function(new_translation) {
      var book, chapter_list, id, old_translation, out, ref, ref1, ref2;
      if (new_translation == null) {
        new_translation = "default";
      }
      if ((new_translation != null) && (((ref = this.translations.aliases[new_translation]) != null ? ref.alias : void 0) != null)) {
        new_translation = this.translations.aliases[new_translation].alias;
      }
      if (!((new_translation != null) && (this.translations[new_translation] != null))) {
        new_translation = "default";
      }
      old_translation = this.options.versification_system;
      if (new_translation !== old_translation) {
        this.versification_system(new_translation);
      }
      out = {
        alias: new_translation,
        books: [],
        chapters: {},
        order: bcv_utils.shallow_clone(this.translations["default"].order)
      };
      ref1 = this.translations["default"].chapters;
      for (book in ref1) {
        if (!hasProp.call(ref1, book)) continue;
        chapter_list = ref1[book];
        out.chapters[book] = bcv_utils.shallow_clone_array(chapter_list);
      }
      ref2 = out.order;
      for (book in ref2) {
        if (!hasProp.call(ref2, book)) continue;
        id = ref2[book];
        out.books[id - 1] = book;
      }
      if (new_translation !== old_translation) {
        this.versification_system(old_translation);
      }
      return out;
    };

    bcv_parser.prototype.replace_control_characters = function(s) {
      s = s.replace(this.regexps.control, " ");
      if (this.options.non_latin_digits_strategy === "replace") {
        s = s.replace(/[٠۰߀०০੦૦୦0౦೦൦๐໐༠၀႐០᠐᥆᧐᪀᪐᭐᮰᱀᱐꘠꣐꤀꧐꩐꯰０]/g, "0");
        s = s.replace(/[١۱߁१১੧૧୧௧౧೧൧๑໑༡၁႑១᠑᥇᧑᪁᪑᭑᮱᱁᱑꘡꣑꤁꧑꩑꯱１]/g, "1");
        s = s.replace(/[٢۲߂२২੨૨୨௨౨೨൨๒໒༢၂႒២᠒᥈᧒᪂᪒᭒᮲᱂᱒꘢꣒꤂꧒꩒꯲２]/g, "2");
        s = s.replace(/[٣۳߃३৩੩૩୩௩౩೩൩๓໓༣၃႓៣᠓᥉᧓᪃᪓᭓᮳᱃᱓꘣꣓꤃꧓꩓꯳３]/g, "3");
        s = s.replace(/[٤۴߄४৪੪૪୪௪౪೪൪๔໔༤၄႔៤᠔᥊᧔᪄᪔᭔᮴᱄᱔꘤꣔꤄꧔꩔꯴４]/g, "4");
        s = s.replace(/[٥۵߅५৫੫૫୫௫౫೫൫๕໕༥၅႕៥᠕᥋᧕᪅᪕᭕᮵᱅᱕꘥꣕꤅꧕꩕꯵５]/g, "5");
        s = s.replace(/[٦۶߆६৬੬૬୬௬౬೬൬๖໖༦၆႖៦᠖᥌᧖᪆᪖᭖᮶᱆᱖꘦꣖꤆꧖꩖꯶６]/g, "6");
        s = s.replace(/[٧۷߇७৭੭૭୭௭౭೭൭๗໗༧၇႗៧᠗᥍᧗᪇᪗᭗᮷᱇᱗꘧꣗꤇꧗꩗꯷７]/g, "7");
        s = s.replace(/[٨۸߈८৮੮૮୮௮౮೮൮๘໘༨၈႘៨᠘᥎᧘᪈᪘᭘᮸᱈᱘꘨꣘꤈꧘꩘꯸８]/g, "8");
        s = s.replace(/[٩۹߉९৯੯૯୯௯౯೯൯๙໙༩၉႙៩᠙᥏᧙᪉᪙᭙᮹᱉᱙꘩꣙꤉꧙꩙꯹９]/g, "9");
      }
      return s;
    };

    bcv_parser.prototype.match_books = function(s) {
      var book, books, has_replacement, k, len, ref;
      books = [];
      ref = this.regexps.books;
      for (k = 0, len = ref.length; k < len; k++) {
        book = ref[k];
        has_replacement = false;
        s = s.replace(book.regexp, function(full, prev, bk) {
          var extra;
          has_replacement = true;
          books.push({
            value: bk,
            parsed: book.osis,
            type: "book"
          });
          extra = book.extra != null ? "/" + book.extra : "";
          return prev + "\x1f" + (books.length - 1) + extra + "\x1f";
        });
        if (has_replacement === true && /^[\s\x1f\d:.,;\-\u2013\u2014]+$/.test(s)) {
          break;
        }
      }
      s = s.replace(this.regexps.translations, function(match) {
        books.push({
          value: match,
          parsed: match.toLowerCase(),
          type: "translation"
        });
        return "\x1e" + (books.length - 1) + "\x1e";
      });
      return [s, this.get_book_indices(books, s)];
    };

    bcv_parser.prototype.get_book_indices = function(books, s) {
      var add_index, match, re;
      add_index = 0;
      re = /([\x1f\x1e])(\d+)(?:\/\d+)?\1/g;
      while (match = re.exec(s)) {
        books[match[2]].start_index = match.index + add_index;
        add_index += books[match[2]].value.length - match[0].length;
      }
      return books;
    };

    bcv_parser.prototype.match_passages = function(s) {
      var accum, book_id, entities, full, match, next_char, original_part_length, part, passage, post_context, ref, regexp_index_adjust, start_index_adjust;
      entities = [];
      post_context = {};
      while (match = this.regexps.escaped_passage.exec(s)) {
        full = match[0], part = match[1], book_id = match[2];
        original_part_length = part.length;
        match.index += full.length - original_part_length;
        if (/\s[2-9]\d\d\s*$|\s\d{4,}\s*$/.test(part)) {
          part = part.replace(/\s+\d+\s*$/, "");
        }
        if (!/[\d\x1f\x1e)]$/.test(part)) {
          part = this.replace_match_end(part);
        }
        if (this.options.captive_end_digits_strategy === "delete") {
          next_char = match.index + part.length;
          if (s.length > next_char && /^\w/.test(s.substr(next_char, 1))) {
            part = part.replace(/[\s*]+\d+$/, "");
          }
          part = part.replace(/(\x1e[)\]]?)[\s*]*\d+$/, "$1");
        }
        part = part.replace(/[A-Z]+/g, function(capitals) {
          return capitals.toLowerCase();
        });
        start_index_adjust = part.substr(0, 1) === "\x1f" ? 0 : part.split("\x1f")[0].length;
        passage = {
          value: grammar.parse(part, {
            punctuation_strategy: this.options.punctuation_strategy
          }),
          type: "base",
          start_index: this.passage.books[book_id].start_index - start_index_adjust,
          match: part
        };
        if (this.options.book_alone_strategy === "full" && this.options.book_range_strategy === "include" && passage.value[0].type === "b" && (passage.value.length === 1 || (passage.value.length > 1 && passage.value[1].type === "translation_sequence")) && start_index_adjust === 0 && (this.passage.books[book_id].parsed.length === 1 || (this.passage.books[book_id].parsed.length > 1 && this.passage.books[book_id].parsed[1].type === "translation")) && /^[234]/.test(this.passage.books[book_id].parsed[0])) {
          this.create_book_range(s, passage, book_id);
        }
        ref = this.passage.handle_obj(passage), accum = ref[0], post_context = ref[1];
        entities = entities.concat(accum);
        regexp_index_adjust = this.adjust_regexp_end(accum, original_part_length, part.length);
        if (regexp_index_adjust > 0) {
          this.regexps.escaped_passage.lastIndex -= regexp_index_adjust;
        }
      }
      return [entities, post_context];
    };

    bcv_parser.prototype.adjust_regexp_end = function(accum, old_length, new_length) {
      var regexp_index_adjust;
      regexp_index_adjust = 0;
      if (accum.length > 0) {
        regexp_index_adjust = old_length - accum[accum.length - 1].indices[1] - 1;
      } else if (old_length !== new_length) {
        regexp_index_adjust = old_length - new_length;
      }
      return regexp_index_adjust;
    };

    bcv_parser.prototype.replace_match_end = function(part) {
      var match, remove;
      remove = part.length;
      while (match = this.regexps.match_end_split.exec(part)) {
        remove = match.index + match[0].length;
      }
      if (remove < part.length) {
        part = part.substr(0, remove);
      }
      return part;
    };

    bcv_parser.prototype.create_book_range = function(s, passage, book_id) {
      var cases, i, k, limit, prev, range_regexp, ref;
      cases = [bcv_parser.prototype.regexps.first, bcv_parser.prototype.regexps.second, bcv_parser.prototype.regexps.third];
      limit = parseInt(this.passage.books[book_id].parsed[0].substr(0, 1), 10);
      for (i = k = 1, ref = limit; 1 <= ref ? k < ref : k > ref; i = 1 <= ref ? ++k : --k) {
        range_regexp = i === limit - 1 ? bcv_parser.prototype.regexps.range_and : bcv_parser.prototype.regexps.range_only;
        prev = s.match(RegExp("(?:^|\\W)(" + cases[i - 1] + "\\s*" + range_regexp + "\\s*)\\x1f" + book_id + "\\x1f", "i"));
        if (prev != null) {
          return this.add_book_range_object(passage, prev, i);
        }
      }
      return false;
    };

    bcv_parser.prototype.add_book_range_object = function(passage, prev, start_book_number) {
      var i, k, length, ref, ref1, results;
      length = prev[1].length;
      passage.value[0] = {
        type: "b_range_pre",
        value: [
          {
            type: "b_pre",
            value: start_book_number.toString(),
            indices: [prev.index, prev.index + length]
          }, passage.value[0]
        ],
        indices: [0, passage.value[0].indices[1] + length]
      };
      passage.value[0].value[1].indices[0] += length;
      passage.value[0].value[1].indices[1] += length;
      passage.start_index -= length;
      passage.match = prev[1] + passage.match;
      if (passage.value.length === 1) {
        return;
      }
      results = [];
      for (i = k = 1, ref = passage.value.length; 1 <= ref ? k < ref : k > ref; i = 1 <= ref ? ++k : --k) {
        if (passage.value[i].value == null) {
          continue;
        }
        if (((ref1 = passage.value[i].value[0]) != null ? ref1.indices : void 0) != null) {
          passage.value[i].value[0].indices[0] += length;
          passage.value[i].value[0].indices[1] += length;
        }
        passage.value[i].indices[0] += length;
        results.push(passage.value[i].indices[1] += length);
      }
      return results;
    };

    bcv_parser.prototype.osis = function() {
      var k, len, osis, out, ref;
      out = [];
      ref = this.parsed_entities();
      for (k = 0, len = ref.length; k < len; k++) {
        osis = ref[k];
        if (osis.osis.length > 0) {
          out.push(osis.osis);
        }
      }
      return out.join(",");
    };

    bcv_parser.prototype.osis_and_translations = function() {
      var k, len, osis, out, ref;
      out = [];
      ref = this.parsed_entities();
      for (k = 0, len = ref.length; k < len; k++) {
        osis = ref[k];
        if (osis.osis.length > 0) {
          out.push([osis.osis, osis.translations.join(",")]);
        }
      }
      return out;
    };

    bcv_parser.prototype.osis_and_indices = function() {
      var k, len, osis, out, ref;
      out = [];
      ref = this.parsed_entities();
      for (k = 0, len = ref.length; k < len; k++) {
        osis = ref[k];
        if (osis.osis.length > 0) {
          out.push({
            osis: osis.osis,
            translations: osis.translations,
            indices: osis.indices
          });
        }
      }
      return out;
    };

    bcv_parser.prototype.parsed_entities = function() {
      var entity, entity_id, i, k, l, last_i, len, len1, length, m, n, osis, osises, out, passage, ref, ref1, ref2, ref3, strings, translation, translation_alias, translation_osis, translations;
      out = [];
      for (entity_id = k = 0, ref = this.entities.length; 0 <= ref ? k < ref : k > ref; entity_id = 0 <= ref ? ++k : --k) {
        entity = this.entities[entity_id];
        if (entity.type && entity.type === "translation_sequence" && out.length > 0 && entity_id === out[out.length - 1].entity_id + 1) {
          out[out.length - 1].indices[1] = entity.absolute_indices[1];
        }
        if (entity.passages == null) {
          continue;
        }
        if ((entity.type === "b" && this.options.book_alone_strategy === "ignore") || (entity.type === "b_range" && this.options.book_range_strategy === "ignore") || entity.type === "context") {
          continue;
        }
        translations = [];
        translation_alias = null;
        if (entity.passages[0].translations != null) {
          ref1 = entity.passages[0].translations;
          for (l = 0, len = ref1.length; l < len; l++) {
            translation = ref1[l];
            translation_osis = ((ref2 = translation.osis) != null ? ref2.length : void 0) > 0 ? translation.osis : "";
            if (translation_alias == null) {
              translation_alias = translation.alias;
            }
            translations.push(translation_osis);
          }
        } else {
          translations = [""];
          translation_alias = "default";
        }
        osises = [];
        length = entity.passages.length;
        for (i = m = 0, ref3 = length; 0 <= ref3 ? m < ref3 : m > ref3; i = 0 <= ref3 ? ++m : --m) {
          passage = entity.passages[i];
          if (passage.type == null) {
            passage.type = entity.type;
          }
          if (passage.valid.valid === false) {
            if (this.options.invalid_sequence_strategy === "ignore" && entity.type === "sequence") {
              this.snap_sequence("ignore", entity, osises, i, length);
            }
            if (this.options.invalid_passage_strategy === "ignore") {
              continue;
            }
          }
          if ((passage.type === "b" || passage.type === "b_range") && this.options.book_sequence_strategy === "ignore" && entity.type === "sequence") {
            this.snap_sequence("book", entity, osises, i, length);
            continue;
          }
          if ((passage.type === "b_range_start" || passage.type === "range_end_b") && this.options.book_range_strategy === "ignore") {
            this.snap_range(entity, i);
          }
          if (passage.absolute_indices == null) {
            passage.absolute_indices = entity.absolute_indices;
          }
          osises.push({
            osis: passage.valid.valid ? this.to_osis(passage.start, passage.end, translation_alias) : "",
            type: passage.type,
            indices: passage.absolute_indices,
            translations: translations,
            start: passage.start,
            end: passage.end,
            enclosed_indices: passage.enclosed_absolute_indices,
            entity_id: entity_id,
            entities: [passage]
          });
        }
        if (osises.length === 0) {
          continue;
        }
        if (osises.length > 1 && this.options.consecutive_combination_strategy === "combine") {
          osises = this.combine_consecutive_passages(osises, translation_alias);
        }
        if (this.options.sequence_combination_strategy === "separate") {
          out = out.concat(osises);
        } else {
          strings = [];
          last_i = osises.length - 1;
          if ((osises[last_i].enclosed_indices != null) && osises[last_i].enclosed_indices[1] >= 0) {
            entity.absolute_indices[1] = osises[last_i].enclosed_indices[1];
          }
          for (n = 0, len1 = osises.length; n < len1; n++) {
            osis = osises[n];
            if (osis.osis.length > 0) {
              strings.push(osis.osis);
            }
          }
          out.push({
            osis: strings.join(","),
            indices: entity.absolute_indices,
            translations: translations,
            entity_id: entity_id,
            entities: osises
          });
        }
      }
      return out;
    };

    bcv_parser.prototype.to_osis = function(start, end, translation) {
      var osis, out;
      if ((end.c == null) && (end.v == null) && start.b === end.b && (start.c == null) && (start.v == null) && this.options.book_alone_strategy === "first_chapter") {
        end.c = 1;
      }
      osis = {
        start: "",
        end: ""
      };
      if (start.c == null) {
        start.c = 1;
      }
      if (start.v == null) {
        start.v = 1;
      }
      if (end.c == null) {
        if (this.options.passage_existence_strategy.indexOf("c") >= 0 || ((this.passage.translations[translation].chapters[end.b] != null) && this.passage.translations[translation].chapters[end.b].length === 1)) {
          end.c = this.passage.translations[translation].chapters[end.b].length;
        } else {
          end.c = 999;
        }
      }
      if (end.v == null) {
        if ((this.passage.translations[translation].chapters[end.b][end.c - 1] != null) && this.options.passage_existence_strategy.indexOf("v") >= 0) {
          end.v = this.passage.translations[translation].chapters[end.b][end.c - 1];
        } else {
          end.v = 999;
        }
      }
      if (this.options.include_apocrypha && this.options.ps151_strategy === "b" && ((start.c === 151 && start.b === "Ps") || (end.c === 151 && end.b === "Ps"))) {
        this.fix_ps151(start, end, translation);
      }
      if (this.options.osis_compaction_strategy === "b" && start.c === 1 && start.v === 1 && ((end.c === 999 && end.v === 999) || (end.c === this.passage.translations[translation].chapters[end.b].length && this.options.passage_existence_strategy.indexOf("c") >= 0 && (end.v === 999 || (end.v === this.passage.translations[translation].chapters[end.b][end.c - 1] && this.options.passage_existence_strategy.indexOf("v") >= 0))))) {
        osis.start = start.b;
        osis.end = end.b;
      } else if (this.options.osis_compaction_strategy.length <= 2 && start.v === 1 && (end.v === 999 || (end.v === this.passage.translations[translation].chapters[end.b][end.c - 1] && this.options.passage_existence_strategy.indexOf("v") >= 0))) {
        osis.start = start.b + "." + start.c.toString();
        osis.end = end.b + "." + end.c.toString();
      } else {
        osis.start = start.b + "." + start.c.toString() + "." + start.v.toString();
        osis.end = end.b + "." + end.c.toString() + "." + end.v.toString();
      }
      if (osis.start === osis.end) {
        out = osis.start;
      } else {
        out = osis.start + "-" + osis.end;
      }
      if (start.extra != null) {
        out = start.extra + "," + out;
      }
      if (end.extra != null) {
        out += "," + end.extra;
      }
      return out;
    };

    bcv_parser.prototype.fix_ps151 = function(start, end, translation) {
      var ref;
      if (translation !== "default" && (((ref = this.translations[translation]) != null ? ref.chapters["Ps151"] : void 0) == null)) {
        this.passage.promote_book_to_translation("Ps151", translation);
      }
      if (start.c === 151 && start.b === "Ps") {
        if (end.c === 151 && end.b === "Ps") {
          start.b = "Ps151";
          start.c = 1;
          end.b = "Ps151";
          return end.c = 1;
        } else {
          start.extra = this.to_osis({
            b: "Ps151",
            c: 1,
            v: start.v
          }, {
            b: "Ps151",
            c: 1,
            v: this.passage.translations[translation].chapters["Ps151"][0]
          }, translation);
          start.b = "Prov";
          start.c = 1;
          return start.v = 1;
        }
      } else {
        end.extra = this.to_osis({
          b: "Ps151",
          c: 1,
          v: 1
        }, {
          b: "Ps151",
          c: 1,
          v: end.v
        }, translation);
        end.c = 150;
        return end.v = this.passage.translations[translation].chapters["Ps"][149];
      }
    };

    bcv_parser.prototype.combine_consecutive_passages = function(osises, translation) {
      var enclosed_sequence_start, has_enclosed, i, is_enclosed_last, k, last_i, osis, out, prev, prev_i, ref;
      out = [];
      prev = {};
      last_i = osises.length - 1;
      enclosed_sequence_start = -1;
      has_enclosed = false;
      for (i = k = 0, ref = last_i; 0 <= ref ? k <= ref : k >= ref; i = 0 <= ref ? ++k : --k) {
        osis = osises[i];
        if (osis.osis.length > 0) {
          prev_i = out.length - 1;
          is_enclosed_last = false;
          if (osis.enclosed_indices[0] !== enclosed_sequence_start) {
            enclosed_sequence_start = osis.enclosed_indices[0];
          }
          if (enclosed_sequence_start >= 0 && (i === last_i || osises[i + 1].enclosed_indices[0] !== osis.enclosed_indices[0])) {
            is_enclosed_last = true;
            has_enclosed = true;
          }
          if (this.is_verse_consecutive(prev, osis.start, translation)) {
            out[prev_i].end = osis.end;
            out[prev_i].is_enclosed_last = is_enclosed_last;
            out[prev_i].indices[1] = osis.indices[1];
            out[prev_i].enclosed_indices[1] = osis.enclosed_indices[1];
            out[prev_i].osis = this.to_osis(out[prev_i].start, osis.end, translation);
          } else {
            out.push(osis);
          }
          prev = {
            b: osis.end.b,
            c: osis.end.c,
            v: osis.end.v
          };
        } else {
          out.push(osis);
          prev = {};
        }
      }
      if (has_enclosed) {
        this.snap_enclosed_indices(out);
      }
      return out;
    };

    bcv_parser.prototype.snap_enclosed_indices = function(osises) {
      var k, len, osis;
      for (k = 0, len = osises.length; k < len; k++) {
        osis = osises[k];
        if (osis.is_enclosed_last != null) {
          if (osis.enclosed_indices[0] < 0 && osis.is_enclosed_last) {
            osis.indices[1] = osis.enclosed_indices[1];
          }
          delete osis.is_enclosed_last;
        }
      }
      return osises;
    };

    bcv_parser.prototype.is_verse_consecutive = function(prev, check, translation) {
      var translation_order;
      if (prev.b == null) {
        return false;
      }
      translation_order = this.passage.translations[translation].order != null ? this.passage.translations[translation].order : this.passage.translations["default"].order;
      if (prev.b === check.b) {
        if (prev.c === check.c) {
          if (prev.v === check.v - 1) {
            return true;
          }
        } else if (check.v === 1 && prev.c === check.c - 1) {
          if (prev.v === this.passage.translations[translation].chapters[prev.b][prev.c - 1]) {
            return true;
          }
        }
      } else if (check.c === 1 && check.v === 1 && translation_order[prev.b] === translation_order[check.b] - 1) {
        if (prev.c === this.passage.translations[translation].chapters[prev.b].length && prev.v === this.passage.translations[translation].chapters[prev.b][prev.c - 1]) {
          return true;
        }
      }
      return false;
    };

    bcv_parser.prototype.snap_range = function(entity, passage_i) {
      var entity_i, key, pluck, ref, source_entity, target_entity, temp, type;
      if (entity.type === "b_range_start" || (entity.type === "sequence" && entity.passages[passage_i].type === "b_range_start")) {
        entity_i = 1;
        source_entity = "end";
        type = "b_range_start";
      } else {
        entity_i = 0;
        source_entity = "start";
        type = "range_end_b";
      }
      target_entity = source_entity === "end" ? "start" : "end";
      ref = entity.passages[passage_i][target_entity];
      for (key in ref) {
        if (!hasProp.call(ref, key)) continue;
        entity.passages[passage_i][target_entity][key] = entity.passages[passage_i][source_entity][key];
      }
      if (entity.type === "sequence") {
        if (passage_i >= entity.value.length) {
          passage_i = entity.value.length - 1;
        }
        pluck = this.passage.pluck(type, entity.value[passage_i]);
        if (pluck != null) {
          temp = this.snap_range(pluck, 0);
          if (passage_i === 0) {
            entity.absolute_indices[0] = temp.absolute_indices[0];
          } else {
            entity.absolute_indices[1] = temp.absolute_indices[1];
          }
        }
      } else {
        entity.original_type = entity.type;
        entity.type = entity.value[entity_i].type;
        entity.absolute_indices = [entity.value[entity_i].absolute_indices[0], entity.value[entity_i].absolute_indices[1]];
      }
      return entity;
    };

    bcv_parser.prototype.snap_sequence = function(type, entity, osises, i, length) {
      var passage;
      passage = entity.passages[i];
      if (passage.absolute_indices[0] === entity.absolute_indices[0] && i < length - 1 && this.get_snap_sequence_i(entity.passages, i, length) !== i) {
        entity.absolute_indices[0] = entity.passages[i + 1].absolute_indices[0];
        this.remove_absolute_indices(entity.passages, i + 1);
      } else if (passage.absolute_indices[1] === entity.absolute_indices[1] && i > 0) {
        entity.absolute_indices[1] = osises.length > 0 ? osises[osises.length - 1].indices[1] : entity.passages[i - 1].absolute_indices[1];
      } else if (type === "book" && i < length - 1 && !this.starts_with_book(entity.passages[i + 1])) {
        entity.passages[i + 1].absolute_indices[0] = passage.absolute_indices[0];
      }
      return entity;
    };

    bcv_parser.prototype.get_snap_sequence_i = function(passages, i, length) {
      var j, k, ref, ref1;
      for (j = k = ref = i + 1, ref1 = length; ref <= ref1 ? k < ref1 : k > ref1; j = ref <= ref1 ? ++k : --k) {
        if (this.starts_with_book(passages[j])) {
          return j;
        }
        if (passages[j].valid.valid) {
          return i;
        }
      }
      return i;
    };

    bcv_parser.prototype.starts_with_book = function(passage) {
      if (passage.type.substr(0, 1) === "b") {
        return true;
      }
      if ((passage.type === "range" || passage.type === "ff") && passage.start.type.substr(0, 1) === "b") {
        return true;
      }
      return false;
    };

    bcv_parser.prototype.remove_absolute_indices = function(passages, i) {
      var end, k, len, passage, ref, ref1, start;
      if (passages[i].enclosed_absolute_indices[0] < 0) {
        return false;
      }
      ref = passages[i].enclosed_absolute_indices, start = ref[0], end = ref[1];
      ref1 = passages.slice(i);
      for (k = 0, len = ref1.length; k < len; k++) {
        passage = ref1[k];
        if (passage.enclosed_absolute_indices[0] === start && passage.enclosed_absolute_indices[1] === end) {
          passage.enclosed_absolute_indices = [-1, -1];
        } else {
          break;
        }
      }
      return true;
    };

    return bcv_parser;

  })();

  root.bcv_parser = bcv_parser;

  bcv_passage = (function() {
    function bcv_passage() {}

    bcv_passage.prototype.books = [];

    bcv_passage.prototype.indices = {};

    bcv_passage.prototype.options = {};

    bcv_passage.prototype.translations = {};

    bcv_passage.prototype.handle_array = function(passages, accum, context) {
      var k, len, passage, ref;
      if (accum == null) {
        accum = [];
      }
      if (context == null) {
        context = {};
      }
      for (k = 0, len = passages.length; k < len; k++) {
        passage = passages[k];
        if (passage == null) {
          continue;
        }
        if (passage.type === "stop") {
          break;
        }
        ref = this.handle_obj(passage, accum, context), accum = ref[0], context = ref[1];
      }
      return [accum, context];
    };

    bcv_passage.prototype.handle_obj = function(passage, accum, context) {
      if ((passage.type != null) && (this[passage.type] != null)) {
        return this[passage.type](passage, accum, context);
      } else {
        return [accum, context];
      }
    };

    bcv_passage.prototype.b = function(passage, accum, context) {
      var alternates, b, k, len, obj, ref, valid;
      passage.start_context = bcv_utils.shallow_clone(context);
      passage.passages = [];
      alternates = [];
      ref = this.books[passage.value].parsed;
      for (k = 0, len = ref.length; k < len; k++) {
        b = ref[k];
        valid = this.validate_ref(passage.start_context.translations, {
          b: b
        });
        obj = {
          start: {
            b: b
          },
          end: {
            b: b
          },
          valid: valid
        };
        if (passage.passages.length === 0 && valid.valid) {
          passage.passages.push(obj);
        } else {
          alternates.push(obj);
        }
      }
      if (passage.passages.length === 0) {
        passage.passages.push(alternates.shift());
      }
      if (alternates.length > 0) {
        passage.passages[0].alternates = alternates;
      }
      if (passage.start_context.translations != null) {
        passage.passages[0].translations = passage.start_context.translations;
      }
      if (passage.absolute_indices == null) {
        passage.absolute_indices = this.get_absolute_indices(passage.indices);
      }
      accum.push(passage);
      context = {
        b: passage.passages[0].start.b
      };
      if (passage.start_context.translations != null) {
        context.translations = passage.start_context.translations;
      }
      return [accum, context];
    };

    bcv_passage.prototype.b_range = function(passage, accum, context) {
      return this.range(passage, accum, context);
    };

    bcv_passage.prototype.b_range_pre = function(passage, accum, context) {
      var alternates, book, end, ref, ref1, start_obj;
      passage.start_context = bcv_utils.shallow_clone(context);
      passage.passages = [];
      alternates = [];
      book = this.pluck("b", passage.value);
      ref = this.b(book, [], context), (ref1 = ref[0], end = ref1[0]), context = ref[1];
      if (passage.absolute_indices == null) {
        passage.absolute_indices = this.get_absolute_indices(passage.indices);
      }
      start_obj = {
        b: passage.value[0].value + end.passages[0].start.b.substr(1),
        type: "b"
      };
      passage.passages = [
        {
          start: start_obj,
          end: end.passages[0].end,
          valid: end.passages[0].valid
        }
      ];
      if (passage.start_context.translations != null) {
        passage.passages[0].translations = passage.start_context.translations;
      }
      accum.push(passage);
      return [accum, context];
    };

    bcv_passage.prototype.b_range_start = function(passage, accum, context) {
      return this.range(passage, accum, context);
    };

    bcv_passage.prototype.base = function(passage, accum, context) {
      this.indices = this.calculate_indices(passage.match, passage.start_index);
      return this.handle_array(passage.value, accum, context);
    };

    bcv_passage.prototype.bc = function(passage, accum, context) {
      var alternates, b, c, context_key, k, len, obj, ref, ref1, valid;
      passage.start_context = bcv_utils.shallow_clone(context);
      passage.passages = [];
      this.reset_context(context, ["b", "c", "v"]);
      c = this.pluck("c", passage.value).value;
      alternates = [];
      ref = this.books[this.pluck("b", passage.value).value].parsed;
      for (k = 0, len = ref.length; k < len; k++) {
        b = ref[k];
        context_key = "c";
        valid = this.validate_ref(passage.start_context.translations, {
          b: b,
          c: c
        });
        obj = {
          start: {
            b: b
          },
          end: {
            b: b
          },
          valid: valid
        };
        if (valid.messages.start_chapter_not_exist_in_single_chapter_book || valid.messages.start_chapter_1) {
          obj.valid = this.validate_ref(passage.start_context.translations, {
            b: b,
            v: c
          });
          if (valid.messages.start_chapter_not_exist_in_single_chapter_book) {
            obj.valid.messages.start_chapter_not_exist_in_single_chapter_book = 1;
          }
          obj.start.c = 1;
          obj.end.c = 1;
          context_key = "v";
        }
        obj.start[context_key] = c;
        ref1 = this.fix_start_zeroes(obj.valid, obj.start.c, obj.start.v), obj.start.c = ref1[0], obj.start.v = ref1[1];
        if (obj.start.v == null) {
          delete obj.start.v;
        }
        obj.end[context_key] = obj.start[context_key];
        if (passage.passages.length === 0 && obj.valid.valid) {
          passage.passages.push(obj);
        } else {
          alternates.push(obj);
        }
      }
      if (passage.passages.length === 0) {
        passage.passages.push(alternates.shift());
      }
      if (alternates.length > 0) {
        passage.passages[0].alternates = alternates;
      }
      if (passage.start_context.translations != null) {
        passage.passages[0].translations = passage.start_context.translations;
      }
      if (passage.absolute_indices == null) {
        passage.absolute_indices = this.get_absolute_indices(passage.indices);
      }
      this.set_context_from_object(context, ["b", "c", "v"], passage.passages[0].start);
      accum.push(passage);
      return [accum, context];
    };

    bcv_passage.prototype.bc_title = function(passage, accum, context) {
      var bc, i, k, ref, ref1, ref2, title;
      passage.start_context = bcv_utils.shallow_clone(context);
      ref = this.bc(this.pluck("bc", passage.value), [], context), (ref1 = ref[0], bc = ref1[0]), context = ref[1];
      if (bc.passages[0].start.b.substr(0, 2) !== "Ps" && (bc.passages[0].alternates != null)) {
        for (i = k = 0, ref2 = bc.passages[0].alternates.length; 0 <= ref2 ? k < ref2 : k > ref2; i = 0 <= ref2 ? ++k : --k) {
          if (bc.passages[0].alternates[i].start.b.substr(0, 2) !== "Ps") {
            continue;
          }
          bc.passages[0] = bc.passages[0].alternates[i];
          break;
        }
      }
      if (bc.passages[0].start.b.substr(0, 2) !== "Ps") {
        accum.push(bc);
        return [accum, context];
      }
      this.books[this.pluck("b", bc.value).value].parsed = ["Ps"];
      title = this.pluck("title", passage.value);
      if (title == null) {
        title = this.pluck("v", passage.value);
      }
      passage.value[1] = {
        type: "v",
        value: [
          {
            type: "integer",
            value: 1,
            indices: title.indices
          }
        ],
        indices: title.indices
      };
      passage.type = "bcv";
      return this.bcv(passage, accum, passage.start_context);
    };

    bcv_passage.prototype.bcv = function(passage, accum, context) {
      var alternates, b, bc, c, k, len, obj, ref, ref1, v, valid;
      passage.start_context = bcv_utils.shallow_clone(context);
      passage.passages = [];
      this.reset_context(context, ["b", "c", "v"]);
      bc = this.pluck("bc", passage.value);
      c = this.pluck("c", bc.value).value;
      v = this.pluck("v", passage.value).value;
      alternates = [];
      ref = this.books[this.pluck("b", bc.value).value].parsed;
      for (k = 0, len = ref.length; k < len; k++) {
        b = ref[k];
        valid = this.validate_ref(passage.start_context.translations, {
          b: b,
          c: c,
          v: v
        });
        ref1 = this.fix_start_zeroes(valid, c, v), c = ref1[0], v = ref1[1];
        obj = {
          start: {
            b: b,
            c: c,
            v: v
          },
          end: {
            b: b,
            c: c,
            v: v
          },
          valid: valid
        };
        if (passage.passages.length === 0 && valid.valid) {
          passage.passages.push(obj);
        } else {
          alternates.push(obj);
        }
      }
      if (passage.passages.length === 0) {
        passage.passages.push(alternates.shift());
      }
      if (alternates.length > 0) {
        passage.passages[0].alternates = alternates;
      }
      if (passage.start_context.translations != null) {
        passage.passages[0].translations = passage.start_context.translations;
      }
      if (passage.absolute_indices == null) {
        passage.absolute_indices = this.get_absolute_indices(passage.indices);
      }
      this.set_context_from_object(context, ["b", "c", "v"], passage.passages[0].start);
      accum.push(passage);
      return [accum, context];
    };

    bcv_passage.prototype.bv = function(passage, accum, context) {
      var b, bcv, ref, ref1, ref2, v;
      passage.start_context = bcv_utils.shallow_clone(context);
      ref = passage.value, b = ref[0], v = ref[1];
      bcv = {
        indices: passage.indices,
        value: [
          {
            type: "bc",
            value: [
              b, {
                type: "c",
                value: [
                  {
                    type: "integer",
                    value: 1
                  }
                ]
              }
            ]
          }, v
        ]
      };
      ref1 = this.bcv(bcv, [], context), (ref2 = ref1[0], bcv = ref2[0]), context = ref1[1];
      passage.passages = bcv.passages;
      if (passage.absolute_indices == null) {
        passage.absolute_indices = this.get_absolute_indices(passage.indices);
      }
      accum.push(passage);
      return [accum, context];
    };

    bcv_passage.prototype.c = function(passage, accum, context) {
      var c, valid;
      passage.start_context = bcv_utils.shallow_clone(context);
      c = passage.type === "integer" ? passage.value : this.pluck("integer", passage.value).value;
      valid = this.validate_ref(passage.start_context.translations, {
        b: context.b,
        c: c
      });
      if (!valid.valid && valid.messages.start_chapter_not_exist_in_single_chapter_book) {
        return this.v(passage, accum, context);
      }
      c = this.fix_start_zeroes(valid, c)[0];
      passage.passages = [
        {
          start: {
            b: context.b,
            c: c
          },
          end: {
            b: context.b,
            c: c
          },
          valid: valid
        }
      ];
      if (passage.start_context.translations != null) {
        passage.passages[0].translations = passage.start_context.translations;
      }
      accum.push(passage);
      context.c = c;
      this.reset_context(context, ["v"]);
      if (passage.absolute_indices == null) {
        passage.absolute_indices = this.get_absolute_indices(passage.indices);
      }
      return [accum, context];
    };

    bcv_passage.prototype.c_psalm = function(passage, accum, context) {
      var c;
      passage.type = "bc";
      c = parseInt(this.books[passage.value].value.match(/^\d+/)[0], 10);
      passage.value = [
        {
          type: "b",
          value: passage.value,
          indices: passage.indices
        }, {
          type: "c",
          value: [
            {
              type: "integer",
              value: c,
              indices: passage.indices
            }
          ],
          indices: passage.indices
        }
      ];
      return this.bc(passage, accum, context);
    };

    bcv_passage.prototype.c_title = function(passage, accum, context) {
      var title;
      passage.start_context = bcv_utils.shallow_clone(context);
      if (context.b !== "Ps") {
        return this.c(passage.value[0], accum, context);
      }
      title = this.pluck("title", passage.value);
      passage.value[1] = {
        type: "v",
        value: [
          {
            type: "integer",
            value: 1,
            indices: title.indices
          }
        ],
        indices: title.indices
      };
      passage.type = "cv";
      return this.cv(passage, accum, passage.start_context);
    };

    bcv_passage.prototype.cv = function(passage, accum, context) {
      var c, ref, v, valid;
      passage.start_context = bcv_utils.shallow_clone(context);
      c = this.pluck("c", passage.value).value;
      v = this.pluck("v", passage.value).value;
      valid = this.validate_ref(passage.start_context.translations, {
        b: context.b,
        c: c,
        v: v
      });
      ref = this.fix_start_zeroes(valid, c, v), c = ref[0], v = ref[1];
      passage.passages = [
        {
          start: {
            b: context.b,
            c: c,
            v: v
          },
          end: {
            b: context.b,
            c: c,
            v: v
          },
          valid: valid
        }
      ];
      if (passage.start_context.translations != null) {
        passage.passages[0].translations = passage.start_context.translations;
      }
      accum.push(passage);
      context.c = c;
      context.v = v;
      if (passage.absolute_indices == null) {
        passage.absolute_indices = this.get_absolute_indices(passage.indices);
      }
      return [accum, context];
    };

    bcv_passage.prototype.cb_range = function(passage, accum, context) {
      var b, end_c, ref, start_c;
      passage.type = "range";
      ref = passage.value, b = ref[0], start_c = ref[1], end_c = ref[2];
      passage.value = [
        {
          type: "bc",
          value: [b, start_c],
          indices: passage.indices
        }, end_c
      ];
      end_c.indices[1] = passage.indices[1];
      return this.range(passage, accum, context);
    };

    bcv_passage.prototype.context = function(passage, accum, context) {
      var key, ref;
      passage.start_context = bcv_utils.shallow_clone(context);
      passage.passages = [];
      ref = this.books[passage.value].context;
      for (key in ref) {
        if (!hasProp.call(ref, key)) continue;
        context[key] = this.books[passage.value].context[key];
      }
      accum.push(passage);
      return [accum, context];
    };

    bcv_passage.prototype.cv_psalm = function(passage, accum, context) {
      var bc, c_psalm, ref, v;
      passage.start_context = bcv_utils.shallow_clone(context);
      passage.type = "bcv";
      ref = passage.value, c_psalm = ref[0], v = ref[1];
      bc = this.c_psalm(c_psalm, [], passage.start_context)[0][0];
      passage.value = [bc, v];
      return this.bcv(passage, accum, context);
    };

    bcv_passage.prototype.ff = function(passage, accum, context) {
      var ref, ref1;
      passage.start_context = bcv_utils.shallow_clone(context);
      passage.value.push({
        type: "integer",
        indices: passage.indices,
        value: 999
      });
      ref = this.range(passage, [], passage.start_context), (ref1 = ref[0], passage = ref1[0]), context = ref[1];
      passage.value[0].indices = passage.value[1].indices;
      passage.value[0].absolute_indices = passage.value[1].absolute_indices;
      passage.value.pop();
      if (passage.passages[0].valid.messages.end_verse_not_exist != null) {
        delete passage.passages[0].valid.messages.end_verse_not_exist;
      }
      if (passage.passages[0].valid.messages.end_chapter_not_exist != null) {
        delete passage.passages[0].valid.messages.end_chapter_not_exist;
      }
      if (passage.passages[0].end.original_c != null) {
        delete passage.passages[0].end.original_c;
      }
      accum.push(passage);
      return [accum, context];
    };

    bcv_passage.prototype.integer_title = function(passage, accum, context) {
      var v_indices;
      passage.start_context = bcv_utils.shallow_clone(context);
      if (context.b !== "Ps") {
        return this.integer(passage.value[0], accum, context);
      }
      passage.value[0] = {
        type: "c",
        value: [passage.value[0]],
        indices: [passage.value[0].indices[0], passage.value[0].indices[1]]
      };
      v_indices = [passage.indices[1] - 5, passage.indices[1]];
      passage.value[1] = {
        type: "v",
        value: [
          {
            type: "integer",
            value: 1,
            indices: v_indices
          }
        ],
        indices: v_indices
      };
      passage.type = "cv";
      return this.cv(passage, accum, passage.start_context);
    };

    bcv_passage.prototype.integer = function(passage, accum, context) {
      if (context.v != null) {
        return this.v(passage, accum, context);
      }
      return this.c(passage, accum, context);
    };

    bcv_passage.prototype.next_v = function(passage, accum, context) {
      var prev_integer, psg, ref, ref1, ref2, ref3;
      passage.start_context = bcv_utils.shallow_clone(context);
      prev_integer = this.pluck_last_recursively("integer", passage.value);
      if (prev_integer == null) {
        prev_integer = {
          value: 1
        };
      }
      passage.value.push({
        type: "integer",
        indices: passage.indices,
        value: prev_integer.value + 1
      });
      ref = this.range(passage, [], passage.start_context), (ref1 = ref[0], psg = ref1[0]), context = ref[1];
      if ((psg.passages[0].valid.messages.end_verse_not_exist != null) && (psg.passages[0].valid.messages.start_verse_not_exist == null) && (psg.passages[0].valid.messages.start_chapter_not_exist == null) && (context.c != null)) {
        passage.value.pop();
        passage.value.push({
          type: "cv",
          indices: passage.indices,
          value: [
            {
              type: "c",
              value: [
                {
                  type: "integer",
                  value: context.c + 1,
                  indices: passage.indices
                }
              ],
              indices: passage.indices
            }, {
              type: "v",
              value: [
                {
                  type: "integer",
                  value: 1,
                  indices: passage.indices
                }
              ],
              indices: passage.indices
            }
          ]
        });
        ref2 = this.range(passage, [], passage.start_context), (ref3 = ref2[0], psg = ref3[0]), context = ref2[1];
      }
      psg.value[0].indices = psg.value[1].indices;
      psg.value[0].absolute_indices = psg.value[1].absolute_indices;
      psg.value.pop();
      if (psg.passages[0].valid.messages.end_verse_not_exist != null) {
        delete psg.passages[0].valid.messages.end_verse_not_exist;
      }
      if (psg.passages[0].valid.messages.end_chapter_not_exist != null) {
        delete psg.passages[0].valid.messages.end_chapter_not_exist;
      }
      if (psg.passages[0].end.original_c != null) {
        delete psg.passages[0].end.original_c;
      }
      accum.push(psg);
      return [accum, context];
    };

    bcv_passage.prototype.sequence = function(passage, accum, context) {
      var k, l, len, len1, obj, psg, ref, ref1, ref2, ref3, sub_psg;
      passage.start_context = bcv_utils.shallow_clone(context);
      passage.passages = [];
      ref = passage.value;
      for (k = 0, len = ref.length; k < len; k++) {
        obj = ref[k];
        ref1 = this.handle_array(obj, [], context), (ref2 = ref1[0], psg = ref2[0]), context = ref1[1];
        ref3 = psg.passages;
        for (l = 0, len1 = ref3.length; l < len1; l++) {
          sub_psg = ref3[l];
          if (sub_psg.type == null) {
            sub_psg.type = psg.type;
          }
          if (sub_psg.absolute_indices == null) {
            sub_psg.absolute_indices = psg.absolute_indices;
          }
          if (psg.start_context.translations != null) {
            sub_psg.translations = psg.start_context.translations;
          }
          sub_psg.enclosed_absolute_indices = psg.type === "sequence_post_enclosed" ? psg.absolute_indices : [-1, -1];
          passage.passages.push(sub_psg);
        }
      }
      if (passage.absolute_indices == null) {
        if (passage.passages.length > 0 && passage.type === "sequence") {
          passage.absolute_indices = [passage.passages[0].absolute_indices[0], passage.passages[passage.passages.length - 1].absolute_indices[1]];
        } else {
          passage.absolute_indices = this.get_absolute_indices(passage.indices);
        }
      }
      accum.push(passage);
      return [accum, context];
    };

    bcv_passage.prototype.sequence_post_enclosed = function(passage, accum, context) {
      return this.sequence(passage, accum, context);
    };

    bcv_passage.prototype.v = function(passage, accum, context) {
      var c, no_c, ref, v, valid;
      v = passage.type === "integer" ? passage.value : this.pluck("integer", passage.value).value;
      passage.start_context = bcv_utils.shallow_clone(context);
      c = context.c != null ? context.c : 1;
      valid = this.validate_ref(passage.start_context.translations, {
        b: context.b,
        c: c,
        v: v
      });
      ref = this.fix_start_zeroes(valid, 0, v), no_c = ref[0], v = ref[1];
      passage.passages = [
        {
          start: {
            b: context.b,
            c: c,
            v: v
          },
          end: {
            b: context.b,
            c: c,
            v: v
          },
          valid: valid
        }
      ];
      if (passage.start_context.translations != null) {
        passage.passages[0].translations = passage.start_context.translations;
      }
      if (passage.absolute_indices == null) {
        passage.absolute_indices = this.get_absolute_indices(passage.indices);
      }
      accum.push(passage);
      context.v = v;
      return [accum, context];
    };

    bcv_passage.prototype.range = function(passage, accum, context) {
      var end, end_obj, ref, ref1, ref2, ref3, ref4, ref5, ref6, ref7, ref8, ref9, return_now, return_value, start, start_obj, valid;
      passage.start_context = bcv_utils.shallow_clone(context);
      ref = passage.value, start = ref[0], end = ref[1];
      ref1 = this.handle_obj(start, [], context), (ref2 = ref1[0], start = ref2[0]), context = ref1[1];
      if (end.type === "v" && ((start.type === "bc" && !((ref3 = start.passages) != null ? (ref4 = ref3[0]) != null ? (ref5 = ref4.valid) != null ? (ref6 = ref5.messages) != null ? ref6.start_chapter_not_exist_in_single_chapter_book : void 0 : void 0 : void 0 : void 0)) || start.type === "c") && this.options.end_range_digits_strategy === "verse") {
        passage.value[0] = start;
        return this.range_change_integer_end(passage, accum);
      }
      ref7 = this.handle_obj(end, [], context), (ref8 = ref7[0], end = ref8[0]), context = ref7[1];
      passage.value = [start, end];
      passage.indices = [start.indices[0], end.indices[1]];
      delete passage.absolute_indices;
      start_obj = {
        b: start.passages[0].start.b,
        c: start.passages[0].start.c,
        v: start.passages[0].start.v,
        type: start.type
      };
      end_obj = {
        b: end.passages[0].end.b,
        c: end.passages[0].end.c,
        v: end.passages[0].end.v,
        type: end.type
      };
      if (end.passages[0].valid.messages.start_chapter_is_zero) {
        end_obj.c = 0;
      }
      if (end.passages[0].valid.messages.start_verse_is_zero) {
        end_obj.v = 0;
      }
      valid = this.validate_ref(passage.start_context.translations, start_obj, end_obj);
      if (valid.valid) {
        ref9 = this.range_handle_valid(valid, passage, start, start_obj, end, end_obj, accum), return_now = ref9[0], return_value = ref9[1];
        if (return_now) {
          return return_value;
        }
      } else {
        return this.range_handle_invalid(valid, passage, start, start_obj, end, end_obj, accum);
      }
      if (passage.absolute_indices == null) {
        passage.absolute_indices = this.get_absolute_indices(passage.indices);
      }
      passage.passages = [
        {
          start: start_obj,
          end: end_obj,
          valid: valid
        }
      ];
      if (passage.start_context.translations != null) {
        passage.passages[0].translations = passage.start_context.translations;
      }
      if (start_obj.type === "b") {
        if (end_obj.type === "b") {
          passage.type = "b_range";
        } else {
          passage.type = "b_range_start";
        }
      } else if (end_obj.type === "b") {
        passage.type = "range_end_b";
      }
      accum.push(passage);
      return [accum, context];
    };

    bcv_passage.prototype.range_change_end = function(passage, accum, new_end) {
      var end, new_obj, ref, start;
      ref = passage.value, start = ref[0], end = ref[1];
      if (end.type === "integer") {
        end.original_value = end.value;
        end.value = new_end;
      } else if (end.type === "v") {
        new_obj = this.pluck("integer", end.value);
        new_obj.original_value = new_obj.value;
        new_obj.value = new_end;
      } else if (end.type === "cv") {
        new_obj = this.pluck("c", end.value);
        new_obj.original_value = new_obj.value;
        new_obj.value = new_end;
      }
      return this.handle_obj(passage, accum, passage.start_context);
    };

    bcv_passage.prototype.range_change_integer_end = function(passage, accum) {
      var end, ref, start;
      ref = passage.value, start = ref[0], end = ref[1];
      if (passage.original_type == null) {
        passage.original_type = passage.type;
      }
      if (passage.original_value == null) {
        passage.original_value = [start, end];
      }
      passage.type = start.type === "integer" ? "cv" : start.type + "v";
      if (start.type === "integer") {
        passage.value[0] = {
          type: "c",
          value: [start],
          indices: start.indices
        };
      }
      if (end.type === "integer") {
        passage.value[1] = {
          type: "v",
          value: [end],
          indices: end.indices
        };
      }
      return this.handle_obj(passage, accum, passage.start_context);
    };

    bcv_passage.prototype.range_check_new_end = function(translations, start_obj, end_obj, valid) {
      var new_end, new_valid, obj_to_validate, type;
      new_end = 0;
      type = null;
      if (valid.messages.end_chapter_before_start) {
        type = "c";
      } else if (valid.messages.end_verse_before_start) {
        type = "v";
      }
      if (type != null) {
        new_end = this.range_get_new_end_value(start_obj, end_obj, valid, type);
      }
      if (new_end > 0) {
        obj_to_validate = {
          b: end_obj.b,
          c: end_obj.c,
          v: end_obj.v
        };
        obj_to_validate[type] = new_end;
        new_valid = this.validate_ref(translations, obj_to_validate);
        if (!new_valid.valid) {
          new_end = 0;
        }
      }
      return new_end;
    };

    bcv_passage.prototype.range_end_b = function(passage, accum, context) {
      return this.range(passage, accum, context);
    };

    bcv_passage.prototype.range_get_new_end_value = function(start_obj, end_obj, valid, key) {
      var new_end;
      new_end = 0;
      if ((key === "c" && valid.messages.end_chapter_is_zero) || (key === "v" && valid.messages.end_verse_is_zero)) {
        return new_end;
      }
      if (start_obj[key] >= 10 && end_obj[key] < 10 && start_obj[key] - 10 * Math.floor(start_obj[key] / 10) < end_obj[key]) {
        new_end = end_obj[key] + 10 * Math.floor(start_obj[key] / 10);
      } else if (start_obj[key] >= 100 && end_obj[key] < 100 && start_obj[key] - 100 < end_obj[key]) {
        new_end = end_obj[key] + 100;
      }
      return new_end;
    };

    bcv_passage.prototype.range_handle_invalid = function(valid, passage, start, start_obj, end, end_obj, accum) {
      var new_end, ref, temp_valid, temp_value;
      if (valid.valid === false && (valid.messages.end_chapter_before_start || valid.messages.end_verse_before_start) && (end.type === "integer" || end.type === "v") || (valid.valid === false && valid.messages.end_chapter_before_start && end.type === "cv")) {
        new_end = this.range_check_new_end(passage.start_context.translations, start_obj, end_obj, valid);
        if (new_end > 0) {
          return this.range_change_end(passage, accum, new_end);
        }
      }
      if (this.options.end_range_digits_strategy === "verse" && (start_obj.v == null) && (end.type === "integer" || end.type === "v")) {
        temp_value = end.type === "v" ? this.pluck("integer", end.value) : end.value;
        temp_valid = this.validate_ref(passage.start_context.translations, {
          b: start_obj.b,
          c: start_obj.c,
          v: temp_value
        });
        if (temp_valid.valid) {
          return this.range_change_integer_end(passage, accum);
        }
      }
      if (passage.original_type == null) {
        passage.original_type = passage.type;
      }
      passage.type = "sequence";
      ref = [[start, end], [[start], [end]]], passage.original_value = ref[0], passage.value = ref[1];
      return this.sequence(passage, accum, passage.start_context);
    };

    bcv_passage.prototype.range_handle_valid = function(valid, passage, start, start_obj, end, end_obj, accum) {
      var temp_valid, temp_value;
      if (valid.messages.end_chapter_not_exist && this.options.end_range_digits_strategy === "verse" && (start_obj.v == null) && (end.type === "integer" || end.type === "v") && this.options.passage_existence_strategy.indexOf("v") >= 0) {
        temp_value = end.type === "v" ? this.pluck("integer", end.value) : end.value;
        temp_valid = this.validate_ref(passage.start_context.translations, {
          b: start_obj.b,
          c: start_obj.c,
          v: temp_value
        });
        if (temp_valid.valid) {
          return [true, this.range_change_integer_end(passage, accum)];
        }
      }
      this.range_validate(valid, start_obj, end_obj, passage);
      return [false, null];
    };

    bcv_passage.prototype.range_validate = function(valid, start_obj, end_obj, passage) {
      var ref;
      if (valid.messages.end_chapter_not_exist || valid.messages.end_chapter_not_exist_in_single_chapter_book) {
        end_obj.original_c = end_obj.c;
        end_obj.c = valid.messages.end_chapter_not_exist ? valid.messages.end_chapter_not_exist : valid.messages.end_chapter_not_exist_in_single_chapter_book;
        if (end_obj.v != null) {
          end_obj.v = this.validate_ref(passage.start_context.translations, {
            b: end_obj.b,
            c: end_obj.c,
            v: 999
          }).messages.end_verse_not_exist;
          delete valid.messages.end_verse_is_zero;
        }
      } else if (valid.messages.end_verse_not_exist) {
        end_obj.original_v = end_obj.v;
        end_obj.v = valid.messages.end_verse_not_exist;
      }
      if (valid.messages.end_verse_is_zero && this.options.zero_verse_strategy !== "allow") {
        end_obj.v = valid.messages.end_verse_is_zero;
      }
      if (valid.messages.end_chapter_is_zero) {
        end_obj.c = valid.messages.end_chapter_is_zero;
      }
      ref = this.fix_start_zeroes(valid, start_obj.c, start_obj.v), start_obj.c = ref[0], start_obj.v = ref[1];
      return true;
    };

    bcv_passage.prototype.translation_sequence = function(passage, accum, context) {
      var k, l, len, len1, ref, translation, translations, val;
      passage.start_context = bcv_utils.shallow_clone(context);
      translations = [];
      translations.push({
        translation: this.books[passage.value[0].value].parsed
      });
      ref = passage.value[1];
      for (k = 0, len = ref.length; k < len; k++) {
        val = ref[k];
        val = this.books[this.pluck("translation", val).value].parsed;
        if (val != null) {
          translations.push({
            translation: val
          });
        }
      }
      for (l = 0, len1 = translations.length; l < len1; l++) {
        translation = translations[l];
        if (this.translations.aliases[translation.translation] != null) {
          translation.alias = this.translations.aliases[translation.translation].alias;
          translation.osis = this.translations.aliases[translation.translation].osis || translation.translation.toUpperCase();
        } else {
          translation.alias = "default";
          translation.osis = translation.translation.toUpperCase();
        }
      }
      if (accum.length > 0) {
        context = this.translation_sequence_apply(accum, translations);
      }
      if (passage.absolute_indices == null) {
        passage.absolute_indices = this.get_absolute_indices(passage.indices);
      }
      accum.push(passage);
      this.reset_context(context, ["translations"]);
      return [accum, context];
    };

    bcv_passage.prototype.translation_sequence_apply = function(accum, translations) {
      var context, i, k, new_accum, ref, ref1, use_i;
      use_i = 0;
      for (i = k = ref = accum.length - 1; ref <= 0 ? k <= 0 : k >= 0; i = ref <= 0 ? ++k : --k) {
        if (accum[i].original_type != null) {
          accum[i].type = accum[i].original_type;
        }
        if (accum[i].original_value != null) {
          accum[i].value = accum[i].original_value;
        }
        if (accum[i].type !== "translation_sequence") {
          continue;
        }
        use_i = i + 1;
        break;
      }
      if (use_i < accum.length) {
        accum[use_i].start_context.translations = translations;
        ref1 = this.handle_array(accum.slice(use_i), [], accum[use_i].start_context), new_accum = ref1[0], context = ref1[1];
      } else {
        context = bcv_utils.shallow_clone(accum[accum.length - 1].start_context);
      }
      return context;
    };

    bcv_passage.prototype.pluck = function(type, passages) {
      var k, len, passage;
      for (k = 0, len = passages.length; k < len; k++) {
        passage = passages[k];
        if (!((passage != null) && (passage.type != null) && passage.type === type)) {
          continue;
        }
        if (type === "c" || type === "v") {
          return this.pluck("integer", passage.value);
        }
        return passage;
      }
      return null;
    };

    bcv_passage.prototype.pluck_last_recursively = function(type, passages) {
      var k, passage, value;
      for (k = passages.length - 1; k >= 0; k += -1) {
        passage = passages[k];
        if (!((passage != null) && (passage.type != null))) {
          continue;
        }
        if (passage.type === type) {
          return this.pluck(type, [passage]);
        }
        value = this.pluck_last_recursively(type, passage.value);
        if (value != null) {
          return value;
        }
      }
      return null;
    };

    bcv_passage.prototype.set_context_from_object = function(context, keys, obj) {
      var k, len, results, type;
      results = [];
      for (k = 0, len = keys.length; k < len; k++) {
        type = keys[k];
        if (obj[type] == null) {
          continue;
        }
        results.push(context[type] = obj[type]);
      }
      return results;
    };

    bcv_passage.prototype.reset_context = function(context, keys) {
      var k, len, results, type;
      results = [];
      for (k = 0, len = keys.length; k < len; k++) {
        type = keys[k];
        results.push(delete context[type]);
      }
      return results;
    };

    bcv_passage.prototype.fix_start_zeroes = function(valid, c, v) {
      if (valid.messages.start_chapter_is_zero && this.options.zero_chapter_strategy === "upgrade") {
        c = valid.messages.start_chapter_is_zero;
      }
      if (valid.messages.start_verse_is_zero && this.options.zero_verse_strategy === "upgrade") {
        v = valid.messages.start_verse_is_zero;
      }
      return [c, v];
    };

    bcv_passage.prototype.calculate_indices = function(match, adjust) {
      var character, end_index, indices, k, l, len, len1, len2, m, match_index, part, part_length, parts, ref, switch_type, temp;
      switch_type = "book";
      indices = [];
      match_index = 0;
      adjust = parseInt(adjust, 10);
      parts = [match];
      ref = ["\x1e", "\x1f"];
      for (k = 0, len = ref.length; k < len; k++) {
        character = ref[k];
        temp = [];
        for (l = 0, len1 = parts.length; l < len1; l++) {
          part = parts[l];
          temp = temp.concat(part.split(character));
        }
        parts = temp;
      }
      for (m = 0, len2 = parts.length; m < len2; m++) {
        part = parts[m];
        switch_type = switch_type === "book" ? "rest" : "book";
        part_length = part.length;
        if (part_length === 0) {
          continue;
        }
        if (switch_type === "book") {
          part = part.replace(/\/\d+$/, "");
          end_index = match_index + part_length;
          if (indices.length > 0 && indices[indices.length - 1].index === adjust) {
            indices[indices.length - 1].end = end_index;
          } else {
            indices.push({
              start: match_index,
              end: end_index,
              index: adjust
            });
          }
          match_index += part_length + 2;
          adjust = this.books[part].start_index + this.books[part].value.length - match_index;
          indices.push({
            start: end_index + 1,
            end: end_index + 1,
            index: adjust
          });
        } else {
          end_index = match_index + part_length - 1;
          if (indices.length > 0 && indices[indices.length - 1].index === adjust) {
            indices[indices.length - 1].end = end_index;
          } else {
            indices.push({
              start: match_index,
              end: end_index,
              index: adjust
            });
          }
          match_index += part_length;
        }
      }
      return indices;
    };

    bcv_passage.prototype.get_absolute_indices = function(arg1) {
      var end, end_out, index, k, len, ref, start, start_out;
      start = arg1[0], end = arg1[1];
      start_out = null;
      end_out = null;
      ref = this.indices;
      for (k = 0, len = ref.length; k < len; k++) {
        index = ref[k];
        if (start_out === null && (index.start <= start && start <= index.end)) {
          start_out = start + index.index;
        }
        if ((index.start <= end && end <= index.end)) {
          end_out = end + index.index + 1;
          break;
        }
      }
      return [start_out, end_out];
    };

    bcv_passage.prototype.validate_ref = function(translations, start, end) {
      var k, len, messages, temp_valid, translation, valid;
      if (!((translations != null) && translations.length > 0)) {
        translations = [
          {
            translation: "default",
            osis: "",
            alias: "default"
          }
        ];
      }
      valid = false;
      messages = {};
      for (k = 0, len = translations.length; k < len; k++) {
        translation = translations[k];
        if (translation.alias == null) {
          translation.alias = "default";
        }
        if (translation.alias == null) {
          if (messages.translation_invalid == null) {
            messages.translation_invalid = [];
          }
          messages.translation_invalid.push(translation);
          continue;
        }
        if (this.translations.aliases[translation.alias] == null) {
          translation.alias = "default";
          if (messages.translation_unknown == null) {
            messages.translation_unknown = [];
          }
          messages.translation_unknown.push(translation);
        }
        temp_valid = this.validate_start_ref(translation.alias, start, messages)[0];
        if (end) {
          temp_valid = this.validate_end_ref(translation.alias, start, end, temp_valid, messages)[0];
        }
        if (temp_valid === true) {
          valid = true;
        }
      }
      return {
        valid: valid,
        messages: messages
      };
    };

    bcv_passage.prototype.validate_start_ref = function(translation, start, messages) {
      var ref, ref1, translation_order, valid;
      valid = true;
      if (translation !== "default" && (((ref = this.translations[translation]) != null ? ref.chapters[start.b] : void 0) == null)) {
        this.promote_book_to_translation(start.b, translation);
      }
      translation_order = ((ref1 = this.translations[translation]) != null ? ref1.order : void 0) != null ? translation : "default";
      if (start.v != null) {
        start.v = parseInt(start.v, 10);
      }
      if (this.translations[translation_order].order[start.b] != null) {
        if (start.c == null) {
          start.c = 1;
        }
        start.c = parseInt(start.c, 10);
        if (isNaN(start.c)) {
          valid = false;
          messages.start_chapter_not_numeric = true;
          return [valid, messages];
        }
        if (start.c === 0) {
          messages.start_chapter_is_zero = 1;
          if (this.options.zero_chapter_strategy === "error") {
            valid = false;
          } else {
            start.c = 1;
          }
        }
        if ((start.v != null) && start.v === 0) {
          messages.start_verse_is_zero = 1;
          if (this.options.zero_verse_strategy === "error") {
            valid = false;
          } else if (this.options.zero_verse_strategy === "upgrade") {
            start.v = 1;
          }
        }
        if (start.c > 0 && (this.translations[translation].chapters[start.b][start.c - 1] != null)) {
          if (start.v != null) {
            if (isNaN(start.v)) {
              valid = false;
              messages.start_verse_not_numeric = true;
            } else if (start.v > this.translations[translation].chapters[start.b][start.c - 1]) {
              if (this.options.passage_existence_strategy.indexOf("v") >= 0) {
                valid = false;
                messages.start_verse_not_exist = this.translations[translation].chapters[start.b][start.c - 1];
              }
            }
          } else if (start.c === 1 && this.options.single_chapter_1_strategy === "verse" && this.translations[translation].chapters[start.b].length === 1) {
            messages.start_chapter_1 = 1;
          }
        } else {
          if (start.c !== 1 && this.translations[translation].chapters[start.b].length === 1) {
            valid = false;
            messages.start_chapter_not_exist_in_single_chapter_book = 1;
          } else if (start.c > 0 && this.options.passage_existence_strategy.indexOf("c") >= 0) {
            valid = false;
            messages.start_chapter_not_exist = this.translations[translation].chapters[start.b].length;
          }
        }
      } else if (start.b == null) {
        valid = false;
        messages.start_book_not_defined = true;
      } else {
        if (this.options.passage_existence_strategy.indexOf("b") >= 0) {
          valid = false;
        }
        messages.start_book_not_exist = true;
      }
      return [valid, messages];
    };

    bcv_passage.prototype.validate_end_ref = function(translation, start, end, valid, messages) {
      var ref, translation_order;
      translation_order = ((ref = this.translations[translation]) != null ? ref.order : void 0) != null ? translation : "default";
      if (end.c != null) {
        end.c = parseInt(end.c, 10);
        if (isNaN(end.c)) {
          valid = false;
          messages.end_chapter_not_numeric = true;
        } else if (end.c === 0) {
          messages.end_chapter_is_zero = 1;
          if (this.options.zero_chapter_strategy === "error") {
            valid = false;
          } else {
            end.c = 1;
          }
        }
      }
      if (end.v != null) {
        end.v = parseInt(end.v, 10);
        if (isNaN(end.v)) {
          valid = false;
          messages.end_verse_not_numeric = true;
        } else if (end.v === 0) {
          messages.end_verse_is_zero = 1;
          if (this.options.zero_verse_strategy === "error") {
            valid = false;
          } else if (this.options.zero_verse_strategy === "upgrade") {
            end.v = 1;
          }
        }
      }
      if (this.translations[translation_order].order[end.b] != null) {
        if ((end.c == null) && this.translations[translation].chapters[end.b].length === 1) {
          end.c = 1;
        }
        if ((this.translations[translation_order].order[start.b] != null) && this.translations[translation_order].order[start.b] > this.translations[translation_order].order[end.b]) {
          if (this.options.passage_existence_strategy.indexOf("b") >= 0) {
            valid = false;
          }
          messages.end_book_before_start = true;
        }
        if (start.b === end.b && (end.c != null) && !isNaN(end.c)) {
          if (start.c == null) {
            start.c = 1;
          }
          if (!isNaN(parseInt(start.c, 10)) && start.c > end.c) {
            valid = false;
            messages.end_chapter_before_start = true;
          } else if (start.c === end.c && (end.v != null) && !isNaN(end.v)) {
            if (start.v == null) {
              start.v = 1;
            }
            if (!isNaN(parseInt(start.v, 10)) && start.v > end.v) {
              valid = false;
              messages.end_verse_before_start = true;
            }
          }
        }
        if ((end.c != null) && !isNaN(end.c)) {
          if (this.translations[translation].chapters[end.b][end.c - 1] == null) {
            if (this.translations[translation].chapters[end.b].length === 1) {
              messages.end_chapter_not_exist_in_single_chapter_book = 1;
            } else if (end.c > 0 && this.options.passage_existence_strategy.indexOf("c") >= 0) {
              messages.end_chapter_not_exist = this.translations[translation].chapters[end.b].length;
            }
          }
        }
        if ((end.v != null) && !isNaN(end.v)) {
          if (end.c == null) {
            end.c = this.translations[translation].chapters[end.b].length;
          }
          if (end.v > this.translations[translation].chapters[end.b][end.c - 1] && this.options.passage_existence_strategy.indexOf("v") >= 0) {
            messages.end_verse_not_exist = this.translations[translation].chapters[end.b][end.c - 1];
          }
        }
      } else {
        valid = false;
        messages.end_book_not_exist = true;
      }
      return [valid, messages];
    };

    bcv_passage.prototype.promote_book_to_translation = function(book, translation) {
      var base, base1;
      if ((base = this.translations)[translation] == null) {
        base[translation] = {};
      }
      if ((base1 = this.translations[translation]).chapters == null) {
        base1.chapters = {};
      }
      if (this.translations[translation].chapters[book] == null) {
        return this.translations[translation].chapters[book] = bcv_utils.shallow_clone_array(this.translations["default"].chapters[book]);
      }
    };

    return bcv_passage;

  })();

  bcv_utils = {
    shallow_clone: function(obj) {
      var key, out, val;
      if (obj == null) {
        return obj;
      }
      out = {};
      for (key in obj) {
        if (!hasProp.call(obj, key)) continue;
        val = obj[key];
        out[key] = val;
      }
      return out;
    },
    shallow_clone_array: function(arr) {
      var i, k, out, ref;
      if (arr == null) {
        return arr;
      }
      out = [];
      for (i = k = 0, ref = arr.length; 0 <= ref ? k <= ref : k >= ref; i = 0 <= ref ? ++k : --k) {
        if (typeof arr[i] !== "undefined") {
          out[i] = arr[i];
        }
      }
      return out;
    }
  };

  bcv_parser.prototype.regexps.translations = /(?:(?:KM|YC(?:1998|200[189])?|T(?:KK|SV|C)|HAD\[İI\]|C(?:AN|OS)))\b/gi;

  bcv_parser.prototype.translations = {
    aliases: {
      yc1998: {
        osis: "YC",
        alias: "default"
      },
      yc2001: {
        osis: "YC",
        alias: "default"
      },
      yc2008: {
        osis: "YC",
        alias: "default"
      },
      yc2009: {
        osis: "YC",
        alias: "default"
      },
      tkk: {
        osis: "YC",
        alias: "default"
      },
      cos: {
        osis: "TC",
        alias: "default"
      },
      "default": {
        osis: "",
        alias: "default"
      }
    },
    alternates: {},
    "default": {
      order: {
        "Gen": 1,
        "Exod": 2,
        "Lev": 3,
        "Num": 4,
        "Deut": 5,
        "Josh": 6,
        "Judg": 7,
        "Ruth": 8,
        "1Sam": 9,
        "2Sam": 10,
        "1Kgs": 11,
        "2Kgs": 12,
        "1Chr": 13,
        "2Chr": 14,
        "Ezra": 15,
        "Neh": 16,
        "Esth": 17,
        "Job": 18,
        "Ps": 19,
        "Prov": 20,
        "Eccl": 21,
        "Song": 22,
        "Isa": 23,
        "Jer": 24,
        "Lam": 25,
        "Ezek": 26,
        "Dan": 27,
        "Hos": 28,
        "Joel": 29,
        "Amos": 30,
        "Obad": 31,
        "Jonah": 32,
        "Mic": 33,
        "Nah": 34,
        "Hab": 35,
        "Zeph": 36,
        "Hag": 37,
        "Zech": 38,
        "Mal": 39,
        "Matt": 40,
        "Mark": 41,
        "Luke": 42,
        "John": 43,
        "Acts": 44,
        "Rom": 45,
        "1Cor": 46,
        "2Cor": 47,
        "Gal": 48,
        "Eph": 49,
        "Phil": 50,
        "Col": 51,
        "1Thess": 52,
        "2Thess": 53,
        "1Tim": 54,
        "2Tim": 55,
        "Titus": 56,
        "Phlm": 57,
        "Heb": 58,
        "Jas": 59,
        "1Pet": 60,
        "2Pet": 61,
        "1John": 62,
        "2John": 63,
        "3John": 64,
        "Jude": 65,
        "Rev": 66,
        "Tob": 67,
        "Jdt": 68,
        "GkEsth": 69,
        "Wis": 70,
        "Sir": 71,
        "Bar": 72,
        "PrAzar": 73,
        "Sus": 74,
        "Bel": 75,
        "SgThree": 76,
        "EpJer": 77,
        "1Macc": 78,
        "2Macc": 79,
        "3Macc": 80,
        "4Macc": 81,
        "1Esd": 82,
        "2Esd": 83,
        "PrMan": 84
      },
      chapters: {
        "Gen": [31, 25, 24, 26, 32, 22, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 38, 18, 34, 24, 20, 67, 34, 35, 46, 22, 35, 43, 55, 32, 20, 31, 29, 43, 36, 30, 23, 23, 57, 38, 34, 34, 28, 34, 31, 22, 33, 26],
        "Exod": [22, 25, 22, 31, 23, 30, 25, 32, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 36, 31, 33, 18, 40, 37, 21, 43, 46, 38, 18, 35, 23, 35, 35, 38, 29, 31, 43, 38],
        "Lev": [17, 16, 17, 35, 19, 30, 38, 36, 24, 20, 47, 8, 59, 57, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 46, 34],
        "Num": [54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 35, 16, 33, 45, 41, 50, 13, 32, 22, 29, 35, 41, 30, 25, 18, 65, 23, 31, 40, 16, 54, 42, 56, 29, 34, 13],
        "Deut": [46, 37, 29, 49, 33, 25, 26, 20, 29, 22, 32, 32, 18, 29, 23, 22, 20, 22, 21, 20, 23, 30, 25, 22, 19, 19, 26, 68, 29, 20, 30, 52, 29, 12],
        "Josh": [18, 24, 17, 24, 15, 27, 26, 35, 27, 43, 23, 24, 33, 15, 63, 10, 18, 28, 51, 9, 45, 34, 16, 33],
        "Judg": [36, 23, 31, 24, 31, 40, 25, 35, 57, 18, 40, 15, 25, 20, 20, 31, 13, 31, 30, 48, 25],
        "Ruth": [22, 23, 18, 22],
        "1Sam": [28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 42, 15, 23, 29, 22, 44, 25, 12, 25, 11, 31, 13],
        "2Sam": [27, 32, 39, 12, 25, 23, 29, 18, 13, 19, 27, 31, 39, 33, 37, 23, 29, 33, 43, 26, 22, 51, 39, 25],
        "1Kgs": [53, 46, 28, 34, 18, 38, 51, 66, 28, 29, 43, 33, 34, 31, 34, 34, 24, 46, 21, 43, 29, 53],
        "2Kgs": [18, 25, 27, 44, 27, 33, 20, 29, 37, 36, 21, 21, 25, 29, 38, 20, 41, 37, 37, 21, 26, 20, 37, 20, 30],
        "1Chr": [54, 55, 24, 43, 26, 81, 40, 40, 44, 14, 47, 40, 14, 17, 29, 43, 27, 17, 19, 8, 30, 19, 32, 31, 31, 32, 34, 21, 30],
        "2Chr": [17, 18, 17, 22, 14, 42, 22, 18, 31, 19, 23, 16, 22, 15, 19, 14, 19, 34, 11, 37, 20, 12, 21, 27, 28, 23, 9, 27, 36, 27, 21, 33, 25, 33, 27, 23],
        "Ezra": [11, 70, 13, 24, 17, 22, 28, 36, 15, 44],
        "Neh": [11, 20, 32, 23, 19, 19, 73, 18, 38, 39, 36, 47, 31],
        "Esth": [22, 23, 15, 17, 14, 14, 10, 17, 32, 3],
        "Job": [22, 13, 26, 21, 27, 30, 21, 22, 35, 22, 20, 25, 28, 22, 35, 22, 16, 21, 29, 29, 34, 30, 17, 25, 6, 14, 23, 28, 25, 31, 40, 22, 33, 37, 16, 33, 24, 41, 30, 24, 34, 17],
        "Ps": [6, 12, 8, 8, 12, 10, 17, 9, 20, 18, 7, 8, 6, 7, 5, 11, 15, 50, 14, 9, 13, 31, 6, 10, 22, 12, 14, 9, 11, 12, 24, 11, 22, 22, 28, 12, 40, 22, 13, 17, 13, 11, 5, 26, 17, 11, 9, 14, 20, 23, 19, 9, 6, 7, 23, 13, 11, 11, 17, 12, 8, 12, 11, 10, 13, 20, 7, 35, 36, 5, 24, 20, 28, 23, 10, 12, 20, 72, 13, 19, 16, 8, 18, 12, 13, 17, 7, 18, 52, 17, 16, 15, 5, 23, 11, 13, 12, 9, 9, 5, 8, 28, 22, 35, 45, 48, 43, 13, 31, 7, 10, 10, 9, 8, 18, 19, 2, 29, 176, 7, 8, 9, 4, 8, 5, 6, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9, 8, 24, 13, 10, 7, 12, 15, 21, 10, 20, 14, 9, 6],
        "Prov": [33, 22, 35, 27, 23, 35, 27, 36, 18, 32, 31, 28, 25, 35, 33, 33, 28, 24, 29, 30, 31, 29, 35, 34, 28, 28, 27, 28, 27, 33, 31],
        "Eccl": [18, 26, 22, 16, 20, 12, 29, 17, 18, 20, 10, 14],
        "Song": [17, 17, 11, 16, 16, 13, 13, 14],
        "Isa": [31, 22, 26, 6, 30, 13, 25, 22, 21, 34, 16, 6, 22, 32, 9, 14, 14, 7, 25, 6, 17, 25, 18, 23, 12, 21, 13, 29, 24, 33, 9, 20, 24, 17, 10, 22, 38, 22, 8, 31, 29, 25, 28, 28, 25, 13, 15, 22, 26, 11, 23, 15, 12, 17, 13, 12, 21, 14, 21, 22, 11, 12, 19, 12, 25, 24],
        "Jer": [19, 37, 25, 31, 31, 30, 34, 22, 26, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 40, 10, 38, 24, 22, 17, 32, 24, 40, 44, 26, 22, 19, 32, 21, 28, 18, 16, 18, 22, 13, 30, 5, 28, 7, 47, 39, 46, 64, 34],
        "Lam": [22, 22, 66, 22, 22],
        "Ezek": [28, 10, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 49, 32, 31, 49, 27, 17, 21, 36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35],
        "Dan": [21, 49, 30, 37, 31, 28, 28, 27, 27, 21, 45, 13],
        "Hos": [11, 23, 5, 19, 15, 11, 16, 14, 17, 15, 12, 14, 16, 9],
        "Joel": [20, 32, 21],
        "Amos": [15, 16, 15, 13, 27, 14, 17, 14, 15],
        "Obad": [21],
        "Jonah": [17, 10, 10, 11],
        "Mic": [16, 13, 12, 13, 15, 16, 20],
        "Nah": [15, 13, 19],
        "Hab": [17, 20, 19],
        "Zeph": [18, 15, 20],
        "Hag": [15, 23],
        "Zech": [21, 13, 10, 14, 11, 15, 14, 23, 17, 12, 17, 14, 9, 21],
        "Mal": [14, 17, 18, 6],
        "Matt": [25, 23, 17, 25, 48, 34, 29, 34, 38, 42, 30, 50, 58, 36, 39, 28, 27, 35, 30, 34, 46, 46, 39, 51, 46, 75, 66, 20],
        "Mark": [45, 28, 35, 41, 43, 56, 37, 38, 50, 52, 33, 44, 37, 72, 47, 20],
        "Luke": [80, 52, 38, 44, 39, 49, 50, 56, 62, 42, 54, 59, 35, 35, 32, 31, 37, 43, 48, 47, 38, 71, 56, 53],
        "John": [51, 25, 36, 54, 47, 71, 53, 59, 41, 42, 57, 50, 38, 31, 27, 33, 26, 40, 42, 31, 25],
        "Acts": [26, 47, 26, 37, 42, 15, 60, 40, 43, 48, 30, 25, 52, 28, 41, 40, 34, 28, 41, 38, 40, 30, 35, 27, 27, 32, 44, 31],
        "Rom": [32, 29, 31, 25, 21, 23, 25, 39, 33, 21, 36, 21, 14, 23, 33, 27],
        "1Cor": [31, 16, 23, 21, 13, 20, 40, 13, 27, 33, 34, 31, 13, 40, 58, 24],
        "2Cor": [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 14],
        "Gal": [24, 21, 29, 31, 26, 18],
        "Eph": [23, 22, 21, 32, 33, 24],
        "Phil": [30, 30, 21, 23],
        "Col": [29, 23, 25, 18],
        "1Thess": [10, 20, 13, 18, 28],
        "2Thess": [12, 17, 18],
        "1Tim": [20, 15, 16, 16, 25, 21],
        "2Tim": [18, 26, 17, 22],
        "Titus": [16, 15, 15],
        "Phlm": [25],
        "Heb": [14, 18, 19, 16, 14, 20, 28, 13, 28, 39, 40, 29, 25],
        "Jas": [27, 26, 18, 17, 20],
        "1Pet": [25, 25, 22, 19, 14],
        "2Pet": [21, 22, 18],
        "1John": [10, 29, 24, 21, 21],
        "2John": [13],
        "3John": [15],
        "Jude": [25],
        "Rev": [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 17, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21],
        "Tob": [22, 14, 17, 21, 22, 18, 16, 21, 6, 13, 18, 22, 17, 15],
        "Jdt": [16, 28, 10, 15, 24, 21, 32, 36, 14, 23, 23, 20, 20, 19, 14, 25],
        "GkEsth": [22, 23, 15, 17, 14, 14, 10, 17, 32, 13, 12, 6, 18, 19, 16, 24],
        "Wis": [16, 24, 19, 20, 23, 25, 30, 21, 18, 21, 26, 27, 19, 31, 19, 29, 21, 25, 22],
        "Sir": [30, 18, 31, 31, 15, 37, 36, 19, 18, 31, 34, 18, 26, 27, 20, 30, 32, 33, 30, 31, 28, 27, 27, 34, 26, 29, 30, 26, 28, 25, 31, 24, 33, 31, 26, 31, 31, 34, 35, 30, 22, 25, 33, 23, 26, 20, 25, 25, 16, 29, 30],
        "Bar": [22, 35, 37, 37, 9],
        "PrAzar": [68],
        "Sus": [64],
        "Bel": [42],
        "SgThree": [39],
        "EpJer": [73],
        "1Macc": [64, 70, 60, 61, 68, 63, 50, 32, 73, 89, 74, 53, 53, 49, 41, 24],
        "2Macc": [36, 32, 40, 50, 27, 31, 42, 36, 29, 38, 38, 45, 26, 46, 39],
        "3Macc": [29, 33, 30, 21, 51, 41, 23],
        "4Macc": [35, 24, 21, 26, 38, 35, 23, 29, 32, 21, 27, 19, 27, 20, 32, 25, 24, 24],
        "1Esd": [58, 30, 24, 63, 73, 34, 15, 96, 55],
        "2Esd": [40, 48, 36, 52, 56, 59, 70, 63, 47, 59, 46, 51, 58, 48, 63, 78],
        "PrMan": [15],
        "Ps151": [7]
      }
    },
    vulgate: {
      chapters: {
        "Gen": [31, 25, 24, 26, 32, 22, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 38, 18, 34, 24, 20, 67, 34, 35, 46, 22, 35, 43, 55, 32, 20, 31, 29, 43, 36, 30, 23, 23, 57, 38, 34, 34, 28, 34, 31, 22, 32, 25],
        "Exod": [22, 25, 22, 31, 23, 30, 25, 32, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 36, 31, 33, 18, 40, 37, 21, 43, 46, 38, 18, 35, 23, 35, 35, 38, 29, 31, 43, 36],
        "Lev": [17, 16, 17, 35, 19, 30, 38, 36, 24, 20, 47, 8, 59, 57, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 45, 34],
        "Num": [54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 34, 15, 34, 45, 41, 50, 13, 32, 22, 30, 35, 41, 30, 25, 18, 65, 23, 31, 39, 17, 54, 42, 56, 29, 34, 13],
        "Josh": [18, 24, 17, 25, 16, 27, 26, 35, 27, 44, 23, 24, 33, 15, 63, 10, 18, 28, 51, 9, 43, 34, 16, 33],
        "Judg": [36, 23, 31, 24, 32, 40, 25, 35, 57, 18, 40, 15, 25, 20, 20, 31, 13, 31, 30, 48, 24],
        "1Sam": [28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 43, 15, 23, 28, 23, 44, 25, 12, 25, 11, 31, 13],
        "1Kgs": [53, 46, 28, 34, 18, 38, 51, 66, 28, 29, 43, 33, 34, 31, 34, 34, 24, 46, 21, 43, 29, 54],
        "1Chr": [54, 55, 24, 43, 26, 81, 40, 40, 44, 14, 46, 40, 14, 17, 29, 43, 27, 17, 19, 7, 30, 19, 32, 31, 31, 32, 34, 21, 30],
        "Neh": [11, 20, 31, 23, 19, 19, 73, 18, 38, 39, 36, 46, 31],
        "Job": [22, 13, 26, 21, 27, 30, 21, 22, 35, 22, 20, 25, 28, 22, 35, 23, 16, 21, 29, 29, 34, 30, 17, 25, 6, 14, 23, 28, 25, 31, 40, 22, 33, 37, 16, 33, 24, 41, 35, 28, 25, 16],
        "Ps": [6, 13, 9, 10, 13, 11, 18, 10, 39, 8, 9, 6, 7, 5, 10, 15, 51, 15, 10, 14, 32, 6, 10, 22, 12, 14, 9, 11, 13, 25, 11, 22, 23, 28, 13, 40, 23, 14, 18, 14, 12, 5, 26, 18, 12, 10, 15, 21, 23, 21, 11, 7, 9, 24, 13, 12, 12, 18, 14, 9, 13, 12, 11, 14, 20, 8, 36, 37, 6, 24, 20, 28, 23, 11, 13, 21, 72, 13, 20, 17, 8, 19, 13, 14, 17, 7, 19, 53, 17, 16, 16, 5, 23, 11, 13, 12, 9, 9, 5, 8, 29, 22, 35, 45, 48, 43, 14, 31, 7, 10, 10, 9, 26, 9, 10, 2, 29, 176, 7, 8, 9, 4, 8, 5, 6, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9, 8, 24, 14, 10, 8, 12, 15, 21, 10, 11, 9, 14, 9, 6],
        "Eccl": [18, 26, 22, 17, 19, 11, 30, 17, 18, 20, 10, 14],
        "Song": [16, 17, 11, 16, 17, 12, 13, 14],
        "Jer": [19, 37, 25, 31, 31, 30, 34, 22, 26, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 40, 10, 38, 24, 22, 17, 32, 24, 40, 44, 26, 22, 19, 32, 20, 28, 18, 16, 18, 22, 13, 30, 5, 28, 7, 47, 39, 46, 64, 34],
        "Ezek": [28, 9, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 49, 32, 31, 49, 27, 17, 21, 36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35],
        "Dan": [21, 49, 100, 34, 31, 28, 28, 27, 27, 21, 45, 13, 65, 42],
        "Hos": [11, 24, 5, 19, 15, 11, 16, 14, 17, 15, 12, 14, 15, 10],
        "Amos": [15, 16, 15, 13, 27, 15, 17, 14, 14],
        "Jonah": [16, 11, 10, 11],
        "Mic": [16, 13, 12, 13, 14, 16, 20],
        "Hag": [14, 24],
        "Matt": [25, 23, 17, 25, 48, 34, 29, 34, 38, 42, 30, 50, 58, 36, 39, 28, 26, 35, 30, 34, 46, 46, 39, 51, 46, 75, 66, 20],
        "Mark": [45, 28, 35, 40, 43, 56, 37, 39, 49, 52, 33, 44, 37, 72, 47, 20],
        "John": [51, 25, 36, 54, 47, 72, 53, 59, 41, 42, 57, 50, 38, 31, 27, 33, 26, 40, 42, 31, 25],
        "Acts": [26, 47, 26, 37, 42, 15, 59, 40, 43, 48, 30, 25, 52, 27, 41, 40, 34, 28, 40, 38, 40, 30, 35, 27, 27, 32, 44, 31],
        "2Cor": [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 13],
        "Rev": [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 18, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21],
        "Tob": [25, 23, 25, 23, 28, 22, 20, 24, 12, 13, 21, 22, 23, 17],
        "Jdt": [12, 18, 15, 17, 29, 21, 25, 34, 19, 20, 21, 20, 31, 18, 15, 31],
        "Wis": [16, 25, 19, 20, 24, 27, 30, 21, 19, 21, 27, 27, 19, 31, 19, 29, 20, 25, 20],
        "Sir": [40, 23, 34, 36, 18, 37, 40, 22, 25, 34, 36, 19, 32, 27, 22, 31, 31, 33, 28, 33, 31, 33, 38, 47, 36, 28, 33, 30, 35, 27, 42, 28, 33, 31, 26, 28, 34, 39, 41, 32, 28, 26, 37, 27, 31, 23, 31, 28, 19, 31, 38, 13],
        "Bar": [22, 35, 38, 37, 9, 72],
        "1Macc": [67, 70, 60, 61, 68, 63, 50, 32, 73, 89, 74, 54, 54, 49, 41, 24],
        "2Macc": [36, 33, 40, 50, 27, 31, 42, 36, 29, 38, 38, 46, 26, 46, 40]
      }
    },
    ceb: {
      chapters: {
        "2Cor": [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 13],
        "Rev": [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 18, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21],
        "Tob": [22, 14, 17, 21, 22, 18, 16, 21, 6, 13, 18, 22, 18, 15],
        "PrAzar": [67],
        "EpJer": [72],
        "1Esd": [55, 26, 24, 63, 71, 33, 15, 92, 55]
      }
    },
    kjv: {
      chapters: {
        "3John": [14]
      }
    },
    nab: {
      order: {
        "Gen": 1,
        "Exod": 2,
        "Lev": 3,
        "Num": 4,
        "Deut": 5,
        "Josh": 6,
        "Judg": 7,
        "Ruth": 8,
        "1Sam": 9,
        "2Sam": 10,
        "1Kgs": 11,
        "2Kgs": 12,
        "1Chr": 13,
        "2Chr": 14,
        "PrMan": 15,
        "Ezra": 16,
        "Neh": 17,
        "1Esd": 18,
        "2Esd": 19,
        "Tob": 20,
        "Jdt": 21,
        "Esth": 22,
        "GkEsth": 23,
        "1Macc": 24,
        "2Macc": 25,
        "3Macc": 26,
        "4Macc": 27,
        "Job": 28,
        "Ps": 29,
        "Prov": 30,
        "Eccl": 31,
        "Song": 32,
        "Wis": 33,
        "Sir": 34,
        "Isa": 35,
        "Jer": 36,
        "Lam": 37,
        "Bar": 38,
        "EpJer": 39,
        "Ezek": 40,
        "Dan": 41,
        "PrAzar": 42,
        "Sus": 43,
        "Bel": 44,
        "SgThree": 45,
        "Hos": 46,
        "Joel": 47,
        "Amos": 48,
        "Obad": 49,
        "Jonah": 50,
        "Mic": 51,
        "Nah": 52,
        "Hab": 53,
        "Zeph": 54,
        "Hag": 55,
        "Zech": 56,
        "Mal": 57,
        "Matt": 58,
        "Mark": 59,
        "Luke": 60,
        "John": 61,
        "Acts": 62,
        "Rom": 63,
        "1Cor": 64,
        "2Cor": 65,
        "Gal": 66,
        "Eph": 67,
        "Phil": 68,
        "Col": 69,
        "1Thess": 70,
        "2Thess": 71,
        "1Tim": 72,
        "2Tim": 73,
        "Titus": 74,
        "Phlm": 75,
        "Heb": 76,
        "Jas": 77,
        "1Pet": 78,
        "2Pet": 79,
        "1John": 80,
        "2John": 81,
        "3John": 82,
        "Jude": 83,
        "Rev": 84
      },
      chapters: {
        "Gen": [31, 25, 24, 26, 32, 22, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 38, 18, 34, 24, 20, 67, 34, 35, 46, 22, 35, 43, 54, 33, 20, 31, 29, 43, 36, 30, 23, 23, 57, 38, 34, 34, 28, 34, 31, 22, 33, 26],
        "Exod": [22, 25, 22, 31, 23, 30, 29, 28, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 37, 30, 33, 18, 40, 37, 21, 43, 46, 38, 18, 35, 23, 35, 35, 38, 29, 31, 43, 38],
        "Lev": [17, 16, 17, 35, 26, 23, 38, 36, 24, 20, 47, 8, 59, 57, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 46, 34],
        "Num": [54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 35, 16, 33, 45, 41, 35, 28, 32, 22, 29, 35, 41, 30, 25, 19, 65, 23, 31, 39, 17, 54, 42, 56, 29, 34, 13],
        "Deut": [46, 37, 29, 49, 33, 25, 26, 20, 29, 22, 32, 31, 19, 29, 23, 22, 20, 22, 21, 20, 23, 29, 26, 22, 19, 19, 26, 69, 28, 20, 30, 52, 29, 12],
        "1Sam": [28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 42, 16, 23, 28, 23, 44, 25, 12, 25, 11, 31, 13],
        "2Sam": [27, 32, 39, 12, 25, 23, 29, 18, 13, 19, 27, 31, 39, 33, 37, 23, 29, 32, 44, 26, 22, 51, 39, 25],
        "1Kgs": [53, 46, 28, 20, 32, 38, 51, 66, 28, 29, 43, 33, 34, 31, 34, 34, 24, 46, 21, 43, 29, 54],
        "2Kgs": [18, 25, 27, 44, 27, 33, 20, 29, 37, 36, 20, 22, 25, 29, 38, 20, 41, 37, 37, 21, 26, 20, 37, 20, 30],
        "1Chr": [54, 55, 24, 43, 41, 66, 40, 40, 44, 14, 47, 41, 14, 17, 29, 43, 27, 17, 19, 8, 30, 19, 32, 31, 31, 32, 34, 21, 30],
        "2Chr": [18, 17, 17, 22, 14, 42, 22, 18, 31, 19, 23, 16, 23, 14, 19, 14, 19, 34, 11, 37, 20, 12, 21, 27, 28, 23, 9, 27, 36, 27, 21, 33, 25, 33, 27, 23],
        "Neh": [11, 20, 38, 17, 19, 19, 72, 18, 37, 40, 36, 47, 31],
        "Job": [22, 13, 26, 21, 27, 30, 21, 22, 35, 22, 20, 25, 28, 22, 35, 22, 16, 21, 29, 29, 34, 30, 17, 25, 6, 14, 23, 28, 25, 31, 40, 22, 33, 37, 16, 33, 24, 41, 30, 32, 26, 17],
        "Ps": [6, 11, 9, 9, 13, 11, 18, 10, 21, 18, 7, 9, 6, 7, 5, 11, 15, 51, 15, 10, 14, 32, 6, 10, 22, 12, 14, 9, 11, 13, 25, 11, 22, 23, 28, 13, 40, 23, 14, 18, 14, 12, 5, 27, 18, 12, 10, 15, 21, 23, 21, 11, 7, 9, 24, 14, 12, 12, 18, 14, 9, 13, 12, 11, 14, 20, 8, 36, 37, 6, 24, 20, 28, 23, 11, 13, 21, 72, 13, 20, 17, 8, 19, 13, 14, 17, 7, 19, 53, 17, 16, 16, 5, 23, 11, 13, 12, 9, 9, 5, 8, 29, 22, 35, 45, 48, 43, 14, 31, 7, 10, 10, 9, 8, 18, 19, 2, 29, 176, 7, 8, 9, 4, 8, 5, 6, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9, 8, 24, 14, 10, 8, 12, 15, 21, 10, 20, 14, 9, 6],
        "Eccl": [18, 26, 22, 17, 19, 12, 29, 17, 18, 20, 10, 14],
        "Song": [17, 17, 11, 16, 16, 12, 14, 14],
        "Isa": [31, 22, 26, 6, 30, 13, 25, 23, 20, 34, 16, 6, 22, 32, 9, 14, 14, 7, 25, 6, 17, 25, 18, 23, 12, 21, 13, 29, 24, 33, 9, 20, 24, 17, 10, 22, 38, 22, 8, 31, 29, 25, 28, 28, 25, 13, 15, 22, 26, 11, 23, 15, 12, 17, 13, 12, 21, 14, 21, 22, 11, 12, 19, 11, 25, 24],
        "Jer": [19, 37, 25, 31, 31, 30, 34, 23, 25, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 40, 10, 38, 24, 22, 17, 32, 24, 40, 44, 26, 22, 19, 32, 21, 28, 18, 16, 18, 22, 13, 30, 5, 28, 7, 47, 39, 46, 64, 34],
        "Ezek": [28, 10, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 44, 37, 31, 49, 27, 17, 21, 36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35],
        "Dan": [21, 49, 100, 34, 30, 29, 28, 27, 27, 21, 45, 13, 64, 42],
        "Hos": [9, 25, 5, 19, 15, 11, 16, 14, 17, 15, 11, 15, 15, 10],
        "Joel": [20, 27, 5, 21],
        "Jonah": [16, 11, 10, 11],
        "Mic": [16, 13, 12, 14, 14, 16, 20],
        "Nah": [14, 14, 19],
        "Zech": [17, 17, 10, 14, 11, 15, 14, 23, 17, 12, 17, 14, 9, 21],
        "Mal": [14, 17, 24],
        "Acts": [26, 47, 26, 37, 42, 15, 60, 40, 43, 49, 30, 25, 52, 28, 41, 40, 34, 28, 40, 38, 40, 30, 35, 27, 27, 32, 44, 31],
        "2Cor": [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 13],
        "Rev": [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 18, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21],
        "Tob": [22, 14, 17, 21, 22, 18, 17, 21, 6, 13, 18, 22, 18, 15],
        "Sir": [30, 18, 31, 31, 15, 37, 36, 19, 18, 31, 34, 18, 26, 27, 20, 30, 32, 33, 30, 31, 28, 27, 27, 33, 26, 29, 30, 26, 28, 25, 31, 24, 33, 31, 26, 31, 31, 34, 35, 30, 22, 25, 33, 23, 26, 20, 25, 25, 16, 29, 30],
        "Bar": [22, 35, 38, 37, 9, 72],
        "2Macc": [36, 32, 40, 50, 27, 31, 42, 36, 29, 38, 38, 46, 26, 46, 39]
      }
    },
    nlt: {
      chapters: {
        "Rev": [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 18, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21]
      }
    },
    nrsv: {
      chapters: {
        "2Cor": [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 13],
        "Rev": [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 18, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21]
      }
    }
  };

  bcv_parser.prototype.languages = ["tr"];

  bcv_parser.prototype.regexps.space = "[\\s\\xa0]";

  bcv_parser.prototype.regexps.escaped_passage = /(?:^|[^\x1f\x1e\dA-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:(?:ch(?:apters?|a?pts?\.?|a?p?s?\.?)?\s*\d+\s*(?:[\u2013\u2014\-]|through|thru|to)\s*\d+\s*(?:from|of|in)(?:\s+the\s+book\s+of)?\s*)|(?:ch(?:apters?|a?pts?\.?|a?p?s?\.?)?\s*\d+\s*(?:from|of|in)(?:\s+the\s+book\s+of)?\s*)|(?:\d+(?:th|nd|st)\s*ch(?:apter|a?pt\.?|a?p?\.?)?\s*(?:from|of|in)(?:\s+the\s+book\s+of)?\s*))?\x1f(\d+)(?:\/\d+)?\x1f(?:\/\d+\x1f|[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014]|ba[şs]l[İIiı]k(?![a-z])|b[öo]l[üu]mler|b[öo]l[üu]m|ayet[İIi]|b[öo]l?|[İIi]la|baplar|ayet|bap|blm|vdm|a\.|bp|vd|ve|–|[b-e](?!\w)|$)+)/gi;

  bcv_parser.prototype.regexps.match_end_split = /\d\W*ba[şs]l[İIiı]k|\d\W*(?:vdm|vd)(?:[\s\xa0*]*\.)?|\d[\s\xa0*]*[b-e](?!\w)|\x1e(?:[\s\xa0*]*[)\]\uff09])?|[\d\x1f]/gi;

  bcv_parser.prototype.regexps.control = /[\x1e\x1f]/g;

  bcv_parser.prototype.regexps.pre_book = "[^A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ]";

  bcv_parser.prototype.regexps.first = "(?:1|I|B[İIi]r|B[İIi]r[İIi]nc[İIi]|[İIi]lk)\\.?" + bcv_parser.prototype.regexps.space + "*";

  bcv_parser.prototype.regexps.second = "(?:2|II|[İIi]k[İIi]|[İIi]k[İIi]nc[İIi])\\.?" + bcv_parser.prototype.regexps.space + "*";

  bcv_parser.prototype.regexps.third = "(?:3|III|[ÜU][çc]|[ÜU][çc][üu]nc[üu])\\.?" + bcv_parser.prototype.regexps.space + "*";

  bcv_parser.prototype.regexps.range_and = "(?:[&\u2013\u2014-]|ve|(?:[İIi]la|–))";

  bcv_parser.prototype.regexps.range_only = "(?:[\u2013\u2014-]|(?:[İIi]la|–))";

  bcv_parser.prototype.regexps.get_books = function(include_apocrypha, case_sensitive) {
    var book, books, k, len, out;
    books = [
      {
        osis: ["Ps"],
        apocrypha: true,
        extra: "2",
        regexp: /(\b)(Ps151)(?=\.1)/g
      }, {
        osis: ["Gen"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Yar(?:at[Iİı]l(?:[Iİı][sş]))?|Tek(?:v[Iİ]n)?|Ba[sş](?:lang(?:[Iİı][cç])?)|Gen)|Ba[sş]|(?:Yarat(?:il[iIıİ][sş]|[Iıİ]li[sş])|Tekvin|Ba[sş]langi[çc]))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Exod"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Exod|M[Iİı]s(?:[Iİı]r(?:dan[\\s\\xa0]*(?:[CÇ](?:[Iİı]k(?:[Iİı][sş]))|['’]dan[\\s\\xa0]*(?:[CÇ](?:[Iİı]k(?:[Iİı][sş]))))))|[CÇ](?:[Iİı]k))|M[Iİı]s(?:[Iİı]r(?:['’]dan[\\s\\xa0]*(?:[CÇ](?:[Iİı]k(?:[Iİı][sş])))))|(?:M(?:is[İiıI]r(?:(?:['’]dan[\\s\\xa0]*(?:[CÇ](?:[İIiı]k(?:[İıiI][sş])))|dan[\\s\\xa0]*[CÇ](?:[Iıiİ]k(?:[Iiİı][sş]))))|[ıİI]s(?:(?:[ıİI]r(?:dan[\\s\\xa0]*(?:[ÇC](?:(?:[Iİı]ki[şs]|ik[Iİiı][şs]))|['’]dan[\\s\\xa0]*(?:[ÇC](?:(?:[ıİI]ki[sş]|ik[İiıI][sş])))))|ir(?:[’']dan[\\s\\xa0]*(?:[CÇ](?:[ıiIİ]k(?:[İıIi][sş])))|dan[\\s\\xa0]*[ÇC](?:[ıiİI]k(?:[Iıİi][şs]))))))|(?:[ÇC](?:ik(?:[iİIı][sş])?|[ıIİ]k(?:[iıİI][şs]))))|M[Iİı]s(?:[ıİI]r(?:[’']dan[\\s\\xa0]*(?:[ÇC](?:(?:[ıIİ]ki[sş]|ik[iIİı][şs]))))))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Bel"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Bel(?:[\\s\\xa0]*ve[\\s\\xa0]*Ejderha)?)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Lev"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Lev(?:[Iiİ]l(?:[Iiİ]ler)|ılıler)?)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Num"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:[CÇ](?:[oö]lde[\\s\\xa0]*Say(?:[Iİı]m))|Say(?:[Iİı]lar)?|Num)|(?:[ÇC](?:[oö]lde[\\s\\xa0]*Sayim)|Sayilar))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Sir"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(S(?:ir(?:ak)?|[Iİı]rak))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Wis"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:B[Iiİ]lgel(?:[Iiİ]k)|Wis))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Lam"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Yer(?:emya(?:['’]n(?:[Iİı]n[\\s\\xa0]*Mers(?:[Iİ]yeler[Iİ]))|n[Iİı]n[\\s\\xa0]*Mers(?:[Iİ]yeler[Iİ]))|[\\s\\xa0]*M(?:er)?|\\.[\\s\\xa0]*M(?:er)?)|Lam|A(?:[gğ](?:[Iİı](?:t(?:lar)?)?)))|(?:Yeremya(?:(?:['’]n(?:(?:[ıIİ]n[\\s\\xa0]*Mers(?:iyeler[İiI]|[İI]yeleri))|in[\\s\\xa0]*Mers[Iİi]yeler[Iİi]))|n(?:(?:[Iıİ]n[\\s\\xa0]*Mers(?:iyeler[iİI]|[Iİ]yeleri))|in[\\s\\xa0]*Mers[iIİ]yeler[İIi]))|A(?:[gğ]i(?:t(?:lar)?)?)))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["EpJer"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Yeremya(?:n[Iiİı]n[\\s\\xa0]*Mektubu|['’]n(?:[Iiİı]n[\\s\\xa0]*Mektubu))|EpJer))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Rev"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Esin(?:leme)?|Rev|Va(?:h(?:[Iiİ]y)?)?))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["PrMan"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:PrMan|Mana[sş](?:[sş]e(?:(?:['’]n(?:[Iİ]n[\\s\\xa0]*Duas[Iİı])|n[Iİ]n[\\s\\xa0]*Duas[Iİı]))))|Mana[şs](?:[şs]e(?:(?:['’]n(?:(?:[İI]n[\\s\\xa0]*Duasi|in[\\s\\xa0]*Duas[İiIı]))|n(?:[İI]n[\\s\\xa0]*Duasi|in[\\s\\xa0]*Duas[iıIİ])))))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Deut"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Kunun(?:un[\\s\\xa0]*Tekrar[Iİı]|['’]un[\\s\\xa0]*Tekrar[Iİı])|Tesn[Iİ]ye|Yas(?:\\.[\\s\\xa0]*Tek|[\\s\\xa0]*Tek|a(?:['’]n(?:[Iİı]n[\\s\\xa0]*Tekrar[Iİı])|n[Iİı]n[\\s\\xa0]*Tekrar[Iİı]))|Deut)|(?:Yas(?:a(?:n(?:in[\\s\\xa0]*Tekrar[ıİiI]|[ıİI]n[\\s\\xa0]*Tekrari)|(?:[’']n(?:in[\\s\\xa0]*Tekrar[İIiı]|[İIı]n[\\s\\xa0]*Tekrari))))?|Kunun(?:['’]un[\\s\\xa0]*Tekrari|un[\\s\\xa0]*Tekrari)|Tesniye))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Josh"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Y(?:[sş]u|e[sş]u)|Josh))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Judg"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:H(?:ak(?:[Iiİ]mler)?|âk[Iiİ]mler)|Judg))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Ruth"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Ruth?)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["1Esd"],
        apocrypha: true,
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:1(?:\.[\s\xa0]*Esdras|[\s\xa0]*Esdras|Esd)|B(?:[Iİ]r(?:[\s\xa0]*Esdras|[Iİ]nc(?:[Iİ][\s\xa0]*Esdras)))|I(?:\.[\s\xa0]*Esdras|[\s\xa0]*Esdras|lk[\s\xa0]*Esdras)|İlk[\s\xa0]*Esdras)|(?:B(?:[İI]r(?:inc(?:[iIİ][\s\xa0]*Esdras|[İI]nci[\s\xa0]*Esdras))|ir(?:[\s\xa0]*Esdras|[iİI]nc(?:[İIi][\s\xa0]*Esdras)))|ilk[\s\xa0]*Esdras)|B[İI]r(?:[İI]nci[\s\xa0]*Esdras))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["2Esd"],
        apocrypha: true,
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:2(?:\.[\s\xa0]*Esdras|[\s\xa0]*Esdras|Esd)|I(?:k(?:[Iİ](?:[\s\xa0]*Esdras|nc[Iİ][\s\xa0]*Esdras))|I(?:\.[\s\xa0]*Esdras|[\s\xa0]*Esdras))|İk(?:[Iİ](?:[\s\xa0]*Esdras|nc[Iİ][\s\xa0]*Esdras)))|(?:ik(?:[iİI](?:[\s\xa0]*Esdras|nc[iIİ][\s\xa0]*Esdras))|(?:[Iİ]k(?:i(?:[\s\xa0]*Esdras|nc[İiI][\s\xa0]*Esdras)|[Iİ]nci[\s\xa0]*Esdras))))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["Isa"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:(?:[Iiİ](?:[sş]a(?:ya)?))|Y(?:e[sş]aya|[sş]a)))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["2Sam"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:2(?:[\s\xa0]*Sa(?:m(?:uel)?)?|\.[\s\xa0]*Sa(?:m(?:uel)?)?|Sam?)|I(?:I(?:[\s\xa0]*Sa(?:m(?:uel)?)?|\.[\s\xa0]*Sa(?:m(?:uel)?)?)|k(?:[Iİ](?:[\s\xa0]*Sa(?:m(?:uel)?)?|nc(?:[Iİ][\s\xa0]*Sa(?:m(?:uel)?)?))))|İk(?:[Iİ](?:[\s\xa0]*Sa(?:m(?:uel)?)?|nc(?:[Iİ][\s\xa0]*Sa(?:m(?:uel)?)?))))|(?:(?:[Iİ]k(?:(?:[İI]nci[\s\xa0]*Sa(?:m(?:uel)?)?)|i(?:[\s\xa0]*Sa(?:m(?:uel)?)?|nc(?:[İIi][\s\xa0]*Sa(?:m(?:uel)?)?))))|ik(?:[Iiİ](?:[\s\xa0]*Sa(?:m(?:uel)?)?|nc(?:[Iiİ][\s\xa0]*Sa(?:m(?:uel)?)?)))))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["1Sam"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:1(?:[\s\xa0]*Sa(?:m(?:uel)?)?|\.[\s\xa0]*Sa(?:m(?:uel)?)?|Sam?)|I(?:[\s\xa0]*Sa(?:m(?:uel)?)?|lk[\s\xa0]*Sa(?:m(?:uel)?)?|\.[\s\xa0]*Sa(?:m(?:uel)?)?)|B(?:[Iİ]r(?:[\s\xa0]*Sa(?:m(?:uel)?)?|(?:[Iİ]nc(?:[Iİ][\s\xa0]*Sa(?:m(?:uel)?)?))))|İlk[\s\xa0]*Sa(?:m(?:uel)?)?)|(?:B(?:(?:[Iİ]r(?:inc(?:[iİI][\s\xa0]*Sa(?:m(?:uel)?)?)|(?:[İI]nci[\s\xa0]*Sa(?:m(?:uel)?)?)))|ir(?:[\s\xa0]*Sa(?:m(?:uel)?)?|(?:[İIi]nc(?:[iİI][\s\xa0]*Sa(?:m(?:uel)?)?))))|ilk[\s\xa0]*Sa(?:m(?:uel)?)?))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["2Kgs"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:2(?:\.[\s\xa0]*K(?:r(?:a(?:llar)?)?|[Iİı]rallar)|K(?:gs|r)|[\s\xa0]*K(?:r(?:a(?:llar)?)?|[Iİı]rallar))|I(?:k(?:[Iİ](?:[\s\xa0]*K(?:r(?:a(?:llar)?)?|[Iİı]rallar)|nc(?:[Iİ][\s\xa0]*K(?:r(?:a(?:llar)?)?|[Iİı]rallar))))|I(?:\.[\s\xa0]*K(?:r(?:a(?:llar)?)?|[Iİı]rallar)|[\s\xa0]*K(?:r(?:a(?:llar)?)?|[Iİı]rallar)))|İk(?:[Iİ](?:[\s\xa0]*K(?:r(?:a(?:llar)?)?|[Iİı]rallar)|nc(?:[Iİ][\s\xa0]*K(?:r(?:a(?:llar)?)?|[Iİı]rallar)))))|(?:2(?:[\s\xa0]*Kirallar|\.[\s\xa0]*Kirallar)|ik(?:[İIi](?:[\s\xa0]*K(?:r(?:a(?:llar)?)?|[ıiİI]rallar)|nc(?:[Iiİ][\s\xa0]*K(?:r(?:a(?:llar)?)?|[İIıi]rallar))))|I(?:k(?:(?:[İI](?:[\s\xa0]*Kirallar|nc(?:i[\s\xa0]*K(?:r(?:a(?:llar)?)?|[İIıi]rallar)|[Iİ][\s\xa0]*Kirallar)))|i(?:[\s\xa0]*K(?:r(?:a(?:llar)?)?|[Iiİı]rallar)|nc(?:[İiI][\s\xa0]*K(?:r(?:a(?:llar)?)?|[Iİıi]rallar))))|I(?:[\s\xa0]*Kirallar|\.[\s\xa0]*Kirallar))|İk(?:(?:[Iİ](?:[\s\xa0]*Kirallar|nc(?:i[\s\xa0]*K(?:r(?:a(?:llar)?)?|[ıIiİ]rallar)|[Iİ][\s\xa0]*Kirallar)))|i(?:[\s\xa0]*K(?:r(?:a(?:llar)?)?|[iıIİ]rallar)|nc(?:[iIİ][\s\xa0]*K(?:r(?:a(?:llar)?)?|[ıİiI]rallar))))))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["1Kgs"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:I(?:\.[\s\xa0]*K(?:r(?:a(?:llar)?)?|[Iİı]rallar)|[\s\xa0]*K(?:r(?:a(?:llar)?)?|[Iİı]rallar)|lk[\s\xa0]*K(?:r(?:a(?:llar)?)?|[Iİı]rallar))|1(?:\.[\s\xa0]*K(?:r(?:a(?:llar)?)?|[Iİı]rallar)|K(?:gs|r)|[\s\xa0]*K(?:r(?:a(?:llar)?)?|[Iİı]rallar))|İlk[\s\xa0]*K(?:r(?:a(?:llar)?)?|[Iİı]rallar)|B(?:[Iİ]r(?:(?:[Iİ]nc(?:[Iİ][\s\xa0]*K(?:r(?:a(?:llar)?)?|[Iİı]rallar)))|[\s\xa0]*K(?:r(?:a(?:llar)?)?|[Iİı]rallar))))|(?:B(?:(?:[Iİ]r(?:[\s\xa0]*Kirallar|(?:[İI]nc(?:i[\s\xa0]*K(?:r(?:a(?:llar)?)?|[ıiIİ]rallar)|[Iİ][\s\xa0]*Kirallar))|inc(?:[iIİ][\s\xa0]*K(?:r(?:a(?:llar)?)?|[Iiıİ]rallar))))|ir(?:[\s\xa0]*K(?:r(?:a(?:llar)?)?|[ıiIİ]rallar)|(?:[İiI]nc(?:[Iiİ][\s\xa0]*K(?:r(?:a(?:llar)?)?|[İIıi]rallar)))))|1(?:[\s\xa0]*Kirallar|\.[\s\xa0]*Kirallar)|I(?:[\s\xa0]*Kirallar|lk[\s\xa0]*Kirallar|\.[\s\xa0]*Kirallar)|ilk[\s\xa0]*K(?:r(?:a(?:llar)?)?|[Iiıİ]rallar)|İlk[\s\xa0]*Kirallar))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["2Chr"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:2(?:\.[\s\xa0]*Ta(?:r(?:[Iİ]hler)?|h)?|Chr|[\s\xa0]*Ta(?:r(?:[Iİ]hler)?|h)?|Ta)|I(?:k(?:[Iİ](?:[\s\xa0]*Ta(?:r(?:[Iİ]hler)?|h)?|nc(?:[Iİ][\s\xa0]*Ta(?:r(?:[Iİ]hler)?|h)?)))|I(?:\.[\s\xa0]*Ta(?:r(?:[Iİ]hler)?|h)?|[\s\xa0]*Ta(?:r(?:[Iİ]hler)?|h)?))|İk(?:[Iİ](?:[\s\xa0]*Ta(?:r(?:[Iİ]hler)?|h)?|nc(?:[Iİ][\s\xa0]*Ta(?:r(?:[Iİ]hler)?|h)?))))|(?:I(?:k(?:(?:[Iİ](?:nc(?:i[\s\xa0]*Ta(?:r(?:[Iİi]hler)?|h)?|[İI][\s\xa0]*Tarihler)|[\s\xa0]*Tarihler))|i(?:[\s\xa0]*Ta(?:r(?:[İIi]hler)?|h)?|nc(?:[iIİ][\s\xa0]*Ta(?:r(?:[iIİ]hler)?|h)?)))|I(?:[\s\xa0]*Tarihler|\.[\s\xa0]*Tarihler))|İk(?:(?:[Iİ](?:nc(?:i[\s\xa0]*Ta(?:r(?:[iİI]hler)?|h)?|[Iİ][\s\xa0]*Tarihler)|[\s\xa0]*Tarihler))|i(?:[\s\xa0]*Ta(?:r(?:[iİI]hler)?|h)?|nc(?:[iIİ][\s\xa0]*Ta(?:r(?:[iIİ]hler)?|h)?)))|2(?:[\s\xa0]*Tarihler|\.[\s\xa0]*Tarihler)|ik(?:[iIİ](?:[\s\xa0]*Ta(?:r(?:[İiI]hler)?|h)?|nc(?:[Iiİ][\s\xa0]*Ta(?:r(?:[Iİi]hler)?|h)?)))))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["1Chr"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:I(?:\.[\s\xa0]*Ta(?:r(?:[Iİ]hler)?|h)?|[\s\xa0]*Ta(?:r(?:[Iİ]hler)?|h)?|lk[\s\xa0]*Ta(?:r(?:[Iİ]hler)?|h)?)|İlk[\s\xa0]*Ta(?:r(?:[Iİ]hler)?|h)?|1(?:\.[\s\xa0]*Ta(?:r(?:[Iİ]hler)?|h)?|Chr|[\s\xa0]*Ta(?:r(?:[Iİ]hler)?|h)?|Ta)|B(?:[Iİ]r(?:(?:[Iİ]nc(?:[Iİ][\s\xa0]*Ta(?:r(?:[Iİ]hler)?|h)?))|[\s\xa0]*Ta(?:r(?:[Iİ]hler)?|h)?)))|(?:ilk[\s\xa0]*Ta(?:r(?:[iİI]hler)?|h)?|I(?:lk[\s\xa0]*Tarihler|[\s\xa0]*Tarihler|\.[\s\xa0]*Tarihler)|1(?:[\s\xa0]*Tarihler|\.[\s\xa0]*Tarihler)|İlk[\s\xa0]*Tarihler|B(?:(?:[İI]r(?:(?:[İI]nc(?:i[\s\xa0]*Ta(?:r(?:[iIİ]hler)?|h)?|[Iİ][\s\xa0]*Tarihler))|[\s\xa0]*Tarihler|inc(?:[iIİ][\s\xa0]*Ta(?:r(?:[Iiİ]hler)?|h)?)))|ir(?:[\s\xa0]*Ta(?:r(?:[iİI]hler)?|h)?|(?:[Iiİ]nc(?:[iIİ][\s\xa0]*Ta(?:r(?:[iİI]hler)?|h)?))))))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["Ezra"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Ezra?)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Neh"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Neh(?:emya)?)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["GkEsth"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Yunanca[\\s\\xa0]*Ester|G(?:kEsth|rek[cç]e[\\s\\xa0]*Ester)))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Esth"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Es(?:t(?:er|h)?)?)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Job"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Job|Ey(?:[uü][bp]?)?))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Ps"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Zebur|Ps|M(?:ez(?:mur(?:lar)?)?|z)))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["PrAzar"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Azarya(?:n[Iİı]n[\\s\\xa0]*Duas[Iİı]|['’]n(?:[Iİı]n[\\s\\xa0]*Duas[Iİı]))|PrAzar)|Azarya(?:n(?:[ıİI]n[\\s\\xa0]*Duasi|in[\\s\\xa0]*Duas[Iİıi])|[’']n(?:(?:[Iıİ]n[\\s\\xa0]*Duasi|in[\\s\\xa0]*Duas[İıiI]))))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Prov"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:S(?:[\\s\\xa0]*(?:Mes(?:eller[Iİ])?|(?:[OÖ]zd(?:ey(?:[Iİ](?:l[Iİ]|[sş]ler[Iİ])))?))|(?:[uü]l(?:[\\s\\xa0]*(?:Mes(?:eller[Iİ])?|(?:[OÖ]zd(?:ey(?:[Iİ](?:l[Iİ]|[sş]ler[Iİ])))?))|\\.[\\s\\xa0]*(?:Mes(?:eller[Iİ])?|(?:[OÖ]zd(?:ey(?:[Iİ](?:l[Iİ]|[sş]ler[Iİ])))?))|eyman(?:(?:[Iİı]n[\\s\\xa0]*(?:Meseller[Iİ]|[OÖ]zdey(?:[Iİ](?:[sş]ler[Iİ]))))|(?:['’](?:[Iİı]n[\\s\\xa0]*(?:Meseller[Iİ]|[OÖ]zdey(?:[Iİ](?:[sş]ler[Iİ]))))))))|\\.[\\s\\xa0]*(?:[OÖ]zd(?:ey(?:[Iİ](?:l[Iİ]|[sş]ler[Iİ])))?))|Prov|Meseller)|(?:S(?:\\.[\\s\\xa0]*[ÖO]zdey(?:i(?:(?:[sş]ler[İiI]|l[Iiİ])|(?:[Iİ](?:li|[sş]leri))))|[\\s\\xa0]*(?:Meselleri|[ÖO]zdey(?:i(?:(?:[şs]ler[iİI]|l[iIİ])|(?:[Iİ](?:li|[şs]leri)))))|[üu]l(?:eyman(?:(?:[’'](?:in[\\s\\xa0]*(?:(?:[ÖO]zdey(?:[Iiİ](?:[sş]ler[İiI]))|Meseller[İIi])|(?:[Iıİ]n[\\s\\xa0]*(?:Meselleri|[OÖ]zdey(?:i(?:[şs]ler[Iİi]|[Iİ](?:[sş]leri)))))))|in[\\s\\xa0]*(?:[OÖ]zdey(?:[İiI](?:[şs]ler[İiI]))|Meseller[İiI])|(?:[ıIİ]n[\\s\\xa0]*(?:Meselleri|[OÖ]zdey(?:i(?:[şs]ler[iİI]|[Iİ](?:[şs]leri))))))|\\.[\\s\\xa0]*(?:Meselleri|[OÖ]zdey(?:i(?:(?:[şs]ler[İiI]|l[İiI])|(?:[İI](?:li|[sş]leri)))))|[\\s\\xa0]*(?:Meselleri|[OÖ]zdey(?:i(?:(?:[sş]ler[iİI]|l[Iiİ])|(?:[İI](?:li|[şs]leri))))))))|[ÖO]zd)|S(?:(?:[üu]l(?:\\.[\\s\\xa0]*(?:Meselleri|[OÖ]zdey(?:i(?:(?:[şs]ler[İiI]|l[İiI])|(?:[İI](?:li|[sş]leri)))))|eyman(?:[İIı]n[\\s\\xa0]*(?:[OÖ]zdey(?:[Iİ](?:[şs]leri)))|(?:[’'](?:[Iıİ]n[\\s\\xa0]*(?:Meselleri|[OÖ]zdey(?:i(?:[şs]ler[Iİi]|[Iİ](?:[sş]leri)))))))|[\\s\\xa0]*(?:Meselleri|[OÖ]zdey(?:i(?:(?:[sş]ler[iİI]|l[Iiİ])|(?:[İI](?:li|[şs]leri)))))))|[\\s\\xa0]*(?:[OÖ]zdey(?:[Iİ](?:li|[sş]leri)))|\\.[\\s\\xa0]*(?:[ÖO]zdey(?:[Iİ](?:li|[sş]leri))))|S(?:[üu]l(?:[\\s\\xa0]*(?:[OÖ]zdey(?:[İI](?:li|[şs]leri)))|\\.[\\s\\xa0]*(?:[OÖ]zdey(?:[İI](?:li|[sş]leri)))|eyman['’](?:[İIı]n[\\s\\xa0]*(?:[OÖ]zdey(?:[İI](?:[şs]leri)))))))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Eccl"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Va[Iiİ]z?|Eccl))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["SgThree"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:SgThree|[UÜ](?:[cç][\\s\\xa0]*Gen(?:[cç][\\s\\xa0]*Adam(?:[Iİı]n[\\s\\xa0]*Ezg(?:[Iİ]s[Iİ])))))|[UÜ](?:[çc][\\s\\xa0]*Gen(?:[cç][\\s\\xa0]*Adam(?:in[\\s\\xa0]*Ezg(?:[Iiİ]s[İIi]|[Iıİ]n[\\s\\xa0]*Ezg(?:(?:[Iİ]si|is[iIİ]))))))|[UÜ](?:[çc][\\s\\xa0]*Gen(?:[cç][\\s\\xa0]*Adam(?:[Iıİ]n[\\s\\xa0]*Ezg(?:(?:[Iİ]si|is[iIİ]))))))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Song"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Song|Ne[sş](?:[Iİ]deler[\\s\\xa0]*Ne(?:[sş](?:[Iİ]des[Iİ]))?)|Ezg[Iİ]ler[\\s\\xa0]*Ezg(?:[Iİ]s[Iİ])?)|(?:Ezg|Ne[sş])|(?:Ne[sş](?:ideler[\\s\\xa0]*Ne(?:[sş](?:[iIİ]des[iIİ])|[İI]deler[\\s\\xa0]*Ne(?:[şs](?:(?:[İI]desi|ides[Iiİ])))))|Ezg(?:iler[\\s\\xa0]*Ezg[Iİi]s[İIi]|[İI]ler[\\s\\xa0]*Ezg(?:(?:[Iİ]si|is[iİI]))))|Ne[şs](?:[Iİ]deler[\\s\\xa0]*Ne(?:[sş](?:(?:[Iİ]desi|ides[iIİ])))))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Jer"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Yer(?:emya['’]n(?:[Iİı]n[\\s\\xa0]*Mers(?:[Iİ]yeler[Iİ])))?|Jer)|Yeremya(?:['’]n(?:(?:[ıIİ]n[\\s\\xa0]*Mers(?:iyeler[İiI]|[İI]yeleri))|in[\\s\\xa0]*Mers[İiI]yeler[Iİi]))?)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Ezek"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Hez(?:ek[Iiİ]el)?|Ezek))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Dan"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Dan(?:[Iiİ]el)?)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Hos"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Ho(?:[sş](?:e(?:a|ya))?))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Joel"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Yoel?|Joel))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Amos"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Amos?)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Obad"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(O(?:va(?:dya)?|bad(?:ya)?))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Jonah"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Yun(?:us)?|Jonah))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Mic"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(M(?:[Iİ]ka?|i(?:c|ka?)))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Nah"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Nah(?:um)?)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Hab"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Hab(?:ak(?:uk|kuk))?)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Zeph"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Sef(?:anya)?|Tsefanya|Zeph))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Hag"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Hag(?:gay|ay)?)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Zech"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Ze(?:ch|k[ae]r(?:(?:[Iiİ]ya|ya))?)|Zek)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Mal"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Mal(?:ak[Iiİ])?)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Matt"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Matta(?:['’](?:n(?:[Iuİı]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ]))|[Iuİı]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ]))|a[\\s\\xa0]*G[oö]re[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l))))|[Iİ]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ])))|Matta['’](?:(?:[Iuİı]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ]))|a[\\s\\xa0]*G[oö]re[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l))))|Mat(?:t(?:a(?:ya[\\s\\xa0]*G[oö]re[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l))|[Iİ]nc(?:[Iİ]l[Iİ])|[’']ya[\\s\\xa0]*G(?:[oö]re[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l)))|n[Iuİı]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ]))|[ıu]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ]))|a[\\s\\xa0]*G[oö]re[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l))))?)?|Matta(?:İn[\\s\\xa0]*(?:inc(?:IlI|[iİ]lİ)|Incİli|İnc(?:İli|il[Iİ]))|'(?:a[\\s\\xa0]*G(?:öre[\\s\\xa0]*(?:İncil|inc[Iİ]l)|ore[\\s\\xa0]*(?:İncil|inc[iİ]l))|in[\\s\\xa0]*(?:Inc(?:İlI|Ilİ)|incilI|İnc(?:ilI|İl[İi]))|ın[\\s\\xa0]*(?:inc(?:Ili|İlİ)|Inc(?:İli|ilİ)|İnc(?:[Iİ]li|ilİ))|n(?:un[\\s\\xa0]*(?:inc(?:ilI|İl[iİ]|Ilİ)|İnc(?:İli|il[iİ]))|ın[\\s\\xa0]*(?:Incilİ|İnc(?:İli|il[Iİ])|inc(?:Ili|İl[iİ]))|in[\\s\\xa0]*(?:Inc(?:Ili|ilİ)|incİlİ|İnc(?:İl[İi]|ilİ))|İn[\\s\\xa0]*(?:Inc[İI]li|İnc(?:İli|il[Iİ])|inc[Iİ]lİ)|In[\\s\\xa0]*(?:İncIli|incİlI))|un[\\s\\xa0]*(?:Incilİ|inc(?:Ili|İl[Iİ])|İnc(?:İli|il[Iİ]))|In[\\s\\xa0]*(?:İncilİ|incİlİ)|İn[\\s\\xa0]*(?:inc(?:IlI|İl[iİ]|ilİ)|İnc(?:[İI]li|ilİ)))|’(?:a[\\s\\xa0]*G(?:ore[\\s\\xa0]*(?:İncil|inc[Iİ]l)|öre[\\s\\xa0]*(?:[Iİ]ncil|incİl))|İn[\\s\\xa0]*(?:inc(?:Ili|İl[iİ]|ilİ)|İnc(?:[Iİ]li|ilİ))|n(?:ın[\\s\\xa0]*(?:inc[iİ]l[İI]|İnc(?:İli|il[iİ]))|In[\\s\\xa0]*inc(?:IlI|ilİ)|İn[\\s\\xa0]*(?:incİl[Iİ]|Inc(?:Ili|ilİ)|İnc(?:İli|il[iİ]))|in[\\s\\xa0]*(?:İnc[Iİ]l[iİ]|incİli|Incİlİ)|un[\\s\\xa0]*(?:İnc(?:[Iİ]li|ilİ)|inc(?:IlI|[İi]lİ)|Incİli))|un[\\s\\xa0]*(?:(?:[Iİ]nc(?:İli|il[iİ]))|incİlİ)|in[\\s\\xa0]*(?:incİlI|Incİlİ|İnc(?:Il[Iİ]|İlİ))|In[\\s\\xa0]*(?:incIlI|Incilİ|İncİli)|ın[\\s\\xa0]*(?:Incili|İnc(?:[Iİ]li|ilİ)|inc(?:İl[iİ]|ilİ))))|Matta(?:’(?:un[\\s\\xa0]*(?:(?:[İI]nc(?:Ili|ilI))|inc(?:[iI]l[İiI]|İl[iI]))|İn[\\s\\xa0]*(?:Inc(?:[Iİ]li|il[İiI])|İncil[Ii]|inc(?:İlI|Il[İI]|il[Ii]))|In[\\s\\xa0]*(?:Inc(?:[Iİ]li|il[iI])|inc(?:[İi]l[Iİi]|Il[İi])|İnc(?:Ili|il[İIi]))|ın[\\s\\xa0]*(?:Inc(?:[İI]li|il[İI])|İncil[Ii]|inc(?:İlI|Il[Iiİ]|il[iI]))|a[\\s\\xa0]*G(?:ore[\\s\\xa0]*[iI]ncil|öre[\\s\\xa0]*inc[iI]l)|in[\\s\\xa0]*(?:inc(?:[iI]l[Iiİ]|İl[iİ])|Inc(?:[Ii]l[iİI]|İl[Ii])|İnc(?:Ili|il[iIİ]|İl[Ii]))|n(?:in[\\s\\xa0]*(?:İnc(?:[İI]lI|il[İiI])|inc(?:[iI]l[Iiİ]|İl[Iİ])|Inc(?:[iI]l[Iiİ]|İl[Ii]))|In[\\s\\xa0]*(?:[Iİ]nc(?:(?:[Iİ]li|il[iIİ]))|inc(?:İl[İIi]|Il[iİ]|il[iI]))|İn[\\s\\xa0]*(?:İnc(?:Ili|ilI)|Inc(?:İli|il[iI])|inc(?:İli|[Ii]l[Iİi]))|un[\\s\\xa0]*(?:İncil[iI]|inc(?:Il[iİ]|[iİ]l[Ii])|Inc(?:Ili|il[İIi]))|ın[\\s\\xa0]*(?:İnc(?:Ili|ilI)|Inc(?:[Iİ]li|il[iIİ])|inc(?:[İi]li|Il[iIİ]))))|'(?:In[\\s\\xa0]*(?:Inc(?:[Iİ]li|il[Iiİ])|İnc(?:[Iİ]li|il[iI])|inc(?:[Ii]l[Iiİ]|İl[iI]))|in[\\s\\xa0]*(?:İnc(?:İlI|Il[Iiİ]|il[İi])|inc(?:[İI]l[Iiİ]|il[İi])|Inc(?:il[İIi]|İl[İi]|Il[iI]))|un[\\s\\xa0]*(?:inc(?:İli|il[İIi]|Il[İI])|İnc[iI]li|Inc(?:[İI]li|il[Ii]))|İn[\\s\\xa0]*(?:Inc(?:[İI]li|il[iİI])|İncil[Ii]|inc(?:İlI|Il[iİ]|il[iI]))|ın[\\s\\xa0]*(?:İncil[Ii]|inc(?:il[iİI]|Il[İI]|İl[Ii])|Inc(?:Ili|il[iI]))|a[\\s\\xa0]*G(?:öre[\\s\\xa0]*[Ii]ncil|ore[\\s\\xa0]*(?:incIl|Incil))|n(?:İn[\\s\\xa0]*(?:İnc[iI]li|Incil[İIi]|inc(?:il[Iiİ]|[İI]l[iI]))|ın[\\s\\xa0]*(?:inc(?:İlI|il[Iiİ]|Il[İI])|İnc[iI]li|Inc(?:[İI]li|il[Ii]))|un[\\s\\xa0]*(?:İnc(?:Ili|ilI)|Inc(?:[Iİ]li|il[iIİ])|inc(?:İlI|il[iİ]|Il[iI]))|In[\\s\\xa0]*(?:İnc(?:İli|il[Iiİ])|Inc(?:[İI]li|il[iİI])|inc(?:[Ii]l[Iiİ]|İl[iİ]))|in[\\s\\xa0]*(?:Inc(?:İl[Iİi]|Il[İI]|il[Ii])|inc(?:[iI]l[iIİ]|İl[Ii])|İnc(?:İlI|Il[Iiİ]|il[iI]))))|İn[\\s\\xa0]*(?:İnc[Ii]li|inc(?:Il[İi]|[İi]l[Ii])|Inc(?:Ili|il[iİI])))|Matta(?:In(?:c(?:[Iİ]li|ilİ)|[\\s\\xa0]*(?:İnc(?:Ili|ilİ)|Incİli))|'ya[\\s\\xa0]*G(?:ore[\\s\\xa0]*(?:İncil|inc[Iİ]l)|öre[\\s\\xa0]*(?:[İI]ncil|incİl))|’ya[\\s\\xa0]*G(?:öre[\\s\\xa0]*(?:İncil|inc[iİ]l)|ore[\\s\\xa0]*(?:[Iİ]ncil|incİl))|in(?:[\\s\\xa0]*(?:İncİl[iİ]|Incil[Iİ]|incİlİ)|cİlİ)|un[\\s\\xa0]*(?:Incilİ|İnc(?:İli|il[Iİ])|inc(?:ili|İl[İI]))|a[\\s\\xa0]*G(?:öre[\\s\\xa0]*(?:İncil|inc[iİ]l)|ore[\\s\\xa0]*(?:[İI]ncil|incİl))|ın[\\s\\xa0]*(?:Incili|İnc(?:İli|il[iİ])|inc(?:İl[iİ]|Ilİ))|n(?:In[\\s\\xa0]*inc[Iİ]lI|in[\\s\\xa0]*(?:İnc(?:IlI|İl[iİ]|ilİ)|incIlİ|Incİlİ)|İn[\\s\\xa0]*(?:inc(?:il[iİ]|İl[İI])|İnc(?:İli|il[iİ]))|un[\\s\\xa0]*(?:İnc(?:[İI]li|ilİ)|Incilİ|inc(?:IlI|İl[Iİ]))|ın[\\s\\xa0]*(?:Incili|İnc(?:[Iİ]li|ilİ)|inc(?:İl[İI]|ilİ)))|ya[\\s\\xa0]*G(?:[öo]re[\\s\\xa0]*(?:İncil|inc[Iİ]l))|İnc(?:İli|il[Iİ]))|Matta(?:İnc[Ii]li|In(?:cil[Ii]|[\\s\\xa0]*(?:inc[Iiİ]l[Iiİ]|İnc(?:İli|il[Ii])|Inc(?:Ili|il[iIİ])))|un[\\s\\xa0]*(?:inc(?:İli|Il[iIİ]|il[İI])|İnc[iI]li|Inc(?:[Iİ]li|il[Ii]))|ya[\\s\\xa0]*G[öo]re[\\s\\xa0]*(?:[iI]ncil)|n(?:un[\\s\\xa0]*(?:inc(?:İli|il[İiI]|Il[İi])|Inc(?:[İI]li|il[Ii])|İncil[iI])|in[\\s\\xa0]*(?:İnc(?:İlI|Il[iİ]|il[Ii])|Inc(?:[Ii]l[iIİ]|İl[Ii])|inc(?:[iİ]l[İIi]|Il[Ii]))|ın[\\s\\xa0]*(?:Inc(?:[Iİ]li|il[İI])|İncil[iI]|inc(?:İli|Il[İiI]|il[Ii]))|İn[\\s\\xa0]*(?:İnc(?:Ili|ilI)|inc(?:İli|ilI|Il[İiI])|Inc(?:[Iİ]li|il[iİI]))|In[\\s\\xa0]*(?:[İI]nc(?:(?:[İI]li|il[iİI]))|inc(?:il[iİI]|[Iİ]l[İi])))|'ya[\\s\\xa0]*G(?:ore[\\s\\xa0]*[Ii]ncil|öre[\\s\\xa0]*inc[Ii]l)|in(?:c(?:[Ii]l[iİI]|İl[Ii])|[\\s\\xa0]*(?:inc(?:[Ii]l[iIİ]|İl[Ii])|İnc(?:İlI|[Ii]l[iIİ])|Inc(?:ili|[İI]l[Iiİ])))|’ya[\\s\\xa0]*G(?:öre[\\s\\xa0]*(?:incIl|Incil)|ore[\\s\\xa0]*inc[iI]l)|a[\\s\\xa0]*G(?:öre[\\s\\xa0]*(?:incIl|Incil)|ore[\\s\\xa0]*inc[iI]l)|ın[\\s\\xa0]*(?:İnc(?:Ili|ilI)|Inc(?:[Iİ]li|il[Iİ])|inc(?:İlI|il[Iiİ]|Il[Ii])))?)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Mark"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Markos(?:['’](?:n(?:[Iuİı]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ]))|[Iuİı]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ]))|a[\\s\\xa0]*G[oö]re[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l))))|[Iİ]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ])))|Markos['’](?:(?:[Iuİı]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ]))|a[\\s\\xa0]*G[oö]re[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l))))|Mar(?:k(?:os(?:ya[\\s\\xa0]*G[oö]re[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l))|[Iİ]nc(?:[Iİ]l[Iİ])|[’']ya[\\s\\xa0]*G(?:[oö]re[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l)))|n[Iuİı]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ]))|[ıu]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ]))|a[\\s\\xa0]*G[oö]re[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l))))?)?|Markos(?:’(?:a[\\s\\xa0]*G(?:öre[\\s\\xa0]*(?:İncil|inc[İI]l)|ore[\\s\\xa0]*(?:İncil|inc[İi]l))|ın[\\s\\xa0]*(?:inc(?:ilI|İl[Iİ]|Ilİ)|İnc(?:[Iİ]li|ilİ))|in[\\s\\xa0]*(?:incIli|İnc(?:Ili|İl[Iİ])|Incİlİ)|İn[\\s\\xa0]*(?:IncilI|İnc(?:İli|il[Iİ])|inc(?:İl[İi]|ilİ))|n(?:in[\\s\\xa0]*(?:incilI|Incİlİ|İnc[İI]lİ)|In[\\s\\xa0]*(?:İnc(?:İli|ilI)|incIlİ|Incİli)|İn[\\s\\xa0]*(?:inc(?:ili|İlİ)|Inc(?:İli|ilİ)|İnc(?:İli|il[iİ]))|un[\\s\\xa0]*(?:Inc(?:İli|ilİ)|inc(?:IlI|İlİ)|İnc(?:İli|il[iİ]))|ın[\\s\\xa0]*(?:IncIli|İnc(?:[İI]li|ilİ)|inc(?:İl[İI]|Ilİ)))|un[\\s\\xa0]*(?:(?:[İI]nc(?:İli|il[İI]))|incİlİ)|In[\\s\\xa0]*(?:inc(?:İlI|Ilİ)|İncilİ))|İn[\\s\\xa0]*(?:Incilİ|inc(?:Ili|İl[Iİ])|İnc(?:İli|il[Iİ]))|'(?:İn[\\s\\xa0]*(?:inc[Iİ]l[Iİ]|İnc(?:İli|il[iİ]))|a[\\s\\xa0]*G(?:öre[\\s\\xa0]*(?:İncil|inc[Iİ]l)|ore[\\s\\xa0]*(?:[Iİ]ncil|incİl))|In[\\s\\xa0]*Incİli|n(?:un[\\s\\xa0]*(?:inc[iİ]l[iİ]|İnc(?:İli|il[iİ]))|ın[\\s\\xa0]*(?:IncIli|İnc(?:İli|il[Iİ])|inc(?:İl[iİ]|ilİ))|İn[\\s\\xa0]*(?:Incİli|İnc(?:İli|il[Iİ])|inc(?:Il[iİ]|İlİ))|in[\\s\\xa0]*(?:Inc(?:[İI]li|ilİ)|İnc(?:İl[İi]|ilİ))|In[\\s\\xa0]*(?:İncilI|incİlİ))|ın[\\s\\xa0]*(?:İnc(?:İli|il[Iİ])|Inc(?:İli|il[iİ])|incİlİ)|in[\\s\\xa0]*(?:İnc(?:İl[iİ]|il[İI])|IncIli|inc[iİ]lİ)|un[\\s\\xa0]*(?:İnc(?:[Iİ]li|ilİ)|Incilİ|inc(?:ilI|İl[iİ]))))|Markos(?:İn[\\s\\xa0]*(?:inc(?:İli|il[İiI]|Il[Iİ])|İnc[iI]li|Inc(?:[İI]li|il[iI]))|'(?:un[\\s\\xa0]*(?:inc(?:İlI|Il[iİI]|il[iİ])|Inc(?:[İI]li|il[Ii])|İncil[Ii])|ın[\\s\\xa0]*(?:Inc(?:Ili|ilI)|İnc[Ii]li|inc(?:[iI]l[iİI]|İl[iI]))|n(?:In[\\s\\xa0]*(?:Inc(?:[İI]li|il[İiI])|İnc(?:[Iİ]li|il[iİ])|inc(?:[iI]l[iIİ]|İl[iI]))|İn[\\s\\xa0]*(?:İnc[Ii]li|Inc(?:Ili|il[İIi])|inc(?:IlI|il[İiI]|İl[iI]))|in[\\s\\xa0]*(?:Inc(?:[İI]l[Iİ]|il[iI])|inc[İiI]l[iIİ]|İnc(?:İlI|Il[Iiİ]|il[Ii]))|ın[\\s\\xa0]*(?:Inc(?:İli|il[iİI])|İnc[iI]li|inc(?:İlI|Il[iIİ]|il[iI]))|un[\\s\\xa0]*(?:İnc(?:Ili|ilI)|inc(?:[İi]lI|Il[iİI])|Inc(?:[İI]li|il[İIi])))|In[\\s\\xa0]*(?:İnc(?:[İI]li|il[Iiİ])|inc[Iİi]l[Iiİ]|Inc(?:Ili|il[İiI]))|in[\\s\\xa0]*(?:İnc(?:ili|İlI|Il[iIİ])|inc(?:Il[Iİi]|[İi]l[Ii])|Inc(?:[İi]l[Iiİ]|Il[Iİ]))|a[\\s\\xa0]*G(?:öre[\\s\\xa0]*[iI]ncil|ore[\\s\\xa0]*inc[iI]l)|İn[\\s\\xa0]*(?:İnc(?:Ili|ilI)|[Ii]nc(?:(?:[İI]li|il[Iİi]))))|’(?:un[\\s\\xa0]*(?:[İI]nc(?:[Ii]li)|inc(?:[Ii]l[iIİ]|İl[iI]))|ın[\\s\\xa0]*(?:Inc(?:[Iİ]li|il[Iİi])|İncil[Ii]|inc(?:İli|il[İi]|Il[iI]))|a[\\s\\xa0]*G(?:öre[\\s\\xa0]*[Ii]ncil|ore[\\s\\xa0]*(?:incIl|Incil))|In[\\s\\xa0]*(?:Inc(?:[Iİ]li|il[Iİi])|İnc(?:[İI]li|il[Ii])|inc(?:il[iIİ]|İl[İi]|Il[Ii]))|İn[\\s\\xa0]*(?:İnc[iI]li|Inc(?:[İI]li|il[iİ])|inc(?:İlI|Il[İiI]|il[Ii]))|n(?:ın[\\s\\xa0]*(?:Inc(?:İli|il[iIİ])|İncil[iI]|inc(?:İli|il[Iiİ]|Il[iI]))|In[\\s\\xa0]*(?:İnc(?:Ili|il[iİ])|inc(?:[İi]l[iIİ]|Il[iI])|Inc(?:Ili|il[Iiİ]))|in[\\s\\xa0]*(?:İnc(?:il[İIi]|[İI]l[iI])|inc(?:[Iİ]l[İiI]|il[iİ])|Inc(?:[Ii]l[iİI]|İl[iI]))|un[\\s\\xa0]*(?:İnc(?:Ili|ilI)|inc(?:il[iİI]|Il[iİ]|İl[iI])|Inc(?:Ili|il[iI]))|İn[\\s\\xa0]*(?:İnc(?:Ili|ilI)|inc(?:Il[Iİi]|il[İI]|İl[Ii])|Inc(?:Ili|il[iI])))|in[\\s\\xa0]*(?:İnc(?:İli|il[Iİi]|Il[İI])|inc(?:[İi]l[iIİ]|Il[İI])|Inc(?:[Ii]l[Iİi]|İl[Ii]))))|Markos(?:n(?:In[\\s\\xa0]*(?:incIlI|İncilİ)|(?:[İu]n[\\s\\xa0]*(?:inc(?:Ili|İlİ)|Inc(?:İli|ilİ)|İnc(?:[Iİ]li|ilİ)))|in[\\s\\xa0]*(?:Inc(?:İlI|ilİ)|İnc(?:ili|İl[Iİ])|incİlİ)|ın[\\s\\xa0]*(?:İnc(?:[Iİ]li|ilİ)|inc(?:IlI|[iİ]lİ)|Incİli))|’ya[\\s\\xa0]*G(?:öre[\\s\\xa0]*(?:İncil|inc[Iİ]l)|ore[\\s\\xa0]*(?:[Iİ]ncil|incİl))|in(?:cİlİ|[\\s\\xa0]*(?:Inc[Iİ]li|incİlİ|İnc[iİ]lİ))|İnc(?:[Iİ]li|ilİ)|ya[\\s\\xa0]*G(?:öre[\\s\\xa0]*(?:İncil|inc[İi]l)|ore[\\s\\xa0]*(?:[Iİ]ncil|incİl))|In(?:[\\s\\xa0]*(?:İnc(?:İli|ilI)|incilİ)|c(?:[Iİ]li|ilİ))|'ya[\\s\\xa0]*G[oö]re[\\s\\xa0]*(?:(?:[İI]ncil|incİl))|a[\\s\\xa0]*G[öo]re[\\s\\xa0]*(?:(?:[Iİ]ncil|incİl))|ın[\\s\\xa0]*(?:İnc(?:[Iİ]li|ilİ)|Incilİ|inc(?:Ili|İl[İI]))|un[\\s\\xa0]*(?:İnc(?:[Iİ]li|ilİ)|Incilİ|inc(?:ilI|İl[Iİ])))|Markos(?:ın[\\s\\xa0]*(?:inc(?:İli|il[Iiİ]|Il[İI])|Inc(?:[İI]li|il[iI])|İncil[iI])|un[\\s\\xa0]*(?:inc(?:İli|Il[Iiİ]|il[İi])|Inc(?:[Iİ]li|il[iI])|İncil[iI])|In(?:cil[Ii]|[\\s\\xa0]*(?:Inc(?:[Iİ]li|il[Iİi])|İnc(?:Ili|il[İi])|inc(?:[Iİ]l[iİI]|il[iI])))|in(?:c(?:[iI]l[Iİi]|İl[iI])|[\\s\\xa0]*(?:İnc(?:Il[Iiİ]|[iİ]l[Ii])|Inc(?:il[iIİ]|[İI]l[İI])|inc(?:[Ii]l[İiI]|İl[Ii])))|İncil[Ii]|’ya[\\s\\xa0]*G(?:öre[\\s\\xa0]*[iI]ncil|ore[\\s\\xa0]*inc[iI]l)|n(?:In[\\s\\xa0]*(?:Inc(?:[İI]li|il[iİI])|İnc(?:[Iİ]li|il[iI])|inc(?:[İi]l[Iİi]|Il[İi]))|in[\\s\\xa0]*(?:İnc(?:İli|Il[iİI]|il[İI])|Inc(?:Il[Iİi]|İl[İi]|il[iI])|inc(?:[iI]l[Iİi]|İl[Ii]))|(?:[İu]n[\\s\\xa0]*(?:İncil[iI]|inc(?:il[İIi]|Il[İI]|İl[Ii])|Inc(?:Ili|il[iI])))|ın[\\s\\xa0]*(?:İncil[Ii]|inc(?:Il[İi]|[İi]l[Ii])|Inc(?:Ili|il[İIi])))|'ya[\\s\\xa0]*G[oö]re[\\s\\xa0]*inc(?:[iI]l)|ya[\\s\\xa0]*G(?:öre[\\s\\xa0]*(?:incIl|Incil)|ore[\\s\\xa0]*inc[iI]l)|a[\\s\\xa0]*G[oö]re[\\s\\xa0]*inc(?:[Ii]l))?)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Luke"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Luka(?:['’](?:n(?:[Iuİı]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ]))|[Iuİı]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ]))|a[\\s\\xa0]*G[oö]re[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l))))|[Iİ]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ])))|Luka['’](?:(?:[Iuİı]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ]))|a[\\s\\xa0]*G[oö]re[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l))))|Luk(?:a(?:ya[\\s\\xa0]*G[oö]re[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l))|[Iİ]nc(?:[Iİ]l[Iİ])|[’']ya[\\s\\xa0]*G(?:[oö]re[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l)))|n[Iuİı]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ]))|[ıu]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ]))|a[\\s\\xa0]*G[oö]re[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l)))|e)?|Luka(?:'(?:un[\\s\\xa0]*(?:inc(?:İl[İi]|Il[İI])|İnc(?:İli|il[İi]))|In[\\s\\xa0]*(?:inc(?:ilI|Ilİ)|İncİli)|ın[\\s\\xa0]*(?:IncIli|İnc(?:İli|il[Iİ])|inc(?:İl[Iİ]|Ilİ))|in[\\s\\xa0]*(?:Incİl[İi]|İnc(?:IlI|[iİ]lİ))|a[\\s\\xa0]*G[oö]re[\\s\\xa0]*(?:(?:[Iİ]ncil|incİl))|İn[\\s\\xa0]*(?:İnc(?:[Iİ]li|ilİ)|Incilİ|inc(?:ili|İl[İI]))|n(?:İn[\\s\\xa0]*(?:inc(?:İl[iİ]|il[Iİ])|İnc(?:İli|il[İI]))|in[\\s\\xa0]*(?:inc[iİ]lI|İnc(?:ilI|İl[İi]|Ilİ)|Inc[Iİ]lİ)|un[\\s\\xa0]*(?:incİl[iİ]|Incil[Iİ]|İnc(?:İli|il[iİ]))|ın[\\s\\xa0]*(?:incİl[İI]|Incil[iİ]|İnc(?:İli|il[İi]))))|’(?:n(?:ın[\\s\\xa0]*(?:inc(?:IlI|İl[Iİ]|ilİ)|İnc(?:İli|il[iİ]))|in[\\s\\xa0]*(?:incİli|[İI]nc(?:[Iİ]lİ))|In[\\s\\xa0]*(?:İnc(?:İli|ilI)|incIli)|un[\\s\\xa0]*(?:inc(?:İl[iİ]|Il[Iİ])|İnc(?:[Iİ]li|ilİ))|İn[\\s\\xa0]*(?:inc(?:ilI|İlİ)|Inc(?:İli|ilİ)|İnc(?:İli|il[iİ])))|a[\\s\\xa0]*G(?:öre[\\s\\xa0]*(?:İncil|inc[iİ]l)|ore[\\s\\xa0]*(?:[Iİ]ncil|incİl))|in[\\s\\xa0]*(?:incIli|İnc(?:İl[Iİ]|ilİ)|Inc[İi]lİ)|ın[\\s\\xa0]*(?:incİl[Iİ]|Inc(?:Ili|ilİ)|İnc(?:İli|il[İi]))|İn[\\s\\xa0]*(?:IncilI|İnc(?:İli|il[iİ])|inc(?:İl[İI]|ilİ))|In[\\s\\xa0]*(?:İncIli|incİlI)|un[\\s\\xa0]*(?:inc(?:ili|İlİ)|Inc(?:İli|ilİ)|İnc(?:İli|il[Iİ])))|İn[\\s\\xa0]*(?:Incili|İnc(?:İli|il[iİ])|inc(?:İl[İI]|Ilİ)))|Luka(?:’(?:In[\\s\\xa0]*(?:İnc(?:İli|il[İiI])|Inc(?:[Iİ]li|il[İiI])|inc(?:[Ii]l[İiI]|İl[İi]))|n(?:ın[\\s\\xa0]*(?:İnc(?:Ili|ilI)|Inc(?:[Iİ]li|il[İiI])|inc(?:İli|Il[İi]|il[iI]))|in[\\s\\xa0]*(?:(?:[İI]nc(?:il[İiI]|[Iİ]l[iI]))|inc(?:[iI]l[İiI]|İl[Iİ]))|In[\\s\\xa0]*(?:Inc(?:[İI]li|il[iİI])|inc(?:[İi]l[iİI]|Il[Iİ])|İnc(?:Ili|il[iİ]))|İn[\\s\\xa0]*(?:İnc(?:Ili|ilI)|inc(?:Il[iIİ]|il[İi]|İl[iI])|Inc(?:Ili|il[iI]))|un[\\s\\xa0]*(?:inc(?:Ili|İlI|il[iİI])|Inc(?:[Iİ]li|il[Iiİ])|İncil[Ii]))|ın[\\s\\xa0]*(?:İnc(?:Ili|ilI)|Inc(?:İli|il[Ii])|inc(?:İli|[iI]l[iİI]))|in[\\s\\xa0]*(?:Inc(?:Il[iIİ]|[iİ]l[Ii])|inc(?:[iİ]l[iIİ]|Il[Iİ])|İnc(?:İli|Il[iIİ]|il[iI]))|un[\\s\\xa0]*(?:İnc[iI]li|inc(?:Il[İIi]|il[İI]|İl[Ii])|Inc(?:Ili|il[iI]))|a[\\s\\xa0]*G(?:öre[\\s\\xa0]*(?:incIl|Incil)|ore[\\s\\xa0]*inc[iI]l)|İn[\\s\\xa0]*(?:İnc(?:Ili|ilI)|Inc(?:[Iİ]li|il[iİ])|inc(?:İli|Il[İIi]|il[iI])))|'(?:İn[\\s\\xa0]*(?:inc(?:İli|Il[İIi]|il[İI])|Inc(?:[İI]li|il[iI])|İncil[iI])|in[\\s\\xa0]*(?:İnc(?:Il[iİ]|[İi]l[iI])|inc[Iİi]l[Iiİ]|Inc(?:İlI|[iI]l[İiI]))|n(?:ın[\\s\\xa0]*(?:İnc(?:Ili|ilI)|inc(?:İli|[iI]l[Iiİ])|Inc(?:[Iİ]li|ilI))|un[\\s\\xa0]*(?:İnc(?:Ili|ilI)|inc(?:İlI|[iI]l[iİI])|Inc[İiI]li)|In[\\s\\xa0]*(?:[İI]nc(?:(?:[İI]li|il[Iİi]))|inc[İiI]l[İiI])|in[\\s\\xa0]*(?:Inc(?:il[Iİi]|[İI]l[iI])|inc(?:Il[Iİi]|[iİ]l[iİ])|İnc(?:İlI|il[İi]|Il[iI]))|İn[\\s\\xa0]*(?:İnc[iI]li|inc(?:ili|İlI|Il[İIi])|Inc(?:[İI]li|il[İIi])))|ın[\\s\\xa0]*(?:Inc(?:İli|il[İIi])|İnc[Ii]li|inc(?:İli|il[Iİi]|Il[iI]))|In[\\s\\xa0]*(?:Inc(?:[Iİ]li|il[Iİi])|inc(?:İl[iIİ]|il[İi]|Il[iI])|İnc(?:Ili|il[iİI]))|un[\\s\\xa0]*(?:İnc(?:Ili|ilI)|inc(?:Ili|İlI|il[iIİ])|Inc(?:[Iİ]li|il[iIİ]))|a[\\s\\xa0]*G[oö]re[\\s\\xa0]*inc(?:[Ii]l))|İn[\\s\\xa0]*(?:İnc(?:Ili|ilI)|Inc(?:[İI]li|il[Iİ])|inc(?:İli|il[İiI]|Il[iI])))|Luka(?:a[\\s\\xa0]*G(?:[oö]re[\\s\\xa0]*(?:İncil|inc[iİ]l))|n(?:İn[\\s\\xa0]*(?:IncIli|İnc(?:İli|il[İI])|inc(?:İl[İi]|Ilİ))|in[\\s\\xa0]*(?:Incİl[İi]|İnc(?:ilI|[Iİ]lİ))|un[\\s\\xa0]*(?:incİl[iİ]|Incil[Iİ]|İnc(?:İli|il[İI]))|In[\\s\\xa0]*(?:IncIli|incIlİ|İncİli)|ın[\\s\\xa0]*(?:inc(?:Ili|İlİ)|Inc(?:İli|ilİ)|İnc(?:İli|il[iİ])))|un[\\s\\xa0]*(?:inc(?:ili|İl[Iİ]|Ilİ)|İnc(?:[İI]li|ilİ))|ın[\\s\\xa0]*(?:IncIli|İnc(?:İli|il[iİ])|inc(?:İl[İi]|Ilİ))|ya[\\s\\xa0]*G(?:ore[\\s\\xa0]*(?:İncil|inc[İI]l)|öre[\\s\\xa0]*(?:[İI]ncil|incİl))|in(?:[\\s\\xa0]*(?:İnc[İi]l[iİ]|Incilİ|incİlI)|c(?:Ili|İl[İi]|ilİ))|İnc(?:İli|il[Iİ])|In[\\s\\xa0]*(?:IncIli|incİlİ)|'ya[\\s\\xa0]*G(?:[öo]re[\\s\\xa0]*(?:İncil|inc[İi]l))|’ya[\\s\\xa0]*G(?:ore[\\s\\xa0]*(?:İncil|inc[İI]l)|öre[\\s\\xa0]*(?:İncil|inc[iİ]l)))|Luka(?:İnc[iI]li|un[\\s\\xa0]*(?:Inc(?:[Iİ]li|il[İIi])|İncil[Ii]|inc(?:İli|il[Iİ]|Il[Ii]))|’ya[\\s\\xa0]*G(?:ore[\\s\\xa0]*[iI]ncil|öre[\\s\\xa0]*(?:incIl|Incil))|'ya[\\s\\xa0]*G(?:[oö]re[\\s\\xa0]*(?:incIl|Incil))|n(?:un[\\s\\xa0]*(?:İnc[Ii]li|inc(?:İlI|[Ii]l[Iİi])|Inc[iİI]li)|in[\\s\\xa0]*(?:İnc(?:il[İi]|[Iİ]l[Ii])|inc[iIİ]l[İiI]|Inc(?:İlI|[Ii]l[iIİ]))|In[\\s\\xa0]*(?:Inc(?:İli|il[iIİ])|inc(?:[iİ]l[iIİ]|Il[Ii])|İnc(?:Ili|il[Iiİ]))|İn[\\s\\xa0]*(?:Inc(?:İli|il[iIİ])|İnc[Ii]li|inc(?:İlI|il[iİI]|Il[Ii]))|ın[\\s\\xa0]*(?:İnc(?:Ili|ilI)|inc(?:il[iİI]|Il[İI]|İl[Ii])|Inc(?:Ili|il[iI])))|ın[\\s\\xa0]*(?:Inc(?:İli|il[iİI])|İnc(?:Ili|ilI)|inc(?:İlI|il[Iİi]|Il[iI]))|a[\\s\\xa0]*G(?:[öo]re[\\s\\xa0]*(?:incIl|Incil))|In(?:c(?:[Iİ]li|il[iIİ])|[\\s\\xa0]*(?:Inc(?:İli|il[Iiİ])|İnc(?:[Iİ]li|il[iİI])|inc(?:[Ii]l[Iİi]|İl[iI])))|in(?:[\\s\\xa0]*(?:İnc(?:[İi]lI|Il[iIİ])|inc(?:[iI]l[İIi]|İl[iİ])|Inc(?:[İI]l[Iiİ]|il[iI]))|c(?:İlI|Il[Iİ]|il[iI]))|ya[\\s\\xa0]*G(?:ore[\\s\\xa0]*[Ii]ncil|öre[\\s\\xa0]*inc[iI]l))?)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["1John"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:1(?:[\s\xa0]*Yu(?:h(?:anna)?)?|Yu|John|\.[\s\xa0]*Yu(?:h(?:anna)?)?)|I(?:[\s\xa0]*Yu(?:h(?:anna)?)?|lk[\s\xa0]*Yu(?:h(?:anna)?)?|\.[\s\xa0]*Yu(?:h(?:anna)?)?)|B(?:[Iİ]r(?:[\s\xa0]*Yu(?:h(?:anna)?)?|(?:[Iİ]nc(?:[Iİ][\s\xa0]*Yu(?:h(?:anna)?)?))))|İlk[\s\xa0]*Yu(?:h(?:anna)?)?|Yuhanna(?:(?:['’]n(?:[Iİı]n[\s\xa0]*(?:I(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu|lk[\s\xa0]*Mektubu)|İlk[\s\xa0]*Mektubu|B(?:[Iİ]r(?:[\s\xa0]*Mektubu|[Iİ]nc(?:[Iİ][\s\xa0]*Mektubu)))|1(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu))))|n(?:[Iİı]n[\s\xa0]*(?:I(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu|lk[\s\xa0]*Mektubu)|İlk[\s\xa0]*Mektubu|B(?:[Iİ]r(?:[\s\xa0]*Mektubu|[Iİ]nc(?:[Iİ][\s\xa0]*Mektubu)))|1(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu)))))|(?:B(?:ir(?:[\s\xa0]*Yu(?:h(?:anna)?)?|(?:[İIi]nc(?:[iIİ][\s\xa0]*Yu(?:h(?:anna)?)?)))|(?:[İI]r(?:(?:[Iİ]nci[\s\xa0]*Yu(?:h(?:anna)?)?)|inc(?:[iIİ][\s\xa0]*Yu(?:h(?:anna)?)?))))|ilk[\s\xa0]*Yu(?:h(?:anna)?)?|Yuhanna(?:(?:[’']n(?:in[\s\xa0]*(?:I(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu|lk[\s\xa0]*Mektubu)|[İi]lk[\s\xa0]*Mektubu|1(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu)|B(?:[iİI]r(?:[\s\xa0]*Mektubu|[iİI]nc(?:[İIi][\s\xa0]*Mektubu))))|(?:[ıİI]n[\s\xa0]*(?:ilk[\s\xa0]*Mektubu|B(?:[Iİ]r(?:(?:[İI]nci[\s\xa0]*Mektubu|inc[Iiİ][\s\xa0]*Mektubu))|ir(?:[\s\xa0]*Mektubu|[iİI]nc(?:[iİI][\s\xa0]*Mektubu)))))))|n(?:in[\s\xa0]*(?:I(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu|lk[\s\xa0]*Mektubu)|[iİ]lk[\s\xa0]*Mektubu|1(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu)|B(?:[İIi]r(?:[\s\xa0]*Mektubu|[iIİ]nc(?:[Iİi][\s\xa0]*Mektubu))))|(?:[Iıİ]n[\s\xa0]*(?:ilk[\s\xa0]*Mektubu|B(?:[İI]r(?:(?:[İI]nci[\s\xa0]*Mektubu|inc[İIi][\s\xa0]*Mektubu))|ir(?:[\s\xa0]*Mektubu|[Iiİ]nc(?:[Iİi][\s\xa0]*Mektubu)))))))))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["2John"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:2(?:[\s\xa0]*Yu(?:h(?:anna)?)?|Yu|John|\.[\s\xa0]*Yu(?:h(?:anna)?)?)|I(?:I(?:[\s\xa0]*Yu(?:h(?:anna)?)?|\.[\s\xa0]*Yu(?:h(?:anna)?)?)|k(?:[Iİ](?:[\s\xa0]*Yu(?:h(?:anna)?)?|nc(?:[Iİ][\s\xa0]*Yu(?:h(?:anna)?)?))))|İk(?:[Iİ](?:[\s\xa0]*Yu(?:h(?:anna)?)?|nc(?:[Iİ][\s\xa0]*Yu(?:h(?:anna)?)?)))|Yuhanna(?:(?:['’]n(?:[Iİı]n[\s\xa0]*(?:İk(?:[Iİ](?:[\s\xa0]*Mektubu|nc[Iİ][\s\xa0]*Mektubu))|2(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu)|I(?:I(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu)|k(?:[Iİ](?:[\s\xa0]*Mektubu|nc[Iİ][\s\xa0]*Mektubu))))))|n(?:[Iİı]n[\s\xa0]*(?:İk(?:[Iİ](?:[\s\xa0]*Mektubu|nc[Iİ][\s\xa0]*Mektubu))|2(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu)|I(?:I(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu)|k(?:[Iİ](?:[\s\xa0]*Mektubu|nc[Iİ][\s\xa0]*Mektubu)))))))|(?:Yuhanna(?:(?:['’]n(?:(?:[Iıİ]n[\s\xa0]*(?:(?:[İI]k(?:i(?:[\s\xa0]*Mektubu|nc[iİI][\s\xa0]*Mektubu)|[Iİ]nci[\s\xa0]*Mektubu))|ik(?:[iIİ](?:[\s\xa0]*Mektubu|nc[Iİi][\s\xa0]*Mektubu))))|in[\s\xa0]*(?:I(?:k(?:[İiI](?:[\s\xa0]*Mektubu|nc[Iiİ][\s\xa0]*Mektubu))|I(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu))|(?:[iİ]k(?:[İiI](?:[\s\xa0]*Mektubu|nc[iIİ][\s\xa0]*Mektubu)))|2(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu))))|n(?:(?:[Iİı]n[\s\xa0]*(?:(?:[İI]k(?:i(?:[\s\xa0]*Mektubu|nc[iİI][\s\xa0]*Mektubu)|[İI]nci[\s\xa0]*Mektubu))|ik(?:[iIİ](?:[\s\xa0]*Mektubu|nc[İiI][\s\xa0]*Mektubu))))|in[\s\xa0]*(?:I(?:k(?:[Iiİ](?:[\s\xa0]*Mektubu|nc[iİI][\s\xa0]*Mektubu))|I(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu))|(?:[iİ]k(?:[iİI](?:[\s\xa0]*Mektubu|nc[İIi][\s\xa0]*Mektubu)))|2(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu))))|(?:[İI]k(?:(?:[İI]nci[\s\xa0]*Yu(?:h(?:anna)?)?)|i(?:[\s\xa0]*Yu(?:h(?:anna)?)?|nc(?:[iIİ][\s\xa0]*Yu(?:h(?:anna)?)?))))|ik(?:[iİI](?:[\s\xa0]*Yu(?:h(?:anna)?)?|nc(?:[Iiİ][\s\xa0]*Yu(?:h(?:anna)?)?)))))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["3John"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:(?:[UÜ](?:[cç](?:[\s\xa0]*Yu(?:h(?:anna)?)?|(?:[uü]nc(?:[uü][\s\xa0]*Yu(?:h(?:anna)?)?)))))|3(?:[\s\xa0]*Yu(?:h(?:anna)?)?|Yu|John|\.[\s\xa0]*Yu(?:h(?:anna)?)?)|III(?:[\s\xa0]*Yu(?:h(?:anna)?)?|\.[\s\xa0]*Yu(?:h(?:anna)?)?)|Yuhanna(?:n[Iİı]n[\s\xa0]*(?:(?:[UÜ](?:[cç](?:(?:[uü]nc(?:[uü][\s\xa0]*Mektubu)|[\s\xa0]*Mektubu)))|3(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu)|III(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu)))|['’]n(?:[Iİı]n[\s\xa0]*(?:(?:[UÜ](?:[cç](?:(?:[uü]nc(?:[uü][\s\xa0]*Mektubu)|[\s\xa0]*Mektubu)))|3(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu)|III(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu))))))|Yuhanna(?:['’]nin[\s\xa0]*(?:(?:[ÜU](?:[çc](?:(?:[üu]nc(?:[üu][\s\xa0]*Mektubu)|[\s\xa0]*Mektubu)))|3(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu)|III(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu)))|nin[\s\xa0]*(?:[ÜU](?:[cç](?:(?:[uü]nc(?:[uü][\s\xa0]*Mektubu)|[\s\xa0]*Mektubu)))|3(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu)|III(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu))))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["John"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Yuhanna(?:['’](?:n(?:[Iuİı]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ]))|[Iuİı]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ]))|a[\\s\\xa0]*G[oö]re[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l))))|[Iİ]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ])))|Yuhanna['’](?:(?:[Iuİı]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ]))|a[\\s\\xa0]*G[oö]re[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l))))|(?:John|Yu(?:h(?:anna(?:ya[\\s\\xa0]*G[oö]re[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l))|[Iİ]nc(?:[Iİ]l[Iİ])|[’']ya[\\s\\xa0]*G(?:[oö]re[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l)))|n[Iuİı]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ]))|[ıu]n[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l[Iİ]))|a[\\s\\xa0]*G[oö]re[\\s\\xa0]*(?:[Iİ]nc(?:[Iİ]l))))?)?)|Yuhanna(?:'(?:in[\\s\\xa0]*(?:İnc(?:Il[iİ]|İl[Iİ])|IncİlI)|ın[\\s\\xa0]*(?:inc(?:İl[iİ]|Il[Iİ])|İnc(?:İli|il[Iİ]))|In[\\s\\xa0]*inc(?:il[iİ]|İlİ)|n(?:in[\\s\\xa0]*(?:Inc(?:Il[Iİ]|İlİ)|İnc(?:İl[iİ]|Ilİ))|ın[\\s\\xa0]*(?:Incilİ|inc(?:ilI|İl[Iİ])|İnc(?:İli|il[İI]))|un[\\s\\xa0]*(?:IncilI|İnc(?:İli|il[iİ])|inc(?:İl[Iİ]|Ilİ))|İn[\\s\\xa0]*(?:inc[İi]l[İI]|İnc(?:[Iİ]li|ilİ))|In[\\s\\xa0]*(?:İncili|incİlI))|un[\\s\\xa0]*(?:inc(?:il[iİ]|İl[Iİ])|İnc(?:[İI]li|ilİ))|a[\\s\\xa0]*G[oö]re[\\s\\xa0]*(?:(?:[Iİ]ncil|incİl))|İn[\\s\\xa0]*(?:inc(?:ilI|İlİ)|Inc(?:İli|ilİ)|İnc(?:İli|il[Iİ])))|’(?:n(?:ın[\\s\\xa0]*(?:inc(?:ilI|İl[Iİ]|Ilİ)|İnc(?:İli|il[Iİ]))|un[\\s\\xa0]*(?:Inc(?:İli|ilİ)|inc(?:ili|İlİ)|İnc(?:[Iİ]li|ilİ))|İn[\\s\\xa0]*(?:Inc(?:İli|ilI)|İnc(?:İli|il[Iİ])|inc[iİ]lİ)|In[\\s\\xa0]*(?:İnc[iİ]li|incİlİ)|in[\\s\\xa0]*(?:inc(?:İlI|ilİ)|IncIli|İnc[İI]lİ))|in[\\s\\xa0]*(?:IncIlİ|incİlI|İnc(?:ili|İl[iİ]))|ın[\\s\\xa0]*(?:Inc[iİ]li|İnc(?:İli|il[İi])|inc[Iİ]lİ)|a[\\s\\xa0]*G[oö]re[\\s\\xa0]*(?:(?:[Iİ]ncil|incİl))|un[\\s\\xa0]*(?:İnc(?:[İI]li|ilİ)|Incilİ|inc(?:ili|İl[İi]))|In[\\s\\xa0]*(?:inc(?:ili|İlİ)|İncilİ)|İn[\\s\\xa0]*(?:Incili|İnc(?:[İI]li|ilİ)|inc(?:İl[İi]|Ilİ)))|İn[\\s\\xa0]*(?:inc[iİ]l[Iİ]|İnc(?:İli|il[iİ])))|Yuhanna(?:’(?:un[\\s\\xa0]*(?:inc(?:İlI|Il[İiI]|il[Iİ])|Inc(?:[Iİ]li|il[Ii])|İncil[Ii])|In[\\s\\xa0]*(?:Inc(?:[Iİ]li|il[iIİ])|İnc(?:[İI]li|il[iI])|inc(?:Il[Iiİ]|il[Iİ]|İl[iI]))|İn[\\s\\xa0]*(?:Inc(?:[İI]li|il[İI])|İncil[iI]|inc(?:İlI|il[Iİi]|Il[Ii]))|ın[\\s\\xa0]*(?:İnc(?:Ili|ilI)|inc(?:il[İIi]|[Iİ]l[iI])|Inc(?:Ili|il[Iİ]))|a[\\s\\xa0]*G[oö]re[\\s\\xa0]*inc(?:[iI]l)|n(?:In[\\s\\xa0]*(?:Inc(?:[Iİ]li|il[Iiİ])|İnc(?:Ili|il[İI])|inc(?:[iI]l[İIi]|İl[iI]))|ın[\\s\\xa0]*(?:İnc[iI]li|Inc(?:[Iİ]li|il[iİI])|inc(?:İli|il[iİ]|Il[Ii]))|un[\\s\\xa0]*(?:İncil[iI]|inc(?:Il[iİI]|il[Iİ]|İl[Ii])|Inc(?:Ili|il[Ii]))|İn[\\s\\xa0]*(?:İnc[iI]li|inc(?:Il[İiI]|[iİ]l[Ii])|Inc(?:Ili|il[İi]))|in[\\s\\xa0]*(?:İnc(?:il[iİI]|[Iİ]l[Ii])|Inc(?:[iİ]l[iİI]|Il[Iİ])|inc(?:Il[iİI]|İl[iİ]|il[Ii])))|in[\\s\\xa0]*(?:İnc(?:İlI|Il[Iİi]|il[İI])|inc(?:[Ii]l[İiI]|İl[iİ])|Inc(?:[iİ]l[İiI]|Il[Ii])))|'(?:In[\\s\\xa0]*(?:[Iİ]nc(?:(?:[Iİ]li|il[iIİ]))|inc(?:ilI|Il[iİI]|İl[Ii]))|n(?:in[\\s\\xa0]*(?:inc[İIi]l[Iİi]|İnc(?:İlI|il[Iİi]|Il[Ii])|Inc(?:Ili|il[Iiİ]|İl[Ii]))|ın[\\s\\xa0]*(?:inc(?:İli|Il[iIİ]|il[İi])|İnc[iI]li|Inc(?:[İI]li|il[iI]))|İn[\\s\\xa0]*(?:inc(?:[iİ]li|Il[İiI])|Inc(?:[İI]li|il[İIi])|İncil[iI])|un[\\s\\xa0]*(?:İnc(?:Ili|ilI)|Inc(?:[İI]li|il[İi])|inc(?:İli|il[Iiİ]|Il[Ii]))|In[\\s\\xa0]*(?:Inc(?:[Iİ]li|il[iİI])|inc(?:[iI]l[iİI]|İl[iİ])|İnc(?:[İI]li|il[İI])))|in[\\s\\xa0]*(?:İnc(?:İli|IlI|il[Iİi])|Inc(?:[iI]l[iİI]|İl[İi])|inc[iİI]l[iIİ])|İn[\\s\\xa0]*(?:İnc[Ii]li|inc(?:Il[İIi]|il[İi]|İl[iI])|Inc(?:Ili|il[Ii]))|un[\\s\\xa0]*(?:inc(?:İli|ilI|Il[Iİi])|Inc(?:[Iİ]li|il[İIi])|İncil[Ii])|ın[\\s\\xa0]*(?:İnc[iI]li|inc(?:Ili|İlI|il[Iiİ])|Inc(?:[Iİ]li|il[Iİi]))|a[\\s\\xa0]*G[öo]re[\\s\\xa0]*inc(?:[Ii]l))|İn[\\s\\xa0]*(?:İnc(?:Ili|ilI)|Inc(?:[Iİ]li|il[İIi])|inc(?:[İi]li|Il[İiI])))|Yuhanna(?:n(?:In[\\s\\xa0]*(?:İncil[İI]|inc(?:IlI|İl[İi]))|ın[\\s\\xa0]*(?:incİl[İi]|Inc(?:Ili|ilİ)|İnc(?:İli|il[Iİ]))|un[\\s\\xa0]*(?:Incİli|İnc(?:İli|il[iİ])|inc(?:il[İI]|İlİ))|in[\\s\\xa0]*(?:İncİl[iİ]|IncIlİ)|İn[\\s\\xa0]*(?:İnc(?:[Iİ]li|ilİ)|Incilİ|inc(?:IlI|İl[Iİ])))|a[\\s\\xa0]*G(?:öre[\\s\\xa0]*(?:İncil|inc[Iİ]l)|ore[\\s\\xa0]*(?:[İI]ncil|incİl))|in(?:[\\s\\xa0]*(?:İnc(?:ilI|İl[İi]|Ilİ)|IncİlI)|c(?:İl[İi]|Ilİ))|In(?:[\\s\\xa0]*inc(?:ili|[Iİ]lİ)|cili)|ya[\\s\\xa0]*G(?:öre[\\s\\xa0]*(?:İncil|inc[İI]l)|ore[\\s\\xa0]*(?:İncil|inc[iİ]l))|İnc(?:İli|il[iİ])|ın[\\s\\xa0]*(?:Incİli|İnc(?:İli|il[İi])|inc(?:Il[İI]|İlİ))|’ya[\\s\\xa0]*G(?:[öo]re[\\s\\xa0]*(?:İncil|inc[İI]l))|'ya[\\s\\xa0]*G(?:[öo]re[\\s\\xa0]*(?:İncil|inc[İi]l))|un[\\s\\xa0]*(?:IncIli|İnc(?:[Iİ]li|ilİ)|inc(?:İl[iİ]|ilİ)))|Yuhanna(?:İnc(?:Ili|ilI)|n(?:İn[\\s\\xa0]*(?:inc(?:İli|il[Iiİ]|Il[İi])|Inc(?:[İI]li|il[Ii])|İncil[Ii])|in[\\s\\xa0]*(?:inc[Iiİ]l[iIİ]|Inc(?:[iİ]l[Iiİ]|Il[Ii])|İnc(?:İlI|[Ii]l[iİI]))|un[\\s\\xa0]*(?:İnc(?:Ili|ilI)|Inc(?:Ili|il[Iiİ])|inc(?:ili|Il[Iiİ]|İl[Ii]))|In[\\s\\xa0]*(?:inc(?:İlI|il[iIİ]|Il[İi])|Inc(?:[İI]li|il[İiI])|İnc[iIİ]li)|ın[\\s\\xa0]*(?:İnc[iI]li|Inc(?:İli|il[iI])|inc(?:İlI|[iI]l[Iİi])))|un[\\s\\xa0]*(?:Inc(?:İli|il[İiI])|İncil[Ii]|inc(?:İlI|Il[Iİi]|il[iI]))|ya[\\s\\xa0]*G(?:öre[\\s\\xa0]*[iI]ncil|ore[\\s\\xa0]*(?:incIl|Incil))|ın[\\s\\xa0]*(?:İnc(?:Ili|ilI)|Inc(?:Ili|il[İiI])|inc(?:Ili|il[Iiİ]|İl[Ii]))|’ya[\\s\\xa0]*G[oö]re[\\s\\xa0]*(?:[Ii]ncil)|'ya[\\s\\xa0]*G(?:[öo]re[\\s\\xa0]*(?:incIl|Incil))|in(?:c(?:İlI|il[Iiİ]|Il[Ii])|[\\s\\xa0]*(?:Inc(?:[Ii]l[İIi]|İl[iİ])|inc[Iiİ]l[Iİi]|İnc(?:İlI|il[iİ]|Il[iI])))|a[\\s\\xa0]*G(?:öre[\\s\\xa0]*[iI]ncil|ore[\\s\\xa0]*inc[Ii]l)|In(?:c(?:[İI]li|il[Iİ])|[\\s\\xa0]*(?:[Iİ]nc(?:(?:[İI]li|il[Iiİ]))|inc(?:il[İI]|[İI]l[Ii]))))?)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Acts"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Kutsal[\\s\\xa0]*Resuller[Iİ]n[\\s\\xa0]*(?:[Iİ](?:[sş]ler[Iİ]))|E(?:\\.[\\s\\xa0]*(?:[Iİ](?:[sş](?:l(?:er[Iİ])?)?))|(?:[cç](?:\\.[\\s\\xa0]*(?:[Iİ](?:[sş](?:l(?:er[Iİ])?)?))|[\\s\\xa0]*(?:[Iİ](?:[sş](?:l(?:er[Iİ])?)?))))|[\\s\\xa0]*(?:[Iİ](?:[sş](?:l(?:er[Iİ])?)?))|l(?:\\.[\\s\\xa0]*(?:[Iİ](?:[sş](?:l(?:er[Iİ])?)?))|[\\s\\xa0]*(?:[Iİ](?:[sş](?:l(?:er[Iİ])?)?))|(?:[cç](?:\\.[\\s\\xa0]*(?:[Iİ](?:[sş](?:l(?:er[Iİ])?)?))|[Iİ]ler(?:[Iİ]n[\\s\\xa0]*(?:[Iİ](?:[sş]ler[Iİ])))|[\\s\\xa0]*(?:[Iİ](?:[sş](?:l(?:er[Iİ])?)?))))))|Ha(?:berc[Iİ]ler(?:[Iİ]n[\\s\\xa0]*(?:[Iİ](?:[sş]ler[Iİ])))|var[Iİ]ler(?:[Iİ]n[\\s\\xa0]*Faal(?:[Iİ]yetler[Iİ])))|Acts)|El[cç]İlerİn[\\s\\xa0]*(?:i(?:[şs]ler[iIİ]|[Iİ](?:[şs]leri)))|El[çc]İlerİn[\\s\\xa0]*(?:[İI](?:[şs]leri))|E(?:c\\.[\\s\\xa0]*Isleri|l(?:ç\\.[\\s\\xa0]*Isleri|[c\\.][\\s\\xa0]*Isleri))|(?:E(?:c(?:\\.[\\s\\xa0]*(?:İ[sş]leri|i(?:ş(?:l(?:er[iİ])?)?|s(?:l(?:erİ)?)?))|[\\s\\xa0]*(?:İ[sş]leri|Isleri|i(?:ş(?:l(?:er[İI])?)?|s(?:l(?:erİ)?)?)))|[\\s\\xa0]*(?:i(?:[sş](?:l(?:er[iİ])?)?)|İ[sş]leri)|ç(?:[\\s\\xa0]*(?:i(?:s(?:l(?:er[Iİ])?)?|ş(?:l(?:er[iİ])?)?)|İ[sş]leri)|\\.[\\s\\xa0]*(?:İ[şs]leri|Isleri|i(?:ş(?:l(?:er[İI])?)?|s(?:l(?:erİ)?)?)))|l(?:[\\s\\xa0]*(?:i(?:s(?:l(?:er[Iİ])?)?|ş(?:l(?:er[iİ])?)?)|İ[şs]leri)|\\.[\\s\\xa0]*(?:İ[şs]leri|i(?:ş(?:l(?:er[iİ])?)?|s(?:l(?:erİ)?)?))|c(?:İler(?:In[\\s\\xa0]*(?:Işleri|[iİ]sleri)|in[\\s\\xa0]*(?:Işlerİ|islerİ|İ(?:şler[Iİ]|slerİ)))|[\\s\\xa0]*(?:İ[şs]leri|i(?:ş(?:l(?:er[iİ])?)?|s(?:l(?:erİ)?)?))|Iler(?:in[\\s\\xa0]*İslerİ|İn[\\s\\xa0]*[iİ]şleri|In[\\s\\xa0]*islerI)|iler(?:In[\\s\\xa0]*(?:İşlerI|Işleri)|İn[\\s\\xa0]*(?:I(?:sleri|şlerİ)|islerİ|İ(?:sler[iİ]|şlerİ))|in[\\s\\xa0]*(?:işlerİ|İ(?:slerI|şlerİ)|Islerİ))|\\.[\\s\\xa0]*(?:İ[sş]leri|Isleri|i(?:ş(?:l(?:er[Iİ])?)?|s(?:l(?:erİ)?)?)))|ç(?:Iler(?:in[\\s\\xa0]*(?:Işleri|islerİ|İ[sş]lerİ)|In[\\s\\xa0]*isleri|İn[\\s\\xa0]*işlerİ)|[\\s\\xa0]*(?:Işleri|İ[şs]leri|i(?:s(?:l(?:er[iİ])?)?|ş(?:l(?:erİ)?)?))|İler(?:in[\\s\\xa0]*(?:Işleri|İ(?:sler[İI]|şlerİ)|isleri)|In[\\s\\xa0]*(?:İşleri|i[şs]lerİ))|iler(?:İn[\\s\\xa0]*(?:i(?:sleri|şlerI)|İ(?:şler[Iİ]|sler[İi])|Islerİ)|in[\\s\\xa0]*(?:Işlerİ|İ(?:sleri|şlerI)))|\\.[\\s\\xa0]*(?:İ[şs]leri|i(?:ş(?:l(?:er[iİ])?)?|s(?:l(?:erİ)?)?))))|\\.[\\s\\xa0]*(?:i(?:ş(?:l(?:er[Iİ])?)?|s(?:l(?:er[iİ])?)?)|İ[sş]leri))|Ha(?:berc(?:İler(?:İn[\\s\\xa0]*(?:İ[sş]leri|i[şs]ler[Iİ])|in[\\s\\xa0]*(?:i(?:şlerI|slerİ)|I(?:slerI|şlerİ)|İ[şs]ler[iİ]))|iler(?:In[\\s\\xa0]*(?:işlerİ|İ(?:şlerI|slerİ)|I(?:sleri|şlerI))|İn[\\s\\xa0]*(?:IşlerI|İ[sş]ler[iİ]|i(?:sler[İI]|şlerİ))|in[\\s\\xa0]*(?:İ(?:slerI|şlerİ)|Islerİ)))|var(?:iler(?:in[\\s\\xa0]*Faalİyetlerİ|İn[\\s\\xa0]*Faal(?:iyetleri|İyetler[iİ]))|İler(?:In[\\s\\xa0]*Faaliyetlerİ|in[\\s\\xa0]*Faal(?:iyetlerI|İyetler[iİ])|İn[\\s\\xa0]*Faal(?:iyetlerİ|[Iİ]yetleri))|Iler(?:in[\\s\\xa0]*Faal(?:Iyetlerİ|İyetleri)|İn[\\s\\xa0]*Faaliyetlerİ|In[\\s\\xa0]*FaalIyetleri)))|Kutsal[\\s\\xa0]*Resuller(?:In[\\s\\xa0]*[İI]şleri|in[\\s\\xa0]*(?:İ(?:sler[Iİ]|şlerİ)|i[sş]lerİ|IslerI)|İn[\\s\\xa0]*(?:İ[şs]leri|i[şs]ler[Iİ]))|Resullerİn[\\s\\xa0]*İ[sş]lerİ)|(?:E(?:\\.[\\s\\xa0]*(?:i(?:şleri|slerI)|I[şs]leri)|c(?:[\\s\\xa0]*(?:i(?:şleri|sler[Ii])|Işleri)|\\.[\\s\\xa0]*(?:i(?:şlerI|sler[Ii])|Işleri))|l(?:c(?:iler(?:in[\\s\\xa0]*(?:i(?:sler[Iİi]|şler[iI])|I(?:şler[İiI]|sler[Ii])|İ(?:şler[iI]|sler[İi]))|In[\\s\\xa0]*(?:i[sş]ler[iİI]|İ(?:sler[Iİi]|şler[iİ])|I(?:sler[Iİi]|şler[Iİ]))|İn[\\s\\xa0]*(?:i(?:şler[Iİi]|sler[Ii])|İ(?:slerI|şler[Ii])|I(?:şler[iI]|sler[Iİ])))|Iler(?:İn[\\s\\xa0]*(?:I[şs]leri|i(?:sler[Iİi]|şler[Iİ])|İsleri)|in[\\s\\xa0]*(?:İ(?:şler[iIİ]|sler[Ii])|[iI](?:[şs]ler[İiI]))|In[\\s\\xa0]*(?:[Iİ](?:[şs]leri)|i(?:şler[iIİ]|sler[iİ])))|İler(?:In[\\s\\xa0]*(?:İşleri|i(?:şler[iİI]|sler[Iİ])|Isleri)|in[\\s\\xa0]*(?:I(?:sler[İIi]|şler[iI])|i(?:şler[İIi]|sler[iI])|İ(?:şleri|sler[Ii])))|[\\s\\xa0]*(?:i(?:şlerI|sler[iI])|Işleri)|\\.[\\s\\xa0]*(?:i(?:şleri|sler[iI])|Işleri))?|[\\s\\xa0]*(?:i(?:sleri|şlerI)|I[şs]leri)|ç(?:iler(?:İn[\\s\\xa0]*(?:I(?:şler[Iİi]|sler[Ii])|İ(?:şleri|slerI)|i(?:sler[İI]|şler[İi]))|In[\\s\\xa0]*[Iİi](?:[şs]ler[İIi])|in[\\s\\xa0]*(?:I(?:sler[İiI]|şler[iI])|i[şs]ler[İIi]|İ(?:sler[Iİ]|şler[İi])))|İler(?:in[\\s\\xa0]*(?:İ(?:sleri|şler[Ii])|i(?:şler[iİI]|sler[İI])|I(?:sler[İIi]|şler[İI]))|In[\\s\\xa0]*(?:i[sş]ler[iI]|I[şs]leri|İsleri))|Iler(?:İn[\\s\\xa0]*(?:i(?:sler[İiI]|şler[Ii])|[İI](?:[sş]leri))|In[\\s\\xa0]*(?:[Iİ](?:[sş]leri)|i(?:şler[İIi]|sler[İI]))|in[\\s\\xa0]*(?:İ[sş]ler[iI]|i(?:şler[İIi]|sler[Ii])|I(?:sler[iİI]|şler[İI])))|[\\s\\xa0]*(?:i(?:slerI|şler[iI])|Isleri)|\\.[\\s\\xa0]*(?:i(?:şlerI|sler[iI])|Işleri))?|\\.[\\s\\xa0]*(?:i(?:şlerI|sler[iI])|Işleri))|[\\s\\xa0]*(?:i[sş]lerI|I[sş]leri)|ç(?:[\\s\\xa0]*(?:i(?:sleri|şlerI)|I[şs]leri)|\\.[\\s\\xa0]*(?:i(?:şleri|sler[Ii])|Işleri)))|Ha(?:var(?:İler(?:In[\\s\\xa0]*Faal(?:iyetler[Ii]|[İI]yetleri)|İn[\\s\\xa0]*Faaliyetler[Ii]|in[\\s\\xa0]*Faal(?:İyetlerI|Iyetler[İiI]|iyetler[İi]))|iler(?:in[\\s\\xa0]*Faal(?:İyetler[iI]|[Ii]yetler[Iiİ])|In[\\s\\xa0]*Faal[İiI]yetler[Iiİ]|İn[\\s\\xa0]*Faal(?:İyetlerI|Iyetler[İIi]|iyetler[Iİ]))|Iler(?:In[\\s\\xa0]*Faal(?:İyetleri|iyetler[Iİi])|İn[\\s\\xa0]*Faal(?:iyetler[Ii]|[Iİ]yetleri)|in[\\s\\xa0]*Faal(?:Iyetler[Ii]|iyetler[İiI]|İyetler[İI])))|berc(?:iler(?:in[\\s\\xa0]*(?:I(?:şler[iIİ]|sler[Ii])|i[sş]ler[İIi]|İ(?:şler[iI]|sler[iİ]))|İn[\\s\\xa0]*(?:i(?:sleri|şler[iI])|İ[sş]lerI|I(?:sler[iIİ]|şler[İi]))|In[\\s\\xa0]*(?:i(?:sler[Iİi]|şler[Ii])|I(?:sler[Iİ]|şler[İi])|İ(?:sler[iI]|şler[İi])))|Iler(?:in[\\s\\xa0]*[Iiİ](?:[sş]ler[Iiİ])|[Iİ]n[\\s\\xa0]*(?:i(?:[sş]ler[Iiİ]|[Iİ](?:[sş]leri))))|İler(?:in[\\s\\xa0]*(?:İ[sş]lerI|I(?:şler[Ii]|sler[iİ])|i(?:sler[Ii]|şler[İi]))|In[\\s\\xa0]*(?:i[şs]ler[İIi]|[İI](?:[şs]leri))|İn[\\s\\xa0]*[iI](?:[şs]leri))))|Resuller(?:[Ii]n[\\s\\xa0]*(?:[İiI](?:[sş]ler[iİI]))|İn[\\s\\xa0]*(?:İ[sş]ler[iI]|[iI](?:[şs]ler[Iİi])))|Kutsal[\\s\\xa0]*Resuller(?:In[\\s\\xa0]*(?:i[şs]ler[Iİi]|[Iİ]sleri)|İn[\\s\\xa0]*[Ii](?:[şs]leri)|in[\\s\\xa0]*(?:i[şs]ler[iI]|İ(?:sleri|şler[Ii])|I(?:şler[iIİ]|sler[iİ]))))|HabercIler[İI]n[\\s\\xa0]*(?:[Iİ](?:[sş]leri)))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Rom"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Rom|Pavlus(?:['’]tan[\\s\\xa0]*Romal(?:[Iİı]lar(?:(?:['’]a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup)))|tan[\\s\\xa0]*Romal[Iİı]lar(?:(?:['’]a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup))))|(?:Pavlus(?:[’']tan[\\s\\xa0]*Romal(?:ilar(?:(?:[’']a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup)?|[Iİı]lar))|tan[\\s\\xa0]*Romal(?:ilar(?:[’']a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup)?|[İIı]lar))|Romal[Iİiı]lar(?:(?:['’]a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup)?))|Pavlus[’']tan[\\s\\xa0]*Romal(?:[Iİı]lar))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["2Cor"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:I(?:k(?:[Iİ](?:[\s\xa0]*Ko(?:r(?:[Iİ]nt(?:oslular|l[Iİ]ler)?)?)?|nc(?:[Iİ][\s\xa0]*Ko(?:r(?:[Iİ]nt(?:oslular|l[Iİ]ler)?)?)?)))|I(?:\.[\s\xa0]*Ko(?:r(?:[Iİ]nt(?:oslular|l[Iİ]ler)?)?)?|[\s\xa0]*Ko(?:r(?:[Iİ]nt(?:oslular|l[Iİ]ler)?)?)?))|Kor(?:[Iİ]ntoslular(?:a[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|İk(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))|(?:['’]a[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|İk(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup))))))|İk(?:[Iİ](?:[\s\xa0]*Ko(?:r(?:[Iİ]nt(?:oslular|l[Iİ]ler)?)?)?|nc(?:[Iİ][\s\xa0]*Ko(?:r(?:[Iİ]nt(?:oslular|l[Iİ]ler)?)?)?)))|2(?:\.[\s\xa0]*Ko(?:r(?:[Iİ]nt(?:oslular|l[Iİ]ler)?)?)?|Ko|[\s\xa0]*Ko(?:r(?:[Iİ]nt(?:oslular|l[Iİ]ler)?)?)?|Cor)|Pavlus(?:(?:['’]tan[\s\xa0]*Kor(?:[Iİ]ntl(?:[Iİ]ler(?:e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|İk(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))|(?:['’]e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|İk(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup))))))))|tan[\s\xa0]*Kor(?:[Iİ]ntl(?:[Iİ]ler(?:e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|İk(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))|(?:['’]e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|İk(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))))))))|(?:Pavlus(?:tan[\s\xa0]*Kor(?:intl(?:[Iiİ]ler(?:(?:['’]e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[iIİ](?:[\s\xa0]*Mektup|nc[iİI][\s\xa0]*Mektup)))|(?:[İi]k(?:[Iiİ](?:[\s\xa0]*Mektup|nc[İIi][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[iIİ](?:[\s\xa0]*Mektup|nc[Iiİ][\s\xa0]*Mektup)))|(?:[İi]k(?:[Iİi](?:[\s\xa0]*Mektup|nc[iİI][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))))|(?:[İI]ntl(?:(?:[Iİ]ler(?:(?:['’]e[\s\xa0]*(?:ik(?:[Iİi](?:[\s\xa0]*Mektup|nc[iİI][\s\xa0]*Mektup))|(?:[Iİ]k(?:i(?:[\s\xa0]*Mektup|nc[iIİ][\s\xa0]*Mektup)|[İI]nci[\s\xa0]*Mektup))))|e[\s\xa0]*(?:ik(?:[iIİ](?:[\s\xa0]*Mektup|nc[Iiİ][\s\xa0]*Mektup))|(?:[İI]k(?:i(?:[\s\xa0]*Mektup|nc[iIİ][\s\xa0]*Mektup)|[Iİ]nci[\s\xa0]*Mektup)))))|iler(?:(?:['’]e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[İiI](?:[\s\xa0]*Mektup|nc[İIi][\s\xa0]*Mektup)))|(?:[İi]k(?:[Iiİ](?:[\s\xa0]*Mektup|nc[iİI][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iİi](?:[\s\xa0]*Mektup|nc[iİI][\s\xa0]*Mektup)))|(?:[İi]k(?:[İIi](?:[\s\xa0]*Mektup|nc[İIi][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))))))|(?:[’']tan[\s\xa0]*Kor(?:intl(?:[iİI]ler(?:(?:['’]e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iİi](?:[\s\xa0]*Mektup|nc[Iiİ][\s\xa0]*Mektup)))|(?:[İi]k(?:[İiI](?:[\s\xa0]*Mektup|nc[Iİi][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[iİI](?:[\s\xa0]*Mektup|nc[İIi][\s\xa0]*Mektup)))|(?:[iİ]k(?:[Iİi](?:[\s\xa0]*Mektup|nc[iIİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))))|(?:[Iİ]ntl(?:(?:[Iİ]ler(?:(?:[’']e[\s\xa0]*(?:ik(?:[Iİi](?:[\s\xa0]*Mektup|nc[İiI][\s\xa0]*Mektup))|(?:[Iİ]k(?:i(?:[\s\xa0]*Mektup|nc[İiI][\s\xa0]*Mektup)|[Iİ]nci[\s\xa0]*Mektup))))|e[\s\xa0]*(?:ik(?:[iIİ](?:[\s\xa0]*Mektup|nc[Iiİ][\s\xa0]*Mektup))|(?:[İI]k(?:i(?:[\s\xa0]*Mektup|nc[iİI][\s\xa0]*Mektup)|[İI]nci[\s\xa0]*Mektup)))))|iler(?:(?:['’]e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[İiI](?:[\s\xa0]*Mektup|nc[iIİ][\s\xa0]*Mektup)))|(?:[İi]k(?:[İiI](?:[\s\xa0]*Mektup|nc[Iİi][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[İiI](?:[\s\xa0]*Mektup|nc[İIi][\s\xa0]*Mektup)))|(?:[iİ]k(?:[iIİ](?:[\s\xa0]*Mektup|nc[İIi][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))))))))|2(?:\.[\s\xa0]*Kor(?:int(?:oslular|l[iİI]ler)?|[İI]ntliler)|[\s\xa0]*Kor(?:int(?:oslular|l[iİI]ler)?|[Iİ]ntliler))|I(?:I(?:\.[\s\xa0]*Kor(?:int(?:oslular|l[İIi]ler)?|[İI]ntliler)|[\s\xa0]*Kor(?:int(?:oslular|l[iİI]ler)?|[İI]ntliler))|k(?:i(?:[\s\xa0]*Ko(?:r(?:[iIİ]nt(?:oslular|l[iİI]ler)?)?)?|nc(?:[Iİi][\s\xa0]*Ko(?:r(?:[Iİi]nt(?:oslular|l[iIİ]ler)?)?)?))|(?:[Iİ](?:nc(?:(?:[Iİ][\s\xa0]*Kor(?:int(?:oslular|l[iIİ]ler)?|[İI]ntliler))|i[\s\xa0]*Ko(?:r(?:[İIi]nt(?:oslular|l[İiI]ler)?)?)?)|[\s\xa0]*Kor(?:int(?:oslular|l[İiI]ler)?|[Iİ]ntliler)))))|ik(?:[İiI](?:[\s\xa0]*Ko(?:r(?:[iİI]nt(?:oslular|l[iİI]ler)?)?)?|nc(?:[iİI][\s\xa0]*Ko(?:r(?:[Iİi]nt(?:oslular|l[İIi]ler)?)?)?)))|İk(?:i(?:[\s\xa0]*Ko(?:r(?:[İiI]nt(?:oslular|l[iIİ]ler)?)?)?|nc(?:[iİI][\s\xa0]*Ko(?:r(?:[Iİi]nt(?:oslular|l[İIi]ler)?)?)?))|(?:[İI](?:nc(?:(?:[İI][\s\xa0]*Kor(?:int(?:oslular|l[iIİ]ler)?|[İI]ntliler))|i[\s\xa0]*Ko(?:r(?:[Iİi]nt(?:oslular|l[İIi]ler)?)?)?)|[\s\xa0]*Kor(?:int(?:oslular|l[İIi]ler)?|[Iİ]ntliler))))|Kor(?:int(?:oslular(?:(?:['’]a[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iiİ](?:[\s\xa0]*Mektup|nc[İiI][\s\xa0]*Mektup)))|(?:[İi]k(?:[Iİi](?:[\s\xa0]*Mektup|nc[Iİi][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|a[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[iIİ](?:[\s\xa0]*Mektup|nc[iIİ][\s\xa0]*Mektup)))|(?:[iİ]k(?:[iIİ](?:[\s\xa0]*Mektup|nc[iIİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|l(?:[iIİ]ler(?:(?:[’']e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[İiI](?:[\s\xa0]*Mektup|nc[Iİi][\s\xa0]*Mektup)))|(?:[İi]k(?:[İiI](?:[\s\xa0]*Mektup|nc[iİI][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[İiI](?:[\s\xa0]*Mektup|nc[İiI][\s\xa0]*Mektup)))|(?:[iİ]k(?:[Iiİ](?:[\s\xa0]*Mektup|nc[iİI][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))))|(?:[Iİ]nt(?:oslular(?:a[\s\xa0]*(?:ik(?:[iIİ](?:[\s\xa0]*Mektup|nc[iİI][\s\xa0]*Mektup))|(?:[İI]k(?:i(?:[\s\xa0]*Mektup|nc[İIi][\s\xa0]*Mektup)|[İI]nci[\s\xa0]*Mektup)))|(?:['’]a[\s\xa0]*(?:ik(?:[iIİ](?:[\s\xa0]*Mektup|nc[iIİ][\s\xa0]*Mektup))|(?:[Iİ]k(?:i(?:[\s\xa0]*Mektup|nc[İiI][\s\xa0]*Mektup)|[Iİ]nci[\s\xa0]*Mektup)))))|l(?:[iİI]ler(?:(?:['’]e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[İIi](?:[\s\xa0]*Mektup|nc[iİI][\s\xa0]*Mektup)))|(?:[iİ]k(?:[Iiİ](?:[\s\xa0]*Mektup|nc[iIİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[İIi](?:[\s\xa0]*Mektup|nc[Iİi][\s\xa0]*Mektup)))|(?:[iİ]k(?:[Iiİ](?:[\s\xa0]*Mektup|nc[Iiİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))))))))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["1Cor"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:Pavlus(?:tan[\s\xa0]*Kor(?:[Iİ]ntl(?:[Iİ]ler(?:e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[Iİ]r(?:[\s\xa0]*Mektup|[Iİ]nc(?:[Iİ][\s\xa0]*Mektup)))|İlk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))|(?:['’]e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[Iİ]r(?:[\s\xa0]*Mektup|[Iİ]nc(?:[Iİ][\s\xa0]*Mektup)))|İlk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))))))|(?:['’]tan[\s\xa0]*Kor(?:[Iİ]ntl(?:[Iİ]ler(?:e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[Iİ]r(?:[\s\xa0]*Mektup|[Iİ]nc(?:[Iİ][\s\xa0]*Mektup)))|İlk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))|(?:['’]e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[Iİ]r(?:[\s\xa0]*Mektup|[Iİ]nc(?:[Iİ][\s\xa0]*Mektup)))|İlk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))))))))|B(?:[Iİ]r(?:[\s\xa0]*Ko(?:r(?:[Iİ]nt(?:oslular|l[Iİ]ler)?)?)?|(?:[Iİ]nc(?:[Iİ][\s\xa0]*Ko(?:r(?:[Iİ]nt(?:oslular|l[Iİ]ler)?)?)?))))|İlk[\s\xa0]*Ko(?:r(?:[Iİ]nt(?:oslular|l[Iİ]ler)?)?)?|1(?:\.[\s\xa0]*Ko(?:r(?:[Iİ]nt(?:oslular|l[Iİ]ler)?)?)?|Ko|[\s\xa0]*Ko(?:r(?:[Iİ]nt(?:oslular|l[Iİ]ler)?)?)?|Cor)|I(?:\.[\s\xa0]*Ko(?:r(?:[Iİ]nt(?:oslular|l[Iİ]ler)?)?)?|[\s\xa0]*Ko(?:r(?:[Iİ]nt(?:oslular|l[Iİ]ler)?)?)?|lk[\s\xa0]*Ko(?:r(?:[Iİ]nt(?:oslular|l[Iİ]ler)?)?)?)|Kor(?:[Iİ]ntoslular(?:a[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[Iİ]r(?:[\s\xa0]*Mektup|[Iİ]nc(?:[Iİ][\s\xa0]*Mektup)))|İlk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))|(?:['’]a[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[Iİ]r(?:[\s\xa0]*Mektup|[Iİ]nc(?:[Iİ][\s\xa0]*Mektup)))|İlk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))))))|(?:B(?:ir(?:[\s\xa0]*Ko(?:r(?:[İiI]nt(?:oslular|l[İiI]ler)?)?)?|(?:[Iİi]nc(?:[İIi][\s\xa0]*Ko(?:r(?:[Iiİ]nt(?:oslular|l[İiI]ler)?)?)?)))|(?:[Iİ]r(?:(?:[Iİ]nc(?:(?:[Iİ][\s\xa0]*Kor(?:int(?:oslular|l[Iiİ]ler)?|[Iİ]ntliler))|i[\s\xa0]*Ko(?:r(?:[İiI]nt(?:oslular|l[İiI]ler)?)?)?))|inc(?:[iIİ][\s\xa0]*Ko(?:r(?:[iİI]nt(?:oslular|l[iIİ]ler)?)?)?)|[\s\xa0]*Kor(?:int(?:oslular|l[Iİi]ler)?|[İI]ntliler))))|1(?:\.[\s\xa0]*Kor(?:int(?:oslular|l[İIi]ler)?|[Iİ]ntliler)|[\s\xa0]*Kor(?:int(?:oslular|l[Iiİ]ler)?|[İI]ntliler))|İlk[\s\xa0]*Kor(?:int(?:oslular|l[iİI]ler)?|[İI]ntliler)|Pavlus(?:tan[\s\xa0]*Kor(?:intl(?:[Iiİ]ler(?:(?:[’']e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[İiI]r(?:[\s\xa0]*Mektup|[Iiİ]nc(?:[Iiİ][\s\xa0]*Mektup)))|[iİ]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[iIİ]r(?:[\s\xa0]*Mektup|[İIi]nc(?:[Iiİ][\s\xa0]*Mektup)))|[İi]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))))|(?:[Iİ]ntl(?:iler(?:(?:['’]e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[iİI]r(?:[\s\xa0]*Mektup|[iIİ]nc(?:[Iİi][\s\xa0]*Mektup)))|[iİ]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[Iİi]r(?:[\s\xa0]*Mektup|[Iİi]nc(?:[iİI][\s\xa0]*Mektup)))|[iİ]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|(?:[İI]ler(?:(?:['’]e[\s\xa0]*(?:B(?:ir(?:[\s\xa0]*Mektup|[Iİi]nc(?:[iIİ][\s\xa0]*Mektup))|[Iİ]r(?:(?:[İI]nci[\s\xa0]*Mektup|inc[İiI][\s\xa0]*Mektup)))|ilk[\s\xa0]*Mektup))|e[\s\xa0]*(?:B(?:ir(?:[\s\xa0]*Mektup|[iİI]nc(?:[iIİ][\s\xa0]*Mektup))|[İI]r(?:(?:[Iİ]nci[\s\xa0]*Mektup|inc[Iİi][\s\xa0]*Mektup)))|ilk[\s\xa0]*Mektup))))))|(?:[’']tan[\s\xa0]*Kor(?:intl(?:[İiI]ler(?:(?:[’']e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[iIİ]r(?:[\s\xa0]*Mektup|[İIi]nc(?:[iİI][\s\xa0]*Mektup)))|[iİ]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[iIİ]r(?:[\s\xa0]*Mektup|[İiI]nc(?:[iİI][\s\xa0]*Mektup)))|[İi]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))))|(?:[İI]ntl(?:iler(?:(?:[’']e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[iIİ]r(?:[\s\xa0]*Mektup|[İIi]nc(?:[İIi][\s\xa0]*Mektup)))|[İi]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[Iİi]r(?:[\s\xa0]*Mektup|[Iiİ]nc(?:[Iiİ][\s\xa0]*Mektup)))|[iİ]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|(?:[İI]ler(?:(?:['’]e[\s\xa0]*(?:B(?:ir(?:[\s\xa0]*Mektup|[Iİi]nc(?:[iİI][\s\xa0]*Mektup))|[Iİ]r(?:(?:[Iİ]nci[\s\xa0]*Mektup|inc[Iİi][\s\xa0]*Mektup)))|ilk[\s\xa0]*Mektup))|e[\s\xa0]*(?:B(?:ir(?:[\s\xa0]*Mektup|[iİI]nc(?:[İiI][\s\xa0]*Mektup))|[Iİ]r(?:(?:[İI]nci[\s\xa0]*Mektup|inc[Iİi][\s\xa0]*Mektup)))|ilk[\s\xa0]*Mektup))))))))|ilk[\s\xa0]*Ko(?:r(?:[İiI]nt(?:oslular|l[iİI]ler)?)?)?|Kor(?:int(?:l(?:[İiI]ler(?:(?:[’']e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[İiI]r(?:[\s\xa0]*Mektup|[Iİi]nc(?:[İIi][\s\xa0]*Mektup)))|[İi]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[İIi]r(?:[\s\xa0]*Mektup|[iİI]nc(?:[İiI][\s\xa0]*Mektup)))|[İi]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))))|oslular(?:(?:[’']a[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[İIi]r(?:[\s\xa0]*Mektup|[Iiİ]nc(?:[Iiİ][\s\xa0]*Mektup)))|[İi]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|a[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[iİI]r(?:[\s\xa0]*Mektup|[iİI]nc(?:[İiI][\s\xa0]*Mektup)))|[iİ]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))))|(?:[Iİ]nt(?:l(?:[İiI]ler(?:(?:['’]e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[iİI]r(?:[\s\xa0]*Mektup|[İiI]nc(?:[Iiİ][\s\xa0]*Mektup)))|[iİ]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[Iiİ]r(?:[\s\xa0]*Mektup|[iIİ]nc(?:[İiI][\s\xa0]*Mektup)))|[İi]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))))|oslular(?:a[\s\xa0]*(?:B(?:ir(?:[\s\xa0]*Mektup|[iIİ]nc(?:[İiI][\s\xa0]*Mektup))|[İI]r(?:(?:[İI]nci[\s\xa0]*Mektup|inc[Iİi][\s\xa0]*Mektup)))|ilk[\s\xa0]*Mektup)|(?:['’]a[\s\xa0]*(?:B(?:ir(?:[\s\xa0]*Mektup|[iIİ]nc(?:[İiI][\s\xa0]*Mektup))|[İI]r(?:(?:[İI]nci[\s\xa0]*Mektup|inc[İiI][\s\xa0]*Mektup)))|ilk[\s\xa0]*Mektup))))))|I(?:\.[\s\xa0]*Kor(?:int(?:oslular|l[İiI]ler)?|[Iİ]ntliler)|lk[\s\xa0]*Kor(?:int(?:oslular|l[İiI]ler)?|[Iİ]ntliler)|[\s\xa0]*Kor(?:int(?:oslular|l[Iiİ]ler)?|[İI]ntliler))))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["Gal"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Pavlus(?:tan[\\s\\xa0]*Galatyal[Iİı]lar(?:(?:['’]a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup))|['’]tan[\\s\\xa0]*Galatyal(?:[Iİı]lar(?:(?:['’]a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup))))|Gal)|(?:Pavlus(?:tan[\\s\\xa0]*Galatyal(?:ilar(?:['’]a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup)?|[ıİI]lar)|['’]tan[\\s\\xa0]*Galatyal(?:ilar(?:(?:[’']a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup)?|[İıI]lar)))|Galatyal[ıiIİ]lar(?:(?:[’']a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup)?))|Pavlus['’]tan[\\s\\xa0]*Galatyal(?:[İıI]lar))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Eph"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Pavlus(?:tan[\\s\\xa0]*Efesl[Iİ]ler(?:(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|['’]tan[\\s\\xa0]*Efesl(?:[Iİ]ler(?:(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))))|E(?:ph|f(?:e(?:s(?:oslular(?:['’]a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup))?)?)?))|Pavlus(?:[’']tan[\\s\\xa0]*Efesliler(?:(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|tan[\\s\\xa0]*Efesliler(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|(?:Efes(?:oslular|l[Iİ]ler(?:(?:[’']e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)))|Pavlus(?:tan[\\s\\xa0]*Efesl[İi]ler|’tan[\\s\\xa0]*Efesl[iİ]ler|'tan[\\s\\xa0]*Efesl[Iİ]ler))|Efesliler(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|(?:Efesl[Iİi]ler|Pavlus(?:tan[\\s\\xa0]*EfeslIler|'tan[\\s\\xa0]*Efesliler|’tan[\\s\\xa0]*EfeslIler)))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Phil"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:P(?:avlus(?:['’]tan[\\s\\xa0]*F(?:[Iİ]l(?:[Iİ]p(?:[Iİ]l(?:[Iİ]ler(?:(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))))))|tan[\\s\\xa0]*F[Iİ]l(?:[Iİ]p(?:[Iİ]l(?:[Iİ]ler(?:(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))))))|hil)|F(?:il|lp))|Pavlus(?:(?:['’]tan[\\s\\xa0]*Fİlİp(?:Ililer'e[\\s\\xa0]*Mektup|İliler(?:[’']e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|il(?:Iler(?:’e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|İler(?:[’']e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))))|tan[\\s\\xa0]*Fİlİp(?:İliler(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|il(?:Ilere[\\s\\xa0]*Mektup|İler(?:[’']e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|Ililer[’']e[\\s\\xa0]*Mektup))|Pavlus(?:tan[\\s\\xa0]*Fİlİp(?:Ililere[\\s\\xa0]*Mektup|il(?:Iler[’']e[\\s\\xa0]*Mektup|iler(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)))|(?:['’]tan[\\s\\xa0]*Fİlİp(?:Ililer(?:’e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|il(?:Iler'e[\\s\\xa0]*Mektup|iler(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)))))|(?:Pavlus(?:tan[\\s\\xa0]*F(?:il(?:İp(?:Ililer(?:’e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|il(?:İler(?:’e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|Iler'e[\\s\\xa0]*Mektup)|İl(?:Ilere[\\s\\xa0]*Mektup|İler(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)))|Ip(?:Ililer’e[\\s\\xa0]*Mektup|İl(?:Ilere[\\s\\xa0]*Mektup|İler['’]e[\\s\\xa0]*Mektup|iler'e[\\s\\xa0]*Mektup))|ip(?:İliler’e[\\s\\xa0]*Mektup|Il(?:ilere[\\s\\xa0]*Mektup|İler(?:’e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|Iler'e[\\s\\xa0]*Mektup)))|Il(?:ip(?:Ilİler'e[\\s\\xa0]*Mektup|İlİlere[\\s\\xa0]*Mektup)|İp(?:ilİler'e[\\s\\xa0]*Mektup|İliler['’]e[\\s\\xa0]*Mektup))|İl(?:ip(?:Ilİler[’']e[\\s\\xa0]*Mektup|İl(?:iler’e[\\s\\xa0]*Mektup|İler(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|ilİlere[\\s\\xa0]*Mektup)|İp(?:İl[İI]ler|il[iİ]ler)|Ip(?:ilIler’e[\\s\\xa0]*Mektup|(?:[Iİ]liler(?:'e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)))))|’tan[\\s\\xa0]*F(?:İl(?:Ip(?:[Iİ]liler’e[\\s\\xa0]*Mektup|ilİler'e[\\s\\xa0]*Mektup)|İp[iİ]l(?:[Iİ]ler)|ip(?:İl(?:iler(?:'e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|İler(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|ilIlere[\\s\\xa0]*Mektup|Il(?:İler(?:’e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|Iler'e[\\s\\xa0]*Mektup)))|Il(?:Ip(?:Ililer'e[\\s\\xa0]*Mektup|İliler’e[\\s\\xa0]*Mektup|ilİlere[\\s\\xa0]*Mektup)|İp(?:İliler'e[\\s\\xa0]*Mektup|Ililer’e[\\s\\xa0]*Mektup)|ipİl(?:ilere[\\s\\xa0]*Mektup|İler(?:[’']e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)))|il(?:İp(?:il(?:ilere[\\s\\xa0]*Mektup|İler[’']e[\\s\\xa0]*Mektup)|İl(?:iler(?:’e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|İler(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|Il(?:İlere[\\s\\xa0]*Mektup|Iler'e[\\s\\xa0]*Mektup))|ip(?:ilIlere[\\s\\xa0]*Mektup|Ilİler’e[\\s\\xa0]*Mektup)|Ip(?:İliler'e[\\s\\xa0]*Mektup|IlIler’e[\\s\\xa0]*Mektup|ilİler'e[\\s\\xa0]*Mektup)))|'tan[\\s\\xa0]*F(?:İl(?:Ip(?:ilIler'e[\\s\\xa0]*Mektup|İliler(?:'e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|ip(?:İl(?:iler’e[\\s\\xa0]*Mektup|İler(?:[’']e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|il(?:İlere[\\s\\xa0]*Mektup|iler’e[\\s\\xa0]*Mektup)|Il(?:Ilere[\\s\\xa0]*Mektup|İler[’']e[\\s\\xa0]*Mektup))|İp(?:İl[İI]ler|il[iİ]ler))|Il(?:İp(?:Ililer'e[\\s\\xa0]*Mektup|il(?:Ilere[\\s\\xa0]*Mektup|iler’e[\\s\\xa0]*Mektup))|ip(?:il(?:İler’e[\\s\\xa0]*Mektup|Iler(?:[’']e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|İl(?:Ilere[\\s\\xa0]*Mektup|İler'e[\\s\\xa0]*Mektup)))|il(?:ip(?:İl[Iİ]ler’e[\\s\\xa0]*Mektup|ilİlere[\\s\\xa0]*Mektup)|İp(?:İl[Iİ]ler(?:(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|Ilİler(?:[’']e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|Ip(?:Ilİler'e[\\s\\xa0]*Mektup|İl(?:İlere[\\s\\xa0]*Mektup|iler'e[\\s\\xa0]*Mektup)))))|Fİlİp(?:İl[iİ]ler(?:(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|il(?:(?:[İi]ler(?:’e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|Iler'e[\\s\\xa0]*Mektup)|Ilİler'e[\\s\\xa0]*Mektup))|(?:Fİlİp(?:İlIler(?:[’']e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|ilİler'e[\\s\\xa0]*Mektup)|Pavlus(?:tan[\\s\\xa0]*F(?:ilipİlİler'e[\\s\\xa0]*Mektup|Il(?:ipİlİler’e[\\s\\xa0]*Mektup|İp(?:İlilere[\\s\\xa0]*Mektup|il(?:İler(?:’e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|iler'e[\\s\\xa0]*Mektup))|Ip(?:İlilere[\\s\\xa0]*Mektup|Ililer’e[\\s\\xa0]*Mektup))|İl(?:Ipil(?:iler'e[\\s\\xa0]*Mektup|İler(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|ip(?:ilIlere[\\s\\xa0]*Mektup|İliler(?:'e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))))|’tan[\\s\\xa0]*F(?:Il(?:Ipilİler['’]e[\\s\\xa0]*Mektup|İpilİler(?:’e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|İlIp(?:Ililere[\\s\\xa0]*Mektup|İliler(?:'e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|il(?:Ipİl(?:Iler’e[\\s\\xa0]*Mektup|İler'e[\\s\\xa0]*Mektup)|ip(?:İlİler(?:’e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|Il(?:İlere[\\s\\xa0]*Mektup|Iler'e[\\s\\xa0]*Mektup))|İp(?:İlIler'e[\\s\\xa0]*Mektup|ililer’e[\\s\\xa0]*Mektup|Ilİler'e[\\s\\xa0]*Mektup)))|'tan[\\s\\xa0]*F(?:il(?:Ipİlİler’e[\\s\\xa0]*Mektup|İp(?:ilİler['’]e[\\s\\xa0]*Mektup|İliler[’']e[\\s\\xa0]*Mektup))|Il(?:ip(?:İliler’e[\\s\\xa0]*Mektup|ilİlere[\\s\\xa0]*Mektup)|İp(?:İlilere[\\s\\xa0]*Mektup|ilİlere[\\s\\xa0]*Mektup))|İl(?:ip(?:İlIler’e[\\s\\xa0]*Mektup|ilİler'e[\\s\\xa0]*Mektup)|Ip(?:Ililere[\\s\\xa0]*Mektup|ilİler’e[\\s\\xa0]*Mektup)))))|Pavlus(?:'tan[\\s\\xa0]*F(?:İl(?:Ip(?:İliler’e[\\s\\xa0]*Mektup|il(?:[Ii]lere[\\s\\xa0]*Mektup|İler'e[\\s\\xa0]*Mektup))|ip(?:Ililere[\\s\\xa0]*Mektup|il(?:[iI]lere[\\s\\xa0]*Mektup|İler’e[\\s\\xa0]*Mektup)))|Il(?:Ip(?:İliler’e[\\s\\xa0]*Mektup|ilİlere[\\s\\xa0]*Mektup)|ip(?:İl[Iİ]ler’e[\\s\\xa0]*Mektup|Ilİlere[\\s\\xa0]*Mektup)|İp(?:ilİler[’']e[\\s\\xa0]*Mektup|İliler['’]e[\\s\\xa0]*Mektup))|il(?:Ip(?:İl[Ii]ler’e[\\s\\xa0]*Mektup|[Ii]lİlere[\\s\\xa0]*Mektup)|ip(?:İliler’e[\\s\\xa0]*Mektup|Ilİlere[\\s\\xa0]*Mektup)|İp(?:İlilere[\\s\\xa0]*Mektup|ilİlere[\\s\\xa0]*Mektup)))|’tan[\\s\\xa0]*F(?:il(?:İp(?:İliler'e[\\s\\xa0]*Mektup|il(?:İlere[\\s\\xa0]*Mektup|Iler’e[\\s\\xa0]*Mektup)|Il[Iiİ]ler’e[\\s\\xa0]*Mektup)|Ip(?:İl(?:iler’e[\\s\\xa0]*Mektup|İler(?:’e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|Il(?:[Ii]ler'e[\\s\\xa0]*Mektup|İler(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|il(?:İler(?:’e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|[Ii]ler'e[\\s\\xa0]*Mektup))|ip(?:İl(?:[iI]ler’e[\\s\\xa0]*Mektup|İler'e[\\s\\xa0]*Mektup)|il(?:[Ii]ler'e[\\s\\xa0]*Mektup|İler(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|Il[İi]ler'e[\\s\\xa0]*Mektup))|İl(?:Ipil[iI]lere[\\s\\xa0]*Mektup|ip(?:ililere[\\s\\xa0]*Mektup|Il[Ii]lere[\\s\\xa0]*Mektup|İlIler(?:'e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)))|Il(?:Ipil[Ii]ler'e[\\s\\xa0]*Mektup|İpil(?:[Ii]ler’e[\\s\\xa0]*Mektup|İler'e[\\s\\xa0]*Mektup)|ip(?:[iI]l(?:(?:[Ii]ler'e[\\s\\xa0]*Mektup|İler(?:[’']e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)))|İl[Ii]ler’e[\\s\\xa0]*Mektup)))|tan[\\s\\xa0]*F(?:il(?:İp(?:ililer'e[\\s\\xa0]*Mektup|İlilere[\\s\\xa0]*Mektup|Il(?:İler(?:’e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|[iI]ler'e[\\s\\xa0]*Mektup))|Ip(?:İlilere[\\s\\xa0]*Mektup|il[iI]ler’e[\\s\\xa0]*Mektup|IlIler’e[\\s\\xa0]*Mektup)|ip(?:[Ii]l(?:[Ii]ler’e[\\s\\xa0]*Mektup)|İl(?:[iI]lere[\\s\\xa0]*Mektup|İler’e[\\s\\xa0]*Mektup)))|İl(?:ip(?:Il(?:İlere[\\s\\xa0]*Mektup|(?:[iI]ler(?:'e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)))|İlIler(?:'e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|il(?:İler[’']e[\\s\\xa0]*Mektup|iler(?:'e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|Iler'e[\\s\\xa0]*Mektup))|Ipil(?:ilere[\\s\\xa0]*Mektup|Iler(?:'e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)))|Il(?:İp(?:Ililer'e[\\s\\xa0]*Mektup|ilIler'e[\\s\\xa0]*Mektup)|ip(?:[iI]l(?:[iI]ler’e[\\s\\xa0]*Mektup)|İl(?:[Ii]lere[\\s\\xa0]*Mektup|İler'e[\\s\\xa0]*Mektup))|Ipil[Ii]ler’e[\\s\\xa0]*Mektup)))|Pavlus(?:tan[\\s\\xa0]*Filipİlİlere[\\s\\xa0]*Mektup|'tan[\\s\\xa0]*FİlIpilİlere[\\s\\xa0]*Mektup)|(?:Pavlus(?:'tan[\\s\\xa0]*F(?:Il(?:Ip(?:il[Iİ]ler’e[\\s\\xa0]*Mektup|İlilere[\\s\\xa0]*Mektup)|İpil(?:Iler['’]e[\\s\\xa0]*Mektup|İler)|ipililer'e[\\s\\xa0]*Mektup)|İl(?:ip(?:İl(?:iler(?:'e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|İler)|ilIler’e[\\s\\xa0]*Mektup|Il(?:İler|iler'e[\\s\\xa0]*Mektup))|İp(?:İliler|Il[Iİ]ler))|il(?:Ip(?:IlIlere[\\s\\xa0]*Mektup|İlİler'e[\\s\\xa0]*Mektup)|ip(?:Ilİler'e[\\s\\xa0]*Mektup|İl(?:İlere[\\s\\xa0]*Mektup|iler'e[\\s\\xa0]*Mektup))|İp(?:ilIlere[\\s\\xa0]*Mektup|İl[Iİ]ler)))|tan[\\s\\xa0]*F(?:Il(?:İp(?:Ililer’e[\\s\\xa0]*Mektup|İlİler)|Ipİlİler|ip(?:Il(?:İler’e[\\s\\xa0]*Mektup|iler'e[\\s\\xa0]*Mektup)|il(?:Ilere[\\s\\xa0]*Mektup|İler'e[\\s\\xa0]*Mektup)))|İl(?:İp(?:İliler|Il[Iİ]ler)|Ipilİler|ip(?:İl(?:Iler’e[\\s\\xa0]*Mektup|İler)|ilIler’e[\\s\\xa0]*Mektup))|il(?:ipİliler'e[\\s\\xa0]*Mektup|İp(?:Il(?:Ilere[\\s\\xa0]*Mektup|İler'e[\\s\\xa0]*Mektup)|İlIler[’']e[\\s\\xa0]*Mektup)|Ip(?:İlIler’e[\\s\\xa0]*Mektup|Ilİlere[\\s\\xa0]*Mektup)))|’tan[\\s\\xa0]*F(?:İl(?:ip(?:İl(?:Iler’e[\\s\\xa0]*Mektup|İler)|ilİler(?:[’']e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|Ip(?:Ililer'e[\\s\\xa0]*Mektup|ilIler’e[\\s\\xa0]*Mektup)|İp(?:İliler|Il[Iİ]ler))|Il(?:ipİlIler'e[\\s\\xa0]*Mektup|İp(?:İliler’e[\\s\\xa0]*Mektup|Ilİler)|Ipİlilere[\\s\\xa0]*Mektup)|il(?:Ip(?:Ililer’e[\\s\\xa0]*Mektup|ilİler)|ip(?:ililere[\\s\\xa0]*Mektup|İlİler)|İp(?:ililer'e[\\s\\xa0]*Mektup|İl(?:Ilere[\\s\\xa0]*Mektup|İler)|IlIlere[\\s\\xa0]*Mektup))))|F(?:ilİp(?:Ilİler’e[\\s\\xa0]*Mektup|İlİler(?:[’']e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|ilİlere[\\s\\xa0]*Mektup)|Ilipİlİler’e[\\s\\xa0]*Mektup|İl(?:ip(?:Ililere[\\s\\xa0]*Mektup|İlİler'e[\\s\\xa0]*Mektup)|İp(?:ilIler’e[\\s\\xa0]*Mektup|Il(?:ilere[\\s\\xa0]*Mektup|İler(?:’e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|Iler'e[\\s\\xa0]*Mektup)|İlİler)|Ipİlİler(?:’e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))))|(?:Fİl(?:ipİlİler(?:’e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|İpilIlere[\\s\\xa0]*Mektup)|Pavlus(?:’tan[\\s\\xa0]*F(?:İl(?:ip(?:Il(?:iler[’']e[\\s\\xa0]*Mektup|İler'e[\\s\\xa0]*Mektup)|İliler’e[\\s\\xa0]*Mektup)|Ipilİler(?:’e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|Ilİpİlilere[\\s\\xa0]*Mektup|il(?:IpİlIler'e[\\s\\xa0]*Mektup|ipilIler’e[\\s\\xa0]*Mektup))|'tan[\\s\\xa0]*F(?:il(?:İpililere[\\s\\xa0]*Mektup|ipİlİler'e[\\s\\xa0]*Mektup)|Ilipİl(?:İlere[\\s\\xa0]*Mektup|iler'e[\\s\\xa0]*Mektup))|tan[\\s\\xa0]*Fil(?:Ip(?:Ilİler[’']e[\\s\\xa0]*Mektup|İlİlere[\\s\\xa0]*Mektup)|İp(?:il(?:iler’e[\\s\\xa0]*Mektup|İler'e[\\s\\xa0]*Mektup)|İliler['’]e[\\s\\xa0]*Mektup)|ipililer'e[\\s\\xa0]*Mektup)))|(?:FİlİpIlIlere[\\s\\xa0]*Mektup|Pavlus(?:tan[\\s\\xa0]*F(?:Il(?:Ip(?:Ililer'e[\\s\\xa0]*Mektup|il(?:İler['’]e[\\s\\xa0]*Mektup|[iI]ler'e[\\s\\xa0]*Mektup))|ip(?:IlIler'e[\\s\\xa0]*Mektup|il(?:İler’e[\\s\\xa0]*Mektup|[iI]ler'e[\\s\\xa0]*Mektup))|İpil[iI]ler’e[\\s\\xa0]*Mektup)|il(?:Ip(?:il(?:İler['’]e[\\s\\xa0]*Mektup|[Ii]ler'e[\\s\\xa0]*Mektup)|Il[Ii]ler'e[\\s\\xa0]*Mektup)|ip(?:il(?:İler[’']e[\\s\\xa0]*Mektup|Iler'e[\\s\\xa0]*Mektup)|Il[iİ]ler'e[\\s\\xa0]*Mektup)|İp[iI]lIler’e[\\s\\xa0]*Mektup))|'tan[\\s\\xa0]*F(?:Il(?:Ipİliler'e[\\s\\xa0]*Mektup|ipİlIler'e[\\s\\xa0]*Mektup|İp[iI]lilere[\\s\\xa0]*Mektup)|il(?:[iI]pİlIler'e[\\s\\xa0]*Mektup|İpIl[Ii]lere[\\s\\xa0]*Mektup))|’tan[\\s\\xa0]*F(?:Il(?:ip(?:İliler'e[\\s\\xa0]*Mektup|[iI]l(?:[Ii]ler’e[\\s\\xa0]*Mektup))|Ip(?:İliler'e[\\s\\xa0]*Mektup|il[Ii]ler’e[\\s\\xa0]*Mektup|Ililer’e[\\s\\xa0]*Mektup))|il(?:ip(?:Il[iI]ler’e[\\s\\xa0]*Mektup|ililer’e[\\s\\xa0]*Mektup|İl[Ii]ler'e[\\s\\xa0]*Mektup)|Ipil[Ii]ler’e[\\s\\xa0]*Mektup)|İl(?:ip(?:IlIler’e[\\s\\xa0]*Mektup|il[iI]ler(?:['’]e[\\s\\xa0]*Mektup))|Ipil(?:iler['’]e[\\s\\xa0]*Mektup|Iler'e[\\s\\xa0]*Mektup)))))|Pavlus(?:tan[\\s\\xa0]*F(?:Il[İI]pililere[\\s\\xa0]*Mektup|ilIpilİlere[\\s\\xa0]*Mektup)|'tan[\\s\\xa0]*FİlipIlİlere[\\s\\xa0]*Mektup)|(?:Pavlus(?:'tan[\\s\\xa0]*F(?:İl(?:Ip(?:ilIler’e[\\s\\xa0]*Mektup|Il(?:İler|iler'e[\\s\\xa0]*Mektup)|İlİler)|İpIliler|ipİlIler(?:'e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|il(?:İp(?:IlIler'e[\\s\\xa0]*Mektup|İliler|il(?:Iler’e[\\s\\xa0]*Mektup|İler))|ipIlİler’e[\\s\\xa0]*Mektup|Ip(?:ilIler'e[\\s\\xa0]*Mektup|İl(?:ilere[\\s\\xa0]*Mektup|Iler)))|Il(?:Ip(?:ililere[\\s\\xa0]*Mektup|Ililer’e[\\s\\xa0]*Mektup)|ip(?:Ilİler'e[\\s\\xa0]*Mektup|İlİler)|İpİlİler))|tan[\\s\\xa0]*F(?:İl(?:Ipİl(?:iler’e[\\s\\xa0]*Mektup|İler)|İpIliler|ipil(?:iler’e[\\s\\xa0]*Mektup|İler))|il(?:ip[iİ]lİler|IpIlIler|İp(?:IlIler|İl[Iİ]ler))|Il(?:Ipİliler'e[\\s\\xa0]*Mektup|ipİlIler’e[\\s\\xa0]*Mektup|İpilİler))|’tan[\\s\\xa0]*F(?:İl(?:Ip[iİ]lİler|İpIliler|ip[Iİ]liler)|il(?:İp(?:ilIler'e[\\s\\xa0]*Mektup|İlIler’e[\\s\\xa0]*Mektup)|ip(?:İliler(?:e[\\s\\xa0]*Mektup)?|IlIlere[\\s\\xa0]*Mektup|ilİler)|Ip(?:Ililer|İlİler))|Ilİp(?:Ililere[\\s\\xa0]*Mektup|[iİ]lİler)))|F(?:il(?:İp(?:İlilere[\\s\\xa0]*Mektup|Ilİlere[\\s\\xa0]*Mektup)|Ipİlİlere[\\s\\xa0]*Mektup)|İl(?:İp(?:İliler|Il(?:Iler’e[\\s\\xa0]*Mektup|iler'e[\\s\\xa0]*Mektup)|ilİler)|Ip[İI]lİler'e[\\s\\xa0]*Mektup|ipIl(?:Ilere[\\s\\xa0]*Mektup|İler’e[\\s\\xa0]*Mektup))|Il(?:Ipİlİler[’']e[\\s\\xa0]*Mektup|İp(?:ilİler[’']e[\\s\\xa0]*Mektup|İl(?:Iler'e[\\s\\xa0]*Mektup|İler(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))))))|(?:Pavlus(?:'tan[\\s\\xa0]*F(?:Ilipilİler'e[\\s\\xa0]*Mektup|ilIpililere[\\s\\xa0]*Mektup)|tan[\\s\\xa0]*F(?:ilipilİlere[\\s\\xa0]*Mektup|IlipİlIler'e[\\s\\xa0]*Mektup)|’tan[\\s\\xa0]*F(?:Ilİp(?:Ililer'e[\\s\\xa0]*Mektup|ilIlere[\\s\\xa0]*Mektup)|ilIpİlilere[\\s\\xa0]*Mektup))|F(?:Il(?:İp(?:İlIlere[\\s\\xa0]*Mektup|ilİlere[\\s\\xa0]*Mektup)|ipİlİlere[\\s\\xa0]*Mektup)|İl(?:ipIlİler'e[\\s\\xa0]*Mektup|İpililer'e[\\s\\xa0]*Mektup)))|(?:Pavlus(?:tan[\\s\\xa0]*F(?:il[iI]pİlIler'e[\\s\\xa0]*Mektup|Il(?:Ipilİlere[\\s\\xa0]*Mektup|ip(?:İliler'e[\\s\\xa0]*Mektup|[Ii]lİlere[\\s\\xa0]*Mektup)))|'tan[\\s\\xa0]*F(?:il(?:Ip(?:Ililere[\\s\\xa0]*Mektup|il(?:Ilere[\\s\\xa0]*Mektup|İler'e[\\s\\xa0]*Mektup))|ip(?:Il[iI]lere[\\s\\xa0]*Mektup|il(?:[iI]lere[\\s\\xa0]*Mektup|İler'e[\\s\\xa0]*Mektup)))|Il(?:Ip(?:Ililere[\\s\\xa0]*Mektup|il(?:Ilere[\\s\\xa0]*Mektup|İler'e[\\s\\xa0]*Mektup))|ip(?:ililere[\\s\\xa0]*Mektup|Il[Ii]lere[\\s\\xa0]*Mektup)))|’tan[\\s\\xa0]*F(?:il(?:İp(?:ilIlere[\\s\\xa0]*Mektup|Ililer(?:'e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|[iI]pİlIlere[\\s\\xa0]*Mektup)|Il(?:ipİlIlere[\\s\\xa0]*Mektup|İpil(?:iler(?:'e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|Iler'e[\\s\\xa0]*Mektup))))|F(?:Il(?:İp(?:İlilere[\\s\\xa0]*Mektup|Ilİlere[\\s\\xa0]*Mektup)|Ipİlİlere[\\s\\xa0]*Mektup)|il(?:İpİlIlere[\\s\\xa0]*Mektup|ipİlİlere[\\s\\xa0]*Mektup)|İl[iI]pilİler'e[\\s\\xa0]*Mektup))|Pavlus(?:’tan[\\s\\xa0]*FIlipIlIlere[\\s\\xa0]*Mektup|'tan[\\s\\xa0]*Filipİlilere[\\s\\xa0]*Mektup)|(?:F(?:il(?:IpIlİlere[\\s\\xa0]*Mektup|İpİlIler’e[\\s\\xa0]*Mektup|ipİl(?:İler[’']e[\\s\\xa0]*Mektup|iler'e[\\s\\xa0]*Mektup))|İl(?:Ip(?:il(?:ilere[\\s\\xa0]*Mektup|İler’e[\\s\\xa0]*Mektup)|İl(?:İler|Iler'e[\\s\\xa0]*Mektup)|Ilİlere[\\s\\xa0]*Mektup)|İp(?:İlIler|Il(?:iler’e[\\s\\xa0]*Mektup|İler))|ipİlIler(?:’e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|Il(?:IpIlİler'e[\\s\\xa0]*Mektup|İp(?:Ilİler[’']e[\\s\\xa0]*Mektup|İl(?:İler|iler'e[\\s\\xa0]*Mektup))))|Pavlus(?:tan[\\s\\xa0]*F(?:Il(?:ip[iİ]lİler|İpİliler|IpIlilere[\\s\\xa0]*Mektup)|İl(?:Ip(?:İlIler|Il(?:iler’e[\\s\\xa0]*Mektup|İler))|İpilIler)|il(?:Ipililer|ipİlIler’e[\\s\\xa0]*Mektup|İp(?:ilIler(?:e[\\s\\xa0]*Mektup)?|Ilİler)))|'tan[\\s\\xa0]*F(?:İl(?:ip(?:ililer'e[\\s\\xa0]*Mektup|İlIler|IlIler’e[\\s\\xa0]*Mektup)|İpilIler|Ipilİler)|Il(?:IpİlIler|İp(?:İliler|Ilİler))|il(?:İp(?:ililer'e[\\s\\xa0]*Mektup|Ililer’e[\\s\\xa0]*Mektup)|Ip(?:IlIler'e[\\s\\xa0]*Mektup|ilIler’e[\\s\\xa0]*Mektup|İlİler)|ipilİler’e[\\s\\xa0]*Mektup))|’tan[\\s\\xa0]*F(?:il(?:ipilIler|İpilİler)|Il(?:Ip[Iİ]lİler|ipİliler|İp(?:İliler|IlIler))|İl(?:IpİlIler|ipil[İI]ler|İpililer))))|(?:Pavlus(?:'tan[\\s\\xa0]*F(?:Il(?:İpililer'e[\\s\\xa0]*Mektup|Ipililer’e[\\s\\xa0]*Mektup)|il(?:ipİlIlere[\\s\\xa0]*Mektup|Ipil(?:İler’e[\\s\\xa0]*Mektup|iler'e[\\s\\xa0]*Mektup)|İpililer’e[\\s\\xa0]*Mektup))|tan[\\s\\xa0]*F(?:İlipIlIler’e[\\s\\xa0]*Mektup|ilIpİliler’e[\\s\\xa0]*Mektup))|F(?:il(?:Ipİlİler’e[\\s\\xa0]*Mektup|İp(?:İlIler'e[\\s\\xa0]*Mektup|ilİler['’]e[\\s\\xa0]*Mektup))|İl(?:IpİlIlere[\\s\\xa0]*Mektup|ipİliler’e[\\s\\xa0]*Mektup)|Ilip[Iİ]lİler'e[\\s\\xa0]*Mektup))|(?:Pavlus(?:tan[\\s\\xa0]*F(?:Il[iI]pİliler’e[\\s\\xa0]*Mektup|İl(?:ipIliler’e[\\s\\xa0]*Mektup|Ipililer’e[\\s\\xa0]*Mektup))|'tan[\\s\\xa0]*F(?:il(?:İp(?:ilIler'e[\\s\\xa0]*Mektup|Il(?:Iler’e[\\s\\xa0]*Mektup|iler'e[\\s\\xa0]*Mektup))|Ip(?:İlIlere[\\s\\xa0]*Mektup|ililer’e[\\s\\xa0]*Mektup|Il(?:iler[’']e[\\s\\xa0]*Mektup|[İI]ler’e[\\s\\xa0]*Mektup))|ip[iI]l(?:[Ii]ler(?:[’']e[\\s\\xa0]*Mektup)))|Il(?:ip(?:İlilere[\\s\\xa0]*Mektup|ililer’e[\\s\\xa0]*Mektup|Il(?:[Ii]ler(?:['’]e[\\s\\xa0]*Mektup)|İler’e[\\s\\xa0]*Mektup))|Ip(?:Ililer'e[\\s\\xa0]*Mektup|il[Ii]ler'e[\\s\\xa0]*Mektup)|İpIliler’e[\\s\\xa0]*Mektup)))|F(?:il(?:ip[iI]lİler'e[\\s\\xa0]*Mektup|Ip[iIİ]lİler'e[\\s\\xa0]*Mektup|İp(?:İliler'e[\\s\\xa0]*Mektup|Ilİler'e[\\s\\xa0]*Mektup))|İl(?:ipİlilere[\\s\\xa0]*Mektup|Ipİl(?:Iler’e[\\s\\xa0]*Mektup|iler(?:’e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)))|Il[Ii]pilİler'e[\\s\\xa0]*Mektup))|Pavlus(?:’tan[\\s\\xa0]*FilIpilIlere[\\s\\xa0]*Mektup|tan[\\s\\xa0]*FilIpilIlere[\\s\\xa0]*Mektup)|(?:F(?:il(?:İp(?:ilIler'e[\\s\\xa0]*Mektup|İlİler)|ipİlIler’e[\\s\\xa0]*Mektup|IpIlIler’e[\\s\\xa0]*Mektup)|İl(?:Ip(?:il[Iİ]lere[\\s\\xa0]*Mektup|İliler'e[\\s\\xa0]*Mektup|Ilİler’e[\\s\\xa0]*Mektup)|İpililer|ipİlİler)|Il(?:İp[iİ]lIler’e[\\s\\xa0]*Mektup|ip(?:İl(?:Ilere[\\s\\xa0]*Mektup|iler'e[\\s\\xa0]*Mektup)|ilİler’e[\\s\\xa0]*Mektup|Il(?:İlere[\\s\\xa0]*Mektup|Iler'e[\\s\\xa0]*Mektup))))|Pavlus(?:'tan[\\s\\xa0]*F(?:İl(?:Ip(?:ililer'e[\\s\\xa0]*Mektup|Ililer’e[\\s\\xa0]*Mektup)|ip(?:İliler|ilİler))|il(?:İpIl[iİ]ler|Ip(?:İliler|ilİler))|Il(?:İpİlIler|Ip(?:IlIler|İlİler)))|’tan[\\s\\xa0]*F(?:Il(?:ipİlİler|Ip[Iİ]liler)|il(?:İp(?:[iİ]liler|Ilİler)|ipIlİler)|İl(?:Ip(?:ilIler|Ilİler)|ipİlIler))|tan[\\s\\xa0]*F(?:il(?:İp(?:il(?:ilere[\\s\\xa0]*Mektup|İler)|Ililer)|Ip(?:Ililer|İl[Iİ]ler))|Il(?:İpİlIler|ipIlİler)|İl(?:ip(?:ililer|Ilİler)|Ipİliler))))|(?:Pavlus(?:tan[\\s\\xa0]*FIlİpIlilere[\\s\\xa0]*Mektup|'tan[\\s\\xa0]*Fİlip(?:ilIler'e[\\s\\xa0]*Mektup|Ililer’e[\\s\\xa0]*Mektup))|F(?:Il(?:İpIliler'e[\\s\\xa0]*Mektup|Ipililer’e[\\s\\xa0]*Mektup)|ilipIlİlere[\\s\\xa0]*Mektup|İl(?:ip(?:İliler'e[\\s\\xa0]*Mektup|ilİler(?:’e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|IpIlIlere[\\s\\xa0]*Mektup)))|(?:Pavlus(?:tan[\\s\\xa0]*FIlİpilIlere[\\s\\xa0]*Mektup|'tan[\\s\\xa0]*Fİl(?:ipIlIler'e[\\s\\xa0]*Mektup|Ipililer’e[\\s\\xa0]*Mektup))|F(?:il(?:ip(?:il(?:İlere[\\s\\xa0]*Mektup|[Ii]ler’e[\\s\\xa0]*Mektup)|Il[Ii]ler’e[\\s\\xa0]*Mektup)|Ip(?:il(?:İlere[\\s\\xa0]*Mektup|[Ii]ler’e[\\s\\xa0]*Mektup)|Ililer’e[\\s\\xa0]*Mektup)|İp(?:ililer'e[\\s\\xa0]*Mektup|Il[iI]ler'e[\\s\\xa0]*Mektup))|Il(?:Ip(?:Il(?:İlere[\\s\\xa0]*Mektup|[iI]ler’e[\\s\\xa0]*Mektup)|il(?:İlere[\\s\\xa0]*Mektup|Iler’e[\\s\\xa0]*Mektup))|ip(?:il(?:İlere[\\s\\xa0]*Mektup|[Ii]ler’e[\\s\\xa0]*Mektup)|Il[iI]ler’e[\\s\\xa0]*Mektup)|İp(?:IlIler'e[\\s\\xa0]*Mektup|il[Ii]ler'e[\\s\\xa0]*Mektup))|İl(?:ip(?:İlIler'e[\\s\\xa0]*Mektup|il[iI]lere[\\s\\xa0]*Mektup|Ilİlere[\\s\\xa0]*Mektup)|IpIlilere[\\s\\xa0]*Mektup)))|Pavlus’tan[\\s\\xa0]*FilipIlilere[\\s\\xa0]*Mektup|(?:F(?:Il(?:Ip(?:ilİler’e[\\s\\xa0]*Mektup|İlIler(?:'e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|İpililer’e[\\s\\xa0]*Mektup)|il(?:Ip(?:Ililer'e[\\s\\xa0]*Mektup|İliler’e[\\s\\xa0]*Mektup)|İp(?:Ililere[\\s\\xa0]*Mektup|İliler’e[\\s\\xa0]*Mektup))|İl(?:İpilIler|IpIliler'e[\\s\\xa0]*Mektup|ipilIler’e[\\s\\xa0]*Mektup))|Pavlus(?:tan[\\s\\xa0]*F(?:İlip(?:İliler|IlIler)|il(?:İpİliler|ipililere[\\s\\xa0]*Mektup)|Il(?:İp(?:ilIler|Ilİler)|ipIliler|Ip(?:İlIler|Ilİler)))|’tan[\\s\\xa0]*F(?:il(?:ipİlIler|İpIlIler|IpIlİler)|Il(?:İpİlIler|IpilIler)|İl(?:ipIlİler|Ip[İi]liler))|'tan[\\s\\xa0]*F(?:il(?:İpilIler|ipİlİler)|İl(?:IpİlIler|ipilIler)|IlIp(?:İliler|Il[iİ]ler))))|F(?:il(?:ipilİler’e[\\s\\xa0]*Mektup|İpIliler’e[\\s\\xa0]*Mektup)|IlIpİliler(?:'e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|F(?:il(?:İp(?:il[iI]ler’e[\\s\\xa0]*Mektup|IlIler’e[\\s\\xa0]*Mektup)|ip(?:Ilİler’e[\\s\\xa0]*Mektup|İl(?:ilere[\\s\\xa0]*Mektup|Iler(?:'e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)))|Ip(?:[iI]lİler’e[\\s\\xa0]*Mektup|İl(?:[iI]ler(?:'e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))))|Il(?:ip(?:İl(?:ilere[\\s\\xa0]*Mektup|Iler'e[\\s\\xa0]*Mektup)|Ilİler’e[\\s\\xa0]*Mektup)|IpIlİler’e[\\s\\xa0]*Mektup|İpIl[iI]ler’e[\\s\\xa0]*Mektup))|Pavlus(?:’tan[\\s\\xa0]*FIlipIlilere[\\s\\xa0]*Mektup|tan[\\s\\xa0]*FilIpIlilere[\\s\\xa0]*Mektup)|(?:Pavlus(?:'tan[\\s\\xa0]*F(?:Il[iİ]pIliler|İlIp(?:İliler|IlIler)|il(?:ipİliler|IpIlİler))|’tan[\\s\\xa0]*F(?:il[İI]pİlIler|İlIpIlIler|Il(?:ipililer|İpIliler|Ipilİler))|tan[\\s\\xa0]*F(?:İlip(?:Ililer|İlIler)|IlİpIliler|il(?:IpilIler|ip(?:İlIler|Ilİler))))|F(?:İl(?:ip(?:ililer’e[\\s\\xa0]*Mektup|Ilİler)|İpIlIler|IpilIler'e[\\s\\xa0]*Mektup)|Il(?:İpİliler’e[\\s\\xa0]*Mektup|Ipİlİler|ipililer'e[\\s\\xa0]*Mektup)|il(?:İpil(?:ilere[\\s\\xa0]*Mektup|İler)|IpİlIler’e[\\s\\xa0]*Mektup)))|(?:Pavlus’tan[\\s\\xa0]*F(?:Il(?:Ip(?:Ililere[\\s\\xa0]*Mektup|il[Ii]lere[\\s\\xa0]*Mektup)|ipil[iI]lere[\\s\\xa0]*Mektup)|ilIp(?:ililere[\\s\\xa0]*Mektup|Il[Ii]lere[\\s\\xa0]*Mektup))|Fİl(?:Ip[iI]l(?:[iI]ler’e[\\s\\xa0]*Mektup)|ipIl[Ii]ler’e[\\s\\xa0]*Mektup))|Pavlustan[\\s\\xa0]*FIlipililere[\\s\\xa0]*Mektup|(?:Pavlus(?:’tan[\\s\\xa0]*F(?:ilIpİliler|İlipililer|Il(?:IpIlIler|İpilIler|ipIlİler))|tan[\\s\\xa0]*F(?:il(?:İpililer|ipilIler|Ip(?:İliler|ilİler))|İlIpIlIler)|'tan[\\s\\xa0]*F(?:il(?:İpililer|IpilIler|ip(?:İlIler|ilİler))|İlipIlIler))|F(?:Il(?:Ipİliler’e[\\s\\xa0]*Mektup|İp(?:İlIler|ilİler))|il(?:Ipİlİler|İpilIlere[\\s\\xa0]*Mektup|ipililer'e[\\s\\xa0]*Mektup)|İl(?:IpİlIler|İpIliler|ipil(?:İler|Iler'e[\\s\\xa0]*Mektup))))|(?:Pavlustan[\\s\\xa0]*F(?:Il(?:IpilIlere[\\s\\xa0]*Mektup|ipIl[Ii]lere[\\s\\xa0]*Mektup)|il(?:Ip(?:ililere[\\s\\xa0]*Mektup|IlIlere[\\s\\xa0]*Mektup)|ip[Ii]lIlere[\\s\\xa0]*Mektup))|Fİl(?:Ip(?:ililer'e[\\s\\xa0]*Mektup|IlIler'e[\\s\\xa0]*Mektup)|ip(?:ililer'e[\\s\\xa0]*Mektup|Il[Ii]ler'e[\\s\\xa0]*Mektup)))|(?:F(?:İlIp(?:İliler|ilİler)|il(?:ipİliler’e[\\s\\xa0]*Mektup|İpIlİler)|Il(?:İp(?:İliler|Ililere[\\s\\xa0]*Mektup)|ip(?:Ililer'e[\\s\\xa0]*Mektup|ilIlere[\\s\\xa0]*Mektup|İlİler)))|Pavlus(?:tan[\\s\\xa0]*F(?:ilIpIlİler|İlIpIliler|Il(?:ipİliler|İpililer|IpIliler))|’tan[\\s\\xa0]*F(?:Il(?:İpililer|ipilİler|Ip(?:ililer|İlIler))|İlipIlIler)|'tan[\\s\\xa0]*F(?:Il(?:ip(?:İliler|IlIler|ilİler)|İpililer)|İlIpilIler)))|F(?:Il(?:Ip[Ii]l(?:[iI]ler'e[\\s\\xa0]*Mektup)|ipilIler'e[\\s\\xa0]*Mektup)|il(?:ip(?:ilIler'e[\\s\\xa0]*Mektup|Il[Ii]ler'e[\\s\\xa0]*Mektup)|Ip(?:IlIler'e[\\s\\xa0]*Mektup|il[Ii]ler'e[\\s\\xa0]*Mektup)))|(?:F(?:il(?:İpİliler|ipİlİler)|İl(?:ipİlIler|IpIlİler)|Il(?:İpIl(?:Ilere[\\s\\xa0]*Mektup|İler)|ip(?:ililere[\\s\\xa0]*Mektup|İliler’e[\\s\\xa0]*Mektup)))|Pavlus(?:’tan[\\s\\xa0]*F(?:il(?:ipIlIler|İpIliler)|IlipİlIler|İlIpIliler)|'tan[\\s\\xa0]*F(?:Ilip(?:İlIler|Ilİler)|il(?:İpIlIler|ipilIler)|İlIpililer)|tan[\\s\\xa0]*F(?:Il(?:İpIlIler|Ipilİler|ip[İI]lIler)|İlIpililer)))|Pavlus(?:’tan[\\s\\xa0]*F(?:ilİpilIler|IlipIlIler)|'tan[\\s\\xa0]*F(?:ilipIlİler|Il[İI]pilIler|İlipIliler))|Pavlus(?:'tan[\\s\\xa0]*F(?:İl(?:ipililer|IpIliler)|il(?:[iI]p(?:ililer|Il[Ii]ler))|Il(?:Ipil[iİ]ler|İpIlIler|ipil[Ii]ler))|’tan[\\s\\xa0]*F(?:il(?:ip[Ii]liler|Ip(?:IlIler|il[iI]ler))|Ilip(?:Ililer|ilIler)))|(?:Pavlustan[\\s\\xa0]*F(?:Il(?:Ip(?:İliler|IlIler|il[Ii]ler)|ipil[Ii]ler)|İl[iI]pilIler|ilip(?:[iİ]liler|Il[Ii]ler))|FIl[iI]pİlIler’e[\\s\\xa0]*Mektup)|F(?:Il(?:Ip[Ii]l(?:[iI]lere[\\s\\xa0]*Mektup)|İpil[iI]lere[\\s\\xa0]*Mektup|ipIl[iI]lere[\\s\\xa0]*Mektup)|il(?:İpIlIlere[\\s\\xa0]*Mektup|[iI]p(?:[Ii]l(?:[iI]lere[\\s\\xa0]*Mektup))))|F(?:İl(?:ipİliler|IpIlIler)|il(?:ip(?:İlIler|Ilİler)|İp(?:ililer|İlIler))|IlipIlIler)|F(?:il(?:Ip(?:[iI]l(?:[iİI]ler)|İl[iI]ler)|ip(?:il[Iİi]ler|İliler|Il[iI]ler)|İp(?:ilIler|Il[Ii]ler))|Il(?:İp[iI]l(?:[iI]ler)|Ip(?:[iI]l(?:[İiI]ler)|İl[iI]ler)|ip(?:il[iIİ]ler|İl[iI]ler|Il[İi]ler))|İl(?:ip[iI]l(?:[Ii]ler)|Ip(?:Ililer|il[iI]ler))))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Col"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:[CK]ol|Pavlus(?:tan[\\s\\xa0]*Kolosel[Iİ]ler(?:(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|['’]tan[\\s\\xa0]*Kolosel(?:[Iİ]ler(?:(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)))))|Pavlus(?:tan[\\s\\xa0]*Koloseliler(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)|['’]tan[\\s\\xa0]*Koloseliler(?:(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)))|(?:Pavlus(?:tan[\\s\\xa0]*Kolosel[Iİ]ler|'tan[\\s\\xa0]*Kolosel[Iİ]ler|’tan[\\s\\xa0]*Kolosel[iİ]ler)|Kolosel(?:Ilere[\\s\\xa0]*Mektup|iler['’]e[\\s\\xa0]*Mektup|İler(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)))|KoloselIler(?:[’']e[\\s\\xa0]*Mektup)|(?:Pavlus(?:'tan[\\s\\xa0]*Koloseliler|’tan[\\s\\xa0]*KoloselIler|tan[\\s\\xa0]*Koloseliler)|Kolosel(?:iler(?:e[\\s\\xa0]*Mektup)?|[Iİ]ler)))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["2Thess"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:2(?:Thess|[\s\xa0]*Se(?:l(?:an[Iİ]kl(?:[Iİ]ler))?)?|\.[\s\xa0]*Se(?:l(?:an[Iİ]kl(?:[Iİ]ler))?)?|Se)|I(?:k[Iİ](?:[\s\xa0]*Se(?:l(?:an(?:[Iİ]kl(?:[Iİ]ler))?)?|nc[Iİ][\s\xa0]*Se(?:l(?:an(?:[Iİ]kl(?:[Iİ]ler))?)?)))|I(?:[\s\xa0]*Se(?:l(?:an[Iİ]kl(?:[Iİ]ler))?)?|\.[\s\xa0]*Se(?:l(?:an[Iİ]kl(?:[Iİ]ler))?)?))|Pavlus(?:tan[\s\xa0]*Selan(?:[Iİ]kl(?:[Iİ]ler(?:e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|İk(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))|(?:['’]e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|İk(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))))))|(?:['’]tan[\s\xa0]*Selan(?:[Iİ]kl(?:[Iİ]ler(?:e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|İk(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))|(?:['’]e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|İk(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))))))))|İk[Iİ](?:[\s\xa0]*Se(?:l(?:an(?:[Iİ]kl(?:[Iİ]ler))?)?|nc[Iİ][\s\xa0]*Se(?:l(?:an(?:[Iİ]kl(?:[Iİ]ler))?)?))))|(?:[Iİ]k(?:[Iİ](?:[\s\xa0]*Se|nc[Iİ][\s\xa0]*Se(?:l(?:an(?:[Iİ]kl(?:[Iİ]ler))?)?))))|[Iİ]k(?:[Iİ]nc(?:[Iİ][\s\xa0]*Se))|(?:İk(?:i(?:nc[İIi][\s\xa0]*Se(?:l(?:an(?:[iIİ]kl(?:[Iiİ]ler))?)?)|[\s\xa0]*Se(?:l(?:an[Iiİ]kl(?:[Iİi]ler))?)?)|[İI](?:nc(?:(?:[Iİ][\s\xa0]*Selan(?:(?:[İI]kliler|ikl[iİI]ler))|i[\s\xa0]*Se(?:l(?:an[Iİi]kl(?:[iIİ]ler))?)?)|[\s\xa0]*Selan(?:[İI]kliler|ikl[iIİ]ler))))|Selan(?:[İIi]kl(?:[iİI]ler(?:(?:[’']e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[İiI](?:[\s\xa0]*Mektup|nc[Iİi][\s\xa0]*Mektup)))|(?:[iİ]k(?:[iİI](?:[\s\xa0]*Mektup|nc[Iİi][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iİi](?:[\s\xa0]*Mektup|nc[Iİi][\s\xa0]*Mektup)))|(?:[iİ]k(?:[iIİ](?:[\s\xa0]*Mektup|nc[Iİi][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))))|Pavlus(?:tan[\s\xa0]*Selan(?:ikl(?:[iİI]ler(?:(?:[’']e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iiİ](?:[\s\xa0]*Mektup|nc[Iiİ][\s\xa0]*Mektup)))|(?:[İi]k(?:[iİI](?:[\s\xa0]*Mektup|nc[Iiİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[İiI](?:[\s\xa0]*Mektup|nc[iİI][\s\xa0]*Mektup)))|(?:[iİ]k(?:[Iİi](?:[\s\xa0]*Mektup|nc[iİI][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))))|(?:[İI]kl(?:(?:[İI]ler(?:(?:[’']e[\s\xa0]*(?:ik(?:[İIi](?:[\s\xa0]*Mektup|nc[Iİi][\s\xa0]*Mektup))|(?:[İI]k(?:i(?:[\s\xa0]*Mektup|nc[İiI][\s\xa0]*Mektup)|[Iİ]nci[\s\xa0]*Mektup))))|e[\s\xa0]*(?:ik(?:[Iİi](?:[\s\xa0]*Mektup|nc[iIİ][\s\xa0]*Mektup))|(?:[Iİ]k(?:i(?:[\s\xa0]*Mektup|nc[Iiİ][\s\xa0]*Mektup)|[Iİ]nci[\s\xa0]*Mektup)))))|iler(?:(?:[’']e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[İIi](?:[\s\xa0]*Mektup|nc[Iiİ][\s\xa0]*Mektup)))|(?:[iİ]k(?:[Iİi](?:[\s\xa0]*Mektup|nc[İIi][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iİi](?:[\s\xa0]*Mektup|nc[iİI][\s\xa0]*Mektup)))|(?:[İi]k(?:[iİI](?:[\s\xa0]*Mektup|nc[iIİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))))))|(?:[’']tan[\s\xa0]*Selan(?:ikl(?:[İIi]ler(?:(?:['’]e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[iİI](?:[\s\xa0]*Mektup|nc[Iiİ][\s\xa0]*Mektup)))|(?:[iİ]k(?:[iİI](?:[\s\xa0]*Mektup|nc[Iiİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iiİ](?:[\s\xa0]*Mektup|nc[Iİi][\s\xa0]*Mektup)))|(?:[İi]k(?:[İiI](?:[\s\xa0]*Mektup|nc[iİI][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))))|(?:[Iİ]kl(?:(?:[Iİ]ler(?:(?:[’']e[\s\xa0]*(?:ik(?:[Iiİ](?:[\s\xa0]*Mektup|nc[iİI][\s\xa0]*Mektup))|(?:[Iİ]k(?:i(?:[\s\xa0]*Mektup|nc[iİI][\s\xa0]*Mektup)|[İI]nci[\s\xa0]*Mektup))))|e[\s\xa0]*(?:ik(?:[Iiİ](?:[\s\xa0]*Mektup|nc[Iiİ][\s\xa0]*Mektup))|(?:[Iİ]k(?:i(?:[\s\xa0]*Mektup|nc[Iİi][\s\xa0]*Mektup)|[Iİ]nci[\s\xa0]*Mektup)))))|iler(?:(?:['’]e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iİi](?:[\s\xa0]*Mektup|nc[iİI][\s\xa0]*Mektup)))|(?:[iİ]k(?:[İIi](?:[\s\xa0]*Mektup|nc[Iiİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|e[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iiİ](?:[\s\xa0]*Mektup|nc[iİI][\s\xa0]*Mektup)))|(?:[iİ]k(?:[iİI](?:[\s\xa0]*Mektup|nc[iİI][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))))))))|ik[iİI](?:nc(?:[İiI][\s\xa0]*Se(?:l(?:an(?:[Iiİ]kl(?:[Iiİ]ler))?)?)|[\s\xa0]*Se(?:l(?:an[iİI]kl(?:[İIi]ler))?)?))|2(?:[\s\xa0]*Selan(?:[İI]kliler|ikl[İiI]ler)|\.[\s\xa0]*Selan(?:[İI]kliler|ikl[iİI]ler))|I(?:k(?:i(?:nc[Iİi][\s\xa0]*Se(?:l(?:an(?:[Iİi]kl(?:[iİI]ler))?)?)|[\s\xa0]*Se(?:l(?:an[İiI]kl(?:[iİI]ler))?)?)|[Iİ](?:nc(?:(?:[Iİ][\s\xa0]*Selan(?:(?:[İI]kliler|ikl[Iiİ]ler))|i[\s\xa0]*Se(?:l(?:an[iİI]kl(?:[iIİ]ler))?)?)|[\s\xa0]*Selan(?:[İI]kliler|ikl[iIİ]ler))))|I(?:[\s\xa0]*Selan(?:[Iİ]kliler|ikl[İIi]ler)|\.[\s\xa0]*Selan(?:[Iİ]kliler|ikl[iİI]ler))))|(?:ik[iİI](?:nc(?:[İiI][\s\xa0]*Se|[\s\xa0]*Se(?:l(?:an[iİI]kl(?:[İIi]ler))?)?))|[İI]k(?:(?:[İI][\s\xa0]*Selan(?:(?:[İI]kliler|ikl[iIİ]ler))|inc[İIi][\s\xa0]*Se)))|ik[iİI][\s\xa0]*Se(?:l(?:an(?:[iİI]kl(?:[İIi]ler))?)?)|ik(?:[iİI][\s\xa0]*Se))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["1Thess"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:Pavlus(?:(?:['’]tan[\s\xa0]*Selan(?:[Iİ]kl(?:[Iİ]ler(?:e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[Iİ]r(?:[\s\xa0]*Mektup|[Iİ]nc(?:[Iİ][\s\xa0]*Mektup)))|İlk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))|(?:['’]e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[Iİ]r(?:[\s\xa0]*Mektup|[Iİ]nc(?:[Iİ][\s\xa0]*Mektup)))|İlk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))))))|tan[\s\xa0]*Selan(?:[Iİ]kl(?:[Iİ]ler(?:e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[Iİ]r(?:[\s\xa0]*Mektup|[Iİ]nc(?:[Iİ][\s\xa0]*Mektup)))|İlk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))|(?:['’]e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[Iİ]r(?:[\s\xa0]*Mektup|[Iİ]nc(?:[Iİ][\s\xa0]*Mektup)))|İlk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))))))|B[Iİ]r(?:(?:[Iİ]nc(?:[Iİ][\s\xa0]*Se(?:l(?:an(?:[Iİ]kl(?:[Iİ]ler))?)?))|[\s\xa0]*Se(?:l(?:an[Iİ]kl(?:[Iİ]ler))?)?))|İlk[\s\xa0]*Se(?:l(?:an[Iİ]kl(?:[Iİ]ler))?)?|1(?:Thess|[\s\xa0]*Se(?:l(?:an[Iİ]kl(?:[Iİ]ler))?)?|\.[\s\xa0]*Se(?:l(?:an[Iİ]kl(?:[Iİ]ler))?)?|Se)|I(?:lk[\s\xa0]*Se(?:l(?:an[Iİ]kl(?:[Iİ]ler))?)?|[\s\xa0]*Se(?:l(?:an[Iİ]kl(?:[Iİ]ler))?)?|\.[\s\xa0]*Se(?:l(?:an[Iİ]kl(?:[Iİ]ler))?)?))|B[Iİ]r(?:[Iİ]nc(?:[Iİ][\s\xa0]*Se))|(?:Pavlus(?:(?:[’']tan[\s\xa0]*Selan(?:(?:[Iİ]kl(?:iler(?:(?:[’']e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[iİI]r(?:[\s\xa0]*Mektup|[Iİi]nc(?:[Iiİ][\s\xa0]*Mektup)))|[iİ]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[İIi]r(?:[\s\xa0]*Mektup|[Iİi]nc(?:[Iİi][\s\xa0]*Mektup)))|[İi]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|(?:[İI]ler(?:(?:[’']e[\s\xa0]*(?:B(?:ir(?:[\s\xa0]*Mektup|[Iİi]nc(?:[İiI][\s\xa0]*Mektup))|[İI]r(?:(?:[Iİ]nci[\s\xa0]*Mektup|inc[Iİi][\s\xa0]*Mektup)))|ilk[\s\xa0]*Mektup))|e[\s\xa0]*(?:B(?:ir(?:[\s\xa0]*Mektup|[Iİi]nc(?:[İIi][\s\xa0]*Mektup))|[İI]r(?:(?:[Iİ]nci[\s\xa0]*Mektup|inc[İiI][\s\xa0]*Mektup)))|ilk[\s\xa0]*Mektup)))))|ikl(?:[iIİ]ler(?:(?:[’']e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[iİI]r(?:[\s\xa0]*Mektup|[İiI]nc(?:[İIi][\s\xa0]*Mektup)))|[İi]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[İIi]r(?:[\s\xa0]*Mektup|[Iiİ]nc(?:[İiI][\s\xa0]*Mektup)))|[iİ]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))))))|tan[\s\xa0]*Selan(?:(?:[İI]kl(?:iler(?:(?:[’']e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[Iiİ]r(?:[\s\xa0]*Mektup|[Iİi]nc(?:[İIi][\s\xa0]*Mektup)))|[İi]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[iIİ]r(?:[\s\xa0]*Mektup|[Iiİ]nc(?:[Iİi][\s\xa0]*Mektup)))|[İi]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|(?:[İI]ler(?:(?:[’']e[\s\xa0]*(?:B(?:ir(?:[\s\xa0]*Mektup|[iİI]nc(?:[iİI][\s\xa0]*Mektup))|[İI]r(?:(?:[Iİ]nci[\s\xa0]*Mektup|inc[iIİ][\s\xa0]*Mektup)))|ilk[\s\xa0]*Mektup))|e[\s\xa0]*(?:B(?:ir(?:[\s\xa0]*Mektup|[İIi]nc(?:[Iiİ][\s\xa0]*Mektup))|[İI]r(?:(?:[Iİ]nci[\s\xa0]*Mektup|inc[İiI][\s\xa0]*Mektup)))|ilk[\s\xa0]*Mektup)))))|ikl(?:[iİI]ler(?:(?:[’']e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[İiI]r(?:[\s\xa0]*Mektup|[İiI]nc(?:[İIi][\s\xa0]*Mektup)))|[iİ]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[İIi]r(?:[\s\xa0]*Mektup|[İIi]nc(?:[iIİ][\s\xa0]*Mektup)))|[İi]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))))))|B(?:[İI]r(?:inc(?:[İIi][\s\xa0]*Se(?:l(?:an(?:[İIi]kl(?:[Iiİ]ler))?)?)|[İI]nc(?:(?:[İI][\s\xa0]*Selan(?:(?:[Iİ]kliler|ikl[iİI]ler))|i[\s\xa0]*Se(?:l(?:an[Iiİ]kl(?:[İIi]ler))?)?))|[\s\xa0]*Selan(?:[Iİ]kliler|ikl[iIİ]ler)))|ir(?:[iİI]nc(?:[iIİ][\s\xa0]*Se(?:l(?:an(?:[iIİ]kl(?:[Iiİ]ler))?)?))|[\s\xa0]*Se(?:l(?:an[Iİi]kl(?:[Iİi]ler))?)?))|Selan(?:[iIİ]kl(?:[İiI]ler(?:(?:[’']e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[Iiİ]r(?:[\s\xa0]*Mektup|[iİI]nc(?:[İiI][\s\xa0]*Mektup)))|[İi]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|e[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[İiI]r(?:[\s\xa0]*Mektup|[İIi]nc(?:[iİI][\s\xa0]*Mektup)))|[İi]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))))|I(?:lk[\s\xa0]*Selan(?:[Iİ]kliler|ikl[iIİ]ler)|[\s\xa0]*Selan(?:[İI]kliler|ikl[İiI]ler)|\.[\s\xa0]*Selan(?:[Iİ]kliler|ikl[İiI]ler))|1(?:[\s\xa0]*Selan(?:[Iİ]kliler|ikl[Iİi]ler)|\.[\s\xa0]*Selan(?:[Iİ]kliler|ikl[Iİi]ler))|İlk[\s\xa0]*Selan(?:[İI]kliler|ikl[iİI]ler)|ilk[\s\xa0]*Se(?:l(?:an[iİI]kl(?:[İIi]ler))?)?)|B(?:[İI]r(?:(?:[İI]nc(?:(?:[İI][\s\xa0]*Selan(?:(?:[Iİ]kliler|ikl[iİI]ler))|i[\s\xa0]*Se(?:l(?:an[Iiİ]kl(?:[İIi]ler))?)?))|[\s\xa0]*Selan(?:[Iİ]kliler|ikl[iIİ]ler)|inc[İIi][\s\xa0]*Se))|ir[iİI]nc(?:[iIİ][\s\xa0]*Se)))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["2Tim"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:2(?:Tim?|\.[\s\xa0]*T(?:[Iİ](?:m(?:ot(?:e(?:yus|os))?)?)?)|[\s\xa0]*T(?:[Iİ](?:m(?:ot(?:e(?:yus|os))?)?)?))|Pavlus(?:tan[\s\xa0]*T(?:[Iİ]moteos(?:a[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|İk(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))|(?:['’]a[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|İk(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup))))))|(?:['’]tan[\s\xa0]*T(?:[Iİ]moteos(?:a[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|İk(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))|(?:['’]a[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|İk(?:[Iİ](?:[\s\xa0]*Mektup|nc[Iİ][\s\xa0]*Mektup))))))))|I(?:k(?:[Iİ](?:nc(?:[Iİ][\s\xa0]*T(?:[Iİ](?:m(?:ot(?:e(?:yus|os))?)?)?))|[\s\xa0]*T(?:[Iİ](?:m(?:ot(?:e(?:yus|os))?)?)?)))|I(?:\.[\s\xa0]*T(?:[Iİ](?:m(?:ot(?:e(?:yus|os))?)?)?)|[\s\xa0]*T(?:[Iİ](?:m(?:ot(?:e(?:yus|os))?)?)?)))|İk(?:[Iİ](?:nc(?:[Iİ][\s\xa0]*T(?:[Iİ](?:m(?:ot(?:e(?:yus|os))?)?)?))|[\s\xa0]*T(?:[Iİ](?:m(?:ot(?:e(?:yus|os))?)?)?))))|(?:Pavlus(?:tan[\s\xa0]*T(?:imoteos(?:(?:[’']a[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[iIİ](?:[\s\xa0]*Mektup|nc[İiI][\s\xa0]*Mektup)))|(?:[iİ]k(?:[İIi](?:[\s\xa0]*Mektup|nc[iIİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|a[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[Iİi](?:[\s\xa0]*Mektup|nc[İIi][\s\xa0]*Mektup)))|(?:[iİ]k(?:[İIi](?:[\s\xa0]*Mektup|nc[Iİi][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|(?:[İI]moteos(?:a[\s\xa0]*(?:ik(?:[İiI](?:[\s\xa0]*Mektup|nc[İiI][\s\xa0]*Mektup))|(?:[Iİ]k(?:i(?:[\s\xa0]*Mektup|nc[Iiİ][\s\xa0]*Mektup)|[Iİ]nci[\s\xa0]*Mektup)))|(?:['’]a[\s\xa0]*(?:ik(?:[iİI](?:[\s\xa0]*Mektup|nc[iİI][\s\xa0]*Mektup))|(?:[Iİ]k(?:i(?:[\s\xa0]*Mektup|nc[Iiİ][\s\xa0]*Mektup)|[Iİ]nci[\s\xa0]*Mektup)))))))|(?:['’]tan[\s\xa0]*T(?:imoteos(?:(?:[’']a[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[iIİ](?:[\s\xa0]*Mektup|nc[iIİ][\s\xa0]*Mektup)))|(?:[İi]k(?:[Iİi](?:[\s\xa0]*Mektup|nc[İiI][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|a[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[iİI](?:[\s\xa0]*Mektup|nc[iİI][\s\xa0]*Mektup)))|(?:[iİ]k(?:[İIi](?:[\s\xa0]*Mektup|nc[iIİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|(?:[Iİ]moteos(?:a[\s\xa0]*(?:ik(?:[iİI](?:[\s\xa0]*Mektup|nc[iİI][\s\xa0]*Mektup))|(?:[Iİ]k(?:i(?:[\s\xa0]*Mektup|nc[Iİi][\s\xa0]*Mektup)|[Iİ]nci[\s\xa0]*Mektup)))|(?:['’]a[\s\xa0]*(?:ik(?:[Iiİ](?:[\s\xa0]*Mektup|nc[İiI][\s\xa0]*Mektup))|(?:[İI]k(?:i(?:[\s\xa0]*Mektup|nc[Iiİ][\s\xa0]*Mektup)|[Iİ]nci[\s\xa0]*Mektup)))))))))|T(?:[İIi]moteos(?:(?:[’']a[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[İiI](?:[\s\xa0]*Mektup|nc[İIi][\s\xa0]*Mektup)))|(?:[İi]k(?:[İiI](?:[\s\xa0]*Mektup|nc[Iiİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|a[\s\xa0]*(?:I(?:I(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|k(?:[iIİ](?:[\s\xa0]*Mektup|nc[iIİ][\s\xa0]*Mektup)))|(?:[İi]k(?:[Iİi](?:[\s\xa0]*Mektup|nc[iIİ][\s\xa0]*Mektup)))|2(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))))|2(?:[\s\xa0]*Ti(?:m(?:ot(?:e(?:yus|os))?)?)?|\.[\s\xa0]*Ti(?:m(?:ot(?:e(?:yus|os))?)?)?)|ik(?:[İiI](?:[\s\xa0]*T(?:[iİI](?:m(?:ot(?:e(?:yus|os))?)?)?)|nc(?:[iIİ][\s\xa0]*T(?:[Iİi](?:m(?:ot(?:e(?:yus|os))?)?)?))))|I(?:I(?:[\s\xa0]*Ti(?:m(?:ot(?:e(?:yus|os))?)?)?|\.[\s\xa0]*Ti(?:m(?:ot(?:e(?:yus|os))?)?)?)|k(?:(?:[Iİ](?:nc(?:i[\s\xa0]*T(?:[Iİi](?:m(?:ot(?:e(?:yus|os))?)?)?)|(?:[İI][\s\xa0]*Ti(?:m(?:ot(?:e(?:yus|os))?)?)?))|[\s\xa0]*Ti(?:m(?:ot(?:e(?:yus|os))?)?)?))|i(?:[\s\xa0]*T(?:[İiI](?:m(?:ot(?:e(?:yus|os))?)?)?)|nc(?:[Iiİ][\s\xa0]*T(?:[İiI](?:m(?:ot(?:e(?:yus|os))?)?)?)))))|İk(?:(?:[Iİ](?:nc(?:i[\s\xa0]*T(?:[iİI](?:m(?:ot(?:e(?:yus|os))?)?)?)|(?:[İI][\s\xa0]*Ti(?:m(?:ot(?:e(?:yus|os))?)?)?))|[\s\xa0]*Ti(?:m(?:ot(?:e(?:yus|os))?)?)?))|i(?:[\s\xa0]*T(?:[Iiİ](?:m(?:ot(?:e(?:yus|os))?)?)?)|nc(?:[Iİi][\s\xa0]*T(?:[İiI](?:m(?:ot(?:e(?:yus|os))?)?)?))))))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["1Tim"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:İlk[\s\xa0]*T(?:[Iİ](?:m(?:ot(?:e(?:yus|os))?)?)?)|1(?:Tim?|\.[\s\xa0]*T(?:[Iİ](?:m(?:ot(?:e(?:yus|os))?)?)?)|[\s\xa0]*T(?:[Iİ](?:m(?:ot(?:e(?:yus|os))?)?)?))|Pavlus(?:tan[\s\xa0]*T(?:[Iİ]moteos(?:a[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[Iİ]r(?:[\s\xa0]*Mektup|[Iİ]nc(?:[Iİ][\s\xa0]*Mektup)))|İlk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))|(?:['’]a[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[Iİ]r(?:[\s\xa0]*Mektup|[Iİ]nc(?:[Iİ][\s\xa0]*Mektup)))|İlk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))))|(?:['’]tan[\s\xa0]*T(?:[Iİ]moteos(?:a[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[Iİ]r(?:[\s\xa0]*Mektup|[Iİ]nc(?:[Iİ][\s\xa0]*Mektup)))|İlk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))|(?:['’]a[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[Iİ]r(?:[\s\xa0]*Mektup|[Iİ]nc(?:[Iİ][\s\xa0]*Mektup)))|İlk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))))))|I(?:lk[\s\xa0]*T(?:[Iİ](?:m(?:ot(?:e(?:yus|os))?)?)?)|\.[\s\xa0]*T(?:[Iİ](?:m(?:ot(?:e(?:yus|os))?)?)?)|[\s\xa0]*T(?:[Iİ](?:m(?:ot(?:e(?:yus|os))?)?)?))|B(?:[Iİ]r(?:(?:[Iİ]nc(?:[Iİ][\s\xa0]*T(?:[Iİ](?:m(?:ot(?:e(?:yus|os))?)?)?)))|[\s\xa0]*T(?:[Iİ](?:m(?:ot(?:e(?:yus|os))?)?)?))))|(?:İlk[\s\xa0]*Ti(?:m(?:ot(?:e(?:yus|os))?)?)?|B(?:(?:[Iİ]r(?:[\s\xa0]*Ti(?:m(?:ot(?:e(?:yus|os))?)?)?|inc(?:[Iiİ][\s\xa0]*T(?:[Iiİ](?:m(?:ot(?:e(?:yus|os))?)?)?))|(?:[İI]nc(?:i[\s\xa0]*T(?:[Iiİ](?:m(?:ot(?:e(?:yus|os))?)?)?)|(?:[Iİ][\s\xa0]*Ti(?:m(?:ot(?:e(?:yus|os))?)?)?)))))|ir(?:[\s\xa0]*T(?:[İiI](?:m(?:ot(?:e(?:yus|os))?)?)?)|(?:[İiI]nc(?:[iIİ][\s\xa0]*T(?:[İIi](?:m(?:ot(?:e(?:yus|os))?)?)?)))))|T(?:[Iİi]moteos(?:(?:['’]a[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[İIi]r(?:[\s\xa0]*Mektup|[İIi]nc(?:[iIİ][\s\xa0]*Mektup)))|[İi]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|a[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[Iİi]r(?:[\s\xa0]*Mektup|[İiI]nc(?:[iİI][\s\xa0]*Mektup)))|[İi]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))))|1(?:[\s\xa0]*Ti(?:m(?:ot(?:e(?:yus|os))?)?)?|\.[\s\xa0]*Ti(?:m(?:ot(?:e(?:yus|os))?)?)?)|I(?:lk[\s\xa0]*Ti(?:m(?:ot(?:e(?:yus|os))?)?)?|[\s\xa0]*Ti(?:m(?:ot(?:e(?:yus|os))?)?)?|\.[\s\xa0]*Ti(?:m(?:ot(?:e(?:yus|os))?)?)?)|Pavlus(?:tan[\s\xa0]*T(?:(?:[Iİ]moteos(?:a[\s\xa0]*(?:B(?:ir(?:[\s\xa0]*Mektup|[iIİ]nc(?:[iİI][\s\xa0]*Mektup))|[Iİ]r(?:(?:[İI]nci[\s\xa0]*Mektup|inc[iİI][\s\xa0]*Mektup)))|ilk[\s\xa0]*Mektup)|(?:[’']a[\s\xa0]*(?:B(?:ir(?:[\s\xa0]*Mektup|[iIİ]nc(?:[Iiİ][\s\xa0]*Mektup))|[İI]r(?:(?:[İI]nci[\s\xa0]*Mektup|inc[İiI][\s\xa0]*Mektup)))|ilk[\s\xa0]*Mektup))))|imoteos(?:(?:['’]a[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[Iİi]r(?:[\s\xa0]*Mektup|[İIi]nc(?:[İIi][\s\xa0]*Mektup)))|[İi]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|a[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[iİI]r(?:[\s\xa0]*Mektup|[Iİi]nc(?:[Iİi][\s\xa0]*Mektup)))|[iİ]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))))|(?:['’]tan[\s\xa0]*T(?:(?:[İI]moteos(?:a[\s\xa0]*(?:B(?:ir(?:[\s\xa0]*Mektup|[iIİ]nc(?:[İIi][\s\xa0]*Mektup))|[İI]r(?:(?:[Iİ]nci[\s\xa0]*Mektup|inc[iIİ][\s\xa0]*Mektup)))|ilk[\s\xa0]*Mektup)|(?:['’]a[\s\xa0]*(?:B(?:ir(?:[\s\xa0]*Mektup|[İIi]nc(?:[İIi][\s\xa0]*Mektup))|[Iİ]r(?:(?:[Iİ]nci[\s\xa0]*Mektup|inc[İiI][\s\xa0]*Mektup)))|ilk[\s\xa0]*Mektup))))|imoteos(?:(?:['’]a[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[İIi]r(?:[\s\xa0]*Mektup|[Iiİ]nc(?:[İiI][\s\xa0]*Mektup)))|[iİ]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)))|a[\s\xa0]*(?:I(?:[\s\xa0]*Mektup|lk[\s\xa0]*Mektup|\.[\s\xa0]*Mektup)|B(?:[Iİi]r(?:[\s\xa0]*Mektup|[Iiİ]nc(?:[iİI][\s\xa0]*Mektup)))|[iİ]lk[\s\xa0]*Mektup|1(?:[\s\xa0]*Mektup|\.[\s\xa0]*Mektup))))))|ilk[\s\xa0]*T(?:[İIi](?:m(?:ot(?:e(?:yus|os))?)?)?)))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["Titus"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Pavlus(?:['’]tan[\\s\\xa0]*T(?:[Iİ]t(?:[ou]s(?:(?:['’]a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup))))|tan[\\s\\xa0]*T[Iİ]t(?:[ou]s(?:(?:['’]a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup))))|T[Iİ]t)|(?:T(?:it[uo]s(?:(?:['’]a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup)?)?|[Iİ]t(?:[ou]s(?:(?:[’']a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup)?)))|Pavlus(?:['’]tan[\\s\\xa0]*T(?:it(?:[uo]s(?:(?:[’']a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup)?)|[Iİ]t(?:[uo]s)))|tan[\\s\\xa0]*T(?:it[ou]s(?:(?:[’']a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup)?)|[İI]t(?:[ou]s))))|(?:Pavlus['’]tan[\\s\\xa0]*T(?:[Iİ]t(?:[uo]s))|Tit))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Phlm"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Flm|P(?:hlm|avlus(?:tan[\\s\\xa0]*F[Iİ]l(?:[Iİ]mon(?:(?:['’]a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup)))|['’]tan[\\s\\xa0]*F(?:[Iİ]l(?:[Iİ]mon(?:(?:['’]a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup)))))))|(?:Pavlus(?:tan[\\s\\xa0]*F(?:il[iİI]mon(?:(?:[’']a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup)?)|[İI]l(?:imon(?:(?:['’]a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup)?|[İI]mon)))|['’]tan[\\s\\xa0]*F(?:il(?:[Iiİ]mon(?:(?:[’']a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup)?)|[İI]l(?:imon(?:(?:['’]a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup)?|[İI]mon)))))|F[iIİ]l(?:[iIİ]mon(?:(?:['’]a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup)?)))|Pavlus(?:[’']tan[\\s\\xa0]*F(?:[Iİ]l(?:imon(?:(?:[’']a[\\s\\xa0]*Mektup|a[\\s\\xa0]*Mektup)?|[İI]mon)))|tan[\\s\\xa0]*F[İI]l(?:[İI]mon))|Pavlus[’']tan[\\s\\xa0]*F(?:[Iİ]l(?:[İI]mon)))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Heb"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Heb|[Iİ]br(?:an(?:[Iİ]ler(?:(?:['’]e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)))?))|(?:[Iİ]br)|(?:[İI]braniler(?:(?:[’']e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup))|ibran[iİI]ler(?:(?:[’']e[\\s\\xa0]*Mektup|e[\\s\\xa0]*Mektup)))|(?:[İI]bran(?:[iİI]ler)|ibr(?:an[Iiİ]ler)?))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Jas"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Yak(?:u(?:b(?:['’]un[\\s\\xa0]*Mektubu|un[\\s\\xa0]*Mektubu)|p(?:['’]un[\\s\\xa0]*Mektubu|un[\\s\\xa0]*Mektubu)?))?|Jas))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["2Pet"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:2(?:[\s\xa0]*Pe(?:t(?:rus)?)?|Pet?|\.[\s\xa0]*Pe(?:t(?:rus)?)?)|I(?:I(?:[\s\xa0]*Pe(?:t(?:rus)?)?|\.[\s\xa0]*Pe(?:t(?:rus)?)?)|k(?:[Iİ](?:[\s\xa0]*Pe(?:t(?:rus)?)?|nc(?:[Iİ][\s\xa0]*Pe(?:t(?:rus)?)?))))|İk(?:[Iİ](?:[\s\xa0]*Pe(?:t(?:rus)?)?|nc(?:[Iİ][\s\xa0]*Pe(?:t(?:rus)?)?)))|Petrus(?:un[\s\xa0]*(?:İk(?:[Iİ](?:[\s\xa0]*Mektubu|nc[Iİ][\s\xa0]*Mektubu))|2(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu)|I(?:I(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu)|k(?:[Iİ](?:[\s\xa0]*Mektubu|nc[Iİ][\s\xa0]*Mektubu))))|(?:['’]un[\s\xa0]*(?:İk(?:[Iİ](?:[\s\xa0]*Mektubu|nc[Iİ][\s\xa0]*Mektubu))|2(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu)|I(?:I(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu)|k(?:[Iİ](?:[\s\xa0]*Mektubu|nc[Iİ][\s\xa0]*Mektubu)))))))|(?:(?:[İI]k(?:(?:[Iİ]nci[\s\xa0]*Pe(?:t(?:rus)?)?)|i(?:[\s\xa0]*Pe(?:t(?:rus)?)?|nc(?:[iİI][\s\xa0]*Pe(?:t(?:rus)?)?))))|Petrus(?:un[\s\xa0]*(?:(?:[İI]k(?:i(?:[\s\xa0]*Mektubu|nc[İIi][\s\xa0]*Mektubu)|[Iİ]nci[\s\xa0]*Mektubu))|ik(?:[İIi](?:[\s\xa0]*Mektubu|nc[İIi][\s\xa0]*Mektubu)))|(?:[’']un[\s\xa0]*(?:(?:[Iİ]k(?:i(?:[\s\xa0]*Mektubu|nc[iIİ][\s\xa0]*Mektubu)|[İI]nci[\s\xa0]*Mektubu))|ik(?:[iİI](?:[\s\xa0]*Mektubu|nc[Iİi][\s\xa0]*Mektubu)))))|ik(?:[iİI](?:[\s\xa0]*Pe(?:t(?:rus)?)?|nc(?:[Iİi][\s\xa0]*Pe(?:t(?:rus)?)?)))))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["1Pet"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:1(?:[\s\xa0]*Pe(?:t(?:rus)?)?|Pet?|\.[\s\xa0]*Pe(?:t(?:rus)?)?)|Petrus(?:(?:['’]un[\s\xa0]*(?:I(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu|lk[\s\xa0]*Mektubu)|İlk[\s\xa0]*Mektubu|B(?:[Iİ]r(?:[\s\xa0]*Mektubu|[Iİ]nc(?:[Iİ][\s\xa0]*Mektubu)))|1(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu)))|un[\s\xa0]*(?:I(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu|lk[\s\xa0]*Mektubu)|İlk[\s\xa0]*Mektubu|B(?:[Iİ]r(?:[\s\xa0]*Mektubu|[Iİ]nc(?:[Iİ][\s\xa0]*Mektubu)))|1(?:[\s\xa0]*Mektubu|\.[\s\xa0]*Mektubu)))|I(?:[\s\xa0]*Pe(?:t(?:rus)?)?|lk[\s\xa0]*Pe(?:t(?:rus)?)?|\.[\s\xa0]*Pe(?:t(?:rus)?)?)|B(?:[Iİ]r(?:[\s\xa0]*Pe(?:t(?:rus)?)?|(?:[Iİ]nc(?:[Iİ][\s\xa0]*Pe(?:t(?:rus)?)?))))|İlk[\s\xa0]*Pe(?:t(?:rus)?)?)|(?:B(?:(?:[İI]r(?:inc(?:[iIİ][\s\xa0]*Pe(?:t(?:rus)?)?)|(?:[Iİ]nci[\s\xa0]*Pe(?:t(?:rus)?)?)))|ir(?:[\s\xa0]*Pe(?:t(?:rus)?)?|(?:[iIİ]nc(?:[iIİ][\s\xa0]*Pe(?:t(?:rus)?)?))))|Petrus(?:(?:['’]un[\s\xa0]*(?:ilk[\s\xa0]*Mektubu|B(?:[İI]r(?:(?:[İI]nci[\s\xa0]*Mektubu|inc[iIİ][\s\xa0]*Mektubu))|ir(?:[\s\xa0]*Mektubu|[Iiİ]nc(?:[iIİ][\s\xa0]*Mektubu)))))|un[\s\xa0]*(?:ilk[\s\xa0]*Mektubu|B(?:[İI]r(?:(?:[İI]nci[\s\xa0]*Mektubu|inc[Iİi][\s\xa0]*Mektubu))|ir(?:[\s\xa0]*Mektubu|[İIi]nc(?:[Iİi][\s\xa0]*Mektubu)))))|ilk[\s\xa0]*Pe(?:t(?:rus)?)?))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["Jude"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Jude|Yah(?:uda(?:n[Iiİı]n[\\s\\xa0]*Mektubu|['’]n(?:[Iiİı]n[\\s\\xa0]*Mektubu))?)?))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Tob"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Tob(?:[Iiİ]t)?)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Jdt"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Jdt|Yud[Iiİ]t))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Bar"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Bar(?:uk)?)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Sus"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Su(?:s|zanna))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["2Macc"],
        apocrypha: true,
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:I(?:I(?:\.[\s\xa0]*Makabeler|[\s\xa0]*Makabeler)|k[Iİ](?:nc(?:[Iİ][\s\xa0]*Makabeler|[\s\xa0]*Makabeler)))|2(?:\.[\s\xa0]*Makabeler|Macc|[\s\xa0]*Makabeler)|İk[Iİ](?:nc(?:[Iİ][\s\xa0]*Makabeler|[\s\xa0]*Makabeler)))|[Iİ]k(?:[Iİ][\s\xa0]*Makabeler)|(?:ik[İiI](?:nc(?:[İiI][\s\xa0]*Makabeler|[\s\xa0]*Makabeler))|[Iİ]k(?:(?:[İI]nci[\s\xa0]*Makabeler|i(?:nc[Iİi][\s\xa0]*Makabeler|[\s\xa0]*Makabeler))))|ik(?:[İiI][\s\xa0]*Makabeler))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["3Macc"],
        apocrypha: true,
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:(?:[UÜ](?:[cç](?:[\s\xa0]*Makabeler|[uü]nc(?:[uü][\s\xa0]*Makabeler))))|3(?:\.[\s\xa0]*Makabeler|Macc|[\s\xa0]*Makabeler)|III(?:\.[\s\xa0]*Makabeler|[\s\xa0]*Makabeler)))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["4Macc"],
        apocrypha: true,
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:4(?:\.[\s\xa0]*Makabeler|Macc|[\s\xa0]*Makabeler)|D(?:[oö]r(?:t[\s\xa0]*Makabeler|d[uü]nc(?:[uü][\s\xa0]*Makabeler)))|IV(?:\.[\s\xa0]*Makabeler|[\s\xa0]*Makabeler)))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["1Macc"],
        apocrypha: true,
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏḀ-ỿⱠ-ⱿꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ])((?:B(?:[Iİ]r(?:[\s\xa0]*Makabeler|[Iİ]nc(?:[Iİ][\s\xa0]*Makabeler)))|1(?:\.[\s\xa0]*Makabeler|Macc|[\s\xa0]*Makabeler)|I(?:lk[\s\xa0]*Makabeler|\.[\s\xa0]*Makabeler|[\s\xa0]*Makabeler)|İlk[\s\xa0]*Makabeler)|(?:B(?:ir(?:[İIi]nc(?:[Iİi][\s\xa0]*Makabeler)|[\s\xa0]*Makabeler)|[Iİ]r(?:(?:[İI]nci[\s\xa0]*Makabeler|inc[Iiİ][\s\xa0]*Makabeler)))|ilk[\s\xa0]*Makabeler))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }
    ];
    if (include_apocrypha === true && case_sensitive === "none") {
      return books;
    }
    out = [];
    for (k = 0, len = books.length; k < len; k++) {
      book = books[k];
      if (include_apocrypha === false && (book.apocrypha != null) && book.apocrypha === true) {
        continue;
      }
      if (case_sensitive === "books") {
        book.regexp = new RegExp(book.regexp.source, "g");
      }
      out.push(book);
    }
    return out;
  };

  bcv_parser.prototype.regexps.books = bcv_parser.prototype.regexps.get_books(false, "none");
var grammar = (function() {
  "use strict";

  /*
   * Generated by PEG.js 0.9.0.
   *
   * http://pegjs.org/
   */

  function peg$subclass(child, parent) {
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor();
  }

  function peg$SyntaxError(message, expected, found, location) {
    this.message  = message;
    this.expected = expected;
    this.found    = found;
    this.location = location;
    this.name     = "SyntaxError";

    if (typeof Error.captureStackTrace === "function") {
      Error.captureStackTrace(this, peg$SyntaxError);
    }
  }

  peg$subclass(peg$SyntaxError, Error);

  function peg$parse(input) {
    var options = arguments.length > 1 ? arguments[1] : {},
        parser  = this,

        peg$FAILED = {},

        peg$startRuleFunctions = { start: peg$parsestart },
        peg$startRuleFunction  = peg$parsestart,

        peg$c0 = function(val_1, val_2) { val_2.unshift([val_1]); return {"type": "sequence", "value": val_2, "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c1 = "(",
        peg$c2 = { type: "literal", value: "(", description: "\"(\"" },
        peg$c3 = ")",
        peg$c4 = { type: "literal", value: ")", description: "\")\"" },
        peg$c5 = function(val_1, val_2) { if (typeof(val_2) === "undefined") val_2 = []; val_2.unshift([val_1]); return {"type": "sequence_post_enclosed", "value": val_2, "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c6 = function(val_1, val_2) { if (val_1.length && val_1.length === 2) val_1 = val_1[0]; // for `b`, which returns [object, undefined]
              return {"type": "range", "value": [val_1, val_2], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c7 = "\x1F",
        peg$c8 = { type: "literal", value: "\x1F", description: "\"\\x1F\"" },
        peg$c9 = "/",
        peg$c10 = { type: "literal", value: "/", description: "\"/\"" },
        peg$c11 = /^[1-8]/,
        peg$c12 = { type: "class", value: "[1-8]", description: "[1-8]" },
        peg$c13 = function(val) { return {"type": "b", "value": val.value, "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c14 = function(val_1, val_2) { return {"type": "bc", "value": [val_1, val_2], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c15 = ",",
        peg$c16 = { type: "literal", value: ",", description: "\",\"" },
        peg$c17 = function(val_1, val_2) { return {"type": "bc_title", "value": [val_1, val_2], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c18 = ".",
        peg$c19 = { type: "literal", value: ".", description: "\".\"" },
        peg$c20 = function(val_1, val_2) { return {"type": "bcv", "value": [val_1, val_2], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c21 = "-",
        peg$c22 = { type: "literal", value: "-", description: "\"-\"" },
        peg$c23 = function(val_1, val_2, val_3, val_4) { return {"type": "range", "value": [{"type": "bcv", "value": [{"type": "bc", "value": [val_1, val_2], "indices": [val_1.indices[0], val_2.indices[1]]}, val_3], "indices": [val_1.indices[0], val_3.indices[1]]}, val_4], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c24 = function(val_1, val_2) { return {"type": "bv", "value": [val_1, val_2], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c25 = function(val_1, val_2) { return {"type": "bc", "value": [val_2, val_1], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c26 = function(val_1, val_2, val_3) { return {"type": "cb_range", "value": [val_3, val_1, val_2], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c27 = "th",
        peg$c28 = { type: "literal", value: "th", description: "\"th\"" },
        peg$c29 = "nd",
        peg$c30 = { type: "literal", value: "nd", description: "\"nd\"" },
        peg$c31 = "st",
        peg$c32 = { type: "literal", value: "st", description: "\"st\"" },
        peg$c33 = "/1\x1F",
        peg$c34 = { type: "literal", value: "/1\x1F", description: "\"/1\\x1F\"" },
        peg$c35 = function(val) { return {"type": "c_psalm", "value": val.value, "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c36 = function(val_1, val_2) { return {"type": "cv_psalm", "value": [val_1, val_2], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c37 = function(val_1, val_2) { return {"type": "c_title", "value": [val_1, val_2], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c38 = function(val_1, val_2) { return {"type": "cv", "value": [val_1, val_2], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c39 = function(val) { return {"type": "c", "value": [val], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c40 = "vdm",
        peg$c41 = { type: "literal", value: "vdm", description: "\"vdm\"" },
        peg$c42 = "vd",
        peg$c43 = { type: "literal", value: "vd", description: "\"vd\"" },
        peg$c44 = /^[a-z]/,
        peg$c45 = { type: "class", value: "[a-z]", description: "[a-z]" },
        peg$c46 = function(val_1) { return {"type": "ff", "value": [val_1], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c47 = "ba",
        peg$c48 = { type: "literal", value: "ba", description: "\"ba\"" },
        peg$c49 = /^[\u015Fs]/i,
        peg$c50 = { type: "class", value: "[\u015Fs]i", description: "[\u015Fs]i" },
        peg$c51 = "l",
        peg$c52 = { type: "literal", value: "l", description: "\"l\"" },
        peg$c53 = /^[\u0130Ii\u0131]/i,
        peg$c54 = { type: "class", value: "[\u0130Ii\u0131]i", description: "[\u0130Ii\u0131]i" },
        peg$c55 = "k",
        peg$c56 = { type: "literal", value: "k", description: "\"k\"" },
        peg$c57 = function(val_1) { return {"type": "integer_title", "value": [val_1], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c58 = "/9\x1F",
        peg$c59 = { type: "literal", value: "/9\x1F", description: "\"/9\\x1F\"" },
        peg$c60 = function(val) { return {"type": "context", "value": val.value, "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c61 = "/2\x1F",
        peg$c62 = { type: "literal", value: "/2\x1F", description: "\"/2\\x1F\"" },
        peg$c63 = ".1",
        peg$c64 = { type: "literal", value: ".1", description: "\".1\"" },
        peg$c65 = /^[0-9]/,
        peg$c66 = { type: "class", value: "[0-9]", description: "[0-9]" },
        peg$c67 = function(val) { return {"type": "bc", "value": [val, {"type": "c", "value": [{"type": "integer", "value": 151, "indices": [peg$currPos - 2, peg$currPos - 1]}], "indices": [peg$currPos - 2, peg$currPos - 1]}], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c68 = function(val_1, val_2) { return {"type": "bcv", "value": [val_1, {"type": "v", "value": [val_2], "indices": [val_2.indices[0], val_2.indices[1]]}], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c69 = /^[b-e]/,
        peg$c70 = { type: "class", value: "[b-e]", description: "[b-e]" },
        peg$c71 = function(val) { return {"type": "v", "value": [val], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c72 = "b",
        peg$c73 = { type: "literal", value: "b", description: "\"b\"" },
        peg$c74 = "aplar",
        peg$c75 = { type: "literal", value: "aplar", description: "\"aplar\"" },
        peg$c76 = "ap",
        peg$c77 = { type: "literal", value: "ap", description: "\"ap\"" },
        peg$c78 = "lm",
        peg$c79 = { type: "literal", value: "lm", description: "\"lm\"" },
        peg$c80 = "p",
        peg$c81 = { type: "literal", value: "p", description: "\"p\"" },
        peg$c82 = /^[\xF6o]/i,
        peg$c83 = { type: "class", value: "[\xF6o]i", description: "[\xF6o]i" },
        peg$c84 = /^[\xFCu]/i,
        peg$c85 = { type: "class", value: "[\xFCu]i", description: "[\xFCu]i" },
        peg$c86 = "mler",
        peg$c87 = { type: "literal", value: "mler", description: "\"mler\"" },
        peg$c88 = "m",
        peg$c89 = { type: "literal", value: "m", description: "\"m\"" },
        peg$c90 = "l?",
        peg$c91 = { type: "literal", value: "l?", description: "\"l?\"" },
        peg$c92 = function() { return {"type": "c_explicit"} },
        peg$c93 = "a",
        peg$c94 = { type: "literal", value: "a", description: "\"a\"" },
        peg$c95 = "yet",
        peg$c96 = { type: "literal", value: "yet", description: "\"yet\"" },
        peg$c97 = /^[\u0130Ii]/i,
        peg$c98 = { type: "class", value: "[\u0130Ii]i", description: "[\u0130Ii]i" },
        peg$c99 = function() { return {"type": "v_explicit"} },
        peg$c100 = ":",
        peg$c101 = { type: "literal", value: ":", description: "\":\"" },
        peg$c102 = /^["']/,
        peg$c103 = { type: "class", value: "[\"']", description: "[\"']" },
        peg$c104 = /^[,;\/:&\-\u2013\u2014~]/,
        peg$c105 = { type: "class", value: "[,;/:&\\-\\u2013\\u2014~]", description: "[,;/:&\\-\\u2013\\u2014~]" },
        peg$c106 = "ve",
        peg$c107 = { type: "literal", value: "ve", description: "\"ve\"" },
        peg$c108 = function() { return "" },
        peg$c109 = /^[\-\u2013\u2014]/,
        peg$c110 = { type: "class", value: "[\\-\\u2013\\u2014]", description: "[\\-\\u2013\\u2014]" },
        peg$c111 = "la",
        peg$c112 = { type: "literal", value: "la", description: "\"la\"" },
        peg$c113 = "\u2013",
        peg$c114 = { type: "literal", value: "\u2013", description: "\"\\u2013\"" },
        peg$c115 = function(val) { return {type:"title", value: [val], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c116 = "from",
        peg$c117 = { type: "literal", value: "from", description: "\"from\"" },
        peg$c118 = "of",
        peg$c119 = { type: "literal", value: "of", description: "\"of\"" },
        peg$c120 = "in",
        peg$c121 = { type: "literal", value: "in", description: "\"in\"" },
        peg$c122 = "the",
        peg$c123 = { type: "literal", value: "the", description: "\"the\"" },
        peg$c124 = "book",
        peg$c125 = { type: "literal", value: "book", description: "\"book\"" },
        peg$c126 = /^[([]/,
        peg$c127 = { type: "class", value: "[\\(\\[]", description: "[\\(\\[]" },
        peg$c128 = /^[)\]]/,
        peg$c129 = { type: "class", value: "[\\)\\]]", description: "[\\)\\]]" },
        peg$c130 = function(val) { return {"type": "translation_sequence", "value": val, "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c131 = "\x1E",
        peg$c132 = { type: "literal", value: "\x1E", description: "\"\\x1E\"" },
        peg$c133 = function(val) { return {"type": "translation", "value": val.value, "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c134 = ",000",
        peg$c135 = { type: "literal", value: ",000", description: "\",000\"" },
        peg$c136 = function(val) { return {"type": "integer", "value": parseInt(val.join(""), 10), "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c137 = /^[^\x1F\x1E([]/,
        peg$c138 = { type: "class", value: "[^\\x1f\\x1e\\(\\[]", description: "[^\\x1f\\x1e\\(\\[]" },
        peg$c139 = function(val) { return {"type": "word", "value": val.join(""), "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c140 = function(val) { return {"type": "stop", "value": val, "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c141 = /^[\s\xa0*]/,
        peg$c142 = { type: "class", value: "[\\s\\xa0\\*]", description: "[\\s\\xa0\\*]" },

        peg$currPos          = 0,
        peg$savedPos         = 0,
        peg$posDetailsCache  = [{ line: 1, column: 1, seenCR: false }],
        peg$maxFailPos       = 0,
        peg$maxFailExpected  = [],
        peg$silentFails      = 0,

        peg$result;

    if ("startRule" in options) {
      if (!(options.startRule in peg$startRuleFunctions)) {
        throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
      }

      peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
    }

    if ("punctuation_strategy" in options && options.punctuation_strategy === "eu") {
        peg$parsecv_sep = peg$parseeu_cv_sep;
        peg$c104 = /^[;\/:&\-\u2013\u2014~]/;
    }

    function text() {
      return input.substring(peg$savedPos, peg$currPos);
    }

    function location() {
      return peg$computeLocation(peg$savedPos, peg$currPos);
    }

    function expected(description) {
      throw peg$buildException(
        null,
        [{ type: "other", description: description }],
        input.substring(peg$savedPos, peg$currPos),
        peg$computeLocation(peg$savedPos, peg$currPos)
      );
    }

    function error(message) {
      throw peg$buildException(
        message,
        null,
        input.substring(peg$savedPos, peg$currPos),
        peg$computeLocation(peg$savedPos, peg$currPos)
      );
    }

    function peg$computePosDetails(pos) {
      var details = peg$posDetailsCache[pos],
          p, ch;

      if (details) {
        return details;
      } else {
        p = pos - 1;
        while (!peg$posDetailsCache[p]) {
          p--;
        }

        details = peg$posDetailsCache[p];
        details = {
          line:   details.line,
          column: details.column,
          seenCR: details.seenCR
        };

        while (p < pos) {
          ch = input.charAt(p);
          if (ch === "\n") {
            if (!details.seenCR) { details.line++; }
            details.column = 1;
            details.seenCR = false;
          } else if (ch === "\r" || ch === "\u2028" || ch === "\u2029") {
            details.line++;
            details.column = 1;
            details.seenCR = true;
          } else {
            details.column++;
            details.seenCR = false;
          }

          p++;
        }

        peg$posDetailsCache[pos] = details;
        return details;
      }
    }

    function peg$computeLocation(startPos, endPos) {
      var startPosDetails = peg$computePosDetails(startPos),
          endPosDetails   = peg$computePosDetails(endPos);

      return {
        start: {
          offset: startPos,
          line:   startPosDetails.line,
          column: startPosDetails.column
        },
        end: {
          offset: endPos,
          line:   endPosDetails.line,
          column: endPosDetails.column
        }
      };
    }

    function peg$fail(expected) {
      if (peg$currPos < peg$maxFailPos) { return; }

      if (peg$currPos > peg$maxFailPos) {
        peg$maxFailPos = peg$currPos;
        peg$maxFailExpected = [];
      }

      peg$maxFailExpected.push(expected);
    }

    function peg$buildException(message, expected, found, location) {
      function cleanupExpected(expected) {
        var i = 1;

        expected.sort(function(a, b) {
          if (a.description < b.description) {
            return -1;
          } else if (a.description > b.description) {
            return 1;
          } else {
            return 0;
          }
        });

        while (i < expected.length) {
          if (expected[i - 1] === expected[i]) {
            expected.splice(i, 1);
          } else {
            i++;
          }
        }
      }

      function buildMessage(expected, found) {
        function stringEscape(s) {
          function hex(ch) { return ch.charCodeAt(0).toString(16).toUpperCase(); }

          return s
            .replace(/\\/g,   '\\\\')
            .replace(/"/g,    '\\"')
            .replace(/\x08/g, '\\b')
            .replace(/\t/g,   '\\t')
            .replace(/\n/g,   '\\n')
            .replace(/\f/g,   '\\f')
            .replace(/\r/g,   '\\r')
            .replace(/[\x00-\x07\x0B\x0E\x0F]/g, function(ch) { return '\\x0' + hex(ch); })
            .replace(/[\x10-\x1F\x80-\xFF]/g,    function(ch) { return '\\x'  + hex(ch); })
            .replace(/[\u0100-\u0FFF]/g,         function(ch) { return '\\u0' + hex(ch); })
            .replace(/[\u1000-\uFFFF]/g,         function(ch) { return '\\u'  + hex(ch); });
        }

        var expectedDescs = new Array(expected.length),
            expectedDesc, foundDesc, i;

        for (i = 0; i < expected.length; i++) {
          expectedDescs[i] = expected[i].description;
        }

        expectedDesc = expected.length > 1
          ? expectedDescs.slice(0, -1).join(", ")
              + " or "
              + expectedDescs[expected.length - 1]
          : expectedDescs[0];

        foundDesc = found ? "\"" + stringEscape(found) + "\"" : "end of input";

        return "Expected " + expectedDesc + " but " + foundDesc + " found.";
      }

      if (expected !== null) {
        cleanupExpected(expected);
      }

      return new peg$SyntaxError(
        message !== null ? message : buildMessage(expected, found),
        expected,
        found,
        location
      );
    }

    function peg$parsestart() {
      var s0, s1;

      s0 = [];
      s1 = peg$parsebcv_hyphen_range();
      if (s1 === peg$FAILED) {
        s1 = peg$parsesequence();
        if (s1 === peg$FAILED) {
          s1 = peg$parsecb_range();
          if (s1 === peg$FAILED) {
            s1 = peg$parserange();
            if (s1 === peg$FAILED) {
              s1 = peg$parseff();
              if (s1 === peg$FAILED) {
                s1 = peg$parsebcv_comma();
                if (s1 === peg$FAILED) {
                  s1 = peg$parsebc_title();
                  if (s1 === peg$FAILED) {
                    s1 = peg$parseps151_bcv();
                    if (s1 === peg$FAILED) {
                      s1 = peg$parsebcv();
                      if (s1 === peg$FAILED) {
                        s1 = peg$parsebcv_weak();
                        if (s1 === peg$FAILED) {
                          s1 = peg$parseps151_bc();
                          if (s1 === peg$FAILED) {
                            s1 = peg$parsebc();
                            if (s1 === peg$FAILED) {
                              s1 = peg$parsecv_psalm();
                              if (s1 === peg$FAILED) {
                                s1 = peg$parsebv();
                                if (s1 === peg$FAILED) {
                                  s1 = peg$parsec_psalm();
                                  if (s1 === peg$FAILED) {
                                    s1 = peg$parseb();
                                    if (s1 === peg$FAILED) {
                                      s1 = peg$parsecbv();
                                      if (s1 === peg$FAILED) {
                                        s1 = peg$parsecbv_ordinal();
                                        if (s1 === peg$FAILED) {
                                          s1 = peg$parsecb();
                                          if (s1 === peg$FAILED) {
                                            s1 = peg$parsecb_ordinal();
                                            if (s1 === peg$FAILED) {
                                              s1 = peg$parsetranslation_sequence_enclosed();
                                              if (s1 === peg$FAILED) {
                                                s1 = peg$parsetranslation_sequence();
                                                if (s1 === peg$FAILED) {
                                                  s1 = peg$parsesequence_sep();
                                                  if (s1 === peg$FAILED) {
                                                    s1 = peg$parsec_title();
                                                    if (s1 === peg$FAILED) {
                                                      s1 = peg$parseinteger_title();
                                                      if (s1 === peg$FAILED) {
                                                        s1 = peg$parsecv();
                                                        if (s1 === peg$FAILED) {
                                                          s1 = peg$parsecv_weak();
                                                          if (s1 === peg$FAILED) {
                                                            s1 = peg$parsev_letter();
                                                            if (s1 === peg$FAILED) {
                                                              s1 = peg$parseinteger();
                                                              if (s1 === peg$FAILED) {
                                                                s1 = peg$parsec();
                                                                if (s1 === peg$FAILED) {
                                                                  s1 = peg$parsev();
                                                                  if (s1 === peg$FAILED) {
                                                                    s1 = peg$parseword();
                                                                    if (s1 === peg$FAILED) {
                                                                      s1 = peg$parseword_parenthesis();
                                                                      if (s1 === peg$FAILED) {
                                                                        s1 = peg$parsecontext();
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                            }
                                                          }
                                                        }
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      if (s1 !== peg$FAILED) {
        while (s1 !== peg$FAILED) {
          s0.push(s1);
          s1 = peg$parsebcv_hyphen_range();
          if (s1 === peg$FAILED) {
            s1 = peg$parsesequence();
            if (s1 === peg$FAILED) {
              s1 = peg$parsecb_range();
              if (s1 === peg$FAILED) {
                s1 = peg$parserange();
                if (s1 === peg$FAILED) {
                  s1 = peg$parseff();
                  if (s1 === peg$FAILED) {
                    s1 = peg$parsebcv_comma();
                    if (s1 === peg$FAILED) {
                      s1 = peg$parsebc_title();
                      if (s1 === peg$FAILED) {
                        s1 = peg$parseps151_bcv();
                        if (s1 === peg$FAILED) {
                          s1 = peg$parsebcv();
                          if (s1 === peg$FAILED) {
                            s1 = peg$parsebcv_weak();
                            if (s1 === peg$FAILED) {
                              s1 = peg$parseps151_bc();
                              if (s1 === peg$FAILED) {
                                s1 = peg$parsebc();
                                if (s1 === peg$FAILED) {
                                  s1 = peg$parsecv_psalm();
                                  if (s1 === peg$FAILED) {
                                    s1 = peg$parsebv();
                                    if (s1 === peg$FAILED) {
                                      s1 = peg$parsec_psalm();
                                      if (s1 === peg$FAILED) {
                                        s1 = peg$parseb();
                                        if (s1 === peg$FAILED) {
                                          s1 = peg$parsecbv();
                                          if (s1 === peg$FAILED) {
                                            s1 = peg$parsecbv_ordinal();
                                            if (s1 === peg$FAILED) {
                                              s1 = peg$parsecb();
                                              if (s1 === peg$FAILED) {
                                                s1 = peg$parsecb_ordinal();
                                                if (s1 === peg$FAILED) {
                                                  s1 = peg$parsetranslation_sequence_enclosed();
                                                  if (s1 === peg$FAILED) {
                                                    s1 = peg$parsetranslation_sequence();
                                                    if (s1 === peg$FAILED) {
                                                      s1 = peg$parsesequence_sep();
                                                      if (s1 === peg$FAILED) {
                                                        s1 = peg$parsec_title();
                                                        if (s1 === peg$FAILED) {
                                                          s1 = peg$parseinteger_title();
                                                          if (s1 === peg$FAILED) {
                                                            s1 = peg$parsecv();
                                                            if (s1 === peg$FAILED) {
                                                              s1 = peg$parsecv_weak();
                                                              if (s1 === peg$FAILED) {
                                                                s1 = peg$parsev_letter();
                                                                if (s1 === peg$FAILED) {
                                                                  s1 = peg$parseinteger();
                                                                  if (s1 === peg$FAILED) {
                                                                    s1 = peg$parsec();
                                                                    if (s1 === peg$FAILED) {
                                                                      s1 = peg$parsev();
                                                                      if (s1 === peg$FAILED) {
                                                                        s1 = peg$parseword();
                                                                        if (s1 === peg$FAILED) {
                                                                          s1 = peg$parseword_parenthesis();
                                                                          if (s1 === peg$FAILED) {
                                                                            s1 = peg$parsecontext();
                                                                          }
                                                                        }
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                            }
                                                          }
                                                        }
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      } else {
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsesequence() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      s1 = peg$parsecb_range();
      if (s1 === peg$FAILED) {
        s1 = peg$parsebcv_hyphen_range();
        if (s1 === peg$FAILED) {
          s1 = peg$parserange();
          if (s1 === peg$FAILED) {
            s1 = peg$parseff();
            if (s1 === peg$FAILED) {
              s1 = peg$parsebcv_comma();
              if (s1 === peg$FAILED) {
                s1 = peg$parsebc_title();
                if (s1 === peg$FAILED) {
                  s1 = peg$parseps151_bcv();
                  if (s1 === peg$FAILED) {
                    s1 = peg$parsebcv();
                    if (s1 === peg$FAILED) {
                      s1 = peg$parsebcv_weak();
                      if (s1 === peg$FAILED) {
                        s1 = peg$parseps151_bc();
                        if (s1 === peg$FAILED) {
                          s1 = peg$parsebc();
                          if (s1 === peg$FAILED) {
                            s1 = peg$parsecv_psalm();
                            if (s1 === peg$FAILED) {
                              s1 = peg$parsebv();
                              if (s1 === peg$FAILED) {
                                s1 = peg$parsec_psalm();
                                if (s1 === peg$FAILED) {
                                  s1 = peg$parseb();
                                  if (s1 === peg$FAILED) {
                                    s1 = peg$parsecbv();
                                    if (s1 === peg$FAILED) {
                                      s1 = peg$parsecbv_ordinal();
                                      if (s1 === peg$FAILED) {
                                        s1 = peg$parsecb();
                                        if (s1 === peg$FAILED) {
                                          s1 = peg$parsecb_ordinal();
                                          if (s1 === peg$FAILED) {
                                            s1 = peg$parsecontext();
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        s4 = peg$parsesequence_sep();
        if (s4 === peg$FAILED) {
          s4 = null;
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parsesequence_post();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$currPos;
            s4 = peg$parsesequence_sep();
            if (s4 === peg$FAILED) {
              s4 = null;
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parsesequence_post();
              if (s5 !== peg$FAILED) {
                s4 = [s4, s5];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          }
        } else {
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c0(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsesequence_post_enclosed() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 40) {
        s1 = peg$c1;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c2); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parsesp();
        if (s2 !== peg$FAILED) {
          s3 = peg$parsesequence_sep();
          if (s3 === peg$FAILED) {
            s3 = null;
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parsesequence_post();
            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$currPos;
              s7 = peg$parsesequence_sep();
              if (s7 === peg$FAILED) {
                s7 = null;
              }
              if (s7 !== peg$FAILED) {
                s8 = peg$parsesequence_post();
                if (s8 !== peg$FAILED) {
                  s7 = [s7, s8];
                  s6 = s7;
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
              } else {
                peg$currPos = s6;
                s6 = peg$FAILED;
              }
              while (s6 !== peg$FAILED) {
                s5.push(s6);
                s6 = peg$currPos;
                s7 = peg$parsesequence_sep();
                if (s7 === peg$FAILED) {
                  s7 = null;
                }
                if (s7 !== peg$FAILED) {
                  s8 = peg$parsesequence_post();
                  if (s8 !== peg$FAILED) {
                    s7 = [s7, s8];
                    s6 = s7;
                  } else {
                    peg$currPos = s6;
                    s6 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
              }
              if (s5 !== peg$FAILED) {
                s6 = peg$parsesp();
                if (s6 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 41) {
                    s7 = peg$c3;
                    peg$currPos++;
                  } else {
                    s7 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c4); }
                  }
                  if (s7 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c5(s4, s5);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsesequence_post() {
      var s0;

      s0 = peg$parsesequence_post_enclosed();
      if (s0 === peg$FAILED) {
        s0 = peg$parsecb_range();
        if (s0 === peg$FAILED) {
          s0 = peg$parsebcv_hyphen_range();
          if (s0 === peg$FAILED) {
            s0 = peg$parserange();
            if (s0 === peg$FAILED) {
              s0 = peg$parseff();
              if (s0 === peg$FAILED) {
                s0 = peg$parsebcv_comma();
                if (s0 === peg$FAILED) {
                  s0 = peg$parsebc_title();
                  if (s0 === peg$FAILED) {
                    s0 = peg$parseps151_bcv();
                    if (s0 === peg$FAILED) {
                      s0 = peg$parsebcv();
                      if (s0 === peg$FAILED) {
                        s0 = peg$parsebcv_weak();
                        if (s0 === peg$FAILED) {
                          s0 = peg$parseps151_bc();
                          if (s0 === peg$FAILED) {
                            s0 = peg$parsebc();
                            if (s0 === peg$FAILED) {
                              s0 = peg$parsecv_psalm();
                              if (s0 === peg$FAILED) {
                                s0 = peg$parsebv();
                                if (s0 === peg$FAILED) {
                                  s0 = peg$parsec_psalm();
                                  if (s0 === peg$FAILED) {
                                    s0 = peg$parseb();
                                    if (s0 === peg$FAILED) {
                                      s0 = peg$parsecbv();
                                      if (s0 === peg$FAILED) {
                                        s0 = peg$parsecbv_ordinal();
                                        if (s0 === peg$FAILED) {
                                          s0 = peg$parsecb();
                                          if (s0 === peg$FAILED) {
                                            s0 = peg$parsecb_ordinal();
                                            if (s0 === peg$FAILED) {
                                              s0 = peg$parsec_title();
                                              if (s0 === peg$FAILED) {
                                                s0 = peg$parseinteger_title();
                                                if (s0 === peg$FAILED) {
                                                  s0 = peg$parsecv();
                                                  if (s0 === peg$FAILED) {
                                                    s0 = peg$parsecv_weak();
                                                    if (s0 === peg$FAILED) {
                                                      s0 = peg$parsev_letter();
                                                      if (s0 === peg$FAILED) {
                                                        s0 = peg$parseinteger();
                                                        if (s0 === peg$FAILED) {
                                                          s0 = peg$parsec();
                                                          if (s0 === peg$FAILED) {
                                                            s0 = peg$parsev();
                                                          }
                                                        }
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }

      return s0;
    }

    function peg$parserange() {
      var s0, s1, s2, s3, s4, s5, s6;

      s0 = peg$currPos;
      s1 = peg$parsebcv_comma();
      if (s1 === peg$FAILED) {
        s1 = peg$parsebc_title();
        if (s1 === peg$FAILED) {
          s1 = peg$parseps151_bcv();
          if (s1 === peg$FAILED) {
            s1 = peg$parsebcv();
            if (s1 === peg$FAILED) {
              s1 = peg$parsebcv_weak();
              if (s1 === peg$FAILED) {
                s1 = peg$parseps151_bc();
                if (s1 === peg$FAILED) {
                  s1 = peg$parsebc();
                  if (s1 === peg$FAILED) {
                    s1 = peg$parsecv_psalm();
                    if (s1 === peg$FAILED) {
                      s1 = peg$parsebv();
                      if (s1 === peg$FAILED) {
                        s1 = peg$currPos;
                        s2 = peg$parseb();
                        if (s2 !== peg$FAILED) {
                          s3 = peg$currPos;
                          peg$silentFails++;
                          s4 = peg$currPos;
                          s5 = peg$parserange_sep();
                          if (s5 !== peg$FAILED) {
                            s6 = peg$parsebcv_comma();
                            if (s6 === peg$FAILED) {
                              s6 = peg$parsebc_title();
                              if (s6 === peg$FAILED) {
                                s6 = peg$parseps151_bcv();
                                if (s6 === peg$FAILED) {
                                  s6 = peg$parsebcv();
                                  if (s6 === peg$FAILED) {
                                    s6 = peg$parsebcv_weak();
                                    if (s6 === peg$FAILED) {
                                      s6 = peg$parseps151_bc();
                                      if (s6 === peg$FAILED) {
                                        s6 = peg$parsebc();
                                        if (s6 === peg$FAILED) {
                                          s6 = peg$parsebv();
                                          if (s6 === peg$FAILED) {
                                            s6 = peg$parseb();
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                            if (s6 !== peg$FAILED) {
                              s5 = [s5, s6];
                              s4 = s5;
                            } else {
                              peg$currPos = s4;
                              s4 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s4;
                            s4 = peg$FAILED;
                          }
                          peg$silentFails--;
                          if (s4 !== peg$FAILED) {
                            peg$currPos = s3;
                            s3 = void 0;
                          } else {
                            s3 = peg$FAILED;
                          }
                          if (s3 !== peg$FAILED) {
                            s2 = [s2, s3];
                            s1 = s2;
                          } else {
                            peg$currPos = s1;
                            s1 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s1;
                          s1 = peg$FAILED;
                        }
                        if (s1 === peg$FAILED) {
                          s1 = peg$parsecbv();
                          if (s1 === peg$FAILED) {
                            s1 = peg$parsecbv_ordinal();
                            if (s1 === peg$FAILED) {
                              s1 = peg$parsec_psalm();
                              if (s1 === peg$FAILED) {
                                s1 = peg$parsecb();
                                if (s1 === peg$FAILED) {
                                  s1 = peg$parsecb_ordinal();
                                  if (s1 === peg$FAILED) {
                                    s1 = peg$parsec_title();
                                    if (s1 === peg$FAILED) {
                                      s1 = peg$parseinteger_title();
                                      if (s1 === peg$FAILED) {
                                        s1 = peg$parsecv();
                                        if (s1 === peg$FAILED) {
                                          s1 = peg$parsecv_weak();
                                          if (s1 === peg$FAILED) {
                                            s1 = peg$parsev_letter();
                                            if (s1 === peg$FAILED) {
                                              s1 = peg$parseinteger();
                                              if (s1 === peg$FAILED) {
                                                s1 = peg$parsec();
                                                if (s1 === peg$FAILED) {
                                                  s1 = peg$parsev();
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parserange_sep();
        if (s2 !== peg$FAILED) {
          s3 = peg$parseff();
          if (s3 === peg$FAILED) {
            s3 = peg$parsebcv_comma();
            if (s3 === peg$FAILED) {
              s3 = peg$parsebc_title();
              if (s3 === peg$FAILED) {
                s3 = peg$parseps151_bcv();
                if (s3 === peg$FAILED) {
                  s3 = peg$parsebcv();
                  if (s3 === peg$FAILED) {
                    s3 = peg$parsebcv_weak();
                    if (s3 === peg$FAILED) {
                      s3 = peg$parseps151_bc();
                      if (s3 === peg$FAILED) {
                        s3 = peg$parsebc();
                        if (s3 === peg$FAILED) {
                          s3 = peg$parsecv_psalm();
                          if (s3 === peg$FAILED) {
                            s3 = peg$parsebv();
                            if (s3 === peg$FAILED) {
                              s3 = peg$parseb();
                              if (s3 === peg$FAILED) {
                                s3 = peg$parsecbv();
                                if (s3 === peg$FAILED) {
                                  s3 = peg$parsecbv_ordinal();
                                  if (s3 === peg$FAILED) {
                                    s3 = peg$parsec_psalm();
                                    if (s3 === peg$FAILED) {
                                      s3 = peg$parsecb();
                                      if (s3 === peg$FAILED) {
                                        s3 = peg$parsecb_ordinal();
                                        if (s3 === peg$FAILED) {
                                          s3 = peg$parsec_title();
                                          if (s3 === peg$FAILED) {
                                            s3 = peg$parseinteger_title();
                                            if (s3 === peg$FAILED) {
                                              s3 = peg$parsecv();
                                              if (s3 === peg$FAILED) {
                                                s3 = peg$parsev_letter();
                                                if (s3 === peg$FAILED) {
                                                  s3 = peg$parseinteger();
                                                  if (s3 === peg$FAILED) {
                                                    s3 = peg$parsecv_weak();
                                                    if (s3 === peg$FAILED) {
                                                      s3 = peg$parsec();
                                                      if (s3 === peg$FAILED) {
                                                        s3 = peg$parsev();
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c6(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseb() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 31) {
        s1 = peg$c7;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c8); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseany_integer();
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 47) {
            s4 = peg$c9;
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c10); }
          }
          if (s4 !== peg$FAILED) {
            if (peg$c11.test(input.charAt(peg$currPos))) {
              s5 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c12); }
            }
            if (s5 !== peg$FAILED) {
              s4 = [s4, s5];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 === peg$FAILED) {
            s3 = null;
          }
          if (s3 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 31) {
              s4 = peg$c7;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c8); }
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c13(s2);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsebc() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      s0 = peg$currPos;
      s1 = peg$parseb();
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        s3 = peg$parsev_explicit();
        if (s3 !== peg$FAILED) {
          s4 = peg$currPos;
          peg$silentFails++;
          s5 = peg$currPos;
          s6 = peg$parsec();
          if (s6 !== peg$FAILED) {
            s7 = peg$parsecv_sep();
            if (s7 !== peg$FAILED) {
              s8 = peg$parsev();
              if (s8 !== peg$FAILED) {
                s6 = [s6, s7, s8];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          peg$silentFails--;
          if (s5 !== peg$FAILED) {
            peg$currPos = s4;
            s4 = void 0;
          } else {
            s4 = peg$FAILED;
          }
          if (s4 !== peg$FAILED) {
            s3 = [s3, s4];
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 === peg$FAILED) {
          s2 = [];
          s3 = peg$parsecv_sep();
          if (s3 !== peg$FAILED) {
            while (s3 !== peg$FAILED) {
              s2.push(s3);
              s3 = peg$parsecv_sep();
            }
          } else {
            s2 = peg$FAILED;
          }
          if (s2 === peg$FAILED) {
            s2 = [];
            s3 = peg$parsecv_sep_weak();
            if (s3 !== peg$FAILED) {
              while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$parsecv_sep_weak();
              }
            } else {
              s2 = peg$FAILED;
            }
            if (s2 === peg$FAILED) {
              s2 = [];
              s3 = peg$parserange_sep();
              if (s3 !== peg$FAILED) {
                while (s3 !== peg$FAILED) {
                  s2.push(s3);
                  s3 = peg$parserange_sep();
                }
              } else {
                s2 = peg$FAILED;
              }
              if (s2 === peg$FAILED) {
                s2 = peg$parsesp();
              }
            }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsec();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c14(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsebc_comma() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      s1 = peg$parseb();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsesp();
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 44) {
            s3 = peg$c15;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c16); }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parsesp();
            if (s4 !== peg$FAILED) {
              s5 = peg$parsec();
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c14(s1, s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsebc_title() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = peg$parseps151_bc();
      if (s1 === peg$FAILED) {
        s1 = peg$parsebc();
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parsetitle();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c17(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsebcv() {
      var s0, s1, s2, s3, s4, s5, s6;

      s0 = peg$currPos;
      s1 = peg$parseps151_bc();
      if (s1 === peg$FAILED) {
        s1 = peg$parsebc();
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        peg$silentFails++;
        s3 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 46) {
          s4 = peg$c18;
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c19); }
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parsev_explicit();
          if (s5 !== peg$FAILED) {
            s6 = peg$parsev();
            if (s6 !== peg$FAILED) {
              s4 = [s4, s5, s6];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 === peg$FAILED) {
          s3 = peg$currPos;
          s4 = peg$parsesequence_sep();
          if (s4 === peg$FAILED) {
            s4 = null;
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parsev_explicit();
            if (s5 !== peg$FAILED) {
              s6 = peg$parsecv();
              if (s6 !== peg$FAILED) {
                s4 = [s4, s5, s6];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
        peg$silentFails--;
        if (s3 === peg$FAILED) {
          s2 = void 0;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          s4 = peg$parsecv_sep();
          if (s4 === peg$FAILED) {
            s4 = peg$parsesequence_sep();
          }
          if (s4 === peg$FAILED) {
            s4 = null;
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parsev_explicit();
            if (s5 !== peg$FAILED) {
              s4 = [s4, s5];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 === peg$FAILED) {
            s3 = peg$parsecv_sep();
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parsev_letter();
            if (s4 === peg$FAILED) {
              s4 = peg$parsev();
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c20(s1, s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsebcv_weak() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      s0 = peg$currPos;
      s1 = peg$parseps151_bc();
      if (s1 === peg$FAILED) {
        s1 = peg$parsebc();
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parsecv_sep_weak();
        if (s2 !== peg$FAILED) {
          s3 = peg$parsev_letter();
          if (s3 === peg$FAILED) {
            s3 = peg$parsev();
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$currPos;
            peg$silentFails++;
            s5 = peg$currPos;
            s6 = peg$parsecv_sep();
            if (s6 !== peg$FAILED) {
              s7 = peg$parsev();
              if (s7 !== peg$FAILED) {
                s6 = [s6, s7];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            peg$silentFails--;
            if (s5 === peg$FAILED) {
              s4 = void 0;
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c20(s1, s3);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsebcv_comma() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

      s0 = peg$currPos;
      s1 = peg$parsebc_comma();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsesp();
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 44) {
            s3 = peg$c15;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c16); }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parsesp();
            if (s4 !== peg$FAILED) {
              s5 = peg$parsev_letter();
              if (s5 === peg$FAILED) {
                s5 = peg$parsev();
              }
              if (s5 !== peg$FAILED) {
                s6 = peg$currPos;
                peg$silentFails++;
                s7 = peg$currPos;
                s8 = peg$parsecv_sep();
                if (s8 !== peg$FAILED) {
                  s9 = peg$parsev();
                  if (s9 !== peg$FAILED) {
                    s8 = [s8, s9];
                    s7 = s8;
                  } else {
                    peg$currPos = s7;
                    s7 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s7;
                  s7 = peg$FAILED;
                }
                peg$silentFails--;
                if (s7 === peg$FAILED) {
                  s6 = void 0;
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
                if (s6 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c20(s1, s5);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsebcv_hyphen_range() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      s0 = peg$currPos;
      s1 = peg$parseb();
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 45) {
          s2 = peg$c21;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c22); }
        }
        if (s2 === peg$FAILED) {
          s2 = peg$parsespace();
        }
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsec();
          if (s3 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 45) {
              s4 = peg$c21;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c22); }
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parsev();
              if (s5 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 45) {
                  s6 = peg$c21;
                  peg$currPos++;
                } else {
                  s6 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c22); }
                }
                if (s6 !== peg$FAILED) {
                  s7 = peg$parsev();
                  if (s7 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c23(s1, s3, s5, s7);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsebv() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      s1 = peg$parseb();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parsecv_sep();
        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parsecv_sep();
          }
        } else {
          s2 = peg$FAILED;
        }
        if (s2 === peg$FAILED) {
          s2 = [];
          s3 = peg$parsecv_sep_weak();
          if (s3 !== peg$FAILED) {
            while (s3 !== peg$FAILED) {
              s2.push(s3);
              s3 = peg$parsecv_sep_weak();
            }
          } else {
            s2 = peg$FAILED;
          }
          if (s2 === peg$FAILED) {
            s2 = [];
            s3 = peg$parserange_sep();
            if (s3 !== peg$FAILED) {
              while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$parserange_sep();
              }
            } else {
              s2 = peg$FAILED;
            }
            if (s2 === peg$FAILED) {
              s2 = peg$currPos;
              s3 = [];
              s4 = peg$parsesequence_sep();
              if (s4 !== peg$FAILED) {
                while (s4 !== peg$FAILED) {
                  s3.push(s4);
                  s4 = peg$parsesequence_sep();
                }
              } else {
                s3 = peg$FAILED;
              }
              if (s3 !== peg$FAILED) {
                s4 = peg$currPos;
                peg$silentFails++;
                s5 = peg$parsev_explicit();
                peg$silentFails--;
                if (s5 !== peg$FAILED) {
                  peg$currPos = s4;
                  s4 = void 0;
                } else {
                  s4 = peg$FAILED;
                }
                if (s4 !== peg$FAILED) {
                  s3 = [s3, s4];
                  s2 = s3;
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
              if (s2 === peg$FAILED) {
                s2 = peg$parsesp();
              }
            }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsev_letter();
          if (s3 === peg$FAILED) {
            s3 = peg$parsev();
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c24(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsecb() {
      var s0, s1, s2, s3, s4;

      s0 = peg$currPos;
      s1 = peg$parsec_explicit();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsec();
        if (s2 !== peg$FAILED) {
          s3 = peg$parsein_book_of();
          if (s3 === peg$FAILED) {
            s3 = null;
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parseb();
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c25(s2, s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsecb_range() {
      var s0, s1, s2, s3, s4, s5, s6;

      s0 = peg$currPos;
      s1 = peg$parsec_explicit();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsec();
        if (s2 !== peg$FAILED) {
          s3 = peg$parserange_sep();
          if (s3 !== peg$FAILED) {
            s4 = peg$parsec();
            if (s4 !== peg$FAILED) {
              s5 = peg$parsein_book_of();
              if (s5 === peg$FAILED) {
                s5 = null;
              }
              if (s5 !== peg$FAILED) {
                s6 = peg$parseb();
                if (s6 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c26(s2, s4, s6);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsecbv() {
      var s0, s1, s2, s3, s4;

      s0 = peg$currPos;
      s1 = peg$parsecb();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsesequence_sep();
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsev_explicit();
          if (s3 !== peg$FAILED) {
            s4 = peg$parsev();
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c20(s1, s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsecb_ordinal() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      s1 = peg$parsec();
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 2) === peg$c27) {
          s2 = peg$c27;
          peg$currPos += 2;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c28); }
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 2) === peg$c29) {
            s2 = peg$c29;
            peg$currPos += 2;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c30); }
          }
          if (s2 === peg$FAILED) {
            if (input.substr(peg$currPos, 2) === peg$c31) {
              s2 = peg$c31;
              peg$currPos += 2;
            } else {
              s2 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c32); }
            }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsec_explicit();
          if (s3 !== peg$FAILED) {
            s4 = peg$parsein_book_of();
            if (s4 === peg$FAILED) {
              s4 = null;
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parseb();
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c25(s1, s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsecbv_ordinal() {
      var s0, s1, s2, s3, s4;

      s0 = peg$currPos;
      s1 = peg$parsecb_ordinal();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsesequence_sep();
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsev_explicit();
          if (s3 !== peg$FAILED) {
            s4 = peg$parsev();
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c20(s1, s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsec_psalm() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 31) {
        s1 = peg$c7;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c8); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseany_integer();
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 3) === peg$c33) {
            s3 = peg$c33;
            peg$currPos += 3;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c34); }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c35(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsecv_psalm() {
      var s0, s1, s2, s3, s4;

      s0 = peg$currPos;
      s1 = peg$parsec_psalm();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsesequence_sep();
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsev_explicit();
          if (s3 !== peg$FAILED) {
            s4 = peg$parsev();
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c36(s1, s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsec_title() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      s1 = peg$parsec_explicit();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsec();
        if (s2 !== peg$FAILED) {
          s3 = peg$parsetitle();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c37(s2, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsecv() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      s0 = peg$currPos;
      s1 = peg$parsev_explicit();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parsec();
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          peg$silentFails++;
          s4 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 46) {
            s5 = peg$c18;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c19); }
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parsev_explicit();
            if (s6 !== peg$FAILED) {
              s7 = peg$parsev();
              if (s7 !== peg$FAILED) {
                s5 = [s5, s6, s7];
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          peg$silentFails--;
          if (s4 === peg$FAILED) {
            s3 = void 0;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$currPos;
            s5 = peg$parsecv_sep();
            if (s5 === peg$FAILED) {
              s5 = null;
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parsev_explicit();
              if (s6 !== peg$FAILED) {
                s5 = [s5, s6];
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
            if (s4 === peg$FAILED) {
              s4 = peg$parsecv_sep();
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parsev_letter();
              if (s5 === peg$FAILED) {
                s5 = peg$parsev();
              }
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c38(s2, s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsecv_weak() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      s0 = peg$currPos;
      s1 = peg$parsec();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsecv_sep_weak();
        if (s2 !== peg$FAILED) {
          s3 = peg$parsev_letter();
          if (s3 === peg$FAILED) {
            s3 = peg$parsev();
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$currPos;
            peg$silentFails++;
            s5 = peg$currPos;
            s6 = peg$parsecv_sep();
            if (s6 !== peg$FAILED) {
              s7 = peg$parsev();
              if (s7 !== peg$FAILED) {
                s6 = [s6, s7];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            peg$silentFails--;
            if (s5 === peg$FAILED) {
              s4 = void 0;
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c38(s1, s3);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsec() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = peg$parsec_explicit();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseinteger();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c39(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseff() {
      var s0, s1, s2, s3, s4, s5, s6;

      s0 = peg$currPos;
      s1 = peg$parsebcv();
      if (s1 === peg$FAILED) {
        s1 = peg$parsebcv_weak();
        if (s1 === peg$FAILED) {
          s1 = peg$parsebc();
          if (s1 === peg$FAILED) {
            s1 = peg$parsebv();
            if (s1 === peg$FAILED) {
              s1 = peg$parsecv();
              if (s1 === peg$FAILED) {
                s1 = peg$parsecv_weak();
                if (s1 === peg$FAILED) {
                  s1 = peg$parseinteger();
                  if (s1 === peg$FAILED) {
                    s1 = peg$parsec();
                    if (s1 === peg$FAILED) {
                      s1 = peg$parsev();
                    }
                  }
                }
              }
            }
          }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parsesp();
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 3) === peg$c40) {
            s3 = peg$c40;
            peg$currPos += 3;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c41); }
          }
          if (s3 === peg$FAILED) {
            if (input.substr(peg$currPos, 2) === peg$c42) {
              s3 = peg$c42;
              peg$currPos += 2;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c43); }
            }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parseabbrev();
            if (s4 === peg$FAILED) {
              s4 = null;
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$currPos;
              peg$silentFails++;
              if (peg$c44.test(input.charAt(peg$currPos))) {
                s6 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s6 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c45); }
              }
              peg$silentFails--;
              if (s6 === peg$FAILED) {
                s5 = void 0;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c46(s1);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseinteger_title() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      s0 = peg$currPos;
      s1 = peg$parseinteger();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsecv_sep();
        if (s2 === peg$FAILED) {
          s2 = peg$parsesequence_sep();
        }
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 2) === peg$c47) {
            s3 = peg$c47;
            peg$currPos += 2;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c48); }
          }
          if (s3 !== peg$FAILED) {
            if (peg$c49.test(input.charAt(peg$currPos))) {
              s4 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c50); }
            }
            if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 108) {
                s5 = peg$c51;
                peg$currPos++;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c52); }
              }
              if (s5 !== peg$FAILED) {
                if (peg$c53.test(input.charAt(peg$currPos))) {
                  s6 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s6 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c54); }
                }
                if (s6 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 107) {
                    s7 = peg$c55;
                    peg$currPos++;
                  } else {
                    s7 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c56); }
                  }
                  if (s7 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c57(s1);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsecontext() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 31) {
        s1 = peg$c7;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c8); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseany_integer();
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 3) === peg$c58) {
            s3 = peg$c58;
            peg$currPos += 3;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c59); }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c60(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseps151_b() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 31) {
        s1 = peg$c7;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c8); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseany_integer();
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 3) === peg$c61) {
            s3 = peg$c61;
            peg$currPos += 3;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c62); }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c13(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseps151_bc() {
      var s0, s1, s2, s3, s4;

      s0 = peg$currPos;
      s1 = peg$parseps151_b();
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 2) === peg$c63) {
          s2 = peg$c63;
          peg$currPos += 2;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c64); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          peg$silentFails++;
          if (peg$c65.test(input.charAt(peg$currPos))) {
            s4 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c66); }
          }
          peg$silentFails--;
          if (s4 === peg$FAILED) {
            s3 = void 0;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c67(s1);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseps151_bcv() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      s1 = peg$parseps151_bc();
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 46) {
          s2 = peg$c18;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c19); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseinteger();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c68(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsev_letter() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      s0 = peg$currPos;
      s1 = peg$parsev_explicit();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseinteger();
        if (s2 !== peg$FAILED) {
          s3 = peg$parsesp();
          if (s3 !== peg$FAILED) {
            s4 = peg$currPos;
            peg$silentFails++;
            if (input.substr(peg$currPos, 3) === peg$c40) {
              s5 = peg$c40;
              peg$currPos += 3;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c41); }
            }
            if (s5 === peg$FAILED) {
              if (input.substr(peg$currPos, 2) === peg$c42) {
                s5 = peg$c42;
                peg$currPos += 2;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c43); }
              }
            }
            peg$silentFails--;
            if (s5 === peg$FAILED) {
              s4 = void 0;
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
            if (s4 !== peg$FAILED) {
              if (peg$c69.test(input.charAt(peg$currPos))) {
                s5 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c70); }
              }
              if (s5 !== peg$FAILED) {
                s6 = peg$currPos;
                peg$silentFails++;
                if (peg$c44.test(input.charAt(peg$currPos))) {
                  s7 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s7 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c45); }
                }
                peg$silentFails--;
                if (s7 === peg$FAILED) {
                  s6 = void 0;
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
                if (s6 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c71(s2);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsev() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = peg$parsev_explicit();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseinteger();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c71(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsec_explicit() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      s0 = peg$currPos;
      s1 = peg$parsesp();
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 98) {
          s3 = peg$c72;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c73); }
        }
        if (s3 !== peg$FAILED) {
          if (input.substr(peg$currPos, 5) === peg$c74) {
            s4 = peg$c74;
            peg$currPos += 5;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c75); }
          }
          if (s4 === peg$FAILED) {
            if (input.substr(peg$currPos, 2) === peg$c76) {
              s4 = peg$c76;
              peg$currPos += 2;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c77); }
            }
            if (s4 === peg$FAILED) {
              s4 = peg$currPos;
              if (input.substr(peg$currPos, 2) === peg$c78) {
                s5 = peg$c78;
                peg$currPos += 2;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c79); }
              }
              if (s5 !== peg$FAILED) {
                s6 = peg$parseabbrev();
                if (s6 === peg$FAILED) {
                  s6 = null;
                }
                if (s6 !== peg$FAILED) {
                  s5 = [s5, s6];
                  s4 = s5;
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
              if (s4 === peg$FAILED) {
                s4 = peg$currPos;
                if (input.charCodeAt(peg$currPos) === 112) {
                  s5 = peg$c80;
                  peg$currPos++;
                } else {
                  s5 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c81); }
                }
                if (s5 !== peg$FAILED) {
                  s6 = peg$parseabbrev();
                  if (s6 === peg$FAILED) {
                    s6 = null;
                  }
                  if (s6 !== peg$FAILED) {
                    s5 = [s5, s6];
                    s4 = s5;
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
                if (s4 === peg$FAILED) {
                  s4 = peg$currPos;
                  if (peg$c82.test(input.charAt(peg$currPos))) {
                    s5 = input.charAt(peg$currPos);
                    peg$currPos++;
                  } else {
                    s5 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c83); }
                  }
                  if (s5 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 108) {
                      s6 = peg$c51;
                      peg$currPos++;
                    } else {
                      s6 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c52); }
                    }
                    if (s6 !== peg$FAILED) {
                      if (peg$c84.test(input.charAt(peg$currPos))) {
                        s7 = input.charAt(peg$currPos);
                        peg$currPos++;
                      } else {
                        s7 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c85); }
                      }
                      if (s7 !== peg$FAILED) {
                        if (input.substr(peg$currPos, 4) === peg$c86) {
                          s8 = peg$c86;
                          peg$currPos += 4;
                        } else {
                          s8 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c87); }
                        }
                        if (s8 !== peg$FAILED) {
                          s5 = [s5, s6, s7, s8];
                          s4 = s5;
                        } else {
                          peg$currPos = s4;
                          s4 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s4;
                        s4 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s4;
                      s4 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                  if (s4 === peg$FAILED) {
                    s4 = peg$currPos;
                    if (peg$c82.test(input.charAt(peg$currPos))) {
                      s5 = input.charAt(peg$currPos);
                      peg$currPos++;
                    } else {
                      s5 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c83); }
                    }
                    if (s5 !== peg$FAILED) {
                      if (input.charCodeAt(peg$currPos) === 108) {
                        s6 = peg$c51;
                        peg$currPos++;
                      } else {
                        s6 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c52); }
                      }
                      if (s6 !== peg$FAILED) {
                        if (peg$c84.test(input.charAt(peg$currPos))) {
                          s7 = input.charAt(peg$currPos);
                          peg$currPos++;
                        } else {
                          s7 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c85); }
                        }
                        if (s7 !== peg$FAILED) {
                          if (input.charCodeAt(peg$currPos) === 109) {
                            s8 = peg$c88;
                            peg$currPos++;
                          } else {
                            s8 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c89); }
                          }
                          if (s8 !== peg$FAILED) {
                            s5 = [s5, s6, s7, s8];
                            s4 = s5;
                          } else {
                            peg$currPos = s4;
                            s4 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s4;
                          s4 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s4;
                        s4 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s4;
                      s4 = peg$FAILED;
                    }
                    if (s4 === peg$FAILED) {
                      s4 = peg$currPos;
                      if (peg$c82.test(input.charAt(peg$currPos))) {
                        s5 = input.charAt(peg$currPos);
                        peg$currPos++;
                      } else {
                        s5 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c83); }
                      }
                      if (s5 !== peg$FAILED) {
                        if (input.substr(peg$currPos, 2) === peg$c90) {
                          s6 = peg$c90;
                          peg$currPos += 2;
                        } else {
                          s6 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c91); }
                        }
                        if (s6 !== peg$FAILED) {
                          s7 = peg$parseabbrev();
                          if (s7 === peg$FAILED) {
                            s7 = null;
                          }
                          if (s7 !== peg$FAILED) {
                            s5 = [s5, s6, s7];
                            s4 = s5;
                          } else {
                            peg$currPos = s4;
                            s4 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s4;
                          s4 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s4;
                        s4 = peg$FAILED;
                      }
                    }
                  }
                }
              }
            }
          }
          if (s4 !== peg$FAILED) {
            s3 = [s3, s4];
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsesp();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c92();
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsev_explicit() {
      var s0, s1, s2, s3, s4, s5, s6;

      s0 = peg$currPos;
      s1 = peg$parsesp();
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 97) {
          s3 = peg$c93;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c94); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parseabbrev();
          if (s4 === peg$FAILED) {
            s4 = peg$currPos;
            if (input.substr(peg$currPos, 3) === peg$c95) {
              s5 = peg$c95;
              peg$currPos += 3;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c96); }
            }
            if (s5 !== peg$FAILED) {
              if (peg$c97.test(input.charAt(peg$currPos))) {
                s6 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s6 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c98); }
              }
              if (s6 !== peg$FAILED) {
                s5 = [s5, s6];
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
            if (s4 === peg$FAILED) {
              if (input.substr(peg$currPos, 3) === peg$c95) {
                s4 = peg$c95;
                peg$currPos += 3;
              } else {
                s4 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c96); }
              }
            }
          }
          if (s4 !== peg$FAILED) {
            s3 = [s3, s4];
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          peg$silentFails++;
          if (peg$c44.test(input.charAt(peg$currPos))) {
            s4 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c45); }
          }
          peg$silentFails--;
          if (s4 === peg$FAILED) {
            s3 = void 0;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parsesp();
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c99();
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsecv_sep() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

      s0 = peg$currPos;
      s1 = peg$parsesp();
      if (s1 !== peg$FAILED) {
        s2 = [];
        if (input.charCodeAt(peg$currPos) === 58) {
          s3 = peg$c100;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c101); }
        }
        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            if (input.charCodeAt(peg$currPos) === 58) {
              s3 = peg$c100;
              peg$currPos++;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c101); }
            }
          }
        } else {
          s2 = peg$FAILED;
        }
        if (s2 === peg$FAILED) {
          s2 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 46) {
            s3 = peg$c18;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c19); }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$currPos;
            peg$silentFails++;
            s5 = peg$currPos;
            s6 = peg$parsesp();
            if (s6 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 46) {
                s7 = peg$c18;
                peg$currPos++;
              } else {
                s7 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c19); }
              }
              if (s7 !== peg$FAILED) {
                s8 = peg$parsesp();
                if (s8 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 46) {
                    s9 = peg$c18;
                    peg$currPos++;
                  } else {
                    s9 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c19); }
                  }
                  if (s9 !== peg$FAILED) {
                    s6 = [s6, s7, s8, s9];
                    s5 = s6;
                  } else {
                    peg$currPos = s5;
                    s5 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            peg$silentFails--;
            if (s5 === peg$FAILED) {
              s4 = void 0;
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
            if (s4 !== peg$FAILED) {
              s3 = [s3, s4];
              s2 = s3;
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsesp();
          if (s3 !== peg$FAILED) {
            s1 = [s1, s2, s3];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsecv_sep_weak() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      s1 = peg$parsesp();
      if (s1 !== peg$FAILED) {
        if (peg$c102.test(input.charAt(peg$currPos))) {
          s2 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c103); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsesp();
          if (s3 !== peg$FAILED) {
            s1 = [s1, s2, s3];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$parsespace();
      }

      return s0;
    }

    function peg$parsesequence_sep() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

      s0 = peg$currPos;
      s1 = [];
      if (peg$c104.test(input.charAt(peg$currPos))) {
        s2 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c105); }
      }
      if (s2 === peg$FAILED) {
        s2 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 46) {
          s3 = peg$c18;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c19); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$currPos;
          peg$silentFails++;
          s5 = peg$currPos;
          s6 = peg$parsesp();
          if (s6 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 46) {
              s7 = peg$c18;
              peg$currPos++;
            } else {
              s7 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c19); }
            }
            if (s7 !== peg$FAILED) {
              s8 = peg$parsesp();
              if (s8 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 46) {
                  s9 = peg$c18;
                  peg$currPos++;
                } else {
                  s9 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c19); }
                }
                if (s9 !== peg$FAILED) {
                  s6 = [s6, s7, s8, s9];
                  s5 = s6;
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          peg$silentFails--;
          if (s5 === peg$FAILED) {
            s4 = void 0;
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          if (s4 !== peg$FAILED) {
            s3 = [s3, s4];
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 2) === peg$c106) {
            s2 = peg$c106;
            peg$currPos += 2;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c107); }
          }
          if (s2 === peg$FAILED) {
            s2 = peg$parsespace();
          }
        }
      }
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          if (peg$c104.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c105); }
          }
          if (s2 === peg$FAILED) {
            s2 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 46) {
              s3 = peg$c18;
              peg$currPos++;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c19); }
            }
            if (s3 !== peg$FAILED) {
              s4 = peg$currPos;
              peg$silentFails++;
              s5 = peg$currPos;
              s6 = peg$parsesp();
              if (s6 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 46) {
                  s7 = peg$c18;
                  peg$currPos++;
                } else {
                  s7 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c19); }
                }
                if (s7 !== peg$FAILED) {
                  s8 = peg$parsesp();
                  if (s8 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 46) {
                      s9 = peg$c18;
                      peg$currPos++;
                    } else {
                      s9 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c19); }
                    }
                    if (s9 !== peg$FAILED) {
                      s6 = [s6, s7, s8, s9];
                      s5 = s6;
                    } else {
                      peg$currPos = s5;
                      s5 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s5;
                    s5 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
              peg$silentFails--;
              if (s5 === peg$FAILED) {
                s4 = void 0;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
              if (s4 !== peg$FAILED) {
                s3 = [s3, s4];
                s2 = s3;
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
            if (s2 === peg$FAILED) {
              if (input.substr(peg$currPos, 2) === peg$c106) {
                s2 = peg$c106;
                peg$currPos += 2;
              } else {
                s2 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c107); }
              }
              if (s2 === peg$FAILED) {
                s2 = peg$parsespace();
              }
            }
          }
        }
      } else {
        s1 = peg$FAILED;
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c108();
      }
      s0 = s1;

      return s0;
    }

    function peg$parserange_sep() {
      var s0, s1, s2, s3, s4, s5, s6;

      s0 = peg$currPos;
      s1 = peg$parsesp();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        if (peg$c109.test(input.charAt(peg$currPos))) {
          s4 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c110); }
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parsesp();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 === peg$FAILED) {
          s3 = peg$currPos;
          if (peg$c97.test(input.charAt(peg$currPos))) {
            s4 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c98); }
          }
          if (s4 !== peg$FAILED) {
            if (input.substr(peg$currPos, 2) === peg$c111) {
              s5 = peg$c111;
              peg$currPos += 2;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c112); }
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parsesp();
              if (s6 !== peg$FAILED) {
                s4 = [s4, s5, s6];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 === peg$FAILED) {
            s3 = peg$currPos;
            if (input.substr(peg$currPos, 1).toLowerCase() === peg$c113) {
              s4 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c114); }
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parsesp();
              if (s5 !== peg$FAILED) {
                s4 = [s4, s5];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          }
        }
        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$currPos;
            if (peg$c109.test(input.charAt(peg$currPos))) {
              s4 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c110); }
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parsesp();
              if (s5 !== peg$FAILED) {
                s4 = [s4, s5];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
            if (s3 === peg$FAILED) {
              s3 = peg$currPos;
              if (peg$c97.test(input.charAt(peg$currPos))) {
                s4 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s4 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c98); }
              }
              if (s4 !== peg$FAILED) {
                if (input.substr(peg$currPos, 2) === peg$c111) {
                  s5 = peg$c111;
                  peg$currPos += 2;
                } else {
                  s5 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c112); }
                }
                if (s5 !== peg$FAILED) {
                  s6 = peg$parsesp();
                  if (s6 !== peg$FAILED) {
                    s4 = [s4, s5, s6];
                    s3 = s4;
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
              if (s3 === peg$FAILED) {
                s3 = peg$currPos;
                if (input.substr(peg$currPos, 1).toLowerCase() === peg$c113) {
                  s4 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s4 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c114); }
                }
                if (s4 !== peg$FAILED) {
                  s5 = peg$parsesp();
                  if (s5 !== peg$FAILED) {
                    s4 = [s4, s5];
                    s3 = s4;
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              }
            }
          }
        } else {
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          s1 = [s1, s2];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsetitle() {
      var s0, s1, s2, s3, s4, s5, s6;

      s0 = peg$currPos;
      s1 = peg$parsecv_sep();
      if (s1 === peg$FAILED) {
        s1 = peg$parsesequence_sep();
      }
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 2) === peg$c47) {
          s2 = peg$c47;
          peg$currPos += 2;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c48); }
        }
        if (s2 !== peg$FAILED) {
          if (peg$c49.test(input.charAt(peg$currPos))) {
            s3 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c50); }
          }
          if (s3 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 108) {
              s4 = peg$c51;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c52); }
            }
            if (s4 !== peg$FAILED) {
              if (peg$c53.test(input.charAt(peg$currPos))) {
                s5 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c54); }
              }
              if (s5 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 107) {
                  s6 = peg$c55;
                  peg$currPos++;
                } else {
                  s6 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c56); }
                }
                if (s6 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c115(s2);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsein_book_of() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10;

      s0 = peg$currPos;
      s1 = peg$parsesp();
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 4) === peg$c116) {
          s2 = peg$c116;
          peg$currPos += 4;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c117); }
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 2) === peg$c118) {
            s2 = peg$c118;
            peg$currPos += 2;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c119); }
          }
          if (s2 === peg$FAILED) {
            if (input.substr(peg$currPos, 2) === peg$c120) {
              s2 = peg$c120;
              peg$currPos += 2;
            } else {
              s2 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c121); }
            }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsesp();
          if (s3 !== peg$FAILED) {
            s4 = peg$currPos;
            if (input.substr(peg$currPos, 3) === peg$c122) {
              s5 = peg$c122;
              peg$currPos += 3;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c123); }
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parsesp();
              if (s6 !== peg$FAILED) {
                if (input.substr(peg$currPos, 4) === peg$c124) {
                  s7 = peg$c124;
                  peg$currPos += 4;
                } else {
                  s7 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c125); }
                }
                if (s7 !== peg$FAILED) {
                  s8 = peg$parsesp();
                  if (s8 !== peg$FAILED) {
                    if (input.substr(peg$currPos, 2) === peg$c118) {
                      s9 = peg$c118;
                      peg$currPos += 2;
                    } else {
                      s9 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c119); }
                    }
                    if (s9 !== peg$FAILED) {
                      s10 = peg$parsesp();
                      if (s10 !== peg$FAILED) {
                        s5 = [s5, s6, s7, s8, s9, s10];
                        s4 = s5;
                      } else {
                        peg$currPos = s4;
                        s4 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s4;
                      s4 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
            if (s4 === peg$FAILED) {
              s4 = null;
            }
            if (s4 !== peg$FAILED) {
              s1 = [s1, s2, s3, s4];
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseabbrev() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      s0 = peg$currPos;
      s1 = peg$parsesp();
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 46) {
          s2 = peg$c18;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c19); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          peg$silentFails++;
          s4 = peg$currPos;
          s5 = peg$parsesp();
          if (s5 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 46) {
              s6 = peg$c18;
              peg$currPos++;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c19); }
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$parsesp();
              if (s7 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 46) {
                  s8 = peg$c18;
                  peg$currPos++;
                } else {
                  s8 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c19); }
                }
                if (s8 !== peg$FAILED) {
                  s5 = [s5, s6, s7, s8];
                  s4 = s5;
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          peg$silentFails--;
          if (s4 === peg$FAILED) {
            s3 = void 0;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 !== peg$FAILED) {
            s1 = [s1, s2, s3];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseeu_cv_sep() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      s1 = peg$parsesp();
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 44) {
          s2 = peg$c15;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c16); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsesp();
          if (s3 !== peg$FAILED) {
            s1 = [s1, s2, s3];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsetranslation_sequence_enclosed() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

      s0 = peg$currPos;
      s1 = peg$parsesp();
      if (s1 !== peg$FAILED) {
        if (peg$c126.test(input.charAt(peg$currPos))) {
          s2 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c127); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsesp();
          if (s3 !== peg$FAILED) {
            s4 = peg$currPos;
            s5 = peg$parsetranslation();
            if (s5 !== peg$FAILED) {
              s6 = [];
              s7 = peg$currPos;
              s8 = peg$parsesequence_sep();
              if (s8 !== peg$FAILED) {
                s9 = peg$parsetranslation();
                if (s9 !== peg$FAILED) {
                  s8 = [s8, s9];
                  s7 = s8;
                } else {
                  peg$currPos = s7;
                  s7 = peg$FAILED;
                }
              } else {
                peg$currPos = s7;
                s7 = peg$FAILED;
              }
              while (s7 !== peg$FAILED) {
                s6.push(s7);
                s7 = peg$currPos;
                s8 = peg$parsesequence_sep();
                if (s8 !== peg$FAILED) {
                  s9 = peg$parsetranslation();
                  if (s9 !== peg$FAILED) {
                    s8 = [s8, s9];
                    s7 = s8;
                  } else {
                    peg$currPos = s7;
                    s7 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s7;
                  s7 = peg$FAILED;
                }
              }
              if (s6 !== peg$FAILED) {
                s5 = [s5, s6];
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parsesp();
              if (s5 !== peg$FAILED) {
                if (peg$c128.test(input.charAt(peg$currPos))) {
                  s6 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s6 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c129); }
                }
                if (s6 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c130(s4);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsetranslation_sequence() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      s0 = peg$currPos;
      s1 = peg$parsesp();
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 44) {
          s3 = peg$c15;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c16); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsesp();
          if (s4 !== peg$FAILED) {
            s3 = [s3, s4];
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          s4 = peg$parsetranslation();
          if (s4 !== peg$FAILED) {
            s5 = [];
            s6 = peg$currPos;
            s7 = peg$parsesequence_sep();
            if (s7 !== peg$FAILED) {
              s8 = peg$parsetranslation();
              if (s8 !== peg$FAILED) {
                s7 = [s7, s8];
                s6 = s7;
              } else {
                peg$currPos = s6;
                s6 = peg$FAILED;
              }
            } else {
              peg$currPos = s6;
              s6 = peg$FAILED;
            }
            while (s6 !== peg$FAILED) {
              s5.push(s6);
              s6 = peg$currPos;
              s7 = peg$parsesequence_sep();
              if (s7 !== peg$FAILED) {
                s8 = peg$parsetranslation();
                if (s8 !== peg$FAILED) {
                  s7 = [s7, s8];
                  s6 = s7;
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
              } else {
                peg$currPos = s6;
                s6 = peg$FAILED;
              }
            }
            if (s5 !== peg$FAILED) {
              s4 = [s4, s5];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c130(s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsetranslation() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 30) {
        s1 = peg$c131;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c132); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseany_integer();
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 30) {
            s3 = peg$c131;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c132); }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c133(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseinteger() {
      var res;
      if (res = /^[0-9]{1,3}(?!\d|,000)/.exec(input.substr(peg$currPos))) {
      	peg$savedPos = peg$currPos;
        peg$currPos += res[0].length;
        return {"type": "integer", "value": parseInt(res[0], 10), "indices": [peg$savedPos, peg$currPos - 1]}
      } else {
        return peg$FAILED;
      }
    }

    function peg$parseany_integer() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = [];
      if (peg$c65.test(input.charAt(peg$currPos))) {
        s2 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c66); }
      }
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          if (peg$c65.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c66); }
          }
        }
      } else {
        s1 = peg$FAILED;
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c136(s1);
      }
      s0 = s1;

      return s0;
    }

    function peg$parseword() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = [];
      if (peg$c137.test(input.charAt(peg$currPos))) {
        s2 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c138); }
      }
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          if (peg$c137.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c138); }
          }
        }
      } else {
        s1 = peg$FAILED;
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c139(s1);
      }
      s0 = s1;

      return s0;
    }

    function peg$parseword_parenthesis() {
      var s0, s1;

      s0 = peg$currPos;
      if (peg$c126.test(input.charAt(peg$currPos))) {
        s1 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c127); }
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c140(s1);
      }
      s0 = s1;

      return s0;
    }

    function peg$parsesp() {
      var s0;

      s0 = peg$parsespace();
      if (s0 === peg$FAILED) {
        s0 = null;
      }

      return s0;
    }

    function peg$parsespace() {
      var res;
      if (res = /^[\s\xa0*]+/.exec(input.substr(peg$currPos))) {
        peg$currPos += res[0].length;
        return [];
      }
      return peg$FAILED;
    }

    peg$result = peg$startRuleFunction();

    if (peg$result !== peg$FAILED && peg$currPos === input.length) {
      return peg$result;
    } else {
      if (peg$result !== peg$FAILED && peg$currPos < input.length) {
        peg$fail({ type: "end", description: "end of input" });
      }

      throw peg$buildException(
        null,
        peg$maxFailExpected,
        peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null,
        peg$maxFailPos < input.length
          ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
          : peg$computeLocation(peg$maxFailPos, peg$maxFailPos)
      );
    }
  }

  return {
    SyntaxError: peg$SyntaxError,
    parse:       peg$parse
  };
})();


}).call(this);
