/* @flow */
"use strict"

/* global require, module */
const OsisFormatter: () => OsisFormatterInterface = require("./osisFormatter")
const osisFormatter: OsisFormatterInterface = new OsisFormatter()

const books: BooksType = Object.freeze({
	"Gen": ["GEN"], "Exod": ["EXO"], "Lev": ["LEV"], "Num": ["NUM"], "Deut": ["DEU"], "Josh": ["JOS"], "Judg": ["JDG"], "Ruth": ["RUT"], "1Sam": ["1SA"], "2Sam": ["2SA"], "1Kgs": ["1KI"], "2Kgs": ["2KI"], "1Chr": ["1CH"], "2Chr": ["2CH"], "Ezra": ["EZR"], "Neh": ["NEH"], "Esth": ["EST"], "Job": ["JOB"], "Ps": ["PSA"], "Prov": ["PRO"], "Eccl": ["ECC"], "Song": ["SNG"], "Isa": ["ISA"], "Jer": ["JER"], "Lam": ["LAM"], "Ezek": ["EZK"], "Dan": ["DAN"], "Hos": ["HOS"], "Joel": ["JOL"], "Amos": ["AMO"], "Obad": ["OBA"], "Jonah": ["JON"], "Mic": ["MIC"], "Nah": ["NAM"], "Hab": ["HAB"], "Zeph": ["ZEP"], "Hag": ["HAG"], "Zech": ["ZEC"], "Mal": ["MAL"], "Matt": ["MAT"], "Mark": ["MRK"], "Luke": ["LUK"], "John": ["JHN"], "Acts": ["ACT"], "Rom": ["ROM"], "1Cor": ["1CO"], "2Cor": ["2CO"], "Gal": ["GAL"], "Eph": ["EPH"], "Phil": ["PHP"], "Col": ["COL"], "1Thess": ["1TH"], "2Thess": ["2TH"], "1Tim": ["1TI"], "2Tim": ["2TI"], "Titus": ["TIT"], "Phlm": ["PHM"], "Heb": ["HEB"], "Jas": ["JAS"], "1Pet": ["1PE"], "2Pet": ["2PE"], "1John": ["1JN"], "2John": ["2JN"], "3John": ["3JN"], "Jude": ["JUD"], "Rev": ["REV"], "Tob": ["TOB"], "Jdt": ["JDT"], "GkEsth": ["ESG"], "EsthGr": ["ESG"], "AddEsth": ["ADE"], "Wis": ["WIS"], "Sir": ["SIR"], "Bar": ["BAR"], "EpJer": ["LJE"], "DanGr": ["DAG"], "SgThree": ["S3Y"], "PrAzar": ["S3Y"], "Sus": ["SUS"], "Bel": ["BEL"], "1Macc": ["1MA"], "2Macc": ["2MA"], "3Macc": ["3MA"], "4Macc": ["4MA"], "PrMan": ["MAN"], "1Esd": ["1ES"], "2Esd": ["2ES"], "Ps151": ["PS2"], "AddPs": ["PS2"]
})
const options: Object = {
	"$chapters": ["$b"],
	"$verses": ["$b $c"],
	"singleChapterFormat": "bcv",
	// This isn't necessary, but it saves some lookups since we know we always want the full BCV.
	"singleChapterBooks": [],
	"Ps151Format": "b",
	"b-c": "-$b ",
	"bc-v": "-$c:",
	"cv-cv": "-",
	"v-c": "-$chapters ",
	".v": ":",
	",c": ",$b ",
	",v": ",$verses:"
}
osisFormatter.setBooks(books)
osisFormatter.setOptions(options)

// Convert an OSIS reference (`Gen.1.1`) to the equivalent Paratext reference (`GEN 1:1`).
function osisToParatext(osis: string) : string {
	if (typeof osis !== "string") {
		throw "osisToParatext: first argument must be a string."
	}
	return osisFormatter.format(osis)
}

module.exports = osisToParatext
