#!/usr/bin/luajit

local yaml = require("yaml")

yaml.configure({
   load_nulls_as_nil = true,
   load_numeric_scalars = false,
})

local PROJECT = os.getenv("PROJECT")
local SORTORDER = os.getenv("SORTORDER")
local TARGETS = os.getenv("TARGETS")
local BUILDDIR = os.getenv("BUILDDIR")

-- luacheck: ignore dump
local function dump (...)
   local arg = { ... } -- Avoid things that Lua stuffs in arg like args to self()
   require("pl.pretty").dump(#arg == 1 and arg[1] or arg, "/dev/stderr")
end

local booktitles = {}
local books = { ... } -- arg has 0 and -1 keys that aren't the passed arguments

local status, seriesmeta = pcall(yaml.loadpath, PROJECT .. ".yml")

local seriestitles = {}
local seriesorders = {}
if status and seriesmeta then
   for _, title in ipairs(seriesmeta.seriestitles) do
      table.insert(seriestitles, title.title)
      seriesorders[title.title] = title.order
   end
else
   for title in TARGETS:gmatch("%S+") do
      table.insert(seriestitles, title)
      seriesorders[title] = #seriesorders + 1
   end
end

local fetchtitle = function (bookid)
   if not booktitles[bookid] then
      booktitles[bookid] = yaml.loadpath(bookid .. ".yml").title
   end
   return booktitles[bookid]
end

local getorder = function (book)
   if SORTORDER == "alphabetical" then
      return book
   end
   local bookid = book:gsub("-.*", ""):gsub(BUILDDIR .. "/", "")
   for key, val in ipairs(seriestitles) do
      if SORTORDER == "manual" then
         if seriesorders[fetchtitle(bookid)] then
            return seriesorders[fetchtitle(bookid)]
         end
      elseif SORTORDER == "meta" then
         if val == fetchtitle(bookid) then
            return key
         end
      end
   end
   return 1 -- TODO: add option for sorting by publish date
end

local seriessort = function (a, b)
   return getorder(a) < getorder(b)
end

if SORTORDER ~= "none" then
   table.sort(books, seriessort)
end

print(table.concat(books, " "))
