// Generated by CoffeeScript 1.11.1
(function() {
  var bcv_parser, bcv_passage, bcv_utils, root,
    hasProp = {}.hasOwnProperty;

  root = this;

  bcv_parser = (function() {
    bcv_parser.prototype.s = "";

    bcv_parser.prototype.entities = [];

    bcv_parser.prototype.passage = null;

    bcv_parser.prototype.regexps = {};

    bcv_parser.prototype.options = {
      consecutive_combination_strategy: "combine",
      osis_compaction_strategy: "b",
      book_sequence_strategy: "ignore",
      invalid_sequence_strategy: "ignore",
      sequence_combination_strategy: "combine",
      punctuation_strategy: "us",
      invalid_passage_strategy: "ignore",
      non_latin_digits_strategy: "ignore",
      passage_existence_strategy: "bcv",
      zero_chapter_strategy: "error",
      zero_verse_strategy: "error",
      single_chapter_1_strategy: "chapter",
      book_alone_strategy: "ignore",
      book_range_strategy: "ignore",
      captive_end_digits_strategy: "delete",
      end_range_digits_strategy: "verse",
      include_apocrypha: false,
      ps151_strategy: "c",
      versification_system: "default",
      case_sensitive: "none"
    };

    function bcv_parser() {
      var key, ref, val;
      this.options = {};
      ref = bcv_parser.prototype.options;
      for (key in ref) {
        if (!hasProp.call(ref, key)) continue;
        val = ref[key];
        this.options[key] = val;
      }
      this.versification_system(this.options.versification_system);
    }

    bcv_parser.prototype.parse = function(s) {
      var ref;
      this.reset();
      this.s = s;
      s = this.replace_control_characters(s);
      ref = this.match_books(s), s = ref[0], this.passage.books = ref[1];
      this.entities = this.match_passages(s)[0];
      return this;
    };

    bcv_parser.prototype.parse_with_context = function(s, context) {
      var entities, ref, ref1, ref2;
      this.reset();
      ref = this.match_books(this.replace_control_characters(context)), context = ref[0], this.passage.books = ref[1];
      ref1 = this.match_passages(context), entities = ref1[0], context = ref1[1];
      this.reset();
      this.s = s;
      s = this.replace_control_characters(s);
      ref2 = this.match_books(s), s = ref2[0], this.passage.books = ref2[1];
      this.passage.books.push({
        value: "",
        parsed: [],
        start_index: 0,
        type: "context",
        context: context
      });
      s = "\x1f" + (this.passage.books.length - 1) + "/9\x1f" + s;
      this.entities = this.match_passages(s)[0];
      return this;
    };

    bcv_parser.prototype.reset = function() {
      this.s = "";
      this.entities = [];
      if (this.passage) {
        this.passage.books = [];
        return this.passage.indices = {};
      } else {
        this.passage = new bcv_passage;
        this.passage.options = this.options;
        return this.passage.translations = this.translations;
      }
    };

    bcv_parser.prototype.set_options = function(options) {
      var key, val;
      for (key in options) {
        if (!hasProp.call(options, key)) continue;
        val = options[key];
        if (key === "include_apocrypha" || key === "versification_system" || key === "case_sensitive") {
          this[key](val);
        } else {
          this.options[key] = val;
        }
      }
      return this;
    };

    bcv_parser.prototype.include_apocrypha = function(arg) {
      var base, base1, ref, translation, verse_count;
      if (!((arg != null) && (arg === true || arg === false))) {
        return this;
      }
      this.options.include_apocrypha = arg;
      this.regexps.books = this.regexps.get_books(arg, this.options.case_sensitive);
      ref = this.translations;
      for (translation in ref) {
        if (!hasProp.call(ref, translation)) continue;
        if (translation === "aliases" || translation === "alternates") {
          continue;
        }
        if ((base = this.translations[translation]).chapters == null) {
          base.chapters = {};
        }
        if ((base1 = this.translations[translation].chapters)["Ps"] == null) {
          base1["Ps"] = bcv_utils.shallow_clone_array(this.translations["default"].chapters["Ps"]);
        }
        if (arg === true) {
          if (this.translations[translation].chapters["Ps151"] != null) {
            verse_count = this.translations[translation].chapters["Ps151"][0];
          } else {
            verse_count = this.translations["default"].chapters["Ps151"][0];
          }
          this.translations[translation].chapters["Ps"][150] = verse_count;
        } else {
          if (this.translations[translation].chapters["Ps"].length === 151) {
            this.translations[translation].chapters["Ps"].pop();
          }
        }
      }
      return this;
    };

    bcv_parser.prototype.versification_system = function(system) {
      var base, base1, base2, book, chapter_list, ref, ref1;
      if (!((system != null) && (this.translations[system] != null))) {
        return this;
      }
      if (this.translations.alternates["default"] != null) {
        if (system === "default") {
          if (this.translations.alternates["default"].order != null) {
            this.translations["default"].order = bcv_utils.shallow_clone(this.translations.alternates["default"].order);
          }
          ref = this.translations.alternates["default"].chapters;
          for (book in ref) {
            if (!hasProp.call(ref, book)) continue;
            chapter_list = ref[book];
            this.translations["default"].chapters[book] = bcv_utils.shallow_clone_array(chapter_list);
          }
        } else {
          this.versification_system("default");
        }
      }
      if ((base = this.translations.alternates)["default"] == null) {
        base["default"] = {
          order: null,
          chapters: {}
        };
      }
      if (system !== "default" && (this.translations[system].order != null)) {
        if ((base1 = this.translations.alternates["default"]).order == null) {
          base1.order = bcv_utils.shallow_clone(this.translations["default"].order);
        }
        this.translations["default"].order = bcv_utils.shallow_clone(this.translations[system].order);
      }
      if (system !== "default" && (this.translations[system].chapters != null)) {
        ref1 = this.translations[system].chapters;
        for (book in ref1) {
          if (!hasProp.call(ref1, book)) continue;
          chapter_list = ref1[book];
          if ((base2 = this.translations.alternates["default"].chapters)[book] == null) {
            base2[book] = bcv_utils.shallow_clone_array(this.translations["default"].chapters[book]);
          }
          this.translations["default"].chapters[book] = bcv_utils.shallow_clone_array(chapter_list);
        }
      }
      this.options.versification_system = system;
      this.include_apocrypha(this.options.include_apocrypha);
      return this;
    };

    bcv_parser.prototype.case_sensitive = function(arg) {
      if (!((arg != null) && (arg === "none" || arg === "books"))) {
        return this;
      }
      if (arg === this.options.case_sensitive) {
        return this;
      }
      this.options.case_sensitive = arg;
      this.regexps.books = this.regexps.get_books(this.options.include_apocrypha, arg);
      return this;
    };

    bcv_parser.prototype.translation_info = function(new_translation) {
      var book, chapter_list, id, old_translation, out, ref, ref1, ref2;
      if (new_translation == null) {
        new_translation = "default";
      }
      if ((new_translation != null) && (((ref = this.translations.aliases[new_translation]) != null ? ref.alias : void 0) != null)) {
        new_translation = this.translations.aliases[new_translation].alias;
      }
      if (!((new_translation != null) && (this.translations[new_translation] != null))) {
        new_translation = "default";
      }
      old_translation = this.options.versification_system;
      if (new_translation !== old_translation) {
        this.versification_system(new_translation);
      }
      out = {
        alias: new_translation,
        books: [],
        chapters: {},
        order: bcv_utils.shallow_clone(this.translations["default"].order)
      };
      ref1 = this.translations["default"].chapters;
      for (book in ref1) {
        if (!hasProp.call(ref1, book)) continue;
        chapter_list = ref1[book];
        out.chapters[book] = bcv_utils.shallow_clone_array(chapter_list);
      }
      ref2 = out.order;
      for (book in ref2) {
        if (!hasProp.call(ref2, book)) continue;
        id = ref2[book];
        out.books[id - 1] = book;
      }
      if (new_translation !== old_translation) {
        this.versification_system(old_translation);
      }
      return out;
    };

    bcv_parser.prototype.replace_control_characters = function(s) {
      s = s.replace(this.regexps.control, " ");
      if (this.options.non_latin_digits_strategy === "replace") {
        s = s.replace(/[٠۰߀०০੦૦୦0౦೦൦๐໐༠၀႐០᠐᥆᧐᪀᪐᭐᮰᱀᱐꘠꣐꤀꧐꩐꯰０]/g, "0");
        s = s.replace(/[١۱߁१১੧૧୧௧౧೧൧๑໑༡၁႑១᠑᥇᧑᪁᪑᭑᮱᱁᱑꘡꣑꤁꧑꩑꯱１]/g, "1");
        s = s.replace(/[٢۲߂२২੨૨୨௨౨೨൨๒໒༢၂႒២᠒᥈᧒᪂᪒᭒᮲᱂᱒꘢꣒꤂꧒꩒꯲２]/g, "2");
        s = s.replace(/[٣۳߃३৩੩૩୩௩౩೩൩๓໓༣၃႓៣᠓᥉᧓᪃᪓᭓᮳᱃᱓꘣꣓꤃꧓꩓꯳３]/g, "3");
        s = s.replace(/[٤۴߄४৪੪૪୪௪౪೪൪๔໔༤၄႔៤᠔᥊᧔᪄᪔᭔᮴᱄᱔꘤꣔꤄꧔꩔꯴４]/g, "4");
        s = s.replace(/[٥۵߅५৫੫૫୫௫౫೫൫๕໕༥၅႕៥᠕᥋᧕᪅᪕᭕᮵᱅᱕꘥꣕꤅꧕꩕꯵５]/g, "5");
        s = s.replace(/[٦۶߆६৬੬૬୬௬౬೬൬๖໖༦၆႖៦᠖᥌᧖᪆᪖᭖᮶᱆᱖꘦꣖꤆꧖꩖꯶６]/g, "6");
        s = s.replace(/[٧۷߇७৭੭૭୭௭౭೭൭๗໗༧၇႗៧᠗᥍᧗᪇᪗᭗᮷᱇᱗꘧꣗꤇꧗꩗꯷７]/g, "7");
        s = s.replace(/[٨۸߈८৮੮૮୮௮౮೮൮๘໘༨၈႘៨᠘᥎᧘᪈᪘᭘᮸᱈᱘꘨꣘꤈꧘꩘꯸８]/g, "8");
        s = s.replace(/[٩۹߉९৯੯૯୯௯౯೯൯๙໙༩၉႙៩᠙᥏᧙᪉᪙᭙᮹᱉᱙꘩꣙꤉꧙꩙꯹９]/g, "9");
      }
      return s;
    };

    bcv_parser.prototype.match_books = function(s) {
      var book, books, has_replacement, k, len, ref;
      books = [];
      ref = this.regexps.books;
      for (k = 0, len = ref.length; k < len; k++) {
        book = ref[k];
        has_replacement = false;
        s = s.replace(book.regexp, function(full, prev, bk) {
          var extra;
          has_replacement = true;
          books.push({
            value: bk,
            parsed: book.osis,
            type: "book"
          });
          extra = book.extra != null ? "/" + book.extra : "";
          return prev + "\x1f" + (books.length - 1) + extra + "\x1f";
        });
        if (has_replacement === true && /^[\s\x1f\d:.,;\-\u2013\u2014]+$/.test(s)) {
          break;
        }
      }
      s = s.replace(this.regexps.translations, function(match) {
        books.push({
          value: match,
          parsed: match.toLowerCase(),
          type: "translation"
        });
        return "\x1e" + (books.length - 1) + "\x1e";
      });
      return [s, this.get_book_indices(books, s)];
    };

    bcv_parser.prototype.get_book_indices = function(books, s) {
      var add_index, match, re;
      add_index = 0;
      re = /([\x1f\x1e])(\d+)(?:\/\d+)?\1/g;
      while (match = re.exec(s)) {
        books[match[2]].start_index = match.index + add_index;
        add_index += books[match[2]].value.length - match[0].length;
      }
      return books;
    };

    bcv_parser.prototype.match_passages = function(s) {
      var accum, book_id, entities, full, match, next_char, original_part_length, part, passage, post_context, ref, regexp_index_adjust, start_index_adjust;
      entities = [];
      post_context = {};
      while (match = this.regexps.escaped_passage.exec(s)) {
        full = match[0], part = match[1], book_id = match[2];
        original_part_length = part.length;
        match.index += full.length - original_part_length;
        if (/\s[2-9]\d\d\s*$|\s\d{4,}\s*$/.test(part)) {
          part = part.replace(/\s+\d+\s*$/, "");
        }
        if (!/[\d\x1f\x1e)]$/.test(part)) {
          part = this.replace_match_end(part);
        }
        if (this.options.captive_end_digits_strategy === "delete") {
          next_char = match.index + part.length;
          if (s.length > next_char && /^\w/.test(s.substr(next_char, 1))) {
            part = part.replace(/[\s*]+\d+$/, "");
          }
          part = part.replace(/(\x1e[)\]]?)[\s*]*\d+$/, "$1");
        }
        part = part.replace(/[A-Z]+/g, function(capitals) {
          return capitals.toLowerCase();
        });
        start_index_adjust = part.substr(0, 1) === "\x1f" ? 0 : part.split("\x1f")[0].length;
        passage = {
          value: grammar.parse(part, {
            punctuation_strategy: this.options.punctuation_strategy
          }),
          type: "base",
          start_index: this.passage.books[book_id].start_index - start_index_adjust,
          match: part
        };
        if (this.options.book_alone_strategy === "full" && this.options.book_range_strategy === "include" && passage.value[0].type === "b" && (passage.value.length === 1 || (passage.value.length > 1 && passage.value[1].type === "translation_sequence")) && start_index_adjust === 0 && (this.passage.books[book_id].parsed.length === 1 || (this.passage.books[book_id].parsed.length > 1 && this.passage.books[book_id].parsed[1].type === "translation")) && /^[234]/.test(this.passage.books[book_id].parsed[0])) {
          this.create_book_range(s, passage, book_id);
        }
        ref = this.passage.handle_obj(passage), accum = ref[0], post_context = ref[1];
        entities = entities.concat(accum);
        regexp_index_adjust = this.adjust_regexp_end(accum, original_part_length, part.length);
        if (regexp_index_adjust > 0) {
          this.regexps.escaped_passage.lastIndex -= regexp_index_adjust;
        }
      }
      return [entities, post_context];
    };

    bcv_parser.prototype.adjust_regexp_end = function(accum, old_length, new_length) {
      var regexp_index_adjust;
      regexp_index_adjust = 0;
      if (accum.length > 0) {
        regexp_index_adjust = old_length - accum[accum.length - 1].indices[1] - 1;
      } else if (old_length !== new_length) {
        regexp_index_adjust = old_length - new_length;
      }
      return regexp_index_adjust;
    };

    bcv_parser.prototype.replace_match_end = function(part) {
      var match, remove;
      remove = part.length;
      while (match = this.regexps.match_end_split.exec(part)) {
        remove = match.index + match[0].length;
      }
      if (remove < part.length) {
        part = part.substr(0, remove);
      }
      return part;
    };

    bcv_parser.prototype.create_book_range = function(s, passage, book_id) {
      var cases, i, k, limit, prev, range_regexp, ref;
      cases = [bcv_parser.prototype.regexps.first, bcv_parser.prototype.regexps.second, bcv_parser.prototype.regexps.third];
      limit = parseInt(this.passage.books[book_id].parsed[0].substr(0, 1), 10);
      for (i = k = 1, ref = limit; 1 <= ref ? k < ref : k > ref; i = 1 <= ref ? ++k : --k) {
        range_regexp = i === limit - 1 ? bcv_parser.prototype.regexps.range_and : bcv_parser.prototype.regexps.range_only;
        prev = s.match(RegExp("(?:^|\\W)(" + cases[i - 1] + "\\s*" + range_regexp + "\\s*)\\x1f" + book_id + "\\x1f", "i"));
        if (prev != null) {
          return this.add_book_range_object(passage, prev, i);
        }
      }
      return false;
    };

    bcv_parser.prototype.add_book_range_object = function(passage, prev, start_book_number) {
      var i, k, length, ref, ref1, results;
      length = prev[1].length;
      passage.value[0] = {
        type: "b_range_pre",
        value: [
          {
            type: "b_pre",
            value: start_book_number.toString(),
            indices: [prev.index, prev.index + length]
          }, passage.value[0]
        ],
        indices: [0, passage.value[0].indices[1] + length]
      };
      passage.value[0].value[1].indices[0] += length;
      passage.value[0].value[1].indices[1] += length;
      passage.start_index -= length;
      passage.match = prev[1] + passage.match;
      if (passage.value.length === 1) {
        return;
      }
      results = [];
      for (i = k = 1, ref = passage.value.length; 1 <= ref ? k < ref : k > ref; i = 1 <= ref ? ++k : --k) {
        if (passage.value[i].value == null) {
          continue;
        }
        if (((ref1 = passage.value[i].value[0]) != null ? ref1.indices : void 0) != null) {
          passage.value[i].value[0].indices[0] += length;
          passage.value[i].value[0].indices[1] += length;
        }
        passage.value[i].indices[0] += length;
        results.push(passage.value[i].indices[1] += length);
      }
      return results;
    };

    bcv_parser.prototype.osis = function() {
      var k, len, osis, out, ref;
      out = [];
      ref = this.parsed_entities();
      for (k = 0, len = ref.length; k < len; k++) {
        osis = ref[k];
        if (osis.osis.length > 0) {
          out.push(osis.osis);
        }
      }
      return out.join(",");
    };

    bcv_parser.prototype.osis_and_translations = function() {
      var k, len, osis, out, ref;
      out = [];
      ref = this.parsed_entities();
      for (k = 0, len = ref.length; k < len; k++) {
        osis = ref[k];
        if (osis.osis.length > 0) {
          out.push([osis.osis, osis.translations.join(",")]);
        }
      }
      return out;
    };

    bcv_parser.prototype.osis_and_indices = function() {
      var k, len, osis, out, ref;
      out = [];
      ref = this.parsed_entities();
      for (k = 0, len = ref.length; k < len; k++) {
        osis = ref[k];
        if (osis.osis.length > 0) {
          out.push({
            osis: osis.osis,
            translations: osis.translations,
            indices: osis.indices
          });
        }
      }
      return out;
    };

    bcv_parser.prototype.parsed_entities = function() {
      var entity, entity_id, i, k, l, last_i, len, len1, length, m, n, osis, osises, out, passage, ref, ref1, ref2, ref3, strings, translation, translation_alias, translation_osis, translations;
      out = [];
      for (entity_id = k = 0, ref = this.entities.length; 0 <= ref ? k < ref : k > ref; entity_id = 0 <= ref ? ++k : --k) {
        entity = this.entities[entity_id];
        if (entity.type && entity.type === "translation_sequence" && out.length > 0 && entity_id === out[out.length - 1].entity_id + 1) {
          out[out.length - 1].indices[1] = entity.absolute_indices[1];
        }
        if (entity.passages == null) {
          continue;
        }
        if ((entity.type === "b" && this.options.book_alone_strategy === "ignore") || (entity.type === "b_range" && this.options.book_range_strategy === "ignore") || entity.type === "context") {
          continue;
        }
        translations = [];
        translation_alias = null;
        if (entity.passages[0].translations != null) {
          ref1 = entity.passages[0].translations;
          for (l = 0, len = ref1.length; l < len; l++) {
            translation = ref1[l];
            translation_osis = ((ref2 = translation.osis) != null ? ref2.length : void 0) > 0 ? translation.osis : "";
            if (translation_alias == null) {
              translation_alias = translation.alias;
            }
            translations.push(translation_osis);
          }
        } else {
          translations = [""];
          translation_alias = "default";
        }
        osises = [];
        length = entity.passages.length;
        for (i = m = 0, ref3 = length; 0 <= ref3 ? m < ref3 : m > ref3; i = 0 <= ref3 ? ++m : --m) {
          passage = entity.passages[i];
          if (passage.type == null) {
            passage.type = entity.type;
          }
          if (passage.valid.valid === false) {
            if (this.options.invalid_sequence_strategy === "ignore" && entity.type === "sequence") {
              this.snap_sequence("ignore", entity, osises, i, length);
            }
            if (this.options.invalid_passage_strategy === "ignore") {
              continue;
            }
          }
          if ((passage.type === "b" || passage.type === "b_range") && this.options.book_sequence_strategy === "ignore" && entity.type === "sequence") {
            this.snap_sequence("book", entity, osises, i, length);
            continue;
          }
          if ((passage.type === "b_range_start" || passage.type === "range_end_b") && this.options.book_range_strategy === "ignore") {
            this.snap_range(entity, i);
          }
          if (passage.absolute_indices == null) {
            passage.absolute_indices = entity.absolute_indices;
          }
          osises.push({
            osis: passage.valid.valid ? this.to_osis(passage.start, passage.end, translation_alias) : "",
            type: passage.type,
            indices: passage.absolute_indices,
            translations: translations,
            start: passage.start,
            end: passage.end,
            enclosed_indices: passage.enclosed_absolute_indices,
            entity_id: entity_id,
            entities: [passage]
          });
        }
        if (osises.length === 0) {
          continue;
        }
        if (osises.length > 1 && this.options.consecutive_combination_strategy === "combine") {
          osises = this.combine_consecutive_passages(osises, translation_alias);
        }
        if (this.options.sequence_combination_strategy === "separate") {
          out = out.concat(osises);
        } else {
          strings = [];
          last_i = osises.length - 1;
          if ((osises[last_i].enclosed_indices != null) && osises[last_i].enclosed_indices[1] >= 0) {
            entity.absolute_indices[1] = osises[last_i].enclosed_indices[1];
          }
          for (n = 0, len1 = osises.length; n < len1; n++) {
            osis = osises[n];
            if (osis.osis.length > 0) {
              strings.push(osis.osis);
            }
          }
          out.push({
            osis: strings.join(","),
            indices: entity.absolute_indices,
            translations: translations,
            entity_id: entity_id,
            entities: osises
          });
        }
      }
      return out;
    };

    bcv_parser.prototype.to_osis = function(start, end, translation) {
      var osis, out;
      if ((end.c == null) && (end.v == null) && start.b === end.b && (start.c == null) && (start.v == null) && this.options.book_alone_strategy === "first_chapter") {
        end.c = 1;
      }
      osis = {
        start: "",
        end: ""
      };
      if (start.c == null) {
        start.c = 1;
      }
      if (start.v == null) {
        start.v = 1;
      }
      if (end.c == null) {
        if (this.options.passage_existence_strategy.indexOf("c") >= 0 || ((this.passage.translations[translation].chapters[end.b] != null) && this.passage.translations[translation].chapters[end.b].length === 1)) {
          end.c = this.passage.translations[translation].chapters[end.b].length;
        } else {
          end.c = 999;
        }
      }
      if (end.v == null) {
        if ((this.passage.translations[translation].chapters[end.b][end.c - 1] != null) && this.options.passage_existence_strategy.indexOf("v") >= 0) {
          end.v = this.passage.translations[translation].chapters[end.b][end.c - 1];
        } else {
          end.v = 999;
        }
      }
      if (this.options.include_apocrypha && this.options.ps151_strategy === "b" && ((start.c === 151 && start.b === "Ps") || (end.c === 151 && end.b === "Ps"))) {
        this.fix_ps151(start, end, translation);
      }
      if (this.options.osis_compaction_strategy === "b" && start.c === 1 && start.v === 1 && ((end.c === 999 && end.v === 999) || (end.c === this.passage.translations[translation].chapters[end.b].length && this.options.passage_existence_strategy.indexOf("c") >= 0 && (end.v === 999 || (end.v === this.passage.translations[translation].chapters[end.b][end.c - 1] && this.options.passage_existence_strategy.indexOf("v") >= 0))))) {
        osis.start = start.b;
        osis.end = end.b;
      } else if (this.options.osis_compaction_strategy.length <= 2 && start.v === 1 && (end.v === 999 || (end.v === this.passage.translations[translation].chapters[end.b][end.c - 1] && this.options.passage_existence_strategy.indexOf("v") >= 0))) {
        osis.start = start.b + "." + start.c.toString();
        osis.end = end.b + "." + end.c.toString();
      } else {
        osis.start = start.b + "." + start.c.toString() + "." + start.v.toString();
        osis.end = end.b + "." + end.c.toString() + "." + end.v.toString();
      }
      if (osis.start === osis.end) {
        out = osis.start;
      } else {
        out = osis.start + "-" + osis.end;
      }
      if (start.extra != null) {
        out = start.extra + "," + out;
      }
      if (end.extra != null) {
        out += "," + end.extra;
      }
      return out;
    };

    bcv_parser.prototype.fix_ps151 = function(start, end, translation) {
      var ref;
      if (translation !== "default" && (((ref = this.translations[translation]) != null ? ref.chapters["Ps151"] : void 0) == null)) {
        this.passage.promote_book_to_translation("Ps151", translation);
      }
      if (start.c === 151 && start.b === "Ps") {
        if (end.c === 151 && end.b === "Ps") {
          start.b = "Ps151";
          start.c = 1;
          end.b = "Ps151";
          return end.c = 1;
        } else {
          start.extra = this.to_osis({
            b: "Ps151",
            c: 1,
            v: start.v
          }, {
            b: "Ps151",
            c: 1,
            v: this.passage.translations[translation].chapters["Ps151"][0]
          }, translation);
          start.b = "Prov";
          start.c = 1;
          return start.v = 1;
        }
      } else {
        end.extra = this.to_osis({
          b: "Ps151",
          c: 1,
          v: 1
        }, {
          b: "Ps151",
          c: 1,
          v: end.v
        }, translation);
        end.c = 150;
        return end.v = this.passage.translations[translation].chapters["Ps"][149];
      }
    };

    bcv_parser.prototype.combine_consecutive_passages = function(osises, translation) {
      var enclosed_sequence_start, has_enclosed, i, is_enclosed_last, k, last_i, osis, out, prev, prev_i, ref;
      out = [];
      prev = {};
      last_i = osises.length - 1;
      enclosed_sequence_start = -1;
      has_enclosed = false;
      for (i = k = 0, ref = last_i; 0 <= ref ? k <= ref : k >= ref; i = 0 <= ref ? ++k : --k) {
        osis = osises[i];
        if (osis.osis.length > 0) {
          prev_i = out.length - 1;
          is_enclosed_last = false;
          if (osis.enclosed_indices[0] !== enclosed_sequence_start) {
            enclosed_sequence_start = osis.enclosed_indices[0];
          }
          if (enclosed_sequence_start >= 0 && (i === last_i || osises[i + 1].enclosed_indices[0] !== osis.enclosed_indices[0])) {
            is_enclosed_last = true;
            has_enclosed = true;
          }
          if (this.is_verse_consecutive(prev, osis.start, translation)) {
            out[prev_i].end = osis.end;
            out[prev_i].is_enclosed_last = is_enclosed_last;
            out[prev_i].indices[1] = osis.indices[1];
            out[prev_i].enclosed_indices[1] = osis.enclosed_indices[1];
            out[prev_i].osis = this.to_osis(out[prev_i].start, osis.end, translation);
          } else {
            out.push(osis);
          }
          prev = {
            b: osis.end.b,
            c: osis.end.c,
            v: osis.end.v
          };
        } else {
          out.push(osis);
          prev = {};
        }
      }
      if (has_enclosed) {
        this.snap_enclosed_indices(out);
      }
      return out;
    };

    bcv_parser.prototype.snap_enclosed_indices = function(osises) {
      var k, len, osis;
      for (k = 0, len = osises.length; k < len; k++) {
        osis = osises[k];
        if (osis.is_enclosed_last != null) {
          if (osis.enclosed_indices[0] < 0 && osis.is_enclosed_last) {
            osis.indices[1] = osis.enclosed_indices[1];
          }
          delete osis.is_enclosed_last;
        }
      }
      return osises;
    };

    bcv_parser.prototype.is_verse_consecutive = function(prev, check, translation) {
      var translation_order;
      if (prev.b == null) {
        return false;
      }
      translation_order = this.passage.translations[translation].order != null ? this.passage.translations[translation].order : this.passage.translations["default"].order;
      if (prev.b === check.b) {
        if (prev.c === check.c) {
          if (prev.v === check.v - 1) {
            return true;
          }
        } else if (check.v === 1 && prev.c === check.c - 1) {
          if (prev.v === this.passage.translations[translation].chapters[prev.b][prev.c - 1]) {
            return true;
          }
        }
      } else if (check.c === 1 && check.v === 1 && translation_order[prev.b] === translation_order[check.b] - 1) {
        if (prev.c === this.passage.translations[translation].chapters[prev.b].length && prev.v === this.passage.translations[translation].chapters[prev.b][prev.c - 1]) {
          return true;
        }
      }
      return false;
    };

    bcv_parser.prototype.snap_range = function(entity, passage_i) {
      var entity_i, key, pluck, ref, source_entity, target_entity, temp, type;
      if (entity.type === "b_range_start" || (entity.type === "sequence" && entity.passages[passage_i].type === "b_range_start")) {
        entity_i = 1;
        source_entity = "end";
        type = "b_range_start";
      } else {
        entity_i = 0;
        source_entity = "start";
        type = "range_end_b";
      }
      target_entity = source_entity === "end" ? "start" : "end";
      ref = entity.passages[passage_i][target_entity];
      for (key in ref) {
        if (!hasProp.call(ref, key)) continue;
        entity.passages[passage_i][target_entity][key] = entity.passages[passage_i][source_entity][key];
      }
      if (entity.type === "sequence") {
        if (passage_i >= entity.value.length) {
          passage_i = entity.value.length - 1;
        }
        pluck = this.passage.pluck(type, entity.value[passage_i]);
        if (pluck != null) {
          temp = this.snap_range(pluck, 0);
          if (passage_i === 0) {
            entity.absolute_indices[0] = temp.absolute_indices[0];
          } else {
            entity.absolute_indices[1] = temp.absolute_indices[1];
          }
        }
      } else {
        entity.original_type = entity.type;
        entity.type = entity.value[entity_i].type;
        entity.absolute_indices = [entity.value[entity_i].absolute_indices[0], entity.value[entity_i].absolute_indices[1]];
      }
      return entity;
    };

    bcv_parser.prototype.snap_sequence = function(type, entity, osises, i, length) {
      var passage;
      passage = entity.passages[i];
      if (passage.absolute_indices[0] === entity.absolute_indices[0] && i < length - 1 && this.get_snap_sequence_i(entity.passages, i, length) !== i) {
        entity.absolute_indices[0] = entity.passages[i + 1].absolute_indices[0];
        this.remove_absolute_indices(entity.passages, i + 1);
      } else if (passage.absolute_indices[1] === entity.absolute_indices[1] && i > 0) {
        entity.absolute_indices[1] = osises.length > 0 ? osises[osises.length - 1].indices[1] : entity.passages[i - 1].absolute_indices[1];
      } else if (type === "book" && i < length - 1 && !this.starts_with_book(entity.passages[i + 1])) {
        entity.passages[i + 1].absolute_indices[0] = passage.absolute_indices[0];
      }
      return entity;
    };

    bcv_parser.prototype.get_snap_sequence_i = function(passages, i, length) {
      var j, k, ref, ref1;
      for (j = k = ref = i + 1, ref1 = length; ref <= ref1 ? k < ref1 : k > ref1; j = ref <= ref1 ? ++k : --k) {
        if (this.starts_with_book(passages[j])) {
          return j;
        }
        if (passages[j].valid.valid) {
          return i;
        }
      }
      return i;
    };

    bcv_parser.prototype.starts_with_book = function(passage) {
      if (passage.type.substr(0, 1) === "b") {
        return true;
      }
      if ((passage.type === "range" || passage.type === "ff") && passage.start.type.substr(0, 1) === "b") {
        return true;
      }
      return false;
    };

    bcv_parser.prototype.remove_absolute_indices = function(passages, i) {
      var end, k, len, passage, ref, ref1, start;
      if (passages[i].enclosed_absolute_indices[0] < 0) {
        return false;
      }
      ref = passages[i].enclosed_absolute_indices, start = ref[0], end = ref[1];
      ref1 = passages.slice(i);
      for (k = 0, len = ref1.length; k < len; k++) {
        passage = ref1[k];
        if (passage.enclosed_absolute_indices[0] === start && passage.enclosed_absolute_indices[1] === end) {
          passage.enclosed_absolute_indices = [-1, -1];
        } else {
          break;
        }
      }
      return true;
    };

    return bcv_parser;

  })();

  root.bcv_parser = bcv_parser;

  bcv_passage = (function() {
    function bcv_passage() {}

    bcv_passage.prototype.books = [];

    bcv_passage.prototype.indices = {};

    bcv_passage.prototype.options = {};

    bcv_passage.prototype.translations = {};

    bcv_passage.prototype.handle_array = function(passages, accum, context) {
      var k, len, passage, ref;
      if (accum == null) {
        accum = [];
      }
      if (context == null) {
        context = {};
      }
      for (k = 0, len = passages.length; k < len; k++) {
        passage = passages[k];
        if (passage == null) {
          continue;
        }
        if (passage.type === "stop") {
          break;
        }
        ref = this.handle_obj(passage, accum, context), accum = ref[0], context = ref[1];
      }
      return [accum, context];
    };

    bcv_passage.prototype.handle_obj = function(passage, accum, context) {
      if ((passage.type != null) && (this[passage.type] != null)) {
        return this[passage.type](passage, accum, context);
      } else {
        return [accum, context];
      }
    };

    bcv_passage.prototype.b = function(passage, accum, context) {
      var alternates, b, k, len, obj, ref, valid;
      passage.start_context = bcv_utils.shallow_clone(context);
      passage.passages = [];
      alternates = [];
      ref = this.books[passage.value].parsed;
      for (k = 0, len = ref.length; k < len; k++) {
        b = ref[k];
        valid = this.validate_ref(passage.start_context.translations, {
          b: b
        });
        obj = {
          start: {
            b: b
          },
          end: {
            b: b
          },
          valid: valid
        };
        if (passage.passages.length === 0 && valid.valid) {
          passage.passages.push(obj);
        } else {
          alternates.push(obj);
        }
      }
      if (passage.passages.length === 0) {
        passage.passages.push(alternates.shift());
      }
      if (alternates.length > 0) {
        passage.passages[0].alternates = alternates;
      }
      if (passage.start_context.translations != null) {
        passage.passages[0].translations = passage.start_context.translations;
      }
      if (passage.absolute_indices == null) {
        passage.absolute_indices = this.get_absolute_indices(passage.indices);
      }
      accum.push(passage);
      context = {
        b: passage.passages[0].start.b
      };
      if (passage.start_context.translations != null) {
        context.translations = passage.start_context.translations;
      }
      return [accum, context];
    };

    bcv_passage.prototype.b_range = function(passage, accum, context) {
      return this.range(passage, accum, context);
    };

    bcv_passage.prototype.b_range_pre = function(passage, accum, context) {
      var alternates, book, end, ref, ref1, start_obj;
      passage.start_context = bcv_utils.shallow_clone(context);
      passage.passages = [];
      alternates = [];
      book = this.pluck("b", passage.value);
      ref = this.b(book, [], context), (ref1 = ref[0], end = ref1[0]), context = ref[1];
      if (passage.absolute_indices == null) {
        passage.absolute_indices = this.get_absolute_indices(passage.indices);
      }
      start_obj = {
        b: passage.value[0].value + end.passages[0].start.b.substr(1),
        type: "b"
      };
      passage.passages = [
        {
          start: start_obj,
          end: end.passages[0].end,
          valid: end.passages[0].valid
        }
      ];
      if (passage.start_context.translations != null) {
        passage.passages[0].translations = passage.start_context.translations;
      }
      accum.push(passage);
      return [accum, context];
    };

    bcv_passage.prototype.b_range_start = function(passage, accum, context) {
      return this.range(passage, accum, context);
    };

    bcv_passage.prototype.base = function(passage, accum, context) {
      this.indices = this.calculate_indices(passage.match, passage.start_index);
      return this.handle_array(passage.value, accum, context);
    };

    bcv_passage.prototype.bc = function(passage, accum, context) {
      var alternates, b, c, context_key, k, len, obj, ref, ref1, valid;
      passage.start_context = bcv_utils.shallow_clone(context);
      passage.passages = [];
      this.reset_context(context, ["b", "c", "v"]);
      c = this.pluck("c", passage.value).value;
      alternates = [];
      ref = this.books[this.pluck("b", passage.value).value].parsed;
      for (k = 0, len = ref.length; k < len; k++) {
        b = ref[k];
        context_key = "c";
        valid = this.validate_ref(passage.start_context.translations, {
          b: b,
          c: c
        });
        obj = {
          start: {
            b: b
          },
          end: {
            b: b
          },
          valid: valid
        };
        if (valid.messages.start_chapter_not_exist_in_single_chapter_book || valid.messages.start_chapter_1) {
          obj.valid = this.validate_ref(passage.start_context.translations, {
            b: b,
            v: c
          });
          if (valid.messages.start_chapter_not_exist_in_single_chapter_book) {
            obj.valid.messages.start_chapter_not_exist_in_single_chapter_book = 1;
          }
          obj.start.c = 1;
          obj.end.c = 1;
          context_key = "v";
        }
        obj.start[context_key] = c;
        ref1 = this.fix_start_zeroes(obj.valid, obj.start.c, obj.start.v), obj.start.c = ref1[0], obj.start.v = ref1[1];
        if (obj.start.v == null) {
          delete obj.start.v;
        }
        obj.end[context_key] = obj.start[context_key];
        if (passage.passages.length === 0 && obj.valid.valid) {
          passage.passages.push(obj);
        } else {
          alternates.push(obj);
        }
      }
      if (passage.passages.length === 0) {
        passage.passages.push(alternates.shift());
      }
      if (alternates.length > 0) {
        passage.passages[0].alternates = alternates;
      }
      if (passage.start_context.translations != null) {
        passage.passages[0].translations = passage.start_context.translations;
      }
      if (passage.absolute_indices == null) {
        passage.absolute_indices = this.get_absolute_indices(passage.indices);
      }
      this.set_context_from_object(context, ["b", "c", "v"], passage.passages[0].start);
      accum.push(passage);
      return [accum, context];
    };

    bcv_passage.prototype.bc_title = function(passage, accum, context) {
      var bc, i, k, ref, ref1, ref2, title;
      passage.start_context = bcv_utils.shallow_clone(context);
      ref = this.bc(this.pluck("bc", passage.value), [], context), (ref1 = ref[0], bc = ref1[0]), context = ref[1];
      if (bc.passages[0].start.b.substr(0, 2) !== "Ps" && (bc.passages[0].alternates != null)) {
        for (i = k = 0, ref2 = bc.passages[0].alternates.length; 0 <= ref2 ? k < ref2 : k > ref2; i = 0 <= ref2 ? ++k : --k) {
          if (bc.passages[0].alternates[i].start.b.substr(0, 2) !== "Ps") {
            continue;
          }
          bc.passages[0] = bc.passages[0].alternates[i];
          break;
        }
      }
      if (bc.passages[0].start.b.substr(0, 2) !== "Ps") {
        accum.push(bc);
        return [accum, context];
      }
      this.books[this.pluck("b", bc.value).value].parsed = ["Ps"];
      title = this.pluck("title", passage.value);
      if (title == null) {
        title = this.pluck("v", passage.value);
      }
      passage.value[1] = {
        type: "v",
        value: [
          {
            type: "integer",
            value: 1,
            indices: title.indices
          }
        ],
        indices: title.indices
      };
      passage.type = "bcv";
      return this.bcv(passage, accum, passage.start_context);
    };

    bcv_passage.prototype.bcv = function(passage, accum, context) {
      var alternates, b, bc, c, k, len, obj, ref, ref1, v, valid;
      passage.start_context = bcv_utils.shallow_clone(context);
      passage.passages = [];
      this.reset_context(context, ["b", "c", "v"]);
      bc = this.pluck("bc", passage.value);
      c = this.pluck("c", bc.value).value;
      v = this.pluck("v", passage.value).value;
      alternates = [];
      ref = this.books[this.pluck("b", bc.value).value].parsed;
      for (k = 0, len = ref.length; k < len; k++) {
        b = ref[k];
        valid = this.validate_ref(passage.start_context.translations, {
          b: b,
          c: c,
          v: v
        });
        ref1 = this.fix_start_zeroes(valid, c, v), c = ref1[0], v = ref1[1];
        obj = {
          start: {
            b: b,
            c: c,
            v: v
          },
          end: {
            b: b,
            c: c,
            v: v
          },
          valid: valid
        };
        if (passage.passages.length === 0 && valid.valid) {
          passage.passages.push(obj);
        } else {
          alternates.push(obj);
        }
      }
      if (passage.passages.length === 0) {
        passage.passages.push(alternates.shift());
      }
      if (alternates.length > 0) {
        passage.passages[0].alternates = alternates;
      }
      if (passage.start_context.translations != null) {
        passage.passages[0].translations = passage.start_context.translations;
      }
      if (passage.absolute_indices == null) {
        passage.absolute_indices = this.get_absolute_indices(passage.indices);
      }
      this.set_context_from_object(context, ["b", "c", "v"], passage.passages[0].start);
      accum.push(passage);
      return [accum, context];
    };

    bcv_passage.prototype.bv = function(passage, accum, context) {
      var b, bcv, ref, ref1, ref2, v;
      passage.start_context = bcv_utils.shallow_clone(context);
      ref = passage.value, b = ref[0], v = ref[1];
      bcv = {
        indices: passage.indices,
        value: [
          {
            type: "bc",
            value: [
              b, {
                type: "c",
                value: [
                  {
                    type: "integer",
                    value: 1
                  }
                ]
              }
            ]
          }, v
        ]
      };
      ref1 = this.bcv(bcv, [], context), (ref2 = ref1[0], bcv = ref2[0]), context = ref1[1];
      passage.passages = bcv.passages;
      if (passage.absolute_indices == null) {
        passage.absolute_indices = this.get_absolute_indices(passage.indices);
      }
      accum.push(passage);
      return [accum, context];
    };

    bcv_passage.prototype.c = function(passage, accum, context) {
      var c, valid;
      passage.start_context = bcv_utils.shallow_clone(context);
      c = passage.type === "integer" ? passage.value : this.pluck("integer", passage.value).value;
      valid = this.validate_ref(passage.start_context.translations, {
        b: context.b,
        c: c
      });
      if (!valid.valid && valid.messages.start_chapter_not_exist_in_single_chapter_book) {
        return this.v(passage, accum, context);
      }
      c = this.fix_start_zeroes(valid, c)[0];
      passage.passages = [
        {
          start: {
            b: context.b,
            c: c
          },
          end: {
            b: context.b,
            c: c
          },
          valid: valid
        }
      ];
      if (passage.start_context.translations != null) {
        passage.passages[0].translations = passage.start_context.translations;
      }
      accum.push(passage);
      context.c = c;
      this.reset_context(context, ["v"]);
      if (passage.absolute_indices == null) {
        passage.absolute_indices = this.get_absolute_indices(passage.indices);
      }
      return [accum, context];
    };

    bcv_passage.prototype.c_psalm = function(passage, accum, context) {
      var c;
      passage.type = "bc";
      c = parseInt(this.books[passage.value].value.match(/^\d+/)[0], 10);
      passage.value = [
        {
          type: "b",
          value: passage.value,
          indices: passage.indices
        }, {
          type: "c",
          value: [
            {
              type: "integer",
              value: c,
              indices: passage.indices
            }
          ],
          indices: passage.indices
        }
      ];
      return this.bc(passage, accum, context);
    };

    bcv_passage.prototype.c_title = function(passage, accum, context) {
      var title;
      passage.start_context = bcv_utils.shallow_clone(context);
      if (context.b !== "Ps") {
        return this.c(passage.value[0], accum, context);
      }
      title = this.pluck("title", passage.value);
      passage.value[1] = {
        type: "v",
        value: [
          {
            type: "integer",
            value: 1,
            indices: title.indices
          }
        ],
        indices: title.indices
      };
      passage.type = "cv";
      return this.cv(passage, accum, passage.start_context);
    };

    bcv_passage.prototype.cv = function(passage, accum, context) {
      var c, ref, v, valid;
      passage.start_context = bcv_utils.shallow_clone(context);
      c = this.pluck("c", passage.value).value;
      v = this.pluck("v", passage.value).value;
      valid = this.validate_ref(passage.start_context.translations, {
        b: context.b,
        c: c,
        v: v
      });
      ref = this.fix_start_zeroes(valid, c, v), c = ref[0], v = ref[1];
      passage.passages = [
        {
          start: {
            b: context.b,
            c: c,
            v: v
          },
          end: {
            b: context.b,
            c: c,
            v: v
          },
          valid: valid
        }
      ];
      if (passage.start_context.translations != null) {
        passage.passages[0].translations = passage.start_context.translations;
      }
      accum.push(passage);
      context.c = c;
      context.v = v;
      if (passage.absolute_indices == null) {
        passage.absolute_indices = this.get_absolute_indices(passage.indices);
      }
      return [accum, context];
    };

    bcv_passage.prototype.cb_range = function(passage, accum, context) {
      var b, end_c, ref, start_c;
      passage.type = "range";
      ref = passage.value, b = ref[0], start_c = ref[1], end_c = ref[2];
      passage.value = [
        {
          type: "bc",
          value: [b, start_c],
          indices: passage.indices
        }, end_c
      ];
      end_c.indices[1] = passage.indices[1];
      return this.range(passage, accum, context);
    };

    bcv_passage.prototype.context = function(passage, accum, context) {
      var key, ref;
      passage.start_context = bcv_utils.shallow_clone(context);
      passage.passages = [];
      ref = this.books[passage.value].context;
      for (key in ref) {
        if (!hasProp.call(ref, key)) continue;
        context[key] = this.books[passage.value].context[key];
      }
      accum.push(passage);
      return [accum, context];
    };

    bcv_passage.prototype.cv_psalm = function(passage, accum, context) {
      var bc, c_psalm, ref, v;
      passage.start_context = bcv_utils.shallow_clone(context);
      passage.type = "bcv";
      ref = passage.value, c_psalm = ref[0], v = ref[1];
      bc = this.c_psalm(c_psalm, [], passage.start_context)[0][0];
      passage.value = [bc, v];
      return this.bcv(passage, accum, context);
    };

    bcv_passage.prototype.ff = function(passage, accum, context) {
      var ref, ref1;
      passage.start_context = bcv_utils.shallow_clone(context);
      passage.value.push({
        type: "integer",
        indices: passage.indices,
        value: 999
      });
      ref = this.range(passage, [], passage.start_context), (ref1 = ref[0], passage = ref1[0]), context = ref[1];
      passage.value[0].indices = passage.value[1].indices;
      passage.value[0].absolute_indices = passage.value[1].absolute_indices;
      passage.value.pop();
      if (passage.passages[0].valid.messages.end_verse_not_exist != null) {
        delete passage.passages[0].valid.messages.end_verse_not_exist;
      }
      if (passage.passages[0].valid.messages.end_chapter_not_exist != null) {
        delete passage.passages[0].valid.messages.end_chapter_not_exist;
      }
      if (passage.passages[0].end.original_c != null) {
        delete passage.passages[0].end.original_c;
      }
      accum.push(passage);
      return [accum, context];
    };

    bcv_passage.prototype.integer_title = function(passage, accum, context) {
      var v_indices;
      passage.start_context = bcv_utils.shallow_clone(context);
      if (context.b !== "Ps") {
        return this.integer(passage.value[0], accum, context);
      }
      passage.value[0] = {
        type: "c",
        value: [passage.value[0]],
        indices: [passage.value[0].indices[0], passage.value[0].indices[1]]
      };
      v_indices = [passage.indices[1] - 5, passage.indices[1]];
      passage.value[1] = {
        type: "v",
        value: [
          {
            type: "integer",
            value: 1,
            indices: v_indices
          }
        ],
        indices: v_indices
      };
      passage.type = "cv";
      return this.cv(passage, accum, passage.start_context);
    };

    bcv_passage.prototype.integer = function(passage, accum, context) {
      if (context.v != null) {
        return this.v(passage, accum, context);
      }
      return this.c(passage, accum, context);
    };

    bcv_passage.prototype.next_v = function(passage, accum, context) {
      var prev_integer, psg, ref, ref1, ref2, ref3;
      passage.start_context = bcv_utils.shallow_clone(context);
      prev_integer = this.pluck_last_recursively("integer", passage.value);
      if (prev_integer == null) {
        prev_integer = {
          value: 1
        };
      }
      passage.value.push({
        type: "integer",
        indices: passage.indices,
        value: prev_integer.value + 1
      });
      ref = this.range(passage, [], passage.start_context), (ref1 = ref[0], psg = ref1[0]), context = ref[1];
      if ((psg.passages[0].valid.messages.end_verse_not_exist != null) && (psg.passages[0].valid.messages.start_verse_not_exist == null) && (psg.passages[0].valid.messages.start_chapter_not_exist == null) && (context.c != null)) {
        passage.value.pop();
        passage.value.push({
          type: "cv",
          indices: passage.indices,
          value: [
            {
              type: "c",
              value: [
                {
                  type: "integer",
                  value: context.c + 1,
                  indices: passage.indices
                }
              ],
              indices: passage.indices
            }, {
              type: "v",
              value: [
                {
                  type: "integer",
                  value: 1,
                  indices: passage.indices
                }
              ],
              indices: passage.indices
            }
          ]
        });
        ref2 = this.range(passage, [], passage.start_context), (ref3 = ref2[0], psg = ref3[0]), context = ref2[1];
      }
      psg.value[0].indices = psg.value[1].indices;
      psg.value[0].absolute_indices = psg.value[1].absolute_indices;
      psg.value.pop();
      if (psg.passages[0].valid.messages.end_verse_not_exist != null) {
        delete psg.passages[0].valid.messages.end_verse_not_exist;
      }
      if (psg.passages[0].valid.messages.end_chapter_not_exist != null) {
        delete psg.passages[0].valid.messages.end_chapter_not_exist;
      }
      if (psg.passages[0].end.original_c != null) {
        delete psg.passages[0].end.original_c;
      }
      accum.push(psg);
      return [accum, context];
    };

    bcv_passage.prototype.sequence = function(passage, accum, context) {
      var k, l, len, len1, obj, psg, ref, ref1, ref2, ref3, sub_psg;
      passage.start_context = bcv_utils.shallow_clone(context);
      passage.passages = [];
      ref = passage.value;
      for (k = 0, len = ref.length; k < len; k++) {
        obj = ref[k];
        ref1 = this.handle_array(obj, [], context), (ref2 = ref1[0], psg = ref2[0]), context = ref1[1];
        ref3 = psg.passages;
        for (l = 0, len1 = ref3.length; l < len1; l++) {
          sub_psg = ref3[l];
          if (sub_psg.type == null) {
            sub_psg.type = psg.type;
          }
          if (sub_psg.absolute_indices == null) {
            sub_psg.absolute_indices = psg.absolute_indices;
          }
          if (psg.start_context.translations != null) {
            sub_psg.translations = psg.start_context.translations;
          }
          sub_psg.enclosed_absolute_indices = psg.type === "sequence_post_enclosed" ? psg.absolute_indices : [-1, -1];
          passage.passages.push(sub_psg);
        }
      }
      if (passage.absolute_indices == null) {
        if (passage.passages.length > 0 && passage.type === "sequence") {
          passage.absolute_indices = [passage.passages[0].absolute_indices[0], passage.passages[passage.passages.length - 1].absolute_indices[1]];
        } else {
          passage.absolute_indices = this.get_absolute_indices(passage.indices);
        }
      }
      accum.push(passage);
      return [accum, context];
    };

    bcv_passage.prototype.sequence_post_enclosed = function(passage, accum, context) {
      return this.sequence(passage, accum, context);
    };

    bcv_passage.prototype.v = function(passage, accum, context) {
      var c, no_c, ref, v, valid;
      v = passage.type === "integer" ? passage.value : this.pluck("integer", passage.value).value;
      passage.start_context = bcv_utils.shallow_clone(context);
      c = context.c != null ? context.c : 1;
      valid = this.validate_ref(passage.start_context.translations, {
        b: context.b,
        c: c,
        v: v
      });
      ref = this.fix_start_zeroes(valid, 0, v), no_c = ref[0], v = ref[1];
      passage.passages = [
        {
          start: {
            b: context.b,
            c: c,
            v: v
          },
          end: {
            b: context.b,
            c: c,
            v: v
          },
          valid: valid
        }
      ];
      if (passage.start_context.translations != null) {
        passage.passages[0].translations = passage.start_context.translations;
      }
      if (passage.absolute_indices == null) {
        passage.absolute_indices = this.get_absolute_indices(passage.indices);
      }
      accum.push(passage);
      context.v = v;
      return [accum, context];
    };

    bcv_passage.prototype.range = function(passage, accum, context) {
      var end, end_obj, ref, ref1, ref2, ref3, ref4, ref5, ref6, ref7, ref8, ref9, return_now, return_value, start, start_obj, valid;
      passage.start_context = bcv_utils.shallow_clone(context);
      ref = passage.value, start = ref[0], end = ref[1];
      ref1 = this.handle_obj(start, [], context), (ref2 = ref1[0], start = ref2[0]), context = ref1[1];
      if (end.type === "v" && ((start.type === "bc" && !((ref3 = start.passages) != null ? (ref4 = ref3[0]) != null ? (ref5 = ref4.valid) != null ? (ref6 = ref5.messages) != null ? ref6.start_chapter_not_exist_in_single_chapter_book : void 0 : void 0 : void 0 : void 0)) || start.type === "c") && this.options.end_range_digits_strategy === "verse") {
        passage.value[0] = start;
        return this.range_change_integer_end(passage, accum);
      }
      ref7 = this.handle_obj(end, [], context), (ref8 = ref7[0], end = ref8[0]), context = ref7[1];
      passage.value = [start, end];
      passage.indices = [start.indices[0], end.indices[1]];
      delete passage.absolute_indices;
      start_obj = {
        b: start.passages[0].start.b,
        c: start.passages[0].start.c,
        v: start.passages[0].start.v,
        type: start.type
      };
      end_obj = {
        b: end.passages[0].end.b,
        c: end.passages[0].end.c,
        v: end.passages[0].end.v,
        type: end.type
      };
      if (end.passages[0].valid.messages.start_chapter_is_zero) {
        end_obj.c = 0;
      }
      if (end.passages[0].valid.messages.start_verse_is_zero) {
        end_obj.v = 0;
      }
      valid = this.validate_ref(passage.start_context.translations, start_obj, end_obj);
      if (valid.valid) {
        ref9 = this.range_handle_valid(valid, passage, start, start_obj, end, end_obj, accum), return_now = ref9[0], return_value = ref9[1];
        if (return_now) {
          return return_value;
        }
      } else {
        return this.range_handle_invalid(valid, passage, start, start_obj, end, end_obj, accum);
      }
      if (passage.absolute_indices == null) {
        passage.absolute_indices = this.get_absolute_indices(passage.indices);
      }
      passage.passages = [
        {
          start: start_obj,
          end: end_obj,
          valid: valid
        }
      ];
      if (passage.start_context.translations != null) {
        passage.passages[0].translations = passage.start_context.translations;
      }
      if (start_obj.type === "b") {
        if (end_obj.type === "b") {
          passage.type = "b_range";
        } else {
          passage.type = "b_range_start";
        }
      } else if (end_obj.type === "b") {
        passage.type = "range_end_b";
      }
      accum.push(passage);
      return [accum, context];
    };

    bcv_passage.prototype.range_change_end = function(passage, accum, new_end) {
      var end, new_obj, ref, start;
      ref = passage.value, start = ref[0], end = ref[1];
      if (end.type === "integer") {
        end.original_value = end.value;
        end.value = new_end;
      } else if (end.type === "v") {
        new_obj = this.pluck("integer", end.value);
        new_obj.original_value = new_obj.value;
        new_obj.value = new_end;
      } else if (end.type === "cv") {
        new_obj = this.pluck("c", end.value);
        new_obj.original_value = new_obj.value;
        new_obj.value = new_end;
      }
      return this.handle_obj(passage, accum, passage.start_context);
    };

    bcv_passage.prototype.range_change_integer_end = function(passage, accum) {
      var end, ref, start;
      ref = passage.value, start = ref[0], end = ref[1];
      if (passage.original_type == null) {
        passage.original_type = passage.type;
      }
      if (passage.original_value == null) {
        passage.original_value = [start, end];
      }
      passage.type = start.type === "integer" ? "cv" : start.type + "v";
      if (start.type === "integer") {
        passage.value[0] = {
          type: "c",
          value: [start],
          indices: start.indices
        };
      }
      if (end.type === "integer") {
        passage.value[1] = {
          type: "v",
          value: [end],
          indices: end.indices
        };
      }
      return this.handle_obj(passage, accum, passage.start_context);
    };

    bcv_passage.prototype.range_check_new_end = function(translations, start_obj, end_obj, valid) {
      var new_end, new_valid, obj_to_validate, type;
      new_end = 0;
      type = null;
      if (valid.messages.end_chapter_before_start) {
        type = "c";
      } else if (valid.messages.end_verse_before_start) {
        type = "v";
      }
      if (type != null) {
        new_end = this.range_get_new_end_value(start_obj, end_obj, valid, type);
      }
      if (new_end > 0) {
        obj_to_validate = {
          b: end_obj.b,
          c: end_obj.c,
          v: end_obj.v
        };
        obj_to_validate[type] = new_end;
        new_valid = this.validate_ref(translations, obj_to_validate);
        if (!new_valid.valid) {
          new_end = 0;
        }
      }
      return new_end;
    };

    bcv_passage.prototype.range_end_b = function(passage, accum, context) {
      return this.range(passage, accum, context);
    };

    bcv_passage.prototype.range_get_new_end_value = function(start_obj, end_obj, valid, key) {
      var new_end;
      new_end = 0;
      if ((key === "c" && valid.messages.end_chapter_is_zero) || (key === "v" && valid.messages.end_verse_is_zero)) {
        return new_end;
      }
      if (start_obj[key] >= 10 && end_obj[key] < 10 && start_obj[key] - 10 * Math.floor(start_obj[key] / 10) < end_obj[key]) {
        new_end = end_obj[key] + 10 * Math.floor(start_obj[key] / 10);
      } else if (start_obj[key] >= 100 && end_obj[key] < 100 && start_obj[key] - 100 < end_obj[key]) {
        new_end = end_obj[key] + 100;
      }
      return new_end;
    };

    bcv_passage.prototype.range_handle_invalid = function(valid, passage, start, start_obj, end, end_obj, accum) {
      var new_end, ref, temp_valid, temp_value;
      if (valid.valid === false && (valid.messages.end_chapter_before_start || valid.messages.end_verse_before_start) && (end.type === "integer" || end.type === "v") || (valid.valid === false && valid.messages.end_chapter_before_start && end.type === "cv")) {
        new_end = this.range_check_new_end(passage.start_context.translations, start_obj, end_obj, valid);
        if (new_end > 0) {
          return this.range_change_end(passage, accum, new_end);
        }
      }
      if (this.options.end_range_digits_strategy === "verse" && (start_obj.v == null) && (end.type === "integer" || end.type === "v")) {
        temp_value = end.type === "v" ? this.pluck("integer", end.value) : end.value;
        temp_valid = this.validate_ref(passage.start_context.translations, {
          b: start_obj.b,
          c: start_obj.c,
          v: temp_value
        });
        if (temp_valid.valid) {
          return this.range_change_integer_end(passage, accum);
        }
      }
      if (passage.original_type == null) {
        passage.original_type = passage.type;
      }
      passage.type = "sequence";
      ref = [[start, end], [[start], [end]]], passage.original_value = ref[0], passage.value = ref[1];
      return this.sequence(passage, accum, passage.start_context);
    };

    bcv_passage.prototype.range_handle_valid = function(valid, passage, start, start_obj, end, end_obj, accum) {
      var temp_valid, temp_value;
      if (valid.messages.end_chapter_not_exist && this.options.end_range_digits_strategy === "verse" && (start_obj.v == null) && (end.type === "integer" || end.type === "v") && this.options.passage_existence_strategy.indexOf("v") >= 0) {
        temp_value = end.type === "v" ? this.pluck("integer", end.value) : end.value;
        temp_valid = this.validate_ref(passage.start_context.translations, {
          b: start_obj.b,
          c: start_obj.c,
          v: temp_value
        });
        if (temp_valid.valid) {
          return [true, this.range_change_integer_end(passage, accum)];
        }
      }
      this.range_validate(valid, start_obj, end_obj, passage);
      return [false, null];
    };

    bcv_passage.prototype.range_validate = function(valid, start_obj, end_obj, passage) {
      var ref;
      if (valid.messages.end_chapter_not_exist || valid.messages.end_chapter_not_exist_in_single_chapter_book) {
        end_obj.original_c = end_obj.c;
        end_obj.c = valid.messages.end_chapter_not_exist ? valid.messages.end_chapter_not_exist : valid.messages.end_chapter_not_exist_in_single_chapter_book;
        if (end_obj.v != null) {
          end_obj.v = this.validate_ref(passage.start_context.translations, {
            b: end_obj.b,
            c: end_obj.c,
            v: 999
          }).messages.end_verse_not_exist;
          delete valid.messages.end_verse_is_zero;
        }
      } else if (valid.messages.end_verse_not_exist) {
        end_obj.original_v = end_obj.v;
        end_obj.v = valid.messages.end_verse_not_exist;
      }
      if (valid.messages.end_verse_is_zero && this.options.zero_verse_strategy !== "allow") {
        end_obj.v = valid.messages.end_verse_is_zero;
      }
      if (valid.messages.end_chapter_is_zero) {
        end_obj.c = valid.messages.end_chapter_is_zero;
      }
      ref = this.fix_start_zeroes(valid, start_obj.c, start_obj.v), start_obj.c = ref[0], start_obj.v = ref[1];
      return true;
    };

    bcv_passage.prototype.translation_sequence = function(passage, accum, context) {
      var k, l, len, len1, ref, translation, translations, val;
      passage.start_context = bcv_utils.shallow_clone(context);
      translations = [];
      translations.push({
        translation: this.books[passage.value[0].value].parsed
      });
      ref = passage.value[1];
      for (k = 0, len = ref.length; k < len; k++) {
        val = ref[k];
        val = this.books[this.pluck("translation", val).value].parsed;
        if (val != null) {
          translations.push({
            translation: val
          });
        }
      }
      for (l = 0, len1 = translations.length; l < len1; l++) {
        translation = translations[l];
        if (this.translations.aliases[translation.translation] != null) {
          translation.alias = this.translations.aliases[translation.translation].alias;
          translation.osis = this.translations.aliases[translation.translation].osis || translation.translation.toUpperCase();
        } else {
          translation.alias = "default";
          translation.osis = translation.translation.toUpperCase();
        }
      }
      if (accum.length > 0) {
        context = this.translation_sequence_apply(accum, translations);
      }
      if (passage.absolute_indices == null) {
        passage.absolute_indices = this.get_absolute_indices(passage.indices);
      }
      accum.push(passage);
      this.reset_context(context, ["translations"]);
      return [accum, context];
    };

    bcv_passage.prototype.translation_sequence_apply = function(accum, translations) {
      var context, i, k, new_accum, ref, ref1, use_i;
      use_i = 0;
      for (i = k = ref = accum.length - 1; ref <= 0 ? k <= 0 : k >= 0; i = ref <= 0 ? ++k : --k) {
        if (accum[i].original_type != null) {
          accum[i].type = accum[i].original_type;
        }
        if (accum[i].original_value != null) {
          accum[i].value = accum[i].original_value;
        }
        if (accum[i].type !== "translation_sequence") {
          continue;
        }
        use_i = i + 1;
        break;
      }
      if (use_i < accum.length) {
        accum[use_i].start_context.translations = translations;
        ref1 = this.handle_array(accum.slice(use_i), [], accum[use_i].start_context), new_accum = ref1[0], context = ref1[1];
      } else {
        context = bcv_utils.shallow_clone(accum[accum.length - 1].start_context);
      }
      return context;
    };

    bcv_passage.prototype.pluck = function(type, passages) {
      var k, len, passage;
      for (k = 0, len = passages.length; k < len; k++) {
        passage = passages[k];
        if (!((passage != null) && (passage.type != null) && passage.type === type)) {
          continue;
        }
        if (type === "c" || type === "v") {
          return this.pluck("integer", passage.value);
        }
        return passage;
      }
      return null;
    };

    bcv_passage.prototype.pluck_last_recursively = function(type, passages) {
      var k, passage, value;
      for (k = passages.length - 1; k >= 0; k += -1) {
        passage = passages[k];
        if (!((passage != null) && (passage.type != null))) {
          continue;
        }
        if (passage.type === type) {
          return this.pluck(type, [passage]);
        }
        value = this.pluck_last_recursively(type, passage.value);
        if (value != null) {
          return value;
        }
      }
      return null;
    };

    bcv_passage.prototype.set_context_from_object = function(context, keys, obj) {
      var k, len, results, type;
      results = [];
      for (k = 0, len = keys.length; k < len; k++) {
        type = keys[k];
        if (obj[type] == null) {
          continue;
        }
        results.push(context[type] = obj[type]);
      }
      return results;
    };

    bcv_passage.prototype.reset_context = function(context, keys) {
      var k, len, results, type;
      results = [];
      for (k = 0, len = keys.length; k < len; k++) {
        type = keys[k];
        results.push(delete context[type]);
      }
      return results;
    };

    bcv_passage.prototype.fix_start_zeroes = function(valid, c, v) {
      if (valid.messages.start_chapter_is_zero && this.options.zero_chapter_strategy === "upgrade") {
        c = valid.messages.start_chapter_is_zero;
      }
      if (valid.messages.start_verse_is_zero && this.options.zero_verse_strategy === "upgrade") {
        v = valid.messages.start_verse_is_zero;
      }
      return [c, v];
    };

    bcv_passage.prototype.calculate_indices = function(match, adjust) {
      var character, end_index, indices, k, l, len, len1, len2, m, match_index, part, part_length, parts, ref, switch_type, temp;
      switch_type = "book";
      indices = [];
      match_index = 0;
      adjust = parseInt(adjust, 10);
      parts = [match];
      ref = ["\x1e", "\x1f"];
      for (k = 0, len = ref.length; k < len; k++) {
        character = ref[k];
        temp = [];
        for (l = 0, len1 = parts.length; l < len1; l++) {
          part = parts[l];
          temp = temp.concat(part.split(character));
        }
        parts = temp;
      }
      for (m = 0, len2 = parts.length; m < len2; m++) {
        part = parts[m];
        switch_type = switch_type === "book" ? "rest" : "book";
        part_length = part.length;
        if (part_length === 0) {
          continue;
        }
        if (switch_type === "book") {
          part = part.replace(/\/\d+$/, "");
          end_index = match_index + part_length;
          if (indices.length > 0 && indices[indices.length - 1].index === adjust) {
            indices[indices.length - 1].end = end_index;
          } else {
            indices.push({
              start: match_index,
              end: end_index,
              index: adjust
            });
          }
          match_index += part_length + 2;
          adjust = this.books[part].start_index + this.books[part].value.length - match_index;
          indices.push({
            start: end_index + 1,
            end: end_index + 1,
            index: adjust
          });
        } else {
          end_index = match_index + part_length - 1;
          if (indices.length > 0 && indices[indices.length - 1].index === adjust) {
            indices[indices.length - 1].end = end_index;
          } else {
            indices.push({
              start: match_index,
              end: end_index,
              index: adjust
            });
          }
          match_index += part_length;
        }
      }
      return indices;
    };

    bcv_passage.prototype.get_absolute_indices = function(arg1) {
      var end, end_out, index, k, len, ref, start, start_out;
      start = arg1[0], end = arg1[1];
      start_out = null;
      end_out = null;
      ref = this.indices;
      for (k = 0, len = ref.length; k < len; k++) {
        index = ref[k];
        if (start_out === null && (index.start <= start && start <= index.end)) {
          start_out = start + index.index;
        }
        if ((index.start <= end && end <= index.end)) {
          end_out = end + index.index + 1;
          break;
        }
      }
      return [start_out, end_out];
    };

    bcv_passage.prototype.validate_ref = function(translations, start, end) {
      var k, len, messages, temp_valid, translation, valid;
      if (!((translations != null) && translations.length > 0)) {
        translations = [
          {
            translation: "default",
            osis: "",
            alias: "default"
          }
        ];
      }
      valid = false;
      messages = {};
      for (k = 0, len = translations.length; k < len; k++) {
        translation = translations[k];
        if (translation.alias == null) {
          translation.alias = "default";
        }
        if (translation.alias == null) {
          if (messages.translation_invalid == null) {
            messages.translation_invalid = [];
          }
          messages.translation_invalid.push(translation);
          continue;
        }
        if (this.translations.aliases[translation.alias] == null) {
          translation.alias = "default";
          if (messages.translation_unknown == null) {
            messages.translation_unknown = [];
          }
          messages.translation_unknown.push(translation);
        }
        temp_valid = this.validate_start_ref(translation.alias, start, messages)[0];
        if (end) {
          temp_valid = this.validate_end_ref(translation.alias, start, end, temp_valid, messages)[0];
        }
        if (temp_valid === true) {
          valid = true;
        }
      }
      return {
        valid: valid,
        messages: messages
      };
    };

    bcv_passage.prototype.validate_start_ref = function(translation, start, messages) {
      var ref, ref1, translation_order, valid;
      valid = true;
      if (translation !== "default" && (((ref = this.translations[translation]) != null ? ref.chapters[start.b] : void 0) == null)) {
        this.promote_book_to_translation(start.b, translation);
      }
      translation_order = ((ref1 = this.translations[translation]) != null ? ref1.order : void 0) != null ? translation : "default";
      if (start.v != null) {
        start.v = parseInt(start.v, 10);
      }
      if (this.translations[translation_order].order[start.b] != null) {
        if (start.c == null) {
          start.c = 1;
        }
        start.c = parseInt(start.c, 10);
        if (isNaN(start.c)) {
          valid = false;
          messages.start_chapter_not_numeric = true;
          return [valid, messages];
        }
        if (start.c === 0) {
          messages.start_chapter_is_zero = 1;
          if (this.options.zero_chapter_strategy === "error") {
            valid = false;
          } else {
            start.c = 1;
          }
        }
        if ((start.v != null) && start.v === 0) {
          messages.start_verse_is_zero = 1;
          if (this.options.zero_verse_strategy === "error") {
            valid = false;
          } else if (this.options.zero_verse_strategy === "upgrade") {
            start.v = 1;
          }
        }
        if (start.c > 0 && (this.translations[translation].chapters[start.b][start.c - 1] != null)) {
          if (start.v != null) {
            if (isNaN(start.v)) {
              valid = false;
              messages.start_verse_not_numeric = true;
            } else if (start.v > this.translations[translation].chapters[start.b][start.c - 1]) {
              if (this.options.passage_existence_strategy.indexOf("v") >= 0) {
                valid = false;
                messages.start_verse_not_exist = this.translations[translation].chapters[start.b][start.c - 1];
              }
            }
          } else if (start.c === 1 && this.options.single_chapter_1_strategy === "verse" && this.translations[translation].chapters[start.b].length === 1) {
            messages.start_chapter_1 = 1;
          }
        } else {
          if (start.c !== 1 && this.translations[translation].chapters[start.b].length === 1) {
            valid = false;
            messages.start_chapter_not_exist_in_single_chapter_book = 1;
          } else if (start.c > 0 && this.options.passage_existence_strategy.indexOf("c") >= 0) {
            valid = false;
            messages.start_chapter_not_exist = this.translations[translation].chapters[start.b].length;
          }
        }
      } else if (start.b == null) {
        valid = false;
        messages.start_book_not_defined = true;
      } else {
        if (this.options.passage_existence_strategy.indexOf("b") >= 0) {
          valid = false;
        }
        messages.start_book_not_exist = true;
      }
      return [valid, messages];
    };

    bcv_passage.prototype.validate_end_ref = function(translation, start, end, valid, messages) {
      var ref, translation_order;
      translation_order = ((ref = this.translations[translation]) != null ? ref.order : void 0) != null ? translation : "default";
      if (end.c != null) {
        end.c = parseInt(end.c, 10);
        if (isNaN(end.c)) {
          valid = false;
          messages.end_chapter_not_numeric = true;
        } else if (end.c === 0) {
          messages.end_chapter_is_zero = 1;
          if (this.options.zero_chapter_strategy === "error") {
            valid = false;
          } else {
            end.c = 1;
          }
        }
      }
      if (end.v != null) {
        end.v = parseInt(end.v, 10);
        if (isNaN(end.v)) {
          valid = false;
          messages.end_verse_not_numeric = true;
        } else if (end.v === 0) {
          messages.end_verse_is_zero = 1;
          if (this.options.zero_verse_strategy === "error") {
            valid = false;
          } else if (this.options.zero_verse_strategy === "upgrade") {
            end.v = 1;
          }
        }
      }
      if (this.translations[translation_order].order[end.b] != null) {
        if ((end.c == null) && this.translations[translation].chapters[end.b].length === 1) {
          end.c = 1;
        }
        if ((this.translations[translation_order].order[start.b] != null) && this.translations[translation_order].order[start.b] > this.translations[translation_order].order[end.b]) {
          if (this.options.passage_existence_strategy.indexOf("b") >= 0) {
            valid = false;
          }
          messages.end_book_before_start = true;
        }
        if (start.b === end.b && (end.c != null) && !isNaN(end.c)) {
          if (start.c == null) {
            start.c = 1;
          }
          if (!isNaN(parseInt(start.c, 10)) && start.c > end.c) {
            valid = false;
            messages.end_chapter_before_start = true;
          } else if (start.c === end.c && (end.v != null) && !isNaN(end.v)) {
            if (start.v == null) {
              start.v = 1;
            }
            if (!isNaN(parseInt(start.v, 10)) && start.v > end.v) {
              valid = false;
              messages.end_verse_before_start = true;
            }
          }
        }
        if ((end.c != null) && !isNaN(end.c)) {
          if (this.translations[translation].chapters[end.b][end.c - 1] == null) {
            if (this.translations[translation].chapters[end.b].length === 1) {
              messages.end_chapter_not_exist_in_single_chapter_book = 1;
            } else if (end.c > 0 && this.options.passage_existence_strategy.indexOf("c") >= 0) {
              messages.end_chapter_not_exist = this.translations[translation].chapters[end.b].length;
            }
          }
        }
        if ((end.v != null) && !isNaN(end.v)) {
          if (end.c == null) {
            end.c = this.translations[translation].chapters[end.b].length;
          }
          if (end.v > this.translations[translation].chapters[end.b][end.c - 1] && this.options.passage_existence_strategy.indexOf("v") >= 0) {
            messages.end_verse_not_exist = this.translations[translation].chapters[end.b][end.c - 1];
          }
        }
      } else {
        valid = false;
        messages.end_book_not_exist = true;
      }
      return [valid, messages];
    };

    bcv_passage.prototype.promote_book_to_translation = function(book, translation) {
      var base, base1;
      if ((base = this.translations)[translation] == null) {
        base[translation] = {};
      }
      if ((base1 = this.translations[translation]).chapters == null) {
        base1.chapters = {};
      }
      if (this.translations[translation].chapters[book] == null) {
        return this.translations[translation].chapters[book] = bcv_utils.shallow_clone_array(this.translations["default"].chapters[book]);
      }
    };

    return bcv_passage;

  })();

  bcv_utils = {
    shallow_clone: function(obj) {
      var key, out, val;
      if (obj == null) {
        return obj;
      }
      out = {};
      for (key in obj) {
        if (!hasProp.call(obj, key)) continue;
        val = obj[key];
        out[key] = val;
      }
      return out;
    },
    shallow_clone_array: function(arr) {
      var i, k, out, ref;
      if (arr == null) {
        return arr;
      }
      out = [];
      for (i = k = 0, ref = arr.length; 0 <= ref ? k <= ref : k >= ref; i = 0 <= ref ? ++k : --k) {
        if (typeof arr[i] !== "undefined") {
          out[i] = arr[i];
        }
      }
      return out;
    }
  };

  bcv_parser.prototype.regexps.translations = /(?:(?:A(?:MP|SV)|RSV|N(?:RSV|LT|I(?:RV|V)|KJV|A(?:B(?:RE)?|SB?))|MSG|TNIV|CE[BV]|E[RS]V|HCSB|KJV|LXX))\b/gi;

  bcv_parser.prototype.translations = {
    aliases: {
      ceb: {
        alias: "ceb"
      },
      kjv: {
        alias: "kjv"
      },
      lxx: {
        alias: "nab"
      },
      nab: {
        alias: "nab"
      },
      nabre: {
        alias: "nab"
      },
      nas: {
        osis: "NASB",
        alias: "default"
      },
      nirv: {
        alias: "kjv"
      },
      niv: {
        alias: "kjv"
      },
      nkjv: {
        alias: "nkjv"
      },
      nlt: {
        alias: "nlt"
      },
      nrsv: {
        alias: "nrsv"
      },
      tniv: {
        alias: "kjv"
      },
      "default": {
        osis: "",
        alias: "default"
      }
    },
    alternates: {},
    "default": {
      order: {
        "Gen": 1,
        "Exod": 2,
        "Lev": 3,
        "Num": 4,
        "Deut": 5,
        "Josh": 6,
        "Judg": 7,
        "Ruth": 8,
        "1Sam": 9,
        "2Sam": 10,
        "1Kgs": 11,
        "2Kgs": 12,
        "1Chr": 13,
        "2Chr": 14,
        "Ezra": 15,
        "Neh": 16,
        "Esth": 17,
        "Job": 18,
        "Ps": 19,
        "Prov": 20,
        "Eccl": 21,
        "Song": 22,
        "Isa": 23,
        "Jer": 24,
        "Lam": 25,
        "Ezek": 26,
        "Dan": 27,
        "Hos": 28,
        "Joel": 29,
        "Amos": 30,
        "Obad": 31,
        "Jonah": 32,
        "Mic": 33,
        "Nah": 34,
        "Hab": 35,
        "Zeph": 36,
        "Hag": 37,
        "Zech": 38,
        "Mal": 39,
        "Matt": 40,
        "Mark": 41,
        "Luke": 42,
        "John": 43,
        "Acts": 44,
        "Rom": 45,
        "1Cor": 46,
        "2Cor": 47,
        "Gal": 48,
        "Eph": 49,
        "Phil": 50,
        "Col": 51,
        "1Thess": 52,
        "2Thess": 53,
        "1Tim": 54,
        "2Tim": 55,
        "Titus": 56,
        "Phlm": 57,
        "Heb": 58,
        "Jas": 59,
        "1Pet": 60,
        "2Pet": 61,
        "1John": 62,
        "2John": 63,
        "3John": 64,
        "Jude": 65,
        "Rev": 66,
        "Tob": 67,
        "Jdt": 68,
        "GkEsth": 69,
        "Wis": 70,
        "Sir": 71,
        "Bar": 72,
        "PrAzar": 73,
        "Sus": 74,
        "Bel": 75,
        "SgThree": 76,
        "EpJer": 77,
        "1Macc": 78,
        "2Macc": 79,
        "3Macc": 80,
        "4Macc": 81,
        "1Esd": 82,
        "2Esd": 83,
        "PrMan": 84
      },
      chapters: {
        "Gen": [31, 25, 24, 26, 32, 22, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 38, 18, 34, 24, 20, 67, 34, 35, 46, 22, 35, 43, 55, 32, 20, 31, 29, 43, 36, 30, 23, 23, 57, 38, 34, 34, 28, 34, 31, 22, 33, 26],
        "Exod": [22, 25, 22, 31, 23, 30, 25, 32, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 36, 31, 33, 18, 40, 37, 21, 43, 46, 38, 18, 35, 23, 35, 35, 38, 29, 31, 43, 38],
        "Lev": [17, 16, 17, 35, 19, 30, 38, 36, 24, 20, 47, 8, 59, 57, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 46, 34],
        "Num": [54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 35, 16, 33, 45, 41, 50, 13, 32, 22, 29, 35, 41, 30, 25, 18, 65, 23, 31, 40, 16, 54, 42, 56, 29, 34, 13],
        "Deut": [46, 37, 29, 49, 33, 25, 26, 20, 29, 22, 32, 32, 18, 29, 23, 22, 20, 22, 21, 20, 23, 30, 25, 22, 19, 19, 26, 68, 29, 20, 30, 52, 29, 12],
        "Josh": [18, 24, 17, 24, 15, 27, 26, 35, 27, 43, 23, 24, 33, 15, 63, 10, 18, 28, 51, 9, 45, 34, 16, 33],
        "Judg": [36, 23, 31, 24, 31, 40, 25, 35, 57, 18, 40, 15, 25, 20, 20, 31, 13, 31, 30, 48, 25],
        "Ruth": [22, 23, 18, 22],
        "1Sam": [28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 42, 15, 23, 29, 22, 44, 25, 12, 25, 11, 31, 13],
        "2Sam": [27, 32, 39, 12, 25, 23, 29, 18, 13, 19, 27, 31, 39, 33, 37, 23, 29, 33, 43, 26, 22, 51, 39, 25],
        "1Kgs": [53, 46, 28, 34, 18, 38, 51, 66, 28, 29, 43, 33, 34, 31, 34, 34, 24, 46, 21, 43, 29, 53],
        "2Kgs": [18, 25, 27, 44, 27, 33, 20, 29, 37, 36, 21, 21, 25, 29, 38, 20, 41, 37, 37, 21, 26, 20, 37, 20, 30],
        "1Chr": [54, 55, 24, 43, 26, 81, 40, 40, 44, 14, 47, 40, 14, 17, 29, 43, 27, 17, 19, 8, 30, 19, 32, 31, 31, 32, 34, 21, 30],
        "2Chr": [17, 18, 17, 22, 14, 42, 22, 18, 31, 19, 23, 16, 22, 15, 19, 14, 19, 34, 11, 37, 20, 12, 21, 27, 28, 23, 9, 27, 36, 27, 21, 33, 25, 33, 27, 23],
        "Ezra": [11, 70, 13, 24, 17, 22, 28, 36, 15, 44],
        "Neh": [11, 20, 32, 23, 19, 19, 73, 18, 38, 39, 36, 47, 31],
        "Esth": [22, 23, 15, 17, 14, 14, 10, 17, 32, 3],
        "Job": [22, 13, 26, 21, 27, 30, 21, 22, 35, 22, 20, 25, 28, 22, 35, 22, 16, 21, 29, 29, 34, 30, 17, 25, 6, 14, 23, 28, 25, 31, 40, 22, 33, 37, 16, 33, 24, 41, 30, 24, 34, 17],
        "Ps": [6, 12, 8, 8, 12, 10, 17, 9, 20, 18, 7, 8, 6, 7, 5, 11, 15, 50, 14, 9, 13, 31, 6, 10, 22, 12, 14, 9, 11, 12, 24, 11, 22, 22, 28, 12, 40, 22, 13, 17, 13, 11, 5, 26, 17, 11, 9, 14, 20, 23, 19, 9, 6, 7, 23, 13, 11, 11, 17, 12, 8, 12, 11, 10, 13, 20, 7, 35, 36, 5, 24, 20, 28, 23, 10, 12, 20, 72, 13, 19, 16, 8, 18, 12, 13, 17, 7, 18, 52, 17, 16, 15, 5, 23, 11, 13, 12, 9, 9, 5, 8, 28, 22, 35, 45, 48, 43, 13, 31, 7, 10, 10, 9, 8, 18, 19, 2, 29, 176, 7, 8, 9, 4, 8, 5, 6, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9, 8, 24, 13, 10, 7, 12, 15, 21, 10, 20, 14, 9, 6],
        "Prov": [33, 22, 35, 27, 23, 35, 27, 36, 18, 32, 31, 28, 25, 35, 33, 33, 28, 24, 29, 30, 31, 29, 35, 34, 28, 28, 27, 28, 27, 33, 31],
        "Eccl": [18, 26, 22, 16, 20, 12, 29, 17, 18, 20, 10, 14],
        "Song": [17, 17, 11, 16, 16, 13, 13, 14],
        "Isa": [31, 22, 26, 6, 30, 13, 25, 22, 21, 34, 16, 6, 22, 32, 9, 14, 14, 7, 25, 6, 17, 25, 18, 23, 12, 21, 13, 29, 24, 33, 9, 20, 24, 17, 10, 22, 38, 22, 8, 31, 29, 25, 28, 28, 25, 13, 15, 22, 26, 11, 23, 15, 12, 17, 13, 12, 21, 14, 21, 22, 11, 12, 19, 12, 25, 24],
        "Jer": [19, 37, 25, 31, 31, 30, 34, 22, 26, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 40, 10, 38, 24, 22, 17, 32, 24, 40, 44, 26, 22, 19, 32, 21, 28, 18, 16, 18, 22, 13, 30, 5, 28, 7, 47, 39, 46, 64, 34],
        "Lam": [22, 22, 66, 22, 22],
        "Ezek": [28, 10, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 49, 32, 31, 49, 27, 17, 21, 36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35],
        "Dan": [21, 49, 30, 37, 31, 28, 28, 27, 27, 21, 45, 13],
        "Hos": [11, 23, 5, 19, 15, 11, 16, 14, 17, 15, 12, 14, 16, 9],
        "Joel": [20, 32, 21],
        "Amos": [15, 16, 15, 13, 27, 14, 17, 14, 15],
        "Obad": [21],
        "Jonah": [17, 10, 10, 11],
        "Mic": [16, 13, 12, 13, 15, 16, 20],
        "Nah": [15, 13, 19],
        "Hab": [17, 20, 19],
        "Zeph": [18, 15, 20],
        "Hag": [15, 23],
        "Zech": [21, 13, 10, 14, 11, 15, 14, 23, 17, 12, 17, 14, 9, 21],
        "Mal": [14, 17, 18, 6],
        "Matt": [25, 23, 17, 25, 48, 34, 29, 34, 38, 42, 30, 50, 58, 36, 39, 28, 27, 35, 30, 34, 46, 46, 39, 51, 46, 75, 66, 20],
        "Mark": [45, 28, 35, 41, 43, 56, 37, 38, 50, 52, 33, 44, 37, 72, 47, 20],
        "Luke": [80, 52, 38, 44, 39, 49, 50, 56, 62, 42, 54, 59, 35, 35, 32, 31, 37, 43, 48, 47, 38, 71, 56, 53],
        "John": [51, 25, 36, 54, 47, 71, 53, 59, 41, 42, 57, 50, 38, 31, 27, 33, 26, 40, 42, 31, 25],
        "Acts": [26, 47, 26, 37, 42, 15, 60, 40, 43, 48, 30, 25, 52, 28, 41, 40, 34, 28, 41, 38, 40, 30, 35, 27, 27, 32, 44, 31],
        "Rom": [32, 29, 31, 25, 21, 23, 25, 39, 33, 21, 36, 21, 14, 23, 33, 27],
        "1Cor": [31, 16, 23, 21, 13, 20, 40, 13, 27, 33, 34, 31, 13, 40, 58, 24],
        "2Cor": [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 14],
        "Gal": [24, 21, 29, 31, 26, 18],
        "Eph": [23, 22, 21, 32, 33, 24],
        "Phil": [30, 30, 21, 23],
        "Col": [29, 23, 25, 18],
        "1Thess": [10, 20, 13, 18, 28],
        "2Thess": [12, 17, 18],
        "1Tim": [20, 15, 16, 16, 25, 21],
        "2Tim": [18, 26, 17, 22],
        "Titus": [16, 15, 15],
        "Phlm": [25],
        "Heb": [14, 18, 19, 16, 14, 20, 28, 13, 28, 39, 40, 29, 25],
        "Jas": [27, 26, 18, 17, 20],
        "1Pet": [25, 25, 22, 19, 14],
        "2Pet": [21, 22, 18],
        "1John": [10, 29, 24, 21, 21],
        "2John": [13],
        "3John": [15],
        "Jude": [25],
        "Rev": [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 17, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21],
        "Tob": [22, 14, 17, 21, 22, 18, 16, 21, 6, 13, 18, 22, 17, 15],
        "Jdt": [16, 28, 10, 15, 24, 21, 32, 36, 14, 23, 23, 20, 20, 19, 14, 25],
        "GkEsth": [22, 23, 15, 17, 14, 14, 10, 17, 32, 13, 12, 6, 18, 19, 16, 24],
        "Wis": [16, 24, 19, 20, 23, 25, 30, 21, 18, 21, 26, 27, 19, 31, 19, 29, 21, 25, 22],
        "Sir": [30, 18, 31, 31, 15, 37, 36, 19, 18, 31, 34, 18, 26, 27, 20, 30, 32, 33, 30, 31, 28, 27, 27, 34, 26, 29, 30, 26, 28, 25, 31, 24, 33, 31, 26, 31, 31, 34, 35, 30, 22, 25, 33, 23, 26, 20, 25, 25, 16, 29, 30],
        "Bar": [22, 35, 37, 37, 9],
        "PrAzar": [68],
        "Sus": [64],
        "Bel": [42],
        "SgThree": [39],
        "EpJer": [73],
        "1Macc": [64, 70, 60, 61, 68, 63, 50, 32, 73, 89, 74, 53, 53, 49, 41, 24],
        "2Macc": [36, 32, 40, 50, 27, 31, 42, 36, 29, 38, 38, 45, 26, 46, 39],
        "3Macc": [29, 33, 30, 21, 51, 41, 23],
        "4Macc": [35, 24, 21, 26, 38, 35, 23, 29, 32, 21, 27, 19, 27, 20, 32, 25, 24, 24],
        "1Esd": [58, 30, 24, 63, 73, 34, 15, 96, 55],
        "2Esd": [40, 48, 36, 52, 56, 59, 70, 63, 47, 59, 46, 51, 58, 48, 63, 78],
        "PrMan": [15],
        "Ps151": [7]
      }
    },
    vulgate: {
      chapters: {
        "Gen": [31, 25, 24, 26, 32, 22, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 38, 18, 34, 24, 20, 67, 34, 35, 46, 22, 35, 43, 55, 32, 20, 31, 29, 43, 36, 30, 23, 23, 57, 38, 34, 34, 28, 34, 31, 22, 32, 25],
        "Exod": [22, 25, 22, 31, 23, 30, 25, 32, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 36, 31, 33, 18, 40, 37, 21, 43, 46, 38, 18, 35, 23, 35, 35, 38, 29, 31, 43, 36],
        "Lev": [17, 16, 17, 35, 19, 30, 38, 36, 24, 20, 47, 8, 59, 57, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 45, 34],
        "Num": [54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 34, 15, 34, 45, 41, 50, 13, 32, 22, 30, 35, 41, 30, 25, 18, 65, 23, 31, 39, 17, 54, 42, 56, 29, 34, 13],
        "Josh": [18, 24, 17, 25, 16, 27, 26, 35, 27, 44, 23, 24, 33, 15, 63, 10, 18, 28, 51, 9, 43, 34, 16, 33],
        "Judg": [36, 23, 31, 24, 32, 40, 25, 35, 57, 18, 40, 15, 25, 20, 20, 31, 13, 31, 30, 48, 24],
        "1Sam": [28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 43, 15, 23, 28, 23, 44, 25, 12, 25, 11, 31, 13],
        "1Kgs": [53, 46, 28, 34, 18, 38, 51, 66, 28, 29, 43, 33, 34, 31, 34, 34, 24, 46, 21, 43, 29, 54],
        "1Chr": [54, 55, 24, 43, 26, 81, 40, 40, 44, 14, 46, 40, 14, 17, 29, 43, 27, 17, 19, 7, 30, 19, 32, 31, 31, 32, 34, 21, 30],
        "Neh": [11, 20, 31, 23, 19, 19, 73, 18, 38, 39, 36, 46, 31],
        "Job": [22, 13, 26, 21, 27, 30, 21, 22, 35, 22, 20, 25, 28, 22, 35, 23, 16, 21, 29, 29, 34, 30, 17, 25, 6, 14, 23, 28, 25, 31, 40, 22, 33, 37, 16, 33, 24, 41, 35, 28, 25, 16],
        "Ps": [6, 13, 9, 10, 13, 11, 18, 10, 39, 8, 9, 6, 7, 5, 10, 15, 51, 15, 10, 14, 32, 6, 10, 22, 12, 14, 9, 11, 13, 25, 11, 22, 23, 28, 13, 40, 23, 14, 18, 14, 12, 5, 26, 18, 12, 10, 15, 21, 23, 21, 11, 7, 9, 24, 13, 12, 12, 18, 14, 9, 13, 12, 11, 14, 20, 8, 36, 37, 6, 24, 20, 28, 23, 11, 13, 21, 72, 13, 20, 17, 8, 19, 13, 14, 17, 7, 19, 53, 17, 16, 16, 5, 23, 11, 13, 12, 9, 9, 5, 8, 29, 22, 35, 45, 48, 43, 14, 31, 7, 10, 10, 9, 26, 9, 10, 2, 29, 176, 7, 8, 9, 4, 8, 5, 6, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9, 8, 24, 14, 10, 8, 12, 15, 21, 10, 11, 9, 14, 9, 6],
        "Eccl": [18, 26, 22, 17, 19, 11, 30, 17, 18, 20, 10, 14],
        "Song": [16, 17, 11, 16, 17, 12, 13, 14],
        "Jer": [19, 37, 25, 31, 31, 30, 34, 22, 26, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 40, 10, 38, 24, 22, 17, 32, 24, 40, 44, 26, 22, 19, 32, 20, 28, 18, 16, 18, 22, 13, 30, 5, 28, 7, 47, 39, 46, 64, 34],
        "Ezek": [28, 9, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 49, 32, 31, 49, 27, 17, 21, 36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35],
        "Dan": [21, 49, 100, 34, 31, 28, 28, 27, 27, 21, 45, 13, 65, 42],
        "Hos": [11, 24, 5, 19, 15, 11, 16, 14, 17, 15, 12, 14, 15, 10],
        "Amos": [15, 16, 15, 13, 27, 15, 17, 14, 14],
        "Jonah": [16, 11, 10, 11],
        "Mic": [16, 13, 12, 13, 14, 16, 20],
        "Hag": [14, 24],
        "Matt": [25, 23, 17, 25, 48, 34, 29, 34, 38, 42, 30, 50, 58, 36, 39, 28, 26, 35, 30, 34, 46, 46, 39, 51, 46, 75, 66, 20],
        "Mark": [45, 28, 35, 40, 43, 56, 37, 39, 49, 52, 33, 44, 37, 72, 47, 20],
        "John": [51, 25, 36, 54, 47, 72, 53, 59, 41, 42, 57, 50, 38, 31, 27, 33, 26, 40, 42, 31, 25],
        "Acts": [26, 47, 26, 37, 42, 15, 59, 40, 43, 48, 30, 25, 52, 27, 41, 40, 34, 28, 40, 38, 40, 30, 35, 27, 27, 32, 44, 31],
        "2Cor": [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 13],
        "Rev": [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 18, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21],
        "Tob": [25, 23, 25, 23, 28, 22, 20, 24, 12, 13, 21, 22, 23, 17],
        "Jdt": [12, 18, 15, 17, 29, 21, 25, 34, 19, 20, 21, 20, 31, 18, 15, 31],
        "Wis": [16, 25, 19, 20, 24, 27, 30, 21, 19, 21, 27, 27, 19, 31, 19, 29, 20, 25, 20],
        "Sir": [40, 23, 34, 36, 18, 37, 40, 22, 25, 34, 36, 19, 32, 27, 22, 31, 31, 33, 28, 33, 31, 33, 38, 47, 36, 28, 33, 30, 35, 27, 42, 28, 33, 31, 26, 28, 34, 39, 41, 32, 28, 26, 37, 27, 31, 23, 31, 28, 19, 31, 38, 13],
        "Bar": [22, 35, 38, 37, 9, 72],
        "1Macc": [67, 70, 60, 61, 68, 63, 50, 32, 73, 89, 74, 54, 54, 49, 41, 24],
        "2Macc": [36, 33, 40, 50, 27, 31, 42, 36, 29, 38, 38, 46, 26, 46, 40]
      }
    },
    ceb: {
      chapters: {
        "2Cor": [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 13],
        "Rev": [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 18, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21],
        "Tob": [22, 14, 17, 21, 22, 18, 16, 21, 6, 13, 18, 22, 18, 15],
        "PrAzar": [67],
        "EpJer": [72],
        "1Esd": [55, 26, 24, 63, 71, 33, 15, 92, 55]
      }
    },
    kjv: {
      chapters: {
        "3John": [14]
      }
    },
    nab: {
      order: {
        "Gen": 1,
        "Exod": 2,
        "Lev": 3,
        "Num": 4,
        "Deut": 5,
        "Josh": 6,
        "Judg": 7,
        "Ruth": 8,
        "1Sam": 9,
        "2Sam": 10,
        "1Kgs": 11,
        "2Kgs": 12,
        "1Chr": 13,
        "2Chr": 14,
        "PrMan": 15,
        "Ezra": 16,
        "Neh": 17,
        "1Esd": 18,
        "2Esd": 19,
        "Tob": 20,
        "Jdt": 21,
        "Esth": 22,
        "GkEsth": 23,
        "1Macc": 24,
        "2Macc": 25,
        "3Macc": 26,
        "4Macc": 27,
        "Job": 28,
        "Ps": 29,
        "Prov": 30,
        "Eccl": 31,
        "Song": 32,
        "Wis": 33,
        "Sir": 34,
        "Isa": 35,
        "Jer": 36,
        "Lam": 37,
        "Bar": 38,
        "EpJer": 39,
        "Ezek": 40,
        "Dan": 41,
        "PrAzar": 42,
        "Sus": 43,
        "Bel": 44,
        "SgThree": 45,
        "Hos": 46,
        "Joel": 47,
        "Amos": 48,
        "Obad": 49,
        "Jonah": 50,
        "Mic": 51,
        "Nah": 52,
        "Hab": 53,
        "Zeph": 54,
        "Hag": 55,
        "Zech": 56,
        "Mal": 57,
        "Matt": 58,
        "Mark": 59,
        "Luke": 60,
        "John": 61,
        "Acts": 62,
        "Rom": 63,
        "1Cor": 64,
        "2Cor": 65,
        "Gal": 66,
        "Eph": 67,
        "Phil": 68,
        "Col": 69,
        "1Thess": 70,
        "2Thess": 71,
        "1Tim": 72,
        "2Tim": 73,
        "Titus": 74,
        "Phlm": 75,
        "Heb": 76,
        "Jas": 77,
        "1Pet": 78,
        "2Pet": 79,
        "1John": 80,
        "2John": 81,
        "3John": 82,
        "Jude": 83,
        "Rev": 84
      },
      chapters: {
        "Gen": [31, 25, 24, 26, 32, 22, 24, 22, 29, 32, 32, 20, 18, 24, 21, 16, 27, 33, 38, 18, 34, 24, 20, 67, 34, 35, 46, 22, 35, 43, 54, 33, 20, 31, 29, 43, 36, 30, 23, 23, 57, 38, 34, 34, 28, 34, 31, 22, 33, 26],
        "Exod": [22, 25, 22, 31, 23, 30, 29, 28, 35, 29, 10, 51, 22, 31, 27, 36, 16, 27, 25, 26, 37, 30, 33, 18, 40, 37, 21, 43, 46, 38, 18, 35, 23, 35, 35, 38, 29, 31, 43, 38],
        "Lev": [17, 16, 17, 35, 26, 23, 38, 36, 24, 20, 47, 8, 59, 57, 33, 34, 16, 30, 37, 27, 24, 33, 44, 23, 55, 46, 34],
        "Num": [54, 34, 51, 49, 31, 27, 89, 26, 23, 36, 35, 16, 33, 45, 41, 35, 28, 32, 22, 29, 35, 41, 30, 25, 19, 65, 23, 31, 39, 17, 54, 42, 56, 29, 34, 13],
        "Deut": [46, 37, 29, 49, 33, 25, 26, 20, 29, 22, 32, 31, 19, 29, 23, 22, 20, 22, 21, 20, 23, 29, 26, 22, 19, 19, 26, 69, 28, 20, 30, 52, 29, 12],
        "1Sam": [28, 36, 21, 22, 12, 21, 17, 22, 27, 27, 15, 25, 23, 52, 35, 23, 58, 30, 24, 42, 16, 23, 28, 23, 44, 25, 12, 25, 11, 31, 13],
        "2Sam": [27, 32, 39, 12, 25, 23, 29, 18, 13, 19, 27, 31, 39, 33, 37, 23, 29, 32, 44, 26, 22, 51, 39, 25],
        "1Kgs": [53, 46, 28, 20, 32, 38, 51, 66, 28, 29, 43, 33, 34, 31, 34, 34, 24, 46, 21, 43, 29, 54],
        "2Kgs": [18, 25, 27, 44, 27, 33, 20, 29, 37, 36, 20, 22, 25, 29, 38, 20, 41, 37, 37, 21, 26, 20, 37, 20, 30],
        "1Chr": [54, 55, 24, 43, 41, 66, 40, 40, 44, 14, 47, 41, 14, 17, 29, 43, 27, 17, 19, 8, 30, 19, 32, 31, 31, 32, 34, 21, 30],
        "2Chr": [18, 17, 17, 22, 14, 42, 22, 18, 31, 19, 23, 16, 23, 14, 19, 14, 19, 34, 11, 37, 20, 12, 21, 27, 28, 23, 9, 27, 36, 27, 21, 33, 25, 33, 27, 23],
        "Neh": [11, 20, 38, 17, 19, 19, 72, 18, 37, 40, 36, 47, 31],
        "Job": [22, 13, 26, 21, 27, 30, 21, 22, 35, 22, 20, 25, 28, 22, 35, 22, 16, 21, 29, 29, 34, 30, 17, 25, 6, 14, 23, 28, 25, 31, 40, 22, 33, 37, 16, 33, 24, 41, 30, 32, 26, 17],
        "Ps": [6, 11, 9, 9, 13, 11, 18, 10, 21, 18, 7, 9, 6, 7, 5, 11, 15, 51, 15, 10, 14, 32, 6, 10, 22, 12, 14, 9, 11, 13, 25, 11, 22, 23, 28, 13, 40, 23, 14, 18, 14, 12, 5, 27, 18, 12, 10, 15, 21, 23, 21, 11, 7, 9, 24, 14, 12, 12, 18, 14, 9, 13, 12, 11, 14, 20, 8, 36, 37, 6, 24, 20, 28, 23, 11, 13, 21, 72, 13, 20, 17, 8, 19, 13, 14, 17, 7, 19, 53, 17, 16, 16, 5, 23, 11, 13, 12, 9, 9, 5, 8, 29, 22, 35, 45, 48, 43, 14, 31, 7, 10, 10, 9, 8, 18, 19, 2, 29, 176, 7, 8, 9, 4, 8, 5, 6, 5, 6, 8, 8, 3, 18, 3, 3, 21, 26, 9, 8, 24, 14, 10, 8, 12, 15, 21, 10, 20, 14, 9, 6],
        "Eccl": [18, 26, 22, 17, 19, 12, 29, 17, 18, 20, 10, 14],
        "Song": [17, 17, 11, 16, 16, 12, 14, 14],
        "Isa": [31, 22, 26, 6, 30, 13, 25, 23, 20, 34, 16, 6, 22, 32, 9, 14, 14, 7, 25, 6, 17, 25, 18, 23, 12, 21, 13, 29, 24, 33, 9, 20, 24, 17, 10, 22, 38, 22, 8, 31, 29, 25, 28, 28, 25, 13, 15, 22, 26, 11, 23, 15, 12, 17, 13, 12, 21, 14, 21, 22, 11, 12, 19, 11, 25, 24],
        "Jer": [19, 37, 25, 31, 31, 30, 34, 23, 25, 25, 23, 17, 27, 22, 21, 21, 27, 23, 15, 18, 14, 30, 40, 10, 38, 24, 22, 17, 32, 24, 40, 44, 26, 22, 19, 32, 21, 28, 18, 16, 18, 22, 13, 30, 5, 28, 7, 47, 39, 46, 64, 34],
        "Ezek": [28, 10, 27, 17, 17, 14, 27, 18, 11, 22, 25, 28, 23, 23, 8, 63, 24, 32, 14, 44, 37, 31, 49, 27, 17, 21, 36, 26, 21, 26, 18, 32, 33, 31, 15, 38, 28, 23, 29, 49, 26, 20, 27, 31, 25, 24, 23, 35],
        "Dan": [21, 49, 100, 34, 30, 29, 28, 27, 27, 21, 45, 13, 64, 42],
        "Hos": [9, 25, 5, 19, 15, 11, 16, 14, 17, 15, 11, 15, 15, 10],
        "Joel": [20, 27, 5, 21],
        "Jonah": [16, 11, 10, 11],
        "Mic": [16, 13, 12, 14, 14, 16, 20],
        "Nah": [14, 14, 19],
        "Zech": [17, 17, 10, 14, 11, 15, 14, 23, 17, 12, 17, 14, 9, 21],
        "Mal": [14, 17, 24],
        "Acts": [26, 47, 26, 37, 42, 15, 60, 40, 43, 49, 30, 25, 52, 28, 41, 40, 34, 28, 40, 38, 40, 30, 35, 27, 27, 32, 44, 31],
        "2Cor": [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 13],
        "Rev": [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 18, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21],
        "Tob": [22, 14, 17, 21, 22, 18, 17, 21, 6, 13, 18, 22, 18, 15],
        "Sir": [30, 18, 31, 31, 15, 37, 36, 19, 18, 31, 34, 18, 26, 27, 20, 30, 32, 33, 30, 31, 28, 27, 27, 33, 26, 29, 30, 26, 28, 25, 31, 24, 33, 31, 26, 31, 31, 34, 35, 30, 22, 25, 33, 23, 26, 20, 25, 25, 16, 29, 30],
        "Bar": [22, 35, 38, 37, 9, 72],
        "2Macc": [36, 32, 40, 50, 27, 31, 42, 36, 29, 38, 38, 46, 26, 46, 39]
      }
    },
    nlt: {
      chapters: {
        "Rev": [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 18, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21]
      }
    },
    nrsv: {
      chapters: {
        "2Cor": [24, 17, 18, 18, 21, 18, 16, 24, 15, 18, 33, 21, 13],
        "Rev": [20, 29, 22, 11, 14, 17, 17, 13, 21, 11, 19, 18, 18, 20, 8, 21, 18, 24, 21, 15, 27, 21]
      }
    }
  };

  bcv_parser.prototype.languages = ["ar", "bg", "ceb", "cs", "cy", "da", "de", "el", "en", "es", "fi", "fr", "he", "hi", "hr", "ht", "hu", "is", "it", "ja", "jv", "ko", "la", "mk", "mr", "ne", "nl", "no", "or", "pa", "pl", "pt", "ro", "ru", "sk", "so", "sq", "sr", "sv", "sw", "ta", "th", "tl", "uk", "ur", "vi", "wal", "zh"];

  bcv_parser.prototype.regexps.space = "[\\s\\xa0]";

  bcv_parser.prototype.regexps.escaped_passage = RegExp("(?:^|[^\\x1f\\x1e\\dA-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])((?:(?:ch(?:apters?|a?pts?\\.?|a?p?s?\\.?)?\\s*\\d+\\s*(?:[\\u2013\\u2014\\-]|through|thru|to)\\s*\\d+\\s*(?:from|of|in)(?:\\s+the\\s+book\\s+of)?\\s*)|(?:ch(?:apters?|a?pts?\\.?|a?p?s?\\.?)?\\s*\\d+\\s*(?:from|of|in)(?:\\s+the\\s+book\\s+of)?\\s*)|(?:\\d+(?:th|nd|st)\\s*ch(?:apter|a?pt\\.?|a?p?\\.?)?\\s*(?:from|of|in)(?:\\s+the\\s+book\\s+of)?\\s*))?\\x1f(\\d+)(?:/\\d+)?\\x1f(?:/\\d+\\x1f|[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014]|title(?![a-z])|see" + bcv_parser.prototype.regexps.space + "+also|ff(?![a-z0-9])|f(?![a-z0-9])|chapters|chapter|through|compare|chapts|verses|chpts|chapt|chaps|verse|chap|thru|also|chp|chs|cha|and|see|ver|vss|ch|to|cf|vs|vv|v|[a-e](?!\\w)|$)+)", "gi");

  bcv_parser.prototype.regexps.match_end_split = /\d\W*title|\d\W*(?:ff(?![a-z0-9])|f(?![a-z0-9]))(?:[\s\xa0*]*\.)?|\d[\s\xa0*]*[a-e](?!\w)|\x1e(?:[\s\xa0*]*[)\]\uff09])?|[\d\x1f]/gi;

  bcv_parser.prototype.regexps.control = /[\x1e\x1f]/g;

  bcv_parser.prototype.regexps.pre_book = "[^A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ]";

  bcv_parser.prototype.regexps.first = "(?:1st|1|I|First)\\.?" + bcv_parser.prototype.regexps.space + "*";

  bcv_parser.prototype.regexps.second = "(?:2nd|2|II|Second)\\.?" + bcv_parser.prototype.regexps.space + "*";

  bcv_parser.prototype.regexps.third = "(?:3rd|3|III|Third)\\.?" + bcv_parser.prototype.regexps.space + "*";

  bcv_parser.prototype.regexps.range_and = "(?:[&\u2013\u2014-]|(?:and|compare|cf|see" + bcv_parser.prototype.regexps.space + "+also|also|see)|(?:through|thru|to))";

  bcv_parser.prototype.regexps.range_only = "(?:[\u2013\u2014-]|(?:through|thru|to))";

  bcv_parser.prototype.regexps.get_books = function(include_apocrypha, case_sensitive) {
    var book, books, k, len, out;
    books = [
      {
        osis: ["Ps"],
        apocrypha: true,
        extra: "2",
        regexp: /(\b)(Ps151)(?=\.1)/g
      }, {
        osis: ["Gen"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])((?:Б(?:у(?:т(?:тя)?|г)|(?:[иы]т(?:ие)?))|На(?:ч(?:ало)?|станување)|Doomettaabaa|창(?:세기?)?|ஆதி(?:யாகமம்)?|pīdāyiš|ﺗﻜﻮﻳﻦ|П(?:ерш[ае][\s\xa0]*книга[\s\xa0]*Мо(?:[ий]сеева)|ост(?:ање)?|рв(?:а[\s\xa0]*(?:Мојс(?:ијева)?|книга[\s\xa0]*Мојсеева)|о[\s\xa0]*книга[\s\xa0]*Мојсеева)|ърва[\s\xa0]*(?:Моисеева|книга[\s\xa0]*Моисеева))|Книга[\s\xa0]*Бытия|F(?:yrsta[\s\xa0]*(?:b[oó]k[\s\xa0]*M(?:[oó]se)|M[oó]seb(?:[oó]k))|(?:[oö]rsta[\s\xa0]*Mosebok(?:en)?)|ørste[\s\xa0]*Mos(?:ebo[gk])?|acerea)|Henesis|B(?:uttja|eresjiet|ilowgii)|utpat(?:ti(?:ko[\s\xa0]*pustak)?)?|M(?:wa(?:nzo)?|[oó]zes[\s\xa0]*I)|தொ(?:டக்க[\s\xa0]*நூல்|நூ)|ปฐ(?:มกาล|ก)|پ(?:يدائش|یدا[ئی]ش|َیدایش)|G(?:e(?:n(?:e(?:s(?:es?|us|[ai])|is(?:[eiu]s)?|es[eiu]s|z(?:is|a))|i(?:[ei]s(?:[eiu]s)|s[eiu]s)|èse|sis|n(?:e(?:is(?:[eiu]s)?|es[eiu]s|s[eiu]s)|i(?:[ei]s(?:[eiu]s)|s[eiu]s)|sis))?)?|n|é(?:n(?:esis)?)?|ên(?:esis)?)|בר(?:אשית|יאה)|Jen(?:[eè]z)?|ଆଦି(?:ପୁସ୍ତକ)?|[ĀA]tiy(?:[aā]kamam)|I(?:\.[\s\xa0]*(?:M(?:o(?:j(?:ž[ií](?:[sš]ova)|ż(?:eszowa)?|z(?:[ií](?:[sš]ova)|eszowa)?)|s(?:eb[oó]k)?|oseksen[\s\xa0]*kirja|zes)|ó(?:s(?:eb[oó]k)?|zes))|книга[\s\xa0]*Мо[ийј]сеева|kniha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova))|Мо(?:јс(?:ијева)?|исеева)|Ks(?:i[eę]g(?:[ai][\s\xa0]*Mo(?:j(?:[zż]eszowa|y[zż]eszowe)))|\.[\s\xa0]*Mo(?:j[zż]eszowa|y[zż]eszowe)|[\s\xa0]*Mo(?:j[zż]eszowa|y[zż]eszowe)))|[\s\xa0]*(?:M(?:o(?:j(?:ž[ií](?:[sš]ova)|ż(?:eszowa)?|z(?:[ií](?:[sš]ova)|eszowa)?)?|s(?:eb[oó]k)?|oseksen[\s\xa0]*kirja|zes)|ó(?:s(?:eb[oó]k)?|zes))|книга[\s\xa0]*Мо[ийј]сеева|kniha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova))|Мо(?:јс(?:ијева)?|исеева)|Ks(?:i[eę]g(?:[ai][\s\xa0]*Mo(?:j(?:[zż]eszowa|y[zż]eszowe)))|\.[\s\xa0]*Mo(?:j[zż]eszowa|y[zż]eszowe)|[\s\xa0]*Mo(?:j[zż]eszowa|y[zż]eszowe))))|1(?:Mós|[\s\xa0]*(?:M(?:z|ó(?:s(?:eb[oó]k)?|z(?:es)?)|o(?:j(?:ž[ií](?:[sš]ova)|ż(?:eszowa)?|z(?:[ií](?:[sš]ova)|eszowa)?)?|s(?:e(?:b(?:ók|o(?:g|k(?:en)?)))?)?|os(?:eksen[\s\xa0]*kirja)?|z(?:es)?)?)|k(?:[\s\xa0]*Moj[zž]i(?:[sš]ova)|niha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova))|\.[\s\xa0]*Moj[zž]i(?:[sš]ova))|книга[\s\xa0]*Мо[ийј]сеева|Buch[\s\xa0]*Mose|М(?:о(?:јс(?:ијева)?|исеева))?|Ks(?:i[eę]g(?:[ai][\s\xa0]*Mo(?:j(?:[zż]eszowa|y[zż]eszowe)))|\.[\s\xa0]*Mo(?:j[zż]eszowa|y[zż]eszowe)|[\s\xa0]*Mo(?:j[zż]eszowa|y[zż]eszowe)))|-?(?:[ае](?:\.[\s\xa0]*книга[\s\xa0]*Мо(?:[ий]сеева|[\s\xa0]*книга[\s\xa0]*Мо[ий]сеева))|ше(?:\.[\s\xa0]*книга[\s\xa0]*Мо[ий]сеева|[\s\xa0]*книга[\s\xa0]*Мо[ий]сеева))|e(?:\.[\s\xa0]*Mozes|[\s\xa0]*Mozes)|\.[\s\xa0]*(?:M(?:o(?:s(?:e(?:b(?:ók|o(?:g|k(?:en)?)))?)?|j(?:ž[ií](?:[sš]ova)|ż(?:eszowa)?|z(?:[ií](?:[sš]ova)|eszowa)?)|oseksen[\s\xa0]*kirja|zes)?|ó(?:s(?:eb[oó]k)?|zes))|книга[\s\xa0]*Мо[ийј]сеева|kniha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova))|Buch[\s\xa0]*Mose|Мо(?:јс(?:ијева)?|исеева)|Ks(?:i[eę]g(?:[ai][\s\xa0]*Mo(?:j(?:[zż]eszowa|y[zż]eszowe)))|\.[\s\xa0]*Mo(?:j[zż]eszowa|y[zż]eszowe)|[\s\xa0]*Mo(?:j[zż]eszowa|y[zż]eszowe))))|P(?:ierwsz(?:[aey][\s\xa0]*(?:Moj(?:[zż](?:eszowa)?)|Ks(?:i[eę]g(?:[ai][\s\xa0]*Mo(?:j(?:[zż]eszowa|y[zż]eszowe)))|\.[\s\xa0]*Mo(?:j[zż]eszowa|y[zż]eszowe)|[\s\xa0]*Mo(?:j[zż]eszowa|y[zż]eszowe))))|urwaning[\s\xa0]*Dumadi|rv(?:[aá][\s\xa0]*(?:Moj(?:[zž]i(?:[sš]ova)|kniha[\s\xa0]*Moj[zž]i(?:[sš]ova)))|[yý][\s\xa0]*(?:Moj(?:[zž]i(?:[sš]ova)|list[\s\xa0]*Moj[zž]i(?:[sš]ova)))|n[ií][\s\xa0]*(?:kniha[\s\xa0]*Moj(?:[zž](?:[ií](?:[sš]ova))|Moj[zž](?:[ií](?:[sš]ova)))))|ost(?:anak)?)|سفر[\s\xa0]*التكوين|Liber[\s\xa0]*Genesis|Ter(?:emt[eé]s)?|E(?:ls[oő][\s\xa0]*M(?:[oó]zes)|nsimm[aä]inen[\s\xa0]*Mooseksen[\s\xa0]*kirja|rste[\s\xa0]*(?:Mose|Buch[\s\xa0]*Mose)|erste[\s\xa0]*Mozes)|Utpaati|R(?:odz|dz)|Γ(?:ε(?:ν(?:εσ(?:η|ις))?)?|έν(?:εσ(?:η|ις))?)|《(?:創(?:世[紀記]》|》)|创(?:世记》|》))|liv[\s\xa0]*Konmansman[\s\xa0]*an|Zan(?:afilla)?|उत्प(?:त(?:्ति(?:को[\s\xa0]*पुस्तक)?|ि)|ाति)|K(?:[\s\xa0]*(?:p[oô]vodu|stvorenia)|itabu[\s\xa0]*cha[\s\xa0]*Kwanza[\s\xa0]*cha[\s\xa0]*Musa|s(?:i[eę]g(?:[ai][\s\xa0]*Rodzaju)|[\s\xa0]*Rodzaju|\.[\s\xa0]*Rodzaju)|\.[\s\xa0]*(?:p[oô]vodu|stvorenia)|n(?:jiga[\s\xa0]*Postanka|iha[\s\xa0]*(?:p[oô]vodu|stvorenia)))|ਉਤਪਤ|Sáng[\s\xa0]*thế[\s\xa0]*ký|تك)|(?:I(?:\.[\s\xa0]*Ksi[eę]g(?:[ai][\s\xa0]*Moy(?:[zż]eszowe))|[\s\xa0]*Ksi[eę]g(?:[ai][\s\xa0]*Moy(?:[zż]eszowe)))|P(?:rv(?:[aá][\s\xa0]*kniha[\s\xa0]*Moj(?:[zž]i(?:[sš]ova))|[yý][\s\xa0]*list[\s\xa0]*Moj(?:[zž]i(?:[sš]ova))|n[ií][\s\xa0]*Moj(?:[zž](?:[ií](?:[sš]ova))))|ierwsz[aey][\s\xa0]*Ksi(?:[eę]g(?:[ai][\s\xa0]*Moy(?:[zż]eszowe))))|1(?:\.[\s\xa0]*Ksi[eę]g(?:[ai][\s\xa0]*Moy(?:[zż]eszowe))|-?[ае][\s\xa0]*книга[\s\xa0]*Мо(?:[ий]сеева)|[\s\xa0]*Ksi[eę]g(?:[ai][\s\xa0]*Moy(?:[zż]eszowe))))|(?:उत्पत्तिको|Genesis|Sáng(?:[\s\xa0]*Thế)?|Konmansman|創(?:世[記紀]》?|》)?|(?:[I1](?:\.[\s\xa0]*Mooseksen|[\s\xa0]*Mooseksen))|《(?:创(?:世记)?|創(?:世[記紀])?)|utpattiko|التكوين|创(?:世记》?|》)?|Ensimm[aä]inen[\s\xa0]*Mooseksen))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["Exod"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])(Nirgaman|(?:nirgam|出エ[シジ](?:[フプ]ト記)|K(?:ut(?:oka)?|s(?:[\s\xa0]*Wyj[sś]cia|\.[\s\xa0]*Wyj[sś]cia|i[eę]g(?:[ai][\s\xa0]*Wyj(?:[sś]cia)))|njiga[\s\xa0]*Izlaska|ess(?:aabaa)?|i(?:v(?:onul[aá]s)?|tabu[\s\xa0]*cha[\s\xa0]*Pili[\s\xa0]*cha[\s\xa0]*Musa))|M(?:[aá]sodik[\s\xa0]*M(?:[oó]zes)|[oó]zes[\s\xa0]*II)|Xuất[\s\xa0]*(?:Hành|Ê-?díp-?tô[\s\xa0]*ký|Ai(?:-?cập|[\s\xa0]*Cập[\s\xa0]*Ký))|خ(?:ُرُوج|ر(?:وج)?)|kūč|Y[aā]ttir(?:[aā]kamam)|탈출기?|T(?:oinen[\s\xa0]*Mooseksen[\s\xa0]*kirja|weede[\s\xa0]*Mozes)|ਕੂਚ|निर्गमन?|Книга[\s\xa0]*Исход|อพยพ?|שמות|(?:[ÉÊ]x(?:o(?:do?)?|d)?)|[OÖ]nnur[\s\xa0]*(?:b(?:[oó]k[\s\xa0]*M(?:[oó]se)|M[oó]seb(?:[oó]k)))|prastʰ[aā]nko[\s\xa0]*pustak|Bax(?:niintii)?|2(?:[\s\xa0]*(?:Ks(?:[\s\xa0]*Moj[zż]eszowa|\.[\s\xa0]*Moj[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|M(?:z|ó(?:s(?:eb[oó]k)?|z(?:es)?)|o(?:j(?:ž[ií](?:[sš]ova)|ż(?:eszowa)?|z(?:[ií](?:[sš]ova)|eszowa)?)?|s(?:e(?:b(?:ók|o(?:g|k(?:en)?)))?)?|os(?:eksen[\s\xa0]*kirja)?|z(?:es)?)?)|k(?:[\s\xa0]*Moj[zž]i(?:[sš]ova)|niha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova))|\.[\s\xa0]*Moj[zž]i(?:[sš]ova))|книга[\s\xa0]*Мо[ийј]сеева|Buch[\s\xa0]*Mose|М(?:о(?:јс(?:ијева)?|исеева))?)|Mós|e(?:\.[\s\xa0]*Mozes|[\s\xa0]*Mozes)|-?(?:[ае](?:\.[\s\xa0]*книга[\s\xa0]*Мо(?:[ий]сеева|[\s\xa0]*книга[\s\xa0]*Мо[ий]сеева))|ге(?:\.[\s\xa0]*книга[\s\xa0]*Мо[ий]сеева|[\s\xa0]*книга[\s\xa0]*Мо[ий]сеева))|\.[\s\xa0]*(?:M(?:o(?:s(?:e(?:b(?:ók|o(?:g|k(?:en)?)))?)?|j(?:ž[ií](?:[sš]ova)|ż(?:eszowa)?|z(?:[ií](?:[sš]ova)|eszowa)?)|oseksen[\s\xa0]*kirja|zes)?|ó(?:s(?:eb[oó]k)?|zes))|Ks(?:[\s\xa0]*Moj[zż]eszowa|\.[\s\xa0]*Moj[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|книга[\s\xa0]*Мо[ийј]сеева|kniha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova))|Buch[\s\xa0]*Mose|Мо(?:јс(?:ијева)?|исеева)))|Sjemot|Liber[\s\xa0]*Exodus|I(?:zl(?:azak)?|I(?:[\s\xa0]*(?:M(?:o(?:j(?:ž[ií](?:[sš]ova)|ż(?:eszowa)?|z(?:[ií](?:[sš]ova)|eszowa)?)?|s(?:eb[oó]k)?|oseksen[\s\xa0]*kirja|zes)|ó(?:s(?:eb[oó]k)?|zes))|Ks(?:[\s\xa0]*Moj[zż]eszowa|\.[\s\xa0]*Moj[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|книга[\s\xa0]*Мо[ийј]сеева|kniha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova))|Мо(?:јс(?:ијева)?|исеева))|\.[\s\xa0]*(?:Ks(?:[\s\xa0]*Moj[zż]eszowa|\.[\s\xa0]*Moj[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|M(?:o(?:j(?:ž[ií](?:[sš]ova)|ż(?:eszowa)?|z(?:[ií](?:[sš]ova)|eszowa)?)|s(?:eb[oó]k)?|oseksen[\s\xa0]*kirja|zes)|ó(?:s(?:eb[oó]k)?|zes))|книга[\s\xa0]*Мо[ийј]сеева|kniha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova))|Мо(?:јс(?:ијева)?|исеева)))|e[sşș]irea)|Εξ(?:οδος)?|liv[\s\xa0]*delivrans[\s\xa0]*lan|Έξοδος|יציא(?:ה|ת[\s\xa0]*מצרים)|An(?:d(?:r(?:e[\s\xa0]*Mos(?:ebok)?|a[\s\xa0]*Mosebok(?:en)?)|en[\s\xa0]*Mos(?:ebog)?)|nen[\s\xa0]*Mosebok)|В(?:тор(?:о[\s\xa0]*книга[\s\xa0]*Мојсеева|а[\s\xa0]*(?:Моисеева|книга[\s\xa0]*Мо[иј]сеева))|их(?:ід)?)|سفر[\s\xa0]*الخروج|Zweite[\s\xa0]*(?:Mose|Buch[\s\xa0]*Mose)|யாத்(?:திராகமம்)?|Pangentasan|Друг(?:е[\s\xa0]*книга[\s\xa0]*Мо[ий]сеева|а[\s\xa0]*(?:Мојс(?:ијева)?|книга[\s\xa0]*Мо[ий]сеева))|출(?:애굽기)?|W(?:yj|j)|Ἔξ|《出(?:埃及(?:[記记]》|》)|谷紀》|》)|Vy[hȟ]id|D(?:al(?:ja)?|ru(?:h(?:[aá][\s\xa0]*(?:kniha[\s\xa0]*Moj(?:[zž](?:[ií](?:[sš]ova))|Moj[zž](?:[ií](?:[sš]ova))))|[yý][\s\xa0]*(?:list[\s\xa0]*Moj(?:[zž]i(?:[sš]ova)|kniha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova))|Moj[zž](?:[ií](?:[sš]ova)))))|g[ai][\s\xa0]*(?:Ks(?:[\s\xa0]*Moj(?:[zż]eszowa|\.[\s\xa0]*Moj[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|Moj(?:[zż](?:eszowa)?)))))|E(?:sodo|gz(?:od(?:us)?|òd)?|ks(?:od[io])?|x(?:o(?:d(?:ul|is|[eos])?)?|d)?|cs(?:odus)?)|ḫurūj|प्रस्थान(?:को[\s\xa0]*पुस्तक)?|வி(?:டுதலைப்[\s\xa0]*பயணம்|ப)|ଯାତ୍ରା(?:[\s\xa0]*ପୁସ୍ତକ|ପୁସ୍ତକ)|Егзодус|И(?:з(?:х(?:од)?|л(?:ез|азак)?)|сх))|(?:2-?[ае][\s\xa0]*книга[\s\xa0]*Мо(?:[ий]сеева)|[OÖ]nnur[\s\xa0]*M(?:[oó]seb(?:[oó]k))|Dru(?:h(?:[yý][\s\xa0]*(?:kniha[\s\xa0]*Moj(?:[zž](?:[ií](?:[sš]ova))|Moj[zž](?:[ií](?:[sš]ova))))|[aá][\s\xa0]*Moj(?:[zž](?:[ií](?:[sš]ova))))|g[ai][\s\xa0]*(?:Ks(?:\.[\s\xa0]*Moj(?:[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|Moj(?:[zż](?:eszowa)?)))))|Dru(?:g[ai][\s\xa0]*(?:Ksi(?:[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa))|Moj(?:[zż](?:eszowa)?)))|h[yý][\s\xa0]*Moj(?:[zž](?:[ií](?:[sš]ova))))|Drug(?:[ai][\s\xa0]*Moj(?:[zż](?:eszowa)?))|(?:Exodus|prastʰ[aā]nko|Исход|出(?:埃及(?:[记記]》?|》)?|谷紀》?|》)?|الخروج|ଯାତ୍ରା|II(?:\.[\s\xa0]*Mooseksen|[\s\xa0]*Mooseksen)|2(?:\.[\s\xa0]*Mooseksen|[\s\xa0]*Mooseksen)|Toinen[\s\xa0]*Mooseksen|《出(?:谷紀|埃及[记記]?)?|Delivrans|Xuất|प्रस्थानको))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["Bel"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:벨과[\\s\\xa0]*[뱀용]|Si[\\s\\xa0]*Bel[\\s\\xa0]*at[\\s\\xa0]*ang[\\s\\xa0]*Dragon|Histoia[\\s\\xa0]*Beli[\\s\\xa0]*et[\\s\\xa0]*draconis|התנין[\\s\\xa0]*בבבל|Β(?:ηλ[\\s\\xa0]*και[\\s\\xa0]*Δρ[άα]κων|ὴλ)|[ヘベ]ルと[竜龍]|Istoria[\\s\\xa0]*(?:omor[aâ]rii[\\s\\xa0]*balaurului[\\s\\xa0]*(?:[sş]i[\\s\\xa0]*a[\\s\\xa0]*sf(?:[aă]r(?:[aâ]m(?:[aă]rii[\\s\\xa0]*lui[\\s\\xa0]*Bel))))|Balaurului)|Бел(?:[\\s\\xa0]*(?:и[\\s\\xa0]*Дракон|і[\\s\\xa0]*дракон)|е)|Opowiadaniem[\\s\\xa0]*o[\\s\\xa0]*Belu[\\s\\xa0]*i[\\s\\xa0]*w[eę](?:[zż]u)|Danieli[\\s\\xa0]*na[\\s\\xa0]*Makuhani[\\s\\xa0]*wa[\\s\\xa0]*Beli|B(?:él[\\s\\xa0]*(?:[eé]s[\\s\\xa0]*a[\\s\\xa0]*s(?:[aá]rk(?:[aá]ny))|a[\\s\\xa0]*drak)|el(?:a[\\s\\xa0]*i[\\s\\xa0]*w[eę](?:[zż]a)|[\\s\\xa0]*(?:o(?:ch[\\s\\xa0]*Ormguden|g[\\s\\xa0]*dr(?:a(?:gen[\\s\\xa0]*i[\\s\\xa0]*Babylon|ken)|ekinn))|ja[\\s\\xa0]*lohik[aä](?:[aä]rme)|[sș]i[\\s\\xa0]*dragonul|und[\\s\\xa0]*Vom[\\s\\xa0]*Drachen|a(?:['’]r[\\s\\xa0]*Ddraig|[\\s\\xa0]*drak|nd[\\s\\xa0]*(?:S(?:erpent|nake)|Dragon|the[\\s\\xa0]*(?:S(?:erpent|nake)|Dragon)))|e(?:t[\\s\\xa0]*(?:le[\\s\\xa0]*(?:Dragon|Serpent)|draconis)|[\\s\\xa0]*(?:o[\\s\\xa0]*Drag[aã]o|il[\\s\\xa0]*Drago)|n[\\s\\xa0]*de[\\s\\xa0]*draak|s[\\s\\xa0]*a[\\s\\xa0]*s[aá]rk(?:[aá]ny))|y[\\s\\xa0]*el[\\s\\xa0]*(?:Serpiente|Drag[oó]n)|&[\\s\\xa0]*(?:S(?:erpent|nake)|Dragon|the[\\s\\xa0]*(?:S(?:erpent|nake)|Dragon))|és[\\s\\xa0]*a[\\s\\xa0]*s[aá]rk(?:[aá]ny)))|a[aá]l[\\s\\xa0]*(?:[eé]s[\\s\\xa0]*a[\\s\\xa0]*s(?:[aá]rk(?:[aá]ny))))|பேல்[\\s\\xa0]*தெய்வமும்[\\s\\xa0]*அரக்கப்பாம்பும்[\\s\\xa0]*என்பவையாகும்|بل[\\s\\xa0]*والتنين|《Bel》|Виле[\\s\\xa0]*и[\\s\\xa0]*драконе|בל[\\s\\xa0]*והדרקון)|(?:பேல்(?:[\\s\\xa0]*தெய்வமும்[\\s\\xa0]*அரக்கப்பாம்பும்)?|B(?:él|el(?:》|[\\s\\xa0]*(?:og[\\s\\xa0]*Dragen|at[\\s\\xa0]*ang[\\s\\xa0]*Dragon|e(?:[\\s\\xa0]*o[\\s\\xa0]*drag[ãa]o|t[\\s\\xa0]*le[\\s\\xa0]*(?:dragon|serpent))))?)|Бел|Βηλ|《Bel))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Phlm"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Φλμ|Waraka[\\s\\xa0]*kwa[\\s\\xa0]*Filemoni|ฟ(?:ีเลโมน|ม)|빌레몬서|フィレモン(?:書|への手紙)?|رسالة[\\s\\xa0]*بولس[\\s\\xa0]*الرسول[\\s\\xa0]*إلى[\\s\\xa0]*فليمون|பில(?:மோன(?:ுக்கு[\\s\\xa0]*எழுதிய[\\s\\xa0]*திருமுகம்|்)|ே(?:மோன(?:ுக்கு[\\s\\xa0]*எழுதிய[\\s\\xa0]*(?:நிருபம்|கடிதம்)|்))?)?|पौलाचे[\\s\\xa0]*फिलेमोनाला[\\s\\xa0]*पत्र|(?:[ヒピ]レモン(?:書|への(?:手紙|書)|ヘの手紙))|П(?:ослан(?:и(?:е[\\s\\xa0]*(?:к(?:ъм[\\s\\xa0]*Филимон|[\\s\\xa0]*Филимону)|на[\\s\\xa0]*св(?:\\.[\\s\\xa0]*ап(?:[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Филимона|\\.[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Филимона)|[\\s\\xa0]*ап(?:[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Филимона|\\.[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Филимона)))|ца[\\s\\xa0]*Филимону)|ня[\\s\\xa0]*(?:до[\\s\\xa0]*Фили(?:пі[ий]ців|мона)|апостола[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Филимона|св(?:[\\s\\xa0]*апостола[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Филимона|\\.[\\s\\xa0]*апостола[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Филимона)))|исмо[\\s\\xa0]*од[\\s\\xa0]*апостол[\\s\\xa0]*Павле[\\s\\xa0]*до[\\s\\xa0]*Филемон)|Προς[\\s\\xa0]*Φιλ[ήη]μονα|B(?:arua[\\s\\xa0]*kwa[\\s\\xa0]*Filemoni|r(?:e(?:f[\\s\\xa0]*P[aá]ls[\\s\\xa0]*til[\\s\\xa0]*F(?:[ií]lemons)|vet[\\s\\xa0]*til(?:l[\\s\\xa0]*Filemon|[\\s\\xa0]*Filemon))|éf[\\s\\xa0]*P[aá]ls[\\s\\xa0]*til[\\s\\xa0]*F(?:[ií]lemons)))|L(?:ist[\\s\\xa0]*(?:do[\\s\\xa0]*Filemona|Filem[oó]novi|(?:[sś]w(?:\\.[\\s\\xa0]*Pawła[\\s\\xa0]*do[\\s\\xa0]*Filemona|[\\s\\xa0]*Pawła[\\s\\xa0]*do[\\s\\xa0]*Filemona)))|ettera[\\s\\xa0]*a[\\s\\xa0]*Filemone)|P(?:a(?:ulus['’][\\s\\xa0]*Brev[\\s\\xa0]*til[\\s\\xa0]*Filemon|vlova[\\s\\xa0]*poslanica[\\s\\xa0]*Filemonu)|il(?:[eē]m(?:[oō](?:[nṉ]ukku[\\s\\xa0]*E(?:[lḻ]utiya[\\s\\xa0]*Nirupam)))|m|imoona)|oslannja[\\s\\xa0]*apostola[\\s\\xa0]*Pavla[\\s\\xa0]*do[\\s\\xa0]*Fylymona|h(?:mn?|i(?:l(?:[éê]mon|e(?:m(?:on(?:hoz)?)?)?)|-?lê-?môn)|l(?:[ei]mon|mn?)))|filēmōn[\\s\\xa0]*ke[\\s\\xa0]*nām[\\s\\xa0]*kā[\\s\\xa0]*ḫaṭ|ଫିଲୀମୋନଙ୍କ[\\s\\xa0]*ପ୍ରତି[\\s\\xa0]*ପତ୍ର|फ(?:ले|िलेमोन(?:ा|लाई[\\s\\xa0]*प(?:ावलको[\\s\\xa0]*पत्र|त्र))?)|필레(?:몬(?:에게[\\s\\xa0]*보낸[\\s\\xa0]*서간|서))?|ਫ(?:ਿਲੇਮੋਨ[\\s\\xa0]*ਨੂੰ[\\s\\xa0]*ਪੱਤ੍ਰੀ|਼ਿਲੇਮੋਨ[\\s\\xa0]*ਨੂੰ[\\s\\xa0]*ਪੱਤ੍ਰੀ)|אגרת[\\s\\xa0]*פולוס[\\s\\xa0]*אל-?פילימון|F(?:lmn?|mn?|i(?:l(?:im(?:on)?|em(?:o(?:n(?:brevet|it|hoz|sbr[eé]fið)|m))?|émon|èmone|m))?|íl(?:emonsbr[eé]fið|m))|الرسالة[\\s\\xa0]*إلى[\\s\\xa0]*فليمون|pʰilemon(?:l[aā](?:[iī][\\s\\xa0]*patra)|[aā]l(?:[aā][\\s\\xa0]*patra)|[\\s\\xa0]*nū̃[\\s\\xa0]*pattrī)|ف(?:ِلیمون[\\s\\xa0]*کے[\\s\\xa0]*نام[\\s\\xa0]*کا[\\s\\xa0]*خط|لیمون[\\s\\xa0]*کے[\\s\\xa0]*نام[\\s\\xa0]*(?:پولس[\\s\\xa0]*رسُول[\\s\\xa0]*کا[\\s\\xa0]*خط|کا[\\s\\xa0]*خط)|يل)?|Ф(?:лм|илим)|Epistula(?:[\\s\\xa0]*ad[\\s\\xa0]*Philemonem|m[\\s\\xa0]*ad[\\s\\xa0]*Philemonem)|《(?:[門门]》|腓利(?:門書》|门书》)|肥利孟》|費肋孟書》)|K(?:irje[\\s\\xa0]*Filemonille|a(?:y[\\s\\xa0]*Filemon|ng[\\s\\xa0]*Filem[oó]n))|האיגרת[\\s\\xa0]*אל[\\s\\xa0]*פילימון)|(?:אל[\\s\\xa0]*פילימון|फिलेमोन(?:ाला(?:[\\s\\xa0]*पत्र)?|लाई)|[门門]》?|腓利(?:門書》?|门书》?)|P(?:aulus’[\\s\\xa0]*brev[\\s\\xa0]*til[\\s\\xa0]*Filemon|oslanica[\\s\\xa0]*Filemonu|hi(?:-?lê|lemonem)|il[ēe]m(?:[oō](?:[nṉ]ukku)))|《(?:肥利孟|腓利(?:门书|門書)|[門门]|費肋孟書)|К[\\s\\xa0]*Филимону|ଫିଲୀମୋନଙ୍କ|pʰilemon(?:l[āa][īi]|[āa]l[aā])?|ਫ਼ਿਲੇਮੋਨ[\\s\\xa0]*ਨੂੰ|Filem(?:on(?:ovi|[aue]|i(?:lle)?)?|ón)|肥利孟》?|Φιλ[ηή]μονα|ad[\\s\\xa0]*Philemonem|Фил(?:имон[уа]?|емон)|До[\\s\\xa0]*Филимона|費肋孟書》?|ف(?:ِلیمون|ل[یي]مون)))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Lev"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])(Λευ[ιϊ]τ(?:ικ(?:[οό]ν?)?)|Λευ(?:[ιϊ]τ)|le(?:w[iī]y|v(?:ī(?:har[uū]ko[\s\xa0]*pustak|āṃ[\s\xa0]*dī[\s\xa0]*potʰī)|ihar[uū]ko[\s\xa0]*pustak))|(?:Þriðja[\s\xa0]*(?:b[oó]k[\s\xa0]*M(?:[oó]se)|M[oó]seb(?:[oó]k))|《(?:利(?:末记》|》|未[記记]》)|肋未紀》)|Лев(?:итска[\s\xa0]*книга)?|Harmadik[\s\xa0]*M[oó]zes|لا|ا(?:حبار|لأحبار)|ויקרא|Тре(?:т(?:а[\s\xa0]*книга[\s\xa0]*Мо[иј]сеева|[яє][\s\xa0]*книга[\s\xa0]*Мо(?:[ий]сеева)|о[\s\xa0]*Моисеева)|ћ(?:а[\s\xa0]*Мојс(?:ијева)?|ом[\s\xa0]*Мојс(?:ијева)?))|เลวีนิติ|أح|iḥbār|ﺍﻟﻼﻭﻳﻲ|ลนต|ल(?:ैव्य(?:्व्य्वस्था|व(?:्यवस्था?|स्था))?|ेव(?:ि|ी(?:हरूको[\s\xa0]*पुस्तक|य)?))|레(?:위기?)?|سفر[\s\xa0]*اللاويين|レ[ヒビ]記?|liv[\s\xa0]*Prensip[\s\xa0]*lavi[\s\xa0]*nan[\s\xa0]*Bondye|W(?:og(?:aabaa)?|a(?:jikra|l))|ଲେବୀୟ[\s\xa0]*ପୁସ୍ତକ|L(?:i(?:ber[\s\xa0]*Leviticus|v(?:[ei]t(?:cus|[ei]cus)))|é(?:v(?:itique)?)?|ê(?:[\s\xa0]*Vi|-?vi[\s\xa0]*ký)|e(?:f(?:iticus)?|b(?:iti(?:co|k(?:us|o)))?|v(?:i(?:t(?:cus|[aá]k|i(?:c(?:os?|u(?:si|l))?|que|k(?:us?|[eë]t)?)|ecus|ski[\s\xa0]*zakonik)|yar[aā]kamam)?|et(?:cus|[ei]cus)|yt|íticos?)?)?|a(?:a(?:ivyavyavastha|w(?:iyiintii)?)|w)|ēviyar[aā]kamam|v)|ਲੇਵੀਆਂ[\s\xa0]*ਦੀ[\s\xa0]*ਪੋਥੀ|III(?:\.[\s\xa0]*(?:книга[\s\xa0]*Мо[ий]сеева|Ks(?:[\s\xa0]*Moj[zż]eszowa|\.[\s\xa0]*Moj[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|M(?:o(?:j(?:ž[ií](?:[sš]ova)|ż(?:eszowa)?|z(?:[ií](?:[sš]ova)|eszowa)?)|s(?:eb[oó]k)?|oseksen[\s\xa0]*kirja|zes)|ó(?:s(?:eb[oó]k)?|zes))|kniha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova))|Мо(?:јс(?:ијева)?|исеева))|[\s\xa0]*(?:книга[\s\xa0]*Мо[ий]сеева|M(?:o(?:j(?:ž[ií](?:[sš]ova)|ż(?:eszowa)?|z(?:[ií](?:[sš]ova)|eszowa)?)?|s(?:eb[oó]k)?|oseksen[\s\xa0]*kirja|zes)|ó(?:s(?:eb[oó]k)?|zes))|Ks(?:[\s\xa0]*Moj[zż]eszowa|\.[\s\xa0]*Moj[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|kniha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova))|Мо(?:јс(?:ијева)?|исеева)))|Книга[\s\xa0]*Левит|Vajikra|Λευ?|T(?:r(?:e(?:dje[\s\xa0]*Mos(?:ebo(?:g|k(?:en)?))?|t(?:í[\s\xa0]*(?:kniha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova))|Moj[zž](?:[ií](?:[sš]ova)))|i(?:[\s\xa0]*(?:kniha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova))|Moj[zž](?:[ií](?:[sš]ova)))|a[\s\xa0]*(?:Moj[zž]i(?:[sš]ova)|kniha[\s\xa0]*Moj[zž]i(?:[sš]ova)))))|zeci(?:a[\s\xa0]*(?:Ks(?:[\s\xa0]*Moj[zż]eszowa|\.[\s\xa0]*Moj[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|Moj(?:[zż](?:eszowa)?))|[\s\xa0]*(?:Ks(?:[\s\xa0]*Moj[zż]eszowa|\.[\s\xa0]*Moj[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|Moj(?:[zż](?:eszowa)?))))|řet[ií][\s\xa0]*(?:kniha[\s\xa0]*Moj(?:[zž](?:[ií](?:[sš]ova))|Moj[zž](?:[ií](?:[sš]ova)))))|D(?:ritte[\s\xa0]*(?:Mose|Buch[\s\xa0]*Mose)|erde[\s\xa0]*Mozes)|K(?:a(?:imaman|p[lł])|s(?:\.[\s\xa0]*Kapła[nń]ska|i[eę]g(?:[ai][\s\xa0]*Kapła(?:[nń]ska))|[\s\xa0]*Kapła[nń]ska)|olmas[\s\xa0]*Mooseksen[\s\xa0]*kirja|itabu[\s\xa0]*cha[\s\xa0]*Tatu[\s\xa0]*cha[\s\xa0]*Musa|p[lł])|லேவி(?:யர(?:ாகமம்|்))?|3(?:Mós|-?(?:[ае](?:\.[\s\xa0]*книга[\s\xa0]*Мо(?:[ий]сеева|[\s\xa0]*книга[\s\xa0]*Мо[ий]сеева))|тє(?:\.[\s\xa0]*книга[\s\xa0]*Мо[ий]сеева|[\s\xa0]*книга[\s\xa0]*Мо[ий]сеева))|[\s\xa0]*(?:книга[\s\xa0]*Мо[ий]сеева|Ks(?:[\s\xa0]*Moj[zż]eszowa|\.[\s\xa0]*Moj[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|M(?:z|ó(?:s(?:eb[oó]k)?|z(?:es)?)|o(?:j(?:ž[ií](?:[sš]ova)|ż(?:eszowa)?|z(?:[ií](?:[sš]ova)|eszowa)?)?|s(?:e(?:b(?:ók|o(?:g|k(?:en)?)))?)?|os(?:eksen[\s\xa0]*kirja)?|z(?:es)?)?)|k(?:[\s\xa0]*Moj[zž]i(?:[sš]ova)|niha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova))|\.[\s\xa0]*Moj[zž]i(?:[sš]ova))|Buch[\s\xa0]*Mose|М(?:о(?:јс(?:ијева)?|исеева))?)|e(?:[\s\xa0]*Mo(?:sebok(?:en)?|zes)|\.[\s\xa0]*Mo(?:sebok(?:en)?|zes))|\.[\s\xa0]*(?:M(?:o(?:s(?:e(?:b(?:ók|o(?:g|k(?:en)?)))?)?|j(?:ž[ií](?:[sš]ova)|ż(?:eszowa)?|z(?:[ií](?:[sš]ova)|eszowa)?)|oseksen[\s\xa0]*kirja|zes)?|ó(?:s(?:eb[oó]k)?|zes))|книга[\s\xa0]*Мо[ий]сеева|Ks(?:[\s\xa0]*Moj[zż]eszowa|\.[\s\xa0]*Moj[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|kniha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova))|Buch[\s\xa0]*Mose|Мо(?:јс(?:ијева)?|исеева)))|M(?:ambo[\s\xa0]*ya[\s\xa0]*Walawi|[oó]zes[\s\xa0]*III)|ספר[\s\xa0]*הלוויים)|(?:3-?[ае][\s\xa0]*книга[\s\xa0]*Мо(?:[ий]сеева)|Třet[ií][\s\xa0]*Moj(?:[zž](?:[ií](?:[sš]ova))))|(?:lev(?:ihar[ūu]ko|ī(?:har[ūu]ko|āṃ))|लेवीहरूको|Левит(?:ска)?|L(?:eviticus|ê(?:-?vi)?)|Kolmas[\s\xa0]*Mooseksen|《(?:肋未紀|利(?:未[记記]|末记)?)|اللاويين|ਲੇਵੀਆਂ|肋未紀》?|3(?:\.[\s\xa0]*Mooseksen|[\s\xa0]*Mooseksen)|ଲେବୀୟ|III(?:\.[\s\xa0]*Mooseksen|[\s\xa0]*Mooseksen)|利(?:末记》?|》|未[记記]》?)|Walawi))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["2Thess"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])(2\.[\s\xa0]*Tessalonikerbrevet|(?:Druh[yý][\s\xa0]*Solun(?:(?:[cč]anom|sk[yý]m))|2(?:\.[\s\xa0]*tessalonikerbrev|[\s\xa0]*Tessalonikerbrevet))|(?:2[\s\xa0]*tessalonikerbrev|Druh[yý][\s\xa0]*list[\s\xa0]*Solun(?:(?:[cč]anom|sk[yý]m)))|(?:थिस्सलोनिकीहरूलाई[\s\xa0]*(?:पावलको[\s\xa0]*दोस्रो[\s\xa0]*पत्र|दोस्त्रो[\s\xa0]*पत्र)|And(?:e(?:n[\s\xa0]*T(?:essalonikerne|hess(?:alonikerbrev)?)|t[\s\xa0]*Thessalonikerbrev)|r(?:e[\s\xa0]*(?:tessalonikerbrev|Tess(?:aloniker(?:ne)?)?)|a[\s\xa0]*T(?:essalonikerbrevet|hessalonikerbrevet)))|האיגרת[\s\xa0]*השנייה[\s\xa0]*אל[\s\xa0]*התסלוניקים|テサロニケ(?:人への(?:第二の手紙|手紙二|後の書)|[\s\xa0]*2|後書|の信徒への手紙二)|M(?:[aá]sodik[\s\xa0]*T(?:essz(?:alonika(?:iakhoz)?)?|hessz(?:alonika(?:iakhoz)?)?))|I(?:kalawang[\s\xa0]*(?:Tesaloni(?:sense|c(?:ense|a)|ka)|Mga[\s\xa0]*T(?:aga(?:[\s\xa0]*Tesaloni[ck]a|-?[\s\xa0]*Tesaloni[ck]a)|esaloni[cs]ense))|I(?:\.[\s\xa0]*(?:Mga[\s\xa0]*T(?:aga(?:[\s\xa0]*Tesaloni[ck]a|-?[\s\xa0]*Tesaloni[ck]a)|esaloni[cs]ense)|List[\s\xa0]*(?:(?:[sś]w(?:[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tesaloniczan|\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tesaloniczan))|do[\s\xa0]*Tesaloniczan)|Сол(?:у(?:н(?:јани|ьці|ян|ци(?:те)?)|њанима))?|list[\s\xa0]*(?:Solu[nň]sk(?:[yý]m)|Tesalonick[yý]m)|T(?:e(?:s(?:aloni(?:ika|senses?|čanom|c(?:en(?:s(?:es?|[oó]w)|i)|a(?:nom)?|k[yý]m|zan)|k(?:a|yen)?)|s(?:z(?:alonika(?:iakhoz)?)?|aloni(?:ce(?:si|n(?:s(?:es|k[yý]m)|zen))|kalais(?:kirje|ille)))?)?)?|h(?:s(?:ss?)?|ê(?:xalônica|-?sa-?lô-?ni-?ca)|e(?:s(?:elon(?:ains|ians?)|olonians?|s(?:elon(?:ains|ians?)|oloni(?:ns|ans?)|z(?:alonika(?:iakhoz)?)?|s|al(?:lonians|on(?:eans|a(?:i(?:ns?|ans)|ns)|i(?:o(?:ns?|ans)|ns|ions|a(?:ns?|ans|id)|c(?:i[ae]ns|en(?:ses|zen)|ans)|ens)|o(?:ians|ans)|ciens)))?|al(?:lonians|oni(?:ians|c(?:iens|ans)|a(?:ns?|id)|ns|ons)))?)?)?|ê-?sa-?lô-?ni-?ca|èsalonika)|Wathesalonike|фессалонікі[ий]ців|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Солун|ослан(?:ня[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|ица[\s\xa0]*Солуњанима))|до[\s\xa0]*солунян|Þess|Sol(?:ún(?:skym|[cč]anom)|u(?:ňsk[yý]m|n(?:[cč]anom|janima[\s\xa0]*Poslanica|sk[yý]m)))?|Kirje[\s\xa0]*tessalonikalaisille)|[\s\xa0]*(?:Mga[\s\xa0]*T(?:aga(?:[\s\xa0]*Tesaloni[ck]a|-?[\s\xa0]*Tesaloni[ck]a)|esaloni[cs]ense)|List[\s\xa0]*(?:(?:[sś]w(?:[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tesaloniczan|\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tesaloniczan))|do[\s\xa0]*Tesaloniczan)|Сол(?:у(?:н(?:јани|ьці|ян|ци(?:те)?)|њанима))?|list[\s\xa0]*(?:Solu[nň]sk(?:[yý]m)|Tesalonick[yý]m)|T(?:e(?:s(?:aloni(?:ika|senses?|čanom|c(?:en(?:s(?:es?|[oó]w)|i)|a(?:nom)?|k[yý]m|zan)|k(?:a|yen)?)|s(?:z(?:alonika(?:iakhoz)?)?|aloni(?:ce(?:si|n(?:s(?:es|k[yý]m)|zen))|kalais(?:kirje|ille)))?)?)?|h(?:s(?:ss?)?|ê(?:xalônica|-?sa-?lô-?ni-?ca)|e(?:s(?:elon(?:ains|ians?)|olonians?|s(?:elon(?:ains|ians?)|oloni(?:ns|ans?)|z(?:alonika(?:iakhoz)?)?|s|al(?:lonians|on(?:eans|a(?:i(?:ns?|ans)|ns)|i(?:o(?:ns?|ans)|ns|ions|a(?:ns?|ans|id)|c(?:i[ae]ns|en(?:ses|zen)|ans)|ens)|o(?:ians|ans)|ciens)))?|al(?:lonians|oni(?:ians|c(?:iens|ans)|a(?:ns?|id)|ns|ons)))?)?)?|ê-?sa-?lô-?ni-?ca|èsalonika)|Wathesalonike|фессалонікі[ий]ців|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Солун|ослан(?:ня[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|ица[\s\xa0]*Солуњанима))|до[\s\xa0]*солунян|Þess|Sol(?:ún(?:skym|[cč]anom)|u(?:ňsk[yý]m|n(?:[cč]anom|janima[\s\xa0]*Poslanica|sk[yý]m)))?|Kirje[\s\xa0]*tessalonikalaisille)))|Wa(?:raka[\s\xa0]*wa[\s\xa0]*Pili[\s\xa0]*kwa[\s\xa0]*Wathesalonik[ei]|thesalonike[\s\xa0]*II)|पौलाचे[\s\xa0]*थेस्सलनीकाकरांस[\s\xa0]*दुसरे[\s\xa0]*पत्र|Zweite[\s\xa0]*Thessalonicher|Προς[\s\xa0]*Θεσσαλονικε[ίι]ς[\s\xa0]*Β['ʹʹ΄’]|ଦ୍ୱିତୀୟ[\s\xa0]*ଥେସଲନୀକୀୟଙ|데살로니가[2후]서|Втор(?:о[\s\xa0]*(?:п(?:ослание[\s\xa0]*(?:към[\s\xa0]*солунците|на[\s\xa0]*св(?:[\s\xa0]*ап(?:\.[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Солуняни|[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Солуняни)|\.[\s\xa0]*ап(?:\.[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Солуняни|[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Солуняни)))|исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Солун)|Солун(?:јани|ците))|а[\s\xa0]*(?:Сол(?:ун(?:јани|ци(?:те)?))?|писмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Солун))|தெசலோனிக்க(?:ேயருக்கு[\s\xa0]*எழுதிய[\s\xa0]*இரண்டாம்[\s\xa0]*கடிதம்|ருக்கு[\s\xa0]*எழுதிய[\s\xa0]*இரண்டா(?:வது[\s\xa0]*திருமுகம்|ம்[\s\xa0]*திருமுகம்)|ியருக்கு[\s\xa0]*எழுதிய[\s\xa0]*இரண்டாவது[\s\xa0]*நிருபம்)|S(?:e(?:cond(?:[\s\xa0]*Th(?:s(?:ss?)?|es(?:elon(?:ains|ians?)|olonians?|al(?:oni(?:[ci]ans|ns|ans?|ons)|lonians)|s(?:al(?:on(?:eans|a(?:i(?:ns?|ans)|ns)|o(?:ians|ans)|i(?:(?:[ao](?:ns?|ans))|ns|ions|ens|c(?:i[ae]ns|ans))|ciens)|lonians)|elon(?:ains|ians?)|oloni(?:ns|ans?)|s)?)?)?|a[\s\xa0]*(?:lettera[\s\xa0]*ai[\s\xa0]*Tessalonicesi|Tessalonicesi)|o[\s\xa0]*Tessalonicesi)|gund(?:a[\s\xa0]*Tessalonicenses|o[\s\xa0]*Tes(?:salonicenses|aloni[cs]enses?)))|[ií]ðara[\s\xa0]*(?:br(?:[eé]f[\s\xa0]*P(?:[aá]ls[\s\xa0]*til[\s\xa0]*Þess(?:alon(?:[ií]kumanna)?))|Þessalon[ií]kubr(?:[eé]f))))|الرسالة[\s\xa0]*الثانية[\s\xa0]*إلى[\s\xa0]*أهل[\s\xa0]*تسالونيكي|Epistula[\s\xa0]*(?:ad[\s\xa0]*Thessalonicenses[\s\xa0]*II|II[\s\xa0]*ad[\s\xa0]*Thessalonicenses)|D(?:e(?:uxi(?:[eè]me(?:[\s\xa0]*Thes(?:aloniciens|saloniciens)|s[\s\xa0]*Thes(?:aloniciens|saloniciens)))|zy(?:[eè]m[\s\xa0]*Tesalonik(?:yen)?))|ru(?:g(?:a[\s\xa0]*(?:List[\s\xa0]*(?:(?:[sś]w(?:[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tesaloniczan|\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tesaloniczan))|do[\s\xa0]*Tesaloniczan)|Solunjanima[\s\xa0]*Poslanica|Tesalonic(?:ens[oó]w|zan))|i[\s\xa0]*(?:List[\s\xa0]*(?:(?:[sś]w(?:[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tesaloniczan|\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tesaloniczan))|do[\s\xa0]*Tesaloniczan)|Tesalonic(?:ens[oó]w|zan)))|h(?:e[\s\xa0]*poslannja[\s\xa0]*apostola[\s\xa0]*Pavla[\s\xa0]*do[\s\xa0]*solunjan|(?:[yý][\s\xa0]*(?:Sol(?:ún(?:skym|[cč]anom)|uňsk[yý]m)?|list[\s\xa0]*(?:Sol(?:ún(?:skym|[cč]anom)|uňsk[yý]m)|Tesaloni(?:čanom|c(?:anom|k[yý]m)))|Te(?:s(?:aloni(?:čanom|c(?:anom|k[yý]m))|salonicensk[yý]m))?))|(?:[aá][\s\xa0]*(?:kniha[\s\xa0]*(?:Sol(?:[uú]n(?:skym|[cč]anom))|Tesaloni(?:čanom|c(?:anom|k[yý]m)))|list[\s\xa0]*(?:Solu[nň]sk(?:[yý]m)|Tesalonick[yý]m)|Sol(?:u(?:ňsk[yý]m|n(?:[cč]anom|sk[yý]m))|ún(?:skym|[cč]anom))?|Te(?:s(?:aloni(?:čanom|c(?:anom|k[yý]m))|salonicensk[yý]m))?)))))|دوم(?:-?تھِسّلُنیکیوں|۔تھسلنیکیوں|[\s\xa0]*تھ(?:س(?:لنیکوں|ّلنیکیوں)|ِسلُنیکیوں))|אגרת[\s\xa0]*פולוס[\s\xa0]*השנייה[\s\xa0]*אל-?התסלונ|۲(?:-?تھِسّلُنیکیوں|۔تھسلنیکیوں|[\s\xa0]*تھ(?:س(?:لنیکوں|ّلنیکیوں)|ِسلُنیکیوں))|رسالة[\s\xa0]*(?:تسالونيكي[\s\xa0]*الثانية|بولس[\s\xa0]*الرسول[\s\xa0]*الثانية[\s\xa0]*إلى[\s\xa0]*أهل[\s\xa0]*تسالونيكي)|تھ(?:سلنیک(?:وں[\s\xa0]*کے[\s\xa0]*نام[\s\xa0]*پو[\s\xa0]*لس[\s\xa0]*رسول[\s\xa0]*کادوسرا[\s\xa0]*خط|یوں[\s\xa0]*کے[\s\xa0]*نام[\s\xa0]*کا[\s\xa0]*دوسرا[\s\xa0]*خط)|ِسّلُنیکیوں[\s\xa0]*کے[\s\xa0]*نام[\s\xa0]*کا[\s\xa0]*دوسرا[\s\xa0]*خط)|P(?:ili[\s\xa0]*(?:Th(?:es?)?|Wathesalonike)|a(?:ulus(?:'[\s\xa0]*Andet[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Thessalonikerne|’[\s\xa0]*(?:Andet[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Thessalonikerne|andre[\s\xa0]*brev[\s\xa0]*til[\s\xa0]*tessalonikerne))|vlova[\s\xa0]*druga[\s\xa0]*poslanica[\s\xa0]*Solunjanima))|T(?:oinen[\s\xa0]*(?:Tessalonikalais(?:kirje|ille)|Kirje[\s\xa0]*tessalonikalaisille)|weede[\s\xa0]*T(?:es(?:s(?:alonicenzen)?)?|hess(?:alonicenzen)?)|e(?:soloniika[\s\xa0]*Labaad|cal[oō](?:[nṉ]ikkiyarukku[\s\xa0]*E(?:[lḻ]utiya[\s\xa0]*Ira(?:[nṇ](?:[tṭ](?:[aā]vatu[\s\xa0]*Nirupam)))))))|2(?:-?(?:تھِسّلُنیکیوں|а(?:\.[\s\xa0]*(?:послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|Солун(?:ьці|ян)|фессалонікі[ий]ців|до[\s\xa0]*солунян)|[\s\xa0]*(?:послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|Солун(?:ьці|ян)|фессалонікі[ий]ців|до[\s\xa0]*солунян))|я(?:[\s\xa0]*(?:к[\s\xa0]*Фессалоники[ий]цам|Фессалоники[ий]цам)|\.[\s\xa0]*(?:к[\s\xa0]*Фессалоники[ий]цам|Фессалоники[ий]цам))|е(?:[\s\xa0]*(?:послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|Солун(?:ьці|ян)|фессалонікі[ий]ців|к[\s\xa0]*Фессалоники[ий]цам|до[\s\xa0]*солунян|Фессалоники[ий]цам)|\.[\s\xa0]*(?:послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|Солун(?:ьці|ян)|фессалонікі[ий]ців|к[\s\xa0]*Фессалоники[ий]цам|до[\s\xa0]*солунян|Фессалоники[ий]цам))|ге(?:\.[\s\xa0]*(?:послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|Солун(?:ьці|ян)|фессалонікі[ий]ців|до[\s\xa0]*солунян)|[\s\xa0]*(?:послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|Солун(?:ьці|ян)|фессалонікі[ий]ців|до[\s\xa0]*солунян)))|e(?:\.[\s\xa0]*T(?:es(?:s(?:alonicenzen)?)?|hes(?:s(?:alonic(?:iens|enzen))?|aloniciens))|me(?:[\s\xa0]*Thes(?:aloniciens|saloniciens)|\.[\s\xa0]*Thes(?:aloniciens|saloniciens))|[\s\xa0]*T(?:es(?:s(?:alonicenzen)?)?|hes(?:s(?:alonic(?:iens|enzen))?|aloniciens)))|\.(?:[\s\xa0]*(?:List[\s\xa0]*(?:(?:[sś]w(?:[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tesaloniczan|\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tesaloniczan))|do[\s\xa0]*Tesaloniczan)|تھ(?:س(?:لنیکوں|ّلنیکیوں)|ِسلُنیکیوں)|Сол(?:у(?:н(?:јани|ьці|ян|ци(?:те)?)|њанима))?|list[\s\xa0]*(?:Solu[nň]sk(?:[yý]m)|Tesalonick[yý]m)|Mga[\s\xa0]*T(?:aga(?:[\s\xa0]*Tesaloni[ck]a|-?(?:[\s\xa0]*Tesaloni[ck]a|Tesal[oó]ni(?:[ck]a)))|esaloni[cs]ense)|tʰissalonik[iī]har(?:[uū]l(?:[aā][iī]))|थिस(?:्स(?:ल(?:ुनीकियों|ोनिकी(?:हरूलाई)?))?|लुनिकी)|T(?:e(?:s(?:s(?:z(?:alonika(?:iakhoz)?)?|aloni(?:k(?:er(?:ne)?|alais(?:kirje|ille))|ce(?:si|n(?:s(?:es|k[yý]m)|zen))))?|al(?:óni[ck]a|oni(?:ika|senses?|čanom|c(?:en(?:s(?:es?|[oó]w)|i)|a(?:nom)?|k[yý]m|zan)|k(?:a|yen)?)))?)?|ê-?sa-?lô-?ni-?ca|h(?:s(?:ss?)?|ê(?:xalônica|-?sa-?lô-?ni-?ca)|aissaluneekiyon|e(?:s(?:s(?:al(?:lonians|on(?:eans|a(?:i(?:ns?|ans)|ns)|i(?:o(?:ns?|ans)|c(?:i[ae]ns|her|en(?:ses|zen)|ans)|ns|ions|a(?:ns?|ans|id)|kerbrev(?:et)?|ens)|o(?:ians|ans)|ciens))|elon(?:ains|ians?)|oloni(?:ns|ans?)|z(?:alonika(?:iakhoz)?)?|s)?|elon(?:ains|ians?)|olonians?|al(?:lonians|oni(?:ians|c(?:iens|ans)|a(?:ns?|id)|ns|kasve|ons)))?)?)?|èsalonika|aga-?Tesal[oó]ni(?:[ck]a))|Wathesalonike|фессалонікі[ий]ців|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Солун|ослан(?:ня[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|ица[\s\xa0]*Солуњанима))|к[\s\xa0]*Фессалоники[ий]цам|S(?:elanikasve|ol(?:ún(?:skym|[cč]anom)|u(?:ňsk[yý]m|n(?:[cč]anom|janima[\s\xa0]*Poslanica|sk[yý]m)))?)|до[\s\xa0]*солунян|Þess|เธ[ซส]ะโลนิกา|Kirje[\s\xa0]*tessalonikalaisille|ଥେସଲନୀକୀୟଙ|Фессалоники[ий]цам)|-?تھِسّلُنیکیوں|[oº](?:\.[\s\xa0]*Tesaloni(?:[cs]enses?|[\s\xa0]*Tesaloni[cs]enses?))|۔تھسلنیکیوں)|nd(?:[\s\xa0]*Th(?:s(?:ss?)?|es(?:elon(?:ains|ians?)|olonians?|al(?:oni(?:[ci]ans|ns|ans?|ons)|lonians)|s(?:al(?:on(?:eans|a(?:i(?:ns?|ans)|ns)|o(?:ians|ans)|i(?:(?:[ao](?:ns?|ans))|ns|ions|ens|c(?:i[ae]ns|ans))|ciens)|lonians)|elon(?:ains|ians?)|oloni(?:ns|ans?)|s)?)?)?|\.[\s\xa0]*Th(?:s(?:ss?)?|es(?:elon(?:ains|ians?)|olonians?|al(?:oni(?:[ci]ans|ns|ans?|ons)|lonians)|s(?:al(?:on(?:eans|a(?:i(?:ns?|ans)|ns)|o(?:ians|ans)|i(?:(?:[ao](?:ns?|ans))|ns|ions|ens|c(?:i[ae]ns|ans))|ciens)|lonians)|elon(?:ains|ians?)|oloni(?:ns|ans?)|s)?)?)?)|d(?:[\s\xa0]*Thes(?:aloniciens|saloniciens)|e(?:[\s\xa0]*Thes(?:aloniciens|saloniciens)|\.[\s\xa0]*Thes(?:aloniciens|saloniciens))|\.[\s\xa0]*Thes(?:aloniciens|saloniciens))|o(?:[\s\xa0]*Tes(?:salonicenses|aloni[cs]enses?)|\.[\s\xa0]*Tes(?:salonicenses|aloni[cs]enses?))|°(?:\.[\s\xa0]*Tessalonicesi|[\s\xa0]*Tessalonicesi)|테살|Thess|[яе](?:[\s\xa0]*(?:к[\s\xa0]*Фессалоники(?:[ий]цам|Фессалоники[ий]цам)|\.[\s\xa0]*(?:к[\s\xa0]*Фессалоники[ий]цам|Фессалоники[ий]цам)))|º(?:\.[\s\xa0]*Tesaloni[cs]enses?|[\s\xa0]*Tesaloni[cs]enses?)|ème(?:[\s\xa0]*Thes(?:aloniciens|saloniciens)|\.[\s\xa0]*Thes(?:aloniciens|saloniciens))|a(?:[\s\xa0]*Tessalonicenses|\.[\s\xa0]*Tessalonicenses)|[\s\xa0]*(?:List[\s\xa0]*(?:(?:[sś]w(?:[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tesaloniczan|\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tesaloniczan))|do[\s\xa0]*Tesaloniczan)|தெச(?:லோ(?:னிக்க(?:ர்|ேயர்))?)?|ธส|Сол(?:у(?:н(?:јани|ьці|ян|ци(?:те)?)|њанима))?|list[\s\xa0]*(?:Solu[nň]sk(?:[yý]m)|Tesalonick[yý]m)|Mga[\s\xa0]*T(?:aga(?:[\s\xa0]*Tesaloni[ck]a|-?(?:[\s\xa0]*Tesaloni[ck]a|Tesal[oó]ni(?:[ck]a)))|esaloni[cs]ense)|tʰ(?:issalonik[iī]har(?:[uū]l(?:[aā][iī]))|assalunīkīāṃ|essalan[iī]k(?:[aā]kar(?:[aā](?:[mṃ]s))))|Wathesalonike|фессалонікі[ий]ців|k(?:\.[\s\xa0]*(?:Sol(?:[uú]n(?:skym|[cč]anom))|Tesaloni(?:čanom|c(?:anom|k[yý]m)))|[\s\xa0]*(?:Sol(?:[uú]n(?:skym|[cč]anom))|Tesaloni(?:čanom|c(?:anom|k[yý]m))))|(?:[ei](?:\.[\s\xa0]*(?:Thesalonikasve|Selanikasve)|[\s\xa0]*(?:Thesalonikasve|Selanikasve)))|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Солун|ослан(?:ня[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|ица[\s\xa0]*Солуњанима))|T(?:ê-?sa-?lô-?ni-?ca|h(?:s(?:ss?)?|ê(?:xalônica|-?sa-?lô-?ni-?ca)|aissaluneekiyon|e(?:s(?:s(?:al(?:lonians|on(?:eans|a(?:i(?:ns?|ans)|ns)|i(?:o(?:ns?|ans)|c(?:i[ae]ns|her|en(?:ses|zen)|ans)|ns|ions|a(?:ns?|ans|id)|kerbrev(?:et)?|ens)|o(?:ians|ans)|ciens))|elon(?:ains|ians?)|oloni(?:ns|ans?)|z(?:alonika(?:iakhoz)?)?|s)?|elon(?:ains|ians?)|olonians?|al(?:lonians|oni(?:ians|c(?:iens|ans)|a(?:ns?|id)|ns|kasve|ons)))?)?)?|a(?:ga-?Tesal[oó]ni(?:[ck]a)|s)|èsalonika|s|e(?:s(?:s(?:z(?:alonika(?:iakhoz)?)?|aloni(?:k(?:er(?:ne)?|alais(?:kirje|ille))|ce(?:si|n(?:s(?:es|k[yý]m)|zen))))?|al(?:óni[ck]a|oni(?:ika|senses?|čanom|c(?:en(?:s(?:es?|[oó]w)|i)|a(?:nom)?|k[yý]m|zan)|k(?:a|yen)?)))?|cal[oō](?:[nṉ]ikkiyarukku))?)|थ(?:ेस्सलनीकाकरांस|िस(?:्स(?:ल(?:ुनीकियों|ोनिकी(?:हरूलाई)?))?|लुनिकी))|к[\s\xa0]*Фессалоники[ий]цам|S(?:elanikasve|ol(?:ún(?:skym|[cč]anom)|u(?:ňsk[yý]m|n(?:[cč]anom|janima[\s\xa0]*Poslanica|sk[yý]m)))?)|до[\s\xa0]*солунян|ت(?:ھ(?:س(?:لنیکوں|ّلنیکیوں)|ِسلُنیکیوں)|س)|Þess|เธ[ซส]ะโลนิกา|Kirje[\s\xa0]*tessalonikalaisille|ਥੱਸਲੁਨੀਕੀਆਂ[\s\xa0]*ਨੂੰ|ଥେସଲନୀକୀୟଙ|Фес(?:салоники[ий]цам)?)|۔تھسلنیکیوں)|tʰ(?:essalan[iī]k(?:[aā]kar(?:[aā](?:[mṃ]s[\s\xa0]*dusre[\s\xa0]*patra)))|assalunīkīāṃ[\s\xa0]*nū̃[\s\xa0]*dūjī[\s\xa0]*pattrī|issal(?:onik[iī]har(?:[uū]l(?:[aā](?:[iī][\s\xa0]*dostro[\s\xa0]*patra)))|unīkiyōṅ[\s\xa0]*ke[\s\xa0]*nām[\s\xa0]*kā[\s\xa0]*dūsrā[\s\xa0]*ḫaṭ))|Barua[\s\xa0]*ya[\s\xa0]*Pili[\s\xa0]*kwa[\s\xa0]*Wathesalonike|테살로니카(?:[\s\xa0]*신자들에게[\s\xa0]*보낸[\s\xa0]*둘째[\s\xa0]*서간|2서)|ଥେସଲନୀକୀୟଙ୍କ[\s\xa0]*ପ୍ରତି[\s\xa0]*ଦ୍ୱିତୀୟ[\s\xa0]*ପତ୍ର|Naa77antto[\s\xa0]*Tasalonqqe|《(?:莎倫後》|帖(?:[后後]》|撒(?:罗尼迦后书》|羅尼迦後書》))|得撒洛尼後書》)|ﺍﻟﺜﺎﻧﻴﺔ[\s\xa0]*ﺗﺴﺎﻟﻮﻧﻴﻜﻲ|Β['ʹʹ΄’][\s\xa0]*Θε(?:σ(?:σαλονικε(?:[ίι]ς)?)?)|Друг(?:а[\s\xa0]*(?:Солу(?:н(?:ьці|ян)|њанима)|фессалонікі[ий]ців|до[\s\xa0]*солунян|послан(?:ня[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|ица[\s\xa0]*Солуњанима))|е[\s\xa0]*(?:послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|Солун(?:ьці|ян)|фессалонікі[ий]ців|до[\s\xa0]*солунян))|ਥੱਸਲੁਨੀਕੀਆਂ[\s\xa0]*ਨੂੰ[\s\xa0]*ਦੂਜੀ[\s\xa0]*ਪੱਤ੍ਰੀ)|(?:2(?:\.[oº][\s\xa0]*Tesaloni(?:[cs]enses?)|[ея](?:[\s\xa0]*Фессалоники(?:[ий]цам|\.[\s\xa0]*(?:к[\s\xa0]*Фессалоники[ий]цам|Фессалоники[ий]цам))))|S[ií]ðara[\s\xa0]*(?:br(?:[eé]f[\s\xa0]*P(?:[aá]ls[\s\xa0]*til[\s\xa0]*Þess)|Þessalon[ií]kubr(?:[eé]f)))|Β['ʹʹ΄’][\s\xa0]*Θε)|(?:S[ií]ðara[\s\xa0]*Þessalon(?:[ií]kubr(?:[eé]f))|2[ея]\.[\s\xa0]*(?:к[\s\xa0]*Фессалоники(?:[ий]цам|Фессалоники[ий]цам)))|2[ея]\.[\s\xa0]*Фессалоники(?:[ий]цам)|(?:ad[\s\xa0]*Thessalonicenses[\s\xa0]*II|得撒洛尼後書》?|Druga[\s\xa0]*(?:Solunjanima|poslanica[\s\xa0]*Solunjanima)|2(?:\.[\s\xa0]*(?:Solunjanima|Tê)|[\s\xa0]*(?:Solunjanima|Tê))|帖(?:[后後]》?|撒(?:罗尼迦后书》?|羅尼迦後書》?))|Thessalonicenses[\s\xa0]*II|השנייה[\s\xa0]*אל[\s\xa0]*התסלוניקים|II(?:\.[\s\xa0]*(?:Solunjanima|Tê)|[\s\xa0]*(?:Solunjanima|Tê))|थेस्सलनीकाकरांस[\s\xa0]*दुसरे[\s\xa0]*पत्र|《(?:莎倫後|帖(?:撒(?:羅尼迦後書|罗尼迦后书)|[後后])|得撒洛尼後書)|莎倫後》?))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["1Thess"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])(1\.[\s\xa0]*Tessalonikerbrevet|(?:Første[\s\xa0]*tessalonikerbrev|Prvn[ií][\s\xa0]*Tesalonick(?:[yý]m)|1(?:\.[\s\xa0]*tessalonikerbrev|[\s\xa0]*Tessalonikerbrevet))|(?:1[\s\xa0]*tessalonikerbrev|Prvn[ií][\s\xa0]*list[\s\xa0]*Tesalonick(?:[yý]m))|(?:데살로니가[1전]서|1(?:e(?:r(?:[\s\xa0]*Thes(?:aloniciens|saloniciens)|e(?:[\s\xa0]*Thes(?:aloniciens|saloniciens)|\.[\s\xa0]*Thes(?:aloniciens|saloniciens))|\.[\s\xa0]*Thes(?:aloniciens|saloniciens))|\.[\s\xa0]*T(?:es(?:s(?:alonicenzen)?)?|hess(?:alonicenzen)?)|[\s\xa0]*T(?:es(?:s(?:alonicenzen)?)?|hess(?:alonicenzen)?))|o(?:[\s\xa0]*Tes(?:salonicenses|aloni[cs]enses?)|\.[\s\xa0]*Tes(?:salonicenses|aloni[cs]enses?))|°(?:\.[\s\xa0]*Tessalonicesi|[\s\xa0]*Tessalonicesi)|테살|\.(?:-?تھِسّلُنیکیوں|[oº](?:\.[\s\xa0]*Tesaloni(?:[cs]enses?|[\s\xa0]*Tesaloni[cs]enses?))|۔تھسلنیکیوں|[\s\xa0]*(?:List[\s\xa0]*(?:(?:[sś]w(?:[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tesaloniczan|\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tesaloniczan))|do[\s\xa0]*Tesaloniczan)|Сол(?:у(?:н(?:јани|ьці|ян|ци(?:те)?)|њанима))?|list[\s\xa0]*(?:Solu[nň]sk(?:[yý]m)|Tesalonick[yý]m)|Mga[\s\xa0]*T(?:aga(?:[\s\xa0]*Tesaloni[ck]a|-?(?:[\s\xa0]*Tesaloni[ck]a|Tesal[oó]ni(?:[ck]a)))|esaloni[cs]ense)|tʰissalonik[iī]har(?:[uū]l(?:[aā][iī]))|تھ(?:سّلنیکیوں|ِسلُنیکیوں)|थिस(?:्स(?:ल(?:ुनीकियों|ोनिकी(?:हरूलाई)?))?|लुनिकी)|T(?:e(?:s(?:s(?:z(?:alonika(?:iakhoz)?)?|aloni(?:k(?:er(?:ne)?|alais(?:kirje|ille))|ce(?:si|n(?:s(?:es|k[yý]m)|zen))))?|al(?:óni[ck]a|oni(?:ika|senses?|čanom|c(?:en(?:s(?:es?|[oó]w)|i)|a(?:nom)?|k[yý]m|zan)|k(?:a|yen)?)))?)?|ê-?sa-?lô-?ni-?ca|h(?:s(?:ss?)?|ê(?:xalônica|-?sa-?lô-?ni-?ca)|aissaluneekiyon|e(?:s(?:s(?:al(?:lonians|on(?:eans|a(?:i(?:ns?|ans)|ns)|i(?:o(?:ns?|ans)|c(?:i[ae]ns|her|en(?:ses|zen)|ans)|ns|ions|a(?:ns?|ans|id)|kerbrev(?:et)?|ens)|o(?:ians|ans)|ciens))|elon(?:ains|ians?)|oloni(?:ns|ans?)|z(?:alonika(?:iakhoz)?)?|s)?|elon(?:ains|ians?)|olonians?|al(?:lonians|oni(?:ians|c(?:iens|ans)|a(?:ns?|id)|ns|kasve|ons)))?)?)?|èsalonika|aga-?Tesal[oó]ni(?:[ck]a))|Wathesalonike|фессалонікі[ий]ців|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Солун|ослан(?:ня[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|ица[\s\xa0]*Солуњанима))|к[\s\xa0]*Фессалоники[ий]цам|S(?:elanikasve|ol(?:ún(?:skym|[cč]anom)|u(?:ňsk[yý]m|n(?:[cč]anom|janima[\s\xa0]*Poslanica|sk[yý]m)))?)|до[\s\xa0]*солунян|Þess|เธ[ซส]ะโลนิกา|Kirje[\s\xa0]*tessalonikalaisille|ଥେସଲନୀକୀୟଙ|Фессалоники[ий]цам))|Thess|[яе](?:[\s\xa0]*(?:к[\s\xa0]*Фессалоники(?:[ий]цам|Фессалоники[ий]цам)|\.[\s\xa0]*(?:к[\s\xa0]*Фессалоники[ий]цам|Фессалоники[ий]цам)))|[\s\xa0]*(?:List[\s\xa0]*(?:(?:[sś]w(?:[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tesaloniczan|\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tesaloniczan))|do[\s\xa0]*Tesaloniczan)|தெச(?:லோ(?:னிக்க(?:ர்|ேயர்))?)?|ธส|Сол(?:у(?:н(?:јани|ьці|ян|ци(?:те)?)|њанима))?|list[\s\xa0]*(?:Solu[nň]sk(?:[yý]m)|Tesalonick[yý]m)|Mga[\s\xa0]*T(?:aga(?:[\s\xa0]*Tesaloni[ck]a|-?(?:[\s\xa0]*Tesaloni[ck]a|Tesal[oó]ni(?:[ck]a)))|esaloni[cs]ense)|tʰ(?:issalonik[iī]har(?:[uū]l(?:[aā][iī]))|assalunīkīāṃ|essalan[iī]k(?:[aā]kar(?:[aā](?:[mṃ]s))))|Wathesalonike|фессалонікі[ий]ців|k(?:\.[\s\xa0]*(?:Sol(?:[uú]n(?:skym|[cč]anom))|Tesaloni(?:čanom|c(?:anom|k[yý]m)))|[\s\xa0]*(?:Sol(?:[uú]n(?:skym|[cč]anom))|Tesaloni(?:čanom|c(?:anom|k[yý]m))))|(?:[ei](?:\.[\s\xa0]*(?:Thesalonikasve|Selanikasve)|[\s\xa0]*(?:Thesalonikasve|Selanikasve)))|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Солун|ослан(?:ня[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|ица[\s\xa0]*Солуњанима))|T(?:ê-?sa-?lô-?ni-?ca|h(?:s(?:ss?)?|ê(?:xalônica|-?sa-?lô-?ni-?ca)|aissaluneekiyon|e(?:s(?:s(?:al(?:lonians|on(?:eans|a(?:i(?:ns?|ans)|ns)|i(?:o(?:ns?|ans)|c(?:i[ae]ns|her|en(?:ses|zen)|ans)|ns|ions|a(?:ns?|ans|id)|kerbrev(?:et)?|ens)|o(?:ians|ans)|ciens))|elon(?:ains|ians?)|oloni(?:ns|ans?)|z(?:alonika(?:iakhoz)?)?|s)?|elon(?:ains|ians?)|olonians?|al(?:lonians|oni(?:ians|c(?:iens|ans)|a(?:ns?|id)|ns|kasve|ons)))?)?)?|a(?:ga-?Tesal[oó]ni(?:[ck]a)|s)|èsalonika|s|e(?:s(?:s(?:z(?:alonika(?:iakhoz)?)?|aloni(?:k(?:er(?:ne)?|alais(?:kirje|ille))|ce(?:si|n(?:s(?:es|k[yý]m)|zen))))?|al(?:óni[ck]a|oni(?:ika|senses?|čanom|c(?:en(?:s(?:es?|[oó]w)|i)|a(?:nom)?|k[yý]m|zan)|k(?:a|yen)?)))?|cal[oō](?:[nṉ]ikkiyarukku))?)|थ(?:ेस्सलनीकाकरांस|िस(?:्स(?:ल(?:ुनीकियों|ोनिकी(?:हरूलाई)?))?|लुनिकी))|к[\s\xa0]*Фессалоники[ий]цам|S(?:elanikasve|ol(?:ún(?:skym|[cč]anom)|u(?:ňsk[yý]m|n(?:[cč]anom|janima[\s\xa0]*Poslanica|sk[yý]m)))?)|до[\s\xa0]*солунян|Þess|เธ[ซส]ะโลนิกา|Kirje[\s\xa0]*tessalonikalaisille|ਥੱਸਲੁਨੀਕੀਆਂ[\s\xa0]*ਨੂੰ|ଥେସଲନୀକୀୟଙ|Фес(?:салоники[ий]цам)?|ت(?:ھ(?:سّلنیکیوں|ِسلُنیکیوں)|س))|º(?:\.[\s\xa0]*Tesaloni[cs]enses?|[\s\xa0]*Tesaloni[cs]enses?)|re(?:[\s\xa0]*Thes(?:aloniciens|saloniciens)|\.[\s\xa0]*Thes(?:aloniciens|saloniciens))|a(?:[\s\xa0]*Tessalonicenses|\.[\s\xa0]*Tessalonicenses)|ère(?:[\s\xa0]*Thes(?:aloniciens|saloniciens)|\.[\s\xa0]*Thes(?:aloniciens|saloniciens))|st(?:[\s\xa0]*Th(?:s(?:ss?)?|es(?:elon(?:ains|ians?)|olonians?|al(?:oni(?:[ci]ans|ns|ans?|ons)|lonians)|s(?:al(?:on(?:eans|a(?:i(?:ns?|ans)|ns)|o(?:ians|ans)|i(?:(?:[ao](?:ns?|ans))|ns|ions|ens|c(?:i[ae]ns|ans))|ciens)|lonians)|elon(?:ains|ians?)|oloni(?:ns|ans?)|s)?)?)?|\.[\s\xa0]*Th(?:s(?:ss?)?|es(?:elon(?:ains|ians?)|olonians?|al(?:oni(?:[ci]ans|ns|ans?|ons)|lonians)|s(?:al(?:on(?:eans|a(?:i(?:ns?|ans)|ns)|o(?:ians|ans)|i(?:(?:[ao](?:ns?|ans))|ns|ions|ens|c(?:i[ae]ns|ans))|ciens)|lonians)|elon(?:ains|ians?)|oloni(?:ns|ans?)|s)?)?)?)|-?(?:تھِسّلُنیکیوں|а(?:\.[\s\xa0]*(?:послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|Солун(?:ьці|ян)|фессалонікі[ий]ців|до[\s\xa0]*солунян)|[\s\xa0]*(?:послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|Солун(?:ьці|ян)|фессалонікі[ий]ців|до[\s\xa0]*солунян))|я(?:[\s\xa0]*(?:к[\s\xa0]*Фессалоники[ий]цам|Фессалоники[ий]цам)|\.[\s\xa0]*(?:к[\s\xa0]*Фессалоники[ий]цам|Фессалоники[ий]цам))|е(?:[\s\xa0]*(?:послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|Солун(?:ьці|ян)|фессалонікі[ий]ців|к[\s\xa0]*Фессалоники[ий]цам|до[\s\xa0]*солунян|Фессалоники[ий]цам)|\.[\s\xa0]*(?:послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|Солун(?:ьці|ян)|фессалонікі[ий]ців|к[\s\xa0]*Фессалоники[ий]цам|до[\s\xa0]*солунян|Фессалоники[ий]цам))|ше(?:\.[\s\xa0]*(?:послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|Солун(?:ьці|ян)|фессалонікі[ий]ців|до[\s\xa0]*солунян)|[\s\xa0]*(?:послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|Солун(?:ьці|ян)|фессалонікі[ий]ців|до[\s\xa0]*солунян)))|۔تھسلنیکیوں)|थिस्सलोनिकीहरूलाई[\s\xa0]*प(?:हिलो[\s\xa0]*पत्र|ावलको[\s\xa0]*पहिलो[\s\xa0]*पत्र)|האיגרת[\s\xa0]*הראשונה[\s\xa0]*אל[\s\xa0]*התסלוניקים|Te(?:soloniika[\s\xa0]*Kowaad|cal[oō](?:[nṉ]ikkiyarukku[\s\xa0]*E(?:[lḻ]utiya[\s\xa0]*Mutal(?:[aā]vatu[\s\xa0]*Nirupam))))|தெசலோனிக்க(?:ியருக்கு[\s\xa0]*எழுதிய[\s\xa0]*முதலாவது[\s\xa0]*நிருபம்|ேயருக்கு[\s\xa0]*எழுதிய[\s\xa0]*முதலாம்[\s\xa0]*கடிதம்|ருக்கு[\s\xa0]*எழுதிய[\s\xa0]*முதல்[\s\xa0]*திருமுகம்)|《(?:帖(?:前》|撒(?:羅尼迦前書》|罗尼迦前书》))|得撒洛尼前書》|莎倫前》)|पौलाचे[\s\xa0]*थेस्सलनीकाकरांस[\s\xa0]*पहिले[\s\xa0]*पत्र|ପ୍ରଥମ[\s\xa0]*ଥେସଲନୀକୀୟଙ|Wa(?:thesalonike[\s\xa0]*I|raka[\s\xa0]*wa[\s\xa0]*Kwanza[\s\xa0]*kwa[\s\xa0]*Wathesalonik[ei])|E(?:rste[\s\xa0]*Thessalonicher|erste[\s\xa0]*T(?:es(?:s(?:alonicenzen)?)?|hess(?:alonicenzen)?)|nsimm(?:[aä]inen[\s\xa0]*(?:Tessalonikalais(?:kirje|ille)|Kirje[\s\xa0]*tessalonikalaisille))|ls(?:[oő][\s\xa0]*T(?:essz(?:alonika(?:iakhoz)?)?|hessz(?:alonika(?:iakhoz)?)?))|pistula[\s\xa0]*(?:ad[\s\xa0]*Thessalonicenses[\s\xa0]*I|I[\s\xa0]*ad[\s\xa0]*Thessalonicenses))|ਥ(?:ਸੱਲੁਨੀਕੀਆਂ[\s\xa0]*ਨੂੰ[\s\xa0]*ਪਹਿਲੀ[\s\xa0]*ਪੱਤ੍ਰੀ|ੱਸਲੁਨੀਕੀਆਂ[\s\xa0]*ਨੂੰ[\s\xa0]*ਪਹਿਲੀ[\s\xa0]*ਪੱਤ੍ਰੀ)|ا(?:لرسالة[\s\xa0]*الأولى[\s\xa0]*إلى[\s\xa0]*أهل[\s\xa0]*تسالونيكي|وّل(?:-?تھِسّلُنیکیوں|[\s\xa0]*تھ(?:سّلنیکیوں|ِسلُنیکیوں)|۔تھسلنیکیوں))|رسالة[\s\xa0]*(?:بولس[\s\xa0]*الرسول[\s\xa0]*الأولى[\s\xa0]*إلى[\s\xa0]*أهل[\s\xa0]*تسالونيكي|تسالونيكي[\s\xa0]*الأولى)|F(?:ørste[\s\xa0]*T(?:ess(?:aloniker(?:ne)?)?|hess(?:alonikerbrev)?)|irst[\s\xa0]*Th(?:s(?:ss?)?|es(?:elon(?:ains|ians?)|olonians?|al(?:oni(?:[ci]ans|ns|ans?|ons)|lonians)|s(?:al(?:on(?:eans|a(?:i(?:ns?|ans)|ns)|o(?:ians|ans)|i(?:(?:[ao](?:ns?|ans))|ns|ions|ens|c(?:i[ae]ns|ans))|ciens)|lonians)|elon(?:ains|ians?)|oloni(?:ns|ans?)|s)?)?)?|yrra[\s\xa0]*(?:br[eé]f[\s\xa0]*P(?:[aá]ls[\s\xa0]*til[\s\xa0]*Þessa(?:lon(?:[ií]kumanna)?))|Þessalon[ií]kubr(?:[eé]f))|(?:[oö]rsta[\s\xa0]*T(?:essalonikerbrevet|hessalonikerbrevet)))|ଥେସଲନୀକୀୟଙ୍କ[\s\xa0]*ପ୍ରତି[\s\xa0]*ପ୍ରଥମ[\s\xa0]*ପତ୍ର|P(?:r(?:im(?:a[\s\xa0]*(?:lettera[\s\xa0]*ai[\s\xa0]*Tessalonicesi|Tessalonicesi)|e(?:ir[ao][\s\xa0]*Tessalonicenses|r(?:o[\s\xa0]*Tesaloni[cs]enses?|[\s\xa0]*Tesaloni[cs]enses?))|o[\s\xa0]*Tessalonicesi)|v(?:á[\s\xa0]*(?:kniha[\s\xa0]*(?:Sol(?:[uú]n(?:skym|[cč]anom))|Tesaloni(?:čanom|c(?:anom|k[yý]m)))|Sol(?:[uú]n(?:skym|[cč]anom))|Tesaloni(?:čanom|c(?:anom|k[yý]m)))|(?:[yý][\s\xa0]*(?:list[\s\xa0]*(?:Sol(?:[uú]n(?:skym|[cč]anom))|Tesaloni(?:čanom|c(?:anom|k[yý]m)))|Sol(?:[uú]n(?:skym|[cč]anom))|Tesaloni(?:čanom|c(?:anom|k[yý]m))))|a[\s\xa0]*(?:Sol(?:ún(?:skym|[cč]anom)|un(?:skym|[cč]anom|janima[\s\xa0]*Poslanica))|kniha[\s\xa0]*(?:Sol(?:[uú]n(?:skym|[cč]anom))|Tesaloni(?:čanom|c(?:anom|k[yý]m)))|Tesaloni(?:čanom|c(?:anom|k[yý]m)))|n[ií][\s\xa0]*(?:list[\s\xa0]*Solu(?:[nň]sk(?:[yý]m)|Te(?:ssalonicensk[yý]m)?|Sol(?:u[nň]sk(?:[yý]m))?)))|em(?:i(?:ère(?:[\s\xa0]*Thes(?:aloniciens|saloniciens)|s[\s\xa0]*Thes(?:aloniciens|saloniciens))|er(?:[\s\xa0]*Thes(?:aloniciens|saloniciens)|e(?:[\s\xa0]*Thes(?:aloniciens|saloniciens)|s[\s\xa0]*Thes(?:aloniciens|saloniciens))|s[\s\xa0]*Thes(?:aloniciens|saloniciens)))|ye[\s\xa0]*Tesalonik(?:yen)?))|a(?:ulus(?:'[\s\xa0]*(?:Første[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Thessalonikerne|1(?:[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Thessalonikerne|\.[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Thessalonikerne))|’[\s\xa0]*(?:Første[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Thessalonikerne|første[\s\xa0]*brev[\s\xa0]*til[\s\xa0]*tessalonikerne|1(?:[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Thessalonikerne|\.[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Thessalonikerne)))|vlova[\s\xa0]*prva[\s\xa0]*poslanica[\s\xa0]*Solunjanima)|ierwsz(?:[aey][\s\xa0]*(?:List[\s\xa0]*(?:(?:[sś]w(?:[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tesaloniczan|\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tesaloniczan))|do[\s\xa0]*Tesaloniczan)|Tesalonic(?:ens[oó]w|zan)))|er[sš]e[\s\xa0]*poslannja[\s\xa0]*apostola[\s\xa0]*Pavla[\s\xa0]*do[\s\xa0]*solunjan)|테살로니카(?:[\s\xa0]*신자들에게[\s\xa0]*보낸[\s\xa0]*첫째[\s\xa0]*서간|1서)|I(?:\.[\s\xa0]*(?:Mga[\s\xa0]*T(?:aga(?:[\s\xa0]*Tesaloni[ck]a|-?[\s\xa0]*Tesaloni[ck]a)|esaloni[cs]ense)|List[\s\xa0]*(?:(?:[sś]w(?:[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tesaloniczan|\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tesaloniczan))|do[\s\xa0]*Tesaloniczan)|Сол(?:у(?:н(?:јани|ьці|ян|ци(?:те)?)|њанима))?|list[\s\xa0]*(?:Solu[nň]sk(?:[yý]m)|Tesalonick[yý]m)|T(?:e(?:s(?:aloni(?:ika|senses?|čanom|c(?:en(?:s(?:es?|[oó]w)|i)|a(?:nom)?|k[yý]m|zan)|k(?:a|yen)?)|s(?:z(?:alonika(?:iakhoz)?)?|aloni(?:ce(?:si|n(?:s(?:es|k[yý]m)|zen))|kalais(?:kirje|ille)))?)?)?|h(?:s(?:ss?)?|ê(?:xalônica|-?sa-?lô-?ni-?ca)|e(?:s(?:elon(?:ains|ians?)|olonians?|s(?:elon(?:ains|ians?)|oloni(?:ns|ans?)|z(?:alonika(?:iakhoz)?)?|s|al(?:lonians|on(?:eans|a(?:i(?:ns?|ans)|ns)|i(?:o(?:ns?|ans)|ns|ions|a(?:ns?|ans|id)|c(?:i[ae]ns|en(?:ses|zen)|ans)|ens)|o(?:ians|ans)|ciens)))?|al(?:lonians|oni(?:ians|c(?:iens|ans)|a(?:ns?|id)|ns|ons)))?)?)?|ê-?sa-?lô-?ni-?ca|èsalonika)|Wathesalonike|фессалонікі[ий]ців|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Солун|ослан(?:ня[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|ица[\s\xa0]*Солуњанима))|до[\s\xa0]*солунян|Þess|Sol(?:ún(?:skym|[cč]anom)|u(?:ňsk[yý]m|n(?:[cč]anom|janima[\s\xa0]*Poslanica|sk[yý]m)))?|Kirje[\s\xa0]*tessalonikalaisille)|[\s\xa0]*(?:Mga[\s\xa0]*T(?:aga(?:[\s\xa0]*Tesaloni[ck]a|-?[\s\xa0]*Tesaloni[ck]a)|esaloni[cs]ense)|List[\s\xa0]*(?:(?:[sś]w(?:[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tesaloniczan|\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tesaloniczan))|do[\s\xa0]*Tesaloniczan)|Сол(?:у(?:н(?:јани|ьці|ян|ци(?:те)?)|њанима))?|list[\s\xa0]*(?:Solu[nň]sk(?:[yý]m)|Tesalonick[yý]m)|T(?:e(?:s(?:aloni(?:ika|senses?|čanom|c(?:en(?:s(?:es?|[oó]w)|i)|a(?:nom)?|k[yý]m|zan)|k(?:a|yen)?)|s(?:z(?:alonika(?:iakhoz)?)?|aloni(?:ce(?:si|n(?:s(?:es|k[yý]m)|zen))|kalais(?:kirje|ille)))?)?)?|h(?:s(?:ss?)?|ê(?:xalônica|-?sa-?lô-?ni-?ca)|e(?:s(?:elon(?:ains|ians?)|olonians?|s(?:elon(?:ains|ians?)|oloni(?:ns|ans?)|z(?:alonika(?:iakhoz)?)?|s|al(?:lonians|on(?:eans|a(?:i(?:ns?|ans)|ns)|i(?:o(?:ns?|ans)|ns|ions|a(?:ns?|ans|id)|c(?:i[ae]ns|en(?:ses|zen)|ans)|ens)|o(?:ians|ans)|ciens)))?|al(?:lonians|oni(?:ians|c(?:iens|ans)|a(?:ns?|id)|ns|ons)))?)?)?|ê-?sa-?lô-?ni-?ca|èsalonika)|Wathesalonike|фессалонікі[ий]ців|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Солун|ослан(?:ня[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|ица[\s\xa0]*Солуњанима))|до[\s\xa0]*солунян|Þess|Sol(?:ún(?:skym|[cč]anom)|u(?:ňsk[yý]m|n(?:[cč]anom|janima[\s\xa0]*Poslanica|sk[yý]m)))?|Kirje[\s\xa0]*tessalonikalaisille))|tʰ(?:assalunīkīāṃ[\s\xa0]*nū̃[\s\xa0]*pahilī[\s\xa0]*pattrī|essalan[iī]k(?:[aā]kar(?:[aā](?:[mṃ]s[\s\xa0]*pahile[\s\xa0]*patra)))|issal(?:unīkiyōṅ[\s\xa0]*ke[\s\xa0]*nām[\s\xa0]*kā[\s\xa0]*pahlā[\s\xa0]*ḫaṭ|onik[iī]har(?:[uū]l(?:[aā](?:[iī][\s\xa0]*pahilo[\s\xa0]*patra)))))|テサロニケ(?:の信徒への手紙一|[\s\xa0]*1|人への(?:前の書|手紙一|第一の手紙)|前書)|K(?:oiro[\s\xa0]*Tasalonqqe|wanza[\s\xa0]*(?:Th(?:es?)?|Wathesalonike))|Προς[\s\xa0]*Θεσσαλονικε[ίι]ς[\s\xa0]*Α['ʹʹ΄’]|ﺍﻻﻭﻝ[\s\xa0]*ﺗﺴﺎﻟﻮﻧﻴﻜﻲ|Barua[\s\xa0]*ya[\s\xa0]*Kwanza[\s\xa0]*kwa[\s\xa0]*Wathesalonike|۱(?:-?تھِسّلُنیکیوں|[\s\xa0]*تھ(?:سّلنیکیوں|ِسلُنیکیوں)|۔تھسلنیکیوں)|Α['ʹʹ΄’][\s\xa0]*Θε(?:σ(?:σαλονικε(?:[ίι]ς)?)?)|Una(?:[\s\xa0]*(?:Tesaloni(?:sense|c(?:ense|a)|ka)|Mga[\s\xa0]*T(?:aga(?:[\s\xa0]*Tesaloni[ck]a|-?[\s\xa0]*Tesaloni[ck]a)|esaloni[cs]ense))|ng[\s\xa0]*(?:Tesaloni(?:sense|c(?:ense|a)|ka)|Mga[\s\xa0]*T(?:aga(?:[\s\xa0]*Tesaloni[ck]a|-?[\s\xa0]*Tesaloni[ck]a)|esaloni[cs]ense)))|П(?:ърв(?:о[\s\xa0]*послание[\s\xa0]*(?:към[\s\xa0]*солунците|на[\s\xa0]*св(?:[\s\xa0]*ап(?:\.[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Солуняни|[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Солуняни)|\.[\s\xa0]*ап(?:\.[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Солуняни|[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Солуняни)))|а[\s\xa0]*Сол(?:унци(?:те)?)?)|ерш(?:[ае][\s\xa0]*(?:послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|до[\s\xa0]*(?:фессалонікі[ий]ців|с(?:алонікі[ий]ців|олунян))|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*солунян))|Солун(?:ьці|ян)|фессалонікі[ий]ців|до[\s\xa0]*солунян))|рв(?:а[\s\xa0]*(?:п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Солун|осланица[\s\xa0]*Солуњанима)|Солу(?:н(?:јани|ците)|њанима))|о[\s\xa0]*(?:писмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Солун|Солун(?:јани|ците))))|אגרת[\s\xa0]*פולוס[\s\xa0]*הראשונה[\s\xa0]*אל-?התסלו|تھ(?:ِسّلُنیکیوں[\s\xa0]*کے[\s\xa0]*نام[\s\xa0]*کا[\s\xa0]*پہلا[\s\xa0]*خط|س(?:ّلنیکیوں[\s\xa0]*کے[\s\xa0]*نام[\s\xa0]*پولس[\s\xa0]*رسول[\s\xa0]*کا[\s\xa0]*پہلا[\s\xa0]*خط|لنیکیوں[\s\xa0]*کے[\s\xa0]*نام[\s\xa0]*کا[\s\xa0]*پہلا[\s\xa0]*خط)))|(?:1(?:\.[oº][\s\xa0]*Tesaloni(?:[cs]enses?)|[ея](?:[\s\xa0]*Фессалоники(?:[ий]цам|\.[\s\xa0]*(?:к[\s\xa0]*Фессалоники[ий]цам|Фессалоники[ий]цам))))|Fyrra[\s\xa0]*br[eé]f[\s\xa0]*P(?:[aá]ls[\s\xa0]*til[\s\xa0]*Þessa)|Prvn[ií][\s\xa0]*(?:Te(?:ssalonicensk(?:[yý]m)?|Sol(?:u[nň]sk(?:[yý]m))?))|Α['ʹʹ΄’][\s\xa0]*Θε)|(?:Prvn[ií][\s\xa0]*(?:Sol(?:u(?:[nň]sk(?:[yý]m))?|Te))|1[ея]\.[\s\xa0]*(?:к[\s\xa0]*Фессалоники(?:[ий]цам|Фессалоники[ий]цам)))|(?:Prvn(?:[ií][\s\xa0]*(?:Sol|Te))|1[ея]\.[\s\xa0]*Фессалоники(?:[ий]цам))|(?:莎倫前》?|Thes(?:elon(?:ains|ians?)|olonians?|al(?:oni(?:[ci]ans|ns|ans?|ons)|lonians)|s(?:elon(?:ains|ians?)|oloni(?:ns|ans?)|al(?:lonians|on(?:eans|a(?:i(?:ns?|ans)|ns)|o(?:ians|ans)|i(?:(?:[ao](?:ns?|ans))|c(?:i[ea]ns|enses[\s\xa0]*I|ans)|ns|ions)|ciens))))|Prva[\s\xa0]*(?:Solunjanima|poslanica[\s\xa0]*Solunjanima)|(?:[1I](?:\.[\s\xa0]*(?:Solunjanima|Tê)|[\s\xa0]*(?:Solunjanima|Tê)))|थेस्सलनीकाकरांस[\s\xa0]*पहिले[\s\xa0]*पत्र|הראשונה[\s\xa0]*אל[\s\xa0]*התסלוניקים|ad[\s\xa0]*Thessalonicenses[\s\xa0]*I|帖(?:前》?|撒(?:羅尼迦前書》?|罗尼迦前书》?))|得撒洛尼前書》?|《(?:莎倫前|帖(?:撒(?:罗尼迦前书|羅尼迦前書)|前)|得撒洛尼前書)))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["2Kgs"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])(2(?:\.[\s\xa0]*kniha[\s\xa0]*kr[aá]lovsk[aá]|[\s\xa0]*r(?:ā(?:jiāṃ|ǳ(?:[aā]har(?:[uū]ko)|e))|aǳ(?:[aā]har(?:[uū]ko)|e)))|(?:δυτικ[οό]ς[\s\xa0]*Βασιλ(?:[έε]ων[\s\xa0]*Β['ʹʹ΄’])|Regum[\s\xa0]*II|M(?:[aá]sodik[\s\xa0]*Kir(?:[aá]lyok)?)|दुसरे[\s\xa0]*राजे|Quart[ao][\s\xa0]*Reinos|《(?:王下》|列王[紀纪记]下》)|ରାଜାବଳୀର[\s\xa0]*ଦ୍ୱିତୀୟ[\s\xa0]*ପୁସ୍ତକ|Boqorradii[\s\xa0]*Labaad|Втор(?:[ао][\s\xa0]*(?:Цареви|книга[\s\xa0]*за[\s\xa0]*царевите))|Четв(?:рта[\s\xa0]*краљев(?:има|ства)|ърта[\s\xa0]*(?:книга[\s\xa0]*Царства|Цар(?:е|ства)|Книга[\s\xa0]*на[\s\xa0]*царете)|ерта[\s\xa0]*Царів)|ଦ୍ୱିତୀୟ[\s\xa0]*ରାଜାବଳୀର?|D(?:e(?:uxi(?:[eè]me(?:[\s\xa0]*Rois|s[\s\xa0]*Rois))|zy(?:[eè]m[\s\xa0]*(?:Wa|liv[\s\xa0]*Wa[\s\xa0]*yo)))|ru(?:g(?:a[\s\xa0]*(?:knjiga[\s\xa0]*o[\s\xa0]*Kraljevima|K(?:s(?:\.[\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w))|[\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w))|i(?:[eę]g(?:[ai][\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w)))))|r(?:[oó]lewska|aljevima)))|i[\s\xa0]*K(?:s(?:\.[\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w))|[\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w))|i(?:[eę]g(?:[ai][\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w)))))|r[oó]lewska))|h(?:[yý][\s\xa0]*(?:kniha[\s\xa0]*kr(?:[aá]lovsk[aá]|list[\s\xa0]*Kr[aá](?:[lľ]ov)|Kr(?:[aá](?:l(?:ov(?:sk[aá])?)?|ľov))?))|[aá][\s\xa0]*(?:kniha[\s\xa0]*(?:kr(?:[aá]lovsk[aá]|Kr[aá](?:[lľ]ov))|Kr(?:[aá](?:l(?:ov(?:sk[aá])?)?|ľov))?)))))|F(?:ourth[\s\xa0]*Kingdoms|jerde[\s\xa0]*Kongerigernes[\s\xa0]*Bog)|2(?:d(?:e(?:[\s\xa0]*Rois|\.[\s\xa0]*Rois)|[\s\xa0]*Rois|\.[\s\xa0]*Rois)|\.(?:-?سلاطِین|(?:[oº](?:[\s\xa0]*Reyes|\.[\s\xa0]*Reyes))|۔سلاطین|[\s\xa0]*(?:سلاطین|พ(?:กษ|งศ์กษัตริย์)|ରାଜାବଳୀର?|о[\s\xa0]*царевима|M(?:bret[eë]rve|ga[\s\xa0]*Hari)|[IÎ]mp(?:[aă]ra(?:[tţ]i)?)|R(?:aja|e(?:is|yes|g(?:um|i)?)|ois)|K(?:s(?:\.[\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w))|[\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w))|i(?:[eę]g(?:[ai][\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w)))))|ön(?:ige)?|o(?:enige|n(?:g(?:ebo[gk])?|ungaboken|i(?:ngen|ge))?)|n(?:gs?|s)?|gs?|i(?:r(?:[aá]lyok)?|n(?:gs?|s)?|gs?|s)?|r(?:[oó]lewska|á(?:l(?:ov(?:sk[aá])?)?|ľov)|a(?:l(?:jevima|ov(?:sk[aá])?)?|ľov))?|un(?:gaboken|inkaiden[\s\xa0]*kirja))|r[aā]ǳ(?:[aā]har(?:[uū]ko))|царів|Vua|к(?:раљева|нига[\s\xa0]*(?:за[\s\xa0]*царевите|царів))|Царе(?:в[аи]|[ий])|Para[\s\xa0]*Raja|Wa(?:falme)?|C(?:ariv|ác[\s\xa0]*Vua)|राजा(?:ओं|हरूको)?|Fal|Hari|B(?:ren(?:hinoedd|inoedd)|oq(?:orradii)?)))|ème(?:[\s\xa0]*Rois|\.[\s\xa0]*Rois)|nd(?:[\s\xa0]*K(?:n(?:gs?|s)?|i(?:n(?:gs?|s)?|gs?|s)?|gs?|s)?|\.[\s\xa0]*K(?:n(?:gs?|s)?|i(?:n(?:gs?|s)?|gs?|s)?|gs?|s)?)|[\s\xa0]*(?:سلاطین|พ(?:กษ|งศ์กษัตริย์)|ରାଜାବଳୀର?|о[\s\xa0]*царевима|salāṭīn|M(?:b(?:ret[eë]rve)?|ga[\s\xa0]*Hari)|k(?:\.[\s\xa0]*Kr[aá](?:[lľ]ov)|[\s\xa0]*Kr[aá](?:[lľ]ov)|niha[\s\xa0]*kr[aá]lovsk[aá])|Împ[aă]ra(?:[tţ]i)?|[ei](?:\.[\s\xa0]*Mbret(?:[eë]rve|[\s\xa0]*Mbret[eë]rve))|царів|Vua|к(?:раљева|нига[\s\xa0]*(?:за[\s\xa0]*царевите|царів))|Царе(?:в[аи]|[ий])|Para[\s\xa0]*Raja|R(?:y(?:es?|s)?|aja|e(?:y(?:es?|s)?|es?|is|s|g(?:um|i)?)|s|ois)?|Wa(?:falme)?|C(?:ariv|ác[\s\xa0]*Vua)|Fal|الملوك|அர(?:சர்கள்)?|Ha(?:ri)?|B(?:ren(?:hinoedd|inoedd)?|oq(?:orradii)?)|K(?:s(?:\.[\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w))|[\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w))|i(?:[eę]g(?:[ai][\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w)))))|ön(?:ige)?|r(?:(?:[oó]l(?:ewska)?)|á(?:l(?:ov(?:sk[aá])?)?|ľov)|a(?:l(?:jevima|ov(?:sk[aá])?)?|ľov)|[lľ])?|o(?:enige|n(?:g(?:ebo[gk])?|ungaboken|i(?:ngen|ge))?)|n(?:gs?|s)?|gs?|aw|i(?:r(?:[aá]lyok)?|n(?:gs?|s)?|gs?|s)?|un(?:g(?:aboken)?|inkaiden[\s\xa0]*kirja)?)|I(?:mp[aă]ra(?:[tţ]i)?|r[aā]j(?:[aā]kka[lḷ]))|राज(?:ा(?:ओं|हरूको)?|े)|مل|இரா(?:ஜா(?:க்கள்)?)?|ਰਾਜਿਆਂ)|a(?:[\s\xa0]*Reis|\.[\s\xa0]*Reis)|열왕|°(?:\.[\s\xa0]*Re|[\s\xa0]*Re)|º(?:[\s\xa0]*Reyes|\.[\s\xa0]*Reyes)|۔سلاطین|e(?:[\s\xa0]*(?:Rois|Ko(?:n(?:ingen)?)?)|me(?:[\s\xa0]*Rois|\.[\s\xa0]*Rois)|\.[\s\xa0]*(?:Rois|Ko(?:n(?:ingen)?)?))|(?:[ея](?:[\s\xa0]*Царе[ий]|\.[\s\xa0]*Царе[ий]))|o(?:[\s\xa0]*Re(?:is|yes)|\.[\s\xa0]*Re(?:is|yes))|Kgs|-?(?:ге(?:\.[\s\xa0]*(?:книга[\s\xa0]*царів|Cariv|царів)|[\s\xa0]*(?:книга[\s\xa0]*царів|Cariv|царів))|а(?:\.[\s\xa0]*(?:книга[\s\xa0]*царів|Cariv|царів)|[\s\xa0]*(?:книга[\s\xa0]*царів|Cariv|царів))|سلاطِین|е(?:[\s\xa0]*(?:книга[\s\xa0]*царів|Cariv|царів|Царе[ий])|\.[\s\xa0]*(?:книга[\s\xa0]*царів|Cariv|царів|Царе[ий]))|я(?:[\s\xa0]*Царе[ий]|\.[\s\xa0]*Царе[ий])))|ﺍﻟﻤﻠﻮﻙ[\s\xa0]*ﺍﻟﺜﺎﻧﻲ|열왕기(?:[\s\xa0]*하권?|하)|دوم(?:-?سلاطِین|[\s\xa0۔]*سلاطین)|۲(?:-?سلاطِین|[\s\xa0۔]*سلاطین)|C(?:artea[\s\xa0]*(?:IV[\s\xa0]*a[\s\xa0]*Regilor|a[\s\xa0]*patra[\s\xa0]*a[\s\xa0]*Regilor)|zwarta[\s\xa0]*Ks(?:i[eę]g(?:[ai][\s\xa0]*Kr(?:[oó]lewska))|\.[\s\xa0]*Kr[oó]lewska|[\s\xa0]*Kr[oó]lewska))|Zweite[\s\xa0]*K(?:o(?:enige|nige)|önige)|I(?:V(?:[\s\xa0]*(?:K(?:s(?:i[eę]g(?:[ai][\s\xa0]*Kr(?:[oó]lewska))|\.[\s\xa0]*Kr[oó]lewska|[\s\xa0]*Kr[oó]lewska)|r[aá](?:[lľ]ov)|ingdoms)|краљев(?:има|ства)|Цар(?:ів|е|ства)|Re(?:g(?:norum|i)|inos)|Книга[\s\xa0]*на[\s\xa0]*царете|Mga[\s\xa0]*Hari)|\.[\s\xa0]*(?:K(?:s(?:i[eę]g(?:[ai][\s\xa0]*Kr(?:[oó]lewska))|\.[\s\xa0]*Kr[oó]lewska|[\s\xa0]*Kr[oó]lewska)|r[aá](?:[lľ]ov)|ingdoms)|краљев(?:има|ства)|Цар(?:ів|е|ства)|Re(?:g(?:norum|i)|inos)|Книга[\s\xa0]*на[\s\xa0]*царете|Mga[\s\xa0]*Hari))|I(?:[\s\xa0]*(?:R(?:ois|e(?:gi?|is|yes)?)|о[\s\xa0]*царевима|[IÎ]mp(?:[aă]ra(?:[tţ]i)?)|a[\s\xa0]*[IÎ]mp(?:[aă]ra(?:[tţ]ilor))|царів|kniha[\s\xa0]*kr[aá]lovsk[aá]|Vua|к(?:раљева|нига[\s\xa0]*(?:за[\s\xa0]*царевите|царів))|Para[\s\xa0]*Raja|K(?:s(?:\.[\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w))|[\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w))|i(?:[eę]g(?:[ai][\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w)))))|n(?:gs?|s)?|gs?|o(?:n(?:ingen)?)?|uninkaiden[\s\xa0]*kirja|i(?:r(?:[aá]lyok)?|n(?:gs?|s)?|gs?|s)?|r(?:[oó]lewska|á(?:l(?:ov(?:sk[aá])?)?|ľov)|a(?:l(?:jevima|ov(?:sk[aá])?)?|ľov))?)?|Wa(?:falme)?|C(?:ariv|ác[\s\xa0]*Vua)|Fal|Hari|B(?:ren(?:hinoedd|inoedd)|oq(?:orradii)?)|Mga[\s\xa0]*Hari|Царев[аи])|\.[\s\xa0]*(?:о[\s\xa0]*царевима|R(?:e(?:is|yes|g(?:um|i)?)?|ois)|[IÎ]mp(?:[aă]ra(?:[tţ]i)?)|царів|kniha[\s\xa0]*kr[aá]lovsk[aá]|Vua|к(?:раљева|нига[\s\xa0]*(?:за[\s\xa0]*царевите|царів))|Para[\s\xa0]*Raja|K(?:s(?:\.[\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w))|[\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w))|i(?:[eę]g(?:[ai][\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w)))))|n(?:gs?|s)?|gs?|o(?:n(?:ingen)?)?|uninkaiden[\s\xa0]*kirja|i(?:r(?:[aá]lyok)?|n(?:gs?|s)?|gs?|s)?|r(?:[oó]lewska|á(?:l(?:ov(?:sk[aá])?)?|ľov)|a(?:l(?:jevima|ov(?:sk[aá])?)?|ľov))?)|Wa(?:falme)?|C(?:ariv|ác[\s\xa0]*Vua)|Fal|Hari|B(?:ren(?:hinoedd|inoedd)|oq(?:orradii)?)|Mga[\s\xa0]*Hari|Царев[аи]))|ka(?:apat[\s\xa0]*Mga[\s\xa0]*Hari|lawang[\s\xa0]*(?:Hari|Mga[\s\xa0]*Hari)))|왕하|S(?:[ií]ðari[\s\xa0]*(?:b(?:[oó]k[\s\xa0]*konunganna|Konungab[oó]k))|e(?:gund(?:a[\s\xa0]*Reis|o[\s\xa0]*Re(?:is|yes))|cond(?:[ao][\s\xa0]*Re|[\s\xa0]*K(?:n(?:gs?|s)?|i(?:n(?:gs?|s)?|gs?|s)?|gs?|s)?))|tvrt[aá][\s\xa0]*(?:kniha[\s\xa0]*Kr(?:[aá](?:[lľ]ov)|Kr[aá](?:[lľ]ov))))|राजा(?:हरूको[\s\xa0]*दोस्रो[\s\xa0]*पुस्तक|ओ[\s\xa0]*का[\s\xa0]*विर्तान्त[\s\xa0]*[2२]रा[\s\xa0]*भाग)|سفر[\s\xa0]*الملوك[\s\xa0]*الثاني|And(?:r(?:e[\s\xa0]*Kong(?:ebok)?|a[\s\xa0]*K(?:ungaboken|onungaboken))|en[\s\xa0]*Kong(?:ebog)?)|Pili[\s\xa0]*(?:Wafalme|Fal)|rājiāṃ[\s\xa0]*dī[\s\xa0]*dūjī[\s\xa0]*potʰī|ਰਾਜਿਆਂ[\s\xa0]*ਦੀ[\s\xa0]*ਦੂਜੀ[\s\xa0]*ਪੋਥੀ|K(?:awotu[\s\xa0]*Maxaafaa[\s\xa0]*Naa77anttuwaa|i(?:r[aá]lyok[\s\xa0]*II|tabu[\s\xa0]*cha[\s\xa0]*Pili[\s\xa0]*cha[\s\xa0]*Wafalme))|الممالك[\s\xa0]*الرابع|Liber[\s\xa0]*II[\s\xa0]*Regum|T(?:oinen[\s\xa0]*Kuninkaiden[\s\xa0]*kirja|weede[\s\xa0]*Ko(?:n(?:ingen)?)?)|4(?:-?(?:[ея](?:[\s\xa0]*(?:Царств|Книга[\s\xa0]*Царств)|\.[\s\xa0]*(?:Царств|Книга[\s\xa0]*Царств)))|\.[\s\xa0]*(?:K(?:s(?:i[eę]g(?:[ai][\s\xa0]*Kr(?:[oó]lewska))|\.[\s\xa0]*Kr[oó]lewska|[\s\xa0]*Kr[oó]lewska)|r[aá](?:[lľ]ov)|ongerigernes[\s\xa0]*Bog|ingdoms)|M(?:bret[eë]rve|ga[\s\xa0]*Hari)|краљев(?:има|ства)|Re(?:g(?:norum|i)|inos)|Цар(?:ів|е|ства?)|Книга[\s\xa0]*(?:на[\s\xa0]*царете|Царств))|[\s\xa0]*(?:K(?:s(?:i[eę]g(?:[ai][\s\xa0]*Kr(?:[oó]lewska))|\.[\s\xa0]*Kr[oó]lewska|[\s\xa0]*Kr[oó]lewska)|r[aá](?:[lľ]ov)|ongerigernes[\s\xa0]*Bog|ingdoms)|M(?:bret[eë]rve|ga[\s\xa0]*Hari)|краљев(?:има|ства)|[ei](?:\.[\s\xa0]*Mbret(?:[eë]rve|[\s\xa0]*Mbret[eë]rve))|k(?:\.[\s\xa0]*Kr[aá](?:[lľ]ov)|[\s\xa0]*Kr[aá](?:[lľ]ov))|அரசுகள்|Re(?:g(?:norum|i)|inos)|Ц(?:ар(?:ів|е|ства?)?)?|Книга[\s\xa0]*(?:на[\s\xa0]*царете|Царств))|(?:[ея](?:[\s\xa0]*(?:Царств|Книга[\s\xa0]*Царств)|\.[\s\xa0]*(?:Царств|Книга[\s\xa0]*Царств)))|th(?:\.[\s\xa0]*Kingdoms|[\s\xa0]*Kingdoms)|(?:[ao](?:\.[\s\xa0]*Reinos|[\s\xa0]*Reinos)))|Wafalme[\s\xa0]*II|இராஜாக்களின்[\s\xa0]*இரண்டாம்[\s\xa0]*புத்தகம்|Друг(?:е[\s\xa0]*(?:книга[\s\xa0]*царів|Cariv|царів)|а[\s\xa0]*(?:о[\s\xa0]*царевима|Царева|Cariv|царів|к(?:раљева|нига[\s\xa0]*царів)))|Štvrt[aá][\s\xa0]*(?:kniha[\s\xa0]*Kr(?:[aá](?:[lľ]ov)|Kr[aá](?:[lľ]ov)))|Β(?:['ʹʹ΄’][\s\xa0]*Βα(?:σ(?:ιλ(?:[έε]ων)?)?)|ασιλει[ωώ]ν[\s\xa0]*Δ['ʹʹ΄’])|מלכים[\s\xa0]*ב['’]|列(?:王(?:記(?:第四巻|下)|[\s\xa0]*2|紀略下)|下))|(?:Druh(?:(?:[aá][\s\xa0]*Kr(?:[aá](?:l(?:ov(?:sk[aá])?)?|ľov))?)|[yý][\s\xa0]*(?:list[\s\xa0]*Kr(?:[aá](?:[lľ]ov)|Kr(?:[aá](?:l(?:ov(?:sk[aá])?)?|ľov))?)))|2(?:\.[\s\xa0]*[IÎ]mp|[\s\xa0]*(?:[ei][\s\xa0]*Mbret(?:[eë]rve)|[IÎ]mp))|S(?:tvrt[aá][\s\xa0]*Kr(?:[aá](?:[lľ]ov))|[ií]ðari[\s\xa0]*Konungab(?:[oó]k))|Β['ʹʹ΄’][\s\xa0]*Βα|II(?:\.[\s\xa0]*[IÎ]mp|[\s\xa0]*[IÎ]mp)|Štvrt[aá][\s\xa0]*Kr(?:[aá](?:[lľ]ov))|4[\s\xa0]*[ei][\s\xa0]*Mbret(?:[eë]rve))|Druh(?:[yý][\s\xa0]*Kr(?:[aá](?:l(?:ov(?:sk[aá])?)?|ľov))?)|(?:王下》?|II(?:\.[\s\xa0]*Kuninkaiden|[\s\xa0]*(?:Kuninkaiden|Regum))|Síðari[\s\xa0]*konungabók|Четвърта[\s\xa0]*книга[\s\xa0]*на[\s\xa0]*царете|2(?:\.[\s\xa0]*Kuninkaiden|[\s\xa0]*Kuninkaiden)|Toinen[\s\xa0]*Kuninkaiden|《(?:王下|列王[记纪紀]下)|מלכים[\s\xa0]*ב|列王[紀记纪]下》?))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["1Kgs"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])((?:1(?:re(?:[\s\xa0]*Rois|\.[\s\xa0]*Rois)|\.[\s\xa0]*kniha[\s\xa0]*kr[aá]lovsk[aá]|[\s\xa0]*r(?:ā(?:jiāṃ|ǳ(?:[aā]har(?:[uū]ko)|e))|aǳ(?:[aā]har(?:[uū]ko)|e)))|I\.[\s\xa0]*kniha[\s\xa0]*kr[aá]lovsk[aá])|(?:Βασιλει[ωώ]ν[\s\xa0]*Γ['ʹʹ΄’]|מלכים[\s\xa0]*א['’]|Wafalme[\s\xa0]*I|Α['ʹʹ΄’][\s\xa0]*Βα(?:σ(?:ιλ(?:[έε]ων)?)?)|Una(?:[\s\xa0]*(?:Hari|Mga[\s\xa0]*Hari)|ng[\s\xa0]*(?:Hari|Mga[\s\xa0]*Hari))|سفر[\s\xa0]*الملوك[\s\xa0]*الأول|Тре(?:т(?:а[\s\xa0]*книга[\s\xa0]*(?:на[\s\xa0]*царете|Царства)|о[\s\xa0]*(?:Цар(?:е|ства)|Книга[\s\xa0]*на[\s\xa0]*царете)|[яє][\s\xa0]*Царів)|ћ(?:ом[\s\xa0]*краљев(?:има|ства)|а[\s\xa0]*краљев(?:има|ства)))|P(?:ierwsz(?:[aey][\s\xa0]*K(?:s(?:\.[\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w))|[\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w))|i(?:[eę]g(?:[ai][\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w)))))|r[oó]lewska))|r(?:em(?:ye[\s\xa0]*(?:Wa|liv[\s\xa0]*Wa[\s\xa0]*yo)|i(?:er(?:e(?:[\s\xa0]*Rois|s[\s\xa0]*Rois)|[\s\xa0]*Rois|s[\s\xa0]*Rois)|ère(?:[\s\xa0]*Rois|s[\s\xa0]*Rois)))|v(?:n(?:[ií][\s\xa0]*(?:Kr(?:[aá]l(?:ovsk[aá])?)?|kniha[\s\xa0]*kr[aá]lovsk[aá]))|[yý][\s\xa0]*(?:list[\s\xa0]*Kr(?:[aá](?:[lľ]ov)|Kr[aá](?:[lľ]ov)))|á[\s\xa0]*(?:kniha[\s\xa0]*Kr[aá](?:[lľ]ov)|Kr[aá](?:[lľ]ov))|a[\s\xa0]*(?:Kr(?:a(?:l(?:jevima|ov)|ľov)|á[lľ]ov)|kn(?:iha[\s\xa0]*Kr[aá](?:[lľ]ov)|jiga[\s\xa0]*o[\s\xa0]*Kraljevima)))|im(?:[ao][\s\xa0]*Re|e(?:ir[ao][\s\xa0]*Reis|r(?:[\s\xa0]*Reyes|o[\s\xa0]*Reyes)))))|ا(?:لممالك[\s\xa0]*الثالث|وّل(?:-?سلاطِین|[\s\xa0۔]*سلاطین))|1(?:[\s\xa0]*(?:سلاطین|พ(?:กษ|งศ์กษัตริย์)|ରାଜାବଳୀର?|о[\s\xa0]*царевима|salāṭīn|M(?:b(?:ret[eë]rve)?|ga[\s\xa0]*Hari)|k(?:\.[\s\xa0]*Kr[aá](?:[lľ]ov)|[\s\xa0]*Kr[aá](?:[lľ]ov)|niha[\s\xa0]*kr[aá]lovsk[aá])|Împ[aă]ra(?:[tţ]i)?|[ei](?:\.[\s\xa0]*Mbret(?:[eë]rve|[\s\xa0]*Mbret[eë]rve))|царів|Vua|к(?:раљева|нига[\s\xa0]*(?:за[\s\xa0]*царевите|царів))|Царе(?:в[аи]|[ий])|Para[\s\xa0]*Raja|R(?:y(?:es?|s)?|aja|e(?:y(?:es?|s)?|es?|is|s|g(?:um|i)?)|s|ois)?|Wa(?:falme)?|C(?:ariv|ác[\s\xa0]*Vua)|Fal|الملوك|அர(?:சர்கள்)?|K(?:s(?:\.[\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w))|[\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w))|i(?:[eę]g(?:[ai][\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w)))))|ön(?:ige)?|r(?:(?:[oó]l(?:ewska)?)|á(?:l(?:ov(?:sk[aá])?)?|ľov)|a(?:l(?:jevima|ov(?:sk[aá])?)?|ľov)|[lľ])?|i(?:r(?:[aá]lyok)?|n(?:gs?|s)?|gs?)?|o(?:enige|n(?:g(?:ebo[gk])?|ungaboken|i(?:ngen|ge))?)|n(?:gs?|s)?|gs?|aw|un(?:g(?:aboken)?|inkaiden[\s\xa0]*kirja)?)|Ha(?:ri)?|B(?:ren(?:hinoedd|inoedd)?|oq(?:orradii)?)|I(?:mp[aă]ra(?:[tţ]i)?|r[aā]j(?:[aā]kka[lḷ]))|राज(?:ा(?:ओं|हरूको)?|े)|مل|இரா(?:ஜா(?:க்கள்)?)?|ਰਾਜਿਆਂ)|ère(?:[\s\xa0]*Rois|\.[\s\xa0]*Rois)|a(?:[\s\xa0]*Reis|\.[\s\xa0]*Reis)|e(?:r(?:e(?:[\s\xa0]*Rois|\.[\s\xa0]*Rois)|[\s\xa0]*Rois|\.[\s\xa0]*Rois)|[\s\xa0]*Ko(?:n(?:ingen)?)?|\.[\s\xa0]*Ko(?:n(?:ingen)?)?)|열왕|\.(?:-?سلاطِین|[\s\xa0]*(?:سلاطین|พ(?:กษ|งศ์กษัตริย์)|ରାଜାବଳୀର?|о[\s\xa0]*царевима|M(?:bret[eë]rve|ga[\s\xa0]*Hari)|[IÎ]mp(?:[aă]ra(?:[tţ]i)?)|R(?:aja|e(?:is|yes|g(?:um|i)?)|ois)|K(?:s(?:\.[\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w))|[\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w))|i(?:[eę]g(?:[ai][\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w)))))|ön(?:ige)?|i(?:r(?:[aá]lyok)?|n(?:gs?|s)?|gs?)?|o(?:enige|n(?:g(?:ebo[gk])?|ungaboken|i(?:ngen|ge))?)|n(?:gs?|s)?|gs?|r(?:[oó]lewska|á(?:l(?:ov(?:sk[aá])?)?|ľov)|a(?:l(?:jevima|ov(?:sk[aá])?)?|ľov))?|un(?:gaboken|inkaiden[\s\xa0]*kirja))|r[aā]ǳ(?:[aā]har(?:[uū]ko))|царів|Vua|к(?:раљева|нига[\s\xa0]*(?:за[\s\xa0]*царевите|царів))|Царе(?:в[аи]|[ий])|Para[\s\xa0]*Raja|Wa(?:falme)?|C(?:ariv|ác[\s\xa0]*Vua)|राजा(?:ओं|हरूको)?|Fal|Hari|B(?:ren(?:hinoedd|inoedd)|oq(?:orradii)?))|(?:[oº](?:[\s\xa0]*Reyes|\.[\s\xa0]*Reyes))|۔سلاطین)|-?(?:ше(?:\.[\s\xa0]*(?:книга[\s\xa0]*царів|Cariv|царів)|[\s\xa0]*(?:книга[\s\xa0]*царів|Cariv|царів))|а(?:\.[\s\xa0]*(?:книга[\s\xa0]*царів|Cariv|царів)|[\s\xa0]*(?:книга[\s\xa0]*царів|Cariv|царів))|سلاطِین|е(?:[\s\xa0]*(?:книга[\s\xa0]*царів|Cariv|царів|Царе[ий])|\.[\s\xa0]*(?:книга[\s\xa0]*царів|Cariv|царів|Царе[ий]))|я(?:[\s\xa0]*Царе[ий]|\.[\s\xa0]*Царе[ий]))|°(?:\.[\s\xa0]*Re|[\s\xa0]*Re)|º(?:[\s\xa0]*Reyes|\.[\s\xa0]*Reyes)|۔سلاطین|(?:[ея](?:[\s\xa0]*Царе[ий]|\.[\s\xa0]*Царе[ий]))|o(?:[\s\xa0]*Re(?:is|yes)|\.[\s\xa0]*Re(?:is|yes))|Kgs|st(?:[\s\xa0]*K(?:n(?:gs?|s)?|gs?|i(?:n(?:gs?|s)?|gs?)?|s)?|\.[\s\xa0]*K(?:n(?:gs?|s)?|gs?|i(?:n(?:gs?|s)?|gs?)?|s)?))|राजा(?:ओ[\s\xa0]*का[\s\xa0]*विर्तान्त[\s\xa0]*[1१]ला[\s\xa0]*भाग्|हरूक[\s\xa0]*पहिल[\s\xa0]*पुस्तक)|3(?:\.[\s\xa0]*(?:K(?:s(?:i[eę]g(?:[ai][\s\xa0]*Kr(?:[oó]lewska))|\.[\s\xa0]*Kr[oó]lewska|[\s\xa0]*Kr[oó]lewska)|r[aá](?:[lľ]ov)|ongerigernes[\s\xa0]*Bog|ingdoms)|M(?:bret[eë]rve|ga[\s\xa0]*Hari)|краљев(?:има|ства)|Re(?:g(?:norum|i)|inos)|Цар(?:ів|е|ства?)|Книга[\s\xa0]*(?:на[\s\xa0]*царете|Царств))|-?(?:я(?:[\s\xa0]*(?:Царств|Книга[\s\xa0]*Царств)|\.[\s\xa0]*(?:Царств|Книга[\s\xa0]*Царств))|е(?:\.[\s\xa0]*(?:Цар(?:ів|ств)|Книга[\s\xa0]*Царств)|[\s\xa0]*(?:Цар(?:ів|ств)|Книга[\s\xa0]*Царств))|а(?:[\s\xa0]*Царів|\.[\s\xa0]*Царів)|тє(?:[\s\xa0]*Царів|\.[\s\xa0]*Царів))|[\s\xa0]*(?:K(?:s(?:i[eę]g(?:[ai][\s\xa0]*Kr(?:[oó]lewska))|\.[\s\xa0]*Kr[oó]lewska|[\s\xa0]*Kr[oó]lewska)|r[aá](?:[lľ]ov)|ongerigernes[\s\xa0]*Bog|ingdoms)|M(?:bret[eë]rve|ga[\s\xa0]*Hari)|краљев(?:има|ства)|[ei](?:\.[\s\xa0]*Mbret(?:[eë]rve|[\s\xa0]*Mbret[eë]rve))|k(?:\.[\s\xa0]*Kr[aá](?:[lľ]ov)|[\s\xa0]*Kr[aá](?:[lľ]ov))|அரசுகள்|Re(?:g(?:norum|i)|inos)|Ц(?:ар(?:ів|е|ства?)?)?|Книга[\s\xa0]*(?:на[\s\xa0]*царете|Царств))|rd(?:\.[\s\xa0]*Kingdoms|[\s\xa0]*Kingdoms)|(?:[ея](?:[\s\xa0]*(?:Царств|Книга[\s\xa0]*Царств)|\.[\s\xa0]*(?:Царств|Книга[\s\xa0]*Царств)))|(?:[ao](?:\.[\s\xa0]*Reinos|[\s\xa0]*Reinos)))|П(?:рв(?:а[\s\xa0]*(?:о[\s\xa0]*царевима|к(?:нига[\s\xa0]*за[\s\xa0]*царевите|раљева)|Царев[аи])|о[\s\xa0]*(?:Цареви|книга[\s\xa0]*за[\s\xa0]*царевите))|ерш(?:[ае][\s\xa0]*(?:книга[\s\xa0]*царів|Cariv|царів)))|ରାଜାବଳୀର[\s\xa0]*ପ୍ରଥମ[\s\xa0]*ପୁସ୍ତକ|ﺍﻟﻤﻠﻮﻙ[\s\xa0]*ﺍﻷﻭ|Cartea[\s\xa0]*(?:a[\s\xa0]*treia[\s\xa0]*a[\s\xa0]*Regilor|III[\s\xa0]*a[\s\xa0]*Regilor)|열왕기(?:[\s\xa0]*상권?|상)|۱(?:-?سلاطِین|[\s\xa0۔]*سلاطین)|列(?:王(?:記(?:第三巻|上)|[\s\xa0]*1|紀略上)|上)|r(?:aǳ[aā]har(?:[uū]ko[\s\xa0]*pustak)|ā(?:jiāṃ[\s\xa0]*dī[\s\xa0]*pahilī[\s\xa0]*potʰī|ǳ[aā]har(?:[uū]ko[\s\xa0]*pustak)))|இராஜாக்களின்[\s\xa0]*முதலாம்[\s\xa0]*புத்தகம்|T(?:hird[\s\xa0]*Kingdoms|erceir[ao][\s\xa0]*Reinos|r(?:zeci(?:a[\s\xa0]*Ks(?:i[eę]g(?:[ai][\s\xa0]*Kr(?:[oó]lewska))|\.[\s\xa0]*Kr[oó]lewska|[\s\xa0]*Kr[oó]lewska)|[\s\xa0]*Ks(?:i[eę]g(?:[ai][\s\xa0]*Kr(?:[oó]lewska))|\.[\s\xa0]*Kr[oó]lewska|[\s\xa0]*Kr[oó]lewska))|e(?:dje[\s\xa0]*Kongerigernes[\s\xa0]*Bog|t(?:í[\s\xa0]*Kr[aá](?:[lľ]ov)|i(?:[\s\xa0]*Kr[aá](?:[lľ]ov)|a[\s\xa0]*(?:kniha[\s\xa0]*Kr[aá](?:[lľ]ov)|Kr[aá](?:[lľ]ov)))))))|I(?:\.[\s\xa0]*(?:о[\s\xa0]*царевима|R(?:e(?:is|yes|g(?:um|i)?)?|ois)|[IÎ]mp(?:[aă]ra(?:[tţ]i)?)|царів|K(?:s(?:\.[\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w))|[\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w))|i(?:[eę]g(?:[ai][\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w)))))|i(?:r(?:[aá]lyok)?|n(?:gs?|s)?|gs?)|n(?:gs?|s)?|gs?|o(?:n(?:ingen)?)?|uninkaiden[\s\xa0]*kirja|r(?:[oó]lewska|á(?:l(?:ov(?:sk[aá])?)?|ľov)|a(?:l(?:jevima|ov(?:sk[aá])?)?|ľov))?)|Vua|к(?:раљева|нига[\s\xa0]*(?:за[\s\xa0]*царевите|царів))|Para[\s\xa0]*Raja|Wa(?:falme)?|C(?:ariv|ác[\s\xa0]*Vua)|Fal|Hari|B(?:ren(?:hinoedd|inoedd)|oq(?:orradii)?)|Mga[\s\xa0]*Hari|Царев[аи])|katlong[\s\xa0]*Mga[\s\xa0]*Hari|II(?:[\s\xa0]*(?:K(?:s(?:i[eę]g(?:[ai][\s\xa0]*Kr(?:[oó]lewska))|\.[\s\xa0]*Kr[oó]lewska|[\s\xa0]*Kr[oó]lewska)|r[aá](?:[lľ]ov)|ingdoms)|краљев(?:има|ства)|Цар(?:ів|е|ства)|Re(?:g(?:norum|i)|inos)|Книга[\s\xa0]*на[\s\xa0]*царете|Mga[\s\xa0]*Hari)|\.[\s\xa0]*(?:K(?:s(?:i[eę]g(?:[ai][\s\xa0]*Kr(?:[oó]lewska))|\.[\s\xa0]*Kr[oó]lewska|[\s\xa0]*Kr[oó]lewska)|r[aá](?:[lľ]ov)|ingdoms)|краљев(?:има|ства)|Цар(?:ів|е|ства)|Re(?:g(?:norum|i)|inos)|Книга[\s\xa0]*на[\s\xa0]*царете|Mga[\s\xa0]*Hari))|[\s\xa0]*(?:R(?:ois|e(?:gi?|is|yes)?)|о[\s\xa0]*царевима|[IÎ]mp(?:[aă]ra(?:[tţ]i)?)|a[\s\xa0]*[IÎ]mp(?:[aă]ra(?:[tţ]ilor))|царів|kniha[\s\xa0]*kr[aá]lovsk[aá]|Vua|к(?:раљева|нига[\s\xa0]*(?:за[\s\xa0]*царевите|царів))|K(?:s(?:\.[\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w))|[\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w))|i(?:[eę]g(?:[ai][\s\xa0]*Kr(?:[oó]l(?:ewska|[oó]w)))))|i(?:r(?:[aá]lyok)?|n(?:gs?|s)?|gs?)|n(?:gs?|s)?|gs?|o(?:n(?:ingen)?)?|uninkaiden[\s\xa0]*kirja|r(?:[oó]lewska|á(?:l(?:ov(?:sk[aá])?)?|ľov)|a(?:l(?:jevima|ov(?:sk[aá])?)?|ľov))?)?|Para[\s\xa0]*Raja|Wa(?:falme)?|C(?:ariv|ác[\s\xa0]*Vua)|Fal|Hari|B(?:ren(?:hinoedd|inoedd)|oq(?:orradii)?)|Mga[\s\xa0]*Hari|Царев[аи]))|ପ୍ରଥମ[\s\xa0]*ରାଜାବଳୀର?|Regum[\s\xa0]*I|ਰਾਜਿਆਂ[\s\xa0]*ਦੀ[\s\xa0]*ਪਹਿਲੀ[\s\xa0]*ਪੋਥੀ|पहिले[\s\xa0]*राजे|Boqorradii[\s\xa0]*Kowaad|《(?:王上》|列王[紀纪记]上》)|왕상|E(?:erste[\s\xa0]*Ko(?:n(?:ingen)?)?|ls(?:[oő][\s\xa0]*Kir(?:[aá]lyok)?)|nsimm[aä]inen[\s\xa0]*Kuninkaiden[\s\xa0]*kirja|rste[\s\xa0]*K(?:o(?:enige|nige)|önige))|δυτικ[οό]ς[\s\xa0]*Βασιλ(?:[έε]ων[\s\xa0]*Α['ʹʹ΄’])|F(?:irst[\s\xa0]*K(?:n(?:gs?|s)?|gs?|i(?:n(?:gs?|s)?|gs?)?|s)?|(?:[oö]rsta[\s\xa0]*K(?:ungaboken|onungaboken))|ørste[\s\xa0]*Kong(?:ebo[gk])?|yrri[\s\xa0]*(?:b[oó]k[\s\xa0]*konunganna|Konungab[oó]k))|K(?:wanza[\s\xa0]*(?:Wafalme|Fal)|i(?:r[aá]lyok[\s\xa0]*I|tabu[\s\xa0]*cha[\s\xa0]*Kwanza[\s\xa0]*cha[\s\xa0]*Wafalme)|awotu[\s\xa0]*Maxaafaa[\s\xa0]*Koiruwaa)|Liber[\s\xa0]*I[\s\xa0]*Regum)|(?:Prv[yý][\s\xa0]*Kr(?:[aá](?:[lľ]ov))|1(?:\.[\s\xa0]*[IÎ]mp|[\s\xa0]*(?:[ei][\s\xa0]*Mbret(?:[eë]rve)|[IÎ]mp))|Α['ʹʹ΄’][\s\xa0]*Βα|I(?:\.[\s\xa0]*[IÎ]mp|[\s\xa0]*[IÎ]mp)|3[\s\xa0]*[ei][\s\xa0]*Mbret(?:[eë]rve))|(?:王上》?|列王[记紀纪]上》?|K(?:gs|in(?:gs)?|ngs)|الملوك[\s\xa0]*الأول|I(?:\.[\s\xa0]*Kuninkaiden|[\s\xa0]*(?:Kuninkaiden|Regum))|Ensimm[aä]inen[\s\xa0]*Kuninkaiden|1(?:\.[\s\xa0]*Kuninkaiden|[\s\xa0]*Kuninkaiden)|מלכים[\s\xa0]*א|《(?:王上|列王[紀记纪]上)|Fyrri[\s\xa0]*konungabók))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["EpJer"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Jer(?:br|[\\s\\xa0]*br|emi(?:jino[\\s\\xa0]*pismo|a(?:n[\\s\\xa0]*kirje|s(?:[\\s\\xa0]*(?:brev|levele)|ov[\\s\\xa0]*list|['’][\\s\\xa0]*Brev)|šov[\\s\\xa0]*list)|á(?:s(?:[\\s\\xa0]*levele|ov[\\s\\xa0]*list)|šov[\\s\\xa0]*list)))|B(?:arua[\\s\\xa0]*ya[\\s\\xa0]*Yeremia|Jer|r(?:[eé]f[\\s\\xa0]*Jerem(?:[ií]a)|ief[\\s\\xa0]*(?:van[\\s\\xa0]*Jeremia|des[\\s\\xa0]*Jeremia)|[\\s\\xa0]*Jer))|Ep(?:\\.[\\s\\xa0]*J(?:[eé]r(?:[eé]mie)?)|[\\s\\xa0]*J(?:[eé]r(?:[eé]mie)?)|ître[\\s\\xa0]*de[\\s\\xa0]*J[eé]r(?:[eé]mie)|i(?:st(?:ola[\\s\\xa0]*lui[\\s\\xa0]*Ieremia|le[\\s\\xa0]*of[\\s\\xa0]*Jeremy)|tre[\\s\\xa0]*de[\\s\\xa0]*J[eé]r(?:[eé]mie)))|エレミヤ(?:・手|の(?:書翰|手紙))|L(?:i(?:st[\\s\\xa0]*Jerem(?:j[aá](?:[sš](?:[uů]v))|iasza)|[\\s\\xa0]*ni[\\s\\xa0]*Jer|h[\\s\\xa0]*Jer)|a[\\s\\xa0]*Carta[\\s\\xa0]*de[\\s\\xa0]*Jerem[ií]as|lythyr[\\s\\xa0]*Jeremeia|et(?:tera[\\s\\xa0]*di[\\s\\xa0]*Geremia|-?ger))|איגרת[\\s\\xa0]*ירמיהו|رسالة[\\s\\xa0]*إرميا|Лист[\\s\\xa0]*Єремі[ії]|அவை[\\s\\xa0]*இளைஞர்[\\s\\xa0]*மூவரின்[\\s\\xa0]*பாடல்|Cart(?:a[\\s\\xa0]*Jer(?:em[ií]as)?|[\\s\\xa0]*Jer|\\.[\\s\\xa0]*Jer)|イエレミヤの達書|《EpJer》|Pismo[\\s\\xa0]*Jeremije[\\s\\xa0]*proroka|П(?:ослан(?:и(?:е[\\s\\xa0]*(?:на[\\s\\xa0]*Иеремия|Иеремии)|ца[\\s\\xa0]*Јеремијина)|ня[\\s\\xa0]*Єремі[ії])|исма[\\s\\xa0]*Јеремије)|Επιστολ(?:ή[\\s\\xa0]*Ιερεμ[ίι]ου|η[\\s\\xa0]*(?:᾿Ιερ|Ιερεμ[ίι]ου)|ὴ[\\s\\xa0]*᾿Ιερ)|Ang[\\s\\xa0]*Liham[\\s\\xa0]*ni[\\s\\xa0]*Jeremias|The[\\s\\xa0]*(?:Ep(?:[\\s\\xa0]*of[\\s\\xa0]*Jeremiah|\\.[\\s\\xa0]*of[\\s\\xa0]*Jeremiah|istle[\\s\\xa0]*of[\\s\\xa0]*Jeremiah)|Let(?:[\\s\\xa0]*of[\\s\\xa0]*Jeremiah|\\.[\\s\\xa0]*of[\\s\\xa0]*Jeremiah|ter[\\s\\xa0]*of[\\s\\xa0]*Jeremiah))|예레미야의[\\s\\xa0]*편지|Ép(?:\\.[\\s\\xa0]*J(?:[eé]r(?:[eé]mie)?)|[\\s\\xa0]*J(?:[eé]r(?:[eé]mie)?)|[iî]tre[\\s\\xa0]*de[\\s\\xa0]*J(?:[eé]r(?:[eé]mie)))|Or(?:atio[\\s\\xa0]*Ieremiae|\\.[\\s\\xa0]*Ier|[\\s\\xa0]*Ier)|எரேமியாவின்[\\s\\xa0]*(?:மடல்|கடிதம்))|(?:《EpJer|Ep(?:[\\s\\xa0]*of[\\s\\xa0]*Jeremiah|\\.[\\s\\xa0]*of[\\s\\xa0]*Jeremiah|Jer》?|istle[\\s\\xa0]*of[\\s\\xa0]*Jeremiah)|Carta[\\s\\xa0]*de[\\s\\xa0]*Jerem[íi]as|L(?:iham[\\s\\xa0]*ni[\\s\\xa0]*Jeremias|et(?:[\\s\\xa0]*of[\\s\\xa0]*Jeremiah|\\.[\\s\\xa0]*of[\\s\\xa0]*Jeremiah|ter[\\s\\xa0]*of[\\s\\xa0]*Jeremiah))))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Lam"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Pla[cč][\\s\\xa0]*Jeremj(?:[aá](?:[sš](?:[uů]v)))|(?:П(?:лач(?:от[\\s\\xa0]*на[\\s\\xa0]*Еремија|ът[\\s\\xa0]*на[\\s\\xa0]*(?:Еремия|[ИЙ]еремия)|[\\s\\xa0]*(?:Єремі[ії]|Ереми(?:ев|ин)|на[\\s\\xa0]*Еремиин|Јеремијин|Иеремии))|\\.[\\s\\xa0]*[ИЙ]ер|[\\s\\xa0]*[ИЙ]ер)|P(?:l(?:âng(?:eri(?:le[\\s\\xa0]*(?:profetului[\\s\\xa0]*Ieremia|lui[\\s\\xa0]*Ieremia))?)?|á[cč][\\s\\xa0]*Jerem(?:[ij](?:[aá](?:[sš](?:[uů]v))))|a(?:ng(?:eri(?:le[\\s\\xa0]*(?:profetului[\\s\\xa0]*Ieremia|lui[\\s\\xa0]*Ieremia))?)?|[cč][\\s\\xa0]*Jeremi(?:(?:[aá](?:[sš](?:[ouů]v))|[iï]))))?|ulampal|anag)|विलापग[ीे]त|Erm(?:maasa[\\s\\xa0]*Zilaassaa|Z)|พคค|T(?:r(?:eny[\\s\\xa0]*Jeremiasza)?|u[zž])|ਵਿਰਲਾਪ|איכה|مرا|H(?:lj|armlj[oó]ðin)|C(?:a[\\s\\xa0]*thương|hante[\\s\\xa0]*pou[\\s\\xa0]*plenn[\\s\\xa0]*S[oò][\\s\\xa0]*lavil[\\s\\xa0]*Jerizal(?:[eè]m))|קינות|哀歌|บทเพลงคร่ำครวญ|A(?:i[\\s\\xa0]*Ca|klat[\\s\\xa0]*ng[\\s\\xa0]*Pa(?:gtaghoy|nanaghoy))|ن(?:وحہ|َوحہ)|Omb|V(?:a(?:j(?:timet)?|lit(?:usvirret)?)|ilapageet)|புல(?:ம்)?|Θρ[ήη]νοι[\\s\\xa0]*Ιερεμ(?:[ίι]ου)?|எரேமியாவின்[\\s\\xa0]*புலம்பல்|Baroor(?:ashadii[\\s\\xa0]*Yeremyaah)?|Siral(?:m(?:ak)?)?|เพลงคร่ำครวญ|예레미(?:아애가|야(?:[\\s\\xa0]*애가|애가))|yarmiy[aā]ko[\\s\\xa0]*vil(?:[aā]p)|Galar(?:nad[\\s\\xa0]*Jeremiah)?|wil[aā]pg(?:[iī]t)|Книга[\\s\\xa0]*Плач[\\s\\xa0]*Иеремиев|المراثي|エレミヤの哀歌|(?:[ZŽ]alosp(?:evy)?)|سفر[\\s\\xa0]*مراثي[\\s\\xa0]*إرميا|यर्मियाको[\\s\\xa0]*विलाप|《(?:耶利米哀歌》|哀》|連同哀歌》)|virlāp|애|K(?:niha[\\s\\xa0]*n(?:[aá](?:r(?:ekov|k[uů])|řk[uů]))|s(?:[\\s\\xa0]*Lamentacji|\\.[\\s\\xa0]*Lamentacji|i[eę]g(?:[ai][\\s\\xa0]*Lamentacji))|idung[\\s\\xa0]*Pa(?:sambat|ngadhuh)|\\.[\\s\\xa0]*n[aá]rekov|[\\s\\xa0]*n[aá]rekov|l(?:a(?:agl(?:iederen)?|g(?:ovisorna|e(?:s(?:angene)?|lieder[\\s\\xa0]*Jeremias))?)|gl)?)|N(?:[aá]r(?:eky)?)|Jeremi(?:(?:[aá](?:šov[\\s\\xa0]*Pla[cč]|s(?:ov[\\s\\xa0]*Pla[cč]|[\\s\\xa0]*sir(?:almai)?)))|jine[\\s\\xa0]*tu[zž]aljke)|L(?:am(?:enta(?:ç[oôõ]es[\\s\\xa0]*de[\\s\\xa0]*Jeremias|c(?:i(?:ones?|je)|je[\\s\\xa0]*Jeremiasza|[oôõ]es[\\s\\xa0]*de[\\s\\xa0]*Jeremias)|zioni|tion(?:s[\\s\\xa0]*de[\\s\\xa0]*J[eé]r(?:[eé]mie)|es)?)|inta(?:ciones?|tions?)|antasyon)?|m)|nūḥâ|ଯିରିମିୟଙ୍କ[\\s\\xa0]*ବିଳାପ|M(?:ga[\\s\\xa0]*(?:Pa(?:naghoy|gbangotan)|Lamentasyon)|ao(?:mbolezo[\\s\\xa0]*ya[\\s\\xa0]*Yeremia)?))|Θρ|(?:Galarnad|विलाप|T(?:u[žz]aljke|reny)|Θρ[ηή]νοι|哀》?|புலம்பல்|Плач(?:[\\s\\xa0]*Иеремиев)?|مراثي[\\s\\xa0]*إرميا|Lamenta(?:c(?:[oõ]es|je)|ç[õo]es|tions)|連同哀歌》?|耶利米哀歌》?|Klagelieder|《(?:耶利米哀歌|連同哀歌|哀)|P(?:l(?:enn|[aá][cč])|a(?:naghoy|gbangotan))|애가|Maombolezo|Baroorashadii))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Num"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])((?:민(?:수기?)?|எண்(?:ண(?:ிக்கை|ாகமம்))?|IV(?:\.[\s\xa0]*(?:книга[\s\xa0]*Мо[ий]сеева|Ks(?:[\s\xa0]*Moj[zż]eszowa|\.[\s\xa0]*Moj[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|M(?:o(?:j(?:ž[ií](?:[sš]ova)|ż(?:eszowa)?|z(?:[ií](?:[sš]ova)|eszowa)?)|s(?:eb[oó]k)?|oseksen[\s\xa0]*kirja|zes)|ó(?:s(?:eb[oó]k)?|zes))|kniha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova))|Мо(?:јс(?:ијева)?|исеева))|[\s\xa0]*(?:книга[\s\xa0]*Мо[ий]сеева|M(?:o(?:j(?:ž[ií](?:[sš]ova)|ż(?:eszowa)?|z(?:[ií](?:[sš]ova)|eszowa)?)?|s(?:eb[oó]k)?|oseksen[\s\xa0]*kirja|zes)|ó(?:s(?:eb[oó]k)?|zes))|Ks(?:[\s\xa0]*Moj[zż]eszowa|\.[\s\xa0]*Moj[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|kniha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova))|Мо(?:јс(?:ијева)?|исеева)))|ספירה|Ginatee|L(?:b|iber[\s\xa0]*Numeri)|عد|S(?:z(?:[aá]m(?:ok)?)|tvrt[aá][\s\xa0]*(?:Moj(?:[zž]i(?:[sš]ova)|kniha[\s\xa0]*Moj[zž]i(?:[sš]ova))))|Dân[\s\xa0]*số[\s\xa0]*ký|ଗଣନା[\s\xa0]*ପୁସ୍ତକ|Wilangan|《(?:民(?:数记》|數記》|》)|戶籍紀》)|Vier(?:de[\s\xa0]*Mozes|te[\s\xa0]*(?:Mose|Buch[\s\xa0]*Mose))|Č(?:tvrt[aá][\s\xa0]*(?:kniha[\s\xa0]*Moj(?:[zž](?:[ií](?:[sš]ova))|Moj[zž](?:[ií](?:[sš]ova))))|ysla)|Hesabu|K(?:s(?:\.[\s\xa0]*Liczb|[\s\xa0]*Liczb|i[eę]g(?:[ai][\s\xa0]*Liczb))|itabu[\s\xa0]*cha[\s\xa0]*Nne[\s\xa0]*cha[\s\xa0]*Musa|njiga[\s\xa0]*Brojeva)|B(?:lg|il|rojevi|[ae]midbar)|liv[\s\xa0]*Resansman[\s\xa0]*an|Αρ(?:ιθ(?:μο[ίι])?)?|ਗਿਣਤੀ|民数記|گ(?:نتی|ِنتی)|Бр(?:о(?:еви|јеви))?|Res|Tir(?:intii)?|4(?:Mós|[\s\xa0]*(?:книга[\s\xa0]*Мо[ий]сеева|Ks(?:[\s\xa0]*Moj[zż]eszowa|\.[\s\xa0]*Moj[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|M(?:z|ó(?:s(?:eb[oó]k)?|z(?:es)?)|o(?:j(?:ž[ií](?:[sš]ova)|ż(?:eszowa)?|z(?:[ií](?:[sš]ova)|eszowa)?)?|s(?:e(?:b(?:ók|o(?:g|k(?:en)?)))?)?|os(?:eksen[\s\xa0]*kirja)?|z(?:es)?)?)|k(?:[\s\xa0]*Moj[zž]i(?:[sš]ova)|niha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova))|\.[\s\xa0]*Moj[zž]i(?:[sš]ova))|Buch[\s\xa0]*Mose|М(?:о(?:јс(?:ијева)?|исеева))?)|\.[\s\xa0]*(?:M(?:o(?:s(?:e(?:b(?:ók|o(?:g|k(?:en)?)))?)?|j(?:ž[ií](?:[sš]ova)|ż(?:eszowa)?|z(?:[ií](?:[sš]ova)|eszowa)?)|oseksen[\s\xa0]*kirja|zes)?|ó(?:s(?:eb[oó]k)?|zes))|книга[\s\xa0]*Мо[ий]сеева|Ks(?:[\s\xa0]*Moj[zż]eszowa|\.[\s\xa0]*Moj[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|kniha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova))|Buch[\s\xa0]*Mose|Мо(?:јс(?:ијева)?|исеева)))|במדבר|سفر[\s\xa0]*العدد|N(?:elj[aä]s[\s\xa0]*Mooseksen[\s\xa0]*kirja|u(?:m(?:rat|erii|b(?:er[is]?)?)?)?|ú(?:m(?:eros)?)?|o(?:m(?:b(?:res)?)?|nb)?|[bm])|E[nṇ](?:[nṇ](?:[aā]kamam))|Štvrt[aá][\s\xa0]*(?:Moj(?:[zž]i(?:[sš]ova)|kniha[\s\xa0]*Moj[zž]i(?:[sš]ova)))|Qo(?:odaabaa|d)|Ἀρ|Книга[\s\xa0]*Чисел|Fj(?:(?:[aä]rde[\s\xa0]*Mosebok(?:en)?)|erde[\s\xa0]*Mos(?:ebo[gk])?|[oó]rða[\s\xa0]*(?:b(?:[oó]k[\s\xa0]*M(?:[oó]se)|M[oó]seb(?:[oó]k))))|ก(?:ดว|ันดารวิถี)|C(?:zwarta[\s\xa0]*(?:Ks(?:[\s\xa0]*Moj[zż]eszowa|\.[\s\xa0]*Moj[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|Moj(?:[zż](?:eszowa)?))|tvrt[aá][\s\xa0]*(?:kniha[\s\xa0]*Moj(?:[zž](?:[ií](?:[sš]ova))|Moj[zž](?:[ií](?:[sš]ova))))|ysla)|M(?:[oó]zes[\s\xa0]*IV|ga[\s\xa0]*(?:Numeros?|Bilang))|Ч(?:ис(?:ла)?|етв(?:ерта[\s\xa0]*книга[\s\xa0]*Мо[ий]сеева|ърта[\s\xa0]*(?:Моисеева|книга[\s\xa0]*Моисеева)|рта[\s\xa0]*(?:Мојс(?:ијева)?|книга[\s\xa0]*Мојсеева)))|g(?:i[nṇ]tī|a(?:n(?:an[aā]|t[iī]ko[\s\xa0]*pustak)|ṇan[aā]))|מניין|ग(?:िनती|णना|न्ती(?:को[\s\xa0]*पुस्तक)?))|(?:[SŠ]tvrt(?:[aá][\s\xa0]*kniha[\s\xa0]*Moj(?:[zž]i(?:[sš]ova)))|Fj[oó]rða[\s\xa0]*M(?:[oó]seb(?:[oó]k))|[CČ]tvrt(?:[aá][\s\xa0]*Moj(?:[zž](?:[ií](?:[sš]ova)))))|(?:gant[īi]ko|《(?:戶籍紀|民(?:数记|數記)?)|गन्तीको|Resansman|العدد|N(?:elj[aä]s[\s\xa0]*Mooseksen|umer(?:os?|i))|Dân(?:[\s\xa0]*Số)?|4(?:\.[\s\xa0]*Mooseksen|[\s\xa0]*Mooseksen)|ଗଣନା|戶籍紀》?|Liczb|IV(?:\.[\s\xa0]*Mooseksen|[\s\xa0]*Mooseksen)|民(?:数记》?|數記》?|》)?))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["Sus"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:С(?:ус(?:анна[\\s\\xa0]*и[\\s\\xa0]*старцы)?|казанию[\\s\\xa0]*о[\\s\\xa0]*Сусанне[\\s\\xa0]*и[\\s\\xa0]*Данииле)|Hist(?:ória[\\s\\xa0]*de[\\s\\xa0]*Susana|oria[\\s\\xa0]*(?:Susannae|de[\\s\\xa0]*Susana))|சூசன்னா|كتاب[\\s\\xa0]*سوزانا|Fortellingen[\\s\\xa0]*om[\\s\\xa0]*Susanna|Opowiadaniem[\\s\\xa0]*o[\\s\\xa0]*Zuzannie|Istoria[\\s\\xa0]*Susanei|수산나|Z(?:suz(?:s(?:anna[\\s\\xa0]*[eé]s[\\s\\xa0]*a[\\s\\xa0]*v(?:[eé]nek))?)?|uz(?:an(?:[ae]|na))?)|《Sus》|ス(?:[サザ]ンナ(?:物語)?)|Σ(?:ωσ[άα]ννα|ουσ(?:[άα]ννα)?)|S(?:u(?:sann(?:e[\\s\\xa0]*(?:au[\\s\\xa0]*bain|et[\\s\\xa0]*les[\\s\\xa0]*(?:vieillards|deux[\\s\\xa0]*vieillards))|a(?:[\\s\\xa0]*(?:i(?:m[\\s\\xa0]*Bade|[\\s\\xa0]*badet)|und[\\s\\xa0]*die[\\s\\xa0]*Alten|ja[\\s\\xa0]*vanhimmat)|h))|z(?:an(?:ne[\\s\\xa0]*(?:au[\\s\\xa0]*bain|et[\\s\\xa0]*les[\\s\\xa0]*(?:vieillards|deux[\\s\\xa0]*vieillards))|a))?)?|hoshana|i[\\s\\xa0]*Susana|[wú]sanna|toria[\\s\\xa0]*di[\\s\\xa0]*Susanna)|שושנה)|(?:Su(?:zanne|s(?:an(?:ei|n(?:e|ae?)|a)|》)?)|《Sus|Zsuzsanna|سوزانا|Сусанна))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Sir"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:L(?:iber[\\s\\xa0]*Ecclesiasticus|a[\\s\\xa0]*Sagesse[\\s\\xa0]*de[\\s\\xa0]*Ben[\\s\\xa0]*Sira)|Je(?:su(?:[\\s\\xa0]*Siraks[\\s\\xa0]*sønns[\\s\\xa0]*visdom|s[\\s\\xa0]*S(?:yraks[\\s\\xa0]*vishet|i(?:rach|irakin[\\s\\xa0]*kirja)))|esus[\\s\\xa0]*Siirakin[\\s\\xa0]*kirja)|משלי[\\s\\xa0]*בן[\\s\\xa0\\-?]*סירא|Книга[\\s\\xa0]*(?:на[\\s\\xa0]*Сирах|Премъдрост[\\s\\xa0]*на[\\s\\xa0]*Иисуса,[\\s\\xa0]*син[\\s\\xa0]*Сирахов|Сираха)|The[\\s\\xa0]*Wisdom[\\s\\xa0]*of[\\s\\xa0]*Jesus(?:[\\s\\xa0]*(?:Son[\\s\\xa0]*of[\\s\\xa0]*Sirach|ben[\\s\\xa0]*Sirach)|,[\\s\\xa0]*Son[\\s\\xa0]*of[\\s\\xa0]*Sirach)|Прем(?:ъдрост[\\s\\xa0]*на[\\s\\xa0]*Иисус,[\\s\\xa0]*син[\\s\\xa0]*Сирахов|удр(?:ість[\\s\\xa0]*Ісуса,[\\s\\xa0]*сина[\\s\\xa0]*Сирахова|ост(?:ь[\\s\\xa0]*Сираха|и[\\s\\xa0]*И(?:суса[\\s\\xa0]*сина[\\s\\xa0]*Сирахова|исуса,[\\s\\xa0]*сына[\\s\\xa0]*Сирахова))))|Сир(?:ина)?|சீ(?:ராக்(?:[\\s\\xa0]*ஆகமம்|கின்[\\s\\xa0]*ஞானம்)|ஞா)|يشوع[\\s\\xa0]*بن[\\s\\xa0]*سيراخ|ספר[\\s\\xa0]*בן[\\s\\xa0]*סירא|Oratio[\\s\\xa0]*Iesu[\\s\\xa0]*filii[\\s\\xa0]*Sirach|S(?:i(?:r(?:àcide|á(?:c(?:id[ae]s?|h)?|k(?:[\\s\\xa0]*(?:fia|b[oö]lcsess(?:[eé]ge))|id[ae]s?|h))|a(?:k(?:[\\s\\xa0]*(?:fia|b[oö]lcsess(?:[eé]ge))|s(?:[\\s\\xa0]*(?:Bog|bok)|b[oó]k)|i(?:n[\\s\\xa0]*kirja|d[ae]s?))|c(?:id(?:as?|es)|hovec)))?)?|apienza[\\s\\xa0]*di[\\s\\xa0]*Sirac(?:ide|h)|yr(?:ak)?|ír(?:a(?:ksb[oó]k|chovec))?)|シラ(?:フの子イイススの知恵書|書（集会の書）)?|집회서?|벤시(?:리크의[\\s\\xa0]*지혜|라(?:[\\s\\xa0]*지혜|의[\\s\\xa0]*지혜|크(?:[\\s\\xa0]*지혜|의[\\s\\xa0]*지혜)))|Екле(?:сіаст|зијастикус)|Бен[\\s\\xa0]*Сираха|บุตรสิรา|Y(?:bS|oshua[\\s\\xa0]*bin[\\s\\xa0]*Sira)|M[aą]dro(?:[sś](?:[cć][\\s\\xa0]*Syracha))|E(?:c(?:le(?:si[aá]stico|ziastic)|c(?:s|l(?:esiasti(?:que|c(?:ul|o))|us(?:iasticus)?|ésiastique)))|k(?:l(?:e(?:zjastyka?|s(?:[iy]astik(?:us|o)))|i)|kle(?:s(?:[iy]astik(?:us|o))|ziastik)))|Huấn[\\s\\xa0]*Ca|《德訓篇》|(?:[ヘベ]ン・シラの(?:智慧|知恵))|س(?:فر[\\s\\xa0]*ابن[\\s\\xa0]*سيراخ|ي)|K(?:arunungan[\\s\\xa0]*ng[\\s\\xa0]*Anak[\\s\\xa0]*ni[\\s\\xa0]*Sirac|\\.[\\s\\xa0]*(?:Ekleziastikus|Sirachov(?:c(?:ova|a)|ho[\\s\\xa0]*syna))|[\\s\\xa0]*(?:Ekleziastikus|Sirachov(?:c(?:ova|a)|ho[\\s\\xa0]*syna))|n(?:jiga[\\s\\xa0]*Sirahova|iha[\\s\\xa0]*(?:Ekleziastikus|S(?:irachov(?:c(?:ova|a)|ho[\\s\\xa0]*syna)|írachovcova)))|itab[\\s\\xa0]*Yesus[\\s\\xa0]*bin[\\s\\xa0]*Sirakh)|Σοφ[ίι]α[\\s\\xa0]*Σ(?:ειρ(?:[άα]χ|ιραχ))|Cartea[\\s\\xa0]*[iî]n(?:[tţ]elepciunii[\\s\\xa0]*lui[\\s\\xa0]*Isus,[\\s\\xa0]*fiul[\\s\\xa0]*lui[\\s\\xa0]*Sirah)|ИсС|Wijsheid[\\s\\xa0]*van[\\s\\xa0]*(?:J(?:ezus[\\s\\xa0]*Sirach|ozua[\\s\\xa0]*Ben[\\s\\xa0]*Sirach)|Ben[\\s\\xa0]*Sirach)|Ang[\\s\\xa0]*Karunungan[\\s\\xa0]*ni[\\s\\xa0]*Jesus(?:,[\\s\\xa0]*Anak[\\s\\xa0]*ni[\\s\\xa0]*Sirac|[\\s\\xa0]*Anak[\\s\\xa0]*ni[\\s\\xa0]*Sirac))|Σοφ(?:[ίι]α[\\s\\xa0]*Σιραχ)|(?:S(?:yracha|agesse[\\s\\xa0]*de[\\s\\xa0]*Ben[\\s\\xa0]*Sira|i(?:r(?:ák|a(?:k(?:in|h)?|c(?:h(?:ovcova)?|ide)?)?)|irakin(?:[\\s\\xa0]*kirja)?))|Ben[\\s\\xa0]*Sira|集会の書|Σειρ[αά]χ|シラ書|سيراخ|《德訓篇|Сирах(?:а|ова?)|Wisdom[\\s\\xa0]*of[\\s\\xa0]*Jesus(?:[\\s\\xa0]*(?:Son[\\s\\xa0]*of[\\s\\xa0]*Sirach|ben[\\s\\xa0]*Sirach)|,[\\s\\xa0]*Son[\\s\\xa0]*of[\\s\\xa0]*Sirach)|Jezus[\\s\\xa0]*Sirach|德訓篇》?|Ecclesiasticus))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["PrMan"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Manasses[\\s\\xa0]*bønn|(?:Da(?:sal[\\s\\xa0]*ni[\\s\\xa0]*Manases|langin[\\s\\xa0]*ni[\\s\\xa0]*Manases)|Pr(?:\\.[\\s\\xa0]*Man(?:ass[eé])?|[\\s\\xa0]*Man(?:ass[eé])?|e(?:ghiera[\\s\\xa0]*di[\\s\\xa0]*Manasse|ce[\\s\\xa0]*de[\\s\\xa0]*Manass[eé]s))|Or(?:[\\s\\xa0]*Man|a(?:zione[\\s\\xa0]*di[\\s\\xa0]*Manasse[\\s\\xa0]*Re[\\s\\xa0]*di[\\s\\xa0]*Giuda|tio[\\s\\xa0]*(?:regis[\\s\\xa0]*Manassae|Manassae))|\\.[\\s\\xa0]*Man)|Πρ(?:οσευχ[ήη][\\s\\xa0]*Μανασσ[ήη]|[\\s\\xa0]*Μαν)|B(?:æn[\\s\\xa0]*Manasse|Mn)|The[\\s\\xa0]*Pr(?:ayer(?:s[\\s\\xa0]*(?:Manasseh|of[\\s\\xa0]*Manasseh)|[\\s\\xa0]*(?:Manasseh|of[\\s\\xa0]*Manasseh))|[\\s\\xa0]*(?:Manasseh|of[\\s\\xa0]*Manasseh))|《PrMan》|صلاة[\\s\\xa0]*منسى|La[\\s\\xa0]*(?:Pri[eè]re[\\s\\xa0]*de[\\s\\xa0]*Manass[eé]|Oraci[oó]n[\\s\\xa0]*de[\\s\\xa0]*Manas(?:[eé]s))|므나쎄의[\\s\\xa0]*기도|M(?:odlit(?:bu[\\s\\xa0]*Manasse|wa[\\s\\xa0]*Manassesa)|an(?:[\\s\\xa0]*ru|as(?:s(?:é[\\s\\xa0]*im[aá]ds(?:[aá]ga)|ze[\\s\\xa0]*im[aá]ja|e(?:s(?:[\\s\\xa0]*(?:Bøn|b[oö]n)|’[\\s\\xa0]*b[oö]n)|[\\s\\xa0]*(?:im[aá]ds(?:[aá]ga)|b[oö]n)|n[\\s\\xa0]*rukouksen))|esova[\\s\\xa0]*modlitba)))|マナセの(?:いのり|祈[り禱])|G(?:eb(?:et[\\s\\xa0]*(?:Manasses?|des[\\s\\xa0]*Manasse)|[\\s\\xa0]*Man)|weddi[\\s\\xa0]*Manasse)|תפילת[\\s\\xa0]*מנשה|Молитва[\\s\\xa0]*Манас(?:сии|ијина)|Rug(?:[aă]ciunea[\\s\\xa0]*(?:lui[\\s\\xa0]*Manase|regelui[\\s\\xa0]*Manase))|Ang[\\s\\xa0]*Panalangin[\\s\\xa0]*ni[\\s\\xa0]*Manases)|(?:Man(?:as(?:e|se))?|《PrMan|P(?:r(?:ayer(?:s[\\s\\xa0]*(?:Manasseh|of[\\s\\xa0]*Manasseh)|[\\s\\xa0]*(?:Manasseh|of[\\s\\xa0]*Manasseh))|i[èe]re[\\s\\xa0]*de[\\s\\xa0]*Manass[eé]|[\\s\\xa0]*(?:Manasseh|of[\\s\\xa0]*Manasseh)|Man》?)|analangin[\\s\\xa0]*ni[\\s\\xa0]*Manases)|Ora(?:ci[óo]n[\\s\\xa0]*de[\\s\\xa0]*Manas(?:[ée]s)|zione[\\s\\xa0]*di[\\s\\xa0]*Manasse)))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Acts"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Дап|(?:Д(?:е(?:ла[\\s\\xa0]*(?:Ап(?:остолска)?|на[\\s\\xa0]*(?:апостолите|светите[\\s\\xa0]*апостоли))|ян(?:ия(?:[\\s\\xa0]*на[\\s\\xa0]*(?:апостолите|светите[\\s\\xa0]*Апостоли)|та[\\s\\xa0]*на[\\s\\xa0]*апостолите))?)|[\\s\\xa0]*А|\\.[\\s\\xa0]*А|і(?:ян(?:ня[\\s\\xa0]*Святих[\\s\\xa0]*Апостолів)?|(?:[ії][\\s\\xa0]*(?:Апостолів|святих[\\s\\xa0]*апостолів))))|Πρ(?:ξ|[άα]ξ(?:εις[\\s\\xa0]*των[\\s\\xa0]*Αποστ(?:[οό]λων)?))|Osu|D(?:ijannja[\\s\\xa0]*svjaty[hȟ][\\s\\xa0]*apostoliv|z(?:[\\s\\xa0]*Ap|iej(?:e[\\s\\xa0]*Apost(?:olskie)?|ach[\\s\\xa0]*Apostolskich))|j(?:ela[\\s\\xa0]*apostolska)?)|मसीह-?दूत|L(?:elakone[\\s\\xa0]*Para[\\s\\xa0]*Rasul|os[\\s\\xa0]*Hechos[\\s\\xa0]*de[\\s\\xa0]*los[\\s\\xa0]*Ap[oó]stoles)|P(?:raeriton[\\s\\xa0]*Ke[\\s\\xa0]*Kam|ostulasagan)|ﺍﻋﻤﺎﻝ[\\s\\xa0]*ﺍﻟﺮﺳﻞ|سفر[\\s\\xa0]*أعمال[\\s\\xa0]*الرسل|《(?:徒》|使徒行[传傳]》|宗徒(?:大事錄》|行實》))|ก(?:ิจการ​ของ​อัครทูต|จ)|Vep(?:rat[\\s\\xa0]*e[\\s\\xa0]*Apostujve)?|Sk(?:utky[\\s\\xa0]*apo(?:[sš]tol(?:ov|sk[eé]|[uů])))?|G(?:awa[\\s\\xa0]*ng[\\s\\xa0]*Apostoles|w)|தி(?:ருத்தூதர்[\\s\\xa0]*பணிகள்|ப)|T(?:ravay[\\s\\xa0]*ap[oò]t[\\s\\xa0]*yo|he[\\s\\xa0]*Acts[\\s\\xa0]*of[\\s\\xa0]*the[\\s\\xa0]*Apostles)|H(?:ch?|and(?:elingen[\\s\\xa0]*(?:der[\\s\\xa0]*apostelen|van[\\s\\xa0]*de[\\s\\xa0]*apostelen))?|ech?|nd)|使徒(?:行[伝録]|書|言行録)?|ا(?:َعمال|ع)|Ebanghelyo[\\s\\xa0]*ng[\\s\\xa0]*Espiritu[\\s\\xa0]*Santo|rasūl(?:āṃ[\\s\\xa0]*de[\\s\\xa0]*kartabb|ōṅ[\\s\\xa0]*ke[\\s\\xa0]*aʿmāl)|یوحنا[\\s\\xa0]*کے[\\s\\xa0]*اعمال|A(?:k(?:syon[\\s\\xa0]*ap[oò]t[\\s\\xa0]*yo|d[eè]zapot)|ng[\\s\\xa0]*Mga[\\s\\xa0]*Binuhatan|t(?:os[\\s\\xa0]*dos[\\s\\xa0]*Ap[oó]stolos|ti[\\s\\xa0]*degli[\\s\\xa0]*Apostoli)?|z[\\s\\xa0]*(?:apostolok[\\s\\xa0]*cselekedetei|ApCsel)|p(?:ost(?:l(?:enes(?:[\\s\\xa0]*(?:Gerninger|gjerninger)|-?gjerninge)|ag[aä]rningarna)|olien[\\s\\xa0]*teot|elg(?:jerningene|eschichte))|[\\s\\xa0]*(?:Csel|t)|\\.(?:[\\s\\xa0]*(?:Csel|t)|[Gt])|p[oō]stalar[\\s\\xa0]*Pa(?:[nṇ]i)|[Gt])|c(?:t(?:sss?|es[\\s\\xa0]*des[\\s\\xa0]*Ap[oô]tres|a(?:u['’]r[\\s\\xa0]*Apostolion)?|us[\\s\\xa0]*Apostolorum)?)?)|M(?:do|ga[\\s\\xa0]*Gawa(?:in|[\\s\\xa0]*ng[\\s\\xa0]*mga[\\s\\xa0]*A(?:postol(?:es)?|lagad))|a(?:buting[\\s\\xa0]*Balita[\\s\\xa0]*(?:ayon[\\s\\xa0]*sa[\\s\\xa0]*Espiritu[\\s\\xa0]*Santo|ng[\\s\\xa0]*Espiritu[\\s\\xa0]*Santo)|tendo[\\s\\xa0]*ya[\\s\\xa0]*Mitume))|pre(?:[sš]it(?:[aā](?:[mṃ]c(?:[iī](?:[mṃ][\\s\\xa0]*kr̥tye[mṃ]))))|rithar[uū]k(?:[aā][\\s\\xa0]*k(?:[aā]m)))|F(?:a(?:l(?:imaha[\\s\\xa0]*Rasuullada)?|p(?:t(?:e(?:le[\\s\\xa0]*Apostolilor|[\\s\\xa0]*Apostolilor))?)?)|[\\s\\xa0]*Ap|\\.(?:[\\s\\xa0]*Ap|A)|A)|מעשי[\\s\\xa0]*השליחים|அப்(?:போ(?:ஸ்தலர(?:ுடைய[\\s\\xa0]*நடபடிகள்|்[\\s\\xa0]*பணி))?)?|ପ୍ରେରିତ(?:ମାନଙ୍କ[\\s\\xa0]*କାର୍ଯ୍ୟର[\\s\\xa0]*ବିବରଣ)?|사도(?:행전)?|B(?:uhat[\\s\\xa0]*sa[\\s\\xa0]*mga[\\s\\xa0]*Apostoles|in)|ਰਸੂਲਾਂ[\\s\\xa0]*ਦੇ[\\s\\xa0]*ਕਰਤੱਬ|Yesuusi[\\s\\xa0]*Kiittidoogeetu[\\s\\xa0]*Oosuwaa|رس(?:ُولوں[\\s\\xa0]*کے[\\s\\xa0]*اعمال|ولوں[\\s\\xa0]*کے[\\s\\xa0]*اعمال)|C(?:selekedetek|ông[\\s\\xa0]*vụ[\\s\\xa0]*(?:Tông[\\s\\xa0]*đồ|các[\\s\\xa0]*Sứ[\\s\\xa0]*đồ))|प्र(?:\\.(?:[\\s\\xa0]*क|क)|[\\s\\xa0]*क|क|े(?:रित(?:हरूका[\\s\\xa0]*काम|ों[\\s\\xa0]*के[\\s\\xa0]*काम(?:ों)?)?|षितांची(?:[\\s\\xa0]*कृत्यें|ं[\\s\\xa0]*कृत्यें?))))|Πρ(?:[άα]ξ)|(?:أعمال[\\s\\xa0]*الرسل|G(?:awa(?:[\\s\\xa0]*ng[\\s\\xa0]*mga[\\s\\xa0]*Apostol)?|erninger)|宗徒(?:大事錄》?|行實》?)|使徒行[傳传]》?|徒》?|S(?:ứ[\\s\\xa0]*đồ|kutky)|Dz(?:ieje)?|《(?:宗徒(?:行實|大事錄)|使徒行[傳传]|徒)|Д(?:і(?:яння|[їі])|е(?:ла|яния))|Veprat(?:[\\s\\xa0]*e[\\s\\xa0]*apostujve)?|Πρ[αά]ξεις|Los[\\s\\xa0]*Hechos|T(?:ravay|eot)|Fapte(?:le)?|กิจการ|A(?:ct(?:s(?:[\\s\\xa0]*of[\\s\\xa0]*the[\\s\\xa0]*Apostles)?|[ue]s|au)|t(?:ti|os)|p(?:ostolok(?:[\\s\\xa0]*cselekedetei)?|Csel|g))|H(?:andelingen|echos(?:[\\s\\xa0]*de[\\s\\xa0]*los[\\s\\xa0]*Ap[óo]stoles)?)|اعمال|Công(?:[\\s\\xa0]*Vụ)?|அப்போஸ்தலர்|Binuhatan|M(?:atendo|ga[\\s\\xa0]*Gawa)|رسولوں|Para[\\s\\xa0]*Rasul))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Rev"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Johannesapokalypsen|(?:Muuj(?:intii)?|தி(?:வெ|ருவெளிப்பாடு)|y(?:uhann[aā]l(?:[aā](?:[iī][\\s\\xa0]*bʰaeko[\\s\\xa0]*prak(?:[aā][sš])))|oh[aā]n(?:[aā]l(?:[aā][\\s\\xa0]*ǳʰ(?:[aā]lele[\\s\\xa0]*praka(?:[tṭ](?:[iī]kara[nṇ])))))|ū(?:h(?:ann[aā]l(?:[aā](?:[iī][\\s\\xa0]*bʰaeko[\\s\\xa0]*prak(?:[aā][sš])))|ãnā[\\s\\xa0]*de[\\s\\xa0]*prakāš[\\s\\xa0]*dī[\\s\\xa0]*potʰī)|ḥannā[\\s\\xa0]*ʿārif[\\s\\xa0]*kā[\\s\\xa0]*mukāšafâ))|U(?:f(?:u(?:nu(?:o[\\s\\xa0]*wa[\\s\\xa0]*Yohan[ae]|a[\\s\\xa0]*wa[\\s\\xa0]*Yohana))?)?|pp(?:enbarelseboken)?)|Z(?:j(?:av(?:enie[\\s\\xa0]*(?:J[aá]na|sv[aä]t(?:[eé]ho[\\s\\xa0]*J(?:[aá]na))|Apo[sš]tola[\\s\\xa0]*J(?:[aá]na)))?|even(?:i[\\s\\xa0]*(?:Janovo|svat[eé]ho[\\s\\xa0]*Jana)|í[\\s\\xa0]*Janovo)|v)?|b(?:u(?:lesa)?)?)|O(?:b(?:j(?:awienie[\\s\\xa0]*(?:Jana|(?:[sś]w(?:\\.[\\s\\xa0]*Jana|[\\s\\xa0]*Jana))))?|['’]javlennja[\\s\\xa0]*Ivana[\\s\\xa0]*Bohoslova)|tk(?:rivenje[\\s\\xa0]*Ivanovo)?|ff(?:b|enbarung)|p(?:inberun(?:arb(?:[oó]k(?:in|[\\s\\xa0]*J[oó]hannesar))|[\\s\\xa0]*J[oó]hannesar)|enb(?:aring(?:en|[\\s\\xa0]*van[\\s\\xa0]*Johannes))?|b)?)|ว(?:ิวรณ์|ว)|K(?:hải[\\s\\xa0]*(?:Huyền[\\s\\xa0]*của[\\s\\xa0]*John|thị)|itab[\\s\\xa0]*Wahyu|s(?:i(?:[eę]g(?:[ai][\\s\\xa0]*(?:Objawienia|Apokalipsy)))|[\\s\\xa0]*(?:Objawienia|Apokalipsy)|\\.[\\s\\xa0]*(?:Objawienia|Apokalipsy))|niha[\\s\\xa0]*Zjeven[ií])|A(?:benbaring(?:en|sbogen)|p(?:o(?:c(?:al(?:yps(?:e[\\s\\xa0]*de[\\s\\xa0]*Jean|is[\\s\\xa0]*Ioannis[\\s\\xa0]*Apostoli)?|i(?:sse[\\s\\xa0]*di[\\s\\xa0]*Giovanni|ps(?:a[\\s\\xa0]*lui[\\s\\xa0]*Ioan|e[\\s\\xa0]*de[\\s\\xa0]*(?:Jo[aã]o|S[aã]o[\\s\\xa0]*Jo(?:[aã]o))|is[\\s\\xa0]*ni[\\s\\xa0]*Juan))))?|k(?:al(?:ips(?:a[\\s\\xa0]*(?:[SŚ]wi(?:[eę]tego[\\s\\xa0]*Jana)|(?:[sś]w(?:\\.[\\s\\xa0]*Jana|[\\s\\xa0]*Jana)))|zis|is[\\s\\xa0]*ni[\\s\\xa0]*Juan)?|yps(?:en|a)))?)?|[ck]|enbaring(?:en|sboken))?|abenbaringen|j(?:u|juutaa))|ଯୋହନଙ୍କ[\\s\\xa0]*ପ୍ରତି[\\s\\xa0]*ପ୍ରକାଶିତ[\\s\\xa0]*ବାକ୍ୟ|黙示録|Ve[lḷ]ippa(?:[tṭ]utti(?:[nṉ]a[\\s\\xa0]*Vic(?:[eē](?:[tṭ]a(?:[nṅ]ka[lḷ])))))|Απ(?:οκ(?:αλ(?:ύψεις|υψ(?:ις[\\s\\xa0]*Ιω[άα]ννου|εις|η))|άλυψ(?:ις[\\s\\xa0]*Ιω[άα]ννου|η))?)?|வெளி(?:ப்படுத்தின[\\s\\xa0]*விசேடங்கள்)?|El[\\s\\xa0]*Apocalipsis|P(?:a(?:medaran|h(?:ayag[\\s\\xa0]*kay[\\s\\xa0]*Juan)?)|rakashaitavakya)|᾿Απ|य(?:ोहानाला[\\s\\xa0]*झालेले[\\s\\xa0]*प्रकटीकरण|ूहन्नालाई[\\s\\xa0]*भएको[\\s\\xa0]*प्रकाश)|חזון[\\s\\xa0]*יוחנן|ヨハネの[默黙]示録|요한(?:[계묵]시록|[\\s\\xa0]*[계묵]시록)|J(?:oh(?:anne(?:ksen[\\s\\xa0]*ilmestys|s(?:[\\s\\xa0]*(?:Uppenbarelse|apokalyps)|['’][\\s\\xa0]*(?:(?:[AÅ]benbaring|[aå]penbaring))))|s(?:[\\s\\xa0]*[AÅ]benbaring|\\.[\\s\\xa0]*[AÅ]benbaring))|el(?:en[eé]sek)?|[aá]nos[\\s\\xa0]*jelen(?:[eé]sei))|《(?:啟(?:》|示錄》)|若望默示錄》|启(?:示录》|》)|[啓默]示錄》)|رؤ(?:يا[\\s\\xa0]*يوحنا)?|Gipadayag|प्र(?:काशित(?:-?वाक्‍य|[\\s\\xa0]*वाक्य|वाक्य)|[\\s\\xa0]*व|\\.[\\s\\xa0]*व)|R(?:iv(?:elazione)?|e(?:belasyon|v(?:el(?:a(?:syon|tions?))?|[ao]lations?|lations?)?)|v)|ਯੂਹੰਨਾ[\\s\\xa0]*ਦੇ[\\s\\xa0]*ਪਰਕਾਸ਼[\\s\\xa0]*ਦੀ[\\s\\xa0]*ਪੋਥੀ|묵시|Dat(?:gudd(?:iad)?)?|Відкриття[\\s\\xa0]*Івана|ה(?:תגלות|התגלות)|Ilm(?:estyskirja)?|О(?:дкр(?:овення[\\s\\xa0]*Івана[\\s\\xa0]*Богослова|иттє)|тк(?:р(?:ивење[\\s\\xa0]*Јованово|ове(?:ние(?:[\\s\\xa0]*на[\\s\\xa0]*(?:св(?:[\\s\\xa0]*Иоана[\\s\\xa0]*Богослова|\\.[\\s\\xa0]*Иоана[\\s\\xa0]*Богослова)|[ИЙ]оан)|то[\\s\\xa0]*на[\\s\\xa0]*[ИЙ]оан)|ње[\\s\\xa0]*Јованово))?)?|б['’]явлення[\\s\\xa0]*(?:св(?:\\.[\\s\\xa0]*(?:(?:[ИЙ]оана[\\s\\xa0]*Богослова|Івана[\\s\\xa0]*Богослова)|[\\s\\xa0]*(?:[ИЙ]оана[\\s\\xa0]*Богослова|Івана[\\s\\xa0]*Богослова))|Івана[\\s\\xa0]*Богослова)))|Апок(?:[aá]ліпсис|а(?:́ліпсис|л[iíиі]псис))|ی(?:و[\\s\\xa0]*حنا[\\s\\xa0]*عارف[\\s\\xa0]*کا[\\s\\xa0]*مکاشفہ|ُو(?:[\\s\\xa0]*حنّا[\\s\\xa0]*عارِف[\\s\\xa0]*کا[\\s\\xa0]*مُکاشفہ|حنا[\\s\\xa0]*عارف[\\s\\xa0]*کا[\\s\\xa0]*مکاشفہ))|ﻳﻮﺣﻨﺎ[\\s\\xa0]*ﺭﺅﻳﺎ|யோவானுக்கு[\\s\\xa0]*வெளிப்படுத்தின[\\s\\xa0]*விசேஷம்|الرؤيــا|Å(?:b(?:enbaring(?:en|sbogen))?|p(?:enbaring(?:en|sboken))?))|Об['’]явлення[\\s\\xa0]*(?:св[\\s\\xa0]*(?:(?:[ИЙ]оана[\\s\\xa0]*Богослова|Івана[\\s\\xa0]*Богослова)|Івана[\\s\\xa0]*Богослова))|Об(?:['’]явлення[\\s\\xa0]*Івана[\\s\\xa0]*Богослова)|(?:प्रक(?:ाश|टीकरण)|Ilmestys|啟(?:》|示錄》?)?|Wahyu|ਪਰਕਾਸ਼[\\s\\xa0]*ਦੀ[\\s\\xa0]*ਪੋਥੀ|O(?:tkrivenje|penbaring|bjawienie)|Zj(?:avenie|even[ií])|Khải(?:[\\s\\xa0]*Huyền)?|م(?:کاشفہ|ُکاشفہ)|Ve[lḷ]ippa(?:[tṭ]utti(?:[ṉn]a))|启(?:示录》?|》)?|[默啓]示錄》?|yūhãnā[\\s\\xa0]*de[\\s\\xa0]*prakāš|若望默示錄》?|О(?:ткр(?:овение|ивење)|б(?:['’]явлення)?)|Pahayag|praka[tṭ](?:[īi]kara[ṇn])|Ap(?:o(?:kalips(?:is|a)|cal(?:i(?:ps(?:is|[ea])|sse)|yps(?:is(?:[\\s\\xa0]*Ioannis)?|e)))|enbaring)|《(?:启(?:示录)?|[默啓]示錄|啟(?:示錄)?|若望默示錄)|Ufunuo))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["PrAzar"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:P(?:r(?:Azr|\\.[\\s\\xa0]*Azar|[\\s\\xa0]*Azar|eghiera[\\s\\xa0]*di[\\s\\xa0]*Azaria)|ie[sś](?:[nń][\\s\\xa0]*Azariasza))|תפילת[\\s\\xa0]*עזריה[\\s\\xa0]*בתוך[\\s\\xa0]*הכבשן|ア[サザ]ルヤの祈り|La[\\s\\xa0]*Pri[eè]re[\\s\\xa0]*d(?:['’]Azaria[hs])|Sal(?:[\\s\\xa0]*Azar|mo[\\s\\xa0]*de[\\s\\xa0]*Azarias)|Or(?:\\.[\\s\\xa0]*Azar|a(?:ci[oó]n[\\s\\xa0]*de[\\s\\xa0]*Azar(?:[ií]as)|tio[\\s\\xa0]*Azariae)|[\\s\\xa0]*Az(?:ar)?)|C[aá]ntico[\\s\\xa0]*de[\\s\\xa0]*Azar(?:[ií]as)|Modlitw[aą][\\s\\xa0]*Azariasza|《PrAzar》|The[\\s\\xa0]*Pr(?:[\\s\\xa0]*of[\\s\\xa0]*Azariah?|ayer(?:s[\\s\\xa0]*of[\\s\\xa0]*Azariah?|[\\s\\xa0]*of[\\s\\xa0]*Azariah?))|G(?:weddi[\\s\\xa0]*Asarias|eb(?:e(?:t[\\s\\xa0]*des[\\s\\xa0]*Asarja|d[\\s\\xa0]*van[\\s\\xa0]*Azarja)|[\\s\\xa0]*As))|A(?:z(?:ári[aá]s[\\s\\xa0]*im(?:[aá](?:ds(?:[aá]ga|ja)))|ar(?:i[aá]s[\\s\\xa0]*im(?:[aá](?:ds(?:[aá]ga|ja)))|j(?:á[sš]ova[\\s\\xa0]*modlitba|a(?:s(?:[\\s\\xa0]*Bøn|ova[\\s\\xa0]*modlitba)|šova[\\s\\xa0]*modlitba))))|sar(?:[\\s\\xa0]*ru|ja(?:s(?:[\\s\\xa0]*b(?:ønn|[oö]n)|’[\\s\\xa0]*b[oö]n)|n[\\s\\xa0]*rukous)|ias(?:[\\s\\xa0]*b[oö]n|’[\\s\\xa0]*b[oö]n))|ng[\\s\\xa0]*Panalangin[\\s\\xa0]*ni[\\s\\xa0]*Azarias)|Πρ(?:[\\s\\xa0]*Αζαρ|οσευχ[ήη][\\s\\xa0]*Αζαρ(?:[ίι]ου))|Молитва[\\s\\xa0]*Азар(?:і[ії]|ия)|அசரியா|صلاة[\\s\\xa0]*عزريا|Rug[aă]ciunea[\\s\\xa0]*lui[\\s\\xa0]*Azaria|Bæn[\\s\\xa0]*Asarja)|Az[aá]ri(?:[aá]s[\\s\\xa0]*im(?:[aá]ja))|(?:תפילת[\\s\\xa0]*עזריה|Azar(?:ia[sh]?|ías|jas[\\s\\xa0]*bøn)|《PrAzar|P(?:analangin[\\s\\xa0]*ni[\\s\\xa0]*Azarias|r(?:i[èe]re[\\s\\xa0]*d(?:['’]Azaria[hs])|Azar》?|[\\s\\xa0]*of[\\s\\xa0]*Azariah?|ayer(?:s[\\s\\xa0]*of[\\s\\xa0]*Azariah?|[\\s\\xa0]*of[\\s\\xa0]*Azariah?)))))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["SgThree"],
        apocrypha: true,
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])((?:《SgThree》|P(?:íse[nň][\s\xa0]*ml(?:[aá]denc(?:[uů][\s\xa0]*v[\s\xa0]*ho(?:[rř](?:[ií]c(?:[ií][\s\xa0]*peci)))))|i(?:e(?:s(?:n(?:[\s\xa0]*trzech[\s\xa0]*młodzie[nń]c(?:[oó]w)|i[aą][\s\xa0]*trzech[\s\xa0]*młodzie(?:[nń]c(?:[oó]w)))|e[nň][\s\xa0]*ml(?:[aá]dencov[\s\xa0]*v[\s\xa0]*ohnivej[\s\xa0]*peci)|ń[\s\xa0]*trzech[\s\xa0]*młodzie[nń]c(?:[oó]w))|ś(?:n(?:[\s\xa0]*trzech[\s\xa0]*młodzie[nń]c(?:[oó]w)|i[aą][\s\xa0]*trzech[\s\xa0]*młodzie(?:[nń]c(?:[oó]w)))|ń[\s\xa0]*trzech[\s\xa0]*młodzie[nń]c(?:[oó]w)))|se[nň][\s\xa0]*ml(?:[aá]denc(?:[uů][\s\xa0]*v[\s\xa0]*ho(?:[rř](?:[ií]c(?:[ií][\s\xa0]*peci)))))))|இளைஞர்[\s\xa0]*மூவரின்[\s\xa0]*பாடல்|שירת[\s\xa0]*שלושת[\s\xa0]*הנערים[\s\xa0]*בכבשן|Благодарственная[\s\xa0]*песнь[\s\xa0]*отроков|三(?:童兒の歌|人の若者の賛歌)|H(?:[aá]rom[\s\xa0]*fiatalember[\s\xa0]*(?:[eé]neke)|ymnus[\s\xa0]*trium[\s\xa0]*puerorum)|C(?:3J|t[\s\xa0]*3[\s\xa0]*(?:E|J[oó])|an(?:t(?:area[\s\xa0]*celor[\s\xa0]*trei[\s\xa0]*(?:evrei|tineri)|i(?:que[\s\xa0]*des[\s\xa0]*(?:3[\s\xa0]*Enfants|Trois[\s\xa0]*Enfants)|co[\s\xa0]*d(?:ei[\s\xa0]*tre[\s\xa0]*(?:fanciulli|giovani[\s\xa0]*nella[\s\xa0]*fornace)|os[\s\xa0]*(?:Tr[eê]s[\s\xa0]*Jovens|3[\s\xa0]*Jovens))))|[\s\xa0]*y[\s\xa0]*Tri[\s\xa0]*L(?:anc|lanc))|ân(?:t(?:ico[\s\xa0]*dos[\s\xa0]*(?:Tr[eê]s[\s\xa0]*Jovens|3[\s\xa0]*Jovens)|area[\s\xa0]*celor[\s\xa0]*trei[\s\xa0]*(?:evrei|tineri))|[\s\xa0]*y[\s\xa0]*Tri[\s\xa0]*L(?:anc|lanc)))|T(?:ři[\s\xa0]*mu[zž]i[\s\xa0]*v[\s\xa0]*rozp(?:[aá]len(?:[eé][\s\xa0]*peci))|he[\s\xa0]*Song[\s\xa0]*of[\s\xa0]*(?:3[\s\xa0]*(?:You(?:ng[\s\xa0]*Men|ths)|Holy[\s\xa0]*Children|Jews)|Three[\s\xa0]*(?:You(?:ng[\s\xa0]*Men|ths)|Holy[\s\xa0]*Children|Jews)|the[\s\xa0]*(?:3[\s\xa0]*(?:You(?:ng[\s\xa0]*Men|ths)|Holy[\s\xa0]*Children|Jews)|Three[\s\xa0]*(?:You(?:ng[\s\xa0]*Men|ths)|Holy[\s\xa0]*Children|Jews)))|r(?:aja[\s\xa0]*ml[aá]denci[\s\xa0]*v[\s\xa0]*rozp(?:[aá]lenej[\s\xa0]*peci)|i[\s\xa0]*mu[zž]i[\s\xa0]*v[\s\xa0]*rozp(?:[aá]len(?:[eé][\s\xa0]*peci))))|П(?:еснь[\s\xa0]*тр[её]х[\s\xa0]*отроков|існя[\s\xa0]*трьох[\s\xa0]*отроків)|[ΎΥ]μνος[\s\xa0]*των[\s\xa0]*Τρι(?:[ωώ]ν[\s\xa0]*Πα(?:[ίι]δων))|Молитва[\s\xa0]*святых[\s\xa0]*трех[\s\xa0]*отроков|S(?:[\s\xa0]*(?:of[\s\xa0]*(?:3(?:[\s\xa0]*(?:Ch|Y)|\.[\s\xa0]*(?:Ch|Y))|Th(?:[\s\xa0]*(?:Ch|Y)|\.[\s\xa0]*(?:Ch|Y)|ree(?:[\s\xa0]*(?:Ch|Y)|\.[\s\xa0]*(?:Ch|Y))))|3(?:[\s\xa0]*(?:Ch|Y)|\.[\s\xa0]*(?:Ch|Y))|Th(?:[\s\xa0]*(?:Ch|Y)|\.[\s\xa0]*(?:Ch|Y)|ree(?:[\s\xa0]*(?:Ch|Y)|\.[\s\xa0]*(?:Ch|Y))))|ong[\s\xa0]*Three|\.[\s\xa0]*(?:of[\s\xa0]*(?:3(?:[\s\xa0]*(?:Ch|Y)|\.[\s\xa0]*(?:Ch|Y))|Th(?:[\s\xa0]*(?:Ch|Y)|\.[\s\xa0]*(?:Ch|Y)|ree(?:[\s\xa0]*(?:Ch|Y)|\.[\s\xa0]*(?:Ch|Y))))|3(?:[\s\xa0]*(?:Ch|Y)|\.[\s\xa0]*(?:Ch|Y))|Th(?:[\s\xa0]*(?:Ch|Y)|\.[\s\xa0]*(?:Ch|Y)|ree(?:[\s\xa0]*(?:Ch|Y)|\.[\s\xa0]*(?:Ch|Y))))|g[\s\xa0]*Thr(?:ee)?|ng[\s\xa0]*Three)|Kolmen[\s\xa0]*(?:nuoren[\s\xa0]*miehen[\s\xa0]*ollessa[\s\xa0]*tulisessa[\s\xa0]*p[aä]tsiss[aä]|miehen[\s\xa0]*kiitosvirsi[\s\xa0]*tulessa)|El[\s\xa0]*(?:Canto[\s\xa0]*de[\s\xa0]*los[\s\xa0]*(?:Tres[\s\xa0]*J(?:[oó]venes[\s\xa0]*(?:Hebreos|Jud[ií]os))|3[\s\xa0]*J(?:[oó]venes[\s\xa0]*(?:Hebreos|Jud[ií]os)))|Himno[\s\xa0]*de[\s\xa0]*los[\s\xa0]*(?:Tres[\s\xa0]*J(?:[oó]venes[\s\xa0]*(?:Hebreos|Jud[ií]os))|3[\s\xa0]*J(?:[oó]venes[\s\xa0]*(?:Hebreos|Jud[ií]os))))|Gezang[\s\xa0]*der[\s\xa0]*drie[\s\xa0]*mannen[\s\xa0]*in[\s\xa0]*het[\s\xa0]*vuur|L(?:o(?:fs[oö]ngur[\s\xa0]*ungmennanna[\s\xa0]*þriggja|bgesang[\s\xa0]*der[\s\xa0]*(?:3[\s\xa0]*jungen[\s\xa0]*M[aä]nner|drei[\s\xa0]*jungen[\s\xa0]*M[aä]nner[\s\xa0]*im[\s\xa0]*Feuerofen))|3J|ied[\s\xa0]*van[\s\xa0]*de[\s\xa0]*drie[\s\xa0]*jongemannen)|De(?:[\s\xa0]*(?:Tre[\s\xa0]*Mænds[\s\xa0]*Lovsang|tre[\s\xa0]*m(?:enn(?:s[\s\xa0]*sang|enes[\s\xa0]*sang[\s\xa0]*føyer)|[aä]nnens[\s\xa0]*lovs(?:[aå]ng)))|r[\s\xa0]*Gesang[\s\xa0]*der[\s\xa0]*Drei[\s\xa0]*M[aä]nner[\s\xa0]*im[\s\xa0]*feurigen[\s\xa0]*Ofen)|3[\s\xa0]*tineri|Aw(?:[\s\xa0]*ng[\s\xa0]*3[\s\xa0]*Kab|it[\s\xa0]*ng[\s\xa0]*(?:3[\s\xa0]*Kabataan|Tatlong[\s\xa0]*(?:Kabataan(?:g[\s\xa0]*Banal)?|B(?:inata|anal[\s\xa0]*na[\s\xa0]*Kabataan))))|أنشودة[\s\xa0]*الأطفال[\s\xa0]*الثلاثة|Wimbo[\s\xa0]*wa[\s\xa0]*Vijana[\s\xa0]*Watatu)|(?:Himno[\s\xa0]*de[\s\xa0]*los[\s\xa0]*(?:3[\s\xa0]*J(?:[óo]venes(?:[\s\xa0]*(?:Hebreos|Jud[íi]os))?)|Tres[\s\xa0]*J[óo]venes(?:[\s\xa0]*Jud(?:[ií]os)?))|《SgThree|Lobgesang[\s\xa0]*der[\s\xa0]*drei[\s\xa0]*jungen[\s\xa0]*M[äa]nner|3[\s\xa0]*J[oó]venes|Gesang[\s\xa0]*der[\s\xa0]*Drei|De(?:r[\s\xa0]*Gesang[\s\xa0]*der[\s\xa0]*Drei|[\s\xa0]*tre[\s\xa0]*mænds[\s\xa0]*lovsang)|S(?:ong[\s\xa0]*of[\s\xa0]*(?:3[\s\xa0]*(?:You(?:ng[\s\xa0]*Men|ths)|Holy[\s\xa0]*Children|Jews)|Three[\s\xa0]*(?:You(?:ng[\s\xa0]*Men|ths)|Holy[\s\xa0]*Children|Jews)|the[\s\xa0]*(?:3[\s\xa0]*(?:You(?:ng[\s\xa0]*Men|ths)|Holy[\s\xa0]*Children|Jews)|Three[\s\xa0]*(?:You(?:ng[\s\xa0]*Men|ths)|Holy[\s\xa0]*Children|Jews)))|gThree》?)|Canto[\s\xa0]*de[\s\xa0]*los[\s\xa0]*(?:3[\s\xa0]*J(?:[óo]venes(?:[\s\xa0]*(?:Hebreos|Jud[ií]os))?)|Tres[\s\xa0]*J(?:[óo]venes(?:[\s\xa0]*(?:Hebreos|Jud[ií]os))?))|Kolmen[\s\xa0]*(?:miehen(?:[\s\xa0]*kiitosvirsi)?|nuoren[\s\xa0]*miehen)|T(?:re(?:s[\s\xa0]*J[óo]venes|i[\s\xa0]*tineri)|atlong[\s\xa0]*Kabataan))|Himno[\s\xa0]*de[\s\xa0]*los[\s\xa0]*Tres[\s\xa0]*J(?:[óo]venes))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["2Pet"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])(2\.[\s\xa0]*patrusko|(?:ਪਤਰਸ[\s\xa0]*ਦੀ[\s\xa0]*ਦੂਜੀ[\s\xa0]*ਪੱਤ੍ਰੀ|I(?:I(?:\.[\s\xa0]*(?:Пет(?:р(?:а|ов[ао])?|[аъ]р)?|San[\s\xa0]*Pedro|But(?:ros)?|п(?:ослан(?:и(?:ца[\s\xa0]*Петрова|е[\s\xa0]*на[\s\xa0]*апостол[\s\xa0]*Петар)|ня[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра))|исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Петар)|List[\s\xa0]*(?:(?:[sś]w(?:\.[\s\xa0]*Piotra|[\s\xa0]*Piotra))|Piotra)|P(?:i(?:otra?|e(?:rre|t(?:arin[\s\xa0]*kirje|ro))?|è)|y[eè]|e(?:r|t(?:r(?:u[sv]?|o(?:v(?:a[\s\xa0]*Poslanica)?)?|ův|i)?|er?)?|dro?)?|tr?|ét(?:rus|er)?|h(?:ê(?:rô|-?rơ)|i(?:-?(?:rơ|e-?rơ)|a-?rơ)))?|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра))|list[\s\xa0]*Petr[uů]v)|[\s\xa0]*(?:Пет(?:р(?:а|ов[ао])?|[аъ]р)?|San[\s\xa0]*Pedro|But(?:ros)?|п(?:ослан(?:и(?:ца[\s\xa0]*Петрова|е[\s\xa0]*на[\s\xa0]*апостол[\s\xa0]*Петар)|ня[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра))|исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Петар)|List[\s\xa0]*(?:(?:[sś]w(?:\.[\s\xa0]*Piotra|[\s\xa0]*Piotra))|Piotra)|P(?:i(?:otra?|e(?:rre|t(?:arin[\s\xa0]*kirje|ro))?|è)|y[eè]|tr?|e(?:t(?:er?|r(?:u[sv]?|o(?:v(?:a[\s\xa0]*Poslanica)?)?|ův)?)?|r|dro?)?|ét(?:rus|er)?|h(?:ê(?:rô|-?rơ)|i(?:-?(?:rơ|e-?rơ)|a-?rơ)))?|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра))|list[\s\xa0]*Petr[uů]v))|kalawang[\s\xa0]*Pedro)|Epistula[\s\xa0]*(?:Petri[\s\xa0]*II|II[\s\xa0]*Petri)|Waraka[\s\xa0]*wa[\s\xa0]*Pili[\s\xa0]*wa[\s\xa0]*Petro|பேதுரு[\s\xa0]*(?:எழுதிய[\s\xa0]*இரண்டா(?:வது[\s\xa0]*நிருபம்|ம்[\s\xa0]*(?:திருமுகம்|கடிதம்))|இரண்டாம்[\s\xa0]*திருமுகம்)|P(?:et(?:ers[\s\xa0]*(?:andre[\s\xa0]*brev|Andet[\s\xa0]*Brev)|uru[\s\xa0]*E[lḻ]utiya[\s\xa0]*Ira(?:[nṇ](?:[tṭ](?:[aā]vatu[\s\xa0]*Nirupam)))|r(?:us[\s\xa0]*andra[\s\xa0]*brev|o[\s\xa0]*II))|ili[\s\xa0]*Pet(?:ro)?|ēturu[\s\xa0]*E[lḻ]utiya[\s\xa0]*Ira(?:[nṇ](?:[tṭ](?:[aā]vatu[\s\xa0]*Nirupam))))|(?:[ヘペ](?:トロ(?:[\s\xa0]*2|の(?:第二の手紙|手紙二))|テロの(?:第二の手紙|後の書)))|베드로(?:[2후]서|의[\s\xa0]*둘째[\s\xa0]*서간)|S(?:e(?:cond(?:o[\s\xa0]*Pietro|[\s\xa0]*P(?:tr?|e(?:t(?:er?|r)?|r)?)?|a[\s\xa0]*(?:lettera[\s\xa0]*di[\s\xa0]*Pietro|Pietro))|gund(?:a[\s\xa0]*Pedro|o[\s\xa0]*(?:San[\s\xa0]*Pedro|Pedro)))|[ií]ðara[\s\xa0]*(?:almenna[\s\xa0]*br(?:[eé]f[\s\xa0]*P(?:[eé]turs)|P[eé]tursbr(?:[eé]f))))|Naa77antto[\s\xa0]*PHeexiroosa|Π[έε]τρου[\s\xa0]*Β['ʹʹ΄’]|رسالة[\s\xa0]*(?:القديس[\s\xa0]*بطرس[\s\xa0]*الثانية|بطرس[\s\xa0]*(?:الثانية|2))|And(?:r(?:a[\s\xa0]*Petrusbrevet|e[\s\xa0]*Pet(?:er(?:s(?:brev)?)?)?)|e(?:n[\s\xa0]*Pet(?:er(?:sbrev)?)?|t[\s\xa0]*Petersbrev))|دوم(?:[\-?۔]پطرس|[\s\xa0]*پطر(?:[\s\xa0]*س|س))|۲(?:[\-?۔]پطرس|[\s\xa0]*پطر(?:[\s\xa0]*س|س))|Β(?:['ʹʹ΄’][\s\xa0]*Π(?:[έε](?:τ(?:ρ(?:ου)?)?)?))|B(?:arua[\s\xa0]*ya[\s\xa0]*Pili[\s\xa0]*ya[\s\xa0]*Petro|utros[\s\xa0]*Labaad)|2(?:e(?:\.[\s\xa0]*P(?:et(?:r(?:us)?)?|ierre)|me(?:[\s\xa0]*Pierre|\.[\s\xa0]*Pierre)|[\s\xa0]*P(?:et(?:r(?:us)?)?|ierre))|۔پطرس|d(?:e(?:[\s\xa0]*Pierre|\.[\s\xa0]*Pierre)|[\s\xa0]*Pierre|\.[\s\xa0]*Pierre)|a(?:[\s\xa0]*Pedro|\.[\s\xa0]*Pedro)|(?:[oº](?:[\s\xa0]*(?:San[\s\xa0]*Pedro|Pedro)|\.[\s\xa0]*(?:San[\s\xa0]*Pedro|Pedro)))|(?:[яе](?:\.[\s\xa0]*(?:послание[\s\xa0]*Петра|Пет(?:ра|ира))|[\s\xa0]*(?:послание[\s\xa0]*Петра|Пет(?:ра|ира))))|nd(?:[\s\xa0]*P(?:tr?|e(?:t(?:er?|r)?|r)?)?|\.[\s\xa0]*P(?:tr?|e(?:t(?:er?|r)?|r)?)?)|-?(?:ге(?:\.[\s\xa0]*(?:Петр(?:а|ово)|послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра)|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра)))|[\s\xa0]*(?:Петр(?:а|ово)|послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра)|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра))))|я(?:\.[\s\xa0]*(?:послание[\s\xa0]*Петра|Пет(?:ра|ира))|[\s\xa0]*(?:послание[\s\xa0]*Петра|Пет(?:ра|ира)))|а(?:\.[\s\xa0]*(?:Петр(?:а|ово)|послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра)|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра)))|[\s\xa0]*(?:Петр(?:а|ово)|послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра)|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра))))|е(?:[\s\xa0]*(?:Пет(?:р(?:а|ово)|ира)|послан(?:ие[\s\xa0]*Петра|ня[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра))|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра)))|\.[\s\xa0]*(?:Пет(?:р(?:а|ово)|ира)|послан(?:ие[\s\xa0]*Петра|ня[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра))|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра))))|پطرس)|ème(?:[\s\xa0]*Pierre|\.[\s\xa0]*Pierre)|بط|Pet|\.(?:[\-?۔]پطرس|(?:[oº](?:[\s\xa0]*(?:San[\s\xa0]*Pedro|Pedro)|\.[\s\xa0]*(?:San[\s\xa0]*Pedro|Pedro)))|[\s\xa0]*(?:P(?:i(?:otra?|e(?:rre|t(?:arin[\s\xa0]*kirje|ro))?|è)|jetrit|y[eè]|e(?:r|dro?|t(?:e(?:r(?:s(?:brev)?)?)?|r(?:o(?:v(?:a[\s\xa0]*Poslanica)?)?|u(?:s(?:brevet)?|v)?|ův|i)?)?)?|tr?|ét(?:rus|er)?|ataras|h(?:ê(?:rô|-?rơ)|i(?:-?(?:rơ|e-?rơ)|a-?rơ)))?|San[\s\xa0]*Pedro|But(?:ros)?|Пет(?:ира|р(?:а|ов[ао])?|[аъ]р)?|ପିତରଙ|پطر(?:[\s\xa0]*س|س)|List[\s\xa0]*(?:(?:[sś]w(?:\.[\s\xa0]*Piotra|[\s\xa0]*Piotra))|Piotra)|पत(?:रस?|्रुस(?:को)?)|เปโตร|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Петар|ослан(?:ня[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра)|и(?:е[\s\xa0]*(?:Петра|на[\s\xa0]*апостол[\s\xa0]*Петар)|ца[\s\xa0]*Петрова)))|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра))|list[\s\xa0]*Petr[uů]v))|°(?:\.[\s\xa0]*Pietro|[\s\xa0]*Pietro)|베드|[\s\xa0]*(?:p(?:atr(?:as|usko)|etr[aā]ce[mṃ])|प(?:त(?:रस?|्रुस(?:को)?)|ेत्र(?:ाचें)?)|ਪਤਰਸ|San[\s\xa0]*Pedro|(?:[ei](?:[\s\xa0]*Pjetrit|\.[\s\xa0]*Pjetrit))|But(?:ros)?|Пет(?:ира|р(?:а|ов[ао])?|[аъ]р)?|ପିତରଙ|پطر(?:[\s\xa0]*س|س)|பேது(?:ரு)?|இராயப்பர்|List[\s\xa0]*(?:(?:[sś]w(?:\.[\s\xa0]*Piotra|[\s\xa0]*Piotra))|Piotra)|ปต|เปโตร|بط|k(?:\.[\s\xa0]*Petrov|[\s\xa0]*Petrov)|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Петар|ослан(?:ня[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра)|и(?:е[\s\xa0]*(?:Петра|на[\s\xa0]*апостол[\s\xa0]*Петар)|ца[\s\xa0]*Петрова)))|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра))|list[\s\xa0]*Petr[uů]v|P(?:i(?:otra?|e(?:rre|t(?:arin[\s\xa0]*kirje|ro)?)?|è)?|j(?:e(?:trit)?)?|y[eè]|tr?|ét(?:rus|er)?|d|ataras|e(?:t(?:uru|e(?:r(?:s(?:brev)?)?)?|r(?:o(?:v(?:a[\s\xa0]*Poslanica)?)?|u(?:s(?:brevet)?|v)?|ův|i)?)?|r|d(?:ro?)?)?|ēturu|He|h(?:ê(?:rô|-?rơ)|i(?:-?(?:rơ|e-?rơ)|a-?rơ)))?))|پطرس[\s\xa0]*کا[\s\xa0]*دوسرا[\s\xa0]*عام[\s\xa0]*خط|प(?:त्रुसको[\s\xa0]*दोस्(?:त्रो[\s\xa0]*पत्र|रो[\s\xa0]*पत्र)|ेत्राचें[\s\xa0]*दुसरे[\s\xa0]*पत्र|ौलाचें[\s\xa0]*दुसरे[\s\xa0]*पत्र)|Zweite[\s\xa0]*Petrus|《(?:彼(?:[后後]》|得(?:後書》|后书》))|伯多祿後書》|撇特爾後》)|T(?:weede[\s\xa0]*Pet(?:r(?:us)?)?|oinen[\s\xa0]*Pietarin[\s\xa0]*kirje)|M(?:[aá]sodik[\s\xa0]*P(?:[eé]t(?:er)?))|Втор(?:а[\s\xa0]*(?:Пет(?:р(?:ово)?|[аъ]р)?|п(?:ослание[\s\xa0]*на[\s\xa0]*апостол[\s\xa0]*Петар|исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Петар))|о[\s\xa0]*(?:съборно[\s\xa0]*послание[\s\xa0]*на[\s\xa0]*св(?:[\s\xa0]*ап(?:\.[\s\xa0]*Петра|[\s\xa0]*Петра)|\.[\s\xa0]*ап(?:\.[\s\xa0]*Петра|[\s\xa0]*Петра))|Пет(?:рово|ар)|п(?:ослание[\s\xa0]*на[\s\xa0]*(?:апостол[\s\xa0]*Петар|Петър)|исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Петар)))|ପିତରଙ୍କ[\s\xa0]*ଦ୍ୱିତୀୟ[\s\xa0]*ପତ୍ର|Друг(?:е[\s\xa0]*(?:Петр(?:а|ово)|послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра)|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра)))|а[\s\xa0]*(?:Петр(?:а|ов[ао])|послан(?:ица[\s\xa0]*Петрова|ня[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра))|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра))))|א(?:יגרת[\s\xa0]*פטרוס[\s\xa0]*השנייה|גרתו[\s\xa0]*השנייה[\s\xa0]*של[\s\xa0]*פטרוס[\s\xa0]*השליח)|ଦ୍ୱିତୀୟ[\s\xa0]*ପିତରଙ|D(?:e(?:uxi(?:[eè]me(?:[\s\xa0]*Pierre|s[\s\xa0]*Pierre))|zy[eè]m[\s\xa0]*P(?:[iy][eè]))|ru(?:h(?:[aá][\s\xa0]*(?:P(?:etr(?:(?:[uů]v|ova?)?|t)?|kniha[\s\xa0]*Petrov|list[\s\xa0]*Petr[uů]v))|e[\s\xa0]*poslannja[\s\xa0]*apostola[\s\xa0]*Petra|(?:[yý][\s\xa0]*(?:P(?:t|etr(?:[uů]v|ov(?:[\s\xa0]*list|a))?)?|list[\s\xa0]*Petr[ouů]v)))|g(?:a[\s\xa0]*(?:List[\s\xa0]*(?:(?:[sś]w(?:\.[\s\xa0]*Piotra|[\s\xa0]*Piotra))|Piotra)|P(?:iotra?|etrova[\s\xa0]*Poslanica))|i[\s\xa0]*(?:List[\s\xa0]*(?:(?:[sś]w(?:\.[\s\xa0]*Piotra|[\s\xa0]*Piotra))|Piotra)|Piotra?))))|p(?:etr[aā]ce(?:[mṃ][\s\xa0]*dusre[\s\xa0]*patra)|a(?:tr(?:as[\s\xa0]*dī[\s\xa0]*dūjī[\s\xa0]*pattrī|usko[\s\xa0]*dostro[\s\xa0]*patra)|ṭras[\s\xa0]*kā[\s\xa0]*dūsrā[\s\xa0]*ʿām[\s\xa0]*ḫaṭ))|二[ヘペ]トロ)|(?:Druh(?:[aá][\s\xa0]*(?:Pt?|kniha[\s\xa0]*Petrov|list[\s\xa0]*Petr[uů]v))|S[ií]ðara[\s\xa0]*P(?:[eé]tursbr(?:[eé]f)))|(?:《(?:彼(?:得(?:后书|後書)|[後后])|伯多祿後書|撇特爾後)|Dru(?:ga[\s\xa0]*Petrova(?:[\s\xa0]*poslanica)?|h[ýy][\s\xa0]*Petrov)|بطرس[\s\xa0]*الثانية|撇特爾後》?|Toinen[\s\xa0]*Pietarin|2(?:[\s\xa0]*P(?:ietarin|hia|etrova)|\.[\s\xa0]*P(?:ietarin|hia|etrova))|II(?:[\s\xa0]*P(?:ietarin|etr(?:ova|i)|hia)|\.[\s\xa0]*P(?:ietarin|hia|etrova))|伯多祿後書》?|彼(?:[后後]》?|得(?:後書》?|后书》?))|Petri[\s\xa0]*II))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["1Pet"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])(1\.[\s\xa0]*patrusko|(?:P(?:ēturu[\s\xa0]*E[lḻ]utiya[\s\xa0]*Mutal(?:[aā]vatu[\s\xa0]*Nirupam)|r(?:im(?:o[\s\xa0]*Pietro|e(?:r(?:[\s\xa0]*(?:San[\s\xa0]*Pedro|Pedro)|o[\s\xa0]*(?:San[\s\xa0]*Pedro|Pedro))|ir[ao][\s\xa0]*Pedro)|a[\s\xa0]*(?:lettera[\s\xa0]*di[\s\xa0]*Pietro|Pietro))|v(?:(?:[yý][\s\xa0]*(?:list[\s\xa0]*Petrov|Petrov[\s\xa0]*list))|a[\s\xa0]*(?:kniha[\s\xa0]*Petrov|Petrov(?:a[\s\xa0]*Poslanica)?)|á[\s\xa0]*(?:Petrov|kniha[\s\xa0]*Petrov)|n[ií][\s\xa0]*(?:P(?:etr(?:(?:[uů]v|ova)?|t)?|list[\s\xa0]*Petr[uů]v)))|em(?:i(?:ère(?:[\s\xa0]*Pierre|s[\s\xa0]*Pierre)|er(?:e(?:[\s\xa0]*Pierre|s[\s\xa0]*Pierre)|[\s\xa0]*Pierre|s[\s\xa0]*Pierre))|ye[\s\xa0]*P[iy][eè]))|e(?:t(?:uru[\s\xa0]*E[lḻ]utiya[\s\xa0]*Mutal(?:[aā]vatu[\s\xa0]*Nirupam)|r(?:us[\s\xa0]*f[oö]rsta[\s\xa0]*brev|o[\s\xa0]*I)|ers[\s\xa0]*(?:1(?:[\s\xa0]*Brev|\.[\s\xa0]*Brev)|Første[\s\xa0]*Brev))|r[sš]e[\s\xa0]*poslannja[\s\xa0]*apostola[\s\xa0]*Petra)|ierwsz(?:[aey][\s\xa0]*(?:List[\s\xa0]*(?:(?:[sś]w(?:\.[\s\xa0]*Piotra|[\s\xa0]*Piotra))|Piotra)|Piotra?)))|پطر(?:س[\s\xa0]*کا[\s\xa0]*پہلا[\s\xa0]*عام[\s\xa0]*خط|[\s\xa0]*س[\s\xa0]*کاپہلا[\s\xa0]*عا[\s\xa0]*م[\s\xa0]*خط)|E(?:nsimm[aä]inen[\s\xa0]*Pietarin[\s\xa0]*kirje|pistula[\s\xa0]*(?:I[\s\xa0]*Petri|Petri[\s\xa0]*I)|rste[\s\xa0]*Petrus|erste[\s\xa0]*Pet(?:r(?:us)?)?|ls(?:[oő][\s\xa0]*P(?:[eé]t(?:er)?)))|ਪਤਰਸ[\s\xa0]*ਦੀ[\s\xa0]*ਪਹਿਲੀ[\s\xa0]*ਪੱਤ੍ਰੀ|א(?:יגרת[\s\xa0]*פטרוס[\s\xa0]*הראשונה|גרתו[\s\xa0]*הראשונה[\s\xa0]*של[\s\xa0]*פטרוס[\s\xa0]*השלי)|(?:[ヘペ](?:テロの(?:前の書|第一の手紙)|トロ(?:の(?:手紙一|第一の手紙)|[\s\xa0]*1)))|B(?:arua[\s\xa0]*ya[\s\xa0]*Kwanza[\s\xa0]*ya[\s\xa0]*Petro|utros[\s\xa0]*Kowaad)|رسالة[\s\xa0]*(?:القديس[\s\xa0]*بطرس[\s\xa0]*الأولى|بطرس[\s\xa0]*(?:الأولى|1))|Π[έε]τρου[\s\xa0]*Α['ʹʹ΄’]|П(?:ерш(?:[ае][\s\xa0]*(?:Петр(?:а|ово)|послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра)|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра))))|ърв(?:о[\s\xa0]*(?:съборно[\s\xa0]*послание[\s\xa0]*на[\s\xa0]*св(?:[\s\xa0]*ап(?:\.[\s\xa0]*Петра|[\s\xa0]*Петра)|\.[\s\xa0]*ап(?:\.[\s\xa0]*Петра|[\s\xa0]*Петра))|послание[\s\xa0]*на[\s\xa0]*Петър)|а[\s\xa0]*Пет(?:р(?:ово)?|ър)?)|рв(?:о[\s\xa0]*(?:Пет(?:рово|ар)|п(?:ослание[\s\xa0]*на[\s\xa0]*апостол[\s\xa0]*Петар|исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Петар))|а[\s\xa0]*(?:п(?:ослани(?:ца[\s\xa0]*Петрова|е[\s\xa0]*на[\s\xa0]*апостол[\s\xa0]*Петар)|исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Петар)|Пет(?:ар|ров[ао]))))|《(?:彼(?:前》|得前[书書]》)|伯多祿前書》|撇特爾前》)|பேதுரு[\s\xa0]*(?:எழுதிய[\s\xa0]*முதல(?:ா(?:ம்[\s\xa0]*கடிதம்|வது[\s\xa0]*நிருபம்)|்[\s\xa0]*திருமுகம்)|முதல்[\s\xa0]*திருமுகம்)|اوّل(?:[\-?۔]پطرس|[\s\xa0]*پطر(?:[\s\xa0]*س|س))|۱(?:[\-?۔]پطرس|[\s\xa0]*پطر(?:[\s\xa0]*س|س))|베드로(?:의[\s\xa0]*첫째[\s\xa0]*서간|[1전]서)|ପ(?:୍ରଥମ[\s\xa0]*ପିତରଙ|ିତରଙ୍କ[\s\xa0]*ପ୍ରଥମ[\s\xa0]*ପତ୍ର)|Α(?:['ʹʹ΄’][\s\xa0]*Π(?:[έε](?:τ(?:ρ(?:ου)?)?)?))|1(?:-?(?:ше(?:\.[\s\xa0]*(?:Петр(?:а|ово)|послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра)|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра)))|[\s\xa0]*(?:Петр(?:а|ово)|послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра)|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра))))|я(?:\.[\s\xa0]*(?:послание[\s\xa0]*Петра|Пет(?:ра|ира))|[\s\xa0]*(?:послание[\s\xa0]*Петра|Пет(?:ра|ира)))|а(?:\.[\s\xa0]*(?:Петр(?:а|ово)|послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра)|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра)))|[\s\xa0]*(?:Петр(?:а|ово)|послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра)|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра))))|е(?:[\s\xa0]*(?:Пет(?:р(?:а|ово)|ира)|послан(?:ие[\s\xa0]*Петра|ня[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра))|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра)))|\.[\s\xa0]*(?:Пет(?:р(?:а|ово)|ира)|послан(?:ие[\s\xa0]*Петра|ня[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра))|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра))))|پطرس)|۔پطرس|a(?:[\s\xa0]*Pedro|\.[\s\xa0]*Pedro)|(?:[oº](?:[\s\xa0]*(?:San[\s\xa0]*Pedro|Pedro)|\.[\s\xa0]*(?:San[\s\xa0]*Pedro|Pedro)))|(?:[яе](?:\.[\s\xa0]*(?:послание[\s\xa0]*Петра|Пет(?:ра|ира))|[\s\xa0]*(?:послание[\s\xa0]*Петра|Пет(?:ра|ира))))|بط|Pet|re(?:[\s\xa0]*Pierre|\.[\s\xa0]*Pierre)|\.(?:[\-?۔]پطرس|(?:[oº](?:[\s\xa0]*(?:San[\s\xa0]*Pedro|Pedro)|\.[\s\xa0]*(?:San[\s\xa0]*Pedro|Pedro)))|[\s\xa0]*(?:P(?:i(?:otra?|e(?:rre|t(?:arin[\s\xa0]*kirje|ro))?|è)|jetrit|y[eè]|e(?:r|dro?|t(?:e(?:r(?:s(?:brev)?)?)?|r(?:o(?:v(?:a[\s\xa0]*Poslanica)?)?|u(?:s(?:brevet)?|v)?|ův|i)?)?)?|tr?|ét(?:rus|er)?|ataras|h(?:ê(?:rô|-?rơ)|i(?:-?(?:rơ|e-?rơ)|a-?rơ)))?|San[\s\xa0]*Pedro|But(?:ros)?|Пет(?:ира|р(?:а|ов[ао])?|[аъ]р)?|ପିତରଙ|پطر(?:[\s\xa0]*س|س)|List[\s\xa0]*(?:(?:[sś]w(?:\.[\s\xa0]*Piotra|[\s\xa0]*Piotra))|Piotra)|पत(?:रस?|्रुस(?:को)?)|เปโตร|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Петар|ослан(?:ня[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра)|и(?:е[\s\xa0]*(?:Петра|на[\s\xa0]*апостол[\s\xa0]*Петар)|ца[\s\xa0]*Петрова)))|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра))|list[\s\xa0]*Petr[uů]v))|°(?:\.[\s\xa0]*Pietro|[\s\xa0]*Pietro)|ère(?:[\s\xa0]*Pierre|\.[\s\xa0]*Pierre)|베드|[\s\xa0]*(?:p(?:atr(?:as|usko)|etr[aā]ce[mṃ])|प(?:त(?:रस?|्रुस(?:को)?)|ेत्र(?:ाचें)?)|ਪਤਰਸ|San[\s\xa0]*Pedro|(?:[ei](?:[\s\xa0]*Pjetrit|\.[\s\xa0]*Pjetrit))|But(?:ros)?|Пет(?:ира|р(?:а|ов[ао])?|[аъ]р)?|ପିତରଙ|پطر(?:[\s\xa0]*س|س)|பேது(?:ரு)?|இராயப்பர்|List[\s\xa0]*(?:(?:[sś]w(?:\.[\s\xa0]*Piotra|[\s\xa0]*Piotra))|Piotra)|ปต|เปโตร|بط|k(?:\.[\s\xa0]*Petrov|[\s\xa0]*Petrov)|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Петар|ослан(?:ня[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра)|и(?:е[\s\xa0]*(?:Петра|на[\s\xa0]*апостол[\s\xa0]*Петар)|ца[\s\xa0]*Петрова)))|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра))|list[\s\xa0]*Petr[uů]v|P(?:i(?:otra?|e(?:rre|t(?:arin[\s\xa0]*kirje|ro)?)?|è)?|j(?:e(?:trit)?)?|y[eè]|tr?|ét(?:rus|er)?|d|ataras|e(?:t(?:uru|e(?:r(?:s(?:brev)?)?)?|r(?:o(?:v(?:a[\s\xa0]*Poslanica)?)?|u(?:s(?:brevet)?|v)?|ův|i)?)?|r|d(?:ro?)?)?|ēturu|He|h(?:ê(?:rô|-?rơ)|i(?:-?(?:rơ|e-?rơ)|a-?rơ)))?)|st(?:[\s\xa0]*P(?:tr?|e(?:t(?:er?|r)?|r)?)?|\.[\s\xa0]*P(?:tr?|e(?:t(?:er?|r)?|r)?)?)|e(?:[\s\xa0]*Pet(?:r(?:us)?)?|r(?:e(?:[\s\xa0]*Pierre|\.[\s\xa0]*Pierre)|[\s\xa0]*Pierre|\.[\s\xa0]*Pierre)|\.[\s\xa0]*Pet(?:r(?:us)?)?))|Una(?:[\s\xa0]*Pedro|ng[\s\xa0]*Pedro)|K(?:wanza[\s\xa0]*Pet(?:ro)?|oiro[\s\xa0]*PHeexiroosa)|I(?:\.[\s\xa0]*(?:Пет(?:р(?:а|ов[ао])?|[аъ]р)?|San[\s\xa0]*Pedro|But(?:ros)?|п(?:ослан(?:и(?:ца[\s\xa0]*Петрова|е[\s\xa0]*на[\s\xa0]*апостол[\s\xa0]*Петар)|ня[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра))|исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Петар)|List[\s\xa0]*(?:(?:[sś]w(?:\.[\s\xa0]*Piotra|[\s\xa0]*Piotra))|Piotra)|P(?:i(?:otra?|e(?:rre|t(?:arin[\s\xa0]*kirje|ro))?|è)|y[eè]|e(?:r|t(?:r(?:u[sv]?|o(?:v(?:a[\s\xa0]*Poslanica)?)?|ův|i)?|er?)?|dro?)?|tr?|ét(?:rus|er)?|h(?:ê(?:rô|-?rơ)|i(?:-?(?:rơ|e-?rơ)|a-?rơ)))?|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра))|list[\s\xa0]*Petr[uů]v)|[\s\xa0]*(?:Пет(?:р(?:а|ов[ао])?|[аъ]р)?|San[\s\xa0]*Pedro|But(?:ros)?|п(?:ослан(?:и(?:ца[\s\xa0]*Петрова|е[\s\xa0]*на[\s\xa0]*апостол[\s\xa0]*Петар)|ня[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра))|исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Петар)|List[\s\xa0]*(?:(?:[sś]w(?:\.[\s\xa0]*Piotra|[\s\xa0]*Piotra))|Piotra)|P(?:i(?:otra?|e(?:rre|t(?:arin[\s\xa0]*kirje|ro))?|è)|y[eè]|tr?|e(?:t(?:er?|r(?:u[sv]?|o(?:v(?:a[\s\xa0]*Poslanica)?)?|ův)?)?|r|dro?)?|ét(?:rus|er)?|h(?:ê(?:rô|-?rơ)|i(?:-?(?:rơ|e-?rơ)|a-?rơ)))?|соборне[\s\xa0]*послання[\s\xa0]*(?:Петра|апостола[\s\xa0]*Петра|св(?:[\s\xa0]*апостола[\s\xa0]*Петра|\.[\s\xa0]*апостола[\s\xa0]*Петра))|list[\s\xa0]*Petr[uů]v))|F(?:irst[\s\xa0]*P(?:tr?|e(?:t(?:er?|r)?|r)?)?|ørste[\s\xa0]*Pet(?:er(?:s(?:brev)?)?)?|[oö]rsta[\s\xa0]*Petrusbrevet|yrra[\s\xa0]*(?:almenna[\s\xa0]*br[eé]f[\s\xa0]*P(?:[eé]turs)|P[eé]tursbr(?:[eé]f)))|Waraka[\s\xa0]*wa[\s\xa0]*Kwanza[\s\xa0]*wa[\s\xa0]*Petro|p(?:etr[aā]ce(?:[mṃ][\s\xa0]*pahile[\s\xa0]*patra)|a(?:ṭras[\s\xa0]*kā[\s\xa0]*pahlā[\s\xa0]*ʿām[\s\xa0]*ḫaṭ|tr(?:as[\s\xa0]*dī[\s\xa0]*pahilī[\s\xa0]*pattrī|usko[\s\xa0]*pahilo[\s\xa0]*patra)))|प(?:त्रुसको[\s\xa0]*पहिलो[\s\xa0]*पत्र|ेत्राचे(?:[\s\xa0]*पहिले[\s\xa0]*पत्र|ं[\s\xa0]*पहिले[\s\xa0]*पत्र))|一[ヘペ]トロ)|Prvn(?:[ií][\s\xa0]*(?:Pt?|list[\s\xa0]*Petr[uů]v))|(?:P(?:et(?:er(?:s[\s\xa0]*første[\s\xa0]*brev)?|ri[\s\xa0]*I)|rv(?:a[\s\xa0]*Petrova(?:[\s\xa0]*poslanica)?|[yý][\s\xa0]*Petrov))|1(?:[\s\xa0]*P(?:ietarin|hia|etrova)|\.[\s\xa0]*P(?:ietarin|hia|etrova))|彼(?:前》?|得前[書书]》?)|بطرس[\s\xa0]*الأولى|伯多祿前書》?|I(?:[\s\xa0]*P(?:ietarin|etr(?:ova|i)|hia)|\.[\s\xa0]*P(?:ietarin|hia|etrova))|Ensimm[aä]inen[\s\xa0]*Pietarin|《(?:撇特爾前|伯多祿前書|彼(?:得前[书書]|前))|撇特爾前》?))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["Rom"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:रोम(?:ियों?|कंरास|ी(?:हरूलाई[\\s\\xa0]*प(?:ावलको[\\s\\xa0]*पत्र|त्र))?)|โรม|Epistula[\\s\\xa0]*ad[\\s\\xa0]*Romanos|Προς[\\s\\xa0]*Ρωμα[ίι]ους|א(?:גרת[\\s\\xa0]*פולוס[\\s\\xa0]*השליח[\\s\\xa0]*אל-?הרומיים|ל[\\s\\xa0]*הרומים)|r(?:ōmiyōṅ[\\s\\xa0]*ke[\\s\\xa0]*nām[\\s\\xa0]*kā[\\s\\xa0]*ḫaṭ|om(?:ihar[uū]l(?:[aā](?:[iī][\\s\\xa0]*patra))|ī(?:har[uū]l(?:[aā](?:[iī][\\s\\xa0]*patra))|āṃ[\\s\\xa0]*nū̃[\\s\\xa0]*pattrī)|kar[aā](?:[mṃ]s[\\s\\xa0]*patra)))|Sulat[\\s\\xa0]*sa[\\s\\xa0]*mga[\\s\\xa0]*Romano|Рим(?:јани(?:те)?|л)|L(?:a(?:yang[\\s\\xa0]*Paulus[\\s\\xa0]*Roma|-?mã)|ist[\\s\\xa0]*(?:R(?:iman[ouů]m|íman[uů]m)|do[\\s\\xa0]*Rzymian|(?:[sś]w(?:\\.[\\s\\xa0]*Pawła[\\s\\xa0]*do[\\s\\xa0]*Rzymian|[\\s\\xa0]*Pawła[\\s\\xa0]*do[\\s\\xa0]*Rzymian))|Ř[ií]man(?:[uů]m))|ettera[\\s\\xa0]*ai[\\s\\xa0]*Romani)|ロ(?:マ人への書|ーマ(?:の信徒への手紙|人への手紙|書)?)|الرسالة[\\s\\xa0]*إلى[\\s\\xa0]*أهل[\\s\\xa0]*رومية|로마(?:[\\s\\xa0]*신자들에게[\\s\\xa0]*보낸[\\s\\xa0]*서간|서)|Ur[oō]marukku[\\s\\xa0]*E(?:[lḻ]utiya[\\s\\xa0]*Nirupam)|Ř(?:[ií]m)?|Ρωμ|R(?:[òu]m|ô(?:-?ma|ma)|o(?:om(?:a(?:laiskirje)?|e)?|amns|emer|m(?:a(?:n(?:ds|s)?|sn|k[eë]ve|rbrevet|i(?:ns|akhoz))|verjabr[eé]fið|iyon|s|e(?:inen(?:brief)?|r(?:brevet)?|n))?|s)?|óm(?:a(?:iakhoz)?|verjabr[eé]fið)?|pmans|huf(?:einiaid)?|öm(?:er)?|m(?:ns?|s)?|z(?:ym)?|(?:[ií]m(?:skym)?))?|П(?:ослан(?:ня[\\s\\xa0]*(?:апостола[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*римлян|св(?:[\\s\\xa0]*апостола[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*римлян|\\.[\\s\\xa0]*апостола[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*римлян)|до[\\s\\xa0]*римлян)|и(?:е[\\s\\xa0]*(?:на[\\s\\xa0]*св(?:[\\s\\xa0]*ап(?:\\.[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Римляни|[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Римляни)|\\.[\\s\\xa0]*ап(?:\\.[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Римляни|[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Римляни))|к(?:ъм[\\s\\xa0]*римляните|[\\s\\xa0]*Римлянам))|ца[\\s\\xa0]*Римљанима))|исмо[\\s\\xa0]*од[\\s\\xa0]*апостол[\\s\\xa0]*Павле[\\s\\xa0]*до[\\s\\xa0]*христијаните[\\s\\xa0]*во[\\s\\xa0]*Рим)|உரோ(?:ம(?:ையர(?:ுக்கு[\\s\\xa0]*எழுதிய[\\s\\xa0]*திருமுகம்|்)|ருக்கு[\\s\\xa0]*எழுதிய[\\s\\xa0]*நிருபம்))?|Waraka[\\s\\xa0]*kwa[\\s\\xa0]*War(?:umi|oma)|ﺭﻭﻣﻴﺔ|ਰੋਮੀਆਂ[\\s\\xa0]*ਨੂੰ[\\s\\xa0]*ਪੱਤ੍ਰੀ|Mga[\\s\\xa0]*Taga(?:-?(?:[\\s\\xa0]*Roma|Roma)|[\\s\\xa0]*Roma)|Kirje[\\s\\xa0]*roomalaisille|῾Ρω|ر(?:سالة[\\s\\xa0]*(?:روما|بولس[\\s\\xa0]*الرسول[\\s\\xa0]*إلى[\\s\\xa0]*أهل[\\s\\xa0]*رومية)|و(?:م(?:یوں[\\s\\xa0]*کے[\\s\\xa0]*نام[\\s\\xa0]*(?:پولس[\\s\\xa0]*رسول[\\s\\xa0]*کا[\\s\\xa0]*خط|کا[\\s\\xa0]*خط))?)?|ُومِیوں)|P(?:oslannja[\\s\\xa0]*apostola[\\s\\xa0]*Pavla[\\s\\xa0]*do[\\s\\xa0]*rymljan|a(?:ulus['’][\\s\\xa0]*Brev[\\s\\xa0]*til[\\s\\xa0]*Romerne|vlova[\\s\\xa0]*poslanica[\\s\\xa0]*Rimljanima))|ରୋମୀୟଙ୍କ[\\s\\xa0]*ପ୍ରତି[\\s\\xa0]*ପତ୍ର|ரோம(?:ர்|ாபுரியாருக்கு[\\s\\xa0]*எழுதிய[\\s\\xa0]*கடிதம்)|《(?:羅(?:馬書》|》|爾瑪書》)|罗(?:》|马书》))|รม|B(?:r[eé]f[\\s\\xa0]*P(?:[aá]ls[\\s\\xa0]*til[\\s\\xa0]*R(?:[oó]mverja))|arua[\\s\\xa0]*kwa[\\s\\xa0]*Waroma)|पौलाचे[\\s\\xa0]*रोमकरांस[\\s\\xa0]*पत्र|האיגרת[\\s\\xa0]*אל[\\s\\xa0]*הרומאים)|Paulus’[\\s\\xa0]*brev[\\s\\xa0]*til[\\s\\xa0]*romerne|Poslanica[\\s\\xa0]*Rimljanima|(?:Roomalaisille|रोमकरांस[\\s\\xa0]*पत्र)|(?:Rimljanima|ਰੋਮੀਆਂ[\\s\\xa0]*ਨੂੰ|Ur[ōo]marukku|rom[īi]har(?:[ūu]l(?:[aā][iī]))|אל[\\s\\xa0]*הרומאים|ad[\\s\\xa0]*Romanos|Taga-?[\\s\\xa0]*Roma|К[\\s\\xa0]*Римлянам|रोमीहरूलाई)|(?:Рим(?:лянам|љанима)|Taga[\\s\\xa0]*Roma|ରୋମୀୟଙ୍କ|रोमकरांस|romkar[aā](?:[ṃm]s)|Ρωμα[ίι]ους|римляните|До[\\s\\xa0]*римлян)|(?:romīāṃ|War(?:umi|oma)|Римляни?|R(?:iman[ouů]m|om(?:erne|an(?:os?|i))|zymian|íman[uů]m)|رومیوں|ਰੋਮੀਆਂ|Ř[ií]man(?:[ůu]m))|(?:羅(?:馬書》|爾瑪書》?)|罗马书》|《(?:罗马书|羅(?:爾瑪書|馬書))|Roma)|(?:로마|《[羅罗]|罗(?:马书|》)|羅(?:馬書|》)|Рим)|[罗羅])(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Song"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(P(?:i(?:se[nň][\\s\\xa0]*(?:[SŠ]alamounova)|es[nń][\\s\\xa0]*Salomona)|íse[nň][\\s\\xa0]*(?:[SŠ]alamounova))|(?:L(?:j(?:[oó]ðalj(?:[oó]ðin)|l)|aul(?:[\\s\\xa0]*l|ujen[\\s\\xa0]*laulu|\\.[\\s\\xa0]*l))|Én(?:ekek[\\s\\xa0]*[eé]neke)?|諸歌の歌|A(?:ng[\\s\\xa0]*Awit[\\s\\xa0]*n(?:i[\\s\\xa0]*S[ao]lom(?:[oó]n)|g[\\s\\xa0]*mga[\\s\\xa0]*Awit)|[\\s\\xa0]*ng[\\s\\xa0]*A|w(?:[\\s\\xa0]*ni[\\s\\xa0]*S|it[\\s\\xa0]*sa[\\s\\xa0]*mga[\\s\\xa0]*Awit)|\\.[\\s\\xa0]*ng[\\s\\xa0]*A)|स(?:ुलेमानको[\\s\\xa0]*श्रेष्ठगीत|्रेस्ट[\\s\\xa0]*गीत)|Reshthageet|T(?:he[\\s\\xa0]*Song(?:s[\\s\\xa0]*of[\\s\\xa0]*S(?:o(?:lom[ao]ns?|ngs?)|alom[ao]ns?)|[\\s\\xa0]*of[\\s\\xa0]*S(?:o(?:lom[ao]ns?|ngs?)|alom[ao]ns?))|ình[\\s\\xa0]*ca)|K(?:orkea[\\s\\xa0]*veisu|idung[\\s\\xa0]*Agung|ant(?:i(?:k(?:o|u(?:[\\s\\xa0]*i[\\s\\xa0]*Kantik[eë]ve|lo))|d[\\s\\xa0]*de[\\s\\xa0]*Kantik))?)|《(?:雅歌》|歌》)|Црковни[\\s\\xa0]*химни|ਸਲੇਮਾਨ[\\s\\xa0]*ਦਾ[\\s\\xa0]*ਗੀਤ|s(?:ulem[aā]nko[\\s\\xa0]*(?:[sš]re(?:[sṣ](?:[tṭ]ʰag(?:[iī]t))))|alemān[\\s\\xa0]*dā[\\s\\xa0]*gīt)|சாலொமோனின்[\\s\\xa0]*உன்னதப்பாட்டு|श्रेष्ठ|C(?:ânt(?:ar(?:i|ea[\\s\\xa0]*(?:C[aâ]nt(?:[aă]rilor)|lui[\\s\\xa0]*Solomon))|ări|ico(?:[\\s\\xa0]*(?:d(?:e[\\s\\xa0]*Salom[aã]o|os[\\s\\xa0]*C[aâ]nticos)|Superlativo)|s[\\s\\xa0]*dos[\\s\\xa0]*C[aâ]nticos))?|nt|hante[\\s\\xa0]*Salomon|t|an(?:t(?:\\.[\\s\\xa0]*Cantic|[\\s\\xa0]*Cantic|ar(?:e(?:s[\\s\\xa0]*de[\\s\\xa0]*Salom[aã]o|[\\s\\xa0]*de[\\s\\xa0]*los[\\s\\xa0]*Cantares|a[\\s\\xa0]*(?:C[aâ]nt(?:[aă]rilor)|lui[\\s\\xa0]*Solomon))|i)|ări|i(?:que[\\s\\xa0]*des[\\s\\xa0]*Cantiques|c(?:o(?:[\\s\\xa0]*(?:d(?:i[\\s\\xa0]*Salomone|e(?:i[\\s\\xa0]*Cantici|[\\s\\xa0]*Salom[aã]o)|os[\\s\\xa0]*C[aâ]nticos)|Superlativo)|s[\\s\\xa0]*dos[\\s\\xa0]*C[aâ]nticos)|um[\\s\\xa0]*Canticorum)))|iad(?:[\\s\\xa0]*Solomon|au))?)|พซม|E(?:nekek[\\s\\xa0]*[eé]neke|l[\\s\\xa0]*Cantar[\\s\\xa0]*de[\\s\\xa0]*los[\\s\\xa0]*Cantares)|உன்ன(?:த[\\s\\xa0]*(?:பாட்டு|சங்கீதம்))?|Diễm[\\s\\xa0]*ca|سفر[\\s\\xa0]*نشيد[\\s\\xa0]*الأنشاد|P(?:ís(?:e[nň][\\s\\xa0]*p(?:[ií]sn[ií]))?|NP|i(?:[\\s\\xa0]*bèl[\\s\\xa0]*Chante[\\s\\xa0]*a|e(?:ś[nń][\\s\\xa0]*(?:nad[\\s\\xa0]*Pie(?:[sś]niami|Salomona))|s(?:[nń][\\s\\xa0]*nad[\\s\\xa0]*Pie(?:[sś]niami)|e(?:[nň][\\s\\xa0]*(?:piesn[ií]|[SŠ]alam(?:[uú]nova))))?)|s(?:nja[\\s\\xa0]*nad[\\s\\xa0]*pisnjamy|e[nň][\\s\\xa0]*p(?:[ií]sn[ií]))?)|Š|j(?:esma[\\s\\xa0]*nad[\\s\\xa0]*pjesmama)?)|ġazalu[\\s\\xa0]*l-?ġazalāt|g[iī]tratna|Wim(?:bo[\\s\\xa0]*(?:Bora|Ulio[\\s\\xa0]*Bora))?|Musthikaning[\\s\\xa0]*Kidung|V(?:[lľ]p|e[lľ]p(?:iese(?:[nň][\\s\\xa0]*(?:[SŠ]alam(?:[uú]nova)))?))|Ασ(?:μα[\\s\\xa0]*Ασμ[άα]των)?|Άσμα[\\s\\xa0]*Ασμ[άα]των|U[nṉ](?:[nṉ]atapp(?:[aā](?:[tṭ](?:[tṭ]u))))|ପରମଗୀତ|இ(?:னிமைமிகு[\\s\\xa0]*பாடல்|பா)|เพลง(?:โซโลมอน|ซาโลมอน)|S(?:o[Sln]?|gs?|ngs?|i(?:q|iquwaa[\\s\\xa0]*Sabaa)|al(?:amon[\\s\\xa0]*[eé]neke|omo(?:ns[\\s\\xa0]*Højsang|s[\\s\\xa0]*(?:høysang|Høisang)))|[\\s\\xa0]*of[\\s\\xa0]*S|S)|아가?|ﻧﺸﻴﺪ[\\s\\xa0]*ﺍﻷﻧﺸﺎ|H(?:ø(?:[jy]s(?:angen)?)|o(?:ga(?:[\\s\\xa0]*(?:visan|V)|v)|js|he(?:s(?:lied[\\s\\xa0]*Salomos|[\\s\\xa0]*Lied)|lied[\\s\\xa0]*Salomonis)|ogl(?:ied)?)|öga(?:v|[\\s\\xa0]*V(?:isan)?)|ld?)|שיר(?:[\\s\\xa0]*השירים|י[\\s\\xa0]*שלמה)|Книга[\\s\\xa0]*П(?:есен[\\s\\xa0]*на[\\s\\xa0]*Песните,[\\s\\xa0]*от[\\s\\xa0]*Соломона|існі[\\s\\xa0]*Пісень[\\s\\xa0]*Соломона)|غزل(?:[\\s\\xa0]*الغزلات|ُ[\\s\\xa0]*الغزلات)|نش(?:يد[\\s\\xa0]*الأناشيد)?|Gab(?:aygii[\\s\\xa0]*Sulaymaan)?|Ἆσ|Nhã[\\s\\xa0]*ca|गीतरत्न|П(?:[\\s\\xa0]*П|нп|ес(?:ма[\\s\\xa0]*(?:Соломонова|над[\\s\\xa0]*песмама)|н(?:ь[\\s\\xa0]*(?:песне[ий][\\s\\xa0]*Соломона|Суле[ий]мана)|и[\\s\\xa0]*Песне[ий]|а(?:[\\s\\xa0]*над[\\s\\xa0]*песните|та[\\s\\xa0]*на(?:[\\s\\xa0]*Соломон|д[\\s\\xa0]*песните)))?)?|існ(?:я[\\s\\xa0]*(?:над[\\s\\xa0]*піснями[\\s\\xa0]*Соломона|Пісне[ий]))?|\\.[\\s\\xa0]*П))|(?:Ve[lľ]p|Pieś[nń][\\s\\xa0]*Salomona)|(?:雅歌》?|உன்னதப்பாட்டு|歌》|H(?:o(?:ga(?:[\\s\\xa0]*v)?|he(?:slied|lied))|öga(?:[\\s\\xa0]*visan)?)|Awit[\\s\\xa0]*n(?:i[\\s\\xa0]*S[oa]lom(?:[oó]n)|g[\\s\\xa0]*mga[\\s\\xa0]*Awit)|《(?:雅歌|歌)|பாடல்|Tình|Song(?:s[\\s\\xa0]*of[\\s\\xa0]*S(?:o(?:lom[oa]ns?|ngs?)|alom[oa]ns?)|[\\s\\xa0]*of[\\s\\xa0]*S(?:o(?:lom[ao]ns?|ngs?)|alom[oa]ns?))?|श्रेष्ठगीत|C(?:hante|ant(?:i(?:que(?:[\\s\\xa0]*des[\\s\\xa0]*cantiques|s)?|c(?:o(?:[\\s\\xa0]*dei[\\s\\xa0]*cantici|s)?|um[\\s\\xa0]*canticorum))|ar(?:[\\s\\xa0]*de[\\s\\xa0]*los[\\s\\xa0]*Cantares|e(?:a[\\s\\xa0]*cantarilor|s)))?|ânticos)|П(?:ес(?:ен[\\s\\xa0]*на[\\s\\xa0]*песните|нь)|існ(?:я[\\s\\xa0]*над[\\s\\xa0]*піснями|і[\\s\\xa0]*Пісень))|Ve[ľl]piese[nň]|Gabaygii|P(?:i(?:se[nň]|ese[ňn])|np|íse[ňn])))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Prov"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Pr[ií]sloví[\\s\\xa0]*(?:[SŠ]alomounova)|Pr[ií]slovi(?:[\\s\\xa0]*(?:[SŠ]alomounova|a))|Pr(?:[ií]slovia)|(?:n[iī]tis(?:[uū]tre)|П(?:р(?:и(?:т(?:ч(?:і[\\s\\xa0]*Соломона)?)?|казки|пові(?:док|сті)|че[\\s\\xa0]*Солом[оу]нове))?|ословици)|Изрек[еи]|Книга[\\s\\xa0]*(?:притче[ий][\\s\\xa0]*Соломоновых|При(?:тчи[\\s\\xa0]*Соломонови|повісте[ий][\\s\\xa0]*Соломонових|казок[\\s\\xa0]*Соломонових))|P(?:r(?:z(?:y(?:p(?:owie[sś]ci[\\s\\xa0]*Salomonowych)?)?)?|[ií]s|everb(?:s|ios?)?|ypovisti|v(?:b(?:os?|s)?|erb(?:s|ios?)?)?|o(?:b(?:verb(?:s|ios)|erb(?:s|ios))|v(?:e(?:rb(?:e(?:le[\\s\\xa0]*lui[\\s\\xa0]*Solomon|s)?|s|i(?:os?|a)?)?|b(?:s|ios))|érbios)?)?)?|[eé]ld(?:abesz(?:[eé]dek)?)|ř[ií]s(?:lov(?:[ií][\\s\\xa0]*(?:[SŠ]alomounova))?)?|o(?:rverb(?:s|ios)|verb(?:s|ios)|slovice)|ildele[\\s\\xa0]*lui[\\s\\xa0]*Solomon|[vw])|S(?:nl|a(?:lomos[\\s\\xa0]*Ordspr(?:og|[aå]k)|nanl(?:asku(?:t|jen[\\s\\xa0]*kirja))?)|pr(?:u(?:che|eche)|ichw[oö]rter|üche|euken)?)|N(?:[iī]timo(?:[lḻ]ika[lḷ])|eetivachan)|ਕਹਾਉ(?:ਂਤਾ|ਤਾਂ)|ส(?:ุภาษิต|ภษ)|Izr|Wulang[\\s\\xa0]*Bebasan|Fjal[eë]t[\\s\\xa0]*e[\\s\\xa0]*urta|مثل|《箴(?:言》|》)|பழமொழி[\\s\\xa0]*ஆகமம்|hitopade[sš]ko[\\s\\xa0]*pustak|நீ(?:மொ|தி(?:மொழிகள்)?)|Châm[\\s\\xa0]*ngôn|M(?:it(?:h(?:ali)?)?|eth(?:ali)?|ga[\\s\\xa0]*(?:Panultihon|Kawikaan)|aah(?:maahyadii)?|udre[\\s\\xa0]*izreke)|O(?:kv|r(?:overbs|ds(?:p(?:r(?:ogene(?:s[\\s\\xa0]*Bog)?|(?:[aå]k(?:ene|sboken))))?)?|ðskviðirnir))|格(?:言の書)?|Diar(?:hebion|ebion)?|잠언?|L(?:i(?:ber[\\s\\xa0]*Proverbiorum|v[\\s\\xa0]*Pwov[eè]b[\\s\\xa0]*yo)|e(?:emiso|m))|ا(?:م(?:ثال)?|َمثال)|Мудр(?:ые[\\s\\xa0]*изречения)?|kahāutāṃ|Π(?:αροιμ(?:[ίι](?:αι|ες))|ρμ)|أمثال|משלים?|ﺃﻣﺜﺎﻝ|नीति(?:[\\s\\xa0]*वचन|[बव]चन|सूत्रें?)|ହିତୋପଦେଶ|K(?:s(?:[\\s\\xa0]*Przy(?:powie[sś]ci[\\s\\xa0]*Salomona|sł[oó]w)|\\.[\\s\\xa0]*Przy(?:powie[sś]ci[\\s\\xa0]*Salomona|sł[oó]w)|i[eę]g(?:[ai][\\s\\xa0]*Przy(?:powie(?:[sś]ci[\\s\\xa0]*Salomona|sł[oó]w))))|aw|[\\s\\xa0]*pr[ií]slov[ií]|\\.[\\s\\xa0]*pr[ií]slov[ií]|niha[\\s\\xa0]*pr[ií]slov[ií])|ams̱āl|פתגמים|سفر[\\s\\xa0]*الأمثال|हितोपदेश(?:को[\\s\\xa0]*पुस्तक)?)|(?:Ksi[eę]g(?:[ai][\\s\\xa0]*Przysł(?:[oó]w))|P(?:[eé]ld|ř))|(?:नीति|hitopade[sš]ko|箴(?:言》?|》)?|P(?:wov[èe]b|r(?:overbele|[ií]slov[ií])|anultihon|ř[íi]slov[íi])|Châm|Kawikaan|《箴言?|हितोपदेशको|При(?:тч(?:і|и(?:[\\s\\xa0]*Соломонови)?)|казок|повісте(?:[йи](?:[\\s\\xa0]*соломонових)?))|الأمثال|Sananlaskujen))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Wis"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Σοφ[ίι]α[\\s\\xa0]*Σολ(?:ομ(?:[ωώ]ντος)?)|Σοφ(?:[ίι]α[\\s\\xa0]*Σολ)|(?:Liber[\\s\\xa0]*Sapientiae|지혜서?|M(?:oudrost[\\s\\xa0]*[SŠ]alomounova|dr|[aą]dr(?:o(?:[sś](?:[cć][\\s\\xa0]*Salomona))?)|úd(?:ros(?:ti?|ť))?|ud(?:r(?:os[tť])?)?)|Ang[\\s\\xa0]*Karunungan[\\s\\xa0]*ni[\\s\\xa0]*S[ao]lom(?:[oó]n)|ஞானாகமம்|知(?:恵(?:の書)?)?|حك(?:مة[\\s\\xa0]*سليمان)?|ソロモンの(?:智慧|知恵書)|He(?:k(?:ima[\\s\\xa0]*ya[\\s\\xa0]*Solomoni)?|t[\\s\\xa0]*boek[\\s\\xa0]*der[\\s\\xa0]*wijsheid)|Σοφ[ίι]α[\\s\\xa0]*Σαλωμ(?:[ωώ]ντος)?|K(?:s(?:[\\s\\xa0]*M[aą]dro(?:[sś]ci)|i[eę]g(?:[ai][\\s\\xa0]*M(?:[aą]dro(?:[sś]ci)))|\\.[\\s\\xa0]*M[aą]dro(?:[sś]ci))|hôn[\\s\\xa0]*Ngoan|n(?:iha[\\s\\xa0]*(?:Moudrosti|moudrostí)|jiga[\\s\\xa0]*Mudrosti)|a(?:wicaksanan[\\s\\xa0]*Salomo|r))|B[oö]lcs(?:ess(?:[eé]g)?)|சா(?:லமோனின்[\\s\\xa0]*ஞானம்|ஞா)|חכמת[\\s\\xa0]*שלמה|Weish(?:eit[\\s\\xa0]*Salomos)?|S(?:a(?:b(?:edoria[\\s\\xa0]*de[\\s\\xa0]*Salom[aã]o|idur[ií]a)?|p(?:ien(?:t(?:ia[\\s\\xa0]*Salomonis)?|za[\\s\\xa0]*di[\\s\\xa0]*Salomone))?|l(?:omo(?:n[\\s\\xa0]*viisaus|s[\\s\\xa0]*(?:Visdom|vishet))|amon[\\s\\xa0]*b[oö]lcsess(?:[eé]ge))|gesse[\\s\\xa0]*de[\\s\\xa0]*Salomon)|peki[\\s\\xa0]*Sal[oó]mons|Sal|b)|《智慧篇》|[IÎ]n(?:[tț]elepciunea[\\s\\xa0]*lui[\\s\\xa0]*Solomon)|Прем(?:[\\s\\xa0]*Сол|уд(?:орсти[\\s\\xa0]*Соломонове|р(?:ости[\\s\\xa0]*Соломона|ість[\\s\\xa0]*Соломона)))|D(?:e[\\s\\xa0]*wijsheid[\\s\\xa0]*van[\\s\\xa0]*Salomo|oethineb[\\s\\xa0]*Solomon)|The[\\s\\xa0]*Wis(?:[\\s\\xa0]*of[\\s\\xa0]*Solomon|om[\\s\\xa0]*of[\\s\\xa0]*Solomon|d(?:[\\s\\xa0]*of[\\s\\xa0]*Solomon|om[\\s\\xa0]*of[\\s\\xa0]*Solomon))|ปรีชาญาณ|Cartea[\\s\\xa0]*(?:[iî]n(?:[tţ]elepciunii[\\s\\xa0]*lui[\\s\\xa0]*Solomon)|[IÎ]nțelepciunii)|سفر[\\s\\xa0]*الحكمة|Муд(?:рости[\\s\\xa0]*Соломонове)?|Книга[\\s\\xa0]*(?:Мудрост(?:[\\s\\xa0]*Соломонова|и)|на[\\s\\xa0]*мъдростта|Прем(?:ъдрост[\\s\\xa0]*Соломонова|удрості[\\s\\xa0]*Соломона))|Vi(?:is(?:auden[\\s\\xa0]*kirja)?|s(?:h(?:eten(?:s[\\s\\xa0]*bok)?)?|d(?:ommen(?:s[\\s\\xa0]*(?:Bog|bok))?)?)))|(?:B[oö]lcs|M[aą]dr|Σοφ)|(?:Мудрости|Σοφ[ιί]α|智慧篇》?|Cartea[\\s\\xa0]*[ÎI]ntelepciunii|الحكمة|M(?:udrosti|oudrost)|《智慧篇|Hekima|S(?:olom[oó]n|a(?:bedoria|pien(?:tia|za)|lom[oó]n|gesse))|Прем(?:ъдрост(?:[\\s\\xa0]*Соломонова)?)?|W(?:eisheit|i(?:jsheid(?:[\\s\\xa0]*van[\\s\\xa0]*Salomo)?|s(?:[\\s\\xa0]*of[\\s\\xa0]*Solomon|om[\\s\\xa0]*of[\\s\\xa0]*Solomon|d(?:[\\s\\xa0]*of[\\s\\xa0]*Solomon|om(?:[\\s\\xa0]*of[\\s\\xa0]*Solomon)?)?)?))|K(?:niha[\\s\\xa0]*moudrosti|a(?:wicaksanan|runungan(?:[\\s\\xa0]*ni[\\s\\xa0]*S[oa]lom(?:[oó]n))?))))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Joel"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])((?:《(?:珥》|岳厄爾》|約珥書》|约[珥饵]书》)|سفر[\s\xa0]*يوئيل|யோவே(?:ல்)?|يوء|Книга[\s\xa0]*(?:[ИЙ]оіла|пророка[\s\xa0]*(?:Йоіла|Ио(?:іла|иля))|на[\s\xa0]*пророк[\s\xa0]*Иоиля?)|J(?:ó[eé]l|l|o(?:[iéï]l|ël?|e(?:l(?:i(?:n[\s\xa0]*kirja)?|s[\s\xa0]*(?:Bog|bok))?)?))|[ਯਜ]ੋਏਲ|Y(?:ōv[eē]l|o(?:e(?:li?)?|v[eē]l|o(?:['’]eel|l)|ael|le)|u(?:u77eela|7e))|Pro(?:roctwo[\s\xa0]*Ioelowe|phetia[\s\xa0]*Ioel)|Јо(?:и[лљ]|ел)|Ks(?:[\s\xa0]*Joela|\.[\s\xa0]*Joela|i[eę]g(?:[ai][\s\xa0]*Joela))|Liv[\s\xa0]*Jow[eè]l[\s\xa0]*la|योएल(?:को[\s\xa0]*पुस्तक)?|ی(?:ُوایل|وایل)|ยอล|よえるしょ|yōʾīl|โยเอล|Ioil|Йо(?:[ії][лн]|ил)|ଯୋୟେଲ[\s\xa0]*ଭବିଷ୍ୟ‌ଦ୍‌ବକ୍ତାଙ୍କ[\s\xa0]*ପୁସ୍ତକ|ヨエル書?|Ἰλ|욜|Gi(?:oe(?:le)?|ô-?ên)|יואל|요엘서?|Ио(?:иль|[ії][лн])|Ι(?:λ|ω[ήη]λ))|(?:珥》?|يوئيل|岳厄爾》?|《(?:约[珥饵]书|約珥書|岳厄爾|珥)|[yI]oel|Йоіла|約珥書》?|Ио(?:иля?|іла)|Jo(?:w[èe]l|el(?:in|a))|约[饵珥]书》?|ଯୋୟେଲ))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["Jonah"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Pro(?:roctwo[\\s\\xa0]*Ionaszowe|phetia[\\s\\xa0]*Ionae)|ଯୂନସ[\\s\\xa0]*ଭବିଷ୍ୟ‌ଦ୍‌ବକ୍ତାଙ୍କ[\\s\\xa0]*ପୁସ୍ତକ|ਯੂਨਾਹ|Книга[\\s\\xa0]*(?:на[\\s\\xa0]*пророк[\\s\\xa0]*Иона|пророка[\\s\\xa0]*(?:Ион[иы]|Йони))|Y(?:unus|o(?:on(?:is|aasa)?|n[aā]?|ṉ[aā])|ō[nṉ][aā])|Ι(?:ν|ων[άα]ς)|יונה|J(?:ón(?:[aá]s)?|o(?:ona(?:n[\\s\\xa0]*kirja)?|n(?:a(?:[hš]|[\\s\\xa0]*bok|s(?:['’][\\s\\xa0]*Bog|[\\s\\xa0]*bok))|á[hsš]?)?)|n[hs])|ยนา|Ион|يون|《(?:拿》|約(?:納》|拿書》)|约拿书》)|Liv[\\s\\xa0]*Jonas[\\s\\xa0]*la|سفر[\\s\\xa0]*يونان|யோனா|Ionas?|โยนาห์|Ks(?:[\\s\\xa0]*Jonasza|\\.[\\s\\xa0]*Jonasza|i[eę]g(?:[ai][\\s\\xa0]*Jonasza))|yūn(?:āh|as)|Йона?|Јона|ی(?:ُوناہ|ونس)|Ἰν|욘|Gi(?:o(?:na)?|ô-?na)|요나서?|Юнус|ヨナ(?:しょ|書)?|योना(?:को[\\s\\xa0]*पुस्तक)?)|(?:《(?:約(?:拿書|納)|拿|约拿书)|拿》?|يونان|Ион[аыи]|ଯୂନସ|約(?:納》?|拿書》?)|约拿书》?|Jo(?:onan|na(?:s(?:za)?)?)|yon[aā]|Йони))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Nah"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:n(?:āḥūm|ahūm)|Liv[\\s\\xa0]*Nawoum[\\s\\xa0]*lan|《(?:[鴻鸿]》|那(?:鴻[书書]》|鸿书》)|納鴻》)|ନାହୂମ[\\s\\xa0]*ଭବିଷ୍ୟ‌ଦ୍‌ବକ୍ତାଙ୍କ[\\s\\xa0]*ପୁସ୍ତକ|नहूम(?:को[\\s\\xa0]*पुस्तक)?|น(?:าฮูม|ฮม)|Книга[\\s\\xa0]*(?:пророка[\\s\\xa0]*Наума|на[\\s\\xa0]*пророк[\\s\\xa0]*Наума?)|ن(?:ا(?:[\\s\\xa0]*حُوم|حُوم)|حوم?)|நாகூ(?:ம்)?|N(?:āk[uū]m|a(?:ch|x(?:uum)?|um|h(?:u(?:m(?:i(?:n[\\s\\xa0]*kirja)?|s[\\s\\xa0]*(?:Bog|bok)|u))?|úm?|o(?:om)?)?|ahooma|-?h[uâ]m|k[uū]m|w(?:oun)?)|áh(?:um)?|h)|ਨਹੂਮ|נחום|Να(?:ο[υύ]μ)?|나(?:훔서?)?|Pro(?:phetia[\\s\\xa0]*Nahum|roctwo[\\s\\xa0]*Nahumowe)|سفر[\\s\\xa0]*ناحوم|ナホム(?:しょ|書)?|Ks(?:i[eę]g(?:[ai][\\s\\xa0]*Nahuma)|\\.[\\s\\xa0]*Nahuma|[\\s\\xa0]*Nahuma))|Nahum(?:in|a)|(?:ନାହୂମ|[鴻鸿]》|那(?:鴻[书書]》|鸿书》)|Na(?:hum|woum)?|Наума?|نا(?:حوم)?|納鴻》|《(?:納鴻|[鸿鴻]|那(?:鸿书|鴻[书書])))|(?:nahum|納鴻|[鸿鴻]|那(?:鸿书|鴻[书書])))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["1John"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])(1[\s\xa0]*yoh[aā]n(?:[aā]ce[mṃ])|(?:اوّل(?:۔یوحنا|[\s\xa0]*ی(?:ُوحنّا|وحنّا)|-?یُوحنّا)|一ヨハネ|K(?:wanza[\s\xa0]*Yoh(?:an[ae])?|oiro[\s\xa0]*Yohaannisa)|F(?:irst[\s\xa0]*J(?:phn|o(?:phn|nh|on|h[mn]?)?|n|h(?:[ho]n|n)?)|ørste[\s\xa0]*Joh(?:annes(?:brev)?)?|[oö]rsta[\s\xa0]*Johannesbrevet|yrsta[\s\xa0]*(?:J[oó]hannesarbr(?:[eé]f)|br[eé]f[\s\xa0]*J(?:[oó]hannesar[\s\xa0]*hið[\s\xa0]*almenna)))|யோவ(?:ான்[\s\xa0]*(?:எழுதிய[\s\xa0]*முதல(?:ாம்[\s\xa0]*கடிதம்|்[\s\xa0]*திருமுகம்)|முதல்[\s\xa0]*திருமுகம்)|ன்[\s\xa0]*எழுதிய[\s\xa0]*முதலாவது[\s\xa0]*நிருபம்)|ਯੂਹੰਨਾ[\s\xa0]*ਦੀ[\s\xa0]*ਪਹਿਲੀ[\s\xa0]*ਪੱਤ੍ਰੀ|Y(?:ōva[nṉ][\s\xa0]*E(?:[lḻ]utiya[\s\xa0]*Mutal(?:[aā]vatu[\s\xa0]*Nirupam))|o(?:oxanaa[\s\xa0]*Kowaad|hane[\s\xa0]*I|va[nṉ][\s\xa0]*E(?:[lḻ]utiya[\s\xa0]*Mutal(?:[aā]vatu[\s\xa0]*Nirupam))))|Barua[\s\xa0]*ya[\s\xa0]*Kwanza[\s\xa0]*ya[\s\xa0]*Yohane|요한(?:의[\s\xa0]*첫째[\s\xa0]*서간|[1일]서)|א(?:יגרת[\s\xa0]*יוחנן[\s\xa0]*הראשונה|גרתו[\s\xa0]*הראשונה[\s\xa0]*של[\s\xa0]*יוחנן[\s\xa0]*השלי)|ヨハネ(?:の(?:手紙一|第一の(?:手紙|書))|[\s\xa0]*1)|《(?:伊望第一》|约(?:壹》|翰[一壹]书》)|約(?:翰[一壹]書》|壹》)|若望一書》)|य(?:ोहानाचें[\s\xa0]*पहिले[\s\xa0]*पत्र|ूहन्नाको[\s\xa0]*पहिलो[\s\xa0]*पत्र)|P(?:er[sš]e[\s\xa0]*poslannja[\s\xa0]*apostola[\s\xa0]*Ivana|ierwsz(?:[aey][\s\xa0]*(?:List[\s\xa0]*(?:Jana|(?:[sś]w(?:\.[\s\xa0]*Jana|[\s\xa0]*Jana)))|Jana))|r(?:v(?:a[\s\xa0]*(?:J[aá]nov|kniha[\s\xa0]*J[aá]nov|Ivanova[\s\xa0]*Poslanica)|n[ií][\s\xa0]*(?:J(?:an(?:(?:[uů]v|ova)?)?|list[\s\xa0]*Jan[uů]v))|[yý][\s\xa0]*(?:J(?:[aá]nov[\s\xa0]*list|list[\s\xa0]*J[aá]nov))|á[\s\xa0]*(?:J[aá]nov|kniha[\s\xa0]*J[aá]nov))|em(?:i(?:er(?:s[\s\xa0]*Jean|[\s\xa0]*Jean|e(?:s[\s\xa0]*Jean|[\s\xa0]*Jean))|ère(?:s[\s\xa0]*Jean|[\s\xa0]*Jean))|ye[\s\xa0]*Jan)|im(?:o[\s\xa0]*Giovanni|a[\s\xa0]*(?:lettera[\s\xa0]*di[\s\xa0]*Giovanni|Giovanni)|e(?:ir[ao][\s\xa0]*Jo(?:[aã]o)|r(?:[\s\xa0]*(?:San[\s\xa0]*J[au](?:[au]n)|J[au](?:[au]n))|o[\s\xa0]*(?:San[\s\xa0]*J[au](?:[au]n)|J[au](?:[au]n)))))))|П(?:ърв(?:о[\s\xa0]*(?:послание[\s\xa0]*на[\s\xa0]*[ИЙ]оан|съборно[\s\xa0]*послание[\s\xa0]*на[\s\xa0]*св(?:[\s\xa0]*ап(?:[\s\xa0]*Иоана[\s\xa0]*Богослова|\.[\s\xa0]*Иоана[\s\xa0]*Богослова)|\.[\s\xa0]*ап(?:[\s\xa0]*Иоана[\s\xa0]*Богослова|\.[\s\xa0]*Иоана[\s\xa0]*Богослова)))|а[\s\xa0]*(?:[ИЙ]оан(?:ово)?))|ерш(?:[ае][\s\xa0]*(?:послання[\s\xa0]*апостола[\s\xa0]*Івана|І(?:вана|оанна)|Послання[\s\xa0]*Івана|[ИЙ]оаново|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)))|рв(?:о[\s\xa0]*(?:Јован(?:ово)?|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Јован|ослание[\s\xa0]*на[\s\xa0]*апостол[\s\xa0]*Јован))|а[\s\xa0]*(?:п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Јован|ослани(?:е[\s\xa0]*на[\s\xa0]*апостол[\s\xa0]*Јован|ца[\s\xa0]*Јованова))|Јован(?:ов[ао])?)))|Waraka[\s\xa0]*wa[\s\xa0]*Kwanza[\s\xa0]*wa[\s\xa0]*Yohane|I(?:[\s\xa0]*(?:Gi(?:ăng|o(?:an|vanni))?|List[\s\xa0]*(?:Jana|(?:[sś]w(?:\.[\s\xa0]*Jana|[\s\xa0]*Jana)))|J(?:phn|óh|áno[sv]|u[au]n|o(?:phn|nh|h(?:anne(?:ksen[\s\xa0]*kirje|s)|[mn])?|on|[aã]o)?|n|ean|a(?:[au]n|n(?:o(?:s|va?)|[uů]v|a)?)|h(?:[ho]n|n)?)?|І(?:вана|оанна)|San[\s\xa0]*J[au](?:[au]n)|Послання[\s\xa0]*Івана|Јован(?:ов[ао])?|(?:[ИЙ]оан(?:ово)?)|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)|list[\s\xa0]*Jan[uů]v|Yo(?:ox(?:anaa)?|h(?:an(?:es?|a))?|kanan)|I(?:vanova[\s\xa0]*Poslanica|n|oan)|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Јован|ослан(?:ня[\s\xa0]*апостола[\s\xa0]*Івана|и(?:е[\s\xa0]*на[\s\xa0]*апостол[\s\xa0]*Јован|ца[\s\xa0]*Јованова))))|\.[\s\xa0]*(?:Gi(?:ăng|o(?:an|vanni))?|List[\s\xa0]*(?:Jana|(?:[sś]w(?:\.[\s\xa0]*Jana|[\s\xa0]*Jana)))|J(?:phn|óh|áno[sv]|u[au]n|o(?:phn|nh|h(?:anne(?:ksen[\s\xa0]*kirje|s)|[mn])?|on|[aã]o)?|n|ean|a(?:[au]n|n(?:o(?:s|va?)|[uů]v|a)?)|h(?:[ho]n|n)?)?|І(?:вана|оанна)|San[\s\xa0]*J[au](?:[au]n)|Послання[\s\xa0]*Івана|Јован(?:ов[ао])?|(?:[ИЙ]оан(?:ово)?)|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)|I(?:oan(?:nis)?|vanova[\s\xa0]*Poslanica|n)|list[\s\xa0]*Jan[uů]v|Yo(?:ox(?:anaa)?|h(?:an(?:es?|a))?|kanan)|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Јован|ослан(?:ня[\s\xa0]*апостола[\s\xa0]*Івана|и(?:е[\s\xa0]*на[\s\xa0]*апостол[\s\xa0]*Јован|ца[\s\xa0]*Јованова)))))|Una(?:ng[\s\xa0]*Juan|[\s\xa0]*Juan)|1(?:ère(?:\.[\s\xa0]*Jean|[\s\xa0]*Jean)|[\s\xa0]*(?:யோ(?:வா(?:ன்)?)?|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Јован|ослан(?:и(?:е[\s\xa0]*(?:Иоанна|на[\s\xa0]*апостол[\s\xa0]*Јован)|ца[\s\xa0]*Јованова)|ня[\s\xa0]*апостола[\s\xa0]*Івана))|List[\s\xa0]*(?:Jana|(?:[sś]w(?:\.[\s\xa0]*Jana|[\s\xa0]*Jana)))|يو|ଯୋହନଙ|І(?:в(?:ана)?|оанна)|И(?:о(?:хана|ан(?:на|ово)?)|н)|k(?:\.[\s\xa0]*J[aá]nov|[\s\xa0]*J[aá]nov)|ی(?:ُوحنّا|وحنّا)|य(?:ूहन्ना(?:को)?|ुहत्रा|ोहान(?:ाच)?)|San[\s\xa0]*J[au](?:[au]n)|(?:[ei](?:[\s\xa0]*Gjonit|\.[\s\xa0]*Gjonit))|G(?:i(?:ăng|o(?:an|vanni))?|v|j(?:onit)?)|Ј(?:ован(?:ов[ао])?|н)|Послання[\s\xa0]*Івана|Йоан(?:ово)?|y(?:uhann[aā]ko|ūh(?:ãnā|ann[aā]ko))|J(?:phn|óh|o(?:phn|nh|on|[aã]o|h(?:anne(?:s(?:brev(?:et)?)?|ksen[\s\xa0]*kirje)|[mn])?)?|áno[sv]|u[au]n|n|ean|a(?:[au]n|n(?:o(?:s|va?)|[uů]v|a)?)|h(?:[ho]n|n)?)?|அருளப்பர்|ย(?:อห์น|น)|I(?:oan(?:nis)?|v(?:anova[\s\xa0]*Poslanica)?|n)|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)|list[\s\xa0]*Jan[uů]v|Y(?:o(?:va[nṉ]|h(?:an(?:es?|a))?|kanan|o(?:x(?:anaa)?|hanna))|ōva[nṉ])|ਯੂਹੰਨਾ)|-?(?:یُوحنّا|ше(?:\.[\s\xa0]*(?:послання[\s\xa0]*апостола[\s\xa0]*Івана|І(?:вана|оанна)|Послання[\s\xa0]*Івана|[ИЙ]оаново|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна))|[\s\xa0]*(?:послання[\s\xa0]*апостола[\s\xa0]*Івана|І(?:вана|оанна)|Послання[\s\xa0]*Івана|[ИЙ]оаново|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)))|а(?:\.[\s\xa0]*(?:послання[\s\xa0]*апостола[\s\xa0]*Івана|І(?:вана|оанна)|Послання[\s\xa0]*Івана|[ИЙ]оаново|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна))|[\s\xa0]*(?:послання[\s\xa0]*апостола[\s\xa0]*Івана|І(?:вана|оанна)|Послання[\s\xa0]*Івана|[ИЙ]оаново|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)))|е(?:[\s\xa0]*(?:І(?:вана|оанна)|Ио(?:хана|ан(?:на|ово))|Послання[\s\xa0]*Івана|послан(?:ие[\s\xa0]*Иоанна|ня[\s\xa0]*апостола[\s\xa0]*Івана)|Йоаново|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна))|\.[\s\xa0]*(?:І(?:вана|оанна)|Ио(?:хана|ан(?:на|ово))|Послання[\s\xa0]*Івана|послан(?:ие[\s\xa0]*Иоанна|ня[\s\xa0]*апостола[\s\xa0]*Івана)|Йоаново|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)))|я(?:\.[\s\xa0]*(?:Ио(?:хана|анна)|послание[\s\xa0]*Иоанна)|[\s\xa0]*(?:Ио(?:хана|анна)|послание[\s\xa0]*Иоанна)))|۔یوحنا|a(?:\.[\s\xa0]*Jo[aã]o|[\s\xa0]*Jo[aã]o)|o(?:[\s\xa0]*(?:J(?:o[aã]o|[au](?:[au]n))|San[\s\xa0]*J[au](?:[au]n))|\.[\s\xa0]*(?:J(?:o[aã]o|[au](?:[au]n))|San[\s\xa0]*J[au](?:[au]n)))|e(?:r(?:e(?:\.[\s\xa0]*Jean|[\s\xa0]*Jean)|\.[\s\xa0]*Jean|[\s\xa0]*Jean)|[\s\xa0]*Joh(?:annes)?|\.[\s\xa0]*Joh(?:annes)?)|John|re(?:\.[\s\xa0]*Jean|[\s\xa0]*Jean)|(?:[яе](?:\.[\s\xa0]*(?:Ио(?:хана|анна)|послание[\s\xa0]*Иоанна)|[\s\xa0]*(?:Ио(?:хана|анна)|послание[\s\xa0]*Иоанна)))|º(?:[\s\xa0]*(?:San[\s\xa0]*J[au](?:[au]n)|J[au](?:[au]n))|\.[\s\xa0]*(?:San[\s\xa0]*J[au](?:[au]n)|J[au](?:[au]n)))|°(?:[\s\xa0]*Giovanni|\.[\s\xa0]*Giovanni)|요한|st(?:[\s\xa0]*J(?:phn|o(?:phn|nh|on|h[mn]?)?|n|h(?:[ho]n|n)?)|\.[\s\xa0]*J(?:phn|o(?:phn|nh|on|h[mn]?)?|n|h(?:[ho]n|n)?))|\.(?:۔یوحنا|[oº](?:[\s\xa0]*(?:San[\s\xa0]*J(?:[au](?:[au]n)|J[au](?:[au]n))|\.[\s\xa0]*(?:San[\s\xa0]*J[au](?:[au]n)|J[au](?:[au]n))))|[\s\xa0]*(?:п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Јован|ослан(?:и(?:е[\s\xa0]*(?:Иоанна|на[\s\xa0]*апостол[\s\xa0]*Јован)|ца[\s\xa0]*Јованова)|ня[\s\xa0]*апостола[\s\xa0]*Івана))|List[\s\xa0]*(?:Jana|(?:[sś]w(?:\.[\s\xa0]*Jana|[\s\xa0]*Jana)))|யோவான்|ଯୋହନଙ|y[uū]hann(?:[aā]ko)|І(?:вана|оанна)|Ио(?:хана|ан(?:на|ово)?)|ی(?:ُوحنّا|وحنّا)|San[\s\xa0]*J[au](?:[au]n)|Послання[\s\xa0]*Івана|Јован(?:ов[ао])?|Йоан(?:ово)?|J(?:phn|óh|o(?:phn|nh|on|[aã]o|h(?:anne(?:s(?:brev(?:et)?)?|ksen[\s\xa0]*kirje)|[mn])?)?|áno[sv]|u[au]n|n|ean|a(?:[au]n|n(?:o(?:s|va?)|[uů]v|a)?)|h(?:[ho]n|n)?)?|य(?:ूहन्ना(?:को)?|ुहत्रा)|Yo(?:h(?:an(?:es?|a))?|kanan|o(?:x(?:anaa)?|hanna))|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)|I(?:oan(?:nis)?|vanova[\s\xa0]*Poslanica|n)|G(?:i(?:ăng|o(?:an|vanni))?|jonit)|list[\s\xa0]*Jan[uů]v|ยอห์น)|-?یُوحنّا))|Α(?:['ʹʹ΄’][\s\xa0]*(?:᾿Ιω|Ιω(?:[άα]ννη)?))|Mutal[aā]vatu[\s\xa0]*யோவான்|رسالة[\s\xa0]*(?:يوحنا[\s\xa0]*(?:الأولى|1)|القديس[\s\xa0]*يوحنا[\s\xa0]*الأولى)|Ιω[άα]ννου[\s\xa0]*Α['ʹʹ΄’]|ی(?:ُوحنّا[\s\xa0]*کا[\s\xa0]*پہلا[\s\xa0]*عام[\s\xa0]*خط|وحن(?:ا[\s\xa0]*کا[\s\xa0]*پہلا[\s\xa0]*عام[\s\xa0]*خط|ّا[\s\xa0]*کا[\s\xa0]*پہلا[\s\xa0]*عام[\s\xa0]*خط))|ପ୍ରଥମ[\s\xa0]*ଯୋହନଙ|ﻳﻮﺣﻨﺎ[\s\xa0]*ﺍﻻﻭﻝ|ଯୋହନଙ୍କ[\s\xa0]*ପ୍ରଥମ[\s\xa0]*ପତ୍ର|E(?:rste[\s\xa0]*Johannes|erste[\s\xa0]*Joh(?:annes)?|ls[oő][\s\xa0]*J(?:(?:[aá]nos|n))|pistula[\s\xa0]*I(?:oannis[\s\xa0]*I|[\s\xa0]*Ioannis)|nsimm[aä]inen[\s\xa0]*Johanneksen[\s\xa0]*kirje)|J(?:ohannes(?:[\s\xa0]*f[oö]rsta[\s\xa0]*brev|(?:['’][\s\xa0]*(?:1(?:[\s\xa0]*Brev|\.[\s\xa0]*Brev)|Første[\s\xa0]*Brev)))|[aá]nos[\s\xa0]*I)|முதலாவது[\s\xa0]*யோவான்|y(?:ū(?:ḥannā[\s\xa0]*kā[\s\xa0]*pahlā[\s\xa0]*ʿām[\s\xa0]*ḫaṭ|h(?:ãnā[\s\xa0]*dī[\s\xa0]*pahilī[\s\xa0]*pattrī|ann[aā]ko[\s\xa0]*pahilo[\s\xa0]*patra))|oh[aā]n(?:[aā]ce(?:[mṃ][\s\xa0]*pahile[\s\xa0]*patra))|uhann[aā]ko[\s\xa0]*pahilo[\s\xa0]*patra)|۱(?:۔یوحنا|[\s\xa0]*ی(?:ُوحنّا|وحنّا)|-?یُوحنّا))|(?:Prv(?:n(?:[ií][\s\xa0]*(?:J|list[\s\xa0]*Jan[uů]v))|[yý][\s\xa0]*list[\s\xa0]*J(?:[aá]nov))|1\.[oº](?:[\s\xa0]*J(?:[au](?:[au]n)|\.[\s\xa0]*(?:San[\s\xa0]*J[au](?:[au]n)|J[au](?:[au]n)))))|1\.[oº]\.[\s\xa0]*(?:San[\s\xa0]*J(?:[au](?:[au]n)|J[au](?:[au]n)))|1\.[oº]\.[\s\xa0]*J(?:[au](?:[au]n))|(?:Johannes’[\s\xa0]*første[\s\xa0]*brev|約(?:壹》?|翰[壹一]書》?)|《(?:约(?:翰[一壹]书|壹)|若望一書|伊望第一|約(?:翰[壹一]書|壹))|若望一書》?|Prv(?:[ýy][\s\xa0]*J(?:[aá]nov)|a[\s\xa0]*Ivanova(?:[\s\xa0]*poslanica)?)|约(?:壹》?|翰[壹一]书》?)|1(?:[\s\xa0]*(?:Ivanova|Johanneksen)|\.[\s\xa0]*(?:Ivanova|Johanneksen))|Fyrsta[\s\xa0]*br[eé]f[\s\xa0]*J(?:[óo]hannesar)|I(?:\.[\s\xa0]*(?:Ivanova|Johanneksen)|oannis[\s\xa0]*I|[\s\xa0]*(?:I(?:vanova|oannis)|Johanneksen))|يوحنا[\s\xa0]*الأولى|Ensimm[äa]inen[\s\xa0]*Johanneksen|伊望第一》?))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["2John"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])(2[\s\xa0]*yoh[aā]n(?:[aā]ce[mṃ])|(?:An(?:nað[\s\xa0]*(?:br[eé]f[\s\xa0]*J(?:[oó]hannesar)|J[oó]hannesarbr(?:[eé]f))|d(?:e(?:n[\s\xa0]*Joh(?:annes(?:brev)?)?|t[\s\xa0]*Johannesbrev)|r(?:a[\s\xa0]*Johannesbrevet|e[\s\xa0]*Joh(?:annes)?)))|二ヨハネ|2(?:d(?:e(?:\.[\s\xa0]*Jean|[\s\xa0]*Jean)|\.[\s\xa0]*Jean|[\s\xa0]*Jean)|\.(?:۔یوحنا|[\s\xa0]*(?:п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Јован|ослан(?:и(?:е[\s\xa0]*(?:Иоанна|на[\s\xa0]*апостол[\s\xa0]*Јован)|ца[\s\xa0]*Јованова)|ня[\s\xa0]*апостола[\s\xa0]*Івана))|List[\s\xa0]*(?:Jana|(?:[sś]w(?:\.[\s\xa0]*Jana|[\s\xa0]*Jana)))|ଯୋହନଙ|y[uū]hann(?:[aā]ko)|І(?:вана|оанна)|Ио(?:хана|ан(?:на|ово)?)|ی(?:ُوحنّا|وحنّا)|San[\s\xa0]*J[au](?:[au]n)|Послання[\s\xa0]*Івана|Јован(?:ов[ао])?|Йоан(?:ово)?|J(?:phn|óh|o(?:phn|nh|on|[aã]o|h(?:anne(?:s(?:brev(?:et)?)?|ksen[\s\xa0]*kirje)|[mn])?)?|áno[sv]|u[au]n|n|ean|a(?:[au]n|n(?:o(?:s|va?)|[uů]v|a)?)|h(?:[ho]n|n)?)?|य(?:ूहन्ना(?:को)?|ुहत्रा)|Yo(?:h(?:an(?:es?|a))?|kanan|o(?:x(?:anaa)?|hanna))|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)|I(?:oan(?:nis)?|vanova[\s\xa0]*Poslanica|n)|G(?:i(?:ăng|o(?:an|vanni))?|jonit)|list[\s\xa0]*Jan[uů]v|ยอห์น)|[oº](?:[\s\xa0]*(?:San[\s\xa0]*J(?:[au](?:[au]n)|J[au](?:[au]n))|\.[\s\xa0]*(?:San[\s\xa0]*J[au](?:[au]n)|J[au](?:[au]n))))|-?یُوحنّا)|nd(?:[\s\xa0]*J(?:phn|o(?:phn|nh|on|h[mn]?)?|n|h(?:[ho]n|n)?)|\.[\s\xa0]*J(?:phn|o(?:phn|nh|on|h[mn]?)?|n|h(?:[ho]n|n)?))|[\s\xa0]*(?:யோ(?:வா(?:ன்)?)?|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Јован|ослан(?:и(?:е[\s\xa0]*(?:Иоанна|на[\s\xa0]*апостол[\s\xa0]*Јован)|ца[\s\xa0]*Јованова)|ня[\s\xa0]*апостола[\s\xa0]*Івана))|List[\s\xa0]*(?:Jana|(?:[sś]w(?:\.[\s\xa0]*Jana|[\s\xa0]*Jana)))|يو|ଯୋହନଙ|І(?:в(?:ана)?|оанна)|И(?:о(?:хана|ан(?:на|ово)?)|н)|k(?:\.[\s\xa0]*J[aá]nov|[\s\xa0]*J[aá]nov)|ی(?:ُوحنّا|وحنّا)|य(?:ूहन्ना(?:को)?|ुहत्रा|ोहान(?:ाच)?)|San[\s\xa0]*J[au](?:[au]n)|(?:[ei](?:[\s\xa0]*Gjonit|\.[\s\xa0]*Gjonit))|G(?:i(?:ăng|o(?:an|vanni))?|v|j(?:onit)?)|Ј(?:ован(?:ов[ао])?|н)|Послання[\s\xa0]*Івана|Йоан(?:ово)?|y(?:uhann[aā]ko|ūh(?:ãnā|ann[aā]ko))|J(?:phn|óh|o(?:phn|nh|on|[aã]o|h(?:anne(?:s(?:brev(?:et)?)?|ksen[\s\xa0]*kirje)|[mn])?)?|áno[sv]|u[au]n|n|ean|a(?:[au]n|n(?:o(?:s|va?)|[uů]v|a)?)|h(?:[ho]n|n)?)?|அருளப்பர்|ย(?:อห์น|น)|I(?:oan(?:nis)?|v(?:anova[\s\xa0]*Poslanica)?|n)|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)|list[\s\xa0]*Jan[uů]v|Y(?:o(?:va[nṉ]|h(?:an(?:es?|a))?|kanan|o(?:x(?:anaa)?|hanna))|ōva[nṉ])|ਯੂਹੰਨਾ)|۔یوحنا|a(?:\.[\s\xa0]*Jo[aã]o|[\s\xa0]*Jo[aã]o)|e(?:\.[\s\xa0]*J(?:oh(?:annes)?|ean)|[\s\xa0]*J(?:oh(?:annes)?|ean)|me(?:\.[\s\xa0]*Jean|[\s\xa0]*Jean))|o(?:[\s\xa0]*(?:J(?:o[aã]o|[au](?:[au]n))|San[\s\xa0]*J[au](?:[au]n))|\.[\s\xa0]*(?:J(?:o[aã]o|[au](?:[au]n))|San[\s\xa0]*J[au](?:[au]n)))|John|(?:[яе](?:\.[\s\xa0]*(?:Ио(?:хана|анна)|послание[\s\xa0]*Иоанна)|[\s\xa0]*(?:Ио(?:хана|анна)|послание[\s\xa0]*Иоанна)))|º(?:[\s\xa0]*(?:San[\s\xa0]*J[au](?:[au]n)|J[au](?:[au]n))|\.[\s\xa0]*(?:San[\s\xa0]*J[au](?:[au]n)|J[au](?:[au]n)))|°(?:[\s\xa0]*Giovanni|\.[\s\xa0]*Giovanni)|-?(?:یُوحنّا|ге(?:\.[\s\xa0]*(?:послання[\s\xa0]*апостола[\s\xa0]*Івана|І(?:вана|оанна)|Послання[\s\xa0]*Івана|[ИЙ]оаново|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна))|[\s\xa0]*(?:послання[\s\xa0]*апостола[\s\xa0]*Івана|І(?:вана|оанна)|Послання[\s\xa0]*Івана|[ИЙ]оаново|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)))|а(?:\.[\s\xa0]*(?:послання[\s\xa0]*апостола[\s\xa0]*Івана|І(?:вана|оанна)|Послання[\s\xa0]*Івана|[ИЙ]оаново|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна))|[\s\xa0]*(?:послання[\s\xa0]*апостола[\s\xa0]*Івана|І(?:вана|оанна)|Послання[\s\xa0]*Івана|[ИЙ]оаново|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)))|е(?:[\s\xa0]*(?:І(?:вана|оанна)|Ио(?:хана|ан(?:на|ово))|Послання[\s\xa0]*Івана|послан(?:ие[\s\xa0]*Иоанна|ня[\s\xa0]*апостола[\s\xa0]*Івана)|Йоаново|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна))|\.[\s\xa0]*(?:І(?:вана|оанна)|Ио(?:хана|ан(?:на|ово))|Послання[\s\xa0]*Івана|послан(?:ие[\s\xa0]*Иоанна|ня[\s\xa0]*апостола[\s\xa0]*Івана)|Йоаново|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)))|я(?:\.[\s\xa0]*(?:Ио(?:хана|анна)|послание[\s\xa0]*Иоанна)|[\s\xa0]*(?:Ио(?:хана|анна)|послание[\s\xa0]*Иоанна)))|요한|ème(?:\.[\s\xa0]*Jean|[\s\xa0]*Jean))|ی(?:وحن(?:ا[\s\xa0]*کا[\s\xa0]*دوسرا[\s\xa0]*عام[\s\xa0]*خط|ّا[\s\xa0]*کا[\s\xa0]*دوسرا[\s\xa0]*خط)|ُوحنّا[\s\xa0]*کا[\s\xa0]*دوسرا[\s\xa0]*عام[\s\xa0]*خط)|ଯୋହନଙ୍କ[\s\xa0]*ଦ୍ୱିତୀୟ[\s\xa0]*ପତ୍ର|ヨハネ(?:の(?:第二の(?:手紙|書)|手紙二)|[\s\xa0]*2)|Pili[\s\xa0]*Yoh(?:an[ae])?|ਯੂਹੰਨਾ[\s\xa0]*ਦੀ[\s\xa0]*ਦੂਜੀ[\s\xa0]*ਪੱਤ੍ਰੀ|Barua[\s\xa0]*ya[\s\xa0]*Pili[\s\xa0]*ya[\s\xa0]*Yohane|I(?:kalawang[\s\xa0]*Juan|I(?:[\s\xa0]*(?:Gi(?:ăng|o(?:an|vanni))?|List[\s\xa0]*(?:Jana|(?:[sś]w(?:\.[\s\xa0]*Jana|[\s\xa0]*Jana)))|J(?:phn|óh|áno[sv]|u[au]n|o(?:phn|nh|h(?:anne(?:ksen[\s\xa0]*kirje|s)|[mn])?|on|[aã]o)?|n|ean|a(?:[au]n|n(?:o(?:s|va?)|[uů]v|a)?)|h(?:[ho]n|n)?)?|І(?:вана|оанна)|San[\s\xa0]*J[au](?:[au]n)|Послання[\s\xa0]*Івана|Јован(?:ов[ао])?|(?:[ИЙ]оан(?:ово)?)|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)|list[\s\xa0]*Jan[uů]v|Yo(?:ox(?:anaa)?|h(?:an(?:es?|a))?|kanan)|I(?:vanova[\s\xa0]*Poslanica|n|oan)|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Јован|ослан(?:ня[\s\xa0]*апостола[\s\xa0]*Івана|и(?:е[\s\xa0]*на[\s\xa0]*апостол[\s\xa0]*Јован|ца[\s\xa0]*Јованова))))|\.[\s\xa0]*(?:Gi(?:ăng|o(?:an|vanni))?|List[\s\xa0]*(?:Jana|(?:[sś]w(?:\.[\s\xa0]*Jana|[\s\xa0]*Jana)))|J(?:phn|óh|áno[sv]|u[au]n|o(?:phn|nh|h(?:anne(?:ksen[\s\xa0]*kirje|s)|[mn])?|on|[aã]o)?|n|ean|a(?:[au]n|n(?:o(?:s|va?)|[uů]v|a)?)|h(?:[ho]n|n)?)?|І(?:вана|оанна)|San[\s\xa0]*J[au](?:[au]n)|Послання[\s\xa0]*Івана|Јован(?:ов[ао])?|(?:[ИЙ]оан(?:ово)?)|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)|I(?:oan(?:nis)?|vanova[\s\xa0]*Poslanica|n)|list[\s\xa0]*Jan[uů]v|Yo(?:ox(?:anaa)?|h(?:an(?:es?|a))?|kanan)|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Јован|ослан(?:ня[\s\xa0]*апостола[\s\xa0]*Івана|и(?:е[\s\xa0]*на[\s\xa0]*апостол[\s\xa0]*Јован|ца[\s\xa0]*Јованова))))))|Zweite[\s\xa0]*Johannes|ଦ୍ୱିତୀୟ[\s\xa0]*ଯୋହନଙ|யோவ(?:ான்[\s\xa0]*(?:இரண்டாம்[\s\xa0]*திருமுகம்|எழுதிய[\s\xa0]*இரண்டாம்[\s\xa0]*(?:திருமுகம்|கடிதம்))|ன்[\s\xa0]*எழுதிய[\s\xa0]*இரண்டாவது[\s\xa0]*நிருபம்)|Ιω[άα]ννου[\s\xa0]*Β['ʹʹ΄’]|य(?:ोहानाचें[\s\xa0]*दुसरे[\s\xa0]*पत्र|ूहन्नाको[\s\xa0]*दोस्(?:त्रो[\s\xa0]*पत्र|रो[\s\xa0]*पत्र))|Друг(?:е[\s\xa0]*(?:послання[\s\xa0]*апостола[\s\xa0]*Івана|І(?:вана|оанна)|Послання[\s\xa0]*Івана|[ИЙ]оаново|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна))|а[\s\xa0]*(?:І(?:вана|оанна)|Јованова|Послання[\s\xa0]*Івана|[ИЙ]оаново|послан(?:ица[\s\xa0]*Јованова|ня[\s\xa0]*апостола[\s\xa0]*Івана)|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)))|Waraka[\s\xa0]*wa[\s\xa0]*Pili[\s\xa0]*wa[\s\xa0]*Yohane|Epistula[\s\xa0]*I(?:I[\s\xa0]*Ioannis|oannis[\s\xa0]*II)|T(?:oinen[\s\xa0]*Joh(?:anneksen[\s\xa0]*kirje)?|weede[\s\xa0]*Joh(?:annes)?)|y(?:ū(?:h(?:ãnā[\s\xa0]*dī[\s\xa0]*dūjī[\s\xa0]*pattrī|ann[aā]ko[\s\xa0]*dostro[\s\xa0]*patra)|ḥannā[\s\xa0]*kā[\s\xa0]*dūsrā[\s\xa0]*ʿām[\s\xa0]*ḫaṭ)|oh[aā]n(?:[aā]ce(?:[mṃ][\s\xa0]*dusre[\s\xa0]*patra))|uhann[aā]ko[\s\xa0]*dostro[\s\xa0]*patra)|Послання[\s\xa0]*до[\s\xa0]*Тита|J(?:ohannes(?:'[\s\xa0]*Andet[\s\xa0]*Brev|’[\s\xa0]*(?:andre[\s\xa0]*brev|Andet[\s\xa0]*Brev)|[\s\xa0]*andra[\s\xa0]*brev)|[aá]nos[\s\xa0]*II)|Втор(?:а[\s\xa0]*(?:(?:[ИЙ]оан(?:ово)?)|Јован(?:ово)?|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Јован|ослание[\s\xa0]*на[\s\xa0]*апостол[\s\xa0]*Јован))|о[\s\xa0]*(?:п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Јован|ослание[\s\xa0]*на[\s\xa0]*(?:апостол[\s\xa0]*Јован|[ИЙ]оан))|Јован(?:ово)?|съборно[\s\xa0]*послание[\s\xa0]*на[\s\xa0]*св(?:[\s\xa0]*ап(?:[\s\xa0]*Иоана[\s\xa0]*Богослова|\.[\s\xa0]*Иоана[\s\xa0]*Богослова)|\.[\s\xa0]*ап(?:[\s\xa0]*Иоана[\s\xa0]*Богослова|\.[\s\xa0]*Иоана[\s\xa0]*Богослова))))|《(?:伊望第二》|约(?:翰[二贰]书》|贰》)|約(?:貳》|翰[二貳]書》)|若望二書》)|Β(?:['ʹʹ΄’][\s\xa0]*(?:᾿Ιω|Ιω(?:[άα]ννη)?))|א(?:יגרת[\s\xa0]*יוחנן[\s\xa0]*השנייה|גרתו[\s\xa0]*השנייה[\s\xa0]*של[\s\xa0]*יוחנן[\s\xa0]*השליח)|M[aá]sodik[\s\xa0]*J(?:(?:[aá]nos|n))|رسالة[\s\xa0]*(?:القديس[\s\xa0]*يوحنا[\s\xa0]*الثانية|يوحنا[\s\xa0]*(?:الثانية|2))|D(?:ru(?:h(?:[aá][\s\xa0]*(?:J(?:an(?:(?:[uů]v|ova?)?|ánov)?|list[\s\xa0]*Jan[uů]v|kniha[\s\xa0]*J[aá]nov))|e[\s\xa0]*poslannja[\s\xa0]*apostola[\s\xa0]*Ivana|[yý][\s\xa0]*(?:J(?:an(?:(?:[uů]v|ov(?:[\s\xa0]*list|a))?|ánov[\s\xa0]*list)?|list[\s\xa0]*J(?:ánov|an[ouů]v))))|g(?:a[\s\xa0]*(?:List[\s\xa0]*(?:Jana|(?:[sś]w(?:\.[\s\xa0]*Jana|[\s\xa0]*Jana)))|Jana|Ivanova[\s\xa0]*Poslanica)|i[\s\xa0]*(?:List[\s\xa0]*(?:Jana|(?:[sś]w(?:\.[\s\xa0]*Jana|[\s\xa0]*Jana)))|Jana)))|e(?:zy[eè]m[\s\xa0]*Jan|uxi(?:[eè]me(?:s[\s\xa0]*Jean|[\s\xa0]*Jean))))|Y(?:o(?:oxanaa[\s\xa0]*Labaad|va[nṉ][\s\xa0]*E(?:[lḻ]utiya[\s\xa0]*Ira(?:[nṇ](?:[tṭ](?:[aā]vatu[\s\xa0]*Nirupam))))|hane[\s\xa0]*II)|ōva[nṉ][\s\xa0]*E(?:[lḻ]utiya[\s\xa0]*Ira(?:[nṇ](?:[tṭ](?:[aā]vatu[\s\xa0]*Nirupam)))))|요한(?:[2이]서|의[\s\xa0]*둘째[\s\xa0]*서간)|دوم(?:۔یوحنا|[\s\xa0]*ی(?:ُوحنّا|وحنّا)|-?یُوحنّا)|۲(?:۔یوحنا|[\s\xa0]*ی(?:ُوحنّا|وحنّا)|-?یُوحنّا)|Naa77antto[\s\xa0]*Yohaannisa|Se(?:cond(?:[\s\xa0]*J(?:phn|o(?:phn|nh|on|h[mn]?)?|n|h(?:[ho]n|n)?)|o[\s\xa0]*Giovanni|a[\s\xa0]*(?:lettera[\s\xa0]*di[\s\xa0]*Giovanni|Giovanni))|gund(?:o[\s\xa0]*(?:J(?:o[aã]o|[au](?:[au]n))|San[\s\xa0]*J[au](?:[au]n))|a[\s\xa0]*Jo[aã]o)))|(?:Druh(?:(?:[aá][\s\xa0]*(?:J(?:ánov)?|list[\s\xa0]*Jan[uů]v|kniha[\s\xa0]*J[aá]nov))|(?:[yý][\s\xa0]*(?:J(?:ánov[\s\xa0]*list)?|list[\s\xa0]*J(?:ánov|an[ouů]v))))|2\.[oº](?:[\s\xa0]*J(?:[au](?:[au]n)|\.[\s\xa0]*(?:San[\s\xa0]*J[au](?:[au]n)|J[au](?:[au]n)))))|2\.[oº]\.[\s\xa0]*(?:San[\s\xa0]*J(?:[au](?:[au]n)|J[au](?:[au]n)))|2\.[oº]\.[\s\xa0]*J(?:[au](?:[au]n))|(?:Toinen[\s\xa0]*Johanneksen|Dru(?:ga[\s\xa0]*Ivanova(?:[\s\xa0]*poslanica)?|h[yý][\s\xa0]*J(?:[aá]nov))|يوحنا[\s\xa0]*الثانية|2(?:[\s\xa0]*(?:Ivanova|Johanneksen)|\.[\s\xa0]*(?:Ivanova|Johanneksen))|約(?:翰[二貳]書》?|貳》?)|I(?:oannis[\s\xa0]*II|I(?:\.[\s\xa0]*(?:Ivanova|Johanneksen)|[\s\xa0]*(?:I(?:vanova|oannis)|Johanneksen)))|若望二書》?|伊望第二》?|约(?:贰》?|翰[贰二]书》?)|《(?:若望二書|伊望第二|約(?:翰[貳二]書|貳)|约(?:翰[二贰]书|贰))))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["3John"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])(3[\s\xa0]*yoh[aā]n(?:[aā]ce[mṃ])|(?:三ヨハネ|ヨハネ(?:の(?:第三の(?:手紙|書)|手紙三)|[\s\xa0]*3)|Тре(?:т(?:(?:[яє][\s\xa0]*(?:послання[\s\xa0]*апостола[\s\xa0]*Івана|І(?:вана|оанна)|Послання[\s\xa0]*Івана|[ИЙ]оаново|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)))|о[\s\xa0]*(?:п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Јован|ослание[\s\xa0]*на[\s\xa0]*(?:апостол[\s\xa0]*Јован|[ИЙ]оан))|(?:[ИЙ]оан(?:ово)?)|Јован(?:ово)?|съборно[\s\xa0]*послание[\s\xa0]*на[\s\xa0]*св(?:[\s\xa0]*ап(?:[\s\xa0]*Иоана[\s\xa0]*Богослова|\.[\s\xa0]*Иоана[\s\xa0]*Богослова)|\.[\s\xa0]*ап(?:[\s\xa0]*Иоана[\s\xa0]*Богослова|\.[\s\xa0]*Иоана[\s\xa0]*Богослова)))|а[\s\xa0]*(?:Јован(?:ово)?|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Јован|ослание[\s\xa0]*на[\s\xa0]*апостол[\s\xa0]*Јован)))|ћ(?:а[\s\xa0]*(?:посланица[\s\xa0]*Јованова|Јованова)|ом[\s\xa0]*(?:посланица[\s\xa0]*Јованова|Јованова)))|ਯੂਹੰਨਾ[\s\xa0]*ਦੀ[\s\xa0]*ਤੀਜੀ[\s\xa0]*ਪੱਤ੍ਰੀ|《(?:伊望第三》|约(?:三》|翰[三叁]书》)|若望三書》|約(?:三》|翰[三參]書》))|य(?:ोहानाचें[\s\xa0]*तिसरे[\s\xa0]*पत्र|ूहन्नाको[\s\xa0]*तेस्(?:त्रो[\s\xa0]*पत्र|रो[\s\xa0]*पत्र))|யோவ(?:ான்[\s\xa0]*(?:மூன்றாம்[\s\xa0]*திருமுகம்|எழுதிய[\s\xa0]*ம(?:ூன்றாம்[\s\xa0]*கடிதம்|ுன்றாம்[\s\xa0]*திருமுகம்))|ன்[\s\xa0]*எழுதிய[\s\xa0]*மூன்றாவது[\s\xa0]*நிருபம்)|ଯୋହନଙ୍କ[\s\xa0]*ତୃତୀୟ[\s\xa0]*ପତ୍ର|H(?:ezzantto[\s\xa0]*Yohaannisa|armadik[\s\xa0]*J(?:[aá]nos|n))|Barua[\s\xa0]*ya[\s\xa0]*Tatu[\s\xa0]*ya[\s\xa0]*Yohane|Y(?:ōva[nṉ][\s\xa0]*E(?:[lḻ]utiya[\s\xa0]*M(?:[uū](?:[nṉ](?:[rṛ](?:[aā]vatu[\s\xa0]*Nirupam)))))|o(?:oxanaa[\s\xa0]*Saddexaad|hane[\s\xa0]*III|va[nṉ][\s\xa0]*E(?:[lḻ]utiya[\s\xa0]*M(?:[uū](?:[nṉ](?:[rṛ](?:[aā]vatu[\s\xa0]*Nirupam)))))))|3(?:-?(?:یُوحنّا|тє(?:\.[\s\xa0]*(?:послання[\s\xa0]*апостола[\s\xa0]*Івана|І(?:вана|оанна)|Послання[\s\xa0]*Івана|[ИЙ]оаново|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна))|[\s\xa0]*(?:послання[\s\xa0]*апостола[\s\xa0]*Івана|І(?:вана|оанна)|Послання[\s\xa0]*Івана|[ИЙ]оаново|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)))|а(?:\.[\s\xa0]*(?:послання[\s\xa0]*апостола[\s\xa0]*Івана|І(?:вана|оанна)|Послання[\s\xa0]*Івана|[ИЙ]оаново|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна))|[\s\xa0]*(?:послання[\s\xa0]*апостола[\s\xa0]*Івана|І(?:вана|оанна)|Послання[\s\xa0]*Івана|[ИЙ]оаново|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)))|е(?:[\s\xa0]*(?:І(?:вана|оанна)|Ио(?:хана|ан(?:на|ово))|Послання[\s\xa0]*Івана|послан(?:ие[\s\xa0]*Иоанна|ня[\s\xa0]*апостола[\s\xa0]*Івана)|Йоаново|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна))|\.[\s\xa0]*(?:І(?:вана|оанна)|Ио(?:хана|ан(?:на|ово))|Послання[\s\xa0]*Івана|послан(?:ие[\s\xa0]*Иоанна|ня[\s\xa0]*апостола[\s\xa0]*Івана)|Йоаново|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)))|я(?:\.[\s\xa0]*(?:Ио(?:хана|анна)|послание[\s\xa0]*Иоанна)|[\s\xa0]*(?:Ио(?:хана|анна)|послание[\s\xa0]*Иоанна)))|rd(?:[\s\xa0]*J(?:phn|o(?:phn|nh|on|h[mn]?)?|n|h(?:[ho]n|n)?)|\.[\s\xa0]*J(?:phn|o(?:phn|nh|on|h[mn]?)?|n|h(?:[ho]n|n)?))|[\s\xa0]*(?:யோ(?:வா(?:ன்)?)?|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Јован|ослан(?:и(?:е[\s\xa0]*(?:Иоанна|на[\s\xa0]*апостол[\s\xa0]*Јован)|ца[\s\xa0]*Јованова)|ня[\s\xa0]*апостола[\s\xa0]*Івана))|List[\s\xa0]*(?:Jana|(?:[sś]w(?:\.[\s\xa0]*Jana|[\s\xa0]*Jana)))|يو|ଯୋହନଙ|І(?:в(?:ана)?|оанна)|И(?:о(?:хана|ан(?:на|ово)?)|н)|k(?:\.[\s\xa0]*J[aá]nov|[\s\xa0]*J[aá]nov)|ی(?:ُوحنّا|وحنّا)|य(?:ूहन्ना(?:को)?|ुहत्रा|ोहान(?:ाच)?)|San[\s\xa0]*J[au](?:[au]n)|(?:[ei](?:[\s\xa0]*Gjonit|\.[\s\xa0]*Gjonit))|G(?:i(?:ăng|o(?:an|vanni))?|v|j(?:onit)?)|Ј(?:ован(?:ов[ао])?|н)|Послання[\s\xa0]*Івана|Йоан(?:ово)?|y(?:uhann[aā]ko|ūh(?:ãnā|ann[aā]ko))|J(?:phn|óh|o(?:phn|nh|on|[aã]o|h(?:anne(?:s(?:brev(?:et)?)?|ksen[\s\xa0]*kirje)|[mn])?)?|áno[sv]|u[au]n|n|ean|a(?:[au]n|n(?:o(?:s|va?)|[uů]v|a)?)|h(?:[ho]n|n)?)?|அருளப்பர்|ย(?:อห์น|น)|I(?:oan(?:nis)?|v(?:anova[\s\xa0]*Poslanica)?|n)|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)|list[\s\xa0]*Jan[uů]v|Y(?:o(?:va[nṉ]|h(?:an(?:es?|a))?|kanan|o(?:x(?:anaa)?|hanna))|ōva[nṉ])|ਯੂਹੰਨਾ)|۔یوحنا|a(?:\.[\s\xa0]*Jo[aã]o|[\s\xa0]*Jo[aã]o)|o(?:[\s\xa0]*(?:J(?:o[aã]o|[au](?:[au]n))|San[\s\xa0]*J[au](?:[au]n))|\.[\s\xa0]*(?:J(?:o[aã]o|[au](?:[au]n))|San[\s\xa0]*J[au](?:[au]n)))|John|(?:[яе](?:\.[\s\xa0]*(?:Ио(?:хана|анна)|послание[\s\xa0]*Иоанна)|[\s\xa0]*(?:Ио(?:хана|анна)|послание[\s\xa0]*Иоанна)))|e(?:[\s\xa0]*J(?:oh(?:annes(?:brevet)?)?|ean)|\.[\s\xa0]*J(?:oh(?:annes(?:brevet)?)?|ean)|me(?:\.[\s\xa0]*Jean|[\s\xa0]*Jean))|º(?:[\s\xa0]*(?:San[\s\xa0]*J[au](?:[au]n)|J[au](?:[au]n))|\.[\s\xa0]*(?:San[\s\xa0]*J[au](?:[au]n)|J[au](?:[au]n)))|°(?:[\s\xa0]*Giovanni|\.[\s\xa0]*Giovanni)|요한|\.(?:۔یوحنا|[oº](?:[\s\xa0]*(?:San[\s\xa0]*J(?:[au](?:[au]n)|J[au](?:[au]n))|\.[\s\xa0]*(?:San[\s\xa0]*J[au](?:[au]n)|J[au](?:[au]n))))|[\s\xa0]*(?:п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Јован|ослан(?:и(?:е[\s\xa0]*(?:Иоанна|на[\s\xa0]*апостол[\s\xa0]*Јован)|ца[\s\xa0]*Јованова)|ня[\s\xa0]*апостола[\s\xa0]*Івана))|List[\s\xa0]*(?:Jana|(?:[sś]w(?:\.[\s\xa0]*Jana|[\s\xa0]*Jana)))|யோவான்|ଯୋହନଙ|y[uū]hann(?:[aā]ko)|І(?:вана|оанна)|Ио(?:хана|ан(?:на|ово)?)|ی(?:ُوحنّا|وحنّا)|San[\s\xa0]*J[au](?:[au]n)|Послання[\s\xa0]*Івана|Јован(?:ов[ао])?|Йоан(?:ово)?|J(?:phn|óh|o(?:phn|nh|on|[aã]o|h(?:anne(?:s(?:brev(?:et)?)?|ksen[\s\xa0]*kirje)|[mn])?)?|áno[sv]|u[au]n|n|ean|a(?:[au]n|n(?:o(?:s|va?)|[uů]v|a)?)|h(?:[ho]n|n)?)?|य(?:ूहन्ना(?:को)?|ुहत्रा)|Yo(?:h(?:an(?:es?|a))?|kanan|o(?:x(?:anaa)?|hanna))|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)|I(?:oan(?:nis)?|vanova[\s\xa0]*Poslanica|n)|G(?:i(?:ăng|o(?:an|vanni))?|jonit)|list[\s\xa0]*Jan[uů]v|ยอห์น)|-?یُوحنّا)|ème(?:\.[\s\xa0]*Jean|[\s\xa0]*Jean))|تیسرا(?:۔یوحنا|[\s\xa0]*ی(?:ُوحنّا|وحنّا)|-?یُوحنّا)|Kolmas[\s\xa0]*Johanneksen[\s\xa0]*kirje|ی(?:ُوحنّا[\s\xa0]*کا[\s\xa0]*تیسرا[\s\xa0]*عام[\s\xa0]*خط|وحن(?:ا[\s\xa0]*کا[\s\xa0]*تیسرا[\s\xa0]*عام[\s\xa0]*خط|ّا[\s\xa0]*کا[\s\xa0]*(?:۳[\s\xa0]*خط|3(?:\.[\s\xa0]*خط|[\s\xa0]*خط)|تیسرا[\s\xa0]*خط)))|Þriðja[\s\xa0]*(?:br[eé]f[\s\xa0]*J(?:[oó]hannesar)|J[oó]hannesarbr(?:[eé]f))|J(?:[aá]nos[\s\xa0]*III|ohannes(?:[\s\xa0]*tredje[\s\xa0]*brev|(?:['’][\s\xa0]*(?:Tredje[\s\xa0]*Brev|3(?:[\s\xa0]*Brev|\.[\s\xa0]*Brev)))))|א(?:גרתו[\s\xa0]*השלישית[\s\xa0]*של[\s\xa0]*יוחנן[\s\xa0]*השלי|יגרת[\s\xa0]*יוחנן[\s\xa0]*השלישית)|ତୃତୀୟ[\s\xa0]*ଯୋହନଙ|Waraka[\s\xa0]*wa[\s\xa0]*Tatu[\s\xa0]*wa[\s\xa0]*Yohane|D(?:ritte[\s\xa0]*Johannes|erde[\s\xa0]*Joh(?:annes)?)|Γ(?:['ʹʹ΄’][\s\xa0]*(?:᾿Ιω|Ιω(?:[άα]ννη)?))|رسالة[\s\xa0]*(?:القديس[\s\xa0]*يوحنا[\s\xa0]*الثالثة|يوحنا[\s\xa0]*(?:3|الثالثة))|Epistula[\s\xa0]*I(?:oannis[\s\xa0]*III|II[\s\xa0]*Ioannis)|Ιω[άα]ννου[\s\xa0]*Γ['ʹʹ΄’]|T(?:řet[ií][\s\xa0]*(?:J(?:an(?:(?:[uů]v|ova)?)?|list[\s\xa0]*Jan[uů]v))|atu[\s\xa0]*Yoh(?:an[ae])?|er(?:ce(?:ir[ao][\s\xa0]*Jo(?:[aã]o)|r(?:[\s\xa0]*(?:San[\s\xa0]*J[au](?:[au]n)|J[au](?:[au]n))|o[\s\xa0]*(?:San[\s\xa0]*J[au](?:[au]n)|J[au](?:[au]n))))|z(?:o[\s\xa0]*Giovanni|a[\s\xa0]*(?:lettera[\s\xa0]*di[\s\xa0]*Giovanni|Giovanni)))|r(?:e(?:[cæć]a[\s\xa0]*Ivanova[\s\xa0]*Poslanica|dje[\s\xa0]*Joh(?:annes(?:brev(?:et)?)?)?|t(?:i(?:a[\s\xa0]*(?:J[aá]nov|kniha[\s\xa0]*J[aá]nov)|[\s\xa0]*(?:J(?:an(?:[uů]v|ov(?:[\s\xa0]*list|a))?|ánov[\s\xa0]*list)?|list[\s\xa0]*Jan[uů]v))|je[\s\xa0]*poslannja[\s\xa0]*apostola[\s\xa0]*Ivana|í[\s\xa0]*(?:J(?:an(?:[uů]v|ov(?:[\s\xa0]*list|a))?|ánov[\s\xa0]*list)?|list[\s\xa0]*Jan[uů]v)))|zeci(?:[\s\xa0]*(?:List[\s\xa0]*(?:Jana|(?:[sś]w(?:\.[\s\xa0]*Jana|[\s\xa0]*Jana)))|Jana)|a[\s\xa0]*(?:List[\s\xa0]*(?:Jana|(?:[sś]w(?:\.[\s\xa0]*Jana|[\s\xa0]*Jana)))|Jana))|oisi(?:[eè]me(?:s[\s\xa0]*Jean|[\s\xa0]*Jean)))|hird[\s\xa0]*J(?:phn|o(?:phn|nh|on|h[mn]?)?|n|h(?:[ho]n|n)?))|M[uū](?:[nṉ](?:[rṛ](?:[aā]vatu[\s\xa0]*யோவான்)))|y(?:oh[aā]n(?:[aā]ce(?:[mṃ][\s\xa0]*tisre[\s\xa0]*patra))|uhann[aā]ko[\s\xa0]*testro[\s\xa0]*patra|ū(?:ḥannā[\s\xa0]*kā[\s\xa0]*tīsrā[\s\xa0]*ʿām[\s\xa0]*ḫaṭ|h(?:ãnā[\s\xa0]*dī[\s\xa0]*tījī[\s\xa0]*pattrī|ann[aā]ko[\s\xa0]*testro[\s\xa0]*patra)))|ம(?:ூன்றாவது[\s\xa0]*யோவான்|ுன்றாம்[\s\xa0]*யோவான்)|I(?:katlong[\s\xa0]*Juan|II(?:[\s\xa0]*(?:Gi(?:ăng|o(?:an|vanni))?|List[\s\xa0]*(?:Jana|(?:[sś]w(?:\.[\s\xa0]*Jana|[\s\xa0]*Jana)))|J(?:phn|óh|áno[sv]|u[au]n|o(?:phn|nh|h(?:anne(?:ksen[\s\xa0]*kirje|s)|[mn])?|on|[aã]o)?|n|ean|a(?:[au]n|n(?:o(?:s|va?)|[uů]v|a)?)|h(?:[ho]n|n)?)?|І(?:вана|оанна)|San[\s\xa0]*J[au](?:[au]n)|Послання[\s\xa0]*Івана|Јован(?:ов[ао])?|(?:[ИЙ]оан(?:ово)?)|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)|list[\s\xa0]*Jan[uů]v|Yo(?:ox(?:anaa)?|h(?:an(?:es?|a))?|kanan)|I(?:vanova[\s\xa0]*Poslanica|n|oan)|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Јован|ослан(?:ня[\s\xa0]*апостола[\s\xa0]*Івана|и(?:е[\s\xa0]*на[\s\xa0]*апостол[\s\xa0]*Јован|ца[\s\xa0]*Јованова))))|\.[\s\xa0]*(?:Gi(?:ăng|o(?:an|vanni))?|List[\s\xa0]*(?:Jana|(?:[sś]w(?:\.[\s\xa0]*Jana|[\s\xa0]*Jana)))|J(?:phn|óh|áno[sv]|u[au]n|o(?:phn|nh|h(?:anne(?:ksen[\s\xa0]*kirje|s)|[mn])?|on|[aã]o)?|n|ean|a(?:[au]n|n(?:o(?:s|va?)|[uů]v|a)?)|h(?:[ho]n|n)?)?|І(?:вана|оанна)|San[\s\xa0]*J[au](?:[au]n)|Послання[\s\xa0]*Івана|Јован(?:ов[ао])?|(?:[ИЙ]оан(?:ово)?)|соборне[\s\xa0]*послання[\s\xa0]*св(?:[\s\xa0]*апостола[\s\xa0]*Іоанна|\.[\s\xa0]*апостола[\s\xa0]*Іоанна)|I(?:oan(?:nis)?|vanova[\s\xa0]*Poslanica|n)|list[\s\xa0]*Jan[uů]v|Yo(?:ox(?:anaa)?|h(?:an(?:es?|a))?|kanan)|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Јован|ослан(?:ня[\s\xa0]*апостола[\s\xa0]*Івана|и(?:е[\s\xa0]*на[\s\xa0]*апостол[\s\xa0]*Јован|ца[\s\xa0]*Јованова))))))|요한(?:의[\s\xa0]*셋째[\s\xa0]*서간|[3삼]서)|۳(?:۔یوحنا|[\s\xa0]*ی(?:ُوحنّا|وحنّا)|-?یُوحنّا))|(?:3\.[oº](?:[\s\xa0]*J(?:[au](?:[au]n)|\.[\s\xa0]*(?:San[\s\xa0]*J[au](?:[au]n)|J[au](?:[au]n))))|Třet(?:[ií][\s\xa0]*(?:J|list[\s\xa0]*Jan[uů]v)))|3\.[oº]\.[\s\xa0]*(?:San[\s\xa0]*J(?:[au](?:[au]n)|J[au](?:[au]n)))|3\.[oº]\.[\s\xa0]*J(?:[au](?:[au]n))|(?:约(?:三》?|翰[三叁]书》?)|Johannes’[\s\xa0]*tredje[\s\xa0]*brev|若望三書》?|約(?:三》?|翰[三參]書》?)|《(?:約(?:翰[參三]書|三)|若望三書|伊望第三|约(?:翰[三叁]书|三))|伊望第三》?|يوحنا[\s\xa0]*الثالثة|Tre(?:(?:[cćæ]a[\s\xa0]*Ivanova(?:[\s\xa0]*poslanica)?)|t[ií][\s\xa0]*J(?:[aá]nov))|3(?:[\s\xa0]*(?:Ivanova|Johanneksen)|\.[\s\xa0]*(?:Ivanova|Johanneksen))|Kolmas[\s\xa0]*Johanneksen|I(?:II(?:\.[\s\xa0]*(?:Ivanova|Johanneksen)|[\s\xa0]*(?:I(?:vanova|oannis)|Johanneksen))|oannis[\s\xa0]*III)))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["John"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(y(?:uhannale[\\s\\xa0]*lekʰeko[\\s\\xa0]*susm[aā]c(?:[aā]r)|oh[aā]n(?:[aā]ne[\\s\\xa0]*lihilele[\\s\\xa0]*(?:[sŝ]ubʰavartam(?:[aā]n))))|(?:யோவா(?:ன்[\\s\\xa0]*(?:நற்செய்தி|எழுதிய[\\s\\xa0]*(?:நற்செய்தி|சுவிசேஷம்)))?|The[\\s\\xa0]*Gospel[\\s\\xa0]*(?:of[\\s\\xa0]*(?:S(?:t(?:[\\s\\xa0]*J(?:phn|n|o(?:phn|nh|on|h[mn]?)|h(?:[ho]n|n)?)|\\.[\\s\\xa0]*J(?:phn|n|o(?:phn|nh|on|h[mn]?)|h(?:[ho]n|n)?))|aint[\\s\\xa0]*J(?:phn|n|o(?:phn|nh|on|h[mn]?)|h(?:[ho]n|n)?))|J(?:phn|n|o(?:phn|nh|on|h[mn]?)|h(?:[ho]n|n)?))|according[\\s\\xa0]*to[\\s\\xa0]*(?:S(?:t(?:[\\s\\xa0]*J(?:phn|n|o(?:phn|nh|on|h[mn]?)|h(?:[ho]n|n)?)|\\.[\\s\\xa0]*J(?:phn|n|o(?:phn|nh|on|h[mn]?)|h(?:[ho]n|n)?))|aint[\\s\\xa0]*J(?:phn|n|o(?:phn|nh|on|h[mn]?)|h(?:[ho]n|n)?))|J(?:phn|n|o(?:phn|nh|on|h[mn]?)|h(?:[ho]n|n)?)))|يو|Ἰω|ย(?:อห์น|[นฮ])|От[\\s\\xa0]*Иоана[\\s\\xa0]*свето[\\s\\xa0]*Евангелие|E(?:van(?:jelium[\\s\\xa0]*Pod[lľ]a[\\s\\xa0]*J(?:[aá]na)|geli(?:e(?:t[\\s\\xa0]*etter[\\s\\xa0]*Johannes|[\\s\\xa0]*volgens[\\s\\xa0]*Johannes)|um[\\s\\xa0]*(?:podle[\\s\\xa0]*Jana|secundum[\\s\\xa0]*Ioannem))|[ðđ]elje[\\s\\xa0]*po[\\s\\xa0]*Ivanu|keliumi[\\s\\xa0]*Johanneksen[\\s\\xa0]*mukaan)|banghelyo[\\s\\xa0]*(?:ayon[\\s\\xa0]*kay[\\s\\xa0]*(?:Juan|San[\\s\\xa0]*Juan)|ni[\\s\\xa0]*San[\\s\\xa0]*Juan)|l[\\s\\xa0]*Evangelio[\\s\\xa0]*de[\\s\\xa0]*J[au](?:[au]n)|w(?:angelia[\\s\\xa0]*(?:w(?:g[\\s\\xa0]*(?:[sś]w(?:\\.[\\s\\xa0]*Jana|[\\s\\xa0]*Jana))|edług[\\s\\xa0]*(?:[sś]w(?:\\.[\\s\\xa0]*Jana|[\\s\\xa0]*Jana)))|Jana)|\\.[\\s\\xa0]*Jana|[\\s\\xa0]*Jana?))|G(?:jo(?:ni)?|i(?:ăng|oan)?|[gv])|Ungjilli[\\s\\xa0]*i[\\s\\xa0]*Gjonit|அருளப்பர்[\\s\\xa0]*நற்செய்தி|Vangelo[\\s\\xa0]*di[\\s\\xa0]*(?:San[\\s\\xa0]*Giovanni|Giovanni)|Ιω(?:[άα]ν(?:νης)?)?|《(?:伊望》|若望福音》|(?:[約约](?:》|翰福音》)))|הבשורה[\\s\\xa0]*על[\\s\\xa0\\-?]*פי[\\s\\xa0]*יוחנן|І[вн]|إنجيل[\\s\\xa0]*يوحنا|ଯୋହନ[\\s\\xa0]*ଲିଖିତ[\\s\\xa0]*ସୁସମାଗ୍ଭର|Y(?:uhanna|o(?:ox(?:anaa)?|kanan|v[aā](?:[nṉ][\\s\\xa0]*Na(?:[rṛ]ceyti))|h(?:aannisa)?)|ōv[aā](?:[nṉ][\\s\\xa0]*Na(?:[rṛ]ceyti)))|य(?:ूह(?:ान्ना|न(?:ा|्ना(?:को[\\s\\xa0]*सुसमाचार|ले[\\s\\xa0]*लेखेको[\\s\\xa0]*सुसमाचार)?))|ोहान(?:ाने[\\s\\xa0]*लिहिलेले[\\s\\xa0]*शुभवर्तमान)?|ुह(?:त्रा|न्ना)|हून्ना)|ヨハネ(?:による福音書|福音書|傳福音書|伝)|ی(?:وحنا[\\s\\xa0]*کی[\\s\\xa0]*انجیل|ُوحنّا[\\s\\xa0]*کی[\\s\\xa0]*انجیل)|Еван(?:гелие(?:[\\s\\xa0]*(?:според[\\s\\xa0]*Јован|от[\\s\\xa0]*(?:Иоан(?:на)?|Йоан))|то[\\s\\xa0]*според[\\s\\xa0]*Јован)|ђеље[\\s\\xa0]*по[\\s\\xa0]*Јовану)|พระวรสารนักบุญจอห์น|Sulat[\\s\\xa0]*ni[\\s\\xa0]*San[\\s\\xa0]*Juan|Ј(?:н|еванђеље[\\s\\xa0]*по[\\s\\xa0]*Јовану)|요한(?:복음서?|[\\s\\xa0]*복음서?)|J(?:e(?:van(?:helije[\\s\\xa0]*vid[\\s\\xa0]*Ivana|đelje[\\s\\xa0]*po[\\s\\xa0]*Ivanu)|an)|án(?:os)?|o(?:[aã]o|hann(?:is[\\s\\xa0]*evangelium|e(?:s(?:arguðspjall|evangeliet)|ksen[\\s\\xa0]*evankeliumi)))|óh(?:annesarguðspjall)?|ano(?:vo[\\s\\xa0]*evangelium|s))|y(?:ū(?:h(?:ann[aā]le[\\s\\xa0]*lekʰeko[\\s\\xa0]*susm(?:[aā]c(?:[aā]r))|ãnā[\\s\\xa0]*dī[\\s\\xa0]*ĩjīl)|ḥannā[\\s\\xa0]*kī[\\s\\xa0]*injīl)|uhannāle[\\s\\xa0]*lekʰeko[\\s\\xa0]*susm[aā]c(?:[aā]r))|Κατ[άα][\\s\\xa0]*Ιω(?:[άα]ννην)|Mabuting[\\s\\xa0]*Balita[\\s\\xa0]*ayon[\\s\\xa0]*kay[\\s\\xa0]*(?:Juan|San[\\s\\xa0]*Juan)|Євангелі(?:є[\\s\\xa0]*від[\\s\\xa0]*(?:св(?:[\\s\\xa0]*[ИЙ]оана|\\.[\\s\\xa0]*[ИЙ]оана)|Івана)|я[\\s\\xa0]*від[\\s\\xa0]*(?:св(?:[\\s\\xa0]*Івана|\\.[\\s\\xa0]*Івана)|Івана))|И(?:охан|н)|I(?:oan(?:nes)?|van|njil(?:[\\s\\xa0]*Yohanes|i[\\s\\xa0]*ya[\\s\\xa0]*Yohan[ae]))|ਯੂਹ(?:ਾਂਨਾ|ੰਨਾ[\\s\\xa0]*ਦੀ[\\s\\xa0]*ਇੰਜੀਲ))|Иоана|yohanane|(?:يوحنا|யோவான்|य(?:ोहानाने|ूहन्नाले)|Y(?:ōv[aā][nṉ]|o(?:han(?:es?|a)|v[āa][nṉ]))|От[\\s\\xa0]*Иоан(?:на|а)|G(?:iovanni|ospel[\\s\\xa0]*(?:of[\\s\\xa0]*(?:S(?:t(?:[\\s\\xa0]*J(?:phn|n|o(?:phn|nh|on|h[nm]?)|h(?:[oh]n|n)?)|\\.[\\s\\xa0]*J(?:phn|n|o(?:phn|nh|on|h[nm]?)|h(?:[oh]n|n)?))|aint[\\s\\xa0]*J(?:phn|n|o(?:phn|nh|on|h[nm]?)|h(?:[oh]n|n)?))|J(?:phn|n|o(?:phn|nh|on|h[mn]?)|h(?:[ho]n|n)?))|according[\\s\\xa0]*to[\\s\\xa0]*(?:S(?:t(?:[\\s\\xa0]*J(?:phn|n|o(?:phn|nh|on|h[nm]?)|h(?:[oh]n|n)?)|\\.[\\s\\xa0]*J(?:phn|n|o(?:phn|nh|on|h[mn]?)|h(?:[oh]n|n)?))|aint[\\s\\xa0]*J(?:phn|n|o(?:phn|nh|on|h[mn]?)|h(?:[ho]n|n)?))|J(?:phn|n|o(?:phn|nh|on|h[mn]?)|h(?:[ho]n|n)?))))|ی(?:ُوحنّا|وحنا)|《(?:(?:[约約](?:翰福音)?)|伊望|若望福音)|y(?:uhann[aā]le|ūh(?:ann[aā]le|ãnā)|oh(?:anāne|ān[aā]ne))|Јован|伊望》|Йоана?|Від[\\s\\xa0]*Івана|요한|若望福音》|(?:[約约](?:》|翰福音》))|ଯୋହନ|San[\\s\\xa0]*Juan|Иоан|J(?:ána|uun|ohanne(?:ksen|s)|a(?:[ua]n|na))|ਯੂਹੰਨਾ)|(?:S(?:t(?:[\\s\\xa0]*J(?:phn|n|o(?:phn|nh|on|h[mn]?)|h(?:[oh]n|n)?)|\\.[\\s\\xa0]*J(?:phn|n|o(?:phn|nh|on|h[nm]?)|h(?:[oh]n|n)?))|aint[\\s\\xa0]*J(?:phn|n|o(?:phn|nh|on|h[nm]?)|h(?:[oh]n|n)?))|約翰福音|约(?:翰福音)?|J(?:phn|n|uan|o(?:phn|nh|on|h[nm]?)|h(?:[ho]n|n)?)|伊望|若望福音|Івана))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Josh"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(ИНав|(?:יהושע|І(?:сус[\\s\\xa0]*Навин|[\\s\\xa0]*Нав|\\.[\\s\\xa0]*Нав)|यहोश(?:ु|वा|ू(?:को[\\s\\xa0]*पुस्तक)?)|யோசு(?:வா(?:வின்[\\s\\xa0]*புத்தகம்)?)?|Ks(?:[\\s\\xa0]*Jozuego|\\.[\\s\\xa0]*Jozuego|i[eę]g(?:[ai][\\s\\xa0]*Jozuego))|Ј[ео]шуа|Єг|يش|Li(?:ber[\\s\\xa0]*Iosue|v[\\s\\xa0]*Jozye[\\s\\xa0]*a)|여호(?:수아기?)?|ヨシュア記?|Ἰη|I(?:sus[\\s\\xa0]*Navyn|os(?:ua[\\s\\xa0]*Navi)?)|И(?:с(?:ус[\\s\\xa0]*Навин|[\\s\\xa0]*Нав|\\.[\\s\\xa0]*Нав)|\\.[\\s\\xa0]*Н|еш(?:уа)?|[\\s\\xa0]*Н)|Книга[\\s\\xa0]*(?:Иисус(?:[\\s\\xa0]*Навин|а[\\s\\xa0]*Навина)|на[\\s\\xa0]*Исус[\\s\\xa0]*Н(?:евин|авиев)|Єгошу[ії]|Ісуса[\\s\\xa0]*Навина)|سفر[\\s\\xa0]*يشوع|Ιη(?:σ(?:ο[υύ]ς[\\s\\xa0]*του[\\s\\xa0]*Ναυ[ήη]|[\\s\\xa0]*Ναυ[ήη]?))?|یش(?:ُوع|وع)|J(?:sh?|o(?:us(?:hua|ua)|s(?:va(?:s[\\s\\xa0]*(?:Bog|bok)|bog(?:en)?)?|úab[oó]k|u(?:ova|a(?:b[oó]k|h)?|[eé])|h(?:ua)?)?|os(?:uan[\\s\\xa0]*kirja)?|z(?:s(?:u[eé])?|u(?:eu?|ova|a))?|šu(?:ova|a))|š|ó(?:s[uú]ab(?:[oó]k)?|z(?:s(?:u[eé])?|u(?:ova|a))))|수|โยชูวา|ya(?:ho(?:ŝaw[aā]|š(?:ūko[\\s\\xa0]*pustak|u(?:ko[\\s\\xa0]*pustak|ā))|s(?:[uū]ko[\\s\\xa0]*pustak|aw[aā]))|šūʿ)|《(?:[书書]》|約書亞記》|约书亚记》|若蘇厄書》)|ยชว|ଯିହୋଶୂୟଙ୍କର[\\s\\xa0]*ପୁସ୍ତକ|Y(?:a(?:sh(?:uuca)?|asu|hoshoo)|o(?:s(?:hua|ua)?|cuv[aā])|usak|ōcuv[aā])|G(?:s(?:ua)?|i(?:ô(?:-?su[aê]|s)|osu[eèé]))|ਯਹੋਸ਼ੁਆ)|Jós|(?:يشوع|书》?|約書亞記》?|Jo(?:osuan|svas|z(?:uego|ye))|書》|若蘇厄書》?|И(?:исус(?:[\\s\\xa0]*Навин|а[\\s\\xa0]*Навина)|сус[\\s\\xa0]*Навиев)|ଯିହୋଶୂୟଙ୍କର|约书亚记》?|Giô|यहोशूको|Єгошу[їі]|Iosu[ae]|Нав|Ісуса[\\s\\xa0]*Навина|《(?:[书書]|約書亞記|约书亚记|若蘇厄書)|yaho[šs](?:[uū]ko)))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["1Esd"],
        apocrypha: true,
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])((?:1(?:\.(?:[\s\xa0]*(?:E(?:s(?:d(?:r(?:a(?:s(?:bog)?|e)?)?)?|ra?)?|z(?:d(?:r(?:á(?:[sš](?:ova)?)|a(?:s(?:ova|za)?|š(?:ova)?)?))?|ra))|Јездрина|Ездр(?:и(?:на)?|а)|Ésdras|Ks(?:i[eę]g(?:[ai][\s\xa0]*Ezdrasza)|\.[\s\xa0]*Ezdrasza|[\s\xa0]*Ezdrasza))|(?:[oº](?:\.[\s\xa0]*Esdras|[\s\xa0]*Esdras)))|[\s\xa0]*(?:E(?:s(?:d(?:r(?:a(?:s(?:bog)?|e)?)?)?|ra?)?|z(?:d(?:r(?:á(?:[sš](?:ova)?)|a(?:s(?:ova|za)?|š(?:ova)?)?))?|ra))|Јез(?:дрина)?|k(?:\.[\s\xa0]*Ezdr(?:[aá](?:[sš](?:ova)?))|[\s\xa0]*Ezdr(?:[aá](?:[sš](?:ova)?)))|எஸ்திராஸ்|Ездр(?:и(?:на)?|а)|Ésdras|Ks(?:i[eę]g(?:[ai][\s\xa0]*Ezdrasza)|\.[\s\xa0]*Ezdrasza|[\s\xa0]*Ezdrasza))|re(?:\.[\s\xa0]*Esdras|[\s\xa0]*Esdras)|-?(?:ше(?:[\s\xa0]*Ездр[аи]|\.[\s\xa0]*Ездр[аи])|(?:[ае](?:[\s\xa0]*Ездр[аи]|\.[\s\xa0]*Ездр[аи])))|°(?:\.[\s\xa0]*(?:Esdras?|Ésdras)|[\s\xa0]*(?:Esdras?|Ésdras))|(?:[ºao](?:\.[\s\xa0]*Esdras|[\s\xa0]*Esdras))|e(?:\.[\s\xa0]*E(?:zra|sdras)|r(?:\.[\s\xa0]*Esdras|[\s\xa0]*Esdras|e(?:\.[\s\xa0]*Esdras|[\s\xa0]*Esdras))|[\s\xa0]*E(?:zra|sdras))|st(?:\.[\s\xa0]*Esd(?:r(?:as)?)?|[\s\xa0]*Esd(?:r(?:as)?)?)|ère(?:\.[\s\xa0]*Esdras|[\s\xa0]*Esdras))|Una(?:[\s\xa0]*E(?:zra|sdras)|ng[\s\xa0]*E(?:zra|sdras))|E(?:ls[oő][\s\xa0]*Ezd(?:r(?:[aá]s)?)|zdr[aá]s[\s\xa0]*I|rste[\s\xa0]*Esra|sdra[\s\xa0]*greco|erste[\s\xa0]*E(?:zra|sdras)|nsimm[aä]inen[\s\xa0]*Esra)|F(?:ørste[\s\xa0]*Es(?:dras(?:bog)?|ra)|[oö]rsta[\s\xa0]*Esra|irst[\s\xa0]*Esd(?:r(?:as)?)?)|エ[スズ](?:(?:[トド]ラ第一巻|ラ第一書))|إسدراس[\s\xa0]*الأول|Liber[\s\xa0]*(?:I[\s\xa0]*Esdrae|Esdrae[\s\xa0]*I)|에스드라[\s\xa0]*1서|П(?:ърва[\s\xa0]*(?:Ездра|книга[\s\xa0]*на[\s\xa0]*Ездра)|рва[\s\xa0]*(?:Ездрина|Јездрина)|ерш[ае][\s\xa0]*Ездр[аи])|K(?:wanza[\s\xa0]*Ezra|itabu[\s\xa0]*cha[\s\xa0]*Kwanza[\s\xa0]*cha[\s\xa0]*Ezra)|P(?:ierwsz(?:[aey][\s\xa0]*(?:Ezdrasza|Ks(?:i[eę]g(?:[ai][\s\xa0]*Ezdrasza)|\.[\s\xa0]*Ezdrasza|[\s\xa0]*Ezdrasza)))|r(?:emi(?:er(?:s[\s\xa0]*Esdras|[\s\xa0]*Esdras|e(?:s[\s\xa0]*Esdras|[\s\xa0]*Esdras))|ère(?:s[\s\xa0]*Esdras|[\s\xa0]*Esdras))|v(?:n[ií][\s\xa0]*Ezdr(?:[aá][sš])|(?:[aá][\s\xa0]*(?:kniha[\s\xa0]*Ezdr(?:[aá](?:[sš](?:ova)?))|Ezdr(?:[aá](?:[sš](?:ova)?))))|(?:[yý][\s\xa0]*(?:list[\s\xa0]*Ezdr(?:[aá](?:[sš](?:ova)?))|Ezdr(?:[aá](?:[sš](?:ova)?)))))|im(?:e(?:r(?:o[\s\xa0]*Esdras|[\s\xa0]*Esdras)|ir[ao][\s\xa0]*Esdras)|(?:[ao][\s\xa0]*(?:Esdras?|Ésdras)))))|חזון[\s\xa0]*עזרא|Derde[\s\xa0]*E(?:zra|sdras)|《1Esd》|Α(?:['ʹʹ΄’][\s\xa0]*(?:[ΈΕ]σδ(?:ρ(?:ας)?)?))|T(?:erz[ao][\s\xa0]*Esdra|redje[\s\xa0]*Es(?:ra|drasbog))|2(?:(?:[ея](?:[\s\xa0]*Ездры|\.[\s\xa0]*Ездры))|-?(?:[ея](?:[\s\xa0]*Ездры|\.[\s\xa0]*Ездры))|[\s\xa0]*Езд(?:ры)?|\.[\s\xa0]*Ездры)|3(?:°(?:\.[\s\xa0]*Esdra|[\s\xa0]*Esdra)|e(?:[\s\xa0]*E(?:s(?:dras|ra)|zra)|\.[\s\xa0]*E(?:s(?:dras|ra)|zra))|[\s\xa0]*E(?:z(?:dra|ra)|s(?:dra(?:s(?:bog)?)?|ra))|\.[\s\xa0]*E(?:z(?:dra|ra)|s(?:dra(?:s(?:bog)?)?|ra)))|[ΈΕ]σδρας[\s\xa0]*Α['ʹʹ΄’]|I(?:[\s\xa0]*(?:Јездрина|Ездр(?:и(?:на)?|а)|Ésdras|E(?:z(?:d(?:r(?:á(?:[sš](?:ova)?)|a(?:s(?:ova|za)?|š(?:ova)?)?))?|ra)|s(?:d(?:r(?:as?)?)?|ra))|Ks(?:i[eę]g(?:[ai][\s\xa0]*Ezdrasza)|\.[\s\xa0]*Ezdrasza|[\s\xa0]*Ezdrasza))|II(?:[\s\xa0]*E(?:z(?:dra|ra)|sdras?)|\.[\s\xa0]*E(?:z(?:dra|ra)|sdras?))|\.[\s\xa0]*(?:Јездрина|E(?:z(?:d(?:r(?:á(?:[sš](?:ova)?)|a(?:s(?:ova|za)?|š(?:ova)?)?))?|ra)|s(?:d(?:r(?:a[es]?)?)?|ra))|Ездр(?:и(?:на)?|а)|Ésdras|Ks(?:i[eę]g(?:[ai][\s\xa0]*Ezdrasza)|\.[\s\xa0]*Ezdrasza|[\s\xa0]*Ezdrasza))))|Els(?:[oő][\s\xa0]*Ezd)|(?:《1Esd|I[\s\xa0]*Esdrae|1Esd》?))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["2Esd"],
        apocrypha: true,
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])((?:에스드라[\s\xa0]*2서|Fj(?:erde[\s\xa0]*Es(?:ra|drasbog)|[aä]rde[\s\xa0]*Esra)|Втора[\s\xa0]*(?:Ездра|книга[\s\xa0]*на[\s\xa0]*Ездра)|D(?:ru(?:h(?:(?:[aá][\s\xa0]*(?:kniha[\s\xa0]*Ezdr(?:[aá](?:[sš](?:ova)?))|Ezdr(?:[aá](?:[sš](?:ova)?))))|(?:[yý][\s\xa0]*(?:list[\s\xa0]*Ezdr(?:[aá](?:[sš](?:ova)?))|Ezdr(?:[aá](?:[sš](?:ova)?)))))|g(?:[ai][\s\xa0]*(?:Ezdrasza|Ks(?:i[eę]g(?:[ai][\s\xa0]*Ezdrasza)|\.[\s\xa0]*Ezdrasza|[\s\xa0]*Ezdrasza))))|euxi(?:[eè]me(?:s[\s\xa0]*Esdras|[\s\xa0]*Esdras)))|Se(?:gund[ao][\s\xa0]*Esdras|cond(?:[\s\xa0]*Esd(?:r(?:as)?)?|(?:[ao][\s\xa0]*(?:Esdras?|Ésdras))))|[ΈΕ]σδρας[\s\xa0]*Β['ʹʹ΄’]|4(?:°(?:\.[\s\xa0]*Esdra|[\s\xa0]*Esdra)|[\s\xa0]*E(?:z(?:dra|ra)|s(?:dra(?:s(?:bog)?)?|ra))|\.[\s\xa0]*E(?:z(?:dra|ra)|s(?:dra(?:s(?:bog)?)?|ra)))|Zweite[\s\xa0]*Esra|エ[スズ](?:(?:[トド]ラ第二巻|ラ第二書))|Друг(?:е[\s\xa0]*(?:книга[\s\xa0]*Ездри|Ездр[аи])|а[\s\xa0]*(?:Јездрина|книга[\s\xa0]*Ездри|Ездр(?:и(?:на)?|а)))|M[aá]sodik[\s\xa0]*Ezd(?:r(?:[aá]s)?)|Vierde[\s\xa0]*E(?:zra|sdras)|I(?:I(?:\.[\s\xa0]*(?:Јездрина|книга[\s\xa0]*Ездри|E(?:z(?:d(?:r(?:á(?:[sš](?:ova)?)|a(?:s(?:ova|za)?|š(?:ova)?)?))?|ra)|s(?:d(?:r(?:a[es]?)?)?|ra))|Ездр(?:и(?:на)?|а)|Ésdras|Ks(?:i[eę]g(?:[ai][\s\xa0]*Ezdrasza)|\.[\s\xa0]*Ezdrasza|[\s\xa0]*Ezdrasza))|[\s\xa0]*(?:Јездрина|книга[\s\xa0]*Ездри|Ездр(?:и(?:на)?|а)|Ésdras|E(?:z(?:d(?:r(?:á(?:[sš](?:ova)?)|a(?:s(?:ova|za)?|š(?:ova)?)?))?|ra)|s(?:d(?:r(?:as?)?)?|ra))|Ks(?:i[eę]g(?:[ai][\s\xa0]*Ezdrasza)|\.[\s\xa0]*Ezdrasza|[\s\xa0]*Ezdrasza)))|kalawang[\s\xa0]*E(?:zra|sdras)|V(?:[\s\xa0]*E(?:z(?:dra|ra)|sdras?)|\.[\s\xa0]*E(?:z(?:dra|ra)|sdras?)))|T(?:weede[\s\xa0]*E(?:zra|sdras)|oinen[\s\xa0]*Esra)|Pili[\s\xa0]*Ezra|Ezdr[aá]s[\s\xa0]*II|עזרא[\s\xa0]*החיצוני|And(?:r(?:e[\s\xa0]*Es(?:dras|ra)|a[\s\xa0]*Esra)|en[\s\xa0]*Esdrasbog)|《2Esd》|2(?:\.(?:[\s\xa0]*(?:E(?:s(?:d(?:r(?:a(?:s(?:bog)?|e)?)?)?|ra?)?|z(?:d(?:r(?:á(?:[sš](?:ova)?)|a(?:s(?:ova|za)?|š(?:ova)?)?))?|ra))|Јездрина|книга[\s\xa0]*Ездри|Ездр(?:и(?:на)?|а)|Ésdras|Ks(?:i[eę]g(?:[ai][\s\xa0]*Ezdrasza)|\.[\s\xa0]*Ezdrasza|[\s\xa0]*Ezdrasza))|(?:[oº](?:\.[\s\xa0]*Esdras|[\s\xa0]*Esdras)))|d(?:\.[\s\xa0]*Esdras|[\s\xa0]*Esdras|e(?:\.[\s\xa0]*Esdras|[\s\xa0]*Esdras))|e(?:\.[\s\xa0]*E(?:zra|sdras)|me(?:\.[\s\xa0]*Esdras|[\s\xa0]*Esdras)|[\s\xa0]*E(?:zra|sdras))|nd(?:\.[\s\xa0]*Esd(?:r(?:as)?)?|[\s\xa0]*Esd(?:r(?:as)?)?)|°(?:\.[\s\xa0]*(?:Esdras?|Ésdras)|[\s\xa0]*(?:Esdras?|Ésdras))|(?:[ºao](?:\.[\s\xa0]*Esdras|[\s\xa0]*Esdras))|[\s\xa0]*(?:E(?:s(?:d(?:r(?:a(?:s(?:bog)?|e)?)?)?|ra?)?|z(?:d(?:r(?:á(?:[sš](?:ova)?)|a(?:s(?:ova|za)?|š(?:ova)?)?))?|ra))|Јез(?:дрина)?|k(?:\.[\s\xa0]*Ezdr(?:[aá](?:[sš](?:ova)?))|[\s\xa0]*Ezdr(?:[aá](?:[sš](?:ova)?)))|எஸ்திராஸ்|книга[\s\xa0]*Ездри|Ездр(?:и(?:на)?|а)|Ésdras|Ks(?:i[eę]g(?:[ai][\s\xa0]*Ezdrasza)|\.[\s\xa0]*Ezdrasza|[\s\xa0]*Ezdrasza))|ème(?:\.[\s\xa0]*Esdras|[\s\xa0]*Esdras)|-?(?:ге(?:\.[\s\xa0]*(?:книга[\s\xa0]*Ездри|Ездр[аи])|[\s\xa0]*(?:книга[\s\xa0]*Ездри|Ездр[аи]))|(?:[ае](?:\.[\s\xa0]*(?:книга[\s\xa0]*Ездри|Ездр[аи])|[\s\xa0]*(?:книга[\s\xa0]*Ездри|Ездр[аи])))))|Liber[\s\xa0]*(?:II[\s\xa0]*Esdrae|Esdrae[\s\xa0]*II)|Β(?:['ʹʹ΄’][\s\xa0]*(?:[ΈΕ]σδ(?:ρ(?:ας)?)?))|3(?:(?:[ея](?:[\s\xa0]*Ездры|\.[\s\xa0]*Ездры))|-?(?:[ея](?:[\s\xa0]*Ездры|\.[\s\xa0]*Ездры))|[\s\xa0]*Езд(?:ры)?|\.[\s\xa0]*Ездры)|Kitabu[\s\xa0]*cha[\s\xa0]*Pili[\s\xa0]*cha[\s\xa0]*Ezra|إسدراس[\s\xa0]*الثاني|Quart[ao][\s\xa0]*Esdra)|M(?:[aá]sodik[\s\xa0]*Ezd)|(?:《2Esd|II[\s\xa0]*Esdrae|2Esd》?))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["Isa"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:イ[サザ]ヤ書?|ଯ(?:[ାୀ]ଶାଇୟ|ିଶାଇୟ[\\s\\xa0]*ଭବିଷ୍ୟ‌ଦ୍‌ବକ୍ତାଙ୍କର[\\s\\xa0]*ପୁସ୍ତକ)|Ks(?:\\.[\\s\\xa0]*Izajasza|i[eę]g(?:[ai][\\s\\xa0]*Izajasza)|[\\s\\xa0]*Izajasza)|Книга[\\s\\xa0]*(?:на[\\s\\xa0]*пророк[\\s\\xa0]*Исаия|пророка[\\s\\xa0]*(?:Исаии|Іса[ії])|Іса[ий][ії])|य(?:श(?:ा(?:य(?:ाह?)?)?|ैया(?:को[\\s\\xa0]*पुस्तक)?|या)|ेशैया)|سفر[\\s\\xa0]*إشعياء|Ê-?sai|I(?:z(?:a(?:j[aá][sš]|i(?:[aá][sš]|ja)))?|s(?:h(?:acyaah)?|a(?:a(?:[ai](?:(?:[ai]ha?|ha?))|ha?)|ía[hs]?|i(?:i(?:[ai]ha?|ha?)|sha?|e|a(?:[ai]ha?|s|ha?)?|ha?)?|ha?|[jy]a|ïe)?|sah|i(?:[ai](?:(?:[ai](?:(?:[ai]ha?|ha?))|ha?))|y(?:aasa)?|ha))?|a|-?sa(?:i-?a|-?gia))|ישע(?:יהו?|ה)|Y[eé]saya|اش|ୟ(?:ଶାଇୟ|ିଶାୟ)|எசா(?:யா)?|ya(?:ŝay[aā]|šəiy[aā]ko[\\s\\xa0]*pustak|s(?:əiy[aā]ko[\\s\\xa0]*pustak|haayaah|a(?:y[aā]|ʿyāh)|āyāh))|Jes(?:a(?:ia|ja(?:n[\\s\\xa0]*kirja|s[\\s\\xa0]*bok|bok(?:en|a))?))?|《(?:[賽赛]》|以(?:賽(?:亞書》|亚书》)|赛亚书》)|依撒意亞》)|Ис(?:а(?:и(?:ја)?|ја|я))?|ی(?:عسیاہ|سعیاہ)|Li(?:ber[\\s\\xa0]*Isaiae|v[\\s\\xa0]*Ezayi[\\s\\xa0]*a)|사|อ(?:ิสยาห์|สย)|ﺃﺷﻌﻴﺎء|E(?:s(?:eia|a(?:jas['’][\\s\\xa0]*Bog|i(?:ás|e|as['’][\\s\\xa0]*bok)?|ïe)?)|zs(?:ai[aá]s)?|c[aā]y[aā])|ਯ(?:ਸਾ(?:ਯਾਹ)?|ਾਸਾਯਾਹ)|ஏசா(?:யா[\\s\\xa0]*தீர்க்கதரிசியின்[\\s\\xa0]*புத்தகம்)?|إش(?:َعْياء|عيا)|Іс(?:ая)?|Ἠσ|이사(?:야서?)?|Η(?:ΣΑ(?:[ΊΙ]ΑΣ|Ϊ́ΑΣ)|σ(?:αΐας)?)|É(?:s(?:a(?:i(?:[aá]s|e)|ïe)?)?|zs(?:ai[aá]s)?))|(?:E(?:zayi|sa[ji]as)|Jesajan|[赛賽]》?|I(?:zajasza|-?sa)|यशैयाको|《(?:以(?:賽(?:亚书|亞書)|赛亚书)|[赛賽]|依撒意亞)|Ησαιας|以(?:賽(?:亞書》?|亚书》?)|赛亚书》?)|ஏசாயா|ଯିଶାଇୟ|ya[šs]əiy(?:[aā]ko)|依撒意亞》?|Іса[їі]|Исаи[яи]))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["2Sam"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])(2(?:[\s\xa0]*sam(?:ū(?:ʾīl|el(?:ko)?)|u(?:elko|wel))|\.[\s\xa0]*sam[uū]elko)|(?:Втор(?:о[\s\xa0]*(?:Самуил|книга[\s\xa0]*Самоилова)|а[\s\xa0]*(?:Самуил|Цар(?:е|ства)|книга[\s\xa0]*(?:Царства|Самоилова|на[\s\xa0]*Самуил)|Книга[\s\xa0]*на[\s\xa0]*царете))|I(?:I(?:[\s\xa0]*(?:Саму(?:[иії]л(?:ова)?)|K(?:s(?:[\s\xa0]*Samuel(?:owa|a)|i(?:[eę]g(?:[ai][\s\xa0]*Samuel(?:owa|a)))|\.[\s\xa0]*Samuel(?:owa|a))|ingdoms)|Re(?:inos|g(?:ilor|norum))|Цар(?:е|ства)|к(?:раљевима|нига[\s\xa0]*Сам(?:у[ії]лова|оилова))|S(?:ám(?:uel)?|a(?:-?mu-?ên|m(?:y[eè]l|weli|u(?:el(?:i(?:n[\s\xa0]*kirja)?|o[vw]a|[els])?|al[ls]?|[iëï]l|u['’]eel))?)|ma?)?|kniha[\s\xa0]*Samuelova|Книга[\s\xa0]*на[\s\xa0]*царете)|\.[\s\xa0]*(?:Саму(?:[иії]л(?:ова)?)|K(?:s(?:[\s\xa0]*Samuel(?:owa|a)|i(?:[eę]g(?:[ai][\s\xa0]*Samuel(?:owa|a)))|\.[\s\xa0]*Samuel(?:owa|a))|ingdoms)|Re(?:inos|g(?:ilor|norum))|Цар(?:е|ства)|к(?:раљевима|нига[\s\xa0]*Сам(?:у[ії]лова|оилова))|kniha[\s\xa0]*Samuelova|S(?:a(?:-?mu-?ên|m(?:y[eè]l|u(?:al[ls]?|[iëï]l|el(?:o[vw]a|i(?:n[\s\xa0]*kirja|s)?|[els])?|u['’]eel)|weli)?)|ám(?:uel)?|ma?)?|Книга[\s\xa0]*на[\s\xa0]*царете))|kalawang[\s\xa0]*Samuel)|2(?:-?(?:е(?:[\s\xa0]*(?:Samu[iï]l|Царств|книга[\s\xa0]*Саму[ії]лова|Саму(?:ила|(?:[ії]л(?:ова)?))|Книга[\s\xa0]*Царств)|\.[\s\xa0]*(?:Samu[iï]l|Царств|книга[\s\xa0]*Саму[ії]лова|Саму(?:ила|(?:[ії]л(?:ова)?))|Книга[\s\xa0]*Царств))|я(?:\.[\s\xa0]*(?:Самуила|Царств|Книга[\s\xa0]*Царств)|[\s\xa0]*(?:Самуила|Царств|Книга[\s\xa0]*Царств))|سموئیل|а(?:[\s\xa0]*(?:Samu[iï]l|Саму(?:[ії]л(?:ова)?)|книга[\s\xa0]*Саму[ії]лова)|\.[\s\xa0]*(?:Samu[iï]l|Саму(?:[ії]л(?:ова)?)|книга[\s\xa0]*Саму[ії]лова))|ге(?:[\s\xa0]*(?:Samu[iï]l|Саму(?:[ії]л(?:ова)?)|книга[\s\xa0]*Саму[ії]лова)|\.[\s\xa0]*(?:Samu[iï]l|Саму(?:[ії]л(?:ова)?)|книга[\s\xa0]*Саму[ії]лова)))|nd(?:[\s\xa0]*(?:Kingdoms|S(?:a(?:m(?:u[ae]l[ls]?)?)?|ma?))|\.[\s\xa0]*(?:Kingdoms|S(?:a(?:m(?:u[ae]l[ls]?)?)?|ma?)))|d(?:\.[\s\xa0]*Samuel|e(?:\.[\s\xa0]*Samuel|[\s\xa0]*Samuel)|[\s\xa0]*Samuel)|(?:[яе](?:\.[\s\xa0]*(?:Самуила|Царств|Книга[\s\xa0]*Царств)|[\s\xa0]*(?:Самуила|Царств|Книга[\s\xa0]*Царств)))|(?:[oa](?:\.[\s\xa0]*(?:Reinos|Samuel)|[\s\xa0]*(?:Reinos|Samuel)))|\.(?:[\s\xa0]*(?:K(?:s(?:[\s\xa0]*Samuel(?:owa|a)|i(?:[eę]g(?:[ai][\s\xa0]*Samuel(?:owa|a)))|\.[\s\xa0]*Samuel(?:owa|a))|ongerigernes[\s\xa0]*Bog|ingdoms)|S(?:ám(?:uel)?|hamooael|ma?|a(?:m(?:y[eè]l|u(?:al[ls]?|[iëï]l|u['’]eel|el(?:s(?:bo(?:g|k(?:en)?))?|i(?:n[\s\xa0]*kirja|[st])?|o[vw]a|[el])?)|weli)?|-?mu-?ên))?|Re(?:inos|g(?:ilor|norum))|Цар(?:е|ства?)|سموئیل|ซ(?:มอ|ามูเอล)|श(?:ामुएल|मू(?:एल(?:को)?)?)|к(?:раљевима|нига[\s\xa0]*Сам(?:у[ії]лова|оилова))|kniha[\s\xa0]*Samuelova|Саму(?:ил(?:а|ова)?|(?:[ії]л(?:ова)?))|šam[uū]elko|Книга[\s\xa0]*(?:на[\s\xa0]*царете|Царств)|ଶାମୁୟେଲଙ?)|-?سموئیل|(?:[oº](?:\.[\s\xa0]*Samuel|[\s\xa0]*Samuel))|۔سموایل)|e(?:me(?:\.[\s\xa0]*Samuel|[\s\xa0]*Samuel)|[\s\xa0]*Sam(?:u[eë]l)?|\.[\s\xa0]*Sam(?:u[eë]l)?)|사무|°(?:\.[\s\xa0]*Samuele|[\s\xa0]*Samuele)|º(?:\.[\s\xa0]*Samuel|[\s\xa0]*Samuel)|۔سموایل|[\s\xa0]*(?:K(?:s(?:[\s\xa0]*Samuel(?:owa|a)|i(?:[eę]g(?:[ai][\s\xa0]*Samuel(?:owa|a)))|\.[\s\xa0]*Samuel(?:owa|a))|ongerigernes[\s\xa0]*Bog|ingdoms)|श(?:ामुएल|म(?:ू(?:एल(?:को)?)?|ुवेल))|S(?:ám(?:uel)?|hamooael|ma?|a(?:m(?:y[eè]l|u(?:al[ls]?|[iëï]l|u['’]eel|el(?:s(?:bo(?:g|k(?:en)?))?|i(?:n[\s\xa0]*kirja|[st])?|o[vw]a|[el])?)|weli)?|-?mu-?ên))?|Re(?:inos|g(?:ilor|norum))|k(?:\.[\s\xa0]*Samuelova|niha[\s\xa0]*Samuelova|[\s\xa0]*Samuelova)|Ц(?:ар(?:е|ства?)?)?|சாமு(?:வேல்)?|سموئیل|ซ(?:มอ|ามูเอล)|அரசுகள்|ਸਮੂਏਲ|(?:[ei](?:[\s\xa0]*Samuelit|\.[\s\xa0]*Samuelit))|к(?:раљевима|нига[\s\xa0]*Сам(?:у[ії]лова|оилова))|Сам(?:у(?:ил(?:а|ова)?|(?:[ії]л(?:ова)?)))?|šam[uū]elko|ŝamuwel|صم(?:وئيل)?|C[aā]muv(?:[eē]l)|Книга[\s\xa0]*(?:на[\s\xa0]*царете|Царств)|ଶାମୁୟେଲଙ?)|ème(?:\.[\s\xa0]*Samuel|[\s\xa0]*Samuel)|Sam)|سفر[\s\xa0]*صموئيل[\s\xa0]*الثاني|Liber[\s\xa0]*II[\s\xa0]*Samuelis|शम(?:ुऐयल[\s\xa0]*की[\s\xa0]*[2२]री[\s\xa0]*पुस्तक|ूएलको[\s\xa0]*दोस्रो[\s\xa0]*पुस्तक)|சாமுவேலின்[\s\xa0]*இரண்டாம்[\s\xa0]*புத்தகம்|दुसरे[\s\xa0]*शमुवेल|列王記第二巻|دوم(?:[\s\xa0\-?]*سموئیل|۔سموایل)|Cartea[\s\xa0]*(?:II[\s\xa0]*a[\s\xa0]*(?:lui[\s\xa0]*Samuel|Regilor)|a[\s\xa0]*doua[\s\xa0]*a[\s\xa0]*Regilor)|사무엘(?:기(?:[\s\xa0]*하권|하)|[\s\xa0]*하|하)|《撒(?:慕爾紀下》|下》|母耳[記记]下》)|Kitabu[\s\xa0]*cha[\s\xa0]*Pili[\s\xa0]*cha[\s\xa0]*Samueli|ଦ୍ୱିତୀୟ[\s\xa0]*ଶାମୁୟେଲଙ?|الممالك[\s\xa0]*الثاني|Β(?:['ʹʹ΄’][\s\xa0]*Σαμ(?:ου(?:[ήη]λ)?)|ασιλει[ωώ]ν[\s\xa0]*Β['ʹʹ΄’])|Друг(?:а[\s\xa0]*(?:Samu[iï]l|Саму(?:(?:[ії]л(?:ова)?)|илова)|к(?:нига[\s\xa0]*Саму[ії]лова|раљевима))|е[\s\xa0]*(?:Samu[iï]l|Саму(?:[ії]л(?:ова)?)|книга[\s\xa0]*Саму[ії]лова))|שמואל[\s\xa0]*ב['’]|삼하|ଶାମୁୟେଲଙ୍କ[\s\xa0]*ଦ୍ୱିତୀୟ[\s\xa0]*ପୁସ୍ତକ|ਸਮੂਏਲ[\s\xa0]*ਦੀ[\s\xa0]*ਦੂਜੀ[\s\xa0]*ਪੋਥੀ|δυτικ[οό]ς[\s\xa0]*Σαμου(?:[ήη]λ[\s\xa0]*Β['ʹʹ΄’])|D(?:ru(?:h(?:(?:[yý][\s\xa0]*(?:S(?:am(?:uel(?:ova)?)?)?|kniha[\s\xa0]*Samuelova|list[\s\xa0]*Samuelova))|(?:[aá][\s\xa0]*(?:S(?:am(?:uel(?:ova)?)?)?|kniha[\s\xa0]*Samuelova)))|g(?:i[\s\xa0]*(?:Ks(?:[\s\xa0]*Samuel(?:owa|a)|i(?:[eę]g(?:[ai][\s\xa0]*Samuel(?:owa|a)))|\.[\s\xa0]*Samuel(?:owa|a))|Samuelowa)|a[\s\xa0]*(?:Samuelo(?:va[\s\xa0]*knjiga|wa)|Ks(?:[\s\xa0]*Samuel(?:owa|a)|i(?:[eę]g(?:[ai][\s\xa0]*Samuel(?:owa|a)))|\.[\s\xa0]*Samuel(?:owa|a))|knjiga[\s\xa0]*o[\s\xa0]*Samuelu)))|e(?:zy[eè]m[\s\xa0]*(?:liv[\s\xa0]*Samy(?:[eè]l[\s\xa0]*la|Samy[eè]l))|uxi(?:[eè]me(?:s[\s\xa0]*Samuel|[\s\xa0]*Samuel))))|S(?:[ií]ðari[\s\xa0]*Sam(?:[uú]elsb(?:[oó]k))|ámuel[\s\xa0]*II|am(?:eela[\s\xa0]*Maxaafaa[\s\xa0]*Naa77anttuwaa|u(?:u['’]eel[\s\xa0]*Labaad|el(?:i(?:s[\s\xa0]*II|[\s\xa0]*II)|[\s\xa0]*II)))|e(?:cond(?:[\s\xa0]*(?:Kingdoms|S(?:a(?:m(?:u[ae]l[ls]?)?)?|ma?))|[ao][\s\xa0]*Samuele)|gund(?:[ao][\s\xa0]*(?:Reinos|Samuel))))|サムエル(?:記下|[\s\xa0]*2|後書|下)|Pili[\s\xa0]*Sam(?:[uw]eli)?|Zweite[\s\xa0]*Samuel|M(?:[aá]sodik[\s\xa0]*S(?:[aá]m(?:uel)?))|samūel[\s\xa0]*dī[\s\xa0]*dūjī[\s\xa0]*potʰī|۲(?:[\s\xa0\-?]*سموئیل|۔سموایل)|T(?:weede[\s\xa0]*Sam(?:u[eë]l)?|oinen[\s\xa0]*Samuelin[\s\xa0]*kirja)|And(?:en[\s\xa0]*(?:Sam(?:uel(?:sbog)?)?|Kongerigernes[\s\xa0]*Bog)|r(?:e[\s\xa0]*Sam(?:uel(?:sbok)?)?|a[\s\xa0]*Samuelsboken))|صموئيل[\s\xa0]*الثّاني)|(?:Β['ʹʹ΄’][\s\xa0]*Σαμ|Dezy[eè]m[\s\xa0]*Samy(?:[eè]l))|(?:撒(?:慕爾紀下》?|下》?|母耳[记記]下》?)|《撒(?:慕爾紀下|母耳[记記]下|下)|שמואל[\s\xa0]*ב|Druga[\s\xa0]*Samuelova|صموئيل[\s\xa0]*الثاني|Toinen[\s\xa0]*Samuelin|II(?:\.[\s\xa0]*Sa(?:muelin)?|[\s\xa0]*Sa(?:mueli[ns])?)|2(?:[\s\xa0]*Sa(?:muelin)?|\.[\s\xa0]*Sa(?:muelin)?)))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["1Sam"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])((?:Samueli(?:[\s\xa0]*I|s[\s\xa0]*I)|1(?:[\s\xa0]*sam(?:ū(?:ʾīl|el(?:ko)?)|u(?:elko|wel))|\.[\s\xa0]*sam[uū]elko|st(?:[\s\xa0]*(?:Kingdoms|S(?:a(?:m(?:u[ae]l[ls]?)?)?|ma?))|\.[\s\xa0]*(?:Kingdoms|S(?:a(?:m(?:u[ae]l[ls]?)?)?|ma?)))))|(?:P(?:r(?:v(?:á[\s\xa0]*(?:Samuelova|kniha[\s\xa0]*Samuelova)|n(?:[ií][\s\xa0]*(?:S(?:am(?:uel(?:ova)?)?)?|kniha[\s\xa0]*Samuelova))|a[\s\xa0]*(?:Samuelova[\s\xa0]*knjiga|kn(?:iha[\s\xa0]*Samuelova|jiga[\s\xa0]*o[\s\xa0]*Samuelu))|(?:[yý][\s\xa0]*(?:Samuelova|list[\s\xa0]*Samuelova)))|em(?:ye[\s\xa0]*(?:liv[\s\xa0]*Samy[eè]l[\s\xa0]*la|Samy[eè]l)|i(?:er(?:s[\s\xa0]*Samuel|[\s\xa0]*Samuel|e(?:s[\s\xa0]*Samuel|[\s\xa0]*Samuel))|ère(?:s[\s\xa0]*Samuel|[\s\xa0]*Samuel)))|im(?:e(?:r(?:o[\s\xa0]*Samuel|[\s\xa0]*Samuel)|ir(?:[ao][\s\xa0]*(?:Reinos|Samuel)))|[ao][\s\xa0]*Samuele))|ierwsz(?:[aey][\s\xa0]*(?:Ks(?:[\s\xa0]*Samuel(?:owa|a)|i(?:[eę]g(?:[ai][\s\xa0]*Samuel(?:owa|a)))|\.[\s\xa0]*Samuel(?:owa|a))|Samuelowa)))|சாமுவேலின்[\s\xa0]*முதலாம்[\s\xa0]*புத்தகம்|사무엘(?:기(?:[\s\xa0]*상권|상)|상|[\s\xa0]*상)|K(?:itabu[\s\xa0]*cha[\s\xa0]*Kwanza[\s\xa0]*cha[\s\xa0]*Samueli|wanza[\s\xa0]*Sam(?:[uw]eli)?)|سفر[\s\xa0]*صموئيل[\s\xa0]*الأول|שמואל[\s\xa0]*א['’]|E(?:erste[\s\xa0]*Sam(?:u[eë]l)?|ls(?:[oő][\s\xa0]*S(?:[aá]m(?:uel)?))|rste[\s\xa0]*Samuel|nsimm[aä]inen[\s\xa0]*Samuelin[\s\xa0]*kirja)|I(?:[\s\xa0]*(?:Саму(?:[иії]л(?:ова)?)|K(?:s(?:[\s\xa0]*Samuel(?:owa|a)|i(?:[eę]g(?:[ai][\s\xa0]*Samuel(?:owa|a)))|\.[\s\xa0]*Samuel(?:owa|a))|ingdoms)|Re(?:inos|g(?:ilor|norum))|Цар(?:е|ства)|к(?:раљевима|нига[\s\xa0]*Сам(?:у[ії]лова|оилова))|S(?:ám(?:uel)?|a(?:-?mu-?ên|m(?:y[eè]l|weli|u(?:el(?:i(?:n[\s\xa0]*kirja)?|o[vw]a|[els])?|al[ls]?|[iëï]l|u['’]eel))?)|ma?)?|kniha[\s\xa0]*Samuelova|Книга[\s\xa0]*на[\s\xa0]*царете)|\.[\s\xa0]*(?:Саму(?:[иії]л(?:ова)?)|K(?:s(?:[\s\xa0]*Samuel(?:owa|a)|i(?:[eę]g(?:[ai][\s\xa0]*Samuel(?:owa|a)))|\.[\s\xa0]*Samuel(?:owa|a))|ingdoms)|Re(?:inos|g(?:ilor|norum))|Цар(?:е|ства)|к(?:раљевима|нига[\s\xa0]*Сам(?:у[ії]лова|оилова))|kniha[\s\xa0]*Samuelova|S(?:a(?:-?mu-?ên|m(?:y[eè]l|u(?:al[ls]?|[iëï]l|el(?:o[vw]a|i(?:n[\s\xa0]*kirja|s)?|[els])?|u['’]eel)|weli)?)|ám(?:uel)?|ma?)?|Книга[\s\xa0]*на[\s\xa0]*царете))|F(?:yrri[\s\xa0]*Sam[uú]elsb(?:[oó]k)|irst[\s\xa0]*(?:Kingdoms|S(?:a(?:m(?:u[ae]l[ls]?)?)?|ma?))|[oö]rsta[\s\xa0]*Samuelsboken|ørste[\s\xa0]*(?:Kongerigernes[\s\xa0]*Bog|Sam(?:uel(?:s(?:bo[gk])?)?)?))|sam(?:uelko[\s\xa0]*pustak|ūel(?:[\s\xa0]*dī[\s\xa0]*pahilī[\s\xa0]*potʰī|ko[\s\xa0]*pustak))|Βασιλει[ωώ]ν[\s\xa0]*Α['ʹʹ΄’]|Una(?:ng[\s\xa0]*Samuel|[\s\xa0]*Samuel)|शम(?:ूएलको[\s\xa0]*पहिलो[\s\xa0]*पुस्तक|ुऐल[\s\xa0]*की[\s\xa0]*[1१]ली[\s\xa0]*पुस्तक)|П(?:рв(?:а[\s\xa0]*(?:к(?:нига[\s\xa0]*Самоилова|раљевима)|Самуил(?:ова)?)|о[\s\xa0]*(?:Самуил|книга[\s\xa0]*Самоилова))|ърва[\s\xa0]*(?:Самуил|книга[\s\xa0]*(?:Царства|на[\s\xa0]*Самуил)|Цар(?:е|ства)|Книга[\s\xa0]*на[\s\xa0]*царете)|ерш[ае][\s\xa0]*(?:Samu(?:[iï]l|Саму(?:[ії]л(?:ова)?)|книга[\s\xa0]*Саму[ії]лова)))|šam[uū]elko[\s\xa0]*pustak|ا(?:وّل(?:-?سموئیل|[\s\xa0]*سموئ[يی]ل|۔سموایل)|لممالك[\s\xa0]*الأول)|1(?:\.(?:-?سموئیل|[\s\xa0]*(?:K(?:s(?:[\s\xa0]*Samuel(?:owa|a)|i(?:[eę]g(?:[ai][\s\xa0]*Samuel(?:owa|a)))|\.[\s\xa0]*Samuel(?:owa|a))|ongerigernes[\s\xa0]*Bog|ingdoms)|سموئ[يی]ل|S(?:ám(?:uel)?|hamooael|ma?|a(?:m(?:y[eè]l|u(?:al[ls]?|[iëï]l|u['’]eel|el(?:s(?:bo(?:g|k(?:en)?))?|i(?:n[\s\xa0]*kirja|[st])?|o[vw]a|[el])?)|weli)?|-?mu-?ên))?|Re(?:inos|g(?:ilor|norum))|Цар(?:е|ства?)|ซ(?:มอ|ามูเอล)|श(?:ामुएल|मू(?:एल(?:को)?)?)|к(?:раљевима|нига[\s\xa0]*Сам(?:у[ії]лова|оилова))|kniha[\s\xa0]*Samuelova|Саму(?:ил(?:а|ова)?|(?:[ії]л(?:ова)?))|šam[uū]elko|Книга[\s\xa0]*(?:на[\s\xa0]*царете|Царств)|ଶାମୁୟେଲଙ?)|(?:[oº](?:\.[\s\xa0]*Samuel|[\s\xa0]*Samuel))|۔سموایل)|(?:[яе](?:\.[\s\xa0]*(?:Самуила|Царств|Книга[\s\xa0]*Царств)|[\s\xa0]*(?:Самуила|Царств|Книга[\s\xa0]*Царств)))|(?:[oa](?:\.[\s\xa0]*(?:Reinos|Samuel)|[\s\xa0]*(?:Reinos|Samuel)))|re(?:\.[\s\xa0]*Samuel|[\s\xa0]*Samuel)|사무|°(?:\.[\s\xa0]*Samuele|[\s\xa0]*Samuele)|º(?:\.[\s\xa0]*Samuel|[\s\xa0]*Samuel)|۔سموایل|[\s\xa0]*(?:K(?:s(?:[\s\xa0]*Samuel(?:owa|a)|i(?:[eę]g(?:[ai][\s\xa0]*Samuel(?:owa|a)))|\.[\s\xa0]*Samuel(?:owa|a))|ongerigernes[\s\xa0]*Bog|ingdoms)|श(?:ामुएल|म(?:ू(?:एल(?:को)?)?|ुवेल))|سموئ[يی]ل|S(?:ám(?:uel)?|hamooael|ma?|a(?:m(?:y[eè]l|u(?:al[ls]?|[iëï]l|u['’]eel|el(?:s(?:bo(?:g|k(?:en)?))?|i(?:n[\s\xa0]*kirja|[st])?|o[vw]a|[el])?)|weli)?|-?mu-?ên))?|Re(?:inos|g(?:ilor|norum))|k(?:\.[\s\xa0]*Samuelova|niha[\s\xa0]*Samuelova|[\s\xa0]*Samuelova)|Ц(?:ар(?:е|ства?)?)?|சாமு(?:வேல்)?|ซ(?:มอ|ามูเอล)|அரசுகள்|ਸਮੂਏਲ|(?:[ei](?:[\s\xa0]*Samuelit|\.[\s\xa0]*Samuelit))|к(?:раљевима|нига[\s\xa0]*Сам(?:у[ії]лова|оилова))|Сам(?:у(?:ил(?:а|ова)?|(?:[ії]л(?:ова)?)))?|šam[uū]elko|ŝamuwel|صم(?:وئيل)?|C[aā]muv(?:[eē]l)|Книга[\s\xa0]*(?:на[\s\xa0]*царете|Царств)|ଶାମୁୟେଲଙ?)|Sam|-?(?:е(?:[\s\xa0]*(?:Samu[iï]l|Царств|книга[\s\xa0]*Саму[ії]лова|Саму(?:ила|(?:[ії]л(?:ова)?))|Книга[\s\xa0]*Царств)|\.[\s\xa0]*(?:Samu[iï]l|Царств|книга[\s\xa0]*Саму[ії]лова|Саму(?:ила|(?:[ії]л(?:ова)?))|Книга[\s\xa0]*Царств))|я(?:\.[\s\xa0]*(?:Самуила|Царств|Книга[\s\xa0]*Царств)|[\s\xa0]*(?:Самуила|Царств|Книга[\s\xa0]*Царств))|سموئیل|а(?:[\s\xa0]*(?:Samu[iï]l|Саму(?:[ії]л(?:ова)?)|книга[\s\xa0]*Саму[ії]лова)|\.[\s\xa0]*(?:Samu[iï]l|Саму(?:[ії]л(?:ова)?)|книга[\s\xa0]*Саму[ії]лова))|ше(?:[\s\xa0]*(?:Samu[iï]l|Саму(?:[ії]л(?:ова)?)|книга[\s\xa0]*Саму[ії]лова)|\.[\s\xa0]*(?:Samu[iï]l|Саму(?:[ії]л(?:ова)?)|книга[\s\xa0]*Саму[ії]лова)))|ère(?:\.[\s\xa0]*Samuel|[\s\xa0]*Samuel)|e(?:r(?:\.[\s\xa0]*Samuel|e(?:\.[\s\xa0]*Samuel|[\s\xa0]*Samuel)|[\s\xa0]*Samuel)|[\s\xa0]*Sam(?:u[eë]l)?|\.[\s\xa0]*Sam(?:u[eë]l)?))|《撒(?:慕爾紀上》|上》|母耳[記记]上》)|S(?:ámuel[\s\xa0]*I|am(?:u(?:u['’]eel[\s\xa0]*Kowaad|el[\s\xa0]*I)|eela[\s\xa0]*Maxaafaa[\s\xa0]*Koiruwaa))|Liber[\s\xa0]*I[\s\xa0]*Samuelis|Α['ʹʹ΄’][\s\xa0]*Σαμ(?:ου(?:[ήη]λ)?)|サムエル(?:記上|[\s\xa0]*1|前書|上)|ਸਮੂਏਲ[\s\xa0]*ਦੀ[\s\xa0]*ਪਹਿਲੀ[\s\xa0]*ਪੋਥੀ|ଶାମୁୟେଲଙ୍କ[\s\xa0]*ପ୍ରଥମ[\s\xa0]*ପୁସ୍ତକ|पहिले[\s\xa0]*शमुवेल|δυτικ[οό]ς[\s\xa0]*Σαμου(?:[ήη]λ[\s\xa0]*Α['ʹʹ΄’])|Cartea[\s\xa0]*(?:[iî]nt(?:[aâ]i[\s\xa0]*a[\s\xa0]*Regilor)|I[\s\xa0]*a[\s\xa0]*(?:lui[\s\xa0]*Samuel|Regilor))|삼상|列王記第一巻|ପ୍ରଥମ[\s\xa0]*ଶାମୁୟେଲଙ?|۱(?:-?سموئیل|[\s\xa0]*سموئ[يی]ل|۔سموایل)|ﺻﻤﻮﺋﻴﻞ[\s\xa0]*ﺍﻷﻭﻝ)|(?:Α['ʹʹ΄’][\s\xa0]*Σαμ|Перш(?:[ае][\s\xa0]*(?:Саму(?:[ії]л(?:ова)?)|книга[\s\xa0]*Саму[ії]лова)))|(?:撒(?:母耳[记記]上》?|上》?|慕爾紀上》?)|《撒(?:慕爾紀上|上|母耳[記记]上)|صموئيل[\s\xa0]*الأول|I(?:\.[\s\xa0]*Sa(?:muelin)?|[\s\xa0]*Sa(?:mueli[ns])?)|שמואל[\s\xa0]*א|Prva[\s\xa0]*Samuelova|Ensimm[aä]inen[\s\xa0]*Samuelin|Samu[ae]l[sl]?|1(?:[\s\xa0]*Sa(?:muelin)?|\.[\s\xa0]*Sa(?:muelin)?)))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["2Chr"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])(2[\s\xa0]*хрон(?:ика|іки)|2[\s\xa0]*Хрон(?:іка?|ик)|2\.[\s\xa0]*хрон(?:ика|іки)|(?:itahās[\s\xa0]*dī[\s\xa0]*dūjī[\s\xa0]*potʰī|Παραλειπομ[έε]νων[\s\xa0]*Β['ʹʹ΄’]|2(?:d(?:\.[\s\xa0]*Chroniques|e(?:\.[\s\xa0]*Chroniques|[\s\xa0]*Chroniques)|[\s\xa0]*Chroniques)|۔تواریخ|[\s\xa0]*(?:K(?:s(?:\.[\s\xa0]*Kronik|[\s\xa0]*Kronik|i[eę]g(?:[ai][\s\xa0]*Kronik))|r(?:ón(?:ika)?|ø(?:n(?:ikebo[gk])?)?|o(?:n(?:ík|i(?:eken|c(?:a|k[aá])|k(?:e(?:l|boken)|a(?:ve)?)?))?)?|ön(?:ikeboken)?|n)|wonik)|इति(?:हास(?:को)?)?|Дн(?:евника)?|tavārīḫ|Taar(?:iikhdii)?|Пар(?:алипоменону?)?|تو[\s\xa0]*اریخ|[\s\xa0]*Sử[\s\xa0]*Ký|книга[\s\xa0]*(?:летописи|хроніки?)|M(?:ga[\s\xa0]*[CK]roni(?:[ck]a)|ambo[\s\xa0]*ya[\s\xa0]*Nyakati)|أخ|Л(?:ітопису|ет(?:опис[иь])?)|Ȟroniky|i(?:[\s\xa0]*Kronika(?:ve)?|t(?:ih(?:ās(?:ko)?|asko)|ahās)|\.[\s\xa0]*Kronika(?:ve)?)|H(?:anO|roniky)|ବଂଶାବଳୀର?|k(?:niha[\s\xa0]*kronik|[\s\xa0]*(?:Kron(?:ík|i(?:ck[aá]|k))|Paralipomenon)|\.[\s\xa0]*(?:Kron(?:ík|i(?:ck[aá]|k))|Paralipomenon))|Sử[\s\xa0]*(?:biên[\s\xa0]*niên|ký)|e(?:[\s\xa0]*Kronika(?:ve)?|\.[\s\xa0]*Kronika(?:ve)?)|Babad|Pa(?:r(?:alipomen(?:on?|a))?)?|Aik(?:ak(?:irja)?)?|хрон|Хр|I(?:tihas|st(?:wa)?)|குறி(?:ப்பேடு)?|L(?:etopis[uů]|ịch[\s\xa0]*sử|jet(?:opisa)?)|C(?:h(?:r(?:n|o(?:n(?:ocles?|i(?:c(?:les?|als)|k|ques))?)?)?|oron[io]cles?)?|r(?:(?:[óô](?:n(?:icas)?)?)|o(?:n(?:ocles?|ache|i(?:c(?:i(?:lor)?|as?|l(?:es?)?)|ka))?)?)?|oron[io]cles?)|Книга[\s\xa0]*на[\s\xa0]*летописите|நாளா(?:கமம்)?|พ(?:ศด|งศาวดาร)|N(?:ya|[aā](?:[lḷ](?:[aā]kamam)))|ਇਤਹਾਸ)|ème(?:\.[\s\xa0]*Chroniques|[\s\xa0]*Chroniques)|º(?:\.[\s\xa0]*Cr[oó]nicas|[\s\xa0]*Cr[oó]nicas)|a(?:\.[\s\xa0]*Cr[oô]nicas|[\s\xa0]*Cr[oô]nicas)|nd(?:\.[\s\xa0]*(?:C(?:ron(?:[io]cles?)?|h(?:r(?:o(?:n(?:ocles?|ic(?:les?|als))?)?|n)?|oron[io]cles?)|oron[io]cles?)|Paralipomenon)|[\s\xa0]*(?:C(?:ron(?:[io]cles?)?|h(?:r(?:o(?:n(?:ocles?|ic(?:les?|als))?)?|n)?|oron[io]cles?)|oron[io]cles?)|Paralipomenon))|-?(?:[\s\xa0]*توارِیخ|е(?:[\s\xa0]*(?:хроніки|книга[\s\xa0]*хроніки?|[HȞ]roniky|Хрон(?:іка?|ик)|Л(?:етопись|ітопису)|Паралипоменон)|\.[\s\xa0]*(?:хроніки|книга[\s\xa0]*хроніки?|[HȞ]roniky|Хрон(?:іка?|ик)|Л(?:етопись|ітопису)|Паралипоменон))|а(?:[\s\xa0]*(?:хроніки|книга[\s\xa0]*хроніки?|Літопису|[HȞ]roniky|Хроніка?)|\.[\s\xa0]*(?:хроніки|книга[\s\xa0]*хроніки?|Літопису|[HȞ]roniky|Хроніка?))|я(?:[\s\xa0]*(?:Летопись|Паралипоменон|Хроник)|\.[\s\xa0]*(?:Летопись|Паралипоменон|Хроник))|ге(?:[\s\xa0]*(?:хроніки|книга[\s\xa0]*хроніки?|Літопису|[HȞ]roniky|Хроніка?)|\.[\s\xa0]*(?:хроніки|книга[\s\xa0]*хроніки?|Літопису|[HȞ]roniky|Хроніка?)))|Chr|o(?:[\s\xa0]*Cr[oóô]nicas|\.[\s\xa0]*Cr[oóô]nicas)|°(?:\.[\s\xa0]*Cronache|[\s\xa0]*Cronache)|\.(?:-?[\s\xa0]*توارِیخ|۔تواریخ|[\s\xa0]*(?:इति(?:हास(?:को)?)?|Taar(?:iikhdii)?|дневника|kniha[\s\xa0]*kronik|تو[\s\xa0]*اریخ|[\s\xa0]*Sử[\s\xa0]*Ký|Паралипоменону?|книга[\s\xa0]*(?:летописи|хроніки?)|M(?:ga[\s\xa0]*[CK]roni(?:[ck]a)|ambo[\s\xa0]*ya[\s\xa0]*Nyakati)|Aikakirja|Л(?:ітопису|ет(?:опис[иь])?)|[ȞH]roniky|Хрон(?:іка?|ик)|K(?:r(?:ón(?:ika)?|ø(?:n(?:ikebo[gk])?)?|o(?:n(?:ík|i(?:eken|c(?:a|k[aá])|k(?:e(?:l|boken)|a(?:ve)?)?))?)?|önikeboken)|s(?:\.[\s\xa0]*Kronik|[\s\xa0]*Kronik|i[eę]g(?:[ai][\s\xa0]*Kronik))|wonik)|ବଂଶାବଳୀର?|Sử[\s\xa0]*(?:biên[\s\xa0]*niên|ký)|Babad|Pa(?:r(?:alipomen(?:on?|a))?)?|Nya|itih[aā]sko|I(?:tihas|stwa)|L(?:etopis[uů]|ịch[\s\xa0]*sử|jetopisa)|Книга[\s\xa0]*на[\s\xa0]*летописите|C(?:h(?:r(?:n|o(?:n(?:ocles?|i(?:c(?:les?|als)|k|ques))?)?)?|oron[io]cles?)|r(?:[óô]nicas|on(?:ocles?|ache|i(?:c(?:i(?:lor)?|as?|l(?:es?)?)|ka))?)|oron[io]cles?)|พ(?:ศด|งศาวดาร))|[oº](?:\.[\s\xa0]*Cr(?:[oó]nicas|[\s\xa0]*Cr[oó]nicas)))|(?:[ея](?:[\s\xa0]*(?:Летопись|Паралипоменон|Хроник)|\.[\s\xa0]*(?:Летопись|Паралипоменон|Хроник)))|e(?:me(?:\.[\s\xa0]*Chroniques|[\s\xa0]*Chroniques)|[\s\xa0]*(?:Kron(?:ieken)?|Chroniques)|\.[\s\xa0]*(?:Kron(?:ieken)?|Chroniques))|역대)|ବଂଶାବଳୀର[\s\xa0]*ଦ୍ୱିତୀୟ[\s\xa0]*ପୁସ୍ତକ|δυτικ[οό]ς[\s\xa0]*Χρονικ(?:[ωώ]ν[\s\xa0]*Β['ʹʹ΄’])|Друг(?:а[\s\xa0]*(?:дневника|книга[\s\xa0]*хроніки?|Літопису|[HȞ]roniky|хрон(?:ика|іки)|Хроніка?|Паралипоменону)|е[\s\xa0]*(?:хроніки|книга[\s\xa0]*хроніки?|Літопису|[HȞ]roniky|Хроніка?))|ਇਤਹਾਸ[\s\xa0]*ਦੀ[\s\xa0]*ਦੂਜੀ[\s\xa0]*ਪੋਥੀ|दुसरे[\s\xa0]*इतिहास|歴(?:下|代(?:史下|志(?:略下|下)|誌(?:[\s\xa0]*2|下)))|Liber[\s\xa0]*II[\s\xa0]*Paralipomenon|Втор(?:а[\s\xa0]*(?:Лет(?:описи)?|Книга[\s\xa0]*на[\s\xa0]*летописите|книга[\s\xa0]*летописи)|о[\s\xa0]*(?:Летописи|книга[\s\xa0]*летописи))|Β(?:['ʹʹ΄’][\s\xa0]*(?:Παρ?|Χρ(?:ον(?:ικ[ωώ]ν)?)?))|And(?:en[\s\xa0]*Kr(?:on|øn(?:ikebog)?)|r(?:e[\s\xa0]*Krø(?:n(?:ikebok)?)?|a[\s\xa0]*Kr[oö]nikeboken))|دوم(?:[\s\xa0]*تو[\s\xa0]*اریخ|-?[\s\xa0]*توارِیخ|۔تواریخ)|۲(?:[\s\xa0]*تو[\s\xa0]*اریخ|-?[\s\xa0]*توارِیخ|۔تواریخ)|T(?:aariikhdii[\s\xa0]*Labaad|weede[\s\xa0]*Kron(?:ieken)?|oinen[\s\xa0]*Aikakirja)|ﺃﺧﺒﺎﺭ[\s\xa0]*ﺍﻷﻳﺎﻡ[\s\xa0]*ﺍﻟﺜﺎﻥ|I(?:I(?:[\s\xa0]*(?:Taar(?:iikhdii)?|дневника|kniha[\s\xa0]*kronik|[\s\xa0]*Sử[\s\xa0]*Ký|C(?:r(?:on(?:ic(?:i(?:lor)?|as?|l(?:es?)?)|ocles?|ache)?|[óô]nicas)|h(?:r(?:o(?:n(?:ocles?|i(?:c(?:les?|als)|ques))?)?|n)?|oron[io]cles?)|oron[io]cles?)|книга[\s\xa0]*(?:летописи|хроніки?)|Aikakirja|[ȞH]roniky|Л(?:ітопису|ет(?:описи)?)|хрон(?:ика|іки)|Sử[\s\xa0]*(?:biên[\s\xa0]*niên|ký)|Babad|Nya|Хроніка?|Istwa|L(?:etopis[uů]|ịch[\s\xa0]*sử|jetopisa)|Книга[\s\xa0]*на[\s\xa0]*летописите|Pa(?:r(?:alipomen[ao])?)?|K(?:r(?:ón(?:ika)?|o(?:n(?:ík|i(?:ck[aá]|eken|k(?:el|a)?))?)?)|s(?:\.[\s\xa0]*Kronik|[\s\xa0]*Kronik|i[eę]g(?:[ai][\s\xa0]*Kronik))|wonik)|Паралипоменону|M(?:ga[\s\xa0]*(?:Kronika|Cronica)|ambo[\s\xa0]*ya[\s\xa0]*Nyakati))|\.[\s\xa0]*(?:Taar(?:iikhdii)?|дневника|kniha[\s\xa0]*kronik|[\s\xa0]*Sử[\s\xa0]*Ký|C(?:r(?:on(?:ic(?:i(?:lor)?|as?|l(?:es?)?)|ocles?|ache)?|[óô]nicas)|h(?:r(?:o(?:n(?:ocles?|i(?:c(?:les?|als)|ques))?)?|n)?|oron[io]cles?)|oron[io]cles?)|книга[\s\xa0]*(?:летописи|хроніки?)|Aikakirja|[ȞH]roniky|Л(?:ітопису|ет(?:описи)?)|хрон(?:ика|іки)|Sử[\s\xa0]*(?:biên[\s\xa0]*niên|ký)|Babad|Pa(?:r(?:alipomen(?:on?|a))?)?|Nya|Хроніка?|Istwa|L(?:etopis[uů]|ịch[\s\xa0]*sử|jetopisa)|Книга[\s\xa0]*на[\s\xa0]*летописите|K(?:r(?:ón(?:ika)?|o(?:n(?:ík|i(?:ck[aá]|eken|k(?:el|a)?))?)?)|s(?:\.[\s\xa0]*Kronik|[\s\xa0]*Kronik|i[eę]g(?:[ai][\s\xa0]*Kronik))|wonik)|Паралипоменону|M(?:ga[\s\xa0]*(?:Kronika|Cronica)|ambo[\s\xa0]*ya[\s\xa0]*Nyakati)))|kalawang[\s\xa0]*(?:C(?:ronica|hronicle)|Paralipomeno|Mga[\s\xa0]*(?:Kronika|Cronica)|Kronik(?:el|a)))|《(?:代下》|[历歷]代志下》|編年紀下》)|S(?:[ií]ðari[\s\xa0]*Kron(?:[ií]kub(?:[oó]k))|e(?:gund(?:a[\s\xa0]*Cr[oô]nicas|o[\s\xa0]*Cr[oóô]nicas)|cond(?:[ao][\s\xa0]*Cronache|[\s\xa0]*(?:C(?:ron(?:[io]cles?)?|h(?:r(?:o(?:n(?:ocles?|ic(?:les?|als))?)?|n)?|oron[io]cles?)|oron[io]cles?)|Paralipomenon))))|대하|நாளாகமத்தின்[\s\xa0]*இரண்டாம்[\s\xa0]*புத்தகம்|Hanidabaa[\s\xa0]*Odiya[\s\xa0]*Naa77antto[\s\xa0]*Maxaafaa|Zweite[\s\xa0]*Chronik|سفر[\s\xa0]*أخبار[\s\xa0]*الأيام[\s\xa0]*الثاني|P(?:ili[\s\xa0]*(?:Mambo[\s\xa0]*ya[\s\xa0]*Nyakati|Nya)|aralipomenon[\s\xa0]*II)|ଦ୍ୱିତୀୟ[\s\xa0]*ବଂଶାବଳୀର?|الأخبار[\s\xa0]*2|역대(?:기[\s\xa0]*하권?|지하|하)|Cartea[\s\xa0]*a[\s\xa0]*doua[\s\xa0]*Paralipomena|M(?:a(?:mbo[\s\xa0]*ya[\s\xa0]*Nyakati[\s\xa0]*II|sodik[\s\xa0]*Kr(?:[oó]n(?:ika)?))|ásodik[\s\xa0]*Kr(?:[oó]n(?:ika)?))|דברי[\s\xa0]*הימים[\s\xa0]*ב['’]|D(?:ru(?:h(?:(?:[aá][\s\xa0]*(?:Kron(?:ík|i(?:ck[aá]|k))|kniha[\s\xa0]*(?:Kron(?:ík|i(?:ck[aá]|k))|Paralipomenon)|Pa(?:ralipomenon)?|Letopis[uů]))|(?:[yý][\s\xa0]*(?:kniha[\s\xa0]*kronik|Kron(?:ík|i(?:ck[aá]|k))|list[\s\xa0]*(?:Kron(?:ík|i(?:ck[aá]|k))|Paralipomenon)|Pa(?:ralipomenon)?|Letopis[uů])))|g(?:i[\s\xa0]*K(?:s(?:\.[\s\xa0]*Kronik|[\s\xa0]*Kronik|i[eę]g(?:[ai][\s\xa0]*Kronik))|ronik)|a[\s\xa0]*(?:knjiga[\s\xa0]*Ljetopisa|Ljetopisa|K(?:s(?:\.[\s\xa0]*Kronik|[\s\xa0]*Kronik|i[eę]g(?:[ai][\s\xa0]*Kronik))|ronik))))|e(?:zy(?:[eè]m[\s\xa0]*(?:liv[\s\xa0]*Kwonik[\s\xa0]*la|Kwonik|Istwa))|uxi(?:[eè]me(?:s[\s\xa0]*Chroniques|[\s\xa0]*Chroniques))))|Kr[oó]nik(?:[aá]k[\s\xa0]*II)|इतिहास(?:को[\s\xa0]*दोस्रो[\s\xa0]*पुस्तक|[\s\xa0]*[2२]रा[\s\xa0]*भाग)|или[\s\xa0]*Втора[\s\xa0]*книга[\s\xa0]*Паралипоменон)|2\.[oº][\s\xa0]*Cr(?:[oó]nicas)|(?:代下》?|2(?:\.[\s\xa0]*Sử|[\s\xa0]*(?:дневника|Sử|itihas))|Χρονικ[ώω]ν[\s\xa0]*Β[ʹʹ'΄’]|Síðari[\s\xa0]*kroníkubók|II(?:\.[\s\xa0]*Sử|[\s\xa0]*(?:Sử|Paralipomenon))|أخبار[\s\xa0]*الأيام[\s\xa0]*الثاني|[歷历]代志下》?|Druh[áa][\s\xa0]*kniha[\s\xa0]*kronik|《(?:代下|[歷历]代志下|編年紀下)|編年紀下》?|דברי[\s\xa0]*הימים[\s\xa0]*ב|Втора[\s\xa0]*книга[\s\xa0]*(?:на[\s\xa0]*летописите|Паралипоменон)))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["1Chr"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])(1[\s\xa0]*хрон(?:ика|іки)|1[\s\xa0]*Хрон(?:іка?|ик)|1\.[\s\xa0]*хрон(?:ика|іки)|(?:ପ୍ରଥମ[\s\xa0]*ବଂଶାବଳୀର?|ا(?:لأخبار[\s\xa0]*1|وّل(?:[\s\xa0۔]*تواریخ|-?توارِیخ))|Taariikhdii[\s\xa0]*Kowaad|Hanidabaa[\s\xa0]*Odiyaa[\s\xa0]*Koiro[\s\xa0]*Maxaafaa|C(?:horonicle|artea[\s\xa0]*[iî]nt(?:[aâ]i[\s\xa0]*Paralipomena))|1(?:۔تواریخ|re(?:\.[\s\xa0]*Chroniques|[\s\xa0]*Chroniques)|-?(?:توارِیخ|е(?:[\s\xa0]*(?:хроніки|книга[\s\xa0]*хроніки?|[HȞ]roniky|Хрон(?:іка?|ик)|Л(?:етопись|ітопису)|Паралипоменон)|\.[\s\xa0]*(?:хроніки|книга[\s\xa0]*хроніки?|[HȞ]roniky|Хрон(?:іка?|ик)|Л(?:етопись|ітопису)|Паралипоменон))|а(?:[\s\xa0]*(?:хроніки|книга[\s\xa0]*хроніки?|Літопису|[HȞ]roniky|Хроніка?)|\.[\s\xa0]*(?:хроніки|книга[\s\xa0]*хроніки?|Літопису|[HȞ]roniky|Хроніка?))|я(?:[\s\xa0]*(?:Летопись|Паралипоменон|Хроник)|\.[\s\xa0]*(?:Летопись|Паралипоменон|Хроник))|ше(?:[\s\xa0]*(?:хроніки|книга[\s\xa0]*хроніки?|Літопису|[HȞ]roniky|Хроніка?)|\.[\s\xa0]*(?:хроніки|книга[\s\xa0]*хроніки?|Літопису|[HȞ]roniky|Хроніка?)))|º(?:\.[\s\xa0]*Cr[oó]nicas|[\s\xa0]*Cr[oó]nicas)|a(?:\.[\s\xa0]*Cr[oô]nicas|[\s\xa0]*Cr[oô]nicas)|ère(?:\.[\s\xa0]*Chroniques|[\s\xa0]*Chroniques)|e(?:r(?:\.[\s\xa0]*Chroniques|e(?:\.[\s\xa0]*Chroniques|[\s\xa0]*Chroniques)|[\s\xa0]*Chroniques)|\.[\s\xa0]*Kron(?:ieken)?|[\s\xa0]*Kron(?:ieken)?)|Chr|o(?:[\s\xa0]*Cr[oóô]nicas|\.[\s\xa0]*Cr[oóô]nicas)|°(?:\.[\s\xa0]*Cronache|[\s\xa0]*Cronache)|(?:[ея](?:[\s\xa0]*(?:Летопись|Паралипоменон|Хроник)|\.[\s\xa0]*(?:Летопись|Паралипоменон|Хроник)))|\.(?:۔تواریخ|-?توارِیخ|[oº](?:\.[\s\xa0]*Cr(?:[oó]nicas|[\s\xa0]*Cr[oó]nicas))|[\s\xa0]*(?:इति(?:हास(?:को)?)?|Taar(?:iikhdii)?|дневника|kniha[\s\xa0]*kronik|تواریخ|Паралипоменону?|книга[\s\xa0]*(?:летописи|хроніки?)|M(?:ga[\s\xa0]*[CK]roni(?:[ck]a)|ambo[\s\xa0]*ya[\s\xa0]*Nyakati)|Aikakirja|Л(?:ітопису|ет(?:опис[иь])?)|[ȞH]roniky|Хрон(?:іка?|ик)|C(?:h(?:oron(?:ocles?|icles)|r(?:n|o(?:n(?:ocles?|i(?:c(?:les?|als)|k|ques))?)?)?)|r(?:[óô]nicas|on(?:ocles?|ache|i(?:c(?:i(?:lor)?|as?|l(?:es?)?)|ka))?)|oron[io]cles?)|K(?:r(?:ón(?:ika)?|ø(?:n(?:ikebo[gk])?)?|o(?:n(?:ík|i(?:eken|c(?:a|k[aá])|k(?:e(?:l|boken)|a(?:ve)?)?))?)?|önikeboken)|s(?:\.[\s\xa0]*Kronik|[\s\xa0]*Kronik|i[eę]g(?:[ai][\s\xa0]*Kronik))|wonik)|ବଂଶାବଳୀର?|Sử[\s\xa0]*(?:biên[\s\xa0]*niên|Ký)|Babad|Pa(?:r(?:alipomen(?:on?|a))?)?|Nya|itih[aā]sko|I(?:tihas|stwa)|L(?:etopis[uů]|ịch[\s\xa0]*sử|jetopisa)|Книга[\s\xa0]*на[\s\xa0]*летописите|พ(?:ศด|งศาวดาร)))|[\s\xa0]*(?:K(?:s(?:\.[\s\xa0]*Kronik|[\s\xa0]*Kronik|i[eę]g(?:[ai][\s\xa0]*Kronik))|r(?:ón(?:ika)?|ø(?:n(?:ikebo[gk])?)?|o(?:n(?:ík|i(?:eken|c(?:a|k[aá])|k(?:e(?:l|boken)|a(?:ve)?)?))?)?|ön(?:ikeboken)?|n)|wonik)|इति(?:हास(?:को)?)?|Дн(?:евника)?|tavārīḫ|Taar(?:iikhdii)?|Пар(?:алипоменону?)?|تواریخ|книга[\s\xa0]*(?:летописи|хроніки?)|M(?:ga[\s\xa0]*[CK]roni(?:[ck]a)|ambo[\s\xa0]*ya[\s\xa0]*Nyakati)|أخ|Л(?:ітопису|ет(?:опис[иь])?)|Ȟroniky|C(?:h(?:oron(?:ocles?|icles)|r(?:n|o(?:n(?:ocles?|i(?:c(?:les?|als)|k|ques))?)?)?)?|r(?:(?:[óô](?:n(?:icas)?)?)|o(?:n(?:ocles?|ache|i(?:c(?:i(?:lor)?|as?|l(?:es?)?)|ka))?)?)?|oron[io]cles?)|i(?:[\s\xa0]*Kronika(?:ve)?|t(?:ih(?:ās(?:ko)?|asko)|ahās)|\.[\s\xa0]*Kronika(?:ve)?)|H(?:anO|roniky)|ବଂଶାବଳୀର?|k(?:niha[\s\xa0]*kronik|[\s\xa0]*(?:Kron(?:ík|i(?:ck[aá]|k))|Paralipomenon)|\.[\s\xa0]*(?:Kron(?:ík|i(?:ck[aá]|k))|Paralipomenon))|Sử[\s\xa0]*(?:biên[\s\xa0]*niên|Ký)|e(?:[\s\xa0]*Kronika(?:ve)?|\.[\s\xa0]*Kronika(?:ve)?)|Babad|Pa(?:r(?:alipomen(?:on?|a))?)?|Aik(?:ak(?:irja)?)?|хрон|Хр|I(?:tihas|st(?:wa)?)|குறி(?:ப்பேடு)?|L(?:etopis[uů]|ịch[\s\xa0]*sử|jet(?:opisa)?)|Книга[\s\xa0]*на[\s\xa0]*летописите|நாளா(?:கமம்)?|พ(?:ศด|งศาวดาร)|N(?:ya|[aā](?:[lḷ](?:[aā]kamam)))|ਇਤਹਾਸ)|역대|st(?:\.[\s\xa0]*(?:C(?:h(?:oron(?:ocles?|icles)|r(?:o(?:n(?:ocles?|ic(?:les?|als))?)?|n)?)|ron(?:[io]cles?)?|oron[io]cles?)|Paralipomenon)|[\s\xa0]*(?:C(?:h(?:oron(?:ocles?|icles)|r(?:o(?:n(?:ocles?|ic(?:les?|als))?)?|n)?)|ron(?:[io]cles?)?|oron[io]cles?)|Paralipomenon)))|K(?:wanza[\s\xa0]*(?:Mambo[\s\xa0]*ya[\s\xa0]*Nyakati|Nya)|r[oó]nik(?:[aá]k[\s\xa0]*I))|Una(?:[\s\xa0]*(?:C(?:ronica|hronicle)|Paralipomeno|Mga[\s\xa0]*(?:Kronika|Cronica)|Kronik(?:el|a))|ng[\s\xa0]*(?:C(?:ronica|hronicle)|Paralipomeno|Mga[\s\xa0]*(?:Kronika|Cronica)|Kronik(?:el|a)))|ﺃﺧﺒﺎﺭ[\s\xa0]*ﺍﻷﻳﺎﻡ[\s\xa0]*ﺍﻷ|ਇਤਹਾਸ[\s\xa0]*ਦੀ[\s\xa0]*ਪਹਿਲੀ[\s\xa0]*ਪੋਥੀ|δυτικ[οό]ς[\s\xa0]*Χρονικ(?:[ωώ]ν[\s\xa0]*Α['ʹʹ΄’])|《(?:代上》|[历歷]代志上》|編年紀上》)|Mambo[\s\xa0]*ya[\s\xa0]*Nyakati[\s\xa0]*I|سفر[\s\xa0]*أخبار[\s\xa0]*الأيام[\s\xa0]*الأول|역대(?:기[\s\xa0]*상권?|상|지상)|Α(?:['ʹʹ΄’][\s\xa0]*(?:Παρ?|Χρ(?:ον(?:ικ[ωώ]ν)?)?))|или[\s\xa0]*Първа[\s\xa0]*книга[\s\xa0]*Паралипоменон|Liber[\s\xa0]*I[\s\xa0]*Paralipomenon|۱(?:[\s\xa0۔]*تواریخ|-?توارِیخ)|நாளாகமத்தின்[\s\xa0]*முதலாம்[\s\xa0]*புத்தகம்|F(?:irst[\s\xa0]*(?:C(?:h(?:oron(?:ocles?|icles)|r(?:o(?:n(?:ocles?|ic(?:les?|als))?)?|n)?)|ron(?:[io]cles?)?|oron[io]cles?)|Paralipomenon)|yrri[\s\xa0]*Kron[ií]kub(?:[oó]k)|ørste[\s\xa0]*Kr(?:on|ø(?:n(?:ikebo[gk])?)?)|[oö]rsta[\s\xa0]*Kr(?:[oö]nikeboken))|П(?:ърва[\s\xa0]*(?:Лет(?:описи)?|Книга[\s\xa0]*на[\s\xa0]*летописите)|рв(?:а[\s\xa0]*(?:дневника|Летописи|хроника|книга[\s\xa0]*летописи|Паралипоменону)|о[\s\xa0]*(?:Летописи|книга[\s\xa0]*летописи))|ерш(?:[ае][\s\xa0]*(?:хроніки|книга[\s\xa0]*хроніки?|Літопису|[HȞ]roniky|Хроніка?)))|E(?:nsimm[aä]inen[\s\xa0]*Aikakirja|ls(?:[oő][\s\xa0]*Kr(?:[oó]n(?:ika)?))|rste[\s\xa0]*Chronik|erste[\s\xa0]*Kron(?:ieken)?)|歴(?:代(?:史上|志(?:略上|上)|誌(?:[\s\xa0]*1|上))|上)|P(?:aralipomenon[\s\xa0]*I|r(?:em(?:ye[\s\xa0]*(?:liv[\s\xa0]*Kwonik[\s\xa0]*la|Kwonik|Istwa)|i(?:er(?:s[\s\xa0]*Chroniques|[\s\xa0]*Chroniques|e(?:s[\s\xa0]*Chroniques|[\s\xa0]*Chroniques))|ère(?:s[\s\xa0]*Chroniques|[\s\xa0]*Chroniques)))|im(?:[ao][\s\xa0]*Cronache|e(?:ir[ao][\s\xa0]*Cr(?:[oô]nicas)|r(?:o[\s\xa0]*Cr[oó]nicas|[\s\xa0]*Cr[oó]nicas)))|v(?:n(?:[ií][\s\xa0]*(?:kniha[\s\xa0]*kronik|Kronik|Pa(?:ralipomenon)?|Letopis[uů]))|a[\s\xa0]*(?:Kron(?:ík|i(?:ck[aá]|k))|Ljetopisa|Paralipomenon|kn(?:jiga[\s\xa0]*Ljetopisa|iha[\s\xa0]*(?:Kron(?:ík|i(?:ck[aá]|k))|Paralipomenon)))|á[\s\xa0]*(?:Kron(?:ík|i(?:ck[aá]|k))|kniha[\s\xa0]*(?:Kron(?:ík|i(?:ck[aá]|k))|Paralipomenon)|Paralipomenon)|(?:[yý][\s\xa0]*(?:Kron(?:ík|i(?:ck[aá]|k))|list[\s\xa0]*(?:Kron(?:ík|i(?:ck[aá]|k))|Paralipomenon)|Paralipomenon))))|ierwsz(?:[aey][\s\xa0]*K(?:s(?:\.[\s\xa0]*Kronik|[\s\xa0]*Kronik|i[eę]g(?:[ai][\s\xa0]*Kronik))|ronik)))|it(?:ih[aā]sko[\s\xa0]*pustak|ahās[\s\xa0]*dī[\s\xa0]*pahilī[\s\xa0]*potʰī)|I(?:\.[\s\xa0]*(?:Taar(?:iikhdii)?|дневника|kniha[\s\xa0]*kronik|книга[\s\xa0]*(?:летописи|хроніки?)|Aikakirja|K(?:s(?:\.[\s\xa0]*Kronik|[\s\xa0]*Kronik|i[eę]g(?:[ai][\s\xa0]*Kronik))|r(?:ón(?:ika)?|o(?:n(?:ík|i(?:ck[aá]|eken|k(?:el)?))?)?)|wonik)|[ȞH]roniky|Л(?:ітопису|ет(?:описи)?)|хрон(?:ика|іки)|Sử[\s\xa0]*(?:biên[\s\xa0]*niên|Ký)|Babad|Pa(?:r(?:alipomen(?:on?|a))?)?|Nya|C(?:h(?:oron(?:ocles?|icles)|r(?:o(?:n(?:ocles?|i(?:c(?:les?|als)|ques))?)?|n)?)|r(?:on(?:ic(?:i(?:lor)?|as?|l(?:es?)?)|ocles?|ache)?|[óô]nicas)|oron[io]cles?)|Хроніка?|Istwa|L(?:etopis[uů]|ịch[\s\xa0]*sử|jetopisa)|Книга[\s\xa0]*на[\s\xa0]*летописите|Паралипоменону|M(?:ga[\s\xa0]*(?:Kronika|Cronica)|ambo[\s\xa0]*ya[\s\xa0]*Nyakati))|[\s\xa0]*(?:Taar(?:iikhdii)?|дневника|kniha[\s\xa0]*kronik|книга[\s\xa0]*(?:летописи|хроніки?)|Aikakirja|K(?:s(?:\.[\s\xa0]*Kronik|[\s\xa0]*Kronik|i[eę]g(?:[ai][\s\xa0]*Kronik))|r(?:ón(?:ika)?|o(?:n(?:ík|i(?:ck[aá]|eken|k(?:el)?))?)?)|wonik)|[ȞH]roniky|Л(?:ітопису|ет(?:описи)?)|хрон(?:ика|іки)|Sử[\s\xa0]*(?:biên[\s\xa0]*niên|Ký)|Babad|Nya|C(?:h(?:oron(?:ocles?|icles)|r(?:o(?:n(?:ocles?|i(?:c(?:les?|als)|ques))?)?|n)?)|r(?:on(?:ic(?:i(?:lor)?|as?|l(?:es?)?)|ocles?|ache)?|[óô]nicas)|oron[io]cles?)|Хроніка?|Istwa|L(?:etopis[uů]|ịch[\s\xa0]*sử|jetopisa)|Книга[\s\xa0]*на[\s\xa0]*летописите|Pa(?:r(?:alipomen[ao])?)?|Паралипоменону|M(?:ga[\s\xa0]*(?:Kronika|Cronica)|ambo[\s\xa0]*ya[\s\xa0]*Nyakati)))|ବଂଶାବଳୀର[\s\xa0]*ପ୍ରଥମ[\s\xa0]*ପୁସ୍ତକ|대상|पहिले[\s\xa0]*इतिहास|Παραλειπομ[έε]νων[\s\xa0]*Α['ʹʹ΄’]|इतिहास(?:को[\s\xa0]*पहिलो[\s\xa0]*पुस्तक|[\s\xa0]*[1१]ला[\s\xa0]*भाग)|דברי[\s\xa0]*הימים[\s\xa0]*א['’])|1\.[oº][\s\xa0]*Cr(?:[oó]nicas)|(?:代上》?|أخبار[\s\xa0]*الأيام[\s\xa0]*الأول|Χρονικ[ώω]ν[\s\xa0]*Α[ʹʹ΄'’]|דברי[\s\xa0]*הימים[\s\xa0]*א|C(?:ron[oi]cles?|h(?:oron(?:ocles?|icles)|ron(?:ocles?|ic(?:les?|als)))|oron[io]cles?)|1(?:\.[\s\xa0]*Sử(?:[\s\xa0]*ký)?|[\s\xa0]*(?:Sử(?:[\s\xa0]*ký)?|дневника|itihas))|[歷历]代志上》?|Fyrri[\s\xa0]*kroníkubók|編年紀上》?|Paralipomenon|《(?:代上|[历歷]代志上|編年紀上)|Първа[\s\xa0]*книга[\s\xa0]*(?:на[\s\xa0]*летописите|Паралипоменон)|I(?:[\s\xa0]*(?:Sử(?:[\s\xa0]*ký)?|Kronika|Paralipomenon)|\.[\s\xa0]*(?:Sử(?:[\s\xa0]*ký)?|Kronika))))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["Ezra"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])(edzr[aā]|(?:E(?:s(?:d(?:ra?)?|r(?:a(?:n[\s\xa0]*kirja|s[\s\xa0]*bok|b[oó]k)?|ā)?|ṛ[aā])|d|-?xơ-?ra|z(?:sd(?:r[aá]s)?|r(?:a(?:s[\s\xa0]*Bog)?)?|d(?:r(?:a[sš]?|á[sš])?)?))|에(?:즈(?:라기?)?|스라기?)|Aejra|Izira?|ଏଜ୍ରା|Первая[\s\xa0]*Ездры|سفر[\s\xa0]*عزرا|Étra|எஸ்(?:றா(?:வின்[\s\xa0]*புத்தகம்)?|ரா)|エ[スズ]ラ[書記]?|ع(?:ـز|ز[\s\xa0]*را)|อสร|เอสรา|azrā|1[\s\xa0]*Езд|Книга[\s\xa0]*(?:на[\s\xa0]*Ездра|Ездр[иы])|Єзд(?:ри)?|ਅਜ਼ਰਾ|Уза[ий]р|《(?:拉》|以斯拉[記记]》|厄斯德拉上》)|Εσ(?:δρας)?|ʿizrā|Έσδρας|एज्रा(?:को[\s\xa0]*पुस्तक)?|עזרא|Ê(?:xra|-?xơ-?ra)|스|Езр(?:ина|а)?|Ces(?:r(?:aa)?)?|Јездра|K(?:s(?:i[eę]g(?:[ai][\s\xa0]*Ezdrasza)|\.[\s\xa0]*Ezdrasza|[\s\xa0]*Ezdrasza)|njiga[\s\xa0]*Ezrina)|eǳr(?:[aā](?:ko)?)|Ἔσ|Li(?:v[\s\xa0]*Esdras[\s\xa0]*la|ber[\s\xa0]*Esdrae))|(?:厄斯德拉上》?|拉》|以斯拉[記记]》?|عزرا|《(?:以斯拉[记記]|厄斯德拉上|拉)|E(?:zdrasza|s(?:dra[se]|ra[ns]))|एज्राको|Езд(?:р[аыи])?))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["Ruth"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(rūtʰ(?:ko[\\s\\xa0]*pustak)?|(?:र(?:ू(?:त|थ(?:को[\\s\\xa0]*पुस्तक)?)|ुत)|῾Ρθ|ਰੂਥ|K(?:njiga[\\s\\xa0]*o[\\s\\xa0]*Ruti|s(?:[\\s\\xa0]*Rut(?:hy)?|\\.[\\s\\xa0]*Rut(?:hy)?|i(?:[eę]g(?:[ai][\\s\\xa0]*Rut(?:hy)?)))|itabu[\\s\\xa0]*cha[\\s\\xa0]*Ruth[iu])|ルツ記?|R(?:u(?:t(?:hs[\\s\\xa0]*Bog|s[\\s\\xa0]*bok|e|a(?:rb[oó]k)?)|-?tơ|u(?:d|t(?:in[\\s\\xa0]*kirja)?))|th?|[úū]t|oot)|سفر[\\s\\xa0]*راعوث|רות|《(?:盧德傳》|得》|路得[記记]》)|룻기?|Ру(?:фь?|та)|ଋତର[\\s\\xa0]*ବିବରଣ[\\s\\xa0]*ପୁସ୍ତକ|ரூத்(?:த(?:ின்[\\s\\xa0]*சரித்திரம்|ு))?|Li(?:v[\\s\\xa0]*Rit[\\s\\xa0]*la|ber[\\s\\xa0]*Ruth)|ر(?:وت|ا|ُوت)|น(?:างรูธ|รธ)|Ρουθ|Uru(?:to)?|Книга[\\s\\xa0]*Ру(?:фи|т)|rutʰ(?:ko[\\s\\xa0]*pustak)?)|rutʰko|(?:R(?:it|u(?:utin|t(?:h[iu]?|s)?)?)|盧德傳》|راعوث|得》|रूथको|rūt(?:ʰko)?|路得[记記]》|《(?:盧德傳|路得[记記]|得)|Рут)|(?:盧德傳|路得[记記]|得))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Neh"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(nahemyahko[\\s\\xa0]*pustak|Nahemyah|(?:נחמיה|நெகே(?:மியா(?:வின்[\\s\\xa0]*புத்தகம்)?)?|نح(?:میاہ)?|n(?:iḥimyāh|ah(?:emy(?:ā(?:hko[\\s\\xa0]*pustak)?|a)|amyāh))|《(?:厄斯德拉下》|尼(?:希米[記记]》|》))|Νε(?:εμ[ίι]ας)?|นหม|ਨਹਮਯਾਹ|سفر[\\s\\xa0]*نحميا|ନିହିମିୟାଙ୍କର[\\s\\xa0]*ପୁସ୍ତକ|K(?:s(?:[\\s\\xa0]*Nehemiasza|\\.[\\s\\xa0]*Nehemiasza|i[eę]g(?:[ai][\\s\\xa0]*Nehemiasza))|njiga[\\s\\xa0]*Nehemijina)|Книга[\\s\\xa0]*(?:Неем(?:і[ії]|ии)|на[\\s\\xa0]*Неемия)|느(?:헤(?:미(?:야기?|아))?)?|न(?:हेम(?:ा(?:याह)?|्या(?:ह(?:को[\\s\\xa0]*पुस्तक)?)?)|्हेम्याह)|เนหะมีย์|Не(?:єм(?:і[ії])?|хемија|м(?:ија)?|ем(?:ија|ія)?)|Li(?:ber[\\s\\xa0]*Nehemiae|v[\\s\\xa0]*Neyemi[\\s\\xa0]*an)|N(?:é(?:h(?:[eé]mie)?)?|ahi(?:miyaa)?|ê-?hê-?mi-?a|e(?:x(?:emyaah)?|em(?:i(?:as?|ja)?)?|h(?:im(?:i(?:h|i(?:[ai]h|h)|a(?:[ai]h|h)?)|a(?:h|[ai](?:(?:[ai]h|h))))|émie|amiah?|em(?:eia|j(?:a(?:s[\\s\\xa0]*bok|š)?|á[sš])|a(?:h|[ai](?:(?:[ai]h|h)))|ía(?:b[oó]k|[hs])|i(?:a(?:[ai]h|n[\\s\\xa0]*kirja|s’[\\s\\xa0]*Bog|b[oó]k|[hš])?|á[sš]|[eh]|ja|i(?:[ai]h|h))|ya))?|k[eē]miy[aā])?|ơkhemia)|ネヘミヤ記?)|(?:نحميا|ନିହିମିୟାଙ୍କର|《(?:尼(?:希米[記记])?|厄斯德拉下)|नहेम्याहको|尼(?:希米[记記]》?|》)?|N(?:e(?:hem(?:jas|ia(?:s(?:za)?|[en]))|yemi)|ê(?:-?hê-?mi)?)|厄斯德拉下》?|Неем(?:и[яи]|і[ії])|nahemy[āa]hko))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["GkEsth"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Est(?:er[\\s\\xa0]*greco|her[\\s\\xa0]*graeca)|(?:에스[겔텔][\\s\\xa0]*추가본|G(?:k[\\s\\xa0]*Esth?|r(?:Est|[\\s\\xa0]*Esth?|écke[\\s\\xa0]*[cč]asti[\\s\\xa0]*knihy[\\s\\xa0]*Ester|e(?:cke[\\s\\xa0]*[cč]asti[\\s\\xa0]*knihy[\\s\\xa0]*Ester|ek[\\s\\xa0]*Est(?:h(?:er)?)?)|aeca[\\s\\xa0]*Esther))|Den[\\s\\xa0]*greske[\\s\\xa0]*Ester-?bok(?:en|a)|Es(?:zter[\\s\\xa0]*k[oö]nyv(?:[eé]nek[\\s\\xa0]*kieg(?:[eé]sz(?:[ií]t(?:[eé]se))))|t(?:[\\s\\xa0]*(?:\\(Gr\\)|Gr)|er(?:arb[oó]k[\\s\\xa0]*hin[\\s\\xa0]*gr(?:[ií]ska)|[\\s\\xa0]*(?:[rř]eck(?:[eé][\\s\\xa0]*(?:(?:[cč](?:[aá]sti)|dodatky)))|\\((?:greco\\)|Gr(?:yego\\)|i(?:yego\\)|e(?:go\\)|chisch\\)|ks\\)))|\\)|eg[ao]\\))|versione[\\s\\xa0]*greca\\)|řecké[\\s\\xa0]*(?:dodatky\\)|části\\)))|enligt[\\s\\xa0]*den[\\s\\xa0]*grekiska[\\s\\xa0]*texten|Gr(?:i(?:yego|ego)|yego|eg[ao])?))|g|h(?:er[\\s\\xa0]*(?:Gr(?:ec)?|\\(Gre(?:ek\\)|c\\)))|[\\s\\xa0]*Gr)))|எஸ்(?:[\\s\\xa0]*\\(கி\\)|தர்[\\s\\xa0]*\\(கி(?:ரேக்கம்\\)|\\)))|エステル(?:記補遺|書殘篇)|《GkEsth》|Εσθ[ήη]ρ[\\s\\xa0]*στα[\\s\\xa0]*ελληνικ[άα]|Дополнения[\\s\\xa0]*к[\\s\\xa0]*Есфири|Kr(?:\\.[\\s\\xa0]*Est|[\\s\\xa0]*Est|eikkalainen[\\s\\xa0]*Esterin[\\s\\xa0]*kirja)|תוספות[\\s\\xa0]*למגילת[\\s\\xa0]*אסתר)|(?:《GkEsth|எஸ்(?:[\\s\\xa0]*\\(கி\\)|தர்[\\s\\xa0]*\\(கி\\))|Kreikkalainen[\\s\\xa0]*Esterin|GkEsth》?|Est(?:h(?:er[\\s\\xa0]*(?:gr(?:ec)?|\\(grec\\))|[\\s\\xa0]*gr)|[\\s\\xa0]*(?:\\(Gr\\)|gr)|er[\\s\\xa0]*(?:gr(?:ega|iego)?|\\((?:Grie(?:chisch\\)|ks\\))|gr(?:iego\\)|ega\\)))))))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Esth"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:estarko[\\s\\xa0]*pustak|எஸ்(?:தர(?:ின்[\\s\\xa0]*சரித்திரம்|்))?|سفر[\\s\\xa0]*أستير|ਅਸਤਰ|เอสเธอร์|[aā]star|ایستر|エステル[書記]?|Ks(?:i[eę]g(?:[ai][\\s\\xa0]*Estery)|\\.[\\s\\xa0]*Estery|[\\s\\xa0]*Estery)|אסתר,[\\s\\xa0]*כולל[\\s\\xa0]*פרקים[\\s\\xa0]*גנוזים|Јест(?:ира)?|Книга[\\s\\xa0]*Ес(?:ф(?:ири|ір)|т[еи]р)|อสธ|Ê-?xơ-?tê|أس|ऐस्तेर|ଏଷ୍ଟର[\\s\\xa0]*ବିବରଣ|एस्त(?:ेर|र(?:को[\\s\\xa0]*पुस्तक)?)|Εσθ(?:[ήη]ρ)?|Li(?:v[\\s\\xa0]*Est[eè][\\s\\xa0]*a|ber[\\s\\xa0]*Esther)|에(?:스(?:더기?|텔|테르기)?)?|E(?:s(?:t(?:[ah]r?|e(?:er|r(?:ei|in[\\s\\xa0]*kirja|s[\\s\\xa0]*(?:Bog|bok)|a(?:rb[oó]k)?)?))?|zt(?:er)?)?|t)|آستر|A(?:ester|st(?:tiro)?)|《(?:艾斯德爾傳》|斯》|以斯帖[記记]》)|Ес(?:т(?:ира)?|ф(?:ирь)?))|Ester(?:in|[ys])|ester|(?:艾斯德爾傳》|Est(?:her|[èe])|斯》|एस्तरको|Ес(?:т[еи]р|фір)|《(?:艾斯德爾傳|斯|以斯帖[记記])|estarko|以斯帖[记記]》|أستير|אסתר)|(?:艾斯德爾傳|斯|以斯帖[记記]))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Job"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:[इई]योब|J(?:b|o(?:b(?:i(?:n[\\s\\xa0]*kirja)?|s(?:[\\s\\xa0]*(?:Bog|bok)|b[oó]k))|v)|ób?)|ayy(?:ūb(?:ko[\\s\\xa0]*pustak)?|ubko[\\s\\xa0]*pustak)|أي|īyob|โยบ|《(?:伯》|约伯记》|約伯[傳記]》)|G(?:b|i(?:óp|obbe))|Книга[\\s\\xa0]*(?:на[\\s\\xa0]*(?:Йов|Иова?)|[ІИЙ]ова)|Ι(?:[ωώ]β|β)|I(?:job|y(?:ob|yooba)|ov)|Y(?:ōpu|o(?:pu|b))|Јов|איוב|Li(?:v[\\s\\xa0]*J[oò]b[\\s\\xa0]*la|ber[\\s\\xa0]*Iob)|욥기?|Ἰβ|Hi(?:obi?)?|ヨ[フブ]記?|K(?:\\.[\\s\\xa0]*J[oó]bova|s(?:\\.[\\s\\xa0]*(?:Joba|Hioba|Ijoba)|[\\s\\xa0]*(?:Joba|Hioba|Ijoba)|i(?:[eę]g(?:[ai][\\s\\xa0]*(?:Joba|Hioba|Ijoba))))|[\\s\\xa0]*J[oó]bova|itabu[\\s\\xa0]*cha[\\s\\xa0]*(?:Ayubu|Yobu)|n(?:jiga[\\s\\xa0]*o[\\s\\xa0]*Jobu|iha[\\s\\xa0]*J[oó]bova))|ਅ(?:ੱਯੂਬ|ਯੂਬ)|अय(?:युब|्यूब(?:को[\\s\\xa0]*पुस्तक)?)|ଆୟୁବ[\\s\\xa0]*ପୁସ୍ତକ|Аюб|யோபு(?:டைய[\\s\\xa0]*சரித்திரம்)?|ای(?:وب|ُّوب|ّوب)|Ay(?:u(?:b|ub)?|yoob)|سفر[\\s\\xa0]*أيوب)|(?:أيوب|约伯记》?|伯》|iyob|अय्यूबको|ଆୟୁବ|ayy[ūu]bko|Iob|約伯[記傳]》?|J(?:ob(?:in|[sa])?|òb)|Ayubu|《(?:約伯[傳記]|伯|约伯记)|Yobu|Hioba|Іова|[ИЙ]ова?))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Mal"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(mal(?:āk(?:ʰ[iī]|[iī])|ak(?:ʰ[iī]|ī))|(?:ਮਲਾਕੀ|Μα(?:λ(?:αχ[ίι]ας)?)?|Книга[\\s\\xa0]*(?:Малахі[ії]|пророка[\\s\\xa0]*Малах(?:і[ії]|ии)|на[\\s\\xa0]*пророк[\\s\\xa0]*Малахия)|《(?:玛(?:拉基(?:书》|》)|》)|瑪(?:拉基[亞書]》|》))|மல(?:்கி(?:யா)?|ா(?:க்கி)?)|Мал(?:ах(?:ија|ія))?|سفر[\\s\\xa0]*ملاخي|M(?:ikiyaasa|a(?:l(?:ichi|ch?|ea(?:hi|[ck]hi)|kiy[aā]|a(?:[hȟ]ija|akii|k(?:i(?:s[\\s\\xa0]*bok|a(?:n[\\s\\xa0]*kirja|s’[\\s\\xa0]*Bog)?|ás)?|í|ee)|c(?:i|h(?:i(?:a[sš]?|á[sš]|e))?)?|qu(?:[ií]as)?)?)?|-?la-?(?:ki|chi))|l)|מלאכי|말(?:라(?:키서|기서?)?)?|मल(?:ा(?:खी|की(?:को[\\s\\xa0]*पुस्तक)?)|की)|Liv[\\s\\xa0]*Malachi[\\s\\xa0]*a|マラ(?:キ書?)?|Pro(?:phetia[\\s\\xa0]*Malachiae|roctwo[\\s\\xa0]*Malachyaszowe)|ମଲାଖି[\\s\\xa0]*ଭବିଷ୍ୟ‌ଦ୍‌ବକ୍ତାଙ୍କ[\\s\\xa0]*ପୁସ୍ତକ|எபிரேயம்|ม(?:าลาคี|ลค)|مل(?:ا(?:کی)?)?|ﻣﻼﺥ|Ks(?:i[eę]g(?:[ai][\\s\\xa0]*Malachiasza)|[\\s\\xa0]*Malachiasza|\\.[\\s\\xa0]*Malachiasza))|Malakia[sn]|(?:malaki|ମଲାଖି|玛(?:拉基(?:书》|》)|》)|瑪(?:拉基[亞書]》|》)|Малах(?:и[яи]|і[ії])|《(?:玛(?:拉基书?)?|瑪(?:拉基[書亞])?)|Malachi(?:asza)?|ملاخي)|(?:玛(?:拉基书?)?|瑪(?:拉基[亞書])?))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Matt"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Еван(?:ђеље[\\s\\xa0]*по[\\s\\xa0]*Матеју|гелие(?:то[\\s\\xa0]*според[\\s\\xa0]*Матеј|[\\s\\xa0]*(?:според[\\s\\xa0]*Матеј|от[\\s\\xa0]*Мат(?:фея|е[ий]))))|《(?:太》|[馬马]太福音》|瑪(?:特斐》|竇福音》))|ม(?:ธ|ัทธิว)|मत्त(?:य(?:ाने[\\s\\xa0]*लिहिलेले[\\s\\xa0]*शुभवर्तमान)?|ि|ी(?:को[\\s\\xa0]*सुसमाचार|ले[\\s\\xa0]*लेखेको[\\s\\xa0]*सुसमाचार)?)|М(?:ат(?:еја|а[ий])?|[тф])|மத்(?:தேயு[\\s\\xa0]*(?:நற்செய்தி|எழுதிய[\\s\\xa0]*(?:நற்செய்தி|சுவிசேஷம்)))?|הבשורה[\\s\\xa0]*(?:לפי[\\s\\xa0]*מתי|על[\\s\\xa0\\-?]*פי[\\s\\xa0]*מתי|הקדושה[\\s\\xa0]*על-?פי[\\s\\xa0]*מתי)|Κατ[άα][\\s\\xa0]*Ματθα(?:[ίι]ον)|Jevan(?:helije[\\s\\xa0]*vid[\\s\\xa0]*Matvija|đelje[\\s\\xa0]*po[\\s\\xa0]*Mateju)|Sulat[\\s\\xa0]*ni[\\s\\xa0]*San[\\s\\xa0]*Mateo|Injil(?:[\\s\\xa0]*Matius|i[\\s\\xa0]*ya[\\s\\xa0]*Mathayo)|ମାଥିଉ[\\s\\xa0]*ଲିଖିତ[\\s\\xa0]*ସୁସମାଗ୍ଭର|マタイ(?:による福音書|福音書|傳福音書|[伝書])|matt(?:ile[\\s\\xa0]*lekʰeko[\\s\\xa0]*susm[aā]c(?:[aā]r)|ay[aā]ne[\\s\\xa0]*lihilele[\\s\\xa0]*(?:[sŝ]ubʰavartam(?:[aā]n))|ī(?:[\\s\\xa0]*(?:kī[\\s\\xa0]*injīl|dī[\\s\\xa0]*ĩjīl)|le[\\s\\xa0]*lekʰeko[\\s\\xa0]*susm[aā]c(?:[aā]r)))|E(?:van(?:keliumi[\\s\\xa0]*Matteuksen[\\s\\xa0]*mukaan|geli(?:um[\\s\\xa0]*(?:secundum[\\s\\xa0]*Matthaeum|podle[\\s\\xa0]*Matou[sš]e)|e(?:t[\\s\\xa0]*etter[\\s\\xa0]*Matteus|[\\s\\xa0]*volgens[\\s\\xa0]*Matte[uü]s))|[ðđ]elje[\\s\\xa0]*po[\\s\\xa0]*Mateju|jelium[\\s\\xa0]*Pod[lľ]a[\\s\\xa0]*Mat(?:[uú](?:[sš]a)))|w(?:angelia[\\s\\xa0]*(?:w(?:edług[\\s\\xa0]*(?:[sś]w(?:\\.[\\s\\xa0]*Mateusza|[\\s\\xa0]*Mateusza))|g[\\s\\xa0]*(?:[sś]w(?:\\.[\\s\\xa0]*Mateusza|[\\s\\xa0]*Mateusza)))|Mateusza)|[\\s\\xa0]*Mat(?:eusza)?|\\.[\\s\\xa0]*Mateusza)|banghelyo[\\s\\xa0]*(?:ni[\\s\\xa0]*(?:San[\\s\\xa0]*Mateo|Mateo)|ayon[\\s\\xa0]*kay[\\s\\xa0]*Mateo)|l[\\s\\xa0]*Evangelio[\\s\\xa0]*de[\\s\\xa0]*Mateo)|The[\\s\\xa0]*Gospel[\\s\\xa0]*(?:according[\\s\\xa0]*to[\\s\\xa0]*(?:M(?:at(?:t(?:iew|t(?:iew|h(?:iew|ew)|ew)|ew|h(?:iew|(?:[ht](?:iew|ew))|ew|we)|we)?|h(?:iew|ew|(?:[ht](?:iew|(?:[ht](?:iew|ew))|ew))))?|t)|S(?:aint[\\s\\xa0]*M(?:at(?:t(?:iew|t(?:iew|h(?:iew|ew)|ew)|ew|h(?:iew|(?:[ht](?:iew|ew))|ew|we)|we)?|h(?:iew|ew|(?:[ht](?:iew|(?:[ht](?:iew|ew))|ew))))?|t)|t(?:\\.[\\s\\xa0]*M(?:at(?:t(?:iew|t(?:iew|h(?:iew|ew)|ew)|ew|h(?:iew|(?:[ht](?:iew|ew))|ew|we)|we)?|h(?:iew|ew|(?:[ht](?:iew|(?:[ht](?:iew|ew))|ew))))?|t)|[\\s\\xa0]*M(?:at(?:t(?:iew|t(?:iew|h(?:iew|ew)|ew)|ew|h(?:iew|(?:[ht](?:iew|ew))|ew|we)|we)?|h(?:iew|ew|(?:[ht](?:iew|(?:[ht](?:iew|ew))|ew))))?|t))))|of[\\s\\xa0]*(?:M(?:at(?:t(?:iew|t(?:iew|h(?:iew|ew)|ew)|ew|h(?:iew|(?:[ht](?:iew|ew))|ew|we)|we)?|h(?:iew|ew|(?:[ht](?:iew|(?:[ht](?:iew|ew))|ew))))?|t)|S(?:aint[\\s\\xa0]*M(?:at(?:t(?:iew|t(?:iew|h(?:iew|ew)|ew)|ew|h(?:iew|(?:[ht](?:iew|ew))|ew|we)|we)?|h(?:iew|ew|(?:[ht](?:iew|(?:[ht](?:iew|ew))|ew))))?|t)|t(?:\\.[\\s\\xa0]*M(?:at(?:t(?:iew|t(?:iew|h(?:iew|ew)|ew)|ew|h(?:iew|(?:[ht](?:iew|ew))|ew|we)|we)?|h(?:iew|ew|(?:[ht](?:iew|(?:[ht](?:iew|ew))|ew))))?|t)|[\\s\\xa0]*M(?:at(?:t(?:iew|t(?:iew|h(?:iew|ew)|ew)|ew|h(?:iew|(?:[ht](?:iew|ew))|ew|we)|we)?|h(?:iew|ew|(?:[ht](?:iew|(?:[ht](?:iew|ew))|ew))))?|t)))))|พระวรสารนักบุญแม็ทธิว|M(?:a(?:-?thi-?ơ|buting[\\s\\xa0]*Balita[\\s\\xa0]*ayon[\\s\\xa0]*kay[\\s\\xa0]*(?:San[\\s\\xa0]*Mateo|Mateo)|t(?:é(?:us)?|ou(?:[sš](?:ovo[\\s\\xa0]*evangelium)?)|e(?:u(?:sz?)?|[ij])?|[uú][sš]|h|ayos?|t(?:æusevangeliet|ēyu[\\s\\xa0]*Na[rṛ]ceyti|h(?:a(?:eus|us)|äus|æus(?:evangeliet)?|[eé](?:[uü]s)|ieu)?|e(?:i[\\s\\xa0]*evangelium|yu[\\s\\xa0]*Na[rṛ]ceyti|u(?:s(?:arguðspjall|evangeliet)|ksen[\\s\\xa0]*evankeliumi)|e))|ye)|atiyoosa)|át(?:thêu|[eé])|t[ht])|مت(?:ّی[\\s\\xa0]*کی[\\s\\xa0]*انجیل|ی[\\s\\xa0]*کی[\\s\\xa0]*انجیل)?|Μ(?:ατθ(?:α[ίι]ος)?|θ)|إنجيل[\\s\\xa0]*متى|Ungjilli[\\s\\xa0]*i[\\s\\xa0]*Mateut|ਮੱਤੀ[\\s\\xa0]*ਦੀ[\\s\\xa0]*ਇੰਜੀਲ|마태(?:오[\\s\\xa0]*복음서?|복음서?)?|Євангелі(?:є[\\s\\xa0]*від[\\s\\xa0]*(?:св(?:[\\s\\xa0]*Матвія|\\.[\\s\\xa0]*Матвія)|Мат(?:вія|ея))|я[\\s\\xa0]*від[\\s\\xa0]*(?:св(?:[\\s\\xa0]*Матвія|\\.[\\s\\xa0]*Матвія)|Матвія))|Vangelo[\\s\\xa0]*di[\\s\\xa0]*(?:San[\\s\\xa0]*Matteo|Matteo)|От[\\s\\xa0]*Матея[\\s\\xa0]*свето[\\s\\xa0]*Евангелие|Јеванђеље[\\s\\xa0]*по[\\s\\xa0]*Матеју)|(?:Evangelio[\\s\\xa0]*de[\\s\\xa0]*Mateo|मत्त(?:ीले|याने)|[马馬]太福音》?|太》|От[\\s\\xa0]*Мат(?:фея|ея)|مت(?:ّی|[ىی])|ମାଥିଉ|Від[\\s\\xa0]*Матвія|மத்தேயு|ਮੱਤੀ|matt(?:ay[āa]ne|ī(?:le)?|ile)|S(?:t(?:\\.[\\s\\xa0]*M(?:at(?:t(?:iew|t(?:iew|h(?:iew|ew)|ew)|ew|h(?:iew|(?:[ht](?:iew|ew))|ew|we)|we)?|h(?:iew|ew|(?:[ht](?:iew|(?:[ht](?:iew|ew))|ew))))?|t)|[\\s\\xa0]*M(?:at(?:t(?:iew|t(?:iew|h(?:iew|ew)|ew)|ew|h(?:iew|(?:[ht](?:iew|ew))|ew|we)|we)?|h(?:iew|ew|(?:[ht](?:iew|(?:[ht](?:iew|ew))|ew))))?|t))|a(?:n[\\s\\xa0]*Mateo|int[\\s\\xa0]*M(?:at(?:t(?:iew|t(?:iew|h(?:iew|ew)|ew)|ew|h(?:iew|(?:[ht](?:iew|ew))|ew|we)|we)?|h(?:iew|ew|(?:[ht](?:iew|(?:[th](?:iew|ew))|ew))))?|t)))|瑪(?:特斐》?|竇福音》?)|Gospel[\\s\\xa0]*(?:according[\\s\\xa0]*to[\\s\\xa0]*(?:M(?:at(?:t(?:iew|t(?:iew|h(?:iew|ew)|ew)|ew|h(?:iew|(?:[th](?:iew|ew))|ew|we)|we)?|h(?:iew|ew|(?:[ht](?:iew|(?:[th](?:iew|ew))|ew))))?|t)|S(?:aint[\\s\\xa0]*M(?:at(?:t(?:iew|t(?:iew|h(?:iew|ew)|ew)|ew|h(?:iew|(?:[ht](?:iew|ew))|ew|we)|we)?|h(?:iew|ew|(?:[ht](?:iew|(?:[th](?:iew|ew))|ew))))?|t)|t(?:\\.[\\s\\xa0]*M(?:at(?:t(?:iew|t(?:iew|h(?:iew|ew)|ew)|ew|h(?:iew|(?:[ht](?:iew|ew))|ew|we)|we)?|h(?:iew|ew|(?:[th](?:iew|(?:[ht](?:iew|ew))|ew))))?|t)|[\\s\\xa0]*M(?:at(?:t(?:iew|t(?:iew|h(?:iew|ew)|ew)|ew|h(?:iew|(?:[th](?:iew|ew))|ew|we)|we)?|h(?:iew|ew|(?:[ht](?:iew|(?:[ht](?:iew|ew))|ew))))?|t))))|of[\\s\\xa0]*(?:M(?:at(?:t(?:iew|t(?:iew|h(?:iew|ew)|ew)|ew|h(?:iew|(?:[ht](?:iew|ew))|ew|we)|we)?|h(?:iew|ew|(?:[th](?:iew|(?:[ht](?:iew|ew))|ew))))?|t)|S(?:aint[\\s\\xa0]*M(?:at(?:t(?:iew|t(?:iew|h(?:iew|ew)|ew)|ew|h(?:iew|(?:[ht](?:iew|ew))|ew|we)|we)?|h(?:iew|ew|(?:[th](?:iew|(?:[th](?:iew|ew))|ew))))?|t)|t(?:\\.[\\s\\xa0]*M(?:at(?:t(?:iew|t(?:iew|h(?:iew|ew)|ew)|ew|h(?:iew|(?:[ht](?:iew|ew))|ew|we)|we)?|h(?:iew|ew|(?:[th](?:iew|(?:[ht](?:iew|ew))|ew))))?|t)|[\\s\\xa0]*M(?:at(?:t(?:iew|t(?:iew|h(?:iew|ew)|ew)|ew|h(?:iew|(?:[th](?:iew|ew))|ew|we)|we)?|h(?:iew|ew|(?:[ht](?:iew|(?:[ht](?:iew|ew))|ew))))?|t)))))|Мат(?:вія|е[йиј])|M(?:at(?:ius|eo|t(?:iew|ēyu|t(?:iew|h(?:iew|ew)|ew)|e(?:u(?:ksen|s)|üs|yu|[wo])|h(?:iew|(?:[ht](?:iew|ew))|ew|we)|we)?|h(?:ayo|iew|ew|(?:[ht](?:iew|(?:[th](?:iew|ew))|ew)))|[uú](?:[šs]a))?|t)|《(?:[馬马]太福音|瑪(?:特斐|竇福音)|太)))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Ps"],
        extra: "1",
        regexp: RegExp("(\\b)((?:(?:(?:1[02-5]|[2-9])?(?:1" + bcv_parser.prototype.regexps.space + "*st|2" + bcv_parser.prototype.regexps.space + "*nd|3" + bcv_parser.prototype.regexps.space + "*rd))|1?1[123]" + bcv_parser.prototype.regexps.space + "*th|(?:150|1[0-4][04-9]|[1-9][04-9]|[4-9])" + bcv_parser.prototype.regexps.space + "*th)" + bcv_parser.prototype.regexps.space + "*Psalm)\\b", "gi")
      }, {
        osis: ["Ps"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Заб(?:ур)?|P(?:s(?:l(?:a(?:ms?|lms?)?|m(?:as|[ms])?)|sm?|a(?:l(?:taren|a(?:ms?|s)?|m(?:a[su]?|[lm]s?|[sy]|i(?:en[\\s\\xa0]*kirja|[it])?|u[ls]|e[nt]?)?|s|lms?)?|a(?:ms|a|lms?)|u(?:mes?)?|m(?:ms?|as|l(?:ms?|[as])?|s)?)?|m(?:ls?|m|a(?:l(?:ms?|s)?)?)?)?|l(?:ms|s(?:s(?:s(?:ss?)?)?|ms?|a(?:ms?)?)|a(?:m(?:as|s)?|as?|s(?:m(?:as?|s)?|s)?))|a(?:m[ls]s|l(?:[lm]s|sms?)|s(?:ss|m(?:ls|s)|lms?)))|தி(?:ருப்பாடல்(?:கள்)?|பா)|ਜ(?:ਬੂਰ|਼ਬੂਰ)|M(?:a(?:smur|z(?:amure)?)|ga[\\s\\xa0]*(?:Awit|Salmo))|S(?:lm?|a(?:buur(?:radii)?|l(?:m(?:os|a(?:rnir|u)|e(?:rne(?:s[\\s\\xa0]*Bog)?|ne(?:s[\\s\\xa0]*bok)?)?|[is])?)?)|álmarnir)|Th(?:i[\\s\\xa0]*Thiên|ánh[\\s\\xa0]*(?:vịnh|Thi))|stotrasa[mṃ]hit[aā]|מזמורים|Jabur|สด(?:ุดี|ด)|K(?:s(?:[\\s\\xa0]*Psalm[oó]w|\\.[\\s\\xa0]*Psalm[oó]w|i[eę]g(?:[ai][\\s\\xa0]*Psalm(?:[oó]w)))|niha[\\s\\xa0]*(?:[zž]alm(?:ov|[uů]))|[\\s\\xa0]*[zž]almov|\\.[\\s\\xa0]*[zž]almov)|תהילים|சங(?:்(?:கீ(?:த(?:ங்கள்|[\\s\\xa0]*புத்தகம்|ம்))?)?|கீதம்)|zabūr|Ψα(?:λμ(?:ο(?:ς|[ίι][\\s\\xa0]*του[\\s\\xa0]*Δαυ(?:[ίι]δ))|ός))?|الم(?:زمور|َزمُور)|Ž(?:al(?:t[aá]r|my?))?|詩(?:編|篇\\/聖詠)|سفر[\\s\\xa0]*المزامير|Пс(?:ал(?:ти(?:рь?|́р)|м(?:и[\\s\\xa0]*Давидови|ы)|[ао]м)?)?|ଗ(?:ାତସଂହିତା|ୀତ(?:ିସଂହିତା|ସଂହିତା))|시편?|Ca(?:[nṅ]k(?:[iī]tam)|rtea[\\s\\xa0]*Psalmilor)|bʰaǳansa[mṃ]grah|स्त(?:ोत्र(?:संहिता)?|्रोत्रसंहिता)|भजन(?:[\\s\\xa0]*संहिता|स(?:ग्रह|ंग्रह)|-?सहिन्ता)|Z(?:a(?:b(?:uri?)?|l(?:t[aá]r|my?))|solt(?:[aá]rok)?)?|《(?:(?:[詩诗](?:篇》|》))|聖詠集》)|زب(?:ور|ُور?)|Li(?:b(?:er[\\s\\xa0]*Psalmorum|ri[\\s\\xa0]*i[\\s\\xa0]*Psalmeve)|v[\\s\\xa0]*S[oò]m[\\s\\xa0]*yo)|Книга[\\s\\xa0]*Псалмів|مز(?:مور)?|เพลงสดุดี|Bhjan)|(?:Awit|المزامير|S(?:[òo]m|alm(?:enes|o))|Псалм(?:ів|и)|(?:[诗詩](?:篇》?|》)?)|《(?:聖詠集|[诗詩]篇?)|Ψαλμο[ιί]|भजन|Psalmien|聖詠集》?|Thi))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Eccl"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Ec(?:cless[ai](?:[ai]st(?:[eé]s?))|les(?:s[ai](?:[ai]st(?:[eé]s?))|a[ai]st(?:[eé]s?)))|(?:ਉਪਦੇਸ਼ਕ|ଉପଦେଶକ|M(?:a(?:nga|gwawali)|hu(?:biri)?)|جا|傳道之書|Ек(?:к(?:л(?:е(?:сиаст|зіяста?))?)?|л(?:[еи]сиаст)?)|ச(?:ங்கத்[\\s\\xa0]*திருவுரை[\\s\\xa0]*ஆகமம்|உ|பை[\\s\\xa0]*உரையாளர்)|伝道の書|upade(?:(?:[sš]ak(?:ko[\\s\\xa0]*pustak)?)|ŝak)|Εκ(?:κλησιαστ[ήη]ς)?|קהלת|उपदेशक(?:को[\\s\\xa0]*पुस्तक)?|《(?:傳(?:道書》|》)|訓道篇》|传(?:》|道书》))|Gi(?:ảng[\\s\\xa0]*Sư|áo[\\s\\xa0]*huấn)|Ang[\\s\\xa0]*Mangangaral|Juru[\\s\\xa0]*Kotbah|전(?:도서)?|Co[eé]let|Разм(?:ышления)?|コヘレト(?:の(?:こと[はば]|言葉))?|vāʿẓ|Проп(?:ов(?:едник|ідника))?|Fork(?:ynneren(?:s[\\s\\xa0]*bok)?)?|המ(?:רצה|קהיל)|코헬렛?|ป(?:ญจ|ัญญาจารย์)|К(?:нига[\\s\\xa0]*(?:на[\\s\\xa0]*Еклисиаста[\\s\\xa0]*или[\\s\\xa0]*Проповедника|Ек(?:лезіястова|кле(?:зіястова|сиаста)))|оге́лет)|P(?:iraca[nṅ]ki|r(?:éd(?:ik(?:a(?:tor|rinn)|átor))?|e(?:g(?:ethwr)?|d(?:i(?:k(?:a(?:ntens[\\s\\xa0]*bok|r(?:inn|boken|en(?:s[\\s\\xa0]*bok)?)|tor)|er(?:ens?)?|átor|uesi)|ger))?)|op(?:ovjednik)?|æd(?:ikeren(?:s[\\s\\xa0]*Bog)?)?|ad))|Ἐκ|பிரச(?:ங்கி)?|Truyền[\\s\\xa0]*đạo|सभो(?:पदेशक)?|Liber[\\s\\xa0]*(?:Qoelet|Ecclesiastes)|Qo(?:h(?:eleth?|èlet)?|èlet)?|سفر[\\s\\xa0]*الجامعة|E(?:c(?:l(?:is[iy]astes|e(?:s(?:a[ai]t(?:[eé]s?)|yast[eé]s|i(?:a(?:st(?:i(?:[eé]s|c[eé]s)|ul|[eé]s?)|t[eé]s?|iastes)|stes|i(?:t[eé]s?|st[eé]s?))|s[ai](?:[ai]t(?:[eé]s?)))?|ziast(?:ul)?))?|c(?:l(?:és(?:iaste)?|es(?:a(?:stes|a(?:t[eé]s?|st[eé]s?)|i(?:t[eé]s?|st[eé]s?|astes))|s[ai](?:[ai]t(?:[eé]s?))|i(?:a(?:i(?:stes|astes)|t[eé]s?|st(?:i(?:[eé]s|c[eé]s)|ul|és?|e)?|a(?:tes|stes))|tes|stes|i(?:t[eé]s?|st[eé]s?|astes)))?)?)?)?|ra(?:nchchaa)?|k(?:l(?:is[iy]astes|e(?:z(?:yas[\\s\\xa0]*-?[\\s\\xa0]*Liv[\\s\\xa0]*Filoz[oò]f[\\s\\xa0]*la|iastes)|s[iy]ast(?:[eé]s)))?|kle(?:siastes|zijast)))|Wac(?:diyah(?:ii|a))?|K(?:\\.[\\s\\xa0]*kazate[lľ]ova|a(?:alam|z(?:n(?:odziei[\\s\\xa0]*Salomonowego)?)?)|oh(?:elet(?:[\\s\\xa0]*—[\\s\\xa0]*Kazate[lľ]|h))?|s(?:i(?:[eę]g(?:[ai][\\s\\xa0]*(?:Eklezjastesa|K(?:oheleta|aznodziei[\\s\\xa0]*Salomona))))|\\.[\\s\\xa0]*(?:Eklezjastesa|K(?:oheleta|aznodziei[\\s\\xa0]*Salomona))|[\\s\\xa0]*(?:Eklezjastesa|K(?:oheleta|aznodziei[\\s\\xa0]*Salomona)))|niha[\\s\\xa0]*kazate[lľ]ova|[\\s\\xa0]*kazate[lľ]ova)|واع(?:ِظ|ظ)|Sa(?:bhopadeshak|ar(?:n(?:aaja(?:n[\\s\\xa0]*kirja)?)?)?))|(?:उपदेशकको|Mangangaral|Ек(?:клезіястова|л(?:езіястова|исиаста))|Qoelet|傳(?:道書》?|》)?|الجامعة|upade[šs]akko|E(?:klezyas|cclesiastes)|Saarnaajan|訓道篇》?|《(?:訓道篇|传(?:道书)?|傳(?:道書)?)|Giáo|K(?:ohelet|azate[ľl])|Проповедника|Liv[\\s\\xa0]*Filoz[oò]f[\\s\\xa0]*la|Filoz[òo]f|传(?:》|道书》?)?))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Ezek"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(hizkīel|(?:ح(?:ِزقی[\\s\\xa0]*ایل|ز(?:قی[\\s\\xa0‌]*ایل)?)|इजकिएल(?:को[\\s\\xa0]*पुस्तक)?|Книга[\\s\\xa0]*(?:на[\\s\\xa0]*пророк[\\s\\xa0]*(?:Иезекииля|Езекиил)|пророка[\\s\\xa0]*(?:Иезекииля|Єзекі[ії]ля))|E(?:z(?:é(?:kiel|ch(?:iel)?)?|[kq]|i(?:k(?:el|iel)|(?:[ei](?:k(?:el|iel)|qu(?:el|iel)))|qu(?:el|iel))|e(?:c(?:h(?:i(?:ël|ele?))?|iel)?|(?:[ei](?:k(?:el|iel)|qu(?:el|iel)))|q(?:u(?:el|i[ae]l)?)?|k(?:el|i(?:el(?:s(?:’[\\s\\xa0]*Bog|[\\s\\xa0]*Bog)|i)?|al))?)?)|x(?:[ei](?:(?:[ei]k(?:el|iel))|k(?:el|iel)))|c[eē]kkiy(?:[eē]l)|s(?:k|e(?:k(?:iel(?:s[\\s\\xa0]*bok)?|[yí]el)?|c(?:iel)?)))|エ[セゼ]キエル書?|เอเสเคียล|यहेज(?:केल|्केल)?|Езек(?:и(?:ел|л))?|Liv[\\s\\xa0]*Ezeky[eè]l[\\s\\xa0]*la|อสค|᾿Ιζ|Ιεζ(?:κ|εκ(?:ι[ήη]λ)?)?|yahe(?:ǳkel|dzkel)|Prophetia[\\s\\xa0]*Ezechielis|Јез(?:екиљ)?|ଯିହିଜିକଲ[\\s\\xa0]*ଭବିଷ୍ୟ‌ଦ୍‌ବକ୍ତାଙ୍କ[\\s\\xa0]*ପୁସ୍ତକ|《(?:[結结]》|以西(?:結[书書]》|结书》)|厄則克耳》)|எசே(?:க்கியேல்[\\s\\xa0]*தீர்க்கதரிசியின்[\\s\\xa0]*புத்தகம்)?|Ê-?xê-?(?:ki-?ên|chi(?:-?ên|ên))|יחזקאל|iǳakielko[\\s\\xa0]*pustak|Jezeki[iï]l['’]|Ks(?:[\\s\\xa0]*Ezechiela|\\.[\\s\\xa0]*Ezechiela|i[eę]g(?:[ai][\\s\\xa0]*Ezechiela))|H(?:iz(?:qqeela)?|e(?:zechiel|s(?:ekiel(?:in[\\s\\xa0]*kirja|s[\\s\\xa0]*bok)?)?))|Éz(?:[eé]ch(?:iel)?)|에(?:제(?:키엘서?)?|스겔서?)|Iezechiel|Y(?:ahejakel|éh[eè]zki(?:[eè]l)|e(?:h(?:èzki[eè]l|e(?:skiel|zki[eè]l))|x(?:esqeel)?))|Йез(?:екиил)?|겔|Єз(?:екі[ії]л[аь])?|ਹਿਜ਼ਕੀਏਲ|سفر[\\s\\xa0]*حزقيال|ḥiziqīʾīl|Иез(?:екииль?)?)|(?:Иезекииля|[結结]》?|ଯିହିଜିକଲ|以西(?:結[書书]》?|结书》?)|Hesekielin|厄則克耳》?|《(?:厄則克耳|以西(?:结书|結[書书])|[结結])|எசேக்கியேல்|इजकिएलको|Езекиил|iǳakielko|Eze(?:chiela|ky[èe]l)|حزقيال|Ê-?xê|Єзекі[ії]ля))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Hos"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])(Ho(?:šea|se(?:ás|a(?:s(?:’[\s\xa0]*Bog|[\s\xa0]*bok))?|ias?))|(?:ホセア(?:しょ|書)?|هو|Ос(?:ија|ія)?|호(?:세(?:아서?)?)?|《(?:歐瑟亞》|何(?:西阿[书書]》|》))|h(?:o(?:šeā?|sey?|ŝey)|ūsīʿ)|Ōciy[aā]|Ô-?sê|ฮชย|Ks(?:[\s\xa0]*Ozeasza|i[eę]g(?:[ai][\s\xa0]*Ozeasza)|\.[\s\xa0]*Ozeasza)|Ωσ(?:η[έε])?|Хошеа|ஒசேயா|होशे(?:य|को[\s\xa0]*पुस्तक)?|הושע|ਹੋਸ਼ੇਆ|Prophetia[\s\xa0]*Osee|O(?:s(?:ija|e(?:ia[hs]?|a[hs]?)|é(?:ias|e))?|ciy[aā]|z(?:e[aá][sš])?)|ہو(?:سیع(?:َِ)?|[\s\xa0]*سیعاہ)|سفر[\s\xa0]*هوشع|Liv[\s\xa0]*Oze[\s\xa0]*a|H(?:ós(?:e(?:as?|ás))?|ô-?sê-?a|o(?:s(?:ho)?|ze[aá][sš]|os(?:e(?:an[\s\xa0]*kirja|7a)|h(?:eeca)?)?|š)?|s)|Книга[\s\xa0]*(?:на[\s\xa0]*пророк[\s\xa0]*Осия|пророка[\s\xa0]*Ос(?:і[ії]|ии))|ஓச(?:[ிே](?:யா)?)|Ὠσ|ହୋଶ(?:ହେ|େୟ[\s\xa0]*ଭବିଷ୍ୟ‌ଦ୍‌ବକ୍ତାଙ୍କ[\s\xa0]*ପୁସ୍ତକ)|โฮเชยา(?:ห์)?)|(?:Ос(?:и[ия]|і[їі])|歐瑟亞》?|هوشع|ହୋଶେୟ|Ho(?:osean|seas)|何(?:西阿[书書]》?|》)?|《(?:歐瑟亞|何(?:西阿[書书])?)|O(?:ze(?:asza)?|see)))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["Obad"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:オ(?:[ハバ](?:[テデ](?:ヤ(?:しょ|書)?|ア書))?)|Ἀβδ|ع(?:بدیاہ|و)|Ks(?:\\.[\\s\\xa0]*Abdiasza|i[eę]g(?:[ai][\\s\\xa0]*Abdiasza)|[\\s\\xa0]*Abdiasza)|Книга[\\s\\xa0]*(?:на[\\s\\xa0]*пророк[\\s\\xa0]*Авди[ий]|пророка[\\s\\xa0]*(?:Авд[иі]я|Овдія))|obad(?:yāh|iy[aā]|ʰ[aā])|ଓବଦିଅ[\\s\\xa0]*ଭବିଷ୍ୟ‌ଦ୍‌ବକ୍ତାଙ୍କ[\\s\\xa0]*ପୁସ୍ତକ|Áp-?đia|ਓਬਦਯਾਹ|Οβδ[ίι]ας|Авд(?:иј[ае]?)?|ஒப(?:தி(?:யா)?)?|Liv[\\s\\xa0]*Abdyas[\\s\\xa0]*la|อบด|O(?:v(?:adia|dij)|b(?:idah|edi[aá][sš]|a(?:d(?:j(?:á[sš]?|a(?:n[\\s\\xa0]*kirja|s[\\s\\xa0]*bok|š)?)?|eia|hah|i(?:a(?:s['’][\\s\\xa0]*Bog|[hš])?|á[sš]|ja)|ía)?|ja)?|d)?|patiy[aā])|Ов(?:д(?:і[ий])?|адија)?|سفر[\\s\\xa0]*عوبديا|A(?:vdie|b(?:d(?:i(?:j[aá][sš]|a[sš]?|á[sš])?|ías|diyyu)?)?)|Ób(?:ad[ií]a)?|ʿabadiyāh|ओब(?:धाह?|द(?:्(?:याह?|दाह)|िया(?:को[\\s\\xa0]*पुस्तक)?)|ेधाह)?|《(?:亞北底亞》|俄(?:巴底(?:亞書》|亚书》)|》))|Ô-?ba-?đi-?a|Pro(?:phetia[\\s\\xa0]*Abdiae|roctwo[\\s\\xa0]*Abdyaszowe)|Cob(?:ad(?:yaah)?)?|옵|ע(?:בדיה|ובדיה)|โอบาดี[ยห]์|오바(?:드야서|디야|댜서?)?|Αβδ(?:ιο[υύ])?)|(?:俄(?:巴底(?:亞書》?|亚书》?)|》)?|ଓବଦିଅ|Авд(?:ія|и[яйи])|Obad(?:ias|ja[sn])|Áp|Овдія|عوبديا|Abd(?:yas|iasza)|亞北底亞》?|《(?:俄(?:巴底(?:亚书|亞書))?|亞北底亞)))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Hag"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:학(?:개서?)?|Αγ(?:γα[ίι]ος)?|Ог(?:і[ий])?|Ohij|Аг(?:г(?:е[ий])?|еј)?|《(?:[該该]》|哈(?:蓋》|該[书書]》|该书》))|حج(?:اي|يّ|َّ[يی]|ی)?|Ἀγ|ハ(?:[カガ]イ(?:しょ|書)?)|하(?:깨|까(?:이서)?)|Āk[aā]y|Xag(?:g(?:ay)?)?|سفر[\\s\\xa0]*حجي|Liv[\\s\\xa0]*Aje[\\s\\xa0]*a|Книга[\\s\\xa0]*(?:Огія|на[\\s\\xa0]*пророк[\\s\\xa0]*Аге[ий]|пророка[\\s\\xa0]*(?:Огія|Аггея))|h(?:a(?:gg(?:əi|ay)|jjaī)|āgg(?:əi|ay))|ହାଗୟ[\\s\\xa0]*ଭବିଷ୍ୟ‌ଦ୍‌ବକ୍ତାଙ୍କ[\\s\\xa0]*ପୁସ୍ତକ|A(?:-?g(?:ai|hê)|g(?:ai|g(?:a(?:eus|us)|äus|e(?:us|[eo])|ée)?|heu|e(?:us?|[jo]))?|k[aā]y)|חגי|Хагај|ฮ(?:ักกัย|กก)|हाग्ग(?:[ये]|ै(?:को[\\s\\xa0]*पुस्तक)?)|Pro(?:roctwo[\\s\\xa0]*Aggieuszowe|phetia[\\s\\xa0]*Aggaei)|ḥajjai|ஆகா(?:ய்)?|H(?:gg?|a(?:-?gai|g(?:a[ij]|e[jo]|g(?:ia[hi]|a(?:ai|j(?:s[\\s\\xa0]*Bog)?|i(?:n[\\s\\xa0]*kirja|s[\\s\\xa0]*bok)?|[íï])?|e(?:us|o))?)?))|ਹੱਜਈ|Ks(?:i[eę]g(?:[ai][\\s\\xa0]*Aggeusza)|[\\s\\xa0]*Aggeusza|\\.[\\s\\xa0]*Aggeusza))|(?:ହାଗୟ|حجي|[该該]》?|哈(?:蓋》?|該[書书]》?|该书》?)|Haggain|Огія|Аг(?:гея|е[ий])|《(?:哈(?:该书|蓋|該[书書])|[該该])|A(?:je|ggeusza)))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Hab"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(habak(?:kūk|ūk)|(?:《哈(?:》|巴谷(?:[书書]》|》))|ஆப(?:கூக்)?|Α(?:β(?:βακο[υύ]μ)?|μβακο[υύ]μ)|Pro(?:phetia[\\s\\xa0]*Habacuc|roctwo[\\s\\xa0]*Abakukowe)|ḥabaqqūq|ฮ(?:าบากุก|บก)|하(?:바(?:쿡서|꾹)?|박국서?)|हबक(?:ूक(?:को[\\s\\xa0]*पुस्तक)?|्कूक?)?|Liv[\\s\\xa0]*Abakik[\\s\\xa0]*la|Āpak[uū]k|Ав(?:в(?:акум)?|ак)?|ହବ(?:କ[ୁୂ]କ୍|‌କ୍‌କୂକ[\\s\\xa0]*ଭବିଷ୍ୟ‌ଦ୍‌ବକ୍ତାଙ୍କ[\\s\\xa0]*ପୁସ୍ତକ)|Ἀβ|I(?:rmbbaaqooma|mba)|ハ(?:[ハバ]クク(?:しょ|書)?)|Xab(?:aquuq)?|سفر[\\s\\xa0]*حبقوق|חבקוק|ਹਬ(?:ਕ(?:ੂਕ|ੱੂਕ)|ੱਕੂਕ)|A(?:pak[uū]k|va[ck]um|b(?:a(?:k(?:uka?|ouk)?|cuc)|k))|Ha(?:-?ba-?cúc|b(?:a(?:c(?:kuk|cuc|uque|ac)?|k(?:akk?|uk(?:i(?:n[\\s\\xa0]*kirja)?|[ku])?|k(?:akk?|ook|uk(?:s[\\s\\xa0]*(?:Bog|bok)|k)?))?)|[ck]|ba(?:k(?:[au]kk?|k[au]kk?)|c[au]c))?)|Книга[\\s\\xa0]*(?:пророка[\\s\\xa0]*Ав(?:акума|вакума)|на[\\s\\xa0]*пророк[\\s\\xa0]*Авакума?)|합|Ха[бв]акук|حب(?:ق(?:ّوق|ُّوق))?|அப(?:க்கூக்கு)?|Ks(?:i[eę]g(?:[ai][\\s\\xa0]*Habakuka)|\\.[\\s\\xa0]*Habakuka|[\\s\\xa0]*Habakuka))|(?:哈(?:巴谷(?:[書书]》?|》)?|》)?|Haba(?:cuc|kuk(?:in|a))|حبقوق|《哈(?:巴谷[书書]?)?|Abakik|ହବ‌କ୍‌କୂକ|Ав(?:акума?|вакума)|habak(?:uk|kuk)))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Mic"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(m(?:īkāh|ikʰ[aā])|(?:மீக(?:ா|்(?:கா)?)|Ks(?:i[eę]g(?:[ai][\\s\\xa0]*Micheasza)|\\.[\\s\\xa0]*Micheasza|[\\s\\xa0]*Micheasza)|Prophetia[\\s\\xa0]*Michaeae|מיכה|미(?:[가카]서?)?|《(?:彌(?:迦書》|》)|弥(?:》|迦书》)|米該亞》)|mīkʰ[aā]|سفر[\\s\\xa0]*ميخا|M(?:y[hȟ]ej|íka?|īk[aā]|i(?:-?c(?:hê|a)|c(?:ah?|h(?:e(?:a[sš]?|á[sš]|e)|äas|a(?:[aá][sš]|eas|h)?|ée)?)?|h(?:e(?:j|ia))?|ik(?:a(?:ah|n[\\s\\xa0]*kirja)?)?|lk(?:kiyaasa)?|q(?:u(?:e(?:as|ias)|éias))?|k(?:a(?:s[\\s\\xa0]*(?:Bog|bok)|h)?|ieas|e(?:as?|ás|yas)|ā|ha)?)|q|eeka)|ม(?:คา|ีคาห์)|ਮੀਕਾਹ|म(?:ी(?:खा|का(?:को[\\s\\xa0]*पुस्तक)?)|िका)|Книга[\\s\\xa0]*(?:на[\\s\\xa0]*пророк[\\s\\xa0]*Михе[ий]|пророка[\\s\\xa0]*М[иі]хея)|М(?:их(?:еј|а)?|іх)|Μ(?:ιχαΐας|χ|ΙΧΑ(?:[ΊΙ]ΑΣ|Ϊ́ΑΣ))|ମ(?:ୀଖା[\\s\\xa0]*ଭବିଷ୍ୟ‌ଦ୍‌ବକ୍ତାଙ୍କ[\\s\\xa0]*ପୁସ୍ତକ|ିଖା)|م(?:ِیکاہ|ي|یکاہ)|Liv[\\s\\xa0]*Miche[\\s\\xa0]*a|ミカ(?:しょ|書)?)|Mikas|(?:Mi(?:ikan|che(?:asza)?)|彌(?:迦書》|》)|М(?:іхея|ихе[ийя])|m[īi]k[āa]|弥(?:》|迦书》)|Μιχα[ιί]ας|《(?:弥(?:迦书)?|彌(?:迦書)?|米該亞)|米該亞》|ميخا|ମୀଖା)|(?:弥(?:迦书)?|彌(?:迦書)?|米該亞))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Zech"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:ज(?:क(?:यार्ह|र(?:्याह|िया(?:को[\\s\\xa0]*पुस्तक)?))|ख[रऱ]्या)|ศคย|X(?:ê-?ca-?ri-?a|a-?cha-?ri-?a)|ଯିଖରିୟ[\\s\\xa0]*ଭବିଷ୍ୟ‌ଦ୍‌ବକ୍ତାଙ୍କ[\\s\\xa0]*ପୁସ୍ତକ|Ks(?:i[eę]g(?:[ai][\\s\\xa0]*Zachariasza)|[\\s\\xa0]*Zachariasza|\\.[\\s\\xa0]*Zachariasza)|За(?:х(?:ар(?:ија|і[ий]))?|к(?:ария)?)|Liv[\\s\\xa0]*Zakari[\\s\\xa0]*a|zakar(?:yāh|iyāh)|(?:[セゼ]カリヤ(?:しょ|書)?)|זכריה|Jakaryah|ச(?:கரி(?:யா)?|ெக்(?:கரியா)?)|즈(?:카(?:르야서)?|가리야)|เศคาริยาห์|Ζ(?:χ|α(?:χ(?:αρ[ίι]ας)?)?)|Книга[\\s\\xa0]*(?:Захарі[ії]|пророка[\\s\\xa0]*Захар(?:ія|ии)|на[\\s\\xa0]*пророк[\\s\\xa0]*Захария)|Cakariy[aā]|Z(?:ch?|e(?:k(?:ariah?)?|c(?:h(?:[ae]r(?:i(?:ih|ah?|h)|a(?:[ai]h|h)))?)?)|a(?:ȟarij|c(?:h(?:er(?:i(?:ih|ah?|h)|a(?:[ai]h|h))|ar(?:j[aá][sš]|i(?:ih|á[sš]|[eh]|a[hsš]?)|a(?:[ai]h|h)))?|c(?:aria|h(?:arie)?)?|ar(?:[ií]as)?)?|h(?:ari(?:a|ja?))?|k(?:ari(?:a(?:s['’][\\s\\xa0]*Bog|h)?|ás)|haria|k(?:aariyaasa)?)?)?)|S(?:a(?:c(?:h(?:arja)?|ar[ií]as)|k(?:ar(?:ias?|ía|ja(?:n[\\s\\xa0]*kirja|s[\\s\\xa0]*bok|boken)?))?)|e(?:ch(?:areia)?|k(?:aryaah)?))|슥|《(?:[亚亞]》|匝加利亞》|撒(?:迦利(?:亞(?:書》|》)|亚书》)|加利亞書》))|jak(?:ariy[aā]|ʰary[aā])|ز(?:کریاہ?|َكَرِيّا|ك)|스가랴서?|سفر[\\s\\xa0]*زكريا|Prophetia[\\s\\xa0]*Zachariae|ਜ(?:਼ਕਰ[ਜਯ]ਾਹ|ਕਰਯਾਹ))|(?:撒(?:迦利(?:亞(?:書》?|》)?|亚书》?)|加利亞書》?)|[亚亞]》?|Sakarjan|匝加利亞》?|زكريا|Xa(?:-?cha-?ri)?|《(?:匝加利亞|撒(?:迦利(?:亚书|亞書?)|加利亞書)|[亚亞])|Захар(?:и[яи]|і[їія])|Za(?:chariasza|kari(?:as)?)|ଯିଖରିୟ))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Zeph"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:X(?:ô-?phô-?ni|ê-?pha-?ni-?a)|Ceppa[nṉ]iy[aā]|ṣafaniyāh|ସିଫନିୟ[\\s\\xa0]*ଭବିଷ୍ୟ‌ଦ୍‌ବକ୍ତାଙ୍କ[\\s\\xa0]*ପୁସ୍ତକ|سفر[\\s\\xa0]*صفنيا|《(?:索福尼亞》|番》|西番雅[书書]》)|स(?:फन्या|पन(?:्याह(?:को[\\s\\xa0]*पुस्तक)?)?)|(?:[セゼ](?:ファ(?:ニ(?:ヤ(?:しょ|書)|ア書?))?|[ハパ]ニヤ書))|sa(?:fanyāh|p(?:ʰany[aā]|anyāh))|С(?:ефанија|оф(?:он(?:ія|и(?:ј[ае]|й)))?)|செப்(?:பனியா)?|(?:[ȚŢT]ef(?:ania)?)|Z(?:ph?|of[oó]ni(?:[aá]s)|a(?:phaniah?|faniah?)|e(?:f(?:an(?:ia[hs]?|[jy]a))?|p(?:h(?:an(?:ia[hs]?|aiah?|ja)?)?|anias)?))|ਸਫ਼ਨਯਾਹ|S(?:ô-?phô-?ni-?a|e(?:p(?:anias?|h)|f(?:f(?:aneia)?|an(?:i(?:a(?:s['’][\\s\\xa0]*Bog)?|ja)|yaah|ja(?:n[\\s\\xa0]*kirja|s[\\s\\xa0]*bok)?|ía))?)|f|o(?:f(?:o(?:n(?:j[aá][sš]|ías|aasa|i(?:j[ae]|a[sš]?|á[sš]|e)))?)?|ph(?:oni(?:as|e))?)|z(?:of(?:oni[aá]s)?|efani[aá]s)|apanyah)|Liv[\\s\\xa0]*Sofoni[\\s\\xa0]*an|صف(?:نیاہ)?|Pro(?:roctwo[\\s\\xa0]*Sofoniaszowe|phetia[\\s\\xa0]*Sophoniae)|습|Книга[\\s\\xa0]*(?:пророка[\\s\\xa0]*Софон(?:і[ії]|ии)|на[\\s\\xa0]*пророк[\\s\\xa0]*Софония)|Σ(?:οφον[ίι]ας|φν)|ศฟย|스바(?:니야서?|냐서?)?|เศฟันยาห์|Ks(?:[\\s\\xa0]*Sofoniasza|i[eę]g(?:[ai][\\s\\xa0]*Sofoniasza)|\\.[\\s\\xa0]*Sofoniasza)|צפניה)|(?:sapanyah|西番雅[书書]》?|番》?|Xô|索福尼亞》?|《(?:索福尼亞|西番雅[書书]|番)|صفنيا|Софон(?:и[ия]|і[їі])|ସିଫନିୟ|S(?:efan(?:ias|jan)|ô-?phô-?ni|ofoni(?:asza)?)))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Luke"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(luk[aā]le[\\s\\xa0]*lekʰeko[\\s\\xa0]*susm(?:[aā]c(?:[aā]r))|l(?:uk[aā]ne[\\s\\xa0]*lihilele[\\s\\xa0]*(?:[sŝ]ubʰavartam(?:[aā]n))|ū(?:qā[\\s\\xa0]*kī[\\s\\xa0]*injīl|k(?:ā(?:ne[\\s\\xa0]*lihilele[\\s\\xa0]*[sŝ]ubʰavartam(?:[aā]n)|[\\s\\xa0]*dī[\\s\\xa0]*ĩjīl|le[\\s\\xa0]*lekʰeko[\\s\\xa0]*susm[aā]c(?:[aā]r))|a(?:ne[\\s\\xa0]*lihilele[\\s\\xa0]*[sŝ]ubʰavartam(?:[aā]n)|le[\\s\\xa0]*lekʰeko[\\s\\xa0]*susm[aā]c(?:[aā]r)))))|(?:Євангелі(?:є[\\s\\xa0]*від[\\s\\xa0]*(?:св(?:\\.[\\s\\xa0]*Луки|[\\s\\xa0]*Луки)|Лу(?:ки|[\\s\\xa0]*ки))|я[\\s\\xa0]*від[\\s\\xa0]*(?:св(?:\\.[\\s\\xa0]*Луки|[\\s\\xa0]*Луки)|Луки))|От[\\s\\xa0]*Лука[\\s\\xa0]*свето[\\s\\xa0]*Евангелие|Ungjilli[\\s\\xa0]*i[\\s\\xa0]*Luk[eë]s|Mabuting[\\s\\xa0]*Balita[\\s\\xa0]*ayon[\\s\\xa0]*kay[\\s\\xa0]*(?:San[\\s\\xa0]*Lu[ck]as|Lu[ck]as)|Λ(?:ουκ(?:[άα]ς)?|κ)|누가(?:복음서?)?|《(?:路(?:》|加福音》)|魯喀》)|Л(?:укa|к)|Ł(?:ukasz|k)|E(?:w(?:angelia[\\s\\xa0]*(?:w(?:edług[\\s\\xa0]*(?:[sś]w(?:[\\s\\xa0]*Łukasza|\\.[\\s\\xa0]*Łukasza))|g[\\s\\xa0]*(?:[sś]w(?:[\\s\\xa0]*Łukasza|\\.[\\s\\xa0]*Łukasza)))|Łukasza)|[\\s\\xa0]*Łuk(?:asza)?|\\.[\\s\\xa0]*Łukasza)|van(?:geli(?:um[\\s\\xa0]*(?:podle[\\s\\xa0]*Luk[aá](?:[sš]e)|secundum[\\s\\xa0]*Lucam)|e(?:t[\\s\\xa0]*etter[\\s\\xa0]*Lukas|[\\s\\xa0]*volgens[\\s\\xa0]*Lu[ck]as))|keliumi[\\s\\xa0]*Luukkaan[\\s\\xa0]*mukaan|jelium[\\s\\xa0]*Pod[lľ]a[\\s\\xa0]*Luk(?:[aá](?:[sš]a))|[ðđ]elje[\\s\\xa0]*po[\\s\\xa0]*Luki)|l[\\s\\xa0]*Evangelio[\\s\\xa0]*de[\\s\\xa0]*Lucas|banghelyo[\\s\\xa0]*(?:ayon[\\s\\xa0]*kay[\\s\\xa0]*(?:San[\\s\\xa0]*Lu[ck]as|Lu[ck]as)|ni[\\s\\xa0]*San[\\s\\xa0]*Lu[ck]as))|ଲୂକ[\\s\\xa0]*ଲିଖିତ[\\s\\xa0]*ସୁସମାଗ୍ଭର|ล(?:ูกา|ก)|루카[\\s\\xa0]*복음서?|ل(?:ُوقا[\\s\\xa0]*کی[\\s\\xa0]*انجیل|و(?:قا[\\s\\xa0]*کی[\\s\\xa0]*انجیل)?)|Јеванђеље[\\s\\xa0]*по[\\s\\xa0]*Луки|ल(?:ूक(?:ा(?:को[\\s\\xa0]*सुसमाचार|ले[\\s\\xa0]*लेखेको[\\s\\xa0]*सुसमाचार|ने[\\s\\xa0]*लिहिलेले[\\s\\xa0]*शुभवर्तमान)?)?|ुका)|Sulat[\\s\\xa0]*ni[\\s\\xa0]*San[\\s\\xa0]*Lucas|إنجيل[\\s\\xa0]*لوقا|L(?:ik|ooka|u(?:-?ca|k(?:á(?:cs|(?:[sš](?:ovo[\\s\\xa0]*evangelium)?))|a(?:cs|š(?:ovo[\\s\\xa0]*evangelium)?|s(?:ovo[\\s\\xa0]*evangelium|[\\s\\xa0]*evangelium|arguðspjall|evangeliet))|k[aā][\\s\\xa0]*Na(?:[rṛ]ceyti))|q(?:aasa)?|uk(?:os|kaan[\\s\\xa0]*evankeliumi)?|c)|lu(?:ka)?|c|úk(?:asarguðspjall)?|ūkk[aā][\\s\\xa0]*Na(?:[rṛ]ceyti))?|லூ(?:க்(?:கா[\\s\\xa0]*(?:நற்செய்தி|எழுதிய[\\s\\xa0]*(?:நற்செய்தி|சுவிசேஷம்)))?)?|The[\\s\\xa0]*Gospel[\\s\\xa0]*(?:of[\\s\\xa0]*(?:S(?:aint[\\s\\xa0]*L(?:u(?:ke?)?|k)|t(?:[\\s\\xa0]*L(?:u(?:ke?)?|k)|\\.[\\s\\xa0]*L(?:u(?:ke?)?|k)))|L(?:u(?:ke?)?|k))|according[\\s\\xa0]*to[\\s\\xa0]*(?:S(?:aint[\\s\\xa0]*L(?:u(?:ke?)?|k)|t(?:[\\s\\xa0]*L(?:u(?:ke?)?|k)|\\.[\\s\\xa0]*L(?:u(?:ke?)?|k)))|L(?:u(?:ke?)?|k)))|Κατ[άα][\\s\\xa0]*Λουκ(?:[άα]ν)|הבשורה[\\s\\xa0]*על(?:[\\s\\xa0]*פי[\\s\\xa0]*לוקס|-?פי[\\s\\xa0]*לוק(?:ס|אס))|Vangelo[\\s\\xa0]*di[\\s\\xa0]*(?:Luca|San[\\s\\xa0]*Luca)|Jevan(?:đelje[\\s\\xa0]*po[\\s\\xa0]*Luki|helije[\\s\\xa0]*vid[\\s\\xa0]*Luky)|พระวรสารนักบุญลูค|ルカ(?:による福音書|福音書|傳福音書|[伝書])?|ਲੂਕਾ[\\s\\xa0]*ਦੀ[\\s\\xa0]*ਇੰਜੀਲ|Injil(?:[\\s\\xa0]*Lukas|i[\\s\\xa0]*ya[\\s\\xa0]*Luka)|Еван(?:гелие(?:то[\\s\\xa0]*според[\\s\\xa0]*Лука|[\\s\\xa0]*(?:според[\\s\\xa0]*Лука|от[\\s\\xa0]*Лук[аи]))|ђеље[\\s\\xa0]*по[\\s\\xa0]*Луки))|(?:लूका[नल]े|ਲੂਕਾ|l(?:ūk(?:ā(?:[nl]e)?|a[nl]e)|uk[āa](?:[nl]e))|Від[\\s\\xa0]*Луки|路(?:》|加福音》?)?|S(?:a(?:int[\\s\\xa0]*L(?:u(?:ke?)?|k)|n[\\s\\xa0]*Lucas)|t(?:[\\s\\xa0]*L(?:u(?:ke?)?|k)|\\.[\\s\\xa0]*L(?:u(?:ke?)?|k)))|Łuk|루카|Evangelio[\\s\\xa0]*de[\\s\\xa0]*Lucas|ଲୂକ|Лук[иа]|லூக்கா|От[\\s\\xa0]*Лук[иа]|魯喀》?|ل(?:ُوقا|وقا)|Gospel[\\s\\xa0]*(?:of[\\s\\xa0]*(?:S(?:aint[\\s\\xa0]*L(?:u(?:ke?)?|k)|t(?:[\\s\\xa0]*L(?:u(?:ke?)?|k)|\\.[\\s\\xa0]*L(?:u(?:ke?)?|k)))|L(?:u(?:ke?)?|k))|according[\\s\\xa0]*to[\\s\\xa0]*(?:S(?:aint[\\s\\xa0]*L(?:u(?:ke?)?|k)|t(?:[\\s\\xa0]*L(?:u(?:ke?)?|k)|\\.[\\s\\xa0]*L(?:u(?:ke?)?|k)))|L(?:u(?:ke?)?|k)))|L(?:ūkk[āa]|k|u(?:ukkaan|k(?:á[sš]a|a(?:sa?|ša)?|e|k[aā])?|cas?)?)|《(?:魯喀|路(?:加福音)?)))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Jer"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Yirmayah|(?:ยรม|Јер(?:емија)?|《耶(?:》|利米[书書]》|肋米亞》)|Y(?:ér[eé]mia|er(?:émia|em(?:yaah|ia))?)|J(?:é(?:r(?:[eé]m(?:ie)?)?)?|e(?:r(?:im(?:ah|i(?:[ai]h|h))|m[im]ah|e(?:m(?:eia|j[aá][sš]|a(?:h|i(?:ah|h))|ías?|i(?:ih|á[sš]|e|ha?|ja|a(?:n[\\s\\xa0]*kirja|š|s(?:['’][\\s\\xa0]*Bog|[\\s\\xa0]*bok))?))?)?|ém(?:ie)?|a(?:m(?:a(?:ih|h)|i(?:ih|ah?|ha?))|iah))?)?|r)|Ks(?:i[eę]g(?:[ai][\\s\\xa0]*Jeremiasza)|[\\s\\xa0]*Jeremiasza|\\.[\\s\\xa0]*Jeremiasza)|y(?:irm(?:ay(?:āh?|a)|iyāh)|armiy[aā]ko[\\s\\xa0]*pustak)|Aklat[\\s\\xa0]*ni[\\s\\xa0]*Jeremia[hs]|เยเรมีย(?:าห์|์)|أرميا|ਯਿਰਮਿਯਾਹ|Sulat[\\s\\xa0]*ni[\\s\\xa0]*Jeremias|எரே(?:மியா[\\s\\xa0]*தீர்க்கதரிசியின்[\\s\\xa0]*புத்தகம்)?|Er(?:m(?:maasa)?|[eē]miy[aā])|H[ei]r(?:[ei]m(?:[iy]as))|ار|ஏரே(?:மியா)?|Ер(?:емија)?|G(?:iê-?rê-?mi-?a|er(?:emia)?|r)|ଯିରିମିୟ[\\s\\xa0]*ଭବିଷ୍ୟ‌ଦ୍‌ବକ୍ତାଙ୍କ[\\s\\xa0]*ପୁସ୍ତକ|[ИЙ]ер|Ἰε|سفر[\\s\\xa0]*إرميا|य(?:र्मिया(?:को[\\s\\xa0]*पुस्तक)?|िर्म(?:याह?)?)|エレミヤ書?|ヱレミヤ記|ﺃﺭﻣﻴﺎء|Книга[\\s\\xa0]*(?:пророка[\\s\\xa0]*(?:Єремі[ії]|Иеремии)|на[\\s\\xa0]*пророк[\\s\\xa0]*(?:Еремия|[ИЙ]еремия))|Єр(?:емія)?|예레(?:미(?:야서?|아))?|Ier(?:emias?)?|ירמיהו?|렘|Ιε(?:ρεμ[ίι]ας)?|Li(?:ber[\\s\\xa0]*Ieremiae|v[\\s\\xa0]*Jeremi[\\s\\xa0]*an)|یرم(?:ِیاہ|یاہ))|(?:Єремі[їі]|Иереми[яи]|إرميا|यर्मियाको|Еремия|Jeremi(?:a(?:s(?:za)?|[hn]))?|《耶(?:利米[书書]|肋米亞)?|Йеремия|எரேமியா|Giê(?:-?rê-?mi)?|耶(?:利米[書书]》?|肋米亞》?|》)?|ଯିରିମିୟ|yarmiy[āa]ko))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["2Cor"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])(2[\s\xa0]*Korinterbrevet|(?:2(?:[\s\xa0]*(?:Коринтяни(?:те)?|korint(?:erbrev|ʰ[iī]har(?:[uū]l(?:[aā][iī]))))|\.[\s\xa0]*(?:Коринтяни(?:те)?|Korinterbrevet)|-?(?:ге(?:\.[\s\xa0]*Коринтяни|[\s\xa0]*Коринтяни)|(?:[ае](?:\.[\s\xa0]*Коринтяни|[\s\xa0]*Коринтяни))))|Druh(?:[aá][\s\xa0]*kniha[\s\xa0]*Korin(?:t(?:anom|sk[yý]m)|ťanom))|II(?:\.[\s\xa0]*Коринтяни(?:те)?|[\s\xa0]*Коринтяни(?:те)?)|Друг[ае][\s\xa0]*Коринтяни)|(?:2(?:\.[\s\xa0]*(?:коринтян|korint(?:erbrev|ʰ[iī]har(?:[uū]l(?:[aā][iī]))))|[\s\xa0]*коринтян)|II(?:\.[\s\xa0]*коринтян|[\s\xa0]*коринтян))|(?:கொரிந்தியருக்கு[\s\xa0]*எழுதிய[\s\xa0]*இரண்டா(?:வது[\s\xa0]*(?:நிருபம்|திருமுகம்)|ம்[\s\xa0]*(?:திருமுகம்|கடிதம்))|האיגרת[\s\xa0]*השנייה[\s\xa0]*אל[\s\xa0]*הקורינתים|고린도[2후]서|ଦ୍ୱିତୀୟ[\s\xa0]*କରିନ୍ଥୀୟ(?:ଙ୍କ)?|رسالة[\s\xa0]*بولس[\s\xa0]*الرسول[\s\xa0]*الثانية[\s\xa0]*إلى[\s\xa0]*أهل[\s\xa0]*كورنثوس|M(?:[aá]sodik[\s\xa0]*Kor(?:int(?:usi|hus(?:iakhoz)?))?)|D(?:ru(?:g(?:a[\s\xa0]*(?:poslanica[\s\xa0]*Korinæanima|list[\s\xa0]*do[\s\xa0]*Koryntian|Kor(?:in[cć]anima[\s\xa0]*Poslanica|ynt(?:[oó]w|ian))|List[\s\xa0]*(?:[sś]w(?:\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Koryntian|[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Koryntian)))|i[\s\xa0]*(?:list[\s\xa0]*do[\s\xa0]*Koryntian|Korynt(?:[oó]w|ian)|List[\s\xa0]*(?:[sś]w(?:\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Koryntian|[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Koryntian))))|h(?:(?:[yý](?:K|[\s\xa0]*(?:K(?:orin(?:t(?:anom|sk[yý]m)|ťanom))?|list[\s\xa0]*Korin(?:t(?:anom|sk[yý]m)|ťanom|sk[yý]m))))|e[\s\xa0]*poslannja[\s\xa0]*apostola[\s\xa0]*Pavla[\s\xa0]*do[\s\xa0]*korynfjan|(?:[aá](?:[\s\xa0]*(?:K(?:orin(?:t(?:anom|sk[yý]m)|ťanom))?|list[\s\xa0]*Korin(?:tsk[yý]m|sk[yý]m))|K))))|e(?:zy(?:[eè]m[\s\xa0]*Kor(?:entyen|int))|uxi(?:[eè]me(?:s[\s\xa0]*Corinthiens|[\s\xa0]*Corinthiens))))|Втор(?:а[\s\xa0]*(?:Кор(?:ин(?:т(?:јани|яни(?:те)?)|[кќ]аните))?|писмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Коринт)|о[\s\xa0]*(?:п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Коринт|ослание[\s\xa0]*(?:към[\s\xa0]*коринтяните|на[\s\xa0]*св(?:\.[\s\xa0]*ап(?:\.[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Коринтяни|[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Коринтяни)|[\s\xa0]*ап(?:\.[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Коринтяни|[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Коринтяни))))|Корин(?:[кќ]аните|тјани)))|पौलाचे[\s\xa0]*करिंथकरांस[\s\xa0]*दूसरे[\s\xa0]*पत्र|コリント(?:人への(?:第二の手紙|手紙二|後の書)|[\s\xa0]*2|後書|の信徒への手紙二)|Epistula[\s\xa0]*(?:II[\s\xa0]*ad[\s\xa0]*Corinthios|ad[\s\xa0]*Corinthios[\s\xa0]*II)|Korint(?:iyarukku[\s\xa0]*E[lḻ]utiya[\s\xa0]*Ira(?:[nṇ](?:[tṭ](?:[aā]vatu[\s\xa0]*Nirupam)))|os[\s\xa0]*Labaad)|Naa77antto[\s\xa0]*Qoronttoosa|Προς[\s\xa0]*Κορινθ[ίι]ους[\s\xa0]*Β['ʹʹ΄’]|코린토(?:[\s\xa0]*신자들에게[\s\xa0]*보낸[\s\xa0]*둘째[\s\xa0]*서간|2서)|אגרת[\s\xa0]*פולוס[\s\xa0]*השנייה[\s\xa0]*אל-?הקורינ|《(?:适凌爾福後》|林[后後]》|[格歌]林多後書》|哥林多(?:後書》|后书》))|S(?:ECOND[\s\xa0]*Sulat[\s\xa0]*sa[\s\xa0]*mga[\s\xa0]*Corint(?:io|o)|(?:[ií]ðara[\s\xa0]*(?:br(?:[eé]f[\s\xa0]*P(?:[aá]ls[\s\xa0]*til[\s\xa0]*Kori(?:ntumanna)?))|K[oó]rintubr(?:[eé]f)))|e(?:gund[ao][\s\xa0]*Cor(?:[ií]ntios)|cond(?:o[\s\xa0]*Corinzi|a[\s\xa0]*(?:lettera[\s\xa0]*ai[\s\xa0]*Corinzi|Corinzi)|[\s\xa0]*C(?:hor(?:anthians|nthians|i(?:nth(?:i(?:ns|ans)|ains)|thians))|o(?:r(?:i(?:n(?:ith(?:i(?:nas|ans)|a(?:ns|ins))|t(?:h(?:a(?:i(?:ns|ans)|ns)|o(?:ians|ans)|i(?:ians|n(?:as|s)|a(?:n(?:[ao]s|s)?|[ai]ns)|ons))?|i[ao]ns)?|[an]thians)?|th(?:oans|a(?:ns|ins)|i(?:ians|ns|ans))|inthi(?:ians|ans))|anthians|n(?:i(?:nth(?:ians|a(?:ns|ins))|th(?:ians|a(?:i(?:ns|ans)|ns)))|th(?:ains|i(?:ians|ns|ans)))|ri(?:th(?:ians|ains)|nth(?:ians|ains))|th(?:ians?)?)?)?))))|Zweite[\s\xa0]*Korinther|Β['ʹʹ΄’][\s\xa0]*Κο(?:ρ(?:ινθ(?:[ίι]ους)?)?)|الرسالة[\s\xa0]*الثانية[\s\xa0]*إلى[\s\xa0]*أهل[\s\xa0]*كورنثوس|Barua[\s\xa0]*ya[\s\xa0]*Pili[\s\xa0]*kwa[\s\xa0]*Wakorintho|2(?:d(?:e(?:\.[\s\xa0]*Corinthiens|[\s\xa0]*Corinthiens)|\.[\s\xa0]*Corinthiens|[\s\xa0]*Corinthiens)|۔کرنتھیوں|كو|ème(?:\.[\s\xa0]*Corinthiens|[\s\xa0]*Corinthiens)|nd(?:[\s\xa0]*C(?:hor(?:anthians|nthians|i(?:nth(?:i(?:ns|ans)|ains)|thians))|o(?:r(?:i(?:n(?:ith(?:i(?:nas|ans)|a(?:ns|ins))|t(?:h(?:a(?:i(?:ns|ans)|ns)|o(?:ians|ans)|i(?:ians|n(?:as|s)|a(?:n(?:[ao]s|s)?|[ai]ns)|ons))?|i[ao]ns)?|[an]thians)?|th(?:oans|a(?:ns|ins)|i(?:ians|ns|ans))|inthi(?:ians|ans))|anthians|n(?:i(?:nth(?:ians|a(?:ns|ins))|th(?:ians|a(?:i(?:ns|ans)|ns)))|th(?:ains|i(?:ians|ns|ans)))|ri(?:th(?:ians|ains)|nth(?:ians|ains))|th(?:ians?)?)?)?)|\.[\s\xa0]*C(?:hor(?:anthians|nthians|i(?:nth(?:i(?:ns|ans)|ains)|thians))|o(?:r(?:i(?:n(?:ith(?:i(?:nas|ans)|a(?:ns|ins))|t(?:h(?:a(?:i(?:ns|ans)|ns)|o(?:ians|ans)|i(?:ians|n(?:as|s)|a(?:n(?:[ao]s|s)?|[ai]ns)|ons))?|i[ao]ns)?|[an]thians)?|th(?:oans|a(?:ns|ins)|i(?:ians|ns|ans))|inthi(?:ians|ans))|anthians|n(?:i(?:nth(?:ians|a(?:ns|ins))|th(?:ians|a(?:i(?:ns|ans)|ns)))|th(?:ains|i(?:ians|ns|ans)))|ri(?:th(?:ians|ains)|nth(?:ians|ains))|th(?:ians?)?)?)?))|(?:[яе](?:\.[\s\xa0]*(?:Коринфянам|к[\s\xa0]*Коринфянам)|[\s\xa0]*(?:Коринфянам|к[\s\xa0]*Коринфянам)))|-?(?:کُرِنتھِیوں|я(?:\.[\s\xa0]*(?:Коринфянам|к[\s\xa0]*Коринфянам)|[\s\xa0]*(?:Коринфянам|к[\s\xa0]*Коринфянам))|е(?:[\s\xa0]*(?:к(?:оринтян|[\s\xa0]*Коринфянам)|Коринфян(?:ам)?|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|послання[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян)|\.[\s\xa0]*(?:к(?:оринтян|[\s\xa0]*Коринфянам)|Коринфян(?:ам)?|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|послання[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян))|а(?:\.[\s\xa0]*(?:Коринфян|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|коринтян|послання[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян)|[\s\xa0]*(?:Коринфян|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|коринтян|послання[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян))|ге(?:\.[\s\xa0]*(?:Коринфян|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|коринтян|послання[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян)|[\s\xa0]*(?:Коринфян|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|коринтян|послання[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян)))|코린|º(?:[\s\xa0]*Corintios|\.[\s\xa0]*Corintios)|[ao](?:[\s\xa0]*Cor(?:[ií]ntios|\.[\s\xa0]*Cor[ií]ntios))|°(?:[\s\xa0]*Corinzi|\.[\s\xa0]*Corinzi)|e(?:[\s\xa0]*(?:Corint(?:i[eë]rs?|h(?:i(?:ërs?|e(?:rs?|ns))|e))|Kor(?:int(?:i[eë]rs?|h(?:i[eë]rs?|e)))?)|me(?:\.[\s\xa0]*Corinthiens|[\s\xa0]*Corinthiens)|\.[\s\xa0]*(?:Corint(?:i[eë]rs?|h(?:i(?:ërs?|e(?:rs?|ns))|e))|Kor(?:int(?:i[eë]rs?|h(?:i[eë]rs?|e)))?))|[CK]or|\.(?:-?کُرِنتھِیوں|۔کرنتھیوں|[\s\xa0]*(?:Кор(?:ин(?:фян(?:ам)?|[кќ]аните|тјани|ћанима))?|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Коринт|ослан(?:ица[\s\xa0]*Коринћанима|ня[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян))|โครินธ์|list[\s\xa0]*(?:do[\s\xa0]*Koryntian|Korin(?:tsk[yý]m|sk[yý]m))|କରିନ୍ଥୀୟ(?:ଙ୍କ)?|Mga[\s\xa0]*Taga(?:[\s\xa0]*Corinto|-?(?:[\s\xa0]*Corinto|Corinto))|Taga-?Corinto|क(?:ोरिन्(?:थी(?:हरूलाई)?|‍थी)|ुर(?:िन्(?:यि़यों|थ(?:ियों?)?)|न्थियों))|List[\s\xa0]*(?:[sś]w(?:\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Koryntian|[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Koryntian))|к[\s\xa0]*Коринфянам|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|K(?:or(?:i(?:n(?:t(?:er(?:ne)?|usi?|a(?:nom|sve)?|i(?:ërs?|er(?:brevet|s|ne)?|o)|os?|h(?:us(?:iakhoz)?|e(?:r(?:brev(?:et)?)?)?|i(?:ërs?|er(?:brevet|s)?))|t(?:ilaisille|olaiskirje)|sk[yý]m)?|ťanom|[cć]anima[\s\xa0]*Poslanica)|tasve)|entyen|ynt(?:[oó]w|ian))?|irje[\s\xa0]*korinttilaisille|urinthiayon)|Wakorint(?:ho|o)|C(?:o(?:r(?:anthians|n(?:i(?:nth(?:ians|a(?:ns|ins))|th(?:ians|a(?:i(?:ns|ans)|ns)))|th(?:ains|i(?:ians|ns|ans)))|i(?:th(?:oans|a(?:ns|ins)|i(?:ians|ns|ans))|inthi(?:ians|ans)|n(?:ith(?:i(?:nas|ans)|a(?:ns|ins))|zi|t(?:i(?:ërs?|e(?:ni|rs?)|o(?:ns|s)?|ans)|eni|o|h(?:a(?:i(?:ns|ans)|ns)|o(?:ians|ans)|e|i(?:ians|ërs?|a(?:i(?:ns|d)|n(?:[ao]s|s)?|ans)|e(?:rs?|ns)|n(?:as|s)|o(?:ns|s)))?)?|[an]thians)?)|ri(?:th(?:ians|ains)|nth(?:ians|ains))|íntios|th(?:ians?)?)?)?|ô(?:-?rinh-?tô|rintô)|hor(?:anthians|nthians|i(?:nth(?:i(?:ns|ans)|ains)|thians)))|ک(?:ُرنتھِیوں|رنتھ(?:ِیُوں|یوں)))|(?:[oº](?:[\s\xa0]*Corintios|\.[\s\xa0]*Corintios)))|[\s\xa0]*(?:Кор(?:ин(?:фян(?:ам)?|[кќ]аните|тјани|ћанима))?|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Коринт|ослан(?:ица[\s\xa0]*Коринћанима|ня[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян))|โครินธ์|list[\s\xa0]*(?:do[\s\xa0]*Koryntian|Korin(?:tsk[yý]m|sk[yý]m))|କରିନ୍ଥୀୟ(?:ଙ୍କ)?|Mga[\s\xa0]*Taga(?:[\s\xa0]*Corinto|-?(?:[\s\xa0]*Corinto|Corinto))|Taga-?Corinto|K(?:irje[\s\xa0]*korinttilaisille|urinthiayon|or(?:entyen|i(?:n(?:ťanom|[cć]anima[\s\xa0]*Poslanica|t(?:er(?:ne)?|usi?|a(?:nom|sve)?|os?|h(?:us(?:iakhoz)?|e(?:r(?:brev(?:et)?)?)?|i(?:ërs?|er(?:brevet|s)?))|t(?:ilaisille|olaiskirje)|sk[yý]m|i(?:ërs?|yarukku|er(?:brevet|s|ne)?|o))?)|tasve)|ynt(?:[oó]w|ian))?)|List[\s\xa0]*(?:[sś]w(?:\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Koryntian|[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Koryntian))|к[\s\xa0]*Коринфянам|(?:[ei](?:\.[\s\xa0]*Kori(?:ntasve|tasve)|[\s\xa0]*Kori(?:ntasve|tasve)))|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|Wakorint(?:ho|o)|ਕੁਰਿੰਥੀਆਂ[\s\xa0]*ਨੂੰ|قور|क(?:ोरिन्(?:थी(?:हरूलाई)?|‍थी)|रिंथकरांस|ुर(?:िन्(?:यि़यों|थ(?:ियों?)?)|न्थियों))|ค[ธร]|C(?:o(?:r(?:anthians|n(?:i(?:nth(?:ians|a(?:ns|ins))|th(?:ians|a(?:i(?:ns|ans)|ns)))|th(?:ains|i(?:ians|ns|ans)))|i(?:th(?:oans|a(?:ns|ins)|i(?:ians|ns|ans))|inthi(?:ians|ans)|n(?:i(?:th(?:i(?:nas|ans)|a(?:ns|ins)))?|zi|t(?:i(?:ërs?|e(?:ni|rs?)|o(?:ns|s)?|ans)?|eni|o|h(?:a(?:i(?:ns|ans)|ns)|o(?:ians|ans)|e|i(?:ians|ërs?|a(?:i(?:ns|d)|n(?:[ao]s|s)?|ans)|e(?:rs?|ns)|n(?:as|s)|o(?:ns|s)))?)?|[an]thians)?)|ri(?:th(?:ians|ains)|nth(?:ians|ains))|íntios|th(?:ians?)?)?)?|ô(?:-?rinh-?tô|rintô)|hor(?:anthians|nthians|i(?:nth(?:i(?:ns|ans)|ains)|thians)))|k(?:urĩtʰīāṃ|\.[\s\xa0]*Korin(?:t(?:anom|sk[yý]m)|ťanom)|ari[mṃ]tʰkar(?:[aā](?:[mṃ]s))|[\s\xa0]*Korin(?:t(?:anom|sk[yý]m)|ťanom))|ک(?:ُرنتھِیوں|رنتھ(?:ِیُوں|یوں))|Qor|கொ(?:ரி(?:ந்தியர்)?)?))|كورنثوس[\s\xa0]*الثانية|Wa(?:raka[\s\xa0]*wa[\s\xa0]*Pili[\s\xa0]*kwa[\s\xa0]*Wakorint(?:ho|o)|korintho[\s\xa0]*II)|دوم(?:-?کُرِنتھِیوں|۔کرنتھیوں|[\s\xa0]*ک(?:ُرنتھِیوں|رنتھ(?:ِیُوں|یوں)))|ک(?:ُرِنتھِیوں[\s\xa0]*کے[\s\xa0]*نام[\s\xa0]*کا[\s\xa0]*دوسرا[\s\xa0]*خط|رنتھ(?:ِیُوں[\s\xa0]*کے[\s\xa0]*نام[\s\xa0]*پولس[\s\xa0]*رسول[\s\xa0]*کا[\s\xa0]*دوسرا[\s\xa0]*خط|یوں[\s\xa0]*کے[\s\xa0]*نام[\s\xa0]*کا[\s\xa0]*دوسرا[\s\xa0]*خط))|۲(?:-?کُرِنتھِیوں|۔کرنتھیوں|[\s\xa0]*ک(?:ُرنتھِیوں|رنتھ(?:ِیُوں|یوں)))|କରିନ୍ଥୀୟଙ୍କ[\s\xa0]*ପ୍ରତି[\s\xa0]*ଦ୍ୱିତୀୟ[\s\xa0]*ପତ୍ର|k(?:orintʰ[iī]har(?:[uū]l(?:[aā](?:[iī][\s\xa0]*dostro[\s\xa0]*patra)))|ur(?:intʰiyōṅ[\s\xa0]*ke[\s\xa0]*nām[\s\xa0]*kā[\s\xa0]*dūsrā[\s\xa0]*ḫaṭ|ĩtʰīāṃ[\s\xa0]*nū̃[\s\xa0]*dūjī[\s\xa0]*pattrī)|ari[mṃ]tʰkar(?:[aā](?:[mṃ]s[\s\xa0]*dusre[\s\xa0]*patra)))|ਕੁਰਿੰਥੀਆਂ[\s\xa0]*ਨੂੰ[\s\xa0]*ਦੂਜੀ[\s\xa0]*ਪੱਤ੍ਰੀ|P(?:ili[\s\xa0]*(?:Wakorint(?:ho|o)|Kor)|a(?:ulus(?:'[\s\xa0]*Andet[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Korintherne|’[\s\xa0]*(?:Andet[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Korintherne|andre[\s\xa0]*brev[\s\xa0]*til[\s\xa0]*korinterne))|vlova[\s\xa0]*druga[\s\xa0]*poslanica[\s\xa0]*Korin[cć]anima))|And(?:r(?:e[\s\xa0]*(?:korinterbrev|Kor(?:int(?:er|ierne))?)|a[\s\xa0]*Korint(?:h(?:ierbrevet|erbrevet)|ierbrevet|erbrevet))|e(?:n[\s\xa0]*Kor(?:int(?:erne|herbrev))?|t[\s\xa0]*Korintherbrev))|I(?:I(?:[\s\xa0]*(?:Mga[\s\xa0]*Taga(?:-?[\s\xa0]*Corinto|[\s\xa0]*Corinto)|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Коринт|ослан(?:ица[\s\xa0]*Коринћанима|ня[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян))|Кор(?:ин(?:[кќ]аните|фян|тјани|ћанима))?|list[\s\xa0]*(?:do[\s\xa0]*Koryntian|Korin(?:tsk[yý]m|sk[yý]m))|K(?:irje[\s\xa0]*korinttilaisille|or(?:in(?:t(?:i(?:[eë]rs?|o)|a(?:nom)?|usi?|os?|h(?:us(?:iakhoz)?|i[eë]rs?|e)|t(?:ilaisille|olaiskirje)|sk[yý]m)?|ťanom|[cć]anima[\s\xa0]*Poslanica)|entyen|ynt(?:[oó]w|ian))?)|List[\s\xa0]*(?:[sś]w(?:\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Koryntian|[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Koryntian))|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|Wakorint(?:ho|o)|C(?:o(?:r(?:anthians|n(?:i(?:nth(?:ians|a(?:ns|ins))|th(?:ians|a(?:i(?:ns|ans)|ns)))|th(?:ains|i(?:ians|ns|ans)))|i(?:th(?:oans|a(?:ns|ins)|i(?:ians|ns|ans))|inthi(?:ians|ans)|n(?:ith(?:i(?:nas|ans)|a(?:ns|ins))|zi|t(?:i(?:ërs?|e(?:ni|rs?)|o(?:ns|s)?|ans)|eni|o|h(?:a(?:i(?:ns|ans)|ns)|o(?:ians|ans)|e|i(?:ians|ërs?|a(?:i(?:ns|d)|n(?:[ao]s|s)?|ans)|e(?:rs?|ns)|n(?:as|s)|o(?:ns|s)))?)?|[an]thians)?)|ri(?:th(?:ians|ains)|nth(?:ians|ains))|íntios|th(?:ians?)?)?)?|ô(?:-?rinh-?tô|rintô)|hor(?:anthians|nthians|i(?:nth(?:i(?:ns|ans)|ains)|thians))))|\.[\s\xa0]*(?:Mga[\s\xa0]*Taga(?:-?[\s\xa0]*Corinto|[\s\xa0]*Corinto)|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Коринт|ослан(?:ица[\s\xa0]*Коринћанима|ня[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян))|Кор(?:ин(?:[кќ]аните|фян|тјани|ћанима))?|list[\s\xa0]*(?:do[\s\xa0]*Koryntian|Korin(?:tsk[yý]m|sk[yý]m))|K(?:irje[\s\xa0]*korinttilaisille|or(?:in(?:t(?:i(?:[eë]rs?|o)|a(?:nom)?|usi?|os?|h(?:us(?:iakhoz)?|i[eë]rs?|e)|t(?:ilaisille|olaiskirje)|sk[yý]m)?|ťanom|[cć]anima[\s\xa0]*Poslanica)|entyen|ynt(?:[oó]w|ian))?)|List[\s\xa0]*(?:[sś]w(?:\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Koryntian|[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Koryntian))|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|Wakorint(?:ho|o)|C(?:o(?:r(?:anthians|n(?:i(?:nth(?:ians|a(?:ns|ins))|th(?:ians|a(?:i(?:ns|ans)|ns)))|th(?:ains|i(?:ians|ns|ans)))|i(?:th(?:oans|a(?:ns|ins)|i(?:ians|ns|ans))|inthi(?:ians|ans)|n(?:ith(?:i(?:nas|ans)|a(?:ns|ins))|zi|t(?:i(?:ërs?|e(?:ni|rs?)|o(?:ns|s)?|ans)|eni|o|h(?:a(?:i(?:ns|ans)|ns)|o(?:ians|ans)|e|i(?:ians|ërs?|a(?:i(?:ns|d)|n(?:[ao]s|s)?|ans)|e(?:rs?|ns)|n(?:as|s)|o(?:ns|s)))?)?|[an]thians)?)|ri(?:th(?:ians|ains)|nth(?:ians|ains))|íntios|th(?:ians?)?)?)?|ô(?:-?rinh-?tô|rintô)|hor(?:anthians|nthians|i(?:nth(?:i(?:ns|ans)|ains)|thians)))))|ka(?:lawang[\s\xa0]*(?:Mga[\s\xa0]*Taga(?:-?[\s\xa0]*Corinto|[\s\xa0]*Corinto)|(?:[CK]orint(?:io|o)))|[\s\xa0]*2[\s\xa0]*Sulat[\s\xa0]*sa[\s\xa0]*mga[\s\xa0]*Corint(?:io|o)|-?[\s\xa0]*2[\s\xa0]*Sulat[\s\xa0]*sa[\s\xa0]*mga[\s\xa0]*Corint(?:io|o)))|T(?:weede[\s\xa0]*(?:Corint(?:i[eë]rs?|h(?:i[eë]rs?|e))|Kor(?:int(?:i[eë]rs?|h(?:i[eë]rs?|e)))?)|oinen[\s\xa0]*K(?:orintt(?:ilaisille|olaiskirje)|irje[\s\xa0]*korinttilaisille))|Друг(?:а[\s\xa0]*(?:Корин(?:фян|ћанима)|послан(?:ица[\s\xa0]*Коринћанима|ня[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян)|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|коринтян)|е[\s\xa0]*(?:Коринфян|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|коринтян|послання[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян))|क(?:रिंथकरांस[\s\xa0]*दुसरे[\s\xa0]*पत्र|ोरिन्थीहरूलाई[\s\xa0]*(?:पावलको[\s\xa0]*दोस्रो[\s\xa0]*पत्र|दोस्त्रो[\s\xa0]*पत्र)))|(?:2[ao]\.[\s\xa0]*Cor(?:[ií]ntios)|Β['ʹʹ΄’][\s\xa0]*Κο)|(?:《(?:哥林多(?:后书|後書)|[格歌]林多後書|适凌爾福後|林[後后])|林[後后]》?|适凌爾福後》?|ad[\s\xa0]*Corinthios[\s\xa0]*II|哥林多(?:後書》?|后书》?)|2(?:\.[\s\xa0]*(?:Korin[ćc]anima|Cô(?:-?rinh)?)|[\s\xa0]*(?:Korin[cć]anima|ਕੁਰਿੰਥੀਆਂ|Cô(?:-?rinh)?))|Corinthios[\s\xa0]*II|II(?:[\s\xa0]*(?:Korin[cć]anima|Cô(?:-?rinh)?)|\.[\s\xa0]*(?:Korin[cć]anima|Cô(?:-?rinh)?))|Druga[\s\xa0]*(?:poslanica[\s\xa0]*Korin[cć]anima|Korin[cć]anima)|[格歌]林多後書》?|השנייה[\s\xa0]*אל[\s\xa0]*הקורינתים))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["1Cor"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])(1[\s\xa0]*Korinterbrevet|(?:Første[\s\xa0]*korinterbrev|1(?:[\s\xa0]*(?:Коринтяни(?:те)?|korint(?:erbrev|ʰ[iī]har(?:[uū]l(?:[aā][iī]))))|-?(?:ше(?:\.[\s\xa0]*Коринтяни|[\s\xa0]*Коринтяни)|(?:[ае](?:\.[\s\xa0]*Коринтяни|[\s\xa0]*Коринтяни)))|\.[\s\xa0]*(?:Коринтяни(?:те)?|Korinterbrevet))|I(?:\.[\s\xa0]*Коринтяни(?:те)?|[\s\xa0]*Коринтяни(?:те)?)|Перш[ае][\s\xa0]*Коринтяни)|(?:I(?:\.[\s\xa0]*коринтян|[\s\xa0]*коринтян)|1(?:\.[\s\xa0]*(?:коринтян|korint(?:erbrev|ʰ[iī]har(?:[uū]l(?:[aā][iī]))))|[\s\xa0]*коринтян))|(?:《(?:林前》|适凌爾福前》|哥林多前[书書]》|[格歌]林多前書》)|Barua[\s\xa0]*ya[\s\xa0]*Kwanza[\s\xa0]*kwa[\s\xa0]*Wakorintho|ପ୍ରଥମ[\s\xa0]*କରିନ୍ଥୀୟ(?:ଙ୍କ)?|ﻛﻮﺭﻧﺜﻮﺱ[\s\xa0]*ﺍﻻﻭﻝ|אגרת[\s\xa0]*פולוס[\s\xa0]*הראשונה[\s\xa0]*אל-?הקורי|האיגרת[\s\xa0]*הראשונה[\s\xa0]*אל[\s\xa0]*הקורינתים|कोरिन्थीहरूलाई[\s\xa0]*प(?:हिलो[\s\xa0]*पत्र|ावलको[\s\xa0]*पहिलो[\s\xa0]*पत्र)|고린도[1전]서|E(?:erste[\s\xa0]*(?:Corint(?:i[eë]rs?|h(?:i[eë]rs?|e))|Kor(?:int(?:i[eë]rs?|h(?:i[eë]rs?|e)))?)|pistula[\s\xa0]*(?:ad[\s\xa0]*Corinthios[\s\xa0]*I|I[\s\xa0]*ad[\s\xa0]*Corinthios)|ls(?:[oő][\s\xa0]*Kor(?:int(?:usi|hus(?:iakhoz)?))?)|nsimm(?:[aä]inen[\s\xa0]*K(?:orintt(?:ilaisille|olaiskirje)|irje[\s\xa0]*korinttilaisille))|rste[\s\xa0]*Korinther)|P(?:a(?:vlova[\s\xa0]*prva[\s\xa0]*poslanica[\s\xa0]*Korin[cć]anima|ulus(?:'[\s\xa0]*(?:1(?:\.[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Korintherne|[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Korintherne)|Første[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Korintherne)|’[\s\xa0]*(?:1(?:\.[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Korintherne|[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Korintherne)|Første[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Korintherne|første[\s\xa0]*brev[\s\xa0]*til[\s\xa0]*korinterne)))|r(?:im(?:e(?:ir[ao][\s\xa0]*Cor(?:[ií]ntios)|r(?:[\s\xa0]*Corintios|o[\s\xa0]*Corintios))|o[\s\xa0]*Corinzi|a[\s\xa0]*(?:lettera[\s\xa0]*ai[\s\xa0]*Corinzi|Corinzi))|v(?:a[\s\xa0]*(?:poslanica[\s\xa0]*Korinæanima|Korin(?:t(?:anom|sk[yý]m)|ťanom|[cć]anima[\s\xa0]*Poslanica)|kniha[\s\xa0]*Korin(?:t(?:anom|sk[yý]m)|ťanom))|n[ií](?:[\s\xa0]*(?:K(?:or(?:intsk(?:[yý]m)?)?|list[\s\xa0]*Korin(?:tsk[yý]m|sk[yý]m))|K))|á[\s\xa0]*(?:Korin(?:t(?:anom|sk[yý]m)|ťanom)|kniha[\s\xa0]*Korin(?:t(?:anom|sk[yý]m)|ťanom))|(?:[yý][\s\xa0]*(?:Korin(?:t(?:anom|sk[yý]m)|ťanom)|list[\s\xa0]*Korin(?:t(?:anom|sk[yý]m)|ťanom))))|em(?:ye[\s\xa0]*Kor(?:entyen|int)|i(?:er(?:e(?:s[\s\xa0]*Corinthiens|[\s\xa0]*Corinthiens)|s[\s\xa0]*Corinthiens|[\s\xa0]*Corinthiens)|ère(?:s[\s\xa0]*Corinthiens|[\s\xa0]*Corinthiens))))|ierwsz(?:[aey][\s\xa0]*(?:list[\s\xa0]*do[\s\xa0]*Koryntian|Korynt(?:[oó]w|ian)|List[\s\xa0]*(?:[sś]w(?:\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Koryntian|[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Koryntian))))|er[sš]e[\s\xa0]*poslannja[\s\xa0]*apostola[\s\xa0]*Pavla[\s\xa0]*do[\s\xa0]*korynfjan)|۱(?:-?کُرِنتھِیوں|۔کرنتھیوں|[\s\xa0]*ک(?:ُرنتھِیوں|رنتھِیُوں))|Α['ʹʹ΄’][\s\xa0]*Κο(?:ρ(?:ινθ(?:[ίι]ους)?)?)|كورنثوس[\s\xa0]*الأولى|П(?:ерш(?:[ае][\s\xa0]*(?:Коринфян|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|коринтян|послання[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян))|рв(?:о[\s\xa0]*(?:Корин(?:[кќ]аните|тјани)|писмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Коринт)|а[\s\xa0]*(?:п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Коринт|осланица[\s\xa0]*Коринћанима)|Корин(?:[кќ]аните|тјани|ћанима)))|ърв(?:о[\s\xa0]*послание[\s\xa0]*(?:към[\s\xa0]*коринтяните|на[\s\xa0]*св(?:\.[\s\xa0]*ап(?:\.[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Коринтяни|[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Коринтяни)|[\s\xa0]*ап(?:\.[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Коринтяни|[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Коринтяни)))|а[\s\xa0]*Кор(?:интяни(?:те)?)?))|F(?:ørste[\s\xa0]*Kor(?:int(?:er(?:ne)?|herbrev|ierne))?|(?:[oö]rsta[\s\xa0]*Korint(?:h(?:ierbrevet|erbrevet)|ierbrevet|erbrevet))|yrra[\s\xa0]*(?:Korintubr[eé]f|br(?:[eé]f[\s\xa0]*P(?:[aá]ls[\s\xa0]*til[\s\xa0]*Korin(?:tumanna)?)))|irst[\s\xa0]*C(?:hor(?:anthians|nthians|i(?:nth(?:i(?:ns|ans)|ains)|thians))|o(?:r(?:i(?:n(?:ith(?:i(?:nas|ans)|a(?:ns|ins))|t(?:h(?:a(?:i(?:ns|ans)|ns)|o(?:ians|ans)|i(?:ians|n(?:as|s)|a(?:n(?:[ao]s|s)?|[ai]ns)|ons))?|i[ao]ns)?|[an]thians)?|th(?:oans|a(?:ns|ins)|i(?:ians|ns|ans))|inthi(?:ians|ans))|anthians|n(?:i(?:nth(?:ians|a(?:ns|ins))|th(?:ians|a(?:i(?:ns|ans)|ns)))|th(?:ains|i(?:ians|ns|ans)))|ri(?:th(?:ians|ains)|nth(?:ians|ains))|th(?:ians?)?)?)?))|ا(?:لرسالة[\s\xa0]*الأولى[\s\xa0]*إلى[\s\xa0]*أهل[\s\xa0]*كورنثوس|وّل(?:-?کُرِنتھِیوں|۔کرنتھیوں|[\s\xa0]*ک(?:ُرنتھِیوں|رنتھِیُوں)))|Wa(?:raka[\s\xa0]*wa[\s\xa0]*Kwanza[\s\xa0]*kwa[\s\xa0]*Wakorint(?:ho|o)|korintho[\s\xa0]*I)|கொரிந்தியருக்கு[\s\xa0]*எழுதிய[\s\xa0]*முதல(?:்[\s\xa0]*திருமுகம்|ா(?:வது[\s\xa0]*(?:நிருபம்|திருமுகம்)|ம்))|k(?:orintʰ[iī]har(?:[uū]l(?:[aā](?:[iī][\s\xa0]*pahilo[\s\xa0]*patra)))|ari[mṃ]tʰkar(?:[aā](?:[mṃ]s[\s\xa0]*pahile[\s\xa0]*patra))|ur(?:ĩtʰīāṃ[\s\xa0]*nū̃[\s\xa0]*pahilī[\s\xa0]*pattrī|intʰiyōṅ[\s\xa0]*ke[\s\xa0]*nām[\s\xa0]*kā[\s\xa0]*pahlā[\s\xa0]*ḫaṭ))|I(?:\.[\s\xa0]*(?:Mga[\s\xa0]*Taga(?:-?[\s\xa0]*Corinto|[\s\xa0]*Corinto)|Sulat[\s\xa0]*sa[\s\xa0]*mga[\s\xa0]*Corint(?:io|o)|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Коринт|ослан(?:ица[\s\xa0]*Коринћанима|ня[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян))|Кор(?:ин(?:[кќ]аните|фян|тјани|ћанима))?|list[\s\xa0]*(?:do[\s\xa0]*Koryntian|Korin(?:tsk[yý]m|sk[yý]m))|K(?:irje[\s\xa0]*korinttilaisille|or(?:in(?:t(?:i(?:[eë]rs?|o)|a(?:nom)?|usi?|os?|h(?:us(?:iakhoz)?|i[eë]rs?|e)|t(?:ilaisille|olaiskirje)|sk[yý]m)?|ťanom|[cć]anima[\s\xa0]*Poslanica)|entyen|ynt(?:[oó]w|ian))?)|List[\s\xa0]*(?:[sś]w(?:\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Koryntian|[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Koryntian))|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|Wakorint(?:ho|o)|C(?:o(?:r(?:anthians|n(?:i(?:nth(?:ians|a(?:ns|ins))|th(?:ians|a(?:i(?:ns|ans)|ns)))|th(?:ains|i(?:ians|ns|ans)))|i(?:th(?:oans|a(?:ns|ins)|i(?:ians|ns|ans))|inthi(?:ians|ans)|n(?:ith(?:i(?:nas|ans)|a(?:ns|ins))|zi|t(?:i(?:ërs?|e(?:ni|rs?)|o(?:ns|s)?|ans)|eni|o|h(?:a(?:i(?:ns|ans)|ns)|o(?:ians|ans)|e|i(?:ians|ërs?|a(?:i(?:ns|d)|n(?:[ao]s|s)?|ans)|e(?:rs?|ns)|n(?:as|s)|o(?:ns|s)))?)?|[an]thians)?)|ri(?:th(?:ians|ains)|nth(?:ians|ains))|íntios|th(?:ians?)?)?)?|ô(?:-?rinh-?tô|rintô)|hor(?:anthians|nthians|i(?:nth(?:i(?:ns|ans)|ains)|thians))))|[\s\xa0]*(?:Mga[\s\xa0]*Taga(?:-?[\s\xa0]*Corinto|[\s\xa0]*Corinto)|Sulat[\s\xa0]*sa[\s\xa0]*mga[\s\xa0]*Corint(?:io|o)|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Коринт|ослан(?:ица[\s\xa0]*Коринћанима|ня[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян))|Кор(?:ин(?:[кќ]аните|фян|тјани|ћанима))?|list[\s\xa0]*(?:do[\s\xa0]*Koryntian|Korin(?:tsk[yý]m|sk[yý]m))|K(?:irje[\s\xa0]*korinttilaisille|or(?:in(?:t(?:i(?:[eë]rs?|o)|a(?:nom)?|usi?|os?|h(?:us(?:iakhoz)?|i[eë]rs?|e)|t(?:ilaisille|olaiskirje)|sk[yý]m)?|ťanom|[cć]anima[\s\xa0]*Poslanica)|entyen|ynt(?:[oó]w|ian))?)|List[\s\xa0]*(?:[sś]w(?:\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Koryntian|[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Koryntian))|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|Wakorint(?:ho|o)|C(?:o(?:r(?:anthians|n(?:i(?:nth(?:ians|a(?:ns|ins))|th(?:ians|a(?:i(?:ns|ans)|ns)))|th(?:ains|i(?:ians|ns|ans)))|i(?:th(?:oans|a(?:ns|ins)|i(?:ians|ns|ans))|inthi(?:ians|ans)|n(?:ith(?:i(?:nas|ans)|a(?:ns|ins))|zi|t(?:i(?:ërs?|e(?:ni|rs?)|o(?:ns|s)?|ans)|eni|o|h(?:a(?:i(?:ns|ans)|ns)|o(?:ians|ans)|e|i(?:ians|ërs?|a(?:i(?:ns|d)|n(?:[ao]s|s)?|ans)|e(?:rs?|ns)|n(?:as|s)|o(?:ns|s)))?)?|[an]thians)?)|ri(?:th(?:ians|ains)|nth(?:ians|ains))|íntios|th(?:ians?)?)?)?|ô(?:-?rinh-?tô|rintô)|hor(?:anthians|nthians|i(?:nth(?:i(?:ns|ans)|ains)|thians))))|ka(?:[\s\xa0]*1[\s\xa0]*Sulat[\s\xa0]*sa[\s\xa0]*mga[\s\xa0]*Corint(?:io|o)|-?[\s\xa0]*1[\s\xa0]*Sulat[\s\xa0]*sa[\s\xa0]*mga[\s\xa0]*Corint(?:io|o)))|K(?:wanza[\s\xa0]*(?:Wakorint(?:ho|o)|Kor)|o(?:rint(?:iyarukku[\s\xa0]*E[lḻ]utiya[\s\xa0]*Mutal(?:[aā]vatu[\s\xa0]*Nirupam)|os[\s\xa0]*Kowaad)|iro[\s\xa0]*Qoronttoosa))|رسالة[\s\xa0]*بولس[\s\xa0]*الرسول[\s\xa0]*الأولى[\s\xa0]*إلى[\s\xa0]*أهل[\s\xa0]*كورنثوس|1(?:۔کرنتھیوں|كو|re(?:\.[\s\xa0]*Corinthiens|[\s\xa0]*Corinthiens)|(?:[яе](?:\.[\s\xa0]*(?:Коринфянам|к[\s\xa0]*Коринфянам)|[\s\xa0]*(?:Коринфянам|к[\s\xa0]*Коринфянам)))|[\s\xa0]*(?:Кор(?:ин(?:фян(?:ам)?|[кќ]аните|тјани|ћанима))?|ک(?:ُرنتھِیوں|رنتھِیُوں)|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Коринт|ослан(?:ица[\s\xa0]*Коринћанима|ня[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян))|โครินธ์|list[\s\xa0]*(?:do[\s\xa0]*Koryntian|Korin(?:tsk[yý]m|sk[yý]m))|କରିନ୍ଥୀୟ(?:ଙ୍କ)?|Mga[\s\xa0]*Taga(?:[\s\xa0]*Corinto|-?(?:[\s\xa0]*Corinto|Corinto))|Taga-?Corinto|K(?:irje[\s\xa0]*korinttilaisille|urinthiayon|or(?:entyen|i(?:n(?:ťanom|[cć]anima[\s\xa0]*Poslanica|t(?:er(?:ne)?|usi?|a(?:nom|sve)?|os?|h(?:us(?:iakhoz)?|e(?:r(?:brev(?:et)?)?)?|i(?:ërs?|er(?:brevet|s)?))|t(?:ilaisille|olaiskirje)|sk[yý]m|i(?:ërs?|yarukku|er(?:brevet|s|ne)?|o))?)|tasve)|ynt(?:[oó]w|ian))?)|List[\s\xa0]*(?:[sś]w(?:\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Koryntian|[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Koryntian))|к[\s\xa0]*Коринфянам|(?:[ei](?:\.[\s\xa0]*Kori(?:ntasve|tasve)|[\s\xa0]*Kori(?:ntasve|tasve)))|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|Wakorint(?:ho|o)|ਕੁਰਿੰਥੀਆਂ[\s\xa0]*ਨੂੰ|قور|क(?:ोरिन्(?:थी(?:हरूलाई)?|‍थी)|रिंथकरांस|ुर(?:िन्(?:यि़यों|थ(?:ियों?)?)|न्थियों))|ค[ธร]|C(?:o(?:r(?:anthians|n(?:i(?:nth(?:ians|a(?:ns|ins))|th(?:ians|a(?:i(?:ns|ans)|ns)))|th(?:ains|i(?:ians|ns|ans)))|i(?:th(?:oans|a(?:ns|ins)|i(?:ians|ns|ans))|inthi(?:ians|ans)|n(?:i(?:th(?:i(?:nas|ans)|a(?:ns|ins)))?|zi|t(?:i(?:ërs?|e(?:ni|rs?)|o(?:ns|s)?|ans)?|eni|o|h(?:a(?:i(?:ns|ans)|ns)|o(?:ians|ans)|e|i(?:ians|ërs?|a(?:i(?:ns|d)|n(?:[ao]s|s)?|ans)|e(?:rs?|ns)|n(?:as|s)|o(?:ns|s)))?)?|[an]thians)?)|ri(?:th(?:ians|ains)|nth(?:ians|ains))|íntios|th(?:ians?)?)?)?|ô(?:-?rinh-?tô|rintô)|hor(?:anthians|nthians|i(?:nth(?:i(?:ns|ans)|ains)|thians)))|k(?:urĩtʰīāṃ|\.[\s\xa0]*Korin(?:t(?:anom|sk[yý]m)|ťanom)|ari[mṃ]tʰkar(?:[aā](?:[mṃ]s))|[\s\xa0]*Korin(?:t(?:anom|sk[yý]m)|ťanom))|Qor|கொ(?:ரி(?:ந்தியர்)?)?)|ère(?:\.[\s\xa0]*Corinthiens|[\s\xa0]*Corinthiens)|코린|e(?:r(?:e(?:\.[\s\xa0]*Corinthiens|[\s\xa0]*Corinthiens)|\.[\s\xa0]*Corinthiens|[\s\xa0]*Corinthiens)|[\s\xa0]*(?:Corint(?:i[eë]rs?|h(?:i[eë]rs?|e))|Kor(?:int(?:i[eë]rs?|h(?:i[eë]rs?|e)))?)|\.[\s\xa0]*(?:Corint(?:i[eë]rs?|h(?:i[eë]rs?|e))|Kor(?:int(?:i[eë]rs?|h(?:i[eë]rs?|e)))?))|º(?:[\s\xa0]*Corintios|\.[\s\xa0]*Corintios)|\.(?:[\s\xa0]*(?:Кор(?:ин(?:фян(?:ам)?|[кќ]аните|тјани|ћанима))?|ک(?:ُرنتھِیوں|رنتھِیُوں)|Sulat[\s\xa0]*sa[\s\xa0]*mga[\s\xa0]*Corint(?:io|o)|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*христијаните[\s\xa0]*во[\s\xa0]*Коринт|ослан(?:ица[\s\xa0]*Коринћанима|ня[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян))|โครินธ์|list[\s\xa0]*(?:do[\s\xa0]*Koryntian|Korin(?:tsk[yý]m|sk[yý]m))|କରିନ୍ଥୀୟ(?:ଙ୍କ)?|Mga[\s\xa0]*Taga(?:[\s\xa0]*Corinto|-?(?:[\s\xa0]*Corinto|Corinto))|Taga-?Corinto|क(?:ोरिन्(?:थी(?:हरूलाई)?|‍थी)|ुर(?:िन्(?:यि़यों|थ(?:ियों?)?)|न्थियों))|List[\s\xa0]*(?:[sś]w(?:\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Koryntian|[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Koryntian))|к[\s\xa0]*Коринфянам|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|K(?:or(?:i(?:n(?:t(?:er(?:ne)?|usi?|a(?:nom|sve)?|i(?:ërs?|er(?:brevet|s|ne)?|o)|os?|h(?:us(?:iakhoz)?|e(?:r(?:brev(?:et)?)?)?|i(?:ërs?|er(?:brevet|s)?))|t(?:ilaisille|olaiskirje)|sk[yý]m)?|ťanom|[cć]anima[\s\xa0]*Poslanica)|tasve)|entyen|ynt(?:[oó]w|ian))?|irje[\s\xa0]*korinttilaisille|urinthiayon)|Wakorint(?:ho|o)|C(?:o(?:r(?:anthians|n(?:i(?:nth(?:ians|a(?:ns|ins))|th(?:ians|a(?:i(?:ns|ans)|ns)))|th(?:ains|i(?:ians|ns|ans)))|i(?:th(?:oans|a(?:ns|ins)|i(?:ians|ns|ans))|inthi(?:ians|ans)|n(?:ith(?:i(?:nas|ans)|a(?:ns|ins))|zi|t(?:i(?:ërs?|e(?:ni|rs?)|o(?:ns|s)?|ans)|eni|o|h(?:a(?:i(?:ns|ans)|ns)|o(?:ians|ans)|e|i(?:ians|ërs?|a(?:i(?:ns|d)|n(?:[ao]s|s)?|ans)|e(?:rs?|ns)|n(?:as|s)|o(?:ns|s)))?)?|[an]thians)?)|ri(?:th(?:ians|ains)|nth(?:ians|ains))|íntios|th(?:ians?)?)?)?|ô(?:-?rinh-?tô|rintô)|hor(?:anthians|nthians|i(?:nth(?:i(?:ns|ans)|ains)|thians))))|-?کُرِنتھِیوں|۔کرنتھیوں|(?:[oº](?:[\s\xa0]*Corintios|\.[\s\xa0]*Corintios)))|[ao](?:[\s\xa0]*Cor(?:[ií]ntios|\.[\s\xa0]*Cor[ií]ntios))|°(?:[\s\xa0]*Corinzi|\.[\s\xa0]*Corinzi)|st(?:[\s\xa0]*C(?:hor(?:anthians|nthians|i(?:nth(?:i(?:ns|ans)|ains)|thians))|o(?:r(?:i(?:n(?:ith(?:i(?:nas|ans)|a(?:ns|ins))|t(?:h(?:a(?:i(?:ns|ans)|ns)|o(?:ians|ans)|i(?:ians|n(?:as|s)|a(?:n(?:[ao]s|s)?|[ai]ns)|ons))?|i[ao]ns)?|[an]thians)?|th(?:oans|a(?:ns|ins)|i(?:ians|ns|ans))|inthi(?:ians|ans))|anthians|n(?:i(?:nth(?:ians|a(?:ns|ins))|th(?:ians|a(?:i(?:ns|ans)|ns)))|th(?:ains|i(?:ians|ns|ans)))|ri(?:th(?:ians|ains)|nth(?:ians|ains))|th(?:ians?)?)?)?)|\.[\s\xa0]*C(?:hor(?:anthians|nthians|i(?:nth(?:i(?:ns|ans)|ains)|thians))|o(?:r(?:i(?:n(?:ith(?:i(?:nas|ans)|a(?:ns|ins))|t(?:h(?:a(?:i(?:ns|ans)|ns)|o(?:ians|ans)|i(?:ians|n(?:as|s)|a(?:n(?:[ao]s|s)?|[ai]ns)|ons))?|i[ao]ns)?|[an]thians)?|th(?:oans|a(?:ns|ins)|i(?:ians|ns|ans))|inthi(?:ians|ans))|anthians|n(?:i(?:nth(?:ians|a(?:ns|ins))|th(?:ians|a(?:i(?:ns|ans)|ns)))|th(?:ains|i(?:ians|ns|ans)))|ri(?:th(?:ians|ains)|nth(?:ians|ains))|th(?:ians?)?)?)?))|Cor|-?(?:کُرِنتھِیوں|я(?:\.[\s\xa0]*(?:Коринфянам|к[\s\xa0]*Коринфянам)|[\s\xa0]*(?:Коринфянам|к[\s\xa0]*Коринфянам))|е(?:[\s\xa0]*(?:к(?:оринтян|[\s\xa0]*Коринфянам)|Коринфян(?:ам)?|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|послання[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян)|\.[\s\xa0]*(?:к(?:оринтян|[\s\xa0]*Коринфянам)|Коринфян(?:ам)?|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|послання[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян))|а(?:\.[\s\xa0]*(?:Коринфян|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|коринтян|послання[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян)|[\s\xa0]*(?:Коринфян|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|коринтян|послання[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян))|ше(?:\.[\s\xa0]*(?:Коринфян|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|коринтян|послання[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян)|[\s\xa0]*(?:Коринфян|до[\s\xa0]*коринтян|Послання[\s\xa0]*до[\s\xa0]*Коринтян|коринтян|послання[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*коринфян))))|ਕੁਰਿੰਥੀਆਂ[\s\xa0]*ਨੂੰ[\s\xa0]*ਪਹਿਲੀ[\s\xa0]*ਪੱਤ੍ਰੀ|Προς[\s\xa0]*Κορινθ[ίι]ους[\s\xa0]*Α['ʹʹ΄’]|କରିନ୍ଥୀୟଙ୍କ[\s\xa0]*ପ୍ରତି[\s\xa0]*ପ୍ରଥମ[\s\xa0]*ପତ୍ର|पौलाचे[\s\xa0]*करिंथकरांस[\s\xa0]*पहिले[\s\xa0]*पत्र|コリント(?:の信徒への手紙一|[\s\xa0]*1|人への(?:前の書|手紙一|第一の手紙)|前書)|코린토(?:[\s\xa0]*신자들에게[\s\xa0]*보낸[\s\xa0]*첫째[\s\xa0]*서간|1서)|Una(?:[\s\xa0]*(?:Mga[\s\xa0]*Taga(?:-?[\s\xa0]*Corinto|[\s\xa0]*Corinto)|Sulat[\s\xa0]*sa[\s\xa0]*mga[\s\xa0]*Corint(?:io|o)|(?:[CK]orint(?:io|o)))|ng[\s\xa0]*(?:Mga[\s\xa0]*Taga(?:-?[\s\xa0]*Corinto|[\s\xa0]*Corinto)|Sulat[\s\xa0]*sa[\s\xa0]*mga[\s\xa0]*Corint(?:io|o)|(?:[CK]orint(?:io|o))))|ک(?:رنتھ(?:ِیُوں[\s\xa0]*کے[\s\xa0]*نام[\s\xa0]*پولس[\s\xa0]*رسول[\s\xa0]*کا[\s\xa0]*پہلا[\s\xa0]*خط|یوں[\s\xa0]*کے[\s\xa0]*نام[\s\xa0]*کا[\s\xa0]*پہلا[\s\xa0]*خط)|ُرِنتھِیوں[\s\xa0]*کے[\s\xa0]*نام[\s\xa0]*کا[\s\xa0]*پہلا[\s\xa0]*خط))|(?:Prvn[ií](?:[\s\xa0]*list[\s\xa0]*Korin(?:tsk(?:[yý]m|sk[yý]m)|K))|1[ao]\.[\s\xa0]*Cor(?:[ií]ntios)|Α['ʹʹ΄’][\s\xa0]*Κο)|Prvn[ií](?:[\s\xa0]*list[\s\xa0]*Korinsk(?:[yý]m|K))|Prvn(?:[ií]K)|(?:[格歌]林多前書》?|《(?:[歌格]林多前書|林前|适凌爾福前|哥林多前[书書])|哥林多前[書书]》?|林前》?|ad[\s\xa0]*Corinthios[\s\xa0]*I|הראשונה[\s\xa0]*אל[\s\xa0]*הקורינתים|I(?:[\s\xa0]*(?:Korin[cć]anima|Cô(?:-?rinh)?)|\.[\s\xa0]*(?:Korin[ćc]anima|Cô(?:-?rinh)?))|适凌爾福前》?|1(?:[\s\xa0]*(?:Sulat[\s\xa0]*sa[\s\xa0]*mga[\s\xa0]*Corint(?:io|o)|Korin[cć]anima|ਕੁਰਿੰਥੀਆਂ|Cô(?:-?rinh)?)|\.[\s\xa0]*(?:Korin[ćc]anima|Cô(?:-?rinh)?))|करिंथकरांस[\s\xa0]*पहिले[\s\xa0]*पत्र|Prva[\s\xa0]*(?:poslanica[\s\xa0]*Korin[cć]anima|Korin[cć]anima)|ਕੁਰਿੰਥੀਆਂ[\s\xa0]*ਨੂੰ|C(?:or(?:n(?:i(?:nth(?:ians|a(?:ns|ins))|th(?:ians|a(?:i(?:ns|ans)|ns)))|th(?:ains|i(?:ians|ns|ans)))|ri(?:th(?:ians|ains)|nth(?:ians|ains))|i(?:th(?:oans|a(?:ns|ins)|i(?:ians|ns|ans))|inthi(?:ians|ans)|n(?:ith(?:i(?:nas|ans)|a(?:ns|ins))|t(?:h(?:a(?:i(?:ns|ans)|ns)|o(?:ians|ans)|i(?:ians|n(?:as|s)|a(?:n(?:[oa]s|s)?|[ai]ns)|o(?:ns|s[\s\xa0]*I)))|i[ao]ns)|[an]thians)))|hor(?:anthians|nthians|i(?:nth(?:i(?:ns|ans)|ains)|thians)))))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["Gal"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:पौलाचे[\\s\\xa0]*गलतीकरांस[\\s\\xa0]*पत्र|K(?:al[aā]ttiyarukku[\\s\\xa0]*E(?:[lḻ]utiya[\\s\\xa0]*Nirupam)|irje[\\s\\xa0]*galatalaisille)|gal(?:āt(?:ihar[uū]l(?:[aā](?:[iī][\\s\\xa0]*patra))|ī(?:har[uū]l(?:[aā](?:[iī][\\s\\xa0]*patra))|āṃ[\\s\\xa0]*nū̃[\\s\\xa0]*pattrī))|at(?:ī(?:har[uū]l(?:[aā](?:[iī][\\s\\xa0]*patra))|kar[aā](?:[mṃ]s[\\s\\xa0]*patra))|i(?:yōṅ[\\s\\xa0]*ke[\\s\\xa0]*nām[\\s\\xa0]*kā[\\s\\xa0]*ḫaṭ|har[uū]l(?:[aā](?:[iī][\\s\\xa0]*patra))|kar[aā](?:[mṃ]s[\\s\\xa0]*patra))))|गल(?:तियों|ात(?:ि(?:यों)?|ी(?:हरूलाई[\\s\\xa0]*प(?:ावलको[\\s\\xa0]*पत्र|त्र))?))|رسالة[\\s\\xa0]*(?:بولس[\\s\\xa0]*الرسول[\\s\\xa0]*إلى[\\s\\xa0]*أهل[\\s\\xa0]*غلاطية|غلاطية)|ଗାଲାତୀୟଙ୍କ[\\s\\xa0]*ପ୍ରତି[\\s\\xa0]*ପତ୍ର|אגרת[\\s\\xa0]*פולוס[\\s\\xa0]*השליח[\\s\\xa0]*אל-?הגלטים|G(?:á(?:l(?:at(?:as)?)?)?|àlati|l|a(?:l(?:át|lati(?:ns|[ao]ns)|a(?:s(?:y(?:en|ano)|ia?)|t(?:o(?:ns|ans)|a(?:br[eé]fið|laiskirj|ns|khoz|sve|i(?:ns|[ao]ns)|[ao]ns)?|ns|e(?:n(?:brief|i)?|r(?:bre(?:vet|fvet))?|s)|ákhoz|i(?:o(?:n(?:[an]s|s)|s|ans)|y(?:on|a)|n(?:a(?:ns|s)|s)|i(?:ns|[ao]ns)|a(?:n(?:[ai]s|s)?|i(?:ns|d)|s|ans)))?|atiyaa)?)?|-?la-?ti))|Προς[\\s\\xa0]*Γαλ[άα]τας|கலா(?:த்(?:தியர(?:ுக்கு[\\s\\xa0]*எழுதிய[\\s\\xa0]*(?:நிருபம்|திருமுகம்|கடிதம்)|்))?)?|《(?:迦拉達書》|加(?:拉太[书書]》|》)|戛拉提亞》)|P(?:a(?:ulus['’][\\s\\xa0]*Brev[\\s\\xa0]*til[\\s\\xa0]*Galaterne|vlova[\\s\\xa0]*poslanica[\\s\\xa0]*Gala[cć]anima)|oslan(?:nja[\\s\\xa0]*apostola[\\s\\xa0]*Pavla[\\s\\xa0]*do[\\s\\xa0]*halativ|ica[\\s\\xa0]*Galaæanima))|П(?:исмо[\\s\\xa0]*од[\\s\\xa0]*апостол[\\s\\xa0]*Павле[\\s\\xa0]*до[\\s\\xa0]*христијаните[\\s\\xa0]*во[\\s\\xa0]*Галатија|о(?:слан(?:ня[\\s\\xa0]*(?:апостола[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*галатів|до[\\s\\xa0]*галатів|св(?:[\\s\\xa0]*апостола[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*галатів|\\.[\\s\\xa0]*апостола[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*галатів))|и(?:е[\\s\\xa0]*(?:к(?:ъм[\\s\\xa0]*галатяните|[\\s\\xa0]*Галатам)|на[\\s\\xa0]*св(?:[\\s\\xa0]*ап(?:\\.[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Галатяни|[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Галатяни)|\\.[\\s\\xa0]*ап(?:\\.[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Галатяни|[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Галатяни)))|ца[\\s\\xa0]*Гала(?:тима|ћанима)))|[\\s\\xa0]*слання[\\s\\xa0]*до[\\s\\xa0]*Галатів))|ก(?:าลาเทีย|ท)|ﻏﻼﻃﻲ|(?:[カガ]ラテヤ(?:の信徒への手紙|人への(?:手紙|書)|書)?)|الرسالة[\\s\\xa0]*إلى[\\s\\xa0]*أهل[\\s\\xa0]*غلاطية|Epistula[\\s\\xa0]*ad[\\s\\xa0]*Galatas|Γα(?:λ(?:[άα]τες)?)?|ਗਲਾਤੀਆਂ[\\s\\xa0]*ਨੂੰ[\\s\\xa0]*ਪੱਤ੍ਰੀ|B(?:arua[\\s\\xa0]*kwa[\\s\\xa0]*Wagalatia|r(?:e(?:f[\\s\\xa0]*P[aá]ls[\\s\\xa0]*til[\\s\\xa0]*Galatamanna|vet[\\s\\xa0]*til[\\s\\xa0]*Galaterne)|éf[\\s\\xa0]*P[aá]ls[\\s\\xa0]*til[\\s\\xa0]*Galatamanna))|L(?:ayang[\\s\\xa0]*Paulus[\\s\\xa0]*Galatia|ettera[\\s\\xa0]*ai[\\s\\xa0]*Galati|ist[\\s\\xa0]*(?:do[\\s\\xa0]*Gala(?:cjan|t[oó]w)|Gala(?:t(?:anom|sk[yý]m)|ťanom)|(?:[sś]w(?:[\\s\\xa0]*Pawła[\\s\\xa0]*do[\\s\\xa0]*Galacjan|\\.[\\s\\xa0]*Pawła[\\s\\xa0]*do[\\s\\xa0]*Galacjan))))|Гал(?:ат(?:јани|ите))?|Sulat[\\s\\xa0]*sa[\\s\\xa0]*mga[\\s\\xa0]*(?:Galacia|taga[\\s\\xa0]*Galacia)|האיגרת[\\s\\xa0]*אל[\\s\\xa0]*הגלטים|گلت(?:یوں[\\s\\xa0]*کے[\\s\\xa0]*نام[\\s\\xa0]*(?:پولُس[\\s\\xa0]*رسول[\\s\\xa0]*کا[\\s\\xa0]*خط|کا[\\s\\xa0]*خط)|ِیوں[\\s\\xa0]*کے[\\s\\xa0]*نام[\\s\\xa0]*کا[\\s\\xa0]*خط)|갈라(?:디아서|티아[\\s\\xa0]*신자들에게[\\s\\xa0]*보낸[\\s\\xa0]*서간)?|Mga[\\s\\xa0]*Taga(?:[\\s\\xa0]*Galasya|-?(?:[\\s\\xa0]*Gala(?:cia|sya)|Galacia))|غل)|Gala(?:ćanima|t(?:erne|as)|c(?:anima|ia))|galat[īi]kar(?:[aā](?:[ṃm]s))|(?:ਗਲਾਤੀਆਂ[\\s\\xa0]*ਨੂੰ|Kal[aā]ttiyarukku|迦拉達書》|gal(?:āt(?:ī(?:har[uū]l(?:[āa][īi])|āṃ)|ihar[ūu]l(?:[āa][iī]))|at[iī]har(?:[ūu]l(?:[āa][iī])))|Гала(?:ћанима|т(?:има|яни(?:те)?))|《(?:加(?:拉太[书書])?|迦拉達書|戛拉提亞)|ad[\\s\\xa0]*Galatas|Taga-?(?:[\\s\\xa0]*Galacia|Galacia)|加(?:拉太[書书]》|》)|אל[\\s\\xa0]*הגלטים|گلت(?:یوں|ِیوں)|Mga[\\s\\xa0]*Taga[\\s\\xa0]*Galacia|戛拉提亞》|P(?:oslanica[\\s\\xa0]*Gala[cć]anima|aulus’[\\s\\xa0]*brev[\\s\\xa0]*til[\\s\\xa0]*galaterne)|До[\\s\\xa0]*галатів|गल(?:तीकरांस[\\s\\xa0]*पत्र|ातीहरूलाई)|Ga(?:la(?:cjan|t(?:a(?:laisille|nom)|[oó]w|ia?|sk[yý]m)|ťanom))?|Wagalatia|ଗାଲାତୀୟଙ୍କ|К[\\s\\xa0]*Галатам)|(?:加(?:拉太[书書])?|गलतीकरांस|迦拉達書|戛拉提亞|Галат(?:ів|ам)|Taga[\\s\\xa0]*Galacia))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Eph"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(epʰis[iī]har(?:[uū]l(?:[aā](?:[iī][\\s\\xa0]*patra)))|(?:《(?:弗》|耶斐斯》|以弗所[书書]》|厄弗所書》)|Προς[\\s\\xa0]*Εφεσ[ίι]ους|Εφ|אגרת[\\s\\xa0]*פולוס[\\s\\xa0]*השליח[\\s\\xa0]*אל-?האפסים|ଏଫିସୀୟଙ୍କ[\\s\\xa0]*ପ୍ରତି[\\s\\xa0]*ପତ୍ର|எபே(?:சி(?:யர(?:ுக்கு[\\s\\xa0]*எழுதிய[\\s\\xa0]*(?:நிருபம்|திருமுகம்|கடிதம்)|்))?)?|Ép(?:h(?:[eé](?:s(?:iens)?)?)?)?|เอเฟซัส|رسالة[\\s\\xa0]*(?:أفسس|بولس[\\s\\xa0]*الرسول[\\s\\xa0]*إلى[\\s\\xa0]*أهل[\\s\\xa0]*أفسس)|에(?:페(?:소(?:[\\s\\xa0]*신자들에게[\\s\\xa0]*보낸[\\s\\xa0]*서간|서))?|베소서)|L(?:ayang[\\s\\xa0]*Paulus[\\s\\xa0]*Efesus|ist[\\s\\xa0]*(?:do[\\s\\xa0]*Efezjan|Ef(?:ézsk[yý]m|ez(?:an[ouů]m|sk[yý]m))|[SŚ]wi(?:[eę]tego[\\s\\xa0]*Pawła[\\s\\xa0]*Apostoła[\\s\\xa0]*do[\\s\\xa0]*Efez(?:[oó]w))|(?:[sś]w(?:[\\s\\xa0]*Pawła[\\s\\xa0]*do[\\s\\xa0]*Efezjan|\\.[\\s\\xa0]*Pawła[\\s\\xa0]*do[\\s\\xa0]*Efezjan)))|ettera[\\s\\xa0]*agli[\\s\\xa0]*Efesini)|Iafisiyon|i(?:pʰiskar[aā](?:[mṃ]s[\\s\\xa0]*patra)|fisiyōṅ[\\s\\xa0]*ke[\\s\\xa0]*nām[\\s\\xa0]*kā[\\s\\xa0]*ḫaṭ)|Mga[\\s\\xa0]*Taga(?:[\\s\\xa0]*E(?:[fp]es(?:io|o))|-?(?:[\\s\\xa0]*E(?:[fp]es(?:io|o))|[EÉ]feso))|ਅਫ਼ਸੀਆਂ[\\s\\xa0]*ਨੂੰ[\\s\\xa0]*ਪੱਤ੍ਰੀ|इफिस(?:ि(?:यों)?|ी)|P(?:a(?:ulus['’][\\s\\xa0]*Brev[\\s\\xa0]*til[\\s\\xa0]*Efeserne|vlova[\\s\\xa0]*poslanica[\\s\\xa0]*Efe[zž]anima)|oslannja[\\s\\xa0]*apostola[\\s\\xa0]*Pavla[\\s\\xa0]*do[\\s\\xa0]*efesjan)|पौलाचे[\\s\\xa0]*इफिसकरांस[\\s\\xa0]*पत्र|B(?:arua[\\s\\xa0]*kwa[\\s\\xa0]*Waefeso|r[eé]f[\\s\\xa0]*P(?:[aá]ls[\\s\\xa0]*til[\\s\\xa0]*Efesusmanna))|E(?:sphesians|hp(?:[ei]sians)?|p(?:ēciyarukku[\\s\\xa0]*E[lḻ]utiya[\\s\\xa0]*Nirupam|e(?:ciyarukku[\\s\\xa0]*E[lḻ]utiya[\\s\\xa0]*Nirupam|hesians|sians)|istula[\\s\\xa0]*ad[\\s\\xa0]*Ephesios|h(?:s(?:ians?)?|isians?|é(?:s(?:iens)?)?|e(?:s(?:i(?:a(?:n[ds]?|id)|[eo]ns)|zosziakhoz|ains?|er)?)?)?)?|f(?:é(?:zusiakhoz|s(?:e|ios))|e(?:s(?:e(?:ni|rbrevet)?|o(?:laiskirje|s)|k[yý]m|i(?:os|erbrevet|an[eë]ve)|usbr[eé]fið)?|z(?:us(?:iakhoz)?|i[eë]rs|yen)?)?|èz|f(?:esiaid)?|is(?:oona)?)?)|Еф(?:е(?:шаните|сјани))?|ﺃﻓﺴﺲ|エ(?:(?:[ヘペ]ソ(?:人への(?:手紙|書)|書))|フェソ(?:の信徒への手紙|人への手紙|書)?)|᾿Εφ|afasīāṃ[\\s\\xa0]*nū̃[\\s\\xa0]*pattrī|Kirje[\\s\\xa0]*efesolaisille|Waraka[\\s\\xa0]*kwa[\\s\\xa0]*Waefeso|อฟ|ا(?:ِف(?:س(?:یوں|ِیوں)|ِسِیوں[\\s\\xa0]*کے[\\s\\xa0]*نام[\\s\\xa0]*کا[\\s\\xa0]*خط)|فسیوں[\\s\\xa0]*کے[\\s\\xa0]*نام[\\s\\xa0]*(?:پو[\\s\\xa0]*لس[\\s\\xa0]*رسول[\\s\\xa0]*کا[\\s\\xa0]*خط|کا[\\s\\xa0]*خط)|لرسالة[\\s\\xa0]*إلى[\\s\\xa0]*أهل[\\s\\xa0]*أفسس)|האיגרת[\\s\\xa0]*אל[\\s\\xa0]*האפסים|Sulat[\\s\\xa0]*sa[\\s\\xa0]*mga[\\s\\xa0]*E(?:[fp]es(?:io|o))|أف|एफिसी(?:हरूलाई[\\s\\xa0]*प(?:ावलको[\\s\\xa0]*पत्र|त्र))?|Ê(?:ph(?:êsô)?|-?phê-?sô)|Єф|П(?:о(?:[\\s\\xa0]*слан[\\s\\xa0]*ня[\\s\\xa0]*до[\\s\\xa0]*Єфесян|слан(?:ня[\\s\\xa0]*(?:апостола[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*ефесян|до[\\s\\xa0]*ефесян|св(?:[\\s\\xa0]*апостола[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*ефесян|\\.[\\s\\xa0]*апостола[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*ефесян))|и(?:е[\\s\\xa0]*(?:к(?:ъм[\\s\\xa0]*ефесяните|[\\s\\xa0]*Ефесянам)|на[\\s\\xa0]*св(?:[\\s\\xa0]*ап(?:[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Ефесяни|\\.[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Ефесяни)|\\.[\\s\\xa0]*ап(?:[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Ефесяни|\\.[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Ефесяни)))|ца[\\s\\xa0]*Ефесцима)))|исмо[\\s\\xa0]*од[\\s\\xa0]*апостол[\\s\\xa0]*Павле[\\s\\xa0]*до[\\s\\xa0]*христијаните[\\s\\xa0]*во[\\s\\xa0]*Ефес)|Эф(?:есянам)?)|(?:弗》?|एफिसीहरूलाई|厄弗所書》?|E(?:p(?:ēciyarukku|hesios|e(?:s(?:io|o)|ciyarukku))|fe(?:s(?:o(?:laisille)?|erne|us|i(?:ni|o))|žanima|z(?:an(?:om|ima)|[óo]w|jan|sk[yý]m)))|К[\\s\\xa0]*Ефесянам|耶斐斯》?|a(?:fasīāṃ|d[\\s\\xa0]*Ephesios)|До[\\s\\xa0]*ефесян|ଏଫିସୀୟଙ୍କ|以弗所[書书]》?|Ефес(?:цима|ян(?:и(?:те)?|ам)?)|אל[\\s\\xa0]*האפסים|《(?:厄弗所書|以弗所[書书]|弗|耶斐斯)|Waefeso|P(?:oslanica[\\s\\xa0]*Efe[zž]anima|aulus’[\\s\\xa0]*brev[\\s\\xa0]*til[\\s\\xa0]*efeserne)|epʰis[īi]har(?:[uū]l(?:[aā][īi]))|Taga(?:[\\s\\xa0]*E(?:[pf]es(?:io|o))|-?(?:[\\s\\xa0]*E(?:[fp]es(?:io|o))|[ÉE]feso))|Εφεσ[ίι]ους|Mga[\\s\\xa0]*E(?:[pf]es(?:io|o))|ipʰiskar[aā](?:[ṃm]s)|ਅਫ਼ਸੀਆਂ[\\s\\xa0]*ਨੂੰ|Éfeso|افسیوں|इफिसकरांस(?:[\\s\\xa0]*पत्र)?))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Col"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:كو|Κ(?:ολ|λ)|K(?:o(?:l(?:o(?:s(?:s(?:e(?:r(?:brevet)?|n(?:s(?:er(?:brevet|n)|k[yý]m)|zen)|iakhoz)?|é(?:iakhoz)?|alaiskirje|ubr[eé]fið|z(?:e(?:beliekhez|ieknek)|ébeliekhez))|ay|ens(?:k[yý]m|[oó]w)|ian[eë]ve|yen)?|ceyarukku[\\s\\xa0]*E[lḻ]utiya[\\s\\xa0]*Nirupam)|òs|ussubr[eé]fið|ōceyarukku[\\s\\xa0]*E[lḻ]utiya[\\s\\xa0]*Nirupam)?)?|ól[ou]ssubr(?:[eé]fið)?|ulussaiyon|irje[\\s\\xa0]*kolossalaisille)|C(?:ô(?:l(?:ôxê)?|-?lô-?se)|al(?:l(?:asi[ao]ns|os(?:sians|i[ao]ns))|[ao]s(?:si(?:[ao]ns|i[ao]ns)))|o(?:l(?:l[ao]si(?:[ao]ns)|os(?:en(?:ses|i)|i(?:a(?:ns|id)|ons)|s(?:enzen|i(?:a(?:ns?|id)|[eo]ns)|ans)?)?|as(?:si[ao]ns|i[ao]ns))?)?|l)|האיגרת[\\s\\xa0]*אל[\\s\\xa0]*הקולוסים|До[\\s\\xa0]*колоссян|คส|Кол(?:о(?:шаните|сјани))?|Sulat[\\s\\xa0]*sa[\\s\\xa0]*mga[\\s\\xa0]*(?:[CK]olo(?:sense|nsense))|قول|Waraka[\\s\\xa0]*kwa[\\s\\xa0]*Wakolosai|ک(?:لسیوں[\\s\\xa0]*کے[\\s\\xa0]*نام[\\s\\xa0]*کا[\\s\\xa0]*خط|ُل(?:ِسّیوں[\\s\\xa0]*کے[\\s\\xa0]*نام[\\s\\xa0]*پولُس[\\s\\xa0]*رسُول[\\s\\xa0]*کا[\\s\\xa0]*خط|ُسِّیوں[\\s\\xa0]*کے[\\s\\xa0]*نام[\\s\\xa0]*کا[\\s\\xa0]*خط|س[ِّ]یوں))|โคโลสี|पौलाचे[\\s\\xa0]*कलस्सैकरांस[\\s\\xa0]*पत्र|Epistula[\\s\\xa0]*ad[\\s\\xa0]*Colossenses|골로새서|콜로(?:새(?:[\\s\\xa0]*신자들에게[\\s\\xa0]*보낸[\\s\\xa0]*서간|서))?|क(?:ुलुस्(?:‍सी|सि(?:यों)?)|लस(?:्सी(?:हरूलाई[\\s\\xa0]*प(?:ावलको[\\s\\xa0]*पत्र|त्र))?|ैकरांस))|ਕੁਲੁੱਸੀਆਂ[\\s\\xa0]*ਨੂੰ[\\s\\xa0]*ਪੱਤ੍ਰੀ|Mga[\\s\\xa0]*Taga(?:-?(?:Colosas|[\\s\\xa0]*[CK]olosas)|[\\s\\xa0]*[CK]olosas)|אגרת[\\s\\xa0]*פולוס[\\s\\xa0]*השליח[\\s\\xa0]*אל-?הקולוסי|رسالة[\\s\\xa0]*(?:كولوسي|بولس[\\s\\xa0]*الرسول[\\s\\xa0]*إلى[\\s\\xa0]*أهل[\\s\\xa0]*كولوسي)|B(?:r[eé]f[\\s\\xa0]*P(?:[aá]ls[\\s\\xa0]*til[\\s\\xa0]*K(?:[oó]lossumanna?))|arua[\\s\\xa0]*kwa[\\s\\xa0]*Wakolosai)|Προς[\\s\\xa0]*Κολοσσαε[ίι]ς|《(?:西》|哥羅森書》|歌(?:羅西書》|罗西书》)|适羅斯》)|П(?:исмо[\\s\\xa0]*од[\\s\\xa0]*апостол[\\s\\xa0]*Павле[\\s\\xa0]*до[\\s\\xa0]*христијаните[\\s\\xa0]*во[\\s\\xa0]*Колос|ослан(?:и(?:ца[\\s\\xa0]*Колошанима|е[\\s\\xa0]*(?:к(?:ъм[\\s\\xa0]*колосяните|[\\s\\xa0]*Колоссянам)|на[\\s\\xa0]*св(?:\\.[\\s\\xa0]*ап(?:[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Колосяни|\\.[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Колосяни)|[\\s\\xa0]*ап(?:[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Колосяни|\\.[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Колосяни))))|ня[\\s\\xa0]*(?:апостола[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*колосян|св(?:[\\s\\xa0]*апостола[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*колосян|\\.[\\s\\xa0]*апостола[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*колосян)|до[\\s\\xa0]*Колосян)))|କଲସୀୟଙ୍କ[\\s\\xa0]*ପ୍ରତି[\\s\\xa0]*ପତ୍ର|k(?:uluss(?:iyōṅ[\\s\\xa0]*ke[\\s\\xa0]*nām[\\s\\xa0]*kā[\\s\\xa0]*ḫaṭ|īāṃ[\\s\\xa0]*nū̃[\\s\\xa0]*pattrī)|alass(?:[iī]har(?:[uū]l(?:[aā](?:[iī][\\s\\xa0]*patra)))|aikar[aā](?:[mṃ]s[\\s\\xa0]*patra)))|P(?:a(?:ulus(?:’[\\s\\xa0]*(?:Brev[\\s\\xa0]*til[\\s\\xa0]*Kolossenserne|brev[\\s\\xa0]*til[\\s\\xa0]*kolosserne)|'[\\s\\xa0]*Brev[\\s\\xa0]*til[\\s\\xa0]*Kolossenserne)|vlova[\\s\\xa0]*poslanica[\\s\\xa0]*Kolo[sš]anima)|oslannja[\\s\\xa0]*apostola[\\s\\xa0]*Pavla[\\s\\xa0]*do[\\s\\xa0]*kolosjan)|Qol(?:asiyaasa)?|கொலோ(?:ச(?:ையர(?:ுக்கு[\\s\\xa0]*எழுதிய[\\s\\xa0]*திருமுகம்|்)|ெயர(?:ுக்கு[\\s\\xa0]*எழுதிய[\\s\\xa0]*(?:நிருபம்|கடிதம்)|்)))?|الرسالة[\\s\\xa0]*إلى[\\s\\xa0]*أهل[\\s\\xa0]*كولوسي|ﻛﻮﻟﻮﺳﻲ|コロサイ(?:の信徒への手紙|人への(?:手紙|書)|書)?|L(?:ayang[\\s\\xa0]*Paulus[\\s\\xa0]*Kolos[eé]|ettera[\\s\\xa0]*ai[\\s\\xa0]*Colossesi|ist[\\s\\xa0]*(?:(?:[sś]w(?:[\\s\\xa0]*Pawła[\\s\\xa0]*do[\\s\\xa0]*Kolosan|\\.[\\s\\xa0]*Pawła[\\s\\xa0]*do[\\s\\xa0]*Kolosan))|do[\\s\\xa0]*Kolosan|Kolos(?:k[yý]m|an[ouů]m))))|(?:Cal[ao]si(?:[ao]ns)|Kól)|(?:哥羅森書》?|《(?:适羅斯|哥羅森書|歌(?:羅西書|罗西书)|西)|Wakolosai|西》?|אל[\\s\\xa0]*הקולוסים|Κολοσσαε[ίι]ς|ک(?:ُلِسّیوں|لسیوں)|Kol(?:o(?:šanima|ceyarukku|s(?:k[yý]m|a(?:n(?:[ůuo]m|ima)?|s)|[ée]|s(?:alaisille|e(?:nserne|rne))))|ōceyarukku)|ad[\\s\\xa0]*Colossenses|歌(?:羅西書》?|罗西书》?)|Poslanica[\\s\\xa0]*Kolo[šs]anima|କଲସୀୟଙ୍କ|К(?:оло(?:с(?:сян(?:ам)?|ян(?:и(?:те)?)?)|шанима)|[\\s\\xa0]*Колоссянам)|Taga(?:[\\s\\xa0]*Colosas|-?(?:Colosas|[\\s\\xa0]*Colosas))|Mga[\\s\\xa0]*(?:[CK]olo(?:sense|nsense))|k(?:ulussīāṃ|alass(?:aikar[āa](?:[mṃ]s)|[īi]har(?:[uū]l(?:[āa][īi]))))|Colos(?:as|se(?:si|nses))|ਕੁਲੁੱਸੀਆਂ[\\s\\xa0]*ਨੂੰ|适羅斯》?|कलस्स(?:ैकरांस(?:[\\s\\xa0]*पत्र)?|ीहरूलाई)))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["2Tim"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])(2[\s\xa0]*tim(?:otʰ(?:i(?:l[aā][iī]|us)|īl[aā][iī])|atʰtʰ[aā]l[aā])|(?:D(?:ru(?:h(?:e[\s\xa0]*poslannja[\s\xa0]*apostola[\s\xa0]*Pavla[\s\xa0]*do[\s\xa0]*Tymofija|(?:[yý][\s\xa0]*(?:T(?:m|im(?:ote(?:ovi|us|jovi))?)|list[\s\xa0]*Tim(?:ote(?:ovi|jovi)|eteovi)))|[aá][\s\xa0]*(?:list[\s\xa0]*Tim(?:[eo]teovi|T(?:m|im(?:ote(?:ovi|us|jovi))?)|kniha[\s\xa0]*Timote(?:ovi|jovi))))|g(?:i[\s\xa0]*(?:Tymoteusza|List[\s\xa0]*(?:(?:[sś]w(?:\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tymoteusza|[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tymoteusza))|do[\s\xa0]*Tymoteusza))|a[\s\xa0]*(?:T(?:imoteju[\s\xa0]*Poslanica|ymoteusza)|List[\s\xa0]*(?:(?:[sś]w(?:\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tymoteusza|[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tymoteusza))|do[\s\xa0]*Tymoteusza))))|e(?:uxi[eè]me(?:[\s\xa0]*Timoth(?:[eé]e|s[\s\xa0]*Timoth[eé]e))|zy[eè]m[\s\xa0]*Timote))|S(?:e(?:gund[ao][\s\xa0]*Tim(?:[oó]teo)|cond(?:o[\s\xa0]*Timoteo|[\s\xa0]*T(?:omothy|i(?:m(?:ot(?:hy?|y))?)?|himot(?:hy|y)|m)|a[\s\xa0]*(?:lettera[\s\xa0]*a[\s\xa0]*Timoteo|Timoteo)))|(?:[ií]ðara[\s\xa0]*(?:br(?:[eé]f[\s\xa0]*P(?:[aá]ls[\s\xa0]*til[\s\xa0]*T(?:[ií]m(?:[oó](?:teusar)?))))|T[ií]m(?:[oó]teusarbr(?:[eé]f)))))|אגרת[\s\xa0]*פולוס[\s\xa0]*השנייה[\s\xa0]*אל-?טימותי|And(?:r(?:e[\s\xa0]*Tim(?:oteus(?:brev)?)?|a[\s\xa0]*Timot(?:heosbrevet|eusbrevet))|e(?:n[\s\xa0]*Tim(?:ot(?:eus|heusbrev))?|t[\s\xa0]*Timotheusbrev))|Waraka[\s\xa0]*wa[\s\xa0]*Pili[\s\xa0]*kwa[\s\xa0]*Timotheo|디모데[2후]서|ﺍﻟﺜﺎﻧﻴﺔ[\s\xa0]*ﺗﻴﻤﻮﺛﺎﻭﺱ|Epistula[\s\xa0]*(?:ad[\s\xa0]*Timotheum[\s\xa0]*II|II[\s\xa0]*ad[\s\xa0]*Timotheum)|الرسالة[\s\xa0]*الثانية[\s\xa0]*إلى[\s\xa0]*تيموثاوس|तिमोथीलाई[\s\xa0]*(?:पावलको[\s\xa0]*दोस्रो[\s\xa0]*पत्र|दोस्त्रो[\s\xa0]*पत्र)|《(?:弟茂德後書》|提(?:[后後]》|摩(?:斐後》|太(?:後書》|后书》))))|t(?:īm(?:utʰiyus[\s\xa0]*ke[\s\xa0]*nām[\s\xa0]*kā[\s\xa0]*dūsrā[\s\xa0]*ḫaṭ|atʰtʰ[aā]l(?:[aā][\s\xa0]*dusre[\s\xa0]*patra))|im(?:otʰ(?:īl[aā](?:[iī][\s\xa0]*dostro[\s\xa0]*patra)|i(?:us[\s\xa0]*nū̃[\s\xa0]*dūjī[\s\xa0]*pattrī|l[aā](?:[iī][\s\xa0]*dostro[\s\xa0]*patra)))|atʰtʰ[aā]l(?:[aā][\s\xa0]*dusre[\s\xa0]*patra)))|ਤਿਮੋਥਿਉਸ[\s\xa0]*ਨੂੰ[\s\xa0]*ਦੂਜੀ[\s\xa0]*ਪੱਤ੍ਰੀ|رسالة[\s\xa0]*بولس[\s\xa0]*الرسول[\s\xa0]*الثانية[\s\xa0]*إلى[\s\xa0]*تيموثاوس|Zweite[\s\xa0]*Timotheus|Naa77antto[\s\xa0]*Ximootiyoosa|Друг(?:а[\s\xa0]*(?:Ти(?:­мофія|мо(?:фію|те(?:[ий]|ју)))|послан(?:ица[\s\xa0]*Тимотеју|ня[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія))))|е[\s\xa0]*(?:Ти(?:мо(?:те[ий]|фію)|­мофія)|послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія))))|テモテ(?:[\s\xa0]*2|への(?:手紙二|後の書)|後書|ヘの第二の手紙)|पौलाचे[\s\xa0]*तीमथ्थाला[\s\xa0]*दुसरे[\s\xa0]*पत्र|2(?:티모|-?(?:تِیمُتھِیُس|я(?:\.[\s\xa0]*(?:к[\s\xa0]*Тимофею|Тим(?:етею|офею))|[\s\xa0]*(?:к[\s\xa0]*Тимофею|Тим(?:етею|офею)))|а(?:[\s\xa0]*(?:Ти(?:мо(?:те[ий]|фію)|­мофія)|послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія)))|\.[\s\xa0]*(?:Ти(?:мо(?:те[ий]|фію)|­мофія)|послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія))))|е(?:\.[\s\xa0]*(?:Ти(?:­мофія|м(?:етею|о(?:те[ий]|ф[еі]ю)))|к[\s\xa0]*Тимофею|послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія)))|[\s\xa0]*(?:Ти(?:­мофія|м(?:етею|о(?:те[ий]|ф[еі]ю)))|к[\s\xa0]*Тимофею|послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія))))|ге(?:[\s\xa0]*(?:Ти(?:мо(?:те[ий]|фію)|­мофія)|послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія)))|\.[\s\xa0]*(?:Ти(?:мо(?:те[ий]|фію)|­мофія)|послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія)))))|Tim|\.(?:(?:[oº](?:\.[\s\xa0]*Timoteo|[\s\xa0]*Timoteo))|۔تیمتھیس|[\s\xa0]*(?:к[\s\xa0]*Тимофею|list[\s\xa0]*Tim[eo]teovi|ทิโมธี|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*Тимотеј|ослан(?:ица[\s\xa0]*Тимотеју|ня[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія))))|K(?:irje[\s\xa0]*Timoteukselle|a(?:y[\s\xa0]*Timoteo|ng[\s\xa0]*Timoteo))|त(?:ीम(?:ु(?:ाथैयुस|थियुस))?|िम(?:ोथी(?:लाई)?|ुथियुस))|ତୀମଥିଙ୍କ|timotʰ[iī]l(?:[aā][iī])|T(?:omothy|i(?:-?mô-?thê|m(?:ot(?:ius|y|h(?:e(?:üs|o(?:s(?:brevet|z))?|e|u(?:m|s(?:brev)?))|y|ée)?|e(?:j(?:ovi|u[\s\xa0]*Poslanica)|o(?:vi)?|üs|u(?:kselle|s(?:kirje|brev(?:et)?|hoz|nak)?|t)|i|yos)?)|ôthê|ót(?:e(?:o|us(?:hoz|nak)?)|heosz))?)|ím|ymoteusza|eemuathaiyus|himot(?:hy|y)|m)|List[\s\xa0]*(?:(?:[sś]w(?:\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tymoteusza|[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tymoteusza))|do[\s\xa0]*Tymoteusza)|Ти(?:­мофія|м(?:етею|о(?:те(?:[ий]|ју?)|ф[еі]ю))?)|ت(?:ِیمُتھِیُس|ی(?:ِمُتھِیُس|مِتھُیس)))|-?تِیمُتھِیُس)|e(?:me(?:[\s\xa0]*Timoth[eé]e|\.[\s\xa0]*Timoth[eé]e)|\.[\s\xa0]*Tim(?:ot(?:h(?:e(?:[uü]s|e)|ée)|e[uü]s))?|[\s\xa0]*Tim(?:ot(?:h(?:e(?:[uü]s|e)|ée)|e[uü]s))?)|nd(?:[\s\xa0]*T(?:omothy|i(?:m(?:ot(?:hy?|y))?)?|himot(?:hy|y)|m)|\.[\s\xa0]*T(?:omothy|i(?:m(?:ot(?:hy?|y))?)?|himot(?:hy|y)|m))|d(?:[\s\xa0]*Timoth[eé]e|e(?:[\s\xa0]*Timoth[eé]e|\.[\s\xa0]*Timoth[eé]e)|\.[\s\xa0]*Timoth[eé]e)|[oa](?:[\s\xa0]*Tim(?:[oó]teo|\.[\s\xa0]*Tim[oó]teo))|(?:[°º](?:\.[\s\xa0]*Timoteo|[\s\xa0]*Timoteo))|(?:[яе](?:\.[\s\xa0]*(?:к[\s\xa0]*Тимофею|Тим(?:етею|офею))|[\s\xa0]*(?:к[\s\xa0]*Тимофею|Тим(?:етею|офею))))|ème(?:[\s\xa0]*Timoth[eé]e|\.[\s\xa0]*Timoth[eé]e)|۔تیمتھیس|[\s\xa0]*(?:tīmatʰtʰ[aā]l[aā]|к[\s\xa0]*Тимофею|list[\s\xa0]*Tim[eo]teovi|Xim|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*Тимотеј|ослан(?:ица[\s\xa0]*Тимотеју|ня[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія))))|த(?:ீமோத்(?:தேயு)?|ிமொ(?:த்தேயு)?)|K(?:irje[\s\xa0]*Timoteukselle|a(?:y[\s\xa0]*Timoteo|ng[\s\xa0]*Timoteo))|T(?:omothy|ím|ym(?:oteusza)?|eemuathaiyus|himot(?:hy|y)|m|i(?:-?mô-?thê|m(?:ōtt[eē]yuvukku|ôthê|ot(?:ius|t[eē]yuvukku|y|h(?:e(?:üs|o(?:s(?:brevet|z))?|e|u(?:m|s(?:brev)?))|y|ée)?|e(?:j(?:ovi|u[\s\xa0]*Poslanica)|o(?:vi)?|üs|u(?:kselle|s(?:kirje|brev(?:et)?|hoz|nak)?|t)|i|yos)?)|ót(?:e(?:o|us(?:hoz|nak)?)|heosz))?)|īm[oō]tt(?:[eē]yuvukku))|طيم|k(?:\.[\s\xa0]*Timote(?:ovi|jovi)|[\s\xa0]*Timote(?:ovi|jovi))|ତୀମଥିଙ୍କ|(?:[ei](?:[\s\xa0]*Timoteut|\.[\s\xa0]*Timoteut))|ਤਿਮੋਥਿਉਸ[\s\xa0]*ਨੂੰ|त(?:ीम(?:ु(?:ाथैयुस|थियुस)|थ्थाला)?|िम(?:ोथी(?:लाई)?|ुथियुस))|List[\s\xa0]*(?:(?:[sś]w(?:\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tymoteusza|[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tymoteusza))|do[\s\xa0]*Tymoteusza)|ท(?:ิโมธี|ธ)|Ти(?:­мофія|м(?:етею|о(?:те(?:[ий]|ју?)|ф[еі]ю))?)|ت(?:ِیمُتھِیُس|ی(?:ِمُتھِیُس|مِتھُیس))))|티모테오(?:에게[\s\xa0]*보낸[\s\xa0]*둘째[\s\xa0]*서간|2서)|ت(?:ِیمُتھِیُس[\s\xa0]*کے[\s\xa0]*نام[\s\xa0]*کا[\s\xa0]*دوسرا[\s\xa0]*خط|يموثاوس[\s\xa0]*الثانية|ی(?:متھیس[\s\xa0]*کے[\s\xa0]*نام[\s\xa0]*کا[\s\xa0]*دوسرا[\s\xa0]*خط|ِمُتھِیُس[\s\xa0]*کے[\s\xa0]*نام[\s\xa0]*پولس[\s\xa0]*رسول[\s\xa0]*کا[\s\xa0]*دوسرا[\s\xa0]*خط))|Β(?:['ʹʹ΄’][\s\xa0]*Τι(?:μ(?:[οό]θεο)?)?)|P(?:ili[\s\xa0]*Tim(?:otheo)?|a(?:ulus(?:’[\s\xa0]*(?:Andet[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Timotheus|andre[\s\xa0]*brev[\s\xa0]*til[\s\xa0]*Timoteus)|'[\s\xa0]*Andet[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Timotheus)|vlova[\s\xa0]*druga[\s\xa0]*poslanica[\s\xa0]*Timoteju))|T(?:oinen[\s\xa0]*(?:Kirje[\s\xa0]*Timoteukselle|Timoteu(?:kselle|skirje))|im(?:ōtt[eē]yuvukku[\s\xa0]*E(?:[lḻ]utiya[\s\xa0]*Ira(?:[nṇ](?:[tṭ](?:[aā]vatu[\s\xa0]*Nirupam))))|ot(?:eyos[\s\xa0]*Labaad|t[eē]yuvukku[\s\xa0]*E(?:[lḻ]utiya[\s\xa0]*Ira(?:[nṇ](?:[tṭ](?:[aā]vatu[\s\xa0]*Nirupam))))|heo[\s\xa0]*II))|īm[oō]tt(?:[eē]yuvukku[\s\xa0]*E(?:[lḻ]utiya[\s\xa0]*Ira(?:[nṇ](?:[tṭ](?:[aā]vatu[\s\xa0]*Nirupam)))))|weede[\s\xa0]*Tim(?:ot(?:he[uü]s|e[uü]s))?)|二テモテ|M(?:[aá]sodik[\s\xa0]*Tim(?:[oó]t(?:heosz|eus(?:hoz|nak)?))?)|த(?:ிம[ொோ]த்தேயுவுக்கு[\s\xa0]*எழுதிய[\s\xa0]*இரண்டாம்[\s\xa0]*திருமுகம்|ீமோத்தேயுவுக்கு[\s\xa0]*எழுதிய[\s\xa0]*இரண்டா(?:ம்[\s\xa0]*கடிதம்|வது[\s\xa0]*நிருபம்))|Προς[\s\xa0]*Τιμ[οό]θεον[\s\xa0]*Β['ʹʹ΄’]|Втор(?:а[\s\xa0]*(?:Тим(?:оте[ийј])?|писмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*Тимотеј)|о[\s\xa0]*(?:п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*Тимотеј|ослание[\s\xa0]*(?:на[\s\xa0]*св(?:\.[\s\xa0]*ап(?:\.[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимотея|[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимотея)|[\s\xa0]*ап(?:\.[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимотея|[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимотея))|към[\s\xa0]*Тимоте[ий]))|Тимотеј))|I(?:kalawang[\s\xa0]*(?:Kay[\s\xa0]*Timoteo|Timoteo)|I(?:[\s\xa0]*(?:list[\s\xa0]*Tim[eo]teovi|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*Тимотеј|ослан(?:ица[\s\xa0]*Тимотеју|ня[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія))))|T(?:omothy|ím|ymoteusza|himot(?:hy|y)|m|i(?:-?mô-?thê|m(?:ot(?:ius|h(?:e(?:üs|o(?:sz)?|e|u[ms])|y|ée)?|y|e(?:j(?:ovi|u[\s\xa0]*Poslanica)|o(?:vi)?|üs|u(?:kselle|s(?:kirje|hoz|nak)?)|i|yos)?)|ôthê|ót(?:e(?:o|us(?:hoz|nak)?)|heosz))?))|K(?:irje[\s\xa0]*Timoteukselle|ay[\s\xa0]*Timoteo)|List[\s\xa0]*(?:(?:[sś]w(?:\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tymoteusza|[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tymoteusza))|do[\s\xa0]*Tymoteusza)|Ти(?:­мофія|м(?:о(?:те(?:[ий]|ју?)|фію))?))|\.[\s\xa0]*(?:list[\s\xa0]*Tim[eo]teovi|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*Тимотеј|ослан(?:ица[\s\xa0]*Тимотеју|ня[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія))))|T(?:omothy|ím|ymoteusza|himot(?:hy|y)|m|i(?:-?mô-?thê|m(?:ot(?:ius|h(?:e(?:üs|o(?:sz)?|e|u[ms])|y|ée)?|y|e(?:j(?:ovi|u[\s\xa0]*Poslanica)|o(?:vi)?|üs|u(?:kselle|s(?:kirje|hoz|nak)?)|i|yos)?)|ôthê|ót(?:e(?:o|us(?:hoz|nak)?)|heosz))?))|K(?:irje[\s\xa0]*Timoteukselle|ay[\s\xa0]*Timoteo)|List[\s\xa0]*(?:(?:[sś]w(?:\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tymoteusza|[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tymoteusza))|do[\s\xa0]*Tymoteusza)|Ти(?:­мофія|м(?:о(?:те(?:[ий]|ју?)|фію))?))))|Barua[\s\xa0]*ya[\s\xa0]*Pili[\s\xa0]*kwa[\s\xa0]*Timotheo|ଦ୍ୱିତୀୟ[\s\xa0]*ତୀମଥିଙ୍କ|ତୀମଥିଙ୍କ[\s\xa0]*ପ୍ରତି[\s\xa0]*ଦ୍ୱିତୀୟ[\s\xa0]*ପତ୍ର|دوم(?:[\s\xa0]*ت(?:ِیمُتھِیُس|ی(?:ِمُتھِیُس|مِتھُیس))|۔تیمتھیس|-?تِیمُتھِیُس)|۲(?:[\s\xa0]*ت(?:ِیمُتھِیُس|ی(?:ِمُتھِیُس|مِتھُیس))|۔تیمتھیس|-?تِیمُتھِیُس)|ה(?:איגרת[\s\xa0]*השנייה[\s\xa0]*אל[\s\xa0]*טימותיוס|שנייה[\s\xa0]*אל[\s\xa0]*טימותיאוס))|(?:D(?:ruh(?:[aá][\s\xa0]*(?:T(?:m|im(?:ote(?:ovi|us|jovi))?)|kniha[\s\xa0]*Timote(?:ovi|jovi)))|euxi[eè]mes[\s\xa0]*Timoth(?:[eé]e))|2[ao]\.[\s\xa0]*Tim(?:[oó]teo))|(?:弟茂德後書》?|ad[\s\xa0]*Timotheum[\s\xa0]*II|II(?:\.[\s\xa0]*Ti(?:moteju)?|[\s\xa0]*Ti(?:moteju)?)|Timotheum[\s\xa0]*II|《(?:提(?:摩(?:太(?:后书|後書)|斐後)|[後后])|弟茂德後書)|तीमथ्थाला[\s\xa0]*दुसरे[\s\xa0]*पत्र|2(?:\.[\s\xa0]*Ti(?:moteju)?|[\s\xa0]*Ti(?:moteju)?)|Druga[\s\xa0]*(?:poslanica[\s\xa0]*Timoteju|Timoteju)|השנייה[\s\xa0]*אל[\s\xa0]*טימותיוס|提(?:摩(?:斐後》?|太(?:後書》?|后书》?))|[后後]》?)))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["1Tim"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])(1[\s\xa0]*tim(?:otʰ(?:i(?:l[aā][iī]|us)|īl[aā][iī])|atʰtʰ[aā]l[aā])|(?:《(?:弟茂德前書》|提(?:前》|摩(?:斐前》|太前[书書]》)))|த(?:ிம[ொோ]த்தேயுவுக்கு[\s\xa0]*எழுதிய[\s\xa0]*முதல்[\s\xa0]*திருமுகம்|ீமோத்தேயுவுக்கு[\s\xa0]*எழுதிய[\s\xa0]*முதலா(?:ம்[\s\xa0]*கடிதம்|வது[\s\xa0]*நிருபம்))|F(?:irst[\s\xa0]*T(?:omothy|i(?:m(?:ot(?:hy?|y))?)?|himot(?:hy|y)|m)|yrra[\s\xa0]*(?:br(?:[eé]f[\s\xa0]*P(?:[aá]ls[\s\xa0]*til[\s\xa0]*T(?:[ií]m(?:[oó]t(?:eusar)?))))|T[ií]m(?:[oó]teusarbr(?:[eé]f)))|(?:[oö]rsta[\s\xa0]*Timot(?:heosbrevet|eusbrevet))|ørste[\s\xa0]*Tim(?:ot(?:heusbrev|eus(?:brev)?))?)|디모데1서|पौलाचे[\s\xa0]*तीमथ्याला[\s\xa0]*पहिले[\s\xa0]*पत्र|Waraka[\s\xa0]*wa[\s\xa0]*Kwanza[\s\xa0]*kwa[\s\xa0]*Timotheo|Una(?:[\s\xa0]*(?:Kay[\s\xa0]*Timoteo|Timoteo)|ng[\s\xa0]*(?:Kay[\s\xa0]*Timoteo|Timoteo))|テモテ(?:[\s\xa0]*1|前書|への(?:前の書|手紙一)|ヘの第一の手紙)|P(?:a(?:vlova[\s\xa0]*prva[\s\xa0]*poslanica[\s\xa0]*Timoteju|ulus(?:'[\s\xa0]*(?:Første[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Timotheus|1(?:\.[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Timotheus|[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Timotheus))|’[\s\xa0]*(?:Første[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Timotheus|første[\s\xa0]*brev[\s\xa0]*til[\s\xa0]*Timoteus|1(?:\.[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Timotheus|[\s\xa0]*Brev[\s\xa0]*til[\s\xa0]*Timotheus))))|ierwsz(?:[aey][\s\xa0]*(?:Tym(?:oteusza)?|List[\s\xa0]*(?:(?:[sś]w(?:\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tymoteusza|[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tymoteusza))|do[\s\xa0]*Tymoteusza)))|r(?:v(?:n[ií][\s\xa0]*(?:list[\s\xa0]*Tim(?:[eo]teovi|T(?:im(?:ote(?:ovi|us))?|m)))|á[\s\xa0]*(?:kniha[\s\xa0]*Timote(?:ovi|jovi)|Timote(?:ovi|jovi))|a[\s\xa0]*(?:Timote(?:j(?:ovi|u[\s\xa0]*Poslanica)|ovi)|kniha[\s\xa0]*Timote(?:ovi|jovi))|(?:[yý][\s\xa0]*(?:list[\s\xa0]*Timote(?:ovi|jovi)|Timote(?:ovi|jovi))))|im(?:o[\s\xa0]*Timoteo|a[\s\xa0]*(?:lettera[\s\xa0]*a[\s\xa0]*Timoteo|Timoteo)|e(?:r(?:o[\s\xa0]*Timoteo|[\s\xa0]*Timoteo)|ir[ao][\s\xa0]*Tim(?:[oó]teo)))|em(?:i(?:ère(?:[\s\xa0]*Timoth[eé]e|s[\s\xa0]*Timoth[eé]e)|er(?:[\s\xa0]*Timoth[eé]e|e(?:[\s\xa0]*Timoth[eé]e|s[\s\xa0]*Timoth[eé]e)|s[\s\xa0]*Timoth[eé]e))|ye[\s\xa0]*Timote))|er[sš]e[\s\xa0]*poslannja[\s\xa0]*apostola[\s\xa0]*Pavla[\s\xa0]*do[\s\xa0]*Tymofija)|ا(?:لرسالة[\s\xa0]*الأولى[\s\xa0]*إلى[\s\xa0]*تيموثاوس|وّل(?:۔تیمتھیس|[\s\xa0]*ت(?:ِیمُتھِیُس|یمِتھُیس)|-?تِیمُتھِیُس))|T(?:im(?:ot(?:eyos[\s\xa0]*Kowaad|heo[\s\xa0]*I|t[eē]yuvukku[\s\xa0]*E(?:[lḻ]utiya[\s\xa0]*Mutal(?:[aā]vatu[\s\xa0]*Nirupam)))|ōtt[eē]yuvukku[\s\xa0]*E(?:[lḻ]utiya[\s\xa0]*Mutal(?:[aā]vatu[\s\xa0]*Nirupam)))|īm[oō]tt(?:[eē]yuvukku[\s\xa0]*E(?:[lḻ]utiya[\s\xa0]*Mutal(?:[aā]vatu[\s\xa0]*Nirupam))))|K(?:oiro[\s\xa0]*Ximootiyoosa|wanza[\s\xa0]*Tim(?:otheo)?)|ت(?:یمتھیس[\s\xa0]*کے[\s\xa0]*نام[\s\xa0]*کا[\s\xa0]*پہلا[\s\xa0]*خط|ِیمُتھِیُس[\s\xa0]*کے[\s\xa0]*نام[\s\xa0]*(?:پولُس[\s\xa0]*رسول[\s\xa0]*کا[\s\xa0]*پہلا[\s\xa0]*خط|کا[\s\xa0]*پہلا[\s\xa0]*خط)|يموثاوس[\s\xa0]*الأولى)|۱(?:۔تیمتھیس|[\s\xa0]*ت(?:ِیمُتھِیُس|یمِتھُیس)|-?تِیمُتھِیُس)|I(?:\.[\s\xa0]*(?:list[\s\xa0]*Tim[eo]teovi|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*Тимотеј|ослан(?:ица[\s\xa0]*Тимотеју|ня[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія))))|T(?:omothy|ím|ym(?:oteusza)?|himot(?:hy|y)|m|i(?:-?mô-?thê|m(?:ot(?:ius|h(?:e(?:üs|o(?:sz)?|e|u[ms])|y|ée)?|y|e(?:j(?:ovi|u[\s\xa0]*Poslanica)|o(?:vi)?|üs|u(?:kselle|s(?:kirje|hoz|nak)?)|i|yos)?)|ôthê|ót(?:e(?:o|us(?:hoz|nak)?)|heosz))?))|K(?:irje[\s\xa0]*Timoteukselle|ay[\s\xa0]*Timoteo)|List[\s\xa0]*(?:(?:[sś]w(?:\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tymoteusza|[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tymoteusza))|do[\s\xa0]*Tymoteusza)|Ти(?:­мофія|м(?:о(?:те(?:[ий]|ју?)|фію))?))|[\s\xa0]*(?:list[\s\xa0]*Tim[eo]teovi|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*Тимотеј|ослан(?:ица[\s\xa0]*Тимотеју|ня[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія))))|T(?:omothy|ím|ym(?:oteusza)?|himot(?:hy|y)|m|i(?:-?mô-?thê|m(?:ot(?:ius|h(?:e(?:üs|o(?:sz)?|e|u[ms])|y|ée)?|y|e(?:j(?:ovi|u[\s\xa0]*Poslanica)|o(?:vi)?|üs|u(?:kselle|s(?:kirje|hoz|nak)?)|i|yos)?)|ôthê|ót(?:e(?:o|us(?:hoz|nak)?)|heosz))?))|K(?:irje[\s\xa0]*Timoteukselle|ay[\s\xa0]*Timoteo)|List[\s\xa0]*(?:(?:[sś]w(?:\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tymoteusza|[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tymoteusza))|do[\s\xa0]*Tymoteusza)|Ти(?:­мофія|м(?:о(?:те(?:[ий]|ју?)|фію))?)))|티모테오(?:1서|에게[\s\xa0]*보낸[\s\xa0]*첫째[\s\xa0]*서간)|1(?:티모|Tim|[oa](?:[\s\xa0]*Tim(?:[oó]teo|\.[\s\xa0]*Tim[oó]teo))|(?:[°º](?:\.[\s\xa0]*Timoteo|[\s\xa0]*Timoteo))|(?:[яе](?:\.[\s\xa0]*(?:к[\s\xa0]*Тимофею|Тим(?:етею|офею))|[\s\xa0]*(?:к[\s\xa0]*Тимофею|Тим(?:етею|офею))))|re(?:[\s\xa0]*Timoth[eé]e|\.[\s\xa0]*Timoth[eé]e)|۔تیمتھیس|ère(?:[\s\xa0]*Timoth[eé]e|\.[\s\xa0]*Timoth[eé]e)|[\s\xa0]*(?:tīmatʰtʰ[aā]l[aā]|к[\s\xa0]*Тимофею|list[\s\xa0]*Tim[eo]teovi|ت(?:ِیمُتھِیُس|یمِتھُیس)|Xim|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*Тимотеј|ослан(?:ица[\s\xa0]*Тимотеју|ня[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія))))|त(?:ीम(?:ु(?:ाथैयुस|थियुस)|थ्[थय]ाला)?|िम(?:ोथी(?:लाई)?|ुथियुस))|த(?:ீமோத்(?:தேயு)?|ிமொ(?:த்தேயு)?)|K(?:irje[\s\xa0]*Timoteukselle|a(?:y[\s\xa0]*Timoteo|ng[\s\xa0]*Timoteo))|T(?:omothy|ím|ym(?:oteusza)?|eemuathaiyus|himot(?:hy|y)|m|i(?:-?mô-?thê|m(?:ōtt[eē]yuvukku|ôthê|ot(?:ius|t[eē]yuvukku|y|h(?:e(?:üs|o(?:s(?:brevet|z))?|e|u(?:m|s(?:brev)?))|y|ée)?|e(?:j(?:ovi|u[\s\xa0]*Poslanica)|o(?:vi)?|üs|u(?:kselle|s(?:kirje|brev(?:et)?|hoz|nak)?|t)|i|yos)?)|ót(?:e(?:o|us(?:hoz|nak)?)|heosz))?)|īm[oō]tt(?:[eē]yuvukku))|طيم|k(?:\.[\s\xa0]*Timote(?:ovi|jovi)|[\s\xa0]*Timote(?:ovi|jovi))|ତୀମଥିଙ୍କ|(?:[ei](?:[\s\xa0]*Timoteut|\.[\s\xa0]*Timoteut))|ਤਿਮੋਥਿਉਸ[\s\xa0]*ਨੂੰ|List[\s\xa0]*(?:(?:[sś]w(?:\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tymoteusza|[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tymoteusza))|do[\s\xa0]*Tymoteusza)|ท(?:ิโมธี|ธ)|Ти(?:­мофія|м(?:етею|о(?:те(?:[ий]|ју?)|ф[еі]ю))?))|st(?:[\s\xa0]*T(?:omothy|i(?:m(?:ot(?:hy?|y))?)?|himot(?:hy|y)|m)|\.[\s\xa0]*T(?:omothy|i(?:m(?:ot(?:hy?|y))?)?|himot(?:hy|y)|m))|\.(?:(?:[oº](?:\.[\s\xa0]*Timoteo|[\s\xa0]*Timoteo))|[\s\xa0]*(?:к[\s\xa0]*Тимофею|list[\s\xa0]*Tim[eo]teovi|ทิโมธี|ت(?:ِیمُتھِیُس|یمِتھُیس)|п(?:исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*Тимотеј|ослан(?:ица[\s\xa0]*Тимотеју|ня[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія))))|K(?:irje[\s\xa0]*Timoteukselle|a(?:y[\s\xa0]*Timoteo|ng[\s\xa0]*Timoteo))|त(?:ीम(?:ु(?:ाथैयुस|थियुस))?|िम(?:ोथी(?:लाई)?|ुथियुस))|ତୀମଥିଙ୍କ|timotʰ[iī]l(?:[aā][iī])|T(?:omothy|i(?:-?mô-?thê|m(?:ot(?:ius|y|h(?:e(?:üs|o(?:s(?:brevet|z))?|e|u(?:m|s(?:brev)?))|y|ée)?|e(?:j(?:ovi|u[\s\xa0]*Poslanica)|o(?:vi)?|üs|u(?:kselle|s(?:kirje|brev(?:et)?|hoz|nak)?|t)|i|yos)?)|ôthê|ót(?:e(?:o|us(?:hoz|nak)?)|heosz))?)|ím|ym(?:oteusza)?|eemuathaiyus|himot(?:hy|y)|m)|List[\s\xa0]*(?:(?:[sś]w(?:\.[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tymoteusza|[\s\xa0]*Pawła[\s\xa0]*do[\s\xa0]*Tymoteusza))|do[\s\xa0]*Tymoteusza)|Ти(?:­мофія|м(?:етею|о(?:те(?:[ий]|ју?)|ф[еі]ю))?))|۔تیمتھیس|-?تِیمُتھِیُس)|-?(?:تِیمُتھِیُس|я(?:\.[\s\xa0]*(?:к[\s\xa0]*Тимофею|Тим(?:етею|офею))|[\s\xa0]*(?:к[\s\xa0]*Тимофею|Тим(?:етею|офею)))|а(?:[\s\xa0]*(?:Ти(?:мо(?:те[ий]|фію)|­мофія)|послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія)))|\.[\s\xa0]*(?:Ти(?:мо(?:те[ий]|фію)|­мофія)|послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія))))|е(?:\.[\s\xa0]*(?:Ти(?:­мофія|м(?:етею|о(?:те[ий]|ф[еі]ю)))|к[\s\xa0]*Тимофею|послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія)))|[\s\xa0]*(?:Ти(?:­мофія|м(?:етею|о(?:те[ий]|ф[еі]ю)))|к[\s\xa0]*Тимофею|послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія))))|ше(?:[\s\xa0]*(?:Ти(?:мо(?:те[ий]|фію)|­мофія)|послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія)))|\.[\s\xa0]*(?:Ти(?:мо(?:те[ий]|фію)|­мофія)|послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія)))))|e(?:r(?:[\s\xa0]*Timoth[eé]e|e(?:[\s\xa0]*Timoth[eé]e|\.[\s\xa0]*Timoth[eé]e)|\.[\s\xa0]*Timoth[eé]e)|[\s\xa0]*Tim(?:ot(?:he[uü]s|e[uü]s))?|\.[\s\xa0]*Tim(?:ot(?:he[uü]s|e[uü]s))?))|رسالة[\s\xa0]*بولس[\s\xa0]*الرسول[\s\xa0]*الأولى[\s\xa0]*إلى[\s\xa0]*تيموثاوس|ତୀମଥିଙ୍କ[\s\xa0]*ପ୍ରତି[\s\xa0]*ପ୍ରଥମ[\s\xa0]*ପତ୍ର|ה(?:ראשונה[\s\xa0]*אל[\s\xa0]*טימותיאוס|איגרת[\s\xa0]*הראשונה[\s\xa0]*אל[\s\xa0]*טימותיוס)|Α(?:['ʹʹ΄’][\s\xa0]*Τι(?:μ(?:[οό]θεο)?)?)|त(?:िमोथीलाई(?:र्[\s\xa0]*पावलको[\s\xa0]*पहिलो[\s\xa0]*पत्र|[\s\xa0]*पहिलो[\s\xa0]*पत्र)|ीमथ्थाला[\s\xa0]*पहिले[\s\xa0]*पत्र)|Προς[\s\xa0]*Τιμ[οό]θεον[\s\xa0]*Α['ʹʹ΄’]|П(?:рв(?:а[\s\xa0]*(?:п(?:осланица[\s\xa0]*Тимотеју|исмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*Тимотеј)|Тимотеју?)|о[\s\xa0]*(?:Тимотеј|писмо[\s\xa0]*од[\s\xa0]*апостол[\s\xa0]*Павле[\s\xa0]*до[\s\xa0]*Тимотеј))|ерш(?:[ае][\s\xa0]*(?:Ти(?:мо(?:те[ий]|фію)|­мофія)|послання[\s\xa0]*(?:апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимофія|до[\s\xa0]*Тимо(?:тея|фія)|Тимофію|св(?:[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія|\.[\s\xa0]*апостола[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Ти­мофія))))|ърв(?:а[\s\xa0]*Тим(?:оте[ий])?|о[\s\xa0]*послание[\s\xa0]*(?:на[\s\xa0]*св(?:\.[\s\xa0]*ап(?:\.[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимотея|[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимотея)|[\s\xa0]*ап(?:\.[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимотея|[\s\xa0]*Павла[\s\xa0]*до[\s\xa0]*Тимотея))|към[\s\xa0]*Тимоте[ий])))|一テモテ|ପ୍ରଥମ[\s\xa0]*ତୀମଥିଙ୍କ|ਤਿਮੋਥਿਉਸ[\s\xa0]*ਨੂੰ[\s\xa0]*ਪਹਿਲੀ[\s\xa0]*ਪੱਤ੍ਰੀ|E(?:nsimm(?:[aä]inen[\s\xa0]*(?:Kirje[\s\xa0]*Timoteukselle|Timoteu(?:kselle|skirje)))|rste[\s\xa0]*Timotheus|pistula[\s\xa0]*(?:ad[\s\xa0]*Timotheum[\s\xa0]*I|I[\s\xa0]*ad[\s\xa0]*Timotheum)|ls(?:[oő][\s\xa0]*Tim(?:[oó]t(?:heosz|eus(?:hoz|nak)?))?)|erste[\s\xa0]*Tim(?:ot(?:he[uü]s|e[uü]s))?)|אגרת[\s\xa0]*פולוס[\s\xa0]*הראשונה[\s\xa0]*אל-?טימות|Barua[\s\xa0]*ya[\s\xa0]*Kwanza[\s\xa0]*kwa[\s\xa0]*Timotheo|t(?:im(?:otʰ(?:īl[aā](?:[iī][\s\xa0]*pahilo[\s\xa0]*patra)|i(?:us[\s\xa0]*nū̃[\s\xa0]*pahilī[\s\xa0]*pattrī|l[aā](?:[iī][\s\xa0]*pahilo[\s\xa0]*patra)))|atʰtʰ[aā]l(?:[aā][\s\xa0]*pahile[\s\xa0]*patra))|īm(?:utʰiyus[\s\xa0]*ke[\s\xa0]*nām[\s\xa0]*kā[\s\xa0]*pahlā[\s\xa0]*ḫaṭ|atʰtʰ[aā]l(?:[aā][\s\xa0]*pahile[\s\xa0]*patra)))|ﺍﻻﻭﻝ[\s\xa0]*ﺗﻴﻤﻮﺛﺎﻭﺱ)|(?:Prvn(?:[ií][\s\xa0]*T(?:im(?:ote(?:ovi|us))?|m))|1[ao]\.[\s\xa0]*Tim(?:[oó]teo))|(?:Timoth(?:y|eum[\s\xa0]*I)?|Prva[\s\xa0]*(?:poslanica[\s\xa0]*Timoteju|Timoteju)|ad[\s\xa0]*Timotheum[\s\xa0]*I|弟茂德前書》?|提(?:前》?|摩(?:斐前》?|太前[书書]》?))|《(?:提(?:摩(?:斐前|太前[书書])|前)|弟茂德前書)|(?:[I1](?:\.[\s\xa0]*Ti(?:moteju)?|[\s\xa0]*Ti(?:moteju)?))|הראשונה[\s\xa0]*אל[\s\xa0]*טימותיוס))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["Deut"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])((?:Li(?:gji[\s\xa0]*i[\s\xa0]*P[eë]rt(?:[eë]rir[eë])|ber[\s\xa0]*Deuteronomii|P)|Δε(?:υτ(?:ερ(?:ον[οό]μιον?)?)?)?|ا(?:ستثناء?|ِستِثنا)|Za(?:rW|arettido[\s\xa0]*Wogaa)|ਬਿਵਸਥਾ[\s\xa0]*ਸਾਰ|anuw[aā]d|P(?:i(?:ata[\s\xa0]*(?:Ks(?:[\s\xa0]*Moj[zż]eszowa|\.[\s\xa0]*Moj[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|Moj(?:ż(?:eszowa)?|z(?:i[sš]ova|eszowa)?|ži[sš]ova)|kniha[\s\xa0]*Moj[zž]i(?:[sš]ova))|ąta[\s\xa0]*(?:Ks(?:[\s\xa0]*Moj[zż]eszowa|\.[\s\xa0]*Moj[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|Moj(?:[zż](?:eszowa)?)))|o(?:novljeni[\s\xa0]*zakon|vtorennja[\s\xa0]*Zakonu)|wt|a(?:t[aá][\s\xa0]*(?:kniha[\s\xa0]*Moj(?:[zž](?:[ií](?:[sš]ova))|Moj[zž](?:[ií](?:[sš]ova))))|ngandharing[\s\xa0]*Toret)|nz|hục[\s\xa0]*truyền[\s\xa0]*luật[\s\xa0]*lệ[\s\xa0]*ký|át[aá][\s\xa0]*(?:kniha[\s\xa0]*Moj(?:[zž](?:[ií](?:[sš]ova))|Moj[zž](?:[ií](?:[sš]ova)))))|F(?:(?:[uü]nfte[\s\xa0]*(?:Mose|Buch[\s\xa0]*Mose))|emte[\s\xa0]*Mos(?:ebo(?:g|k(?:en)?))?|immta[\s\xa0]*(?:b[oó]k[\s\xa0]*M(?:[oó]se)|M[oó]seb(?:[oó]k)))|Вт(?:ор(?:озак(?:он(?:ня|ие))?)?)?|5(?:Mós|[\s\xa0]*(?:Ks(?:[\s\xa0]*Moj[zż]eszowa|\.[\s\xa0]*Moj[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|k(?:[\s\xa0]*Moj[zž]i(?:[sš]ova)|niha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova))|\.[\s\xa0]*Moj[zž]i(?:[sš]ova))|M(?:z|ó(?:s(?:eb[oó]k)?|z(?:es)?)|o(?:j(?:ž[ií](?:[sš]ova)|ż(?:eszowa)?|z(?:[ií](?:[sš]ova)|eszowa)?)?|s(?:e(?:b(?:ók|o(?:g|k(?:en)?)))?)?|os(?:eksen[\s\xa0]*kirja)?|z(?:es)?)?)?|Buch[\s\xa0]*Mose|М(?:о(?:јс(?:ијева)?|исеева))?)|\.[\s\xa0]*(?:Мојс(?:ијева)?|Ks(?:[\s\xa0]*Moj[zż]eszowa|\.[\s\xa0]*Moj[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|M(?:o(?:s(?:e(?:b(?:ók|o(?:g|k(?:en)?)))?)?|j(?:ž[ií](?:[sš]ova)|ż(?:eszowa)?|z(?:[ií](?:[sš]ova)|eszowa)?)|oseksen[\s\xa0]*kirja|zes)?|ós(?:eb[oó]k)?)|kniha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova))|Buch[\s\xa0]*Mose))|เฉลย(?:ธรรมบัญญัติ|​ธรรม​บัญญัติ)|《申(?:》|命[紀記记]》)|ଦ୍ୱିତୀୟ[\s\xa0]*ବିବରଣୀ?|דברים|משנה[\s\xa0]*תורה|П(?:ет(?:а[\s\xa0]*(?:Мојс(?:ијева)?|книга[\s\xa0]*Моисеева)|та[\s\xa0]*книга[\s\xa0]*Мојсеева)|о(?:н(?:овљени[\s\xa0]*закони|з)|вт(?:орен(?:ня[\s\xa0]*Закону|и[\s\xa0]*закони)|[\s\xa0]*Закону|\.[\s\xa0]*Закону))|['’]ята[\s\xa0]*книга[\s\xa0]*Мо(?:[ий]сеева))|व्य(?:वस्था(?:विवरण|को[\s\xa0]*पुस्तक|[\s\xa0]*विवरण)|्वस्थाविवरन|ावस्था)|V(?:i(?:ides[\s\xa0]*Mooseksen[\s\xa0]*kirja|jfde[\s\xa0]*Mozes)|[\s\xa0]*(?:Мојс(?:ијева)?|Ks(?:[\s\xa0]*Moj[zż]eszowa|\.[\s\xa0]*Moj[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|M(?:o(?:j(?:ž[ií](?:[sš]ova)|ż(?:eszowa)?|z(?:[ií](?:[sš]ova)|eszowa)?)?|s(?:eb[oó]k)?|oseksen[\s\xa0]*kirja|zes)|ós(?:eb[oó]k)?)|kniha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova)))|\.[\s\xa0]*(?:Мојс(?:ијева)?|Ks(?:[\s\xa0]*Moj[zż]eszowa|\.[\s\xa0]*Moj[zż]eszowa|i[eę]g(?:[ai][\s\xa0]*Moj(?:[zż]eszowa)))|kniha[\s\xa0]*Moj[zž](?:[ií](?:[sš]ova))|M(?:o(?:j(?:ž[ií](?:[sš]ova)|ż(?:eszowa)?|z(?:[ií](?:[sš]ova)|eszowa)?)|s(?:eb[oó]k)?|oseksen[\s\xa0]*kirja|zes)|ós(?:eb[oó]k)?))|yavasthaavivaran)|M(?:[aá]sodik[\s\xa0]*t(?:[oö]rv(?:[eé]nyk(?:[oö]nyv)))|T[oö]rv|[oó]zes[\s\xa0]*(?:(?:[oö]t(?:[oö]dik[\s\xa0]*k(?:[oö]nyve))|V)))|Đệ[\s\xa0]*nhị[\s\xa0]*luật|سفر[\s\xa0]*التثنية|vyavastʰ[aā]ko[\s\xa0]*pustak|Andharaning[\s\xa0]*Tor[eè]t|신(?:명기?)?|ت(?:ث(?:نية[\s\xa0]*الإشتراع)?|َثنِيَة)|Sharci(?:ga[\s\xa0]*Kunoqoshadiisa)?|istis̱nā|இ(?:ணைச்[\s\xa0]*சட்டம்|ச)|bivastʰā[\s\xa0]*sār|உபா(?:கமம்)?|K(?:s(?:[\s\xa0]*Powt(?:[oó]rzonego[\s\xa0]*Prawa|[\s\xa0]*Prawa)|i[eę]g(?:[ai][\s\xa0]*Powt(?:(?:[oó]rzonego[\s\xa0]*Prawa|[\s\xa0]*Prawa)))|\.[\s\xa0]*Powt(?:[oó]rzonego[\s\xa0]*Prawa|[\s\xa0]*Prawa))|um(?:b(?:ukumbu[\s\xa0]*la[\s\xa0]*(?:Sheria|Torati))?)?|itabu[\s\xa0]*cha[\s\xa0]*Tano[\s\xa0]*cha[\s\xa0]*Musa)|ବିବରଣି|Up[aā]kamam|ฉธบ|D(?:yuteronomyo|u(?:et(?:eron(?:my|om(?:io|y))|ron(?:omy|my)|oron(?:omy|my))?|ut(?:ron(?:omy|my)|(?:[eo]ron(?:omy|my))))|tn?|iyuteronomyo|e(?:zy[eè]m[\s\xa0]*liv[\s\xa0]*Lalwa[\s\xa0]*a|yuteronomyo|wariem|t(?:e[rw]on(?:[oò]m))?|u(?:t(?:ron(?:m(?:io|y)|om(?:io|y))|eron(?:ómi(?:um|o)|m(?:io|y)|ômio|om(?:ul|i(?:um|y[ao]|[ao])?|[ae]|ya?)?)|éronome|oron(?:m(?:io|y)|om(?:io|y)))?)?|et(?:ron(?:omy|my)|(?:[eo]ron(?:omy|my))))?)|अनुवाद)|P[aá]t(?:[aá][\s\xa0]*Moj(?:[zž](?:[ií](?:[sš]ova))))|(?:Kumbukumbu|التثنية|vyavastʰ[āa]ko|Ligji[\s\xa0]*i[\s\xa0]*përtërirë|Повт|ਬਿਵਸਥਾ|V(?:\.[\s\xa0]*Mooseksen|iides[\s\xa0]*Mooseksen|[\s\xa0]*Mooseksen)|申(?:命[紀記记]》?|》)?|5(?:\.[\s\xa0]*Mooseksen|[\s\xa0]*Mooseksen)|《申(?:命[记記紀])?|Phục(?:[\s\xa0]*Truyền(?:[\s\xa0]*Luật[\s\xa0]*Lệ)?)?|व्यवस्था(?:को)?))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["Titus"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(tit(?:āl[aā][\\s\\xa0]*patra|a(?:sl[aā](?:[iī][\\s\\xa0]*patra)|l[aā][\\s\\xa0]*patra))|(?:티토(?:에게[\\s\\xa0]*보낸[\\s\\xa0]*서간|서)?|tīt(?:āl[aā][\\s\\xa0]*patra|us[\\s\\xa0]*nū̃[\\s\\xa0]*pattrī|a(?:sl[aā](?:[iī][\\s\\xa0]*patra)|l[aā][\\s\\xa0]*patra))|الرسالة[\\s\\xa0]*إلى[\\s\\xa0]*تيطس|テ(?:トス(?:への(?:手紙|て[かが]み|書)|書|ヘの手紙)?|ィトに達する書)|تي|ﺗﻴﻄﺲ|T(?:i(?:it(?:os|u)?|t(?:tuvukku[\\s\\xa0]*E[lḻ]utiya[\\s\\xa0]*Nirupam|it?|[eô]|us(?:brevet|arbr(?:[eé]f(?:ið)?)|z(?:hoz)?|hoz))?)?|īttuvukku[\\s\\xa0]*E[lḻ]utiya[\\s\\xa0]*Nirupam|yt|í(?:ch|t(?:usarbr(?:[eé]f(?:ið)?))?)|t|eetus)|П(?:ослан(?:[\\s\\xa0]*ня[\\s\\xa0]*до[\\s\\xa0]*Тита|ня[\\s\\xa0]*(?:апостола[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Тита|св(?:[\\s\\xa0]*апостола[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Тита|\\.[\\s\\xa0]*апостола[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Тита))|и(?:е[\\s\\xa0]*(?:на[\\s\\xa0]*св(?:\\.[\\s\\xa0]*ап(?:[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Тита|\\.[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Тита)|[\\s\\xa0]*ап(?:[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Тита|\\.[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Тита))|к(?:ъм[\\s\\xa0]*Тит|[\\s\\xa0]*Титу))|ца[\\s\\xa0]*Титу))|исмо[\\s\\xa0]*од[\\s\\xa0]*апостол[\\s\\xa0]*Павле[\\s\\xa0]*до[\\s\\xa0]*Тит)|Προς[\\s\\xa0]*Τ[ίι]τον|तीत(?:स(?:लाई[\\s\\xa0]*प(?:ावलको[\\s\\xa0]*पत्र|त्र))?|ुस)|K(?:a(?:ng[\\s\\xa0]*Tito|y[\\s\\xa0]*Tito)|irje[\\s\\xa0]*Titukselle)|《(?:多》|弟鐸書》|提(?:特書》|多[书書]》))|디도서|L(?:ettera[\\s\\xa0]*a[\\s\\xa0]*Tito|ist[\\s\\xa0]*(?:do[\\s\\xa0]*Tytusa|T[ií]tovi|(?:[sś]w(?:[\\s\\xa0]*Pawła[\\s\\xa0]*do[\\s\\xa0]*Tytusa|\\.[\\s\\xa0]*Pawła[\\s\\xa0]*do[\\s\\xa0]*Tytusa))))|पौलाचे[\\s\\xa0]*तीताला[\\s\\xa0]*पत्र|ṭiṭus[\\s\\xa0]*ke[\\s\\xa0]*nām[\\s\\xa0]*kā[\\s\\xa0]*ḫaṭ|Τ(?:τ|[ίι]το?)|P(?:a(?:vlova[\\s\\xa0]*poslanica[\\s\\xa0]*Titu|ulus['’][\\s\\xa0]*Brev[\\s\\xa0]*til[\\s\\xa0]*Titus)|oslannja[\\s\\xa0]*apostola[\\s\\xa0]*Pavla[\\s\\xa0]*do[\\s\\xa0]*Tyta)|אגרת[\\s\\xa0]*פולוס[\\s\\xa0]*אל-?טיטוס|رسالة[\\s\\xa0]*بولس[\\s\\xa0]*الرسول[\\s\\xa0]*إلى[\\s\\xa0]*تيطس|தீத்(?:து(?:க்கு[\\s\\xa0]*எழுதிய[\\s\\xa0]*திருமுகம்|வுக்கு[\\s\\xa0]*எழுதிய[\\s\\xa0]*(?:நிருபம்|திருமுகம்|கடிதம்))?)?|Epistula[\\s\\xa0]*ad[\\s\\xa0]*Titum|ਤੀਤੁਸ[\\s\\xa0]*ਨੂੰ[\\s\\xa0]*ਪੱਤ੍ਰੀ|ତୀତସଙ୍କ[\\s\\xa0]*ପ୍ରତି[\\s\\xa0]*ପତ୍ର|האיגרת[\\s\\xa0]*אל[\\s\\xa0]*טיטוס|ท(?:ิตัส|ต)|Waraka[\\s\\xa0]*kwa[\\s\\xa0]*Tito|B(?:arua[\\s\\xa0]*kwa[\\s\\xa0]*Tito|r(?:e(?:f[\\s\\xa0]*P[aá]ls[\\s\\xa0]*til[\\s\\xa0]*T(?:[ií]tusar)|vet[\\s\\xa0]*til(?:[\\s\\xa0]*Titus|l[\\s\\xa0]*Titus))|éf[\\s\\xa0]*P[aá]ls[\\s\\xa0]*til[\\s\\xa0]*T(?:[ií]tusar)))|ط(?:ي(?:طس)?|طس[\\s\\xa0]*کے[\\s\\xa0]*نام[\\s\\xa0]*کا[\\s\\xa0]*خط|ِطُس[\\s\\xa0]*کے[\\s\\xa0]*نام[\\s\\xa0]*(?:پولس[\\s\\xa0]*رسُول[\\s\\xa0]*کا[\\s\\xa0]*خط|کا[\\s\\xa0]*خط)))|(?:ਤੀਤੁਸ(?:[\\s\\xa0]*ਨੂੰ)?|多》?|ط(?:طس|ِطُس)|弟鐸書》?|T(?:it(?:u(?:kselle|[ms])?|tuvukku|o(?:vi)?)|ytusa|ítovi|īttuvukku)|ତୀତସଙ୍କ|Тит[ау]?|提(?:特書》?|多[書书]》?)|t(?:īt(?:a(?:sl[aā][īi]|l[āa])|āl[āa]|us)|it(?:a(?:sl[aā][iī]|l[āa])|āl[āa]))|К[\\s\\xa0]*Титу|P(?:oslanica[\\s\\xa0]*Titu|aulus’[\\s\\xa0]*brev[\\s\\xa0]*til[\\s\\xa0]*Titus)|तीत(?:सलाई|ाला(?:[\\s\\xa0]*पत्र)?)|《(?:提(?:特書|多[书書])|多|弟鐸書)|До[\\s\\xa0]*Тита|ad[\\s\\xa0]*Titum|אל[\\s\\xa0]*טיטוס))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Heb"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Євр(?:е[ії])?|Јев|L(?:ist[\\s\\xa0]*(?:do[\\s\\xa0]*(?:[ZŻ]yd(?:[oó]w)|Hebrajczyk[oó]w)|Hebrej[ouů]m|[ZŽ]id(?:[uů]m))|ayang[\\s\\xa0]*Ibrani|ettera[\\s\\xa0]*agli[\\s\\xa0]*Ebrei)|Ibra(?:a(?:aniyon|we))?|П(?:ослан(?:и(?:е[\\s\\xa0]*(?:к(?:[\\s\\xa0]*Евреям|ъм[\\s\\xa0]*евреите)|на[\\s\\xa0]*св(?:[\\s\\xa0]*ап(?:\\.[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Евреите|[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Евреите)|\\.[\\s\\xa0]*ап(?:\\.[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Евреите|[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Евреите)))|ца[\\s\\xa0]*Јеврејима)|[\\s\\xa0]*ня[\\s\\xa0]*до[\\s\\xa0]*Євре[ії]в|ня[\\s\\xa0]*до[\\s\\xa0]*євре[ії]в)|исмо[\\s\\xa0]*до[\\s\\xa0]*Евреите)|《(?:[來来]》|耶烏雷爾》|希伯(?:來[书書]》|来书》))|H(?:ê-?bơ-?rơ|e(?:pr(?:ealaiskirje)?|(?:[ew]brew(?:ws|s))|b(?:w(?:ers|res)|e(?:r(?:[eorw]s|s|[\\s\\xa0]*lev[eé]l)|w[erw]s|[eo](?:(?:[eor]s|s))|s)|o(?:[eor](?:(?:[eor]s|s))|s)|r(?:r(?:[eorw]s|s)|w(?:es|s)|[æé]erbrevet|äer|o(?:[eor]s|s)|s|ae(?:er|r)|e(?:a(?:br[eé]fið|id)|u[sx]|rs|njve|o(?:s|hanon)|s|e(?:[eë]n|rbrevet|s)|w(?:ws|s)?))?)?)?|br(?:ew(?:ws|s))?|w(?:brew(?:ws|s)|(?:[ew]brew(?:ws|s)))|é(?:b(?:er[\\s\\xa0]*lev[eé]l|r(?:eux)?)?)?)|Προς[\\s\\xa0]*Εβρα[ίι]ους|इब्र(?:ी[\\s\\xa0]*लोकांस[\\s\\xa0]*पत्र|ान(?:ि(?:यों)?|ी))|Cib(?:raaniyada)?|ibr(?:ānīāṃ[\\s\\xa0]*nū̃[\\s\\xa0]*pattrī|[iī][\\s\\xa0]*lok(?:[aā](?:[mṃ]s[\\s\\xa0]*patra)))|Евр(?:еи)?|Kirje[\\s\\xa0]*he[bp]realaisille|Ž(?:d|id(?:om)?)|הא(?:גרת[\\s\\xa0]*אל-?העברים|יגרת[\\s\\xa0]*אל[\\s\\xa0]*העברים)|الرسالة[\\s\\xa0]*إلى[\\s\\xa0]*العبرانيين|Ἑβ|Εβρ?|ਇਬਰਾਨੀਆਂ[\\s\\xa0]*ਨੂੰ[\\s\\xa0]*ਪੱਤ੍ਰੀ|P(?:avlova[\\s\\xa0]*poslanica[\\s\\xa0]*Hebrejima|oslannja[\\s\\xa0]*do[\\s\\xa0]*jevre[iï]v)|Z(?:sid[oó]k(?:hoz[\\s\\xa0]*(?:[ií]rt[\\s\\xa0]*lev(?:[eé]l))?)?|d|id(?:om)?|yd)|Do[\\s\\xa0]*Thái|hibr[uū]har(?:[uū]ko[\\s\\xa0]*nimti[\\s\\xa0]*patra)|हिब्रू(?:हरूको[\\s\\xa0]*निम्ति[\\s\\xa0]*पत्र)?|ฮ(?:ีบรู|บ)|எபி(?:ர(?:ெயருக்கு[\\s\\xa0]*எழுதிய[\\s\\xa0]*நிருபம்|ே(?:யர(?:ுக்கு[\\s\\xa0]*எழுதிய[\\s\\xa0]*(?:திருமுகம்|கடிதம்)|்))?))?|ع(?:ب(?:رانیوں[\\s\\xa0]*کے[\\s\\xa0]*نام[\\s\\xa0]*(?:پولس[\\s\\xa0]*رسول[\\s\\xa0]*کا[\\s\\xa0]*خط|کا[\\s\\xa0]*خط))?|ِبرانیوں[\\s\\xa0]*کے[\\s\\xa0]*نام[\\s\\xa0]*کا[\\s\\xa0]*خط)|ʿibrāniyōṅ[\\s\\xa0]*ke[\\s\\xa0]*nām[\\s\\xa0]*kā[\\s\\xa0]*ḫaṭ|ଏବ୍ରୀ|B(?:r(?:éfið[\\s\\xa0]*til[\\s\\xa0]*Hebrea|e(?:vet[\\s\\xa0]*til[\\s\\xa0]*(?:Hebræerne|hebreerne)|fið[\\s\\xa0]*til[\\s\\xa0]*Hebrea))|arua[\\s\\xa0]*kwa[\\s\\xa0]*Waebrania)|E(?:vr(?:ei)?|pi(?:stula[\\s\\xa0]*ad[\\s\\xa0]*Hebraeos|reyarukku[\\s\\xa0]*E[lḻ]utiya[\\s\\xa0]*Nirupam)|b(?:re?)?)|히브(?:리(?:인들에게[\\s\\xa0]*보낸[\\s\\xa0]*서간|서))?|Mga[\\s\\xa0]*(?:Hebr(?:ohanon|eo)|Ebreo)|Żyd|ヘ(?:[フブ](?:ル(?:人への(?:手紙|書)|書)|ライ(?:人への手紙|書)?))|Waraka[\\s\\xa0]*kwa[\\s\\xa0]*Waebrania)|Zsid|(?:Żyd[oó]w|ad[\\s\\xa0]*Hebraeos|Евре(?:ите|ям)|H(?:e(?:br(?:e(?:erne|j(?:[uoů]m|ima)|o)|a(?:jczyk[oó]w|eos)|æerne)|prealaisille)|ê)|《(?:耶烏雷爾|[来來]|希伯(?:来书|來[書书]))|[来來]》?|אל[\\s\\xa0]*העברים|Јеврејима|हिब्रूहरूको[\\s\\xa0]*निम्ति|hibr[uū]har(?:[ūu]ko[\\s\\xa0]*nimti)|Ibrani|Εβρα[ιί]ους|耶烏雷爾》?|希伯(?:來[书書]》?|来书》?)|इब्री(?:[\\s\\xa0]*लोकांस)?|К[\\s\\xa0]*Евреям|E(?:brei|pireyarukku)|Waebrania|Євре[їі]в|ع(?:ِبرانیوں|برانیوں)|العبرانيين|Poslanica[\\s\\xa0]*Hebrejima|Z(?:id[ůu]m|yd[óo]w|sid[óo]khoz)|Žid[uů]m|ibr(?:[īi][\\s\\xa0]*lok(?:[aā](?:[ṃm]s))|ānīāṃ)|ਇਬਰਾਨੀਆਂ[\\s\\xa0]*ਨੂੰ|До[\\s\\xa0]*євре[ії]в))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Phil"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:L(?:ayang[\\s\\xa0]*Paulus[\\s\\xa0]*Filipi|ist[\\s\\xa0]*(?:(?:[sś]w(?:[\\s\\xa0]*Pawła[\\s\\xa0]*do[\\s\\xa0]*Filipian|\\.[\\s\\xa0]*Pawła[\\s\\xa0]*do[\\s\\xa0]*Filipian))|Filip(?:anom|sk[yý]m)|do[\\s\\xa0]*Filipian)|ettera[\\s\\xa0]*ai[\\s\\xa0]*Filippesi)|பிலி(?:ப்(?:பியர(?:ுக்கு[\\s\\xa0]*எழுதிய[\\s\\xa0]*(?:நிருபம்|திருமுகம்|கடிதம்)|்))?)?|フィリ(?:[ヒピ](?:の信徒への手紙|人への手紙|書)?)|Kirje[\\s\\xa0]*filippil[aä]isille|B(?:r[eé]f[\\s\\xa0]*P(?:[aá]ls[\\s\\xa0]*til[\\s\\xa0]*Filipp(?:[ií]manna?))|arua[\\s\\xa0]*kwa[\\s\\xa0]*Wafilipi)|ﻓﻴﻠﻴﺒﻲ|filipp(?:iyōṅ[\\s\\xa0]*ke[\\s\\xa0]*nām[\\s\\xa0]*kā[\\s\\xa0]*ḫaṭ|īāṃ[\\s\\xa0]*nū̃[\\s\\xa0]*pattrī)|(?:[ヒピ]リ(?:[ヒピ](?:人への(?:手紙|書)|書)))|P(?:h(?:l(?:pp?|ip(?:ians|p(?:ians)?)?)|i(?:l(?:i(?:p(?:a(?:i(?:ns?|ans)|ns?)|e(?:ns|ans)|i(?:ians|a(?:ns?|id)|ns|ens)|p(?:a(?:i(?:ns|ans)|ns?)|pians?|e(?:r|ans?)|i(?:ians|beliekhez|ns?|a(?:ns?|[ai]ns)|ens))?)?)?|p(?:eans|i(?:ns|ans?)|a(?:n|ins)|p(?:pians|i(?:ians|ans?))?)?|l(?:l(?:ip(?:pians|i(?:ians|ans?))|p(?:ians|pians))|p(?:pians?|i(?:ans?|ens)|ans)|i(?:p(?:a(?:i(?:ns?|ans)|ns?)|i(?:ians|e(?:ns|ans)|ns|a(?:ns?|[ai]ns))|p(?:pians|a(?:ns|ins)|i(?:[ei]ans|a(?:ns?|ins)|ns)|eans?)|eans?)?)?)|ípphê)?|-?líp)|p)|il(?:ip(?:piyarukku[\\s\\xa0]*E[lḻ]utiya[\\s\\xa0]*Nirupam|hphisiyuusa)|p)|a(?:ulus['’][\\s\\xa0]*Brev[\\s\\xa0]*til[\\s\\xa0]*Filipperne|vlova[\\s\\xa0]*poslanica[\\s\\xa0]*Filipljanima)|oslannja[\\s\\xa0]*apostola[\\s\\xa0]*Pavla[\\s\\xa0]*do[\\s\\xa0]*fylyp['’]jan)|《(?:斐理伯書》|腓(?:》|立比[书書]》)|肥利批》)|Ф(?:ил(?:ип(?:јани(?:те)?|['’]яни))?|лп)|האיגרת[\\s\\xa0]*אל[\\s\\xa0]*הפיליפים|pʰilipp(?:[iī]har(?:[uū]l(?:[aā](?:[iī][\\s\\xa0]*patra)))|aikar[aā](?:[mṃ]s[\\s\\xa0]*patra))|П(?:ослан(?:и(?:е[\\s\\xa0]*(?:к(?:[\\s\\xa0]*Филиппи[ий]цам|ъм[\\s\\xa0]*филипяните)|на[\\s\\xa0]*св(?:[\\s\\xa0]*ап(?:[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Филипяни|\\.[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Филипяни)|\\.[\\s\\xa0]*ап(?:[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Филипяни|\\.[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*Филипяни)))|ца[\\s\\xa0]*Филипљанима)|ня[\\s\\xa0]*(?:апостола[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*филип['’]ян|св(?:[\\s\\xa0]*апостола[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*филип['’]ян|\\.[\\s\\xa0]*апостола[\\s\\xa0]*Павла[\\s\\xa0]*до[\\s\\xa0]*филип['’]ян)|до[\\s\\xa0]*(?:Філіп['’]ян|филип['’]ян)))|исмо[\\s\\xa0]*од[\\s\\xa0]*апостол[\\s\\xa0]*Павле[\\s\\xa0]*до[\\s\\xa0]*христијаните[\\s\\xa0]*во[\\s\\xa0]*Филипи)|पौलाचे[\\s\\xa0]*फिलिप्पैकरांस[\\s\\xa0]*पत्र|Φι|אגרת[\\s\\xa0]*פולוס[\\s\\xa0]*השליח[\\s\\xa0]*אל-?הפיליפי|ฟ(?:ีลิปปี|ป)|ف(?:ِل(?:ِپ(?:ّیُوں[\\s\\xa0]*کے[\\s\\xa0]*نام[\\s\\xa0]*پو[\\s\\xa0]*لس[\\s\\xa0]*رسُول[\\s\\xa0]*کا[\\s\\xa0]*خط|ِّیوں[\\s\\xa0]*کے[\\s\\xa0]*نام[\\s\\xa0]*کا[\\s\\xa0]*خط)|پّیوں)|ي|ل(?:پیوں[\\s\\xa0]*کے[\\s\\xa0]*نام[\\s\\xa0]*کا[\\s\\xa0]*خط)?)|फिलिप्(?:‍पी|प(?:ि(?:यों)?|ी(?:हरूलाई[\\s\\xa0]*प(?:ावलको[\\s\\xa0]*पत्र|त्र))?))|Waraka[\\s\\xa0]*kwa[\\s\\xa0]*Wafilipi|빌립보서|ਫ਼ਿਲਿੱਪੀਆਂ[\\s\\xa0]*ਨੂੰ[\\s\\xa0]*ਪੱਤ੍ਰੀ|رسالة[\\s\\xa0]*(?:فيلبي|بولس[\\s\\xa0]*الرسول[\\s\\xa0]*إلى[\\s\\xa0]*أهل[\\s\\xa0]*فيلبي)|Epistula[\\s\\xa0]*ad[\\s\\xa0]*Philippenses|الرسالة[\\s\\xa0]*إلى[\\s\\xa0]*أهل[\\s\\xa0]*فيلبي|F(?:l(?:ippiekhez|p)?|il(?:i(?:p(?:p(?:aiyon|i(?:br[eé]fið|ekhez|l[aä]iskirje)?|íbr[eé]fið|e(?:n(?:serne|zen)|rbrevet))|en(?:s(?:es|k[yý]m|[oó]w)|i)|ian[eë]ve|yen)?|boy)?)?|p)|Sulat[\\s\\xa0]*sa[\\s\\xa0]*mga[\\s\\xa0]*(?:Pilip(?:ense|yano)|Filipense)|Mga[\\s\\xa0]*Taga(?:-?(?:Filipos|[\\s\\xa0]*[FP]ilipos)|[\\s\\xa0]*[FP]ilipos)|필리(?:피(?:[\\s\\xa0]*신자들에게[\\s\\xa0]*보낸[\\s\\xa0]*서간|서))?|ଫିଲି‌ପ୍‌ପୀୟଙ୍କ[\\s\\xa0]*ପ୍ରତି[\\s\\xa0]*ପତ୍ର|Προς[\\s\\xa0]*Φιλιππησ[ίι]ους)|(?:腓(?:立比[书書]》?|》)?|Φιλιππησ[ιί]ους|斐理伯書》?|pʰilipp(?:aikar[aā](?:[mṃ]s)|[īi]har(?:[ūu]l(?:[aā][īi])))|ଫିଲି‌ପ୍‌ପୀୟଙ୍କ|ਫ਼ਿਲਿੱਪੀਆਂ[\\s\\xa0]*ਨੂੰ|《(?:斐理伯書|肥利批|腓(?:立比[书書])?)|Mga[\\s\\xa0]*(?:Pilip(?:ense|yano)|Filipense)|Taga(?:-?(?:Filipos|[\\s\\xa0]*[PF]ilipos)|[\\s\\xa0]*[PF]ilipos)|Wafilipi|Filip(?:ljanima|anom|p(?:il[äa]isille|e(?:si|rne))|os|i(?:an)?|sk[yý]m)|फिलिप्प(?:ैकरांस(?:[\\s\\xa0]*पत्र)?|ीहरूलाई)|Филип(?:пи[ий]цам|[’']ян|яни(?:те)?|љанима)|肥利批》?|אל[\\s\\xa0]*הפיליפים|ad[\\s\\xa0]*Philippenses|До[\\s\\xa0]*филип['’]ян|К[\\s\\xa0]*Филиппи[йи]цам|P(?:aulus’[\\s\\xa0]*brev[\\s\\xa0]*til[\\s\\xa0]*filipperne|hi(?:lippenses)?|ilip(?:os|piyarukku)|oslanica[\\s\\xa0]*Filipljanima)|filippīāṃ|ف(?:لپیوں|ِلِپّیُوں)))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Dan"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Δ(?:α(?:ν(?:ι[ήη]λ)?)?|ν)|דניאל|دا(?:نی(?:[\\s\\xa0‌]*ایل|ال))?|d(?:an(?:iyalko[\\s\\xa0]*pustak|īel)|ān(?:i(?:el|yalko[\\s\\xa0]*pustak)|ī(?:ʾīl|el)))|다니(?:엘서?)?|سفر[\\s\\xa0]*دانيال|Ða-?ni-?ên|T[aā](?:[nṉ]iy(?:[eē]l))|Liv[\\s\\xa0]*Dany[eè]l[\\s\\xa0]*la|D(?:án(?:iel)?|haniel|[ln]|a(?:n(?:i(?:[aèë]l|el(?:i(?:n[\\s\\xa0]*kirja)?|s[\\s\\xa0]*(?:Bog|bok)|e)?)|y[iï]l|e|íel)?|an(?:yeel|eela|iyyel)?)?)|ଦାନିୟେଲଙ(?:୍କ[\\s\\xa0]*ପୁସ୍ତକ)?|[タダ]ニエル書?|Đa(?:-?ni(?:-?ên|ên)|nien)|दान(?:ीएल(?:्र)?|ि(?:य(?:्य(?:ेल|ल)|ल(?:को[\\s\\xa0]*पुस्तक)?))?)|Ks(?:\\.[\\s\\xa0]*Daniela|[\\s\\xa0]*Daniela|i[eę]g(?:[ai][\\s\\xa0]*Daniela))|《(?:達尼爾》|但(?:以理[书書]》|》))|Книга[\\s\\xa0]*(?:на[\\s\\xa0]*пророк[\\s\\xa0]*Даниила?|пророка[\\s\\xa0]*Дани[иії]ла)|ਦਾਨੀਏਲ|단|ด(?:าเนียล|นล)|Д(?:он|ан(?:и(?:[еяії]л|ло?)|аил)?)|தானி(?:யேல(?:்|ின்[\\s\\xa0]*புத்தகம்))?|Prophetia[\\s\\xa0]*Danielis)|(?:達尼爾》?|دانيال|दानियलको|Dan(?:y[eè]l|iel(?:in|a))|Дани(?:ила?|[їі]ла)|Đa|《(?:達尼爾|但(?:以理[书書])?)|d(?:ani(?:yalko|el)|āniyalko)|但(?:以理[書书]》?|》)?))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Jude"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Ιο[υύ]δα|《(?:猶(?:[大達]書》|》)|犹(?:》|大书》)|伊屋達》)|᾿Ιδ|С(?:оборне[\\s\\xa0]*послання[\\s\\xa0]*(?:Юди|св(?:[\\s\\xa0]*апостола[\\s\\xa0]*Юди|\\.[\\s\\xa0]*апостола[\\s\\xa0]*Юди))|ъборно[\\s\\xa0]*послание[\\s\\xa0]*на[\\s\\xa0]*св(?:[\\s\\xa0]*ап(?:[\\s\\xa0]*Иуда|\\.[\\s\\xa0]*Иуда)|\\.[\\s\\xa0]*ап(?:[\\s\\xa0]*Иуда|\\.[\\s\\xa0]*Иуда)))|Iuda|Ј(?:уде|аковљевог|д)|San[\\s\\xa0]*Judas|यहूदा(?:चें[\\s\\xa0]*पत्र|को[\\s\\xa0]*पत्र)?|یہ(?:ُوداہ[\\s\\xa0]*کا[\\s\\xa0]*عام[\\s\\xa0]*خط|وداہ[\\s\\xa0]*کا[\\s\\xa0]*عام[\\s\\xa0]*خط)|ユ(?:[タダ](?:からの手紙|の(?:手紙|書))?)|유다(?:서|[\\s\\xa0]*서간)|Юд|ย(?:ูดา|ด)|யூதா[\\s\\xa0]*(?:எழுதிய[\\s\\xa0]*(?:நிருபம்|கடிதம்)|திருமுகம்)|ਯਹੂਦਾਹ[\\s\\xa0]*ਦੀ[\\s\\xa0]*ਪੱਤ੍ਰੀ|Barua[\\s\\xa0]*ya[\\s\\xa0]*Yuda|[ИІ]уд|א(?:יגרת[\\s\\xa0]*יהודה|גרת[\\s\\xa0]*יהודה)|J(?:wd(?:as)?|d(?:as|e)|úd(?:ás|as(?:arbr(?:[eé]f(?:ið)?))?|ov[\\s\\xa0]*List)?|id|u(?:ud(?:aksen[\\s\\xa0]*kirje)?|d(?:a(?:s(?:brevet|arbr(?:[eé]f(?:ið)?)|[\\s\\xa0]*(?:epistel|brev)|['’][\\s\\xa0]*Brev))?|ás|ov(?:[\\s\\xa0]*List|a)|ina[\\s\\xa0]*poslanica)))|yah(?:ūd(?:a(?:ko[\\s\\xa0]*patra|ce[mṃ][\\s\\xa0]*patra)|ā(?:h[\\s\\xa0]*(?:dī[\\s\\xa0]*pattrī|kā[\\s\\xa0]*ʿām[\\s\\xa0]*ḫaṭ)|ko[\\s\\xa0]*patra|ce[mṃ][\\s\\xa0]*patra))|ud(?:[aā](?:ko[\\s\\xa0]*patra|ce[mṃ][\\s\\xa0]*patra)))|H(?:ið[\\s\\xa0]*almenna[\\s\\xa0]*br[eé]f[\\s\\xa0]*J(?:[uú]dasar)|udas)|يهو?|G(?:iu(?:-?đe|đa)|d)|L(?:ist[\\s\\xa0]*(?:(?:[sś]w(?:\\.[\\s\\xa0]*Judy|[\\s\\xa0]*Judy))|powszechny[\\s\\xa0]*[SŚ]wi(?:[eę]tego[\\s\\xa0]*Iudasa[\\s\\xa0]*Apostoła)|Jud(?:[uů]v|y))|ayang[\\s\\xa0]*Yudas|ettera[\\s\\xa0]*di[\\s\\xa0]*Giuda)|رسال(?:ة[\\s\\xa0]*يهوذا|ى[\\s\\xa0]*القديس[\\s\\xa0]*يهوذا)|ଯିହୂଦାଙ୍କ[\\s\\xa0]*ପତ୍ର|Epistula[\\s\\xa0]*Iudae|П(?:ослан(?:и(?:е[\\s\\xa0]*(?:Иуды|на[\\s\\xa0]*(?:апостол[\\s\\xa0]*Јуда|Юда))|ца[\\s\\xa0]*Јудина)|ня[\\s\\xa0]*(?:апостола[\\s\\xa0]*Юди|Іуди))|исмо[\\s\\xa0]*од[\\s\\xa0]*апостол[\\s\\xa0]*Јуда)|Y(?:ūt[aā][\\s\\xa0]*E(?:[lḻ]utiya[\\s\\xa0]*Nirupam)|u(?:t[aā][\\s\\xa0]*E(?:[lḻ]utiya[\\s\\xa0]*Nirupam)|ud(?:as)?|d)|ahooda|ihu(?:daa)?)|Poslan(?:nja[\\s\\xa0]*apostola[\\s\\xa0]*Judy|ica[\\s\\xa0]*Jude[\\s\\xa0]*apostola))|(?:Giuda|yah(?:ud(?:[aā](?:ko|ce[mṃ]))|ūd(?:a(?:ko|ce[ṃm])|ā(?:ko|ce[ṃm]|h)))|یہ(?:وداہ|ُوداہ)|يهوذا|猶(?:[大達]書》?|》)?|ଯିହୂଦାଙ୍କ|犹(?:》|大书》?)?|யூதா|《(?:犹(?:大书)?|猶(?:[大達]書)?|伊屋達)|J(?:údov|u(?:d(?:ina|as(?:’[\\s\\xa0]*brev)?|ov|[ye])|udaksen))|यहूदा(?:चें|को)|伊屋達》?|Јуд(?:ина|а)|ਯਹੂਦਾਹ|Iudae|Y(?:u(?:das?|t[āa])|ūt[aā])|Иуд[ыа]|유다|Юда|Послання[\\s\\xa0]*Юди))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["2Macc"],
        apocrypha: true,
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])((?:2[\s\xa0]*makkabilaiskirja|II(?:\.[\s\xa0]*makkabilaiskirja|[\s\xa0]*makkabilaiskirja))|(?:Se(?:gund(?:o[\s\xa0]*Mac(?:ab(?:e(?:os?|us|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?)))|a[\s\xa0]*Macabeus)|cond(?:a[\s\xa0]*Maccabei|o[\s\xa0]*(?:Maccabei|libro[\s\xa0]*dei[\s\xa0]*Maccabei)|[\s\xa0]*Mac(?:c(?:c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?|ab(?:e(?:e(?:es?|s)?|s)?|b(?:be[es]?|e(?:e[es]?|s)?)))?|ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:es?|s)?|s)?)|e(?:e(?:es?|s)?|s)?))?))|Zweite[\s\xa0]*Makkab[aä]er|Β['ʹʹ΄’][\s\xa0]*Μακκ(?:αβα(?:[ίι]ων)?)|Liber[\s\xa0]*(?:Maccabaeorum[\s\xa0]*II|II[\s\xa0]*Maccabaeorum)|마카베오(?:기[\s\xa0]*하권|하)|חשמונאים[\s\xa0]*ב['’]|2(?:-?(?:ге(?:\.[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Макаве[ії]в)|[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Макаве[ії]в))|а(?:\.[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Макаве[ії]в)|[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Макаве[ії]в))|я(?:\.[\s\xa0]*Маккавеев|[\s\xa0]*Маккавеев)|е(?:\.[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Мак(?:аве[ії]в|кавеев))|[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Мак(?:аве[ії]в|кавеев))))|\.(?:(?:[oº](?:[\s\xa0]*Mac(?:ab(?:e(?:os?|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?)))|\.[\s\xa0]*Mac(?:ab(?:e(?:os?|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?)))))|[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Wamakabayo|มัคคาบี|Мак(?:кавеев|а(?:ве(?:ј(?:ска|а)|[ії]в|и)|бејаца))|Ks(?:\.[\s\xa0]*Machabejska|[\s\xa0]*Machabejska|i[eę]g(?:[ai][\s\xa0]*Machabejska))|makkabilaiskirja|M(?:a(?:c(?:ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:[eo]s?|s)?|os?|s)?)|aeorum|e(?:aid|e(?:[eo]s?|s)?|os?|us|[is])?)|hab(?:aeorum|ejcov)|kab[eé]erboken|c(?:ab(?:b(?:e(?:os?|e(?:os?|[es])?|s)?|be[es]?)|e(?:e(?:[eo]s?|s)?|os?|[is])?|ées)|c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?)?)?|k(?:abe(?:j(?:sk[aá]|cov))?|k(?:ab(?:e(?:e(?:[eë]n|rbok)|usok)|æerbog|[aä]er))?)?)|ga[\s\xa0]*Macabeo)))|e(?:[\s\xa0]*Ma(?:ccab[eé]es|k(?:kabee[eë]n)?)|\.[\s\xa0]*Ma(?:ccab[eé]es|k(?:kabee[eë]n)?)|me(?:\.[\s\xa0]*Maccab[eé]es|[\s\xa0]*Maccab[eé]es))|d(?:\.[\s\xa0]*Maccab[eé]es|[\s\xa0]*Maccab[eé]es|e(?:\.[\s\xa0]*Maccab[eé]es|[\s\xa0]*Maccab[eé]es))|(?:[яе](?:\.[\s\xa0]*Маккавеев|[\s\xa0]*Маккавеев))|마카|a(?:\.[\s\xa0]*Macabeus|[\s\xa0]*Macabeus)|ème(?:\.[\s\xa0]*Maccab[eé]es|[\s\xa0]*Maccab[eé]es)|nd(?:\.[\s\xa0]*Mac(?:c(?:c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?|ab(?:e(?:e(?:es?|s)?|s)?|b(?:be[es]?|e(?:e[es]?|s)?)))?|ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:es?|s)?|s)?)|e(?:e(?:es?|s)?|s)?))?|[\s\xa0]*Mac(?:c(?:c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?|ab(?:e(?:e(?:es?|s)?|s)?|b(?:be[es]?|e(?:e[es]?|s)?)))?|ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:es?|s)?|s)?)|e(?:e(?:es?|s)?|s)?))?)|Macc|°(?:[\s\xa0]*Maccabei|\.[\s\xa0]*Maccabei)|º(?:[\s\xa0]*Mac(?:ab(?:e(?:os?|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?)))|\.[\s\xa0]*Mac(?:ab(?:e(?:os?|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?))))|o(?:\.[\s\xa0]*Mac(?:ab(?:e(?:os?|us|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?)))|[\s\xa0]*Mac(?:ab(?:e(?:os?|us|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?))))|[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|المكابيين|மக்(?:கபேயர்)?|Wamakabayo|M(?:c[bh]?|a(?:k(?:abe(?:j(?:sk[aá]|cov))?|k(?:ab(?:e(?:e(?:[eë]n|rbok)|usok)|æerbog|[aä]er))?)?|c(?:ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:[eo]s?|s)?|os?|s)?)|aeorum|e(?:aid|e(?:[eo]s?|s)?|os?|us|[is])?)|h(?:ab(?:aeorum|ejcov))?|k(?:ab[eé]erboken)?|c(?:ab(?:b(?:e(?:os?|e(?:os?|[es])?|s)?|be[es]?)|e(?:e(?:[eo]s?|s)?|os?|[is])?|ées)|c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?)?)?)?|ga[\s\xa0]*Macabeo)?|k(?:\.[\s\xa0]*Ma(?:kabejcov|chabejcov)|[\s\xa0]*Ma(?:kabejcov|chabejcov))|มัคคาบี|Ks(?:\.[\s\xa0]*Machabejska|[\s\xa0]*Machabejska|i[eę]g(?:[ai][\s\xa0]*Machabejska))|М(?:ак(?:а(?:ве(?:ј(?:ска|а)|[ії]в|и)|бејаца)|к(?:авеев)?)?|к)|مك))|[OÖ]nnur[\s\xa0]*Makkabeab(?:[oó]k)|Втора(?:[\s\xa0]*(?:книга[\s\xa0]*(?:Макаве[ий]ска|на[\s\xa0]*Макавеите)|Макавеи)|я[\s\xa0]*книга[\s\xa0]*Маккаве[ий]ская)|سفر[\s\xa0]*المكابين[\s\xa0]*الثاني|I(?:I(?:\.[\s\xa0]*(?:M(?:a(?:k(?:abe(?:j(?:sk[aá]|cov))?|k(?:abe(?:e[eë]n|usok))?)?|c(?:ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:[eo]s?|s)?|os?|s)?)|aeorum|e(?:aid|e(?:[eo]s?|s)?|os?|us|[is])?)|hab(?:aeorum|ejcov)|c(?:ab(?:b(?:e(?:os?|e(?:os?|[es])?|s)?|be[es]?)|e(?:e(?:[eo]s?|s)?|os?|[is])?|ées)|c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?)?)?)|ga[\s\xa0]*Macabeo)|книга[\s\xa0]*Макаве[ії]в|Мака(?:ве(?:ј(?:ска|а)|[ії]в|и)|бејаца)|Wamakabayo|Ks(?:\.[\s\xa0]*Machabejska|[\s\xa0]*Machabejska|i[eę]g(?:[ai][\s\xa0]*Machabejska)))|[\s\xa0]*(?:M(?:a(?:k(?:abe(?:j(?:sk[aá]|cov))?|k(?:abe(?:e[eë]n|usok))?)?|c(?:ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:[eo]s?|s)?|os?|s)?)|aeorum|e(?:aid|e(?:[eo]s?|s)?|os?|us|[is])?)|hab(?:aeorum|ejcov)|c(?:ab(?:b(?:e(?:os?|e(?:os?|[es])?|s)?|be[es]?)|e(?:e(?:[eo]s?|s)?|os?|[is])?|ées)|c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?)?)?)|ga[\s\xa0]*Macabeo)|книга[\s\xa0]*Макаве[ії]в|Мака(?:ве(?:ј(?:ска|а)|[ії]в|и)|бејаца)|Wamakabayo|Ks(?:\.[\s\xa0]*Machabejska|[\s\xa0]*Machabejska|i[eę]g(?:[ai][\s\xa0]*Machabejska))))|kalawang[\s\xa0]*M(?:ga[\s\xa0]*Macabeo|acabeos?))|D(?:euxi[eè]me(?:s[\s\xa0]*Maccab(?:[eé]es|[\s\xa0]*Maccab[eé]es))|ru(?:h(?:(?:[yý][\s\xa0]*(?:list[\s\xa0]*Ma(?:kabejcov|chabejcov)|Ma(?:k(?:abej(?:sk[aá]|cov))?|chabejcov)))|(?:[aá][\s\xa0]*(?:Ma(?:k(?:abej(?:sk[aá]|cov))?|chabejcov)|kniha[\s\xa0]*Ma(?:kabejcov|chabejcov))))|g(?:a[\s\xa0]*(?:Ks(?:\.[\s\xa0]*Machabejska|[\s\xa0]*Machabejska|i[eę]g(?:[ai][\s\xa0]*Machabejska))|knjiga[\s\xa0]*o[\s\xa0]*Makabejcima)|i[\s\xa0]*Ks(?:\.[\s\xa0]*Machabejska|[\s\xa0]*Machabejska|i[eę]g(?:[ai][\s\xa0]*Machabejska)))))|Μακκαβα[ίι]ων[\s\xa0]*Β['ʹʹ΄’]|《瑪加伯下》|Pili[\s\xa0]*(?:Wamakabayo|Mak)|And(?:en[\s\xa0]*Makk(?:abæerbog)?|r(?:a[\s\xa0]*Mackab[eé]erboken|e[\s\xa0]*Makk(?:abeerbok)?))|マカ(?:(?:[ハバ]イ(?:[\s\xa0]*2|下|記[2下]))|[ヒビ]ー第二書)|Kitabu[\s\xa0]*cha[\s\xa0]*Wamakabayo[\s\xa0]*II|Друг(?:е[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Макаве[ії]в)|а[\s\xa0]*(?:Мака(?:ве(?:ј(?:ска|а)|[ії]в)|бејаца)|книга[\s\xa0]*Макаве[ії]в))|M(?:ásodik[\s\xa0]*Mak(?:kabeusok)?|a(?:sodik[\s\xa0]*Mak(?:kabeusok)?|kkabeusok[\s\xa0]*II|chabaeorum[\s\xa0]*II))|ספר[\s\xa0]*מקבים[\s\xa0]*ב['’]|T(?:weede[\s\xa0]*Mak(?:kabee[eë]n)?|oinen[\s\xa0]*makkabilaiskirja))|(?:Β['ʹʹ΄’][\s\xa0]*Μακκ|Deuxi[eè]me[\s\xa0]*Maccab(?:[eé]es))|(?:المكابين[\s\xa0]*الثاني|2[\s\xa0]*makk|《瑪加伯下|瑪加伯下》?|Wamakabayo[\s\xa0]*II|מקבים[\s\xa0]*ב))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["3Macc"],
        apocrypha: true,
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])((?:3(?:\.[\s\xa0]*makkabilaiskirja|[\s\xa0]*makkabilaiskirja)|III(?:\.[\s\xa0]*makkabilaiskirja|[\s\xa0]*makkabilaiskirja))|(?:Γ['ʹʹ΄’][\s\xa0]*Μακκ(?:αβα(?:[ίι]ων)?)|《3Macc》|Тре(?:ћ(?:а[\s\xa0]*Мака(?:веј(?:ска|а)|бејаца)|ом[\s\xa0]*Мака(?:веј(?:ска|а)|бејаца))|т(?:о[\s\xa0]*(?:книга[\s\xa0]*на[\s\xa0]*Макавеите|Макавеи)|[яє][\s\xa0]*(?:книга[\s\xa0]*Макаве(?:[ії]в|Макаве[ії]в))|а[\s\xa0]*книга[\s\xa0]*Макаве[ий]ска|ья[\s\xa0]*книга[\s\xa0]*Маккаве[ий]ская))|I(?:katlong[\s\xa0]*M(?:ga[\s\xa0]*Macabeo|acabeos?)|II(?:[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Мака(?:ве(?:ј(?:ска|а)|[ії]в|и)|бејаца)|Wamakabayo|M(?:a(?:c(?:ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:[eo]s?|s)?|os?|s)?)|aeorum|e(?:aid|e(?:[eo]s?|s)?|os?|us|[is])?)|hab(?:aeorum|ejcov)|c(?:ab(?:b(?:e(?:os?|e(?:os?|[es])?|s)?|be[es]?)|e(?:e(?:[eo]s?|s)?|os?|[is])?|ées)|c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?)?)?|k(?:abe(?:jsk[aá])?|k(?:abe(?:e[eë]n|usok))?)?)|ga[\s\xa0]*Macabeo)|Ks(?:\.[\s\xa0]*Machabejska|[\s\xa0]*Machabejska|i[eę]g(?:[ai][\s\xa0]*Machabejska)))|\.[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Мака(?:ве(?:ј(?:ска|а)|[ії]в|и)|бејаца)|Wamakabayo|M(?:a(?:c(?:ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:[eo]s?|s)?|os?|s)?)|aeorum|e(?:aid|e(?:[eo]s?|s)?|os?|us|[is])?)|hab(?:aeorum|ejcov)|c(?:ab(?:b(?:e(?:os?|e(?:os?|[es])?|s)?|be[es]?)|e(?:e(?:[eo]s?|s)?|os?|[is])?|ées)|c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?)?)?|k(?:abe(?:jsk[aá])?|k(?:abe(?:e[eë]n|usok))?)?)|ga[\s\xa0]*Macabeo)|Ks(?:\.[\s\xa0]*Machabejska|[\s\xa0]*Machabejska|i[eę]g(?:[ai][\s\xa0]*Machabejska)))))|Liber[\s\xa0]*(?:Maccabaeorum[\s\xa0]*III|III[\s\xa0]*Maccabaeorum)|Μακκαβα[ίι]ων[\s\xa0]*Γ['ʹʹ΄’]|K(?:olmas[\s\xa0]*makkabilaiskirja|itabu[\s\xa0]*cha[\s\xa0]*Wamakabayo[\s\xa0]*III)|Harmadik[\s\xa0]*Mak(?:kabeusok)?|חשמונאים[\s\xa0]*ג['’]|المكابين[\s\xa0]*الثالث|Þriðja[\s\xa0]*Makkabeab[oó]k|マカ(?:[ハバ]イ(?:[\s\xa0記]*3)|[ヒビ]ー第三書)|Ma(?:kkabeusok[\s\xa0]*III|chabaeorum[\s\xa0]*III)|ספר[\s\xa0]*מקבים[\s\xa0]*ג['’]|D(?:erde[\s\xa0]*Mak(?:kabee[eë]n)?|ritte[\s\xa0]*Makkab[aä]er)|T(?:r(?:oisi[eè]me(?:s[\s\xa0]*Maccab(?:[eé]es|[\s\xa0]*Maccab[eé]es))|zeci(?:a[\s\xa0]*Ks(?:\.[\s\xa0]*Machabejska|[\s\xa0]*Machabejska|i[eę]g(?:[ai][\s\xa0]*Machabejska))|[\s\xa0]*Ks(?:\.[\s\xa0]*Machabejska|[\s\xa0]*Machabejska|i[eę]g(?:[ai][\s\xa0]*Machabejska)))|e(?:[cć]a[\s\xa0]*knjiga[\s\xa0]*o[\s\xa0]*Makabejcima|dje[\s\xa0]*Ma(?:ckab[eé]erboken|kk(?:ab(?:æerbog|eerbok))?)|t(?:i(?:a[\s\xa0]*(?:kniha[\s\xa0]*Machabejcov|Machabejcov)|[\s\xa0]*Ma(?:k(?:abejsk[aá])?|chabejcov))|í[\s\xa0]*Ma(?:k(?:abejsk[aá])?|chabejcov))))|hird[\s\xa0]*Mac(?:c(?:c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?|ab(?:e(?:e(?:es?|s)?|s)?|b(?:be[es]?|e(?:e[es]?|s)?)))?|ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:es?|s)?|s)?)|e(?:e(?:es?|s)?|s)?))?|řet(?:[ií][\s\xa0]*Mak(?:abejsk[aá])?)|atu[\s\xa0]*(?:Wamakabayo|Mak)|er(?:ce(?:ir[ao][\s\xa0]*Macabeus|r(?:[\s\xa0]*Mac(?:ab(?:e(?:os?|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?)))|o[\s\xa0]*Mac(?:ab(?:e(?:os?|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?)))))|z(?:a[\s\xa0]*Maccabei|o[\s\xa0]*(?:Maccabei|libro[\s\xa0]*dei[\s\xa0]*Maccabei))))|마카베오[\s\xa0]*3서|3(?:e(?:\.[\s\xa0]*Ma(?:k(?:kabee[eë]n)?|c(?:cab[eé]es|kab[eé]erboken))|[\s\xa0]*Ma(?:k(?:kabee[eë]n)?|c(?:cab[eé]es|kab[eé]erboken))|me(?:\.[\s\xa0]*Maccab[eé]es|[\s\xa0]*Maccab[eé]es))|(?:[яе](?:\.[\s\xa0]*Маккавеев|[\s\xa0]*Маккавеев))|\.(?:(?:[oº](?:[\s\xa0]*Mac(?:ab(?:e(?:os?|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?)))|\.[\s\xa0]*Mac(?:ab(?:e(?:os?|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?)))))|[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|M(?:ga[\s\xa0]*Macabeo|a(?:c(?:ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:[eo]s?|s)?|os?|s)?)|aeorum|e(?:aid|e(?:[eo]s?|s)?|os?|us|[is])?)|hab(?:aeorum|ejcov)|kab[eé]erboken|c(?:ab(?:b(?:e(?:os?|e(?:os?|[es])?|s)?|be[es]?)|e(?:e(?:[eo]s?|s)?|os?|[is])?|ées)|c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?)?)?|k(?:k(?:ab(?:e(?:e(?:[eë]n|rbok)|usok)|æerbog|[aä]er))?|abe(?:jsk[aá])?)?))|Wamakabayo|มัคคาบี|Мак(?:кавеев|а(?:ве(?:ј(?:ска|а)|[ії]в|и)|бејаца))|Ks(?:\.[\s\xa0]*Machabejska|[\s\xa0]*Machabejska|i[eę]g(?:[ai][\s\xa0]*Machabejska))))|마카|-?(?:а(?:\.[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Макаве[ії]в)|[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Макаве[ії]в))|я(?:\.[\s\xa0]*Маккавеев|[\s\xa0]*Маккавеев)|е(?:\.[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Мак(?:аве[ії]в|кавеев))|[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Мак(?:аве[ії]в|кавеев)))|тє(?:\.[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Макаве[ії]в)|[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Макаве[ії]в)))|a(?:\.[\s\xa0]*Macabeus|[\s\xa0]*Macabeus)|ème(?:\.[\s\xa0]*Maccab[eé]es|[\s\xa0]*Maccab[eé]es)|rd(?:\.[\s\xa0]*Mac(?:c(?:c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?|ab(?:e(?:e(?:es?|s)?|s)?|b(?:be[es]?|e(?:e[es]?|s)?)))?|ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:es?|s)?|s)?)|e(?:e(?:es?|s)?|s)?))?|[\s\xa0]*Mac(?:c(?:c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?|ab(?:e(?:e(?:es?|s)?|s)?|b(?:be[es]?|e(?:e[es]?|s)?)))?|ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:es?|s)?|s)?)|e(?:e(?:es?|s)?|s)?))?)|°(?:[\s\xa0]*Maccabei|\.[\s\xa0]*Maccabei)|º(?:[\s\xa0]*Mac(?:ab(?:e(?:os?|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?)))|\.[\s\xa0]*Mac(?:ab(?:e(?:os?|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?))))|o(?:\.[\s\xa0]*Mac(?:ab(?:e(?:os?|us|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?)))|[\s\xa0]*Mac(?:ab(?:e(?:os?|us|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?))))|[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|மக்(?:கபேயர்)?|Wamakabayo|มัคคาบี|Ks(?:\.[\s\xa0]*Machabejska|[\s\xa0]*Machabejska|i[eę]g(?:[ai][\s\xa0]*Machabejska))|k(?:\.[\s\xa0]*Machabejcov|[\s\xa0]*Machabejcov)|M(?:c[bh]?|a(?:k(?:k(?:ab(?:e(?:e(?:[eë]n|rbok)|usok)|æerbog|[aä]er))?|abe(?:jsk[aá])?)?|c(?:ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:[eo]s?|s)?|os?|s)?)|aeorum|e(?:aid|e(?:[eo]s?|s)?|os?|us|[is])?)|h(?:ab(?:aeorum|ejcov))?|k(?:ab[eé]erboken)?|c(?:ab(?:b(?:e(?:os?|e(?:os?|[es])?|s)?|be[es]?)|e(?:e(?:[eo]s?|s)?|os?|[is])?|ées)|c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?)?)?)|ga[\s\xa0]*Macabeo)?|М(?:ак(?:а(?:ве(?:ј(?:ска|а)|[ії]в|и)|бејаца)|к(?:авеев)?)?|к))))|(?:Трет[яє][\s\xa0]*Макаве(?:[ії]в)|Γ['ʹʹ΄’][\s\xa0]*Μακκ|Troisi[eè]me[\s\xa0]*Maccab(?:[eé]es))|(?:Wamakabayo[\s\xa0]*III|《3Macc|3(?:[\s\xa0]*makk|Macc》?)|מקבים[\s\xa0]*ג))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["4Macc"],
        apocrypha: true,
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])((?:4(?:\.[\s\xa0]*makkabilaiskirja|[\s\xa0]*makkabilaiskirja)|IV(?:\.[\s\xa0]*makkabilaiskirja|[\s\xa0]*makkabilaiskirja))|(?:Qua(?:rt(?:o[\s\xa0]*(?:libro[\s\xa0]*dei[\s\xa0]*Maccabei|Mac(?:cabei|abeus))|a[\s\xa0]*Mac(?:cabei|abeus))|tri[eè]me(?:s[\s\xa0]*Maccab(?:[eé]es|[\s\xa0]*Maccab[eé]es)))|Δ['ʹʹ΄’][\s\xa0]*Μακκ(?:αβα(?:[ίι]ων)?)|Μακκαβα[ίι]ων[\s\xa0]*Δ['ʹʹ΄’]|《4Macc》|Четв(?:ерта[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Макаве[ії]в)|рта[\s\xa0]*Мака(?:веј(?:ска|а)|бејаца)|ърта[\s\xa0]*(?:книга[\s\xa0]*на[\s\xa0]*Макавеите|Макавеи))|المكابين[\s\xa0]*الرابع|Čtvrt(?:[aá][\s\xa0]*Mak(?:abejsk[aá])?)|חשמונאים[\s\xa0]*ד['’]|N(?:ne[\s\xa0]*(?:Wamakabayo|Mak)|elj[aä]s[\s\xa0]*makkabilaiskirja)|Ma(?:kkabeusok[\s\xa0]*IV|chabaeorum[\s\xa0]*IV)|Liber[\s\xa0]*(?:Maccabaeorum[\s\xa0]*IV|IV[\s\xa0]*Maccabaeorum)|마카베오[\s\xa0]*4서|マカ(?:[ハバ]イ(?:[\s\xa0記]*4)|[ヒビ]ー第四書)|Vier(?:te[\s\xa0]*Makkab[aä]er|de[\s\xa0]*Mak(?:kabee[eë]n)?)|4(?:-?(?:[ея](?:\.[\s\xa0]*Маккавеев|[\s\xa0]*Маккавеев))|e(?:\.[\s\xa0]*Maccab[eé]es|[\s\xa0]*Maccab[eé]es|me(?:\.[\s\xa0]*Maccab[eé]es|[\s\xa0]*Maccab[eé]es))|(?:[яе](?:\.[\s\xa0]*Маккавеев|[\s\xa0]*Маккавеев))|\.(?:(?:[oº](?:[\s\xa0]*Mac(?:ab(?:e(?:os?|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?)))|\.[\s\xa0]*Mac(?:ab(?:e(?:os?|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?)))))|[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|M(?:ga[\s\xa0]*Macabeo|a(?:c(?:ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:[eo]s?|s)?|os?|s)?)|aeorum|e(?:aid|e(?:[eo]s?|s)?|os?|us|[is])?)|hab(?:aeorum|ejcov)|kab[eé]erboken|c(?:ab(?:b(?:e(?:os?|e(?:os?|[es])?|s)?|be[es]?)|e(?:e(?:[eo]s?|s)?|os?|[is])?|ées)|c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?)?)?|k(?:k(?:ab(?:e(?:e(?:[eë]n|rbok)|usok)|æerbog|[aä]er))?|abe(?:jsk[aá])?)?))|Wamakabayo|มัคคาบี|Мак(?:кавеев|а(?:ве(?:ј(?:ска|а)|[ії]в|и)|бејаца))|Ks(?:\.[\s\xa0]*Machabejska|[\s\xa0]*Machabejska|i[eę]g(?:[ai][\s\xa0]*Machabejska))))|마카|a(?:\.[\s\xa0]*Macabeus|[\s\xa0]*Macabeus)|ème(?:\.[\s\xa0]*Maccab[eé]es|[\s\xa0]*Maccab[eé]es)|°(?:[\s\xa0]*Maccabei|\.[\s\xa0]*Maccabei)|º(?:[\s\xa0]*Mac(?:ab(?:e(?:os?|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?)))|\.[\s\xa0]*Mac(?:ab(?:e(?:os?|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?))))|o(?:\.[\s\xa0]*Mac(?:ab(?:e(?:os?|us|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?)))|[\s\xa0]*Mac(?:ab(?:e(?:os?|us|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?))))|th(?:\.[\s\xa0]*Mac(?:c(?:c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?|ab(?:e(?:e(?:es?|s)?|s)?|b(?:be[es]?|e(?:e[es]?|s)?)))?|ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:es?|s)?|s)?)|e(?:e(?:es?|s)?|s)?))?|[\s\xa0]*Mac(?:c(?:c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?|ab(?:e(?:e(?:es?|s)?|s)?|b(?:be[es]?|e(?:e[es]?|s)?)))?|ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:es?|s)?|s)?)|e(?:e(?:es?|s)?|s)?))?)|[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|மக்(?:கபேயர்)?|Wamakabayo|มัคคาบี|Ks(?:\.[\s\xa0]*Machabejska|[\s\xa0]*Machabejska|i[eę]g(?:[ai][\s\xa0]*Machabejska))|k(?:\.[\s\xa0]*Machabejcov|[\s\xa0]*Machabejcov)|M(?:c[bh]?|a(?:k(?:k(?:ab(?:e(?:e(?:[eë]n|rbok)|usok)|æerbog|[aä]er))?|abe(?:jsk[aá])?)?|c(?:ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:[eo]s?|s)?|os?|s)?)|aeorum|e(?:aid|e(?:[eo]s?|s)?|os?|us|[is])?)|h(?:ab(?:aeorum|ejcov))?|k(?:ab[eé]erboken)?|c(?:ab(?:b(?:e(?:os?|e(?:os?|[es])?|s)?|be[es]?)|e(?:e(?:[eo]s?|s)?|os?|[is])?|ées)|c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?)?)?)|ga[\s\xa0]*Macabeo)?|М(?:ак(?:а(?:ве(?:ј(?:ска|а)|[ії]в|и)|бејаца)|к(?:авеев)?)?|к)))|F(?:j(?:erde[\s\xa0]*Makk(?:ab(?:æerbog|eerbok))?|[aä]rde[\s\xa0]*Mackab(?:[eé]erboken)|[oó]rða[\s\xa0]*Makkabeab(?:[oó]k))|ourth[\s\xa0]*Mac(?:c(?:c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?|ab(?:e(?:e(?:es?|s)?|s)?|b(?:be[es]?|e(?:e[es]?|s)?)))?|ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:es?|s)?|s)?)|e(?:e(?:es?|s)?|s)?))?)|(?:[ŠS]tvrt(?:[aá][\s\xa0]*(?:kniha[\s\xa0]*Machabejcov|Machabejcov)))|I(?:V(?:[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Мака(?:ве(?:ј(?:ска|а)|[ії]в|и)|бејаца)|Wamakabayo|M(?:a(?:c(?:ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:[eo]s?|s)?|os?|s)?)|aeorum|e(?:aid|e(?:[eo]s?|s)?|os?|us|[is])?)|hab(?:aeorum|ejcov)|c(?:ab(?:b(?:e(?:os?|e(?:os?|[es])?|s)?|be[es]?)|e(?:e(?:[eo]s?|s)?|os?|[is])?|ées)|c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?)?)?|k(?:abe(?:jsk[aá])?|k(?:abe(?:e[eë]n|usok))?)?)|ga[\s\xa0]*Macabeo)|Ks(?:\.[\s\xa0]*Machabejska|[\s\xa0]*Machabejska|i[eę]g(?:[ai][\s\xa0]*Machabejska)))|\.[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Мака(?:ве(?:ј(?:ска|а)|[ії]в|и)|бејаца)|Wamakabayo|M(?:a(?:c(?:ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:[eo]s?|s)?|os?|s)?)|aeorum|e(?:aid|e(?:[eo]s?|s)?|os?|us|[is])?)|hab(?:aeorum|ejcov)|c(?:ab(?:b(?:e(?:os?|e(?:os?|[es])?|s)?|be[es]?)|e(?:e(?:[eo]s?|s)?|os?|[is])?|ées)|c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?)?)?|k(?:abe(?:jsk[aá])?|k(?:abe(?:e[eë]n|usok))?)?)|ga[\s\xa0]*Macabeo)|Ks(?:\.[\s\xa0]*Machabejska|[\s\xa0]*Machabejska|i[eę]g(?:[ai][\s\xa0]*Machabejska))))|kaapat[\s\xa0]*M(?:ga[\s\xa0]*Macabeo|acabeos?))|Kitabu[\s\xa0]*cha[\s\xa0]*Wamakabayo[\s\xa0]*IV|ספר[\s\xa0]*מקבים[\s\xa0]*ד['’]|C(?:tvrt(?:[aá][\s\xa0]*Mak(?:abejsk[aá])?)|uarto[\s\xa0]*Mac(?:ab(?:e(?:os?|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?)))|zwarta[\s\xa0]*Ks(?:\.[\s\xa0]*Machabejska|[\s\xa0]*Machabejska|i[eę]g(?:[ai][\s\xa0]*Machabejska))))|(?:Δ['ʹʹ΄’][\s\xa0]*Μακκ|Quatri[eè]me[\s\xa0]*Maccab(?:[eé]es))|(?:Wamakabayo[\s\xa0]*IV|מקבים[\s\xa0]*ד|《4Macc|4(?:[\s\xa0]*makk|Macc》?)))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["1Macc"],
        apocrypha: true,
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])((?:[1I](?:\.[\s\xa0]*makkabilaiskirja|[\s\xa0]*makkabilaiskirja))|(?:Α['ʹʹ΄’][\s\xa0]*Μακκ(?:αβα(?:[ίι]ων)?)|سفر[\s\xa0]*المكابين[\s\xa0]*الأول|П(?:ер(?:ш[ае][\s\xa0]*(?:книга[\s\xa0]*Макаве(?:[ії]в|Макаве[ії]в))|вая[\s\xa0]*книга[\s\xa0]*Маккаве[ий]ская)|ърва[\s\xa0]*(?:книга[\s\xa0]*(?:Макаве[ий]ска|на[\s\xa0]*Макавеите)|Макавеи)|рва[\s\xa0]*Мака(?:веј(?:ска|а)|бејаца))|《瑪加伯上》|I(?:[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Мака(?:ве(?:ј(?:ска|а)|[ії]в|и)|бејаца)|Wamakabayo|M(?:a(?:c(?:ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:[eo]s?|s)?|os?|s)?)|aeorum|e(?:aid|e(?:[eo]s?|s)?|os?|us|[is])?)|hab(?:aeorum|ejcov)|c(?:ab(?:b(?:e(?:os?|e(?:os?|[es])?|s)?|be[es]?)|e(?:e(?:[eo]s?|s)?|os?|[is])?|ées)|c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?)?)?|k(?:abe(?:jsk[aá])?|k(?:abe(?:e[eë]n|usok))?)?)|ga[\s\xa0]*Macabeo)|Ks(?:\.[\s\xa0]*Machabejska|[\s\xa0]*Machabejska|i[eę]g(?:[ai][\s\xa0]*Machabejska)))|\.[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Мака(?:ве(?:ј(?:ска|а)|[ії]в|и)|бејаца)|Wamakabayo|M(?:a(?:c(?:ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:[eo]s?|s)?|os?|s)?)|aeorum|e(?:aid|e(?:[eo]s?|s)?|os?|us|[is])?)|hab(?:aeorum|ejcov)|c(?:ab(?:b(?:e(?:os?|e(?:os?|[es])?|s)?|be[es]?)|e(?:e(?:[eo]s?|s)?|os?|[is])?|ées)|c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?)?)?|k(?:abe(?:jsk[aá])?|k(?:abe(?:e[eë]n|usok))?)?)|ga[\s\xa0]*Macabeo)|Ks(?:\.[\s\xa0]*Machabejska|[\s\xa0]*Machabejska|i[eę]g(?:[ai][\s\xa0]*Machabejska))))|K(?:itabu[\s\xa0]*cha[\s\xa0]*Wamakabayo[\s\xa0]*I|wanza[\s\xa0]*(?:Wamakabayo|Mak))|ספר[\s\xa0]*מקבים[\s\xa0]*א['’]|E(?:nsimm[aä]inen[\s\xa0]*makkabilaiskirja|erste[\s\xa0]*Mak(?:kabee[eë]n)?|ls(?:[oő][\s\xa0]*Mak(?:kabeusok)?)|rste[\s\xa0]*Makkab[aä]er)|マカ(?:(?:[ハバ]イ(?:[\s\xa0]*1|記[1上]|上))|[ヒビ]ー第一書)|Μακκαβα[ίι]ων[\s\xa0]*Α['ʹʹ΄’]|F(?:yrsta[\s\xa0]*Makkabeab[oó]k|irst[\s\xa0]*Mac(?:c(?:c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?|ab(?:e(?:e(?:es?|s)?|s)?|b(?:be[es]?|e(?:e[es]?|s)?)))?|ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:es?|s)?|s)?)|e(?:e(?:es?|s)?|s)?))?|[oö]rsta[\s\xa0]*Mackab(?:[eé]erboken)|ørste[\s\xa0]*Makk(?:ab(?:æerbog|eerbok))?)|חשמונאים[\s\xa0]*א['’]|Una(?:[\s\xa0]*M(?:ga[\s\xa0]*Macabeo|acabeos?)|ng[\s\xa0]*M(?:ga[\s\xa0]*Macabeo|acabeos?))|마카베오(?:기[\s\xa0]*상권|상)|P(?:ierwsz(?:[aey][\s\xa0]*Ks(?:\.[\s\xa0]*Machabejska|[\s\xa0]*Machabejska|i[eę]g(?:[ai][\s\xa0]*Machabejska)))|r(?:emi(?:ère(?:s[\s\xa0]*Maccab[eé]es|[\s\xa0]*Maccab[eé]es)|er(?:s[\s\xa0]*Maccab[eé]es|[\s\xa0]*Maccab[eé]es|e(?:s[\s\xa0]*Maccab[eé]es|[\s\xa0]*Maccab[eé]es)))|im(?:e(?:ir[ao][\s\xa0]*Macabeus|r(?:[\s\xa0]*Mac(?:ab(?:e(?:os?|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?)))|o[\s\xa0]*Mac(?:ab(?:e(?:os?|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?)))))|a[\s\xa0]*Maccabei|o[\s\xa0]*(?:Maccabei|libro[\s\xa0]*dei[\s\xa0]*Maccabei))|v(?:n(?:[ií][\s\xa0]*Mak(?:abejsk[aá])?)|á[\s\xa0]*(?:kniha[\s\xa0]*Machabejcov|Ma(?:kabejcov|chabejcov))|a[\s\xa0]*(?:Ma(?:kabejcov|chabejcov)|kn(?:iha[\s\xa0]*Machabejcov|jiga[\s\xa0]*o[\s\xa0]*Makabejcima))|(?:[yý][\s\xa0]*(?:Machabejcov|list[\s\xa0]*Machabejcov)))))|Ma(?:kkabeusok[\s\xa0]*I|chabaeorum[\s\xa0]*I)|1(?:st(?:\.[\s\xa0]*Mac(?:c(?:c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?|ab(?:e(?:e(?:es?|s)?|s)?|b(?:be[es]?|e(?:e[es]?|s)?)))?|ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:es?|s)?|s)?)|e(?:e(?:es?|s)?|s)?))?|[\s\xa0]*Mac(?:c(?:c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?|ab(?:e(?:e(?:es?|s)?|s)?|b(?:be[es]?|e(?:e[es]?|s)?)))?|ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:es?|s)?|s)?)|e(?:e(?:es?|s)?|s)?))?)|(?:[яе](?:\.[\s\xa0]*Маккавеев|[\s\xa0]*Маккавеев))|\.(?:(?:[oº](?:[\s\xa0]*Mac(?:ab(?:e(?:os?|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?)))|\.[\s\xa0]*Mac(?:ab(?:e(?:os?|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?)))))|[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|M(?:ga[\s\xa0]*Macabeo|a(?:c(?:ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:[eo]s?|s)?|os?|s)?)|aeorum|e(?:aid|e(?:[eo]s?|s)?|os?|us|[is])?)|hab(?:aeorum|ejcov)|kab[eé]erboken|c(?:ab(?:b(?:e(?:os?|e(?:os?|[es])?|s)?|be[es]?)|e(?:e(?:[eo]s?|s)?|os?|[is])?|ées)|c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?)?)?|k(?:k(?:ab(?:e(?:e(?:[eë]n|rbok)|usok)|æerbog|[aä]er))?|abe(?:jsk[aá])?)?))|Wamakabayo|มัคคาบี|Мак(?:кавеев|а(?:ве(?:ј(?:ска|а)|[ії]в|и)|бејаца))|Ks(?:\.[\s\xa0]*Machabejska|[\s\xa0]*Machabejska|i[eę]g(?:[ai][\s\xa0]*Machabejska))))|[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|المكابيين|மக்(?:கபேயர்)?|Wamakabayo|มัคคาบี|Ks(?:\.[\s\xa0]*Machabejska|[\s\xa0]*Machabejska|i[eę]g(?:[ai][\s\xa0]*Machabejska))|M(?:c[bh]?|a(?:k(?:k(?:ab(?:e(?:e(?:[eë]n|rbok)|usok)|æerbog|[aä]er))?|abe(?:jsk[aá])?)?|c(?:ab(?:b(?:be(?:e[es]?|s)?|e(?:e(?:[eo]s?|s)?|os?|s)?)|aeorum|e(?:aid|e(?:[eo]s?|s)?|os?|us|[is])?)|h(?:ab(?:aeorum|ejcov))?|k(?:ab[eé]erboken)?|c(?:ab(?:b(?:e(?:os?|e(?:os?|[es])?|s)?|be[es]?)|e(?:e(?:[eo]s?|s)?|os?|[is])?|ées)|c(?:ab(?:b(?:e[es]?|be)|e(?:e[es]?|s)?))?)?)?)?|ga[\s\xa0]*Macabeo)?|k(?:\.[\s\xa0]*Machabejcov|[\s\xa0]*Machabejcov)|М(?:ак(?:а(?:ве(?:ј(?:ска|а)|[ії]в|и)|бејаца)|к(?:авеев)?)?|к)|مك)|마카|a(?:\.[\s\xa0]*Macabeus|[\s\xa0]*Macabeus)|Macc|re(?:\.[\s\xa0]*Maccab[eé]es|[\s\xa0]*Maccab[eé]es)|°(?:[\s\xa0]*Maccabei|\.[\s\xa0]*Maccabei)|º(?:[\s\xa0]*Mac(?:ab(?:e(?:os?|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?)))|\.[\s\xa0]*Mac(?:ab(?:e(?:os?|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?))))|o(?:\.[\s\xa0]*Mac(?:ab(?:e(?:os?|us|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?)))|[\s\xa0]*Mac(?:ab(?:e(?:os?|us|eos?)|be(?:os?|eos?))|cab(?:e(?:os?|eos?)|be(?:os?|eos?))))|-?(?:ше(?:\.[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Макаве[ії]в)|[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Макаве[ії]в))|а(?:\.[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Макаве[ії]в)|[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Макаве[ії]в))|я(?:\.[\s\xa0]*Маккавеев|[\s\xa0]*Маккавеев)|е(?:\.[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Мак(?:аве[ії]в|кавеев))|[\s\xa0]*(?:книга[\s\xa0]*Макаве[ії]в|Мак(?:аве[ії]в|кавеев))))|ère(?:\.[\s\xa0]*Maccab[eé]es|[\s\xa0]*Maccab[eé]es)|e(?:[\s\xa0]*Mak(?:kabee[eë]n)?|r(?:\.[\s\xa0]*Maccab[eé]es|[\s\xa0]*Maccab[eé]es|e(?:\.[\s\xa0]*Maccab[eé]es|[\s\xa0]*Maccab[eé]es))|\.[\s\xa0]*Mak(?:kabee[eë]n)?))|Liber[\s\xa0]*(?:Maccabaeorum[\s\xa0]*I|I[\s\xa0]*Maccabaeorum))|(?:Α['ʹʹ΄’][\s\xa0]*Μακκ|Перш[ае][\s\xa0]*Макаве(?:[ії]в))|(?:1[\s\xa0]*makk|Wamakabayo[\s\xa0]*I|المكابين[\s\xa0]*الأول|מקבים[\s\xa0]*א|《瑪加伯上|瑪加伯上》?|Maccabees))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["Judg"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:न्याय(?:िय(?:[\\s\\xa0]*का[\\s\\xa0]*विर्तान्त|ों)|कर्त(?:ा(?:हरूको[\\s\\xa0]*पुस्तक)?|्ताहरूको[\\s\\xa0]*पुस्तक))|Para[\\s\\xa0]*Hakim|Книга[\\s\\xa0]*(?:на[\\s\\xa0]*(?:съдиите|израелеви[\\s\\xa0]*судии)|С(?:уд(?:дів|е[ий][\\s\\xa0]*Израилевых)|ъдии[\\s\\xa0]*Израилеви))|K(?:\\.[\\s\\xa0]*sudcov|s(?:i[eę]g(?:[ai][\\s\\xa0]*S(?:[eę]dzi(?:[oó]w)))|\\.[\\s\\xa0]*S[eę]dzi(?:[oó]w)|[\\s\\xa0]*S[eę]dzi(?:[oó]w))|[\\s\\xa0]*sudcov|n(?:yha[\\s\\xa0]*Suddiv|jiga[\\s\\xa0]*o[\\s\\xa0]*Sucima))|שופטים|Quan[\\s\\xa0]*án|ବିଗ୍ଭରକର୍ତ୍ତାମାନଙ୍କ[\\s\\xa0]*ବିବରଣ|R(?:icht(?:er(?:en?)?)?|echt(?:ers)?)|士師|سفر[\\s\\xa0]*القضاة|Waam(?:uzi)?|qużāh|판관기?|Xaak(?:innada)?|Li(?:ber[\\s\\xa0]*Iudicum|v[\\s\\xa0]*Ch[eè]f[\\s\\xa0]*yo)|S(?:u(?:d(?:covia)?|ci)|[eę]dz|d[cz]?|oudc[uů])|N(?:iy[aā]y(?:[aā]tipatika[lḷ])|yayiyon)|T(?:uom(?:arien[\\s\\xa0]*kirja)?|hẩm[\\s\\xa0]*phán)|Huk|n(?:iāīāṃ[\\s\\xa0]*dī[\\s\\xa0]*potʰī|y[aā]yakartt(?:[aā]har(?:[uū]ko[\\s\\xa0]*pustak)))|B(?:arn(?:wyr)?|ír(?:[aá]k)?|ir[aá]k)|วนฉ|ந(?:ீத(?:ி(?:பதிகள்|த்[\\s\\xa0]*தலைவர்கள்))?|ியா(?:யாதிபதிகள(?:்[\\s\\xa0]*ஆகமம்|ின்[\\s\\xa0]*புத்தகம்))?)|Mga[\\s\\xa0]*(?:Hukom|Maghuhukom)|ผู้วินิจฉัย|《(?:民長紀》|士(?:师记》|師記》|》))|Iud|Các[\\s\\xa0]*(?:quan[\\s\\xa0]*xét|Thủ[\\s\\xa0]*lãnh)|J(?:ij|gs?|u(?:e(?:c(?:es)?)?|d(?:ec(?:ători|atorii?)|g(?:es)?)|g(?:es)?|(?:[ií]z(?:es)?))|dgs?|[cz])|사사기|D(?:óm(?:arab(?:[oó]k(?:in)?))?|om(?:ar(?:boken|ab(?:[oó]k(?:in)?))|mer(?:bogen|ne(?:s[\\s\\xa0]*bok)?)?)?|a(?:annata|na))|삿|ق(?:ُضاۃ|ض(?:ا[ةہۃ])?)|ਨਿਆ(?:ਂਈਆਂ[\\s\\xa0]*ਦੀ[\\s\\xa0]*ਪੋਥੀ|ਈਆਂ[\\s\\xa0]*ਦੀ[\\s\\xa0]*ਪੋਥੀ)|Κρ(?:ιτ(?:α[ίι]|[έε]ς)?)?|शास्ते|С(?:ъд|уд(?:ьи|иј[ае])?)|G(?:jy(?:qtar[eë]t)?|iudici|dc)|[ŝs](?:[aā]ste)|Amu)|(?:Iudicum|Hukom|士(?:师记》?|師記》?|》)?|Maghuhukom|Quan|С(?:уд(?:дів|е[ий]|ии)|ъдии(?:[\\s\\xa0]*Израилеви)?)|न्यायकर्त्ताहरूको|நியாயாதிபதிகள்|n(?:iāīāṃ|y[aā]yakartt(?:[āa]har(?:[ūu]ko)))|Dommernes|القضاة|S(?:[eę]dzi(?:[óo]w)|udcov)|Книга[\\s\\xa0]*Суде[ий]|《(?:士(?:师记|師記)?|民長紀)|T(?:uomarien|hủ(?:[\\s\\xa0]*lãnh)?)|民長紀》?))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Mark"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:ਮਰਕੁਸ[\\s\\xa0]*ਦੀ[\\s\\xa0]*ਇੰਜੀਲ|Sulat[\\s\\xa0]*ni[\\s\\xa0]*San[\\s\\xa0]*Marcos|ମାର୍କ[\\s\\xa0]*ଲିଖିତ[\\s\\xa0]*ସୁସମାଗ୍ଭର|The[\\s\\xa0]*Gospel[\\s\\xa0]*(?:according[\\s\\xa0]*to[\\s\\xa0]*(?:M(?:rk?|ark?|k)|S(?:aint[\\s\\xa0]*M(?:rk?|ark?|k)|t(?:\\.[\\s\\xa0]*M(?:rk?|ark?|k)|[\\s\\xa0]*M(?:rk?|ark?|k))))|of[\\s\\xa0]*(?:M(?:rk?|ark?|k)|S(?:aint[\\s\\xa0]*M(?:rk?|ark?|k)|t(?:\\.[\\s\\xa0]*M(?:rk?|ark?|k)|[\\s\\xa0]*M(?:rk?|ark?|k)))))|إنجيل[\\s\\xa0]*مرقس|m(?:ārk[aā]ne[\\s\\xa0]*lihilele[\\s\\xa0]*(?:[sŝ]ubʰavartam(?:[aā]n))|ar(?:k(?:[aā]ne[\\s\\xa0]*lihilele[\\s\\xa0]*(?:[sŝ]ubʰavartam(?:[aā]n))|ūsle[\\s\\xa0]*lekʰeko[\\s\\xa0]*susm[aā]c(?:[aā]r)|us(?:[\\s\\xa0]*dī[\\s\\xa0]*ĩjīl|le[\\s\\xa0]*lekʰeko[\\s\\xa0]*susm[aā]c(?:[aā]r)))|qus[\\s\\xa0]*kī[\\s\\xa0]*injīl))|Injil(?:[\\s\\xa0]*Markus|i[\\s\\xa0]*ya[\\s\\xa0]*Marko)|Vangelo[\\s\\xa0]*di[\\s\\xa0]*(?:Marco|San[\\s\\xa0]*Marco)|ม(?:าระโก|ก)|Євангелі(?:[яє][\\s\\xa0]*від[\\s\\xa0]*(?:Марка|св(?:[\\s\\xa0]*Марка|\\.[\\s\\xa0]*Марка)))|マルコ(?:による福音書|福音書|傳福音書|[伝書])|Ungjilli[\\s\\xa0]*i[\\s\\xa0]*Markut|พระวรสารนักบุญมาร์ค|마(?:르(?:코[\\s\\xa0]*복음서?)?|가(?:복음서?)?)|र्मक(?:ूस|स)|М(?:аркo?|[кр])|M(?:rc(?:os)?|ā[rṛ]ku[\\s\\xa0]*Na(?:[rṛ]ceyti)|á(?:rk|c(?:cô)?)|a(?:buting[\\s\\xa0]*Balita[\\s\\xa0]*ayon[\\s\\xa0]*kay[\\s\\xa0]*(?:Mar[ck]os|San[\\s\\xa0]*Mar[ck]os)|r(?:q(?:qoosa)?|ek|k(?:ovo[\\s\\xa0]*evangelium|úsarguðspjall|u(?:[\\s\\xa0]*Na[rṛ]ceyti|ksen[\\s\\xa0]*evankeliumi|s(?:[\\s\\xa0]*evangelium|arguðspjall|evangeliet)))|cu?|akus)|ṛku[\\s\\xa0]*Na[rṛ]ceyti)|c)|Jevan(?:helije[\\s\\xa0]*vid[\\s\\xa0]*Marka|đelje[\\s\\xa0]*po[\\s\\xa0]*Marku)|म(?:र(?:कुस|्क(?:ुस|ू(?:श|स(?:को[\\s\\xa0]*सुसमाचार|ले[\\s\\xa0]*लेखेको[\\s\\xa0]*सुसमाचार)?)))|ार्क(?:ाने[\\s\\xa0]*लिहिलेले[\\s\\xa0]*शुभवर्तमान)?)|הבשורה[\\s\\xa0]*על[\\s\\xa0\\-?]*פי[\\s\\xa0]*מרקוס|E(?:banghelyo[\\s\\xa0]*(?:ni[\\s\\xa0]*(?:Mar[ck]os|San[\\s\\xa0]*Mar[ck]os)|ayon[\\s\\xa0]*kay[\\s\\xa0]*Marcos)|l[\\s\\xa0]*Evangelio[\\s\\xa0]*de[\\s\\xa0]*Marcos|van(?:jelium[\\s\\xa0]*Pod[lľ]a[\\s\\xa0]*Marka|keliumi[\\s\\xa0]*Markuksen[\\s\\xa0]*mukaan|geli(?:um[\\s\\xa0]*(?:secundum[\\s\\xa0]*Marcum|podle[\\s\\xa0]*Marka)|e(?:t[\\s\\xa0]*etter[\\s\\xa0]*Markus|[\\s\\xa0]*volgens[\\s\\xa0]*Mar[ck]us))|[ðđ]elje[\\s\\xa0]*po[\\s\\xa0]*Marku)|w(?:angelia[\\s\\xa0]*(?:Marka|w(?:edług[\\s\\xa0]*(?:[sś]w(?:[\\s\\xa0]*Marka|\\.[\\s\\xa0]*Marka))|g[\\s\\xa0]*(?:[sś]w(?:[\\s\\xa0]*Marka|\\.[\\s\\xa0]*Marka))))|[\\s\\xa0]*Mar(?:ka)?|\\.[\\s\\xa0]*Marka))|Μ(?:(?:[άα]ρκ(?:ος)?)|ρ)|《(?:可》|马可福音》|瑪爾克》|馬(?:爾谷福音》|可福音》))|Еван(?:ђеље[\\s\\xa0]*по[\\s\\xa0]*Марку|гелие(?:то[\\s\\xa0]*според[\\s\\xa0]*Марко|[\\s\\xa0]*(?:според[\\s\\xa0]*Марко|от[\\s\\xa0]*Марк[ао])))|مر(?:ق(?:ُس[\\s\\xa0]*کی[\\s\\xa0]*انجیل|س[\\s\\xa0]*کی[\\s\\xa0]*انجیل))?|Κατ[άα][\\s\\xa0]*Μ(?:[άα]ρκον)|Јеванђеље[\\s\\xa0]*по[\\s\\xa0]*Марку|மாற்(?:கு[\\s\\xa0]*(?:நற்செய்தி|எழுதிய[\\s\\xa0]*(?:நற்செய்தி|சுவிசேஷம்)))?|От[\\s\\xa0]*Марка[\\s\\xa0]*свето[\\s\\xa0]*Евангелие)|(?:म(?:ार्काने|र्कूसले)|m(?:ārk[aā]ne|ark(?:us(?:le)?|ūsle|[āa]ne))|От[\\s\\xa0]*Марка|可》?|马可福音》?|Gospel[\\s\\xa0]*(?:according[\\s\\xa0]*to[\\s\\xa0]*(?:M(?:rk?|ark?|k)|S(?:aint[\\s\\xa0]*M(?:rk?|ark?|k)|t(?:\\.[\\s\\xa0]*M(?:rk?|ark?|k)|[\\s\\xa0]*M(?:rk?|ark?|k))))|of[\\s\\xa0]*(?:M(?:rk?|ark?|k)|S(?:aint[\\s\\xa0]*M(?:rk?|ark?|k)|t(?:\\.[\\s\\xa0]*M(?:rk?|ark?|k)|[\\s\\xa0]*M(?:rk?|ark?|k)))))|ମାର୍କ|S(?:t(?:\\.[\\s\\xa0]*M(?:rk?|ark?|k)|[\\s\\xa0]*M(?:rk?|ark?|k))|a(?:n[\\s\\xa0]*Marcos|int[\\s\\xa0]*M(?:rk?|ark?|k)))|Evangelio[\\s\\xa0]*de[\\s\\xa0]*Marcos|மாற்கு|《(?:马可福音|瑪爾克|可|馬(?:爾谷福音|可福音))|瑪爾克》?|馬(?:爾谷福音》?|可福音》?)|مرقس|Марк[оа]|Від[\\s\\xa0]*Марка|ਮਰਕੁਸ|M(?:rk?|a(?:r(?:c(?:os?|us)|k(?:u(?:ksen|s)?|os?|a)?)?|ṛku)|ā[ṛr]ku|k)))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Jas"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(yak(?:ob[aā]ce(?:[mṃ][\\s\\xa0]*patra)|[uū]bko[\\s\\xa0]*patra)|(?:याक(?:ोब(?:ाचें[\\s\\xa0]*पत्र)?|ूब(?:को[\\s\\xa0]*पत्र)?)|ヤコ(?:[フブ](?:からの手紙|の(?:手紙|書)|書)?)|Y(?:ākk[oō]pu[\\s\\xa0]*E(?:[lḻ]utiya[\\s\\xa0]*Nirupam)|a(?:aqooba|k(?:oob|k[oō]pu[\\s\\xa0]*E(?:[lḻ]utiya[\\s\\xa0]*Nirupam))?|q|c(?:q(?:uub)?)?))|ਯਾਕੂਬ[\\s\\xa0]*ਦੀ[\\s\\xa0]*ਪੱਤ੍ਰੀ|ย(?:ากอบ|[กบ])|Poslannja[\\s\\xa0]*apostola[\\s\\xa0]*Jakova|Јак(?:овова)?|᾿Ια|T(?:iago|g)|Waraka[\\s\\xa0]*wa[\\s\\xa0]*Yakobo|J(?:ms?|k|a(?:ak(?:obin[\\s\\xa0]*kirje)?|c(?:obo|q(?:ues)?)?|m(?:es?)?|s|ques|k(?:ub(?:ov[\\s\\xa0]*List)?|ab|o(?:vljeva[\\s\\xa0]*poslanica|b(?:us(?:brief)?|s(?:br(?:éfið|e(?:fið|vet))|[\\s\\xa0]*(?:epistel|Brev))|it?)?))?)?)|Як(?:уб)?|یعق(?:ُوب[\\s\\xa0]*کا[\\s\\xa0]*عام[\\s\\xa0]*خط|وب[\\s\\xa0]*کا[\\s\\xa0]*عا(?:م[\\s\\xa0]*خط|[\\s\\xa0]*م[\\s\\xa0]*خط))|П(?:ослан(?:и(?:ца[\\s\\xa0]*Јаковљева|е[\\s\\xa0]*(?:Иакова|на[\\s\\xa0]*(?:Яков|апостол[\\s\\xa0]*Јаков)))|ня[\\s\\xa0]*апостола[\\s\\xa0]*Якова)|исмо[\\s\\xa0]*од[\\s\\xa0]*апостол[\\s\\xa0]*Јаков)|ଯାକୁବଙ୍କ[\\s\\xa0]*ପତ୍ର|Hið[\\s\\xa0]*almenna[\\s\\xa0]*br[eé]f[\\s\\xa0]*Jakobs|G(?:ia(?:-?cơ|côbê)|[cm])|L(?:ist[\\s\\xa0]*(?:Jakub(?:[uů]v|a)|powszechny[\\s\\xa0]*[SŚ]wi(?:[eę]tego[\\s\\xa0]*Iakuba[\\s\\xa0]*Apostoła)|(?:[sś]w(?:\\.[\\s\\xa0]*Jakuba|[\\s\\xa0]*Jakuba)))|ayang[\\s\\xa0]*Yakobus|ettera[\\s\\xa0]*di[\\s\\xa0]*Giacomo)|Epistula[\\s\\xa0]*Iacobi|يع|Barua[\\s\\xa0]*ya[\\s\\xa0]*Yakobo|Иак|யாக(?:்(?:கோபு[\\s\\xa0]*(?:திருமுகம்|எழுதிய[\\s\\xa0]*(?:நிருபம்|திருமுகம்|கடிதம்)))?|ப்பர்[\\s\\xa0]*திருமுகம்)|С(?:оборне[\\s\\xa0]*послання[\\s\\xa0]*(?:Якова|св(?:[\\s\\xa0]*апостола[\\s\\xa0]*Якова|\\.[\\s\\xa0]*апостола[\\s\\xa0]*Якова))|ъборно[\\s\\xa0]*послание[\\s\\xa0]*на[\\s\\xa0]*св(?:[\\s\\xa0]*ап(?:\\.[\\s\\xa0]*Иакова|[\\s\\xa0]*Иакова)|\\.[\\s\\xa0]*ап(?:\\.[\\s\\xa0]*Иакова|[\\s\\xa0]*Иакова)))|رسالة[\\s\\xa0]*(?:القديس[\\s\\xa0]*يعقوب|يعقوب)|א(?:גרת[\\s\\xa0]*יעקב|יגרת[\\s\\xa0]*יעקב)|《(?:雅(?:》|各(?:[书書]》|伯書》))|亞适烏》)|Ιακ[ωώ]βου|y(?:āk(?:ūb(?:ko[\\s\\xa0]*patra|[\\s\\xa0]*dī[\\s\\xa0]*pattrī)|ob[aā]ce(?:[mṃ][\\s\\xa0]*patra)|ubko[\\s\\xa0]*patra)|aʿqūb[\\s\\xa0]*kā[\\s\\xa0]*ʿām[\\s\\xa0]*ḫaṭ)|S(?:tg?|an(?:t(?:iago)?)?)|야고(?:보(?:서|[\\s\\xa0]*서간))?|Ia(?:go?|c(?:o[bv])?))|(?:याक(?:ूबको|ोबाचें)|یعق(?:وب|ُوب)|Y(?:ākk[oō]pu|ak(?:ob(?:us|o)|k[oō]pu))|ଯାକୁବଙ୍କ|Послання[\\s\\xa0]*Якова|Iacobi|《(?:雅(?:各(?:伯書|[書书]))?|亞适烏)|Иакова|يعقوب|雅(?:各(?:[書书]》?|伯書》?)|》)?|Якова?|y(?:ak(?:[uū]bko|ob[āa]ce[ṃm])|āk(?:ūb(?:ko)?|ubko|ob[āa]ce[ṃm]))|Giacomo|亞适烏》?|Јаков(?:љева)?|ਯਾਕੂਬ|Ja(?:akobin|k(?:o(?:vljeva|bs(?:[\\s\\xa0]*brev)?)|ub(?:ov|a)))|யாக்கோபு))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Amos"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Ām[oō]s|ଆମୋଷ[\\s\\xa0]*ଭବିଷ୍ୟ‌ଦ୍‌ବକ୍ତାଙ୍କ[\\s\\xa0]*ପୁସ୍ତକ|עמוס|Αμ(?:[ωώ]ς)?|Prophetia[\\s\\xa0]*Amos|Ks(?:i[eę]g(?:[ai][\\s\\xa0]*Amosa)|[\\s\\xa0]*Amosa|\\.[\\s\\xa0]*Amosa)|سفر[\\s\\xa0]*عاموس|《(?:摩》|阿摩司[书書]》|亞毛斯》)|Ám(?:ós|osz?)?|ʿāmōs|アモス(?:しょ|書)?|Книга[\\s\\xa0]*(?:пророка[\\s\\xa0]*Амоса|на[\\s\\xa0]*пророк[\\s\\xa0]*Амоса?)|आमोस(?:को[\\s\\xa0]*पुस्तक)?|아모(?:스서?)?|عا(?:مُوس)?|Ам|A(?:m(?:o(?:s(?:(?:['’][\\s\\xa0]*(?:Bog|bok))|[iz])|xa?)?|ós?|ōs|s)?|-?mốt|am(?:oksen[\\s\\xa0]*kirja)?)|Ἀμ|Liv[\\s\\xa0]*Am[oò]s[\\s\\xa0]*la|암|อ(?:มส|าโมส)|ਆਮੋਸ|अमोस|ஆமோ(?:ஸ்)?|Caam(?:oos)?)|Amosa|(?:摩》|阿摩司[书書]》|[aā]mos|亞毛斯》|《(?:亞毛斯|阿摩司[書书]|摩)|Амоса?|عاموس|A(?:mòs|amoksen)|ଆମୋଷ)|(?:亞毛斯|Amos|阿摩司[書书]|摩))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Tob"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:《多俾亞傳》|طو|Ks(?:i(?:[eę]g(?:[ai][\\s\\xa0]*Tobi(?:ta|asza)))|\\.[\\s\\xa0]*Tobi(?:ta|asza)|[\\s\\xa0]*Tobi(?:ta|asza))|Liber[\\s\\xa0]*T(?:hobis|obiae)|T(?:ho|ób(?:ítsb[oó]k|i(?:t(?:sb[oó]k)?|j[aá][sš]|[aá]s))?|b|ob(?:í(?:tsb[oó]k|as?)|i(?:t(?:i(?:n[\\s\\xa0]*kirja)?|s(?:[\\s\\xa0]*(?:Bog|bok)|b[oó]k))|a(?:n[\\s\\xa0]*kirja|an[\\s\\xa0]*kirja|s['’][\\s\\xa0]*bok|š)?|j(?:a[sš]?|á[sš])|á[sš]|olo|e)?|t)?)|Τωβ(?:[ίι]τ)?|த(?:ோபி(?:த்து)?|ொபியாசு[\\s\\xa0]*ஆகமம்)|Cartea[\\s\\xa0]*lui[\\s\\xa0]*Tobit|То(?:бија|в)|토(?:빗기?|비트)|ト[ヒビ]ト[書記]?|โทบิต|سفر[\\s\\xa0]*طوبيا|К(?:нига[\\s\\xa0]*(?:на[\\s\\xa0]*Товита?|Товита|за[\\s\\xa0]*Тобия)|њига[\\s\\xa0]*Товијина)|טוביה)|(?:طوبيا|То(?:бия|вита?)|多俾亞傳》?|《多俾亞傳|Tobi(?:t(?:in)?|a(?:an|[sen]))))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Jdt"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:יהודית|《友弟德傳》|سفر[\\s\\xa0]*يهوديت|G(?:iuditta|dt)|유딧기?|Yud(?:it(?:hi?|i)|t)|J(?:úd(?:it(?:arb[oó]k)?|ítarb[oó]k|t)|d(?:th?|ith?)|ud(?:th?|ítarb[oó]k|it(?:in[\\s\\xa0]*kirja|s[\\s\\xa0]*(?:Bog|bok)|[eh]|a(?:rb[oó]k)?)?))|ยูดิธ|يـه|ユ(?:[テデ](?:ィト記?|ト書))|Юди(?:фь)?|யூதி(?:த்து)?|К(?:нига[\\s\\xa0]*(?:Юдити|Иудит|за[\\s\\xa0]*Юдита)|њига[\\s\\xa0]*о[\\s\\xa0]*Јудити)|Јуд(?:ита)?|Ι(?:ουδ[ίι]θ|δθ)|Liber[\\s\\xa0]*Iudith|I(?:dt|udita)|K(?:niha[\\s\\xa0]*Juditina|itab[\\s\\xa0]*Yudit|s(?:i[eę]g(?:[ai][\\s\\xa0]*Judyty)|[\\s\\xa0]*Judyty|\\.[\\s\\xa0]*Judyty)|\\.[\\s\\xa0]*Juditina|[\\s\\xa0]*Juditina))|(?:Юдити|Yudit|Jud(?:itin|yty)|Иудит|Iudith|يهوديت|友弟德傳》?|《友弟德傳))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Bar"],
        apocrypha: true,
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:K(?:s(?:[\\s\\xa0]*Barucha|\\.[\\s\\xa0]*Barucha|i[eę]g(?:[ai][\\s\\xa0]*Barucha))|itab[\\s\\xa0]*Barukh|niha[\\s\\xa0]*B(?:[aá]ru(?:chova|kova)))|Proroctvo[\\s\\xa0]*Baruchovo|《巴路克》|Liber[\\s\\xa0]*Baruch|바룩서?|با(?:روك)?|ספר[\\s\\xa0]*ברוך|ワルフの預言書|Β(?:αρ(?:ο[υύ]χ)?|ρ)|B(?:ár(?:u(?:ch|k))?|a(?:r(?:úksb[oó]k|u(?:k(?:in[\\s\\xa0]*kirja|s(?:[\\s\\xa0]*(?:Bog|bok)|b[oó]k)|u)?|que|[ch]))?|arukin[\\s\\xa0]*kirja)?|r)|Вар(?:ух)?|سفر[\\s\\xa0]*باروخ|Бару́ха|பாரூ(?:க்கு)?|[ハバ]ルク書?|Книга[\\s\\xa0]*(?:Варуха|пророка[\\s\\xa0]*Вару́ха|на[\\s\\xa0]*(?:Барух|пророк[\\s\\xa0]*Варуха))|บารุค|พระธรรมบารุค)|(?:Ba(?:arukin|ru(?:cha?|k(?:in|h)))|巴路克》?|ברוך|Варуха|《巴路克|Барух))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["1Kgs"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])((?:I(?:\.[\s\xa0]*K[is]|[\s\xa0]*K[is])|1(?:\.[\s\xa0]*(?:Ks|Re)|[\s\xa0]*(?:Ks|Re))))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["2Kgs"],
        regexp: /(^|[^0-9A-Za-zªµºÀ-ÖØ-öø-ɏ̀-ʹͶ-ͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁ҃-҇Ҋ-ԧ֑-ֽֿׁ-ׂׄ-ׇׅא-תװ-ײؐ-ؚؠ-ٟٮ-ۓە-ۜ۟-۪ۨ-ۯۺ-ۼۿݐ-ݿࢠࢢ-ࢬࣤ-ࣾऀ-ंऄ-ऺ़-ऽु-ै्ॐ-ॣॱ-ॷॹ-ॿਁ-ਂਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹ਼ੁ-ੂੇ-ੈੋ-੍ੑਖ਼-ੜਫ਼ੰ-ੵଁଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ଼-ଽିୁ-ୄ୍ୖଡ଼-ଢ଼ୟ-ୣୱஂ-ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-ஹீ்ௐก-ฺเ-๎᷀-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼ⃐-⃿Ⱡ-Ɀⷠ-ⷿ々-〆〪-〭〱-〵〻-〼㐀-䶵一-鿌Ꙁ-꙯ꙴ-꙽ꙿ-ꚗꚟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꟿ꣠-ꣷꣻ가-힯豈-舘並-龎ﭐ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼ])((?:2(?:\.[\s\xa0]*(?:Ks|Re)|[\s\xa0]*(?:Ks|Re))|II(?:\.[\s\xa0]*Ks|[\s\xa0]*Ks)))(?:(?=[\d\s\xa0.:,;\x1e\x1f&\(\)（）\[\]\/"'\*=~\-\u2013\u2014])|$)/gi
      }, {
        osis: ["Acts"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Апостол)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Ezek", "Ezra"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Ез|Ez))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Ezra"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(拉)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Hab", "Hag"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Ha)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Heb", "Hab"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Hb)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Job"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(伯)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["John"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:約|Jan))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["John", "Jonah"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Yn)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["John", "Jonah", "Job", "Josh", "Joel"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Jo)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["John", "Josh", "Joel", "Jonah"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(யோ)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Jonah", "Joel"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Yoo)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Josh"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(書)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Jude", "Judg"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(J(?:d|ud?))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Judg"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Bir)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Lam"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(La)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Lev"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(利)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Matt"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(太)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Matt", "Mark", "Mal"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Ma)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Mic"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Mi)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Phil", "Phlm"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Phl?)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Rev"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Re)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Song"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")((?:Songs|歌))(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }, {
        osis: ["Zeph", "Zech"],
        regexp: RegExp("(^|" + bcv_parser.prototype.regexps.pre_book + ")(Ze)(?:(?=[\\d\\s\\xa0.:,;\\x1e\\x1f&\\(\\)（）\\[\\]/\"'\\*=~\\-\\u2013\\u2014])|$)", "gi")
      }
    ];
    if (include_apocrypha === true && case_sensitive === "none") {
      return books;
    }
    out = [];
    for (k = 0, len = books.length; k < len; k++) {
      book = books[k];
      if (include_apocrypha === false && (book.apocrypha != null) && book.apocrypha === true) {
        continue;
      }
      if (case_sensitive === "books") {
        book.regexp = new RegExp(book.regexp.source, "g");
      }
      out.push(book);
    }
    return out;
  };

  bcv_parser.prototype.regexps.books = bcv_parser.prototype.regexps.get_books(false, "none");
var grammar = (function() {
  "use strict";

  /*
   * Generated by PEG.js 0.9.0.
   *
   * http://pegjs.org/
   */

  function peg$subclass(child, parent) {
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor();
  }

  function peg$SyntaxError(message, expected, found, location) {
    this.message  = message;
    this.expected = expected;
    this.found    = found;
    this.location = location;
    this.name     = "SyntaxError";

    if (typeof Error.captureStackTrace === "function") {
      Error.captureStackTrace(this, peg$SyntaxError);
    }
  }

  peg$subclass(peg$SyntaxError, Error);

  function peg$parse(input) {
    var options = arguments.length > 1 ? arguments[1] : {},
        parser  = this,

        peg$FAILED = {},

        peg$startRuleFunctions = { start: peg$parsestart },
        peg$startRuleFunction  = peg$parsestart,

        peg$c0 = function(val_1, val_2) { val_2.unshift([val_1]); return {"type": "sequence", "value": val_2, "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c1 = "(",
        peg$c2 = { type: "literal", value: "(", description: "\"(\"" },
        peg$c3 = ")",
        peg$c4 = { type: "literal", value: ")", description: "\")\"" },
        peg$c5 = function(val_1, val_2) { if (typeof(val_2) === "undefined") val_2 = []; val_2.unshift([val_1]); return {"type": "sequence_post_enclosed", "value": val_2, "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c6 = function(val_1, val_2) { if (val_1.length && val_1.length === 2) val_1 = val_1[0]; // for `b`, which returns [object, undefined]
              return {"type": "range", "value": [val_1, val_2], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c7 = "\x1F",
        peg$c8 = { type: "literal", value: "\x1F", description: "\"\\x1F\"" },
        peg$c9 = "/",
        peg$c10 = { type: "literal", value: "/", description: "\"/\"" },
        peg$c11 = /^[1-8]/,
        peg$c12 = { type: "class", value: "[1-8]", description: "[1-8]" },
        peg$c13 = function(val) { return {"type": "b", "value": val.value, "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c14 = function(val_1, val_2) { return {"type": "bc", "value": [val_1, val_2], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c15 = ",",
        peg$c16 = { type: "literal", value: ",", description: "\",\"" },
        peg$c17 = function(val_1, val_2) { return {"type": "bc_title", "value": [val_1, val_2], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c18 = ".",
        peg$c19 = { type: "literal", value: ".", description: "\".\"" },
        peg$c20 = function(val_1, val_2) { return {"type": "bcv", "value": [val_1, val_2], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c21 = "-",
        peg$c22 = { type: "literal", value: "-", description: "\"-\"" },
        peg$c23 = function(val_1, val_2, val_3, val_4) { return {"type": "range", "value": [{"type": "bcv", "value": [{"type": "bc", "value": [val_1, val_2], "indices": [val_1.indices[0], val_2.indices[1]]}, val_3], "indices": [val_1.indices[0], val_3.indices[1]]}, val_4], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c24 = function(val_1, val_2) { return {"type": "bv", "value": [val_1, val_2], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c25 = function(val_1, val_2) { return {"type": "bc", "value": [val_2, val_1], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c26 = function(val_1, val_2, val_3) { return {"type": "cb_range", "value": [val_3, val_1, val_2], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c27 = "th",
        peg$c28 = { type: "literal", value: "th", description: "\"th\"" },
        peg$c29 = "nd",
        peg$c30 = { type: "literal", value: "nd", description: "\"nd\"" },
        peg$c31 = "st",
        peg$c32 = { type: "literal", value: "st", description: "\"st\"" },
        peg$c33 = "/1\x1F",
        peg$c34 = { type: "literal", value: "/1\x1F", description: "\"/1\\x1F\"" },
        peg$c35 = function(val) { return {"type": "c_psalm", "value": val.value, "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c36 = function(val_1, val_2) { return {"type": "cv_psalm", "value": [val_1, val_2], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c37 = function(val_1, val_2) { return {"type": "c_title", "value": [val_1, val_2], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c38 = function(val_1, val_2) { return {"type": "cv", "value": [val_1, val_2], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c39 = function(val) { return {"type": "c", "value": [val], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c40 = "ff",
        peg$c41 = { type: "literal", value: "ff", description: "\"ff\"" },
        peg$c42 = /^[a-z0-9]/,
        peg$c43 = { type: "class", value: "[a-z0-9]", description: "[a-z0-9]" },
        peg$c44 = "f",
        peg$c45 = { type: "literal", value: "f", description: "\"f\"" },
        peg$c46 = /^[a-z]/,
        peg$c47 = { type: "class", value: "[a-z]", description: "[a-z]" },
        peg$c48 = function(val_1) { return {"type": "ff", "value": [val_1], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c49 = "title",
        peg$c50 = { type: "literal", value: "title", description: "\"title\"" },
        peg$c51 = function(val_1) { return {"type": "integer_title", "value": [val_1], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c52 = "/9\x1F",
        peg$c53 = { type: "literal", value: "/9\x1F", description: "\"/9\\x1F\"" },
        peg$c54 = function(val) { return {"type": "context", "value": val.value, "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c55 = "/2\x1F",
        peg$c56 = { type: "literal", value: "/2\x1F", description: "\"/2\\x1F\"" },
        peg$c57 = ".1",
        peg$c58 = { type: "literal", value: ".1", description: "\".1\"" },
        peg$c59 = /^[0-9]/,
        peg$c60 = { type: "class", value: "[0-9]", description: "[0-9]" },
        peg$c61 = function(val) { return {"type": "bc", "value": [val, {"type": "c", "value": [{"type": "integer", "value": 151, "indices": [peg$currPos - 2, peg$currPos - 1]}], "indices": [peg$currPos - 2, peg$currPos - 1]}], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c62 = function(val_1, val_2) { return {"type": "bcv", "value": [val_1, {"type": "v", "value": [val_2], "indices": [val_2.indices[0], val_2.indices[1]]}], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c63 = /^[a-e]/,
        peg$c64 = { type: "class", value: "[a-e]", description: "[a-e]" },
        peg$c65 = function(val) { return {"type": "v", "value": [val], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c66 = "ch",
        peg$c67 = { type: "literal", value: "ch", description: "\"ch\"" },
        peg$c68 = "apters",
        peg$c69 = { type: "literal", value: "apters", description: "\"apters\"" },
        peg$c70 = "apter",
        peg$c71 = { type: "literal", value: "apter", description: "\"apter\"" },
        peg$c72 = "apts",
        peg$c73 = { type: "literal", value: "apts", description: "\"apts\"" },
        peg$c74 = "pts",
        peg$c75 = { type: "literal", value: "pts", description: "\"pts\"" },
        peg$c76 = "apt",
        peg$c77 = { type: "literal", value: "apt", description: "\"apt\"" },
        peg$c78 = "aps",
        peg$c79 = { type: "literal", value: "aps", description: "\"aps\"" },
        peg$c80 = "ap",
        peg$c81 = { type: "literal", value: "ap", description: "\"ap\"" },
        peg$c82 = "p",
        peg$c83 = { type: "literal", value: "p", description: "\"p\"" },
        peg$c84 = "s",
        peg$c85 = { type: "literal", value: "s", description: "\"s\"" },
        peg$c86 = "a",
        peg$c87 = { type: "literal", value: "a", description: "\"a\"" },
        peg$c88 = function() { return {"type": "c_explicit"} },
        peg$c89 = "v",
        peg$c90 = { type: "literal", value: "v", description: "\"v\"" },
        peg$c91 = "erses",
        peg$c92 = { type: "literal", value: "erses", description: "\"erses\"" },
        peg$c93 = "erse",
        peg$c94 = { type: "literal", value: "erse", description: "\"erse\"" },
        peg$c95 = "er",
        peg$c96 = { type: "literal", value: "er", description: "\"er\"" },
        peg$c97 = "ss",
        peg$c98 = { type: "literal", value: "ss", description: "\"ss\"" },
        peg$c99 = function() { return {"type": "v_explicit"} },
        peg$c100 = ":",
        peg$c101 = { type: "literal", value: ":", description: "\":\"" },
        peg$c102 = /^["']/,
        peg$c103 = { type: "class", value: "[\"']", description: "[\"']" },
        peg$c104 = /^[,;\/:&\-\u2013\u2014~]/,
        peg$c105 = { type: "class", value: "[,;/:&\\-\\u2013\\u2014~]", description: "[,;/:&\\-\\u2013\\u2014~]" },
        peg$c106 = "and",
        peg$c107 = { type: "literal", value: "and", description: "\"and\"" },
        peg$c108 = "compare",
        peg$c109 = { type: "literal", value: "compare", description: "\"compare\"" },
        peg$c110 = "cf",
        peg$c111 = { type: "literal", value: "cf", description: "\"cf\"" },
        peg$c112 = "see",
        peg$c113 = { type: "literal", value: "see", description: "\"see\"" },
        peg$c114 = "also",
        peg$c115 = { type: "literal", value: "also", description: "\"also\"" },
        peg$c116 = function() { return "" },
        peg$c117 = /^[\-\u2013\u2014]/,
        peg$c118 = { type: "class", value: "[\\-\\u2013\\u2014]", description: "[\\-\\u2013\\u2014]" },
        peg$c119 = "through",
        peg$c120 = { type: "literal", value: "through", description: "\"through\"" },
        peg$c121 = "thru",
        peg$c122 = { type: "literal", value: "thru", description: "\"thru\"" },
        peg$c123 = "to",
        peg$c124 = { type: "literal", value: "to", description: "\"to\"" },
        peg$c125 = function(val) { return {type:"title", value: [val], "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c126 = "from",
        peg$c127 = { type: "literal", value: "from", description: "\"from\"" },
        peg$c128 = "of",
        peg$c129 = { type: "literal", value: "of", description: "\"of\"" },
        peg$c130 = "in",
        peg$c131 = { type: "literal", value: "in", description: "\"in\"" },
        peg$c132 = "the",
        peg$c133 = { type: "literal", value: "the", description: "\"the\"" },
        peg$c134 = "book",
        peg$c135 = { type: "literal", value: "book", description: "\"book\"" },
        peg$c136 = /^[([]/,
        peg$c137 = { type: "class", value: "[\\(\\[]", description: "[\\(\\[]" },
        peg$c138 = /^[)\]]/,
        peg$c139 = { type: "class", value: "[\\)\\]]", description: "[\\)\\]]" },
        peg$c140 = function(val) { return {"type": "translation_sequence", "value": val, "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c141 = "\x1E",
        peg$c142 = { type: "literal", value: "\x1E", description: "\"\\x1E\"" },
        peg$c143 = function(val) { return {"type": "translation", "value": val.value, "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c144 = ",000",
        peg$c145 = { type: "literal", value: ",000", description: "\",000\"" },
        peg$c146 = function(val) { return {"type": "integer", "value": parseInt(val.join(""), 10), "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c147 = /^[^\x1F\x1E([]/,
        peg$c148 = { type: "class", value: "[^\\x1f\\x1e\\(\\[]", description: "[^\\x1f\\x1e\\(\\[]" },
        peg$c149 = function(val) { return {"type": "word", "value": val.join(""), "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c150 = function(val) { return {"type": "stop", "value": val, "indices": [peg$savedPos, peg$currPos - 1]} },
        peg$c151 = /^[\s\xa0*]/,
        peg$c152 = { type: "class", value: "[\\s\\xa0\\*]", description: "[\\s\\xa0\\*]" },

        peg$currPos          = 0,
        peg$savedPos         = 0,
        peg$posDetailsCache  = [{ line: 1, column: 1, seenCR: false }],
        peg$maxFailPos       = 0,
        peg$maxFailExpected  = [],
        peg$silentFails      = 0,

        peg$result;

    if ("startRule" in options) {
      if (!(options.startRule in peg$startRuleFunctions)) {
        throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
      }

      peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
    }

    if ("punctuation_strategy" in options && options.punctuation_strategy === "eu") {
        peg$parsecv_sep = peg$parseeu_cv_sep;
        peg$c104 = /^[;\/:&\-\u2013\u2014~]/;
    }

    function text() {
      return input.substring(peg$savedPos, peg$currPos);
    }

    function location() {
      return peg$computeLocation(peg$savedPos, peg$currPos);
    }

    function expected(description) {
      throw peg$buildException(
        null,
        [{ type: "other", description: description }],
        input.substring(peg$savedPos, peg$currPos),
        peg$computeLocation(peg$savedPos, peg$currPos)
      );
    }

    function error(message) {
      throw peg$buildException(
        message,
        null,
        input.substring(peg$savedPos, peg$currPos),
        peg$computeLocation(peg$savedPos, peg$currPos)
      );
    }

    function peg$computePosDetails(pos) {
      var details = peg$posDetailsCache[pos],
          p, ch;

      if (details) {
        return details;
      } else {
        p = pos - 1;
        while (!peg$posDetailsCache[p]) {
          p--;
        }

        details = peg$posDetailsCache[p];
        details = {
          line:   details.line,
          column: details.column,
          seenCR: details.seenCR
        };

        while (p < pos) {
          ch = input.charAt(p);
          if (ch === "\n") {
            if (!details.seenCR) { details.line++; }
            details.column = 1;
            details.seenCR = false;
          } else if (ch === "\r" || ch === "\u2028" || ch === "\u2029") {
            details.line++;
            details.column = 1;
            details.seenCR = true;
          } else {
            details.column++;
            details.seenCR = false;
          }

          p++;
        }

        peg$posDetailsCache[pos] = details;
        return details;
      }
    }

    function peg$computeLocation(startPos, endPos) {
      var startPosDetails = peg$computePosDetails(startPos),
          endPosDetails   = peg$computePosDetails(endPos);

      return {
        start: {
          offset: startPos,
          line:   startPosDetails.line,
          column: startPosDetails.column
        },
        end: {
          offset: endPos,
          line:   endPosDetails.line,
          column: endPosDetails.column
        }
      };
    }

    function peg$fail(expected) {
      if (peg$currPos < peg$maxFailPos) { return; }

      if (peg$currPos > peg$maxFailPos) {
        peg$maxFailPos = peg$currPos;
        peg$maxFailExpected = [];
      }

      peg$maxFailExpected.push(expected);
    }

    function peg$buildException(message, expected, found, location) {
      function cleanupExpected(expected) {
        var i = 1;

        expected.sort(function(a, b) {
          if (a.description < b.description) {
            return -1;
          } else if (a.description > b.description) {
            return 1;
          } else {
            return 0;
          }
        });

        while (i < expected.length) {
          if (expected[i - 1] === expected[i]) {
            expected.splice(i, 1);
          } else {
            i++;
          }
        }
      }

      function buildMessage(expected, found) {
        function stringEscape(s) {
          function hex(ch) { return ch.charCodeAt(0).toString(16).toUpperCase(); }

          return s
            .replace(/\\/g,   '\\\\')
            .replace(/"/g,    '\\"')
            .replace(/\x08/g, '\\b')
            .replace(/\t/g,   '\\t')
            .replace(/\n/g,   '\\n')
            .replace(/\f/g,   '\\f')
            .replace(/\r/g,   '\\r')
            .replace(/[\x00-\x07\x0B\x0E\x0F]/g, function(ch) { return '\\x0' + hex(ch); })
            .replace(/[\x10-\x1F\x80-\xFF]/g,    function(ch) { return '\\x'  + hex(ch); })
            .replace(/[\u0100-\u0FFF]/g,         function(ch) { return '\\u0' + hex(ch); })
            .replace(/[\u1000-\uFFFF]/g,         function(ch) { return '\\u'  + hex(ch); });
        }

        var expectedDescs = new Array(expected.length),
            expectedDesc, foundDesc, i;

        for (i = 0; i < expected.length; i++) {
          expectedDescs[i] = expected[i].description;
        }

        expectedDesc = expected.length > 1
          ? expectedDescs.slice(0, -1).join(", ")
              + " or "
              + expectedDescs[expected.length - 1]
          : expectedDescs[0];

        foundDesc = found ? "\"" + stringEscape(found) + "\"" : "end of input";

        return "Expected " + expectedDesc + " but " + foundDesc + " found.";
      }

      if (expected !== null) {
        cleanupExpected(expected);
      }

      return new peg$SyntaxError(
        message !== null ? message : buildMessage(expected, found),
        expected,
        found,
        location
      );
    }

    function peg$parsestart() {
      var s0, s1;

      s0 = [];
      s1 = peg$parsebcv_hyphen_range();
      if (s1 === peg$FAILED) {
        s1 = peg$parsesequence();
        if (s1 === peg$FAILED) {
          s1 = peg$parsecb_range();
          if (s1 === peg$FAILED) {
            s1 = peg$parserange();
            if (s1 === peg$FAILED) {
              s1 = peg$parseff();
              if (s1 === peg$FAILED) {
                s1 = peg$parsebcv_comma();
                if (s1 === peg$FAILED) {
                  s1 = peg$parsebc_title();
                  if (s1 === peg$FAILED) {
                    s1 = peg$parseps151_bcv();
                    if (s1 === peg$FAILED) {
                      s1 = peg$parsebcv();
                      if (s1 === peg$FAILED) {
                        s1 = peg$parsebcv_weak();
                        if (s1 === peg$FAILED) {
                          s1 = peg$parseps151_bc();
                          if (s1 === peg$FAILED) {
                            s1 = peg$parsebc();
                            if (s1 === peg$FAILED) {
                              s1 = peg$parsecv_psalm();
                              if (s1 === peg$FAILED) {
                                s1 = peg$parsebv();
                                if (s1 === peg$FAILED) {
                                  s1 = peg$parsec_psalm();
                                  if (s1 === peg$FAILED) {
                                    s1 = peg$parseb();
                                    if (s1 === peg$FAILED) {
                                      s1 = peg$parsecbv();
                                      if (s1 === peg$FAILED) {
                                        s1 = peg$parsecbv_ordinal();
                                        if (s1 === peg$FAILED) {
                                          s1 = peg$parsecb();
                                          if (s1 === peg$FAILED) {
                                            s1 = peg$parsecb_ordinal();
                                            if (s1 === peg$FAILED) {
                                              s1 = peg$parsetranslation_sequence_enclosed();
                                              if (s1 === peg$FAILED) {
                                                s1 = peg$parsetranslation_sequence();
                                                if (s1 === peg$FAILED) {
                                                  s1 = peg$parsesequence_sep();
                                                  if (s1 === peg$FAILED) {
                                                    s1 = peg$parsec_title();
                                                    if (s1 === peg$FAILED) {
                                                      s1 = peg$parseinteger_title();
                                                      if (s1 === peg$FAILED) {
                                                        s1 = peg$parsecv();
                                                        if (s1 === peg$FAILED) {
                                                          s1 = peg$parsecv_weak();
                                                          if (s1 === peg$FAILED) {
                                                            s1 = peg$parsev_letter();
                                                            if (s1 === peg$FAILED) {
                                                              s1 = peg$parseinteger();
                                                              if (s1 === peg$FAILED) {
                                                                s1 = peg$parsec();
                                                                if (s1 === peg$FAILED) {
                                                                  s1 = peg$parsev();
                                                                  if (s1 === peg$FAILED) {
                                                                    s1 = peg$parseword();
                                                                    if (s1 === peg$FAILED) {
                                                                      s1 = peg$parseword_parenthesis();
                                                                      if (s1 === peg$FAILED) {
                                                                        s1 = peg$parsecontext();
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                            }
                                                          }
                                                        }
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      if (s1 !== peg$FAILED) {
        while (s1 !== peg$FAILED) {
          s0.push(s1);
          s1 = peg$parsebcv_hyphen_range();
          if (s1 === peg$FAILED) {
            s1 = peg$parsesequence();
            if (s1 === peg$FAILED) {
              s1 = peg$parsecb_range();
              if (s1 === peg$FAILED) {
                s1 = peg$parserange();
                if (s1 === peg$FAILED) {
                  s1 = peg$parseff();
                  if (s1 === peg$FAILED) {
                    s1 = peg$parsebcv_comma();
                    if (s1 === peg$FAILED) {
                      s1 = peg$parsebc_title();
                      if (s1 === peg$FAILED) {
                        s1 = peg$parseps151_bcv();
                        if (s1 === peg$FAILED) {
                          s1 = peg$parsebcv();
                          if (s1 === peg$FAILED) {
                            s1 = peg$parsebcv_weak();
                            if (s1 === peg$FAILED) {
                              s1 = peg$parseps151_bc();
                              if (s1 === peg$FAILED) {
                                s1 = peg$parsebc();
                                if (s1 === peg$FAILED) {
                                  s1 = peg$parsecv_psalm();
                                  if (s1 === peg$FAILED) {
                                    s1 = peg$parsebv();
                                    if (s1 === peg$FAILED) {
                                      s1 = peg$parsec_psalm();
                                      if (s1 === peg$FAILED) {
                                        s1 = peg$parseb();
                                        if (s1 === peg$FAILED) {
                                          s1 = peg$parsecbv();
                                          if (s1 === peg$FAILED) {
                                            s1 = peg$parsecbv_ordinal();
                                            if (s1 === peg$FAILED) {
                                              s1 = peg$parsecb();
                                              if (s1 === peg$FAILED) {
                                                s1 = peg$parsecb_ordinal();
                                                if (s1 === peg$FAILED) {
                                                  s1 = peg$parsetranslation_sequence_enclosed();
                                                  if (s1 === peg$FAILED) {
                                                    s1 = peg$parsetranslation_sequence();
                                                    if (s1 === peg$FAILED) {
                                                      s1 = peg$parsesequence_sep();
                                                      if (s1 === peg$FAILED) {
                                                        s1 = peg$parsec_title();
                                                        if (s1 === peg$FAILED) {
                                                          s1 = peg$parseinteger_title();
                                                          if (s1 === peg$FAILED) {
                                                            s1 = peg$parsecv();
                                                            if (s1 === peg$FAILED) {
                                                              s1 = peg$parsecv_weak();
                                                              if (s1 === peg$FAILED) {
                                                                s1 = peg$parsev_letter();
                                                                if (s1 === peg$FAILED) {
                                                                  s1 = peg$parseinteger();
                                                                  if (s1 === peg$FAILED) {
                                                                    s1 = peg$parsec();
                                                                    if (s1 === peg$FAILED) {
                                                                      s1 = peg$parsev();
                                                                      if (s1 === peg$FAILED) {
                                                                        s1 = peg$parseword();
                                                                        if (s1 === peg$FAILED) {
                                                                          s1 = peg$parseword_parenthesis();
                                                                          if (s1 === peg$FAILED) {
                                                                            s1 = peg$parsecontext();
                                                                          }
                                                                        }
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                            }
                                                          }
                                                        }
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      } else {
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsesequence() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      s1 = peg$parsecb_range();
      if (s1 === peg$FAILED) {
        s1 = peg$parsebcv_hyphen_range();
        if (s1 === peg$FAILED) {
          s1 = peg$parserange();
          if (s1 === peg$FAILED) {
            s1 = peg$parseff();
            if (s1 === peg$FAILED) {
              s1 = peg$parsebcv_comma();
              if (s1 === peg$FAILED) {
                s1 = peg$parsebc_title();
                if (s1 === peg$FAILED) {
                  s1 = peg$parseps151_bcv();
                  if (s1 === peg$FAILED) {
                    s1 = peg$parsebcv();
                    if (s1 === peg$FAILED) {
                      s1 = peg$parsebcv_weak();
                      if (s1 === peg$FAILED) {
                        s1 = peg$parseps151_bc();
                        if (s1 === peg$FAILED) {
                          s1 = peg$parsebc();
                          if (s1 === peg$FAILED) {
                            s1 = peg$parsecv_psalm();
                            if (s1 === peg$FAILED) {
                              s1 = peg$parsebv();
                              if (s1 === peg$FAILED) {
                                s1 = peg$parsec_psalm();
                                if (s1 === peg$FAILED) {
                                  s1 = peg$parseb();
                                  if (s1 === peg$FAILED) {
                                    s1 = peg$parsecbv();
                                    if (s1 === peg$FAILED) {
                                      s1 = peg$parsecbv_ordinal();
                                      if (s1 === peg$FAILED) {
                                        s1 = peg$parsecb();
                                        if (s1 === peg$FAILED) {
                                          s1 = peg$parsecb_ordinal();
                                          if (s1 === peg$FAILED) {
                                            s1 = peg$parsecontext();
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        s4 = peg$parsesequence_sep();
        if (s4 === peg$FAILED) {
          s4 = null;
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parsesequence_post();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$currPos;
            s4 = peg$parsesequence_sep();
            if (s4 === peg$FAILED) {
              s4 = null;
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parsesequence_post();
              if (s5 !== peg$FAILED) {
                s4 = [s4, s5];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          }
        } else {
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c0(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsesequence_post_enclosed() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 40) {
        s1 = peg$c1;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c2); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parsesp();
        if (s2 !== peg$FAILED) {
          s3 = peg$parsesequence_sep();
          if (s3 === peg$FAILED) {
            s3 = null;
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parsesequence_post();
            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$currPos;
              s7 = peg$parsesequence_sep();
              if (s7 === peg$FAILED) {
                s7 = null;
              }
              if (s7 !== peg$FAILED) {
                s8 = peg$parsesequence_post();
                if (s8 !== peg$FAILED) {
                  s7 = [s7, s8];
                  s6 = s7;
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
              } else {
                peg$currPos = s6;
                s6 = peg$FAILED;
              }
              while (s6 !== peg$FAILED) {
                s5.push(s6);
                s6 = peg$currPos;
                s7 = peg$parsesequence_sep();
                if (s7 === peg$FAILED) {
                  s7 = null;
                }
                if (s7 !== peg$FAILED) {
                  s8 = peg$parsesequence_post();
                  if (s8 !== peg$FAILED) {
                    s7 = [s7, s8];
                    s6 = s7;
                  } else {
                    peg$currPos = s6;
                    s6 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
              }
              if (s5 !== peg$FAILED) {
                s6 = peg$parsesp();
                if (s6 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 41) {
                    s7 = peg$c3;
                    peg$currPos++;
                  } else {
                    s7 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c4); }
                  }
                  if (s7 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c5(s4, s5);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsesequence_post() {
      var s0;

      s0 = peg$parsesequence_post_enclosed();
      if (s0 === peg$FAILED) {
        s0 = peg$parsecb_range();
        if (s0 === peg$FAILED) {
          s0 = peg$parsebcv_hyphen_range();
          if (s0 === peg$FAILED) {
            s0 = peg$parserange();
            if (s0 === peg$FAILED) {
              s0 = peg$parseff();
              if (s0 === peg$FAILED) {
                s0 = peg$parsebcv_comma();
                if (s0 === peg$FAILED) {
                  s0 = peg$parsebc_title();
                  if (s0 === peg$FAILED) {
                    s0 = peg$parseps151_bcv();
                    if (s0 === peg$FAILED) {
                      s0 = peg$parsebcv();
                      if (s0 === peg$FAILED) {
                        s0 = peg$parsebcv_weak();
                        if (s0 === peg$FAILED) {
                          s0 = peg$parseps151_bc();
                          if (s0 === peg$FAILED) {
                            s0 = peg$parsebc();
                            if (s0 === peg$FAILED) {
                              s0 = peg$parsecv_psalm();
                              if (s0 === peg$FAILED) {
                                s0 = peg$parsebv();
                                if (s0 === peg$FAILED) {
                                  s0 = peg$parsec_psalm();
                                  if (s0 === peg$FAILED) {
                                    s0 = peg$parseb();
                                    if (s0 === peg$FAILED) {
                                      s0 = peg$parsecbv();
                                      if (s0 === peg$FAILED) {
                                        s0 = peg$parsecbv_ordinal();
                                        if (s0 === peg$FAILED) {
                                          s0 = peg$parsecb();
                                          if (s0 === peg$FAILED) {
                                            s0 = peg$parsecb_ordinal();
                                            if (s0 === peg$FAILED) {
                                              s0 = peg$parsec_title();
                                              if (s0 === peg$FAILED) {
                                                s0 = peg$parseinteger_title();
                                                if (s0 === peg$FAILED) {
                                                  s0 = peg$parsecv();
                                                  if (s0 === peg$FAILED) {
                                                    s0 = peg$parsecv_weak();
                                                    if (s0 === peg$FAILED) {
                                                      s0 = peg$parsev_letter();
                                                      if (s0 === peg$FAILED) {
                                                        s0 = peg$parseinteger();
                                                        if (s0 === peg$FAILED) {
                                                          s0 = peg$parsec();
                                                          if (s0 === peg$FAILED) {
                                                            s0 = peg$parsev();
                                                          }
                                                        }
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }

      return s0;
    }

    function peg$parserange() {
      var s0, s1, s2, s3, s4, s5, s6;

      s0 = peg$currPos;
      s1 = peg$parsebcv_comma();
      if (s1 === peg$FAILED) {
        s1 = peg$parsebc_title();
        if (s1 === peg$FAILED) {
          s1 = peg$parseps151_bcv();
          if (s1 === peg$FAILED) {
            s1 = peg$parsebcv();
            if (s1 === peg$FAILED) {
              s1 = peg$parsebcv_weak();
              if (s1 === peg$FAILED) {
                s1 = peg$parseps151_bc();
                if (s1 === peg$FAILED) {
                  s1 = peg$parsebc();
                  if (s1 === peg$FAILED) {
                    s1 = peg$parsecv_psalm();
                    if (s1 === peg$FAILED) {
                      s1 = peg$parsebv();
                      if (s1 === peg$FAILED) {
                        s1 = peg$currPos;
                        s2 = peg$parseb();
                        if (s2 !== peg$FAILED) {
                          s3 = peg$currPos;
                          peg$silentFails++;
                          s4 = peg$currPos;
                          s5 = peg$parserange_sep();
                          if (s5 !== peg$FAILED) {
                            s6 = peg$parsebcv_comma();
                            if (s6 === peg$FAILED) {
                              s6 = peg$parsebc_title();
                              if (s6 === peg$FAILED) {
                                s6 = peg$parseps151_bcv();
                                if (s6 === peg$FAILED) {
                                  s6 = peg$parsebcv();
                                  if (s6 === peg$FAILED) {
                                    s6 = peg$parsebcv_weak();
                                    if (s6 === peg$FAILED) {
                                      s6 = peg$parseps151_bc();
                                      if (s6 === peg$FAILED) {
                                        s6 = peg$parsebc();
                                        if (s6 === peg$FAILED) {
                                          s6 = peg$parsebv();
                                          if (s6 === peg$FAILED) {
                                            s6 = peg$parseb();
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                            if (s6 !== peg$FAILED) {
                              s5 = [s5, s6];
                              s4 = s5;
                            } else {
                              peg$currPos = s4;
                              s4 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s4;
                            s4 = peg$FAILED;
                          }
                          peg$silentFails--;
                          if (s4 !== peg$FAILED) {
                            peg$currPos = s3;
                            s3 = void 0;
                          } else {
                            s3 = peg$FAILED;
                          }
                          if (s3 !== peg$FAILED) {
                            s2 = [s2, s3];
                            s1 = s2;
                          } else {
                            peg$currPos = s1;
                            s1 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s1;
                          s1 = peg$FAILED;
                        }
                        if (s1 === peg$FAILED) {
                          s1 = peg$parsecbv();
                          if (s1 === peg$FAILED) {
                            s1 = peg$parsecbv_ordinal();
                            if (s1 === peg$FAILED) {
                              s1 = peg$parsec_psalm();
                              if (s1 === peg$FAILED) {
                                s1 = peg$parsecb();
                                if (s1 === peg$FAILED) {
                                  s1 = peg$parsecb_ordinal();
                                  if (s1 === peg$FAILED) {
                                    s1 = peg$parsec_title();
                                    if (s1 === peg$FAILED) {
                                      s1 = peg$parseinteger_title();
                                      if (s1 === peg$FAILED) {
                                        s1 = peg$parsecv();
                                        if (s1 === peg$FAILED) {
                                          s1 = peg$parsecv_weak();
                                          if (s1 === peg$FAILED) {
                                            s1 = peg$parsev_letter();
                                            if (s1 === peg$FAILED) {
                                              s1 = peg$parseinteger();
                                              if (s1 === peg$FAILED) {
                                                s1 = peg$parsec();
                                                if (s1 === peg$FAILED) {
                                                  s1 = peg$parsev();
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parserange_sep();
        if (s2 !== peg$FAILED) {
          s3 = peg$parseff();
          if (s3 === peg$FAILED) {
            s3 = peg$parsebcv_comma();
            if (s3 === peg$FAILED) {
              s3 = peg$parsebc_title();
              if (s3 === peg$FAILED) {
                s3 = peg$parseps151_bcv();
                if (s3 === peg$FAILED) {
                  s3 = peg$parsebcv();
                  if (s3 === peg$FAILED) {
                    s3 = peg$parsebcv_weak();
                    if (s3 === peg$FAILED) {
                      s3 = peg$parseps151_bc();
                      if (s3 === peg$FAILED) {
                        s3 = peg$parsebc();
                        if (s3 === peg$FAILED) {
                          s3 = peg$parsecv_psalm();
                          if (s3 === peg$FAILED) {
                            s3 = peg$parsebv();
                            if (s3 === peg$FAILED) {
                              s3 = peg$parseb();
                              if (s3 === peg$FAILED) {
                                s3 = peg$parsecbv();
                                if (s3 === peg$FAILED) {
                                  s3 = peg$parsecbv_ordinal();
                                  if (s3 === peg$FAILED) {
                                    s3 = peg$parsec_psalm();
                                    if (s3 === peg$FAILED) {
                                      s3 = peg$parsecb();
                                      if (s3 === peg$FAILED) {
                                        s3 = peg$parsecb_ordinal();
                                        if (s3 === peg$FAILED) {
                                          s3 = peg$parsec_title();
                                          if (s3 === peg$FAILED) {
                                            s3 = peg$parseinteger_title();
                                            if (s3 === peg$FAILED) {
                                              s3 = peg$parsecv();
                                              if (s3 === peg$FAILED) {
                                                s3 = peg$parsev_letter();
                                                if (s3 === peg$FAILED) {
                                                  s3 = peg$parseinteger();
                                                  if (s3 === peg$FAILED) {
                                                    s3 = peg$parsecv_weak();
                                                    if (s3 === peg$FAILED) {
                                                      s3 = peg$parsec();
                                                      if (s3 === peg$FAILED) {
                                                        s3 = peg$parsev();
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c6(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseb() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 31) {
        s1 = peg$c7;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c8); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseany_integer();
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 47) {
            s4 = peg$c9;
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c10); }
          }
          if (s4 !== peg$FAILED) {
            if (peg$c11.test(input.charAt(peg$currPos))) {
              s5 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c12); }
            }
            if (s5 !== peg$FAILED) {
              s4 = [s4, s5];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 === peg$FAILED) {
            s3 = null;
          }
          if (s3 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 31) {
              s4 = peg$c7;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c8); }
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c13(s2);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsebc() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      s0 = peg$currPos;
      s1 = peg$parseb();
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        s3 = peg$parsev_explicit();
        if (s3 !== peg$FAILED) {
          s4 = peg$currPos;
          peg$silentFails++;
          s5 = peg$currPos;
          s6 = peg$parsec();
          if (s6 !== peg$FAILED) {
            s7 = peg$parsecv_sep();
            if (s7 !== peg$FAILED) {
              s8 = peg$parsev();
              if (s8 !== peg$FAILED) {
                s6 = [s6, s7, s8];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          peg$silentFails--;
          if (s5 !== peg$FAILED) {
            peg$currPos = s4;
            s4 = void 0;
          } else {
            s4 = peg$FAILED;
          }
          if (s4 !== peg$FAILED) {
            s3 = [s3, s4];
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 === peg$FAILED) {
          s2 = [];
          s3 = peg$parsecv_sep();
          if (s3 !== peg$FAILED) {
            while (s3 !== peg$FAILED) {
              s2.push(s3);
              s3 = peg$parsecv_sep();
            }
          } else {
            s2 = peg$FAILED;
          }
          if (s2 === peg$FAILED) {
            s2 = [];
            s3 = peg$parsecv_sep_weak();
            if (s3 !== peg$FAILED) {
              while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$parsecv_sep_weak();
              }
            } else {
              s2 = peg$FAILED;
            }
            if (s2 === peg$FAILED) {
              s2 = [];
              s3 = peg$parserange_sep();
              if (s3 !== peg$FAILED) {
                while (s3 !== peg$FAILED) {
                  s2.push(s3);
                  s3 = peg$parserange_sep();
                }
              } else {
                s2 = peg$FAILED;
              }
              if (s2 === peg$FAILED) {
                s2 = peg$parsesp();
              }
            }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsec();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c14(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsebc_comma() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      s1 = peg$parseb();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsesp();
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 44) {
            s3 = peg$c15;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c16); }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parsesp();
            if (s4 !== peg$FAILED) {
              s5 = peg$parsec();
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c14(s1, s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsebc_title() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = peg$parseps151_bc();
      if (s1 === peg$FAILED) {
        s1 = peg$parsebc();
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parsetitle();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c17(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsebcv() {
      var s0, s1, s2, s3, s4, s5, s6;

      s0 = peg$currPos;
      s1 = peg$parseps151_bc();
      if (s1 === peg$FAILED) {
        s1 = peg$parsebc();
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        peg$silentFails++;
        s3 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 46) {
          s4 = peg$c18;
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c19); }
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parsev_explicit();
          if (s5 !== peg$FAILED) {
            s6 = peg$parsev();
            if (s6 !== peg$FAILED) {
              s4 = [s4, s5, s6];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 === peg$FAILED) {
          s3 = peg$currPos;
          s4 = peg$parsesequence_sep();
          if (s4 === peg$FAILED) {
            s4 = null;
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parsev_explicit();
            if (s5 !== peg$FAILED) {
              s6 = peg$parsecv();
              if (s6 !== peg$FAILED) {
                s4 = [s4, s5, s6];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
        peg$silentFails--;
        if (s3 === peg$FAILED) {
          s2 = void 0;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          s4 = peg$parsecv_sep();
          if (s4 === peg$FAILED) {
            s4 = peg$parsesequence_sep();
          }
          if (s4 === peg$FAILED) {
            s4 = null;
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parsev_explicit();
            if (s5 !== peg$FAILED) {
              s4 = [s4, s5];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 === peg$FAILED) {
            s3 = peg$parsecv_sep();
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parsev_letter();
            if (s4 === peg$FAILED) {
              s4 = peg$parsev();
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c20(s1, s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsebcv_weak() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      s0 = peg$currPos;
      s1 = peg$parseps151_bc();
      if (s1 === peg$FAILED) {
        s1 = peg$parsebc();
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parsecv_sep_weak();
        if (s2 !== peg$FAILED) {
          s3 = peg$parsev_letter();
          if (s3 === peg$FAILED) {
            s3 = peg$parsev();
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$currPos;
            peg$silentFails++;
            s5 = peg$currPos;
            s6 = peg$parsecv_sep();
            if (s6 !== peg$FAILED) {
              s7 = peg$parsev();
              if (s7 !== peg$FAILED) {
                s6 = [s6, s7];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            peg$silentFails--;
            if (s5 === peg$FAILED) {
              s4 = void 0;
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c20(s1, s3);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsebcv_comma() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

      s0 = peg$currPos;
      s1 = peg$parsebc_comma();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsesp();
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 44) {
            s3 = peg$c15;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c16); }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parsesp();
            if (s4 !== peg$FAILED) {
              s5 = peg$parsev_letter();
              if (s5 === peg$FAILED) {
                s5 = peg$parsev();
              }
              if (s5 !== peg$FAILED) {
                s6 = peg$currPos;
                peg$silentFails++;
                s7 = peg$currPos;
                s8 = peg$parsecv_sep();
                if (s8 !== peg$FAILED) {
                  s9 = peg$parsev();
                  if (s9 !== peg$FAILED) {
                    s8 = [s8, s9];
                    s7 = s8;
                  } else {
                    peg$currPos = s7;
                    s7 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s7;
                  s7 = peg$FAILED;
                }
                peg$silentFails--;
                if (s7 === peg$FAILED) {
                  s6 = void 0;
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
                if (s6 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c20(s1, s5);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsebcv_hyphen_range() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      s0 = peg$currPos;
      s1 = peg$parseb();
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 45) {
          s2 = peg$c21;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c22); }
        }
        if (s2 === peg$FAILED) {
          s2 = peg$parsespace();
        }
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsec();
          if (s3 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 45) {
              s4 = peg$c21;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c22); }
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parsev();
              if (s5 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 45) {
                  s6 = peg$c21;
                  peg$currPos++;
                } else {
                  s6 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c22); }
                }
                if (s6 !== peg$FAILED) {
                  s7 = peg$parsev();
                  if (s7 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c23(s1, s3, s5, s7);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsebv() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      s1 = peg$parseb();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parsecv_sep();
        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parsecv_sep();
          }
        } else {
          s2 = peg$FAILED;
        }
        if (s2 === peg$FAILED) {
          s2 = [];
          s3 = peg$parsecv_sep_weak();
          if (s3 !== peg$FAILED) {
            while (s3 !== peg$FAILED) {
              s2.push(s3);
              s3 = peg$parsecv_sep_weak();
            }
          } else {
            s2 = peg$FAILED;
          }
          if (s2 === peg$FAILED) {
            s2 = [];
            s3 = peg$parserange_sep();
            if (s3 !== peg$FAILED) {
              while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$parserange_sep();
              }
            } else {
              s2 = peg$FAILED;
            }
            if (s2 === peg$FAILED) {
              s2 = peg$currPos;
              s3 = [];
              s4 = peg$parsesequence_sep();
              if (s4 !== peg$FAILED) {
                while (s4 !== peg$FAILED) {
                  s3.push(s4);
                  s4 = peg$parsesequence_sep();
                }
              } else {
                s3 = peg$FAILED;
              }
              if (s3 !== peg$FAILED) {
                s4 = peg$currPos;
                peg$silentFails++;
                s5 = peg$parsev_explicit();
                peg$silentFails--;
                if (s5 !== peg$FAILED) {
                  peg$currPos = s4;
                  s4 = void 0;
                } else {
                  s4 = peg$FAILED;
                }
                if (s4 !== peg$FAILED) {
                  s3 = [s3, s4];
                  s2 = s3;
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
              if (s2 === peg$FAILED) {
                s2 = peg$parsesp();
              }
            }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsev_letter();
          if (s3 === peg$FAILED) {
            s3 = peg$parsev();
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c24(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsecb() {
      var s0, s1, s2, s3, s4;

      s0 = peg$currPos;
      s1 = peg$parsec_explicit();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsec();
        if (s2 !== peg$FAILED) {
          s3 = peg$parsein_book_of();
          if (s3 === peg$FAILED) {
            s3 = null;
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parseb();
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c25(s2, s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsecb_range() {
      var s0, s1, s2, s3, s4, s5, s6;

      s0 = peg$currPos;
      s1 = peg$parsec_explicit();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsec();
        if (s2 !== peg$FAILED) {
          s3 = peg$parserange_sep();
          if (s3 !== peg$FAILED) {
            s4 = peg$parsec();
            if (s4 !== peg$FAILED) {
              s5 = peg$parsein_book_of();
              if (s5 === peg$FAILED) {
                s5 = null;
              }
              if (s5 !== peg$FAILED) {
                s6 = peg$parseb();
                if (s6 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c26(s2, s4, s6);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsecbv() {
      var s0, s1, s2, s3, s4;

      s0 = peg$currPos;
      s1 = peg$parsecb();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsesequence_sep();
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsev_explicit();
          if (s3 !== peg$FAILED) {
            s4 = peg$parsev();
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c20(s1, s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsecb_ordinal() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      s1 = peg$parsec();
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 2) === peg$c27) {
          s2 = peg$c27;
          peg$currPos += 2;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c28); }
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 2) === peg$c29) {
            s2 = peg$c29;
            peg$currPos += 2;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c30); }
          }
          if (s2 === peg$FAILED) {
            if (input.substr(peg$currPos, 2) === peg$c31) {
              s2 = peg$c31;
              peg$currPos += 2;
            } else {
              s2 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c32); }
            }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsec_explicit();
          if (s3 !== peg$FAILED) {
            s4 = peg$parsein_book_of();
            if (s4 === peg$FAILED) {
              s4 = null;
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parseb();
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c25(s1, s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsecbv_ordinal() {
      var s0, s1, s2, s3, s4;

      s0 = peg$currPos;
      s1 = peg$parsecb_ordinal();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsesequence_sep();
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsev_explicit();
          if (s3 !== peg$FAILED) {
            s4 = peg$parsev();
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c20(s1, s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsec_psalm() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 31) {
        s1 = peg$c7;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c8); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseany_integer();
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 3) === peg$c33) {
            s3 = peg$c33;
            peg$currPos += 3;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c34); }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c35(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsecv_psalm() {
      var s0, s1, s2, s3, s4;

      s0 = peg$currPos;
      s1 = peg$parsec_psalm();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsesequence_sep();
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsev_explicit();
          if (s3 !== peg$FAILED) {
            s4 = peg$parsev();
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c36(s1, s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsec_title() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      s1 = peg$parsec_explicit();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsec();
        if (s2 !== peg$FAILED) {
          s3 = peg$parsetitle();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c37(s2, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsecv() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      s0 = peg$currPos;
      s1 = peg$parsev_explicit();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parsec();
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          peg$silentFails++;
          s4 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 46) {
            s5 = peg$c18;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c19); }
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parsev_explicit();
            if (s6 !== peg$FAILED) {
              s7 = peg$parsev();
              if (s7 !== peg$FAILED) {
                s5 = [s5, s6, s7];
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          peg$silentFails--;
          if (s4 === peg$FAILED) {
            s3 = void 0;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$currPos;
            s5 = peg$parsecv_sep();
            if (s5 === peg$FAILED) {
              s5 = null;
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parsev_explicit();
              if (s6 !== peg$FAILED) {
                s5 = [s5, s6];
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
            if (s4 === peg$FAILED) {
              s4 = peg$parsecv_sep();
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parsev_letter();
              if (s5 === peg$FAILED) {
                s5 = peg$parsev();
              }
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c38(s2, s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsecv_weak() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      s0 = peg$currPos;
      s1 = peg$parsec();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsecv_sep_weak();
        if (s2 !== peg$FAILED) {
          s3 = peg$parsev_letter();
          if (s3 === peg$FAILED) {
            s3 = peg$parsev();
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$currPos;
            peg$silentFails++;
            s5 = peg$currPos;
            s6 = peg$parsecv_sep();
            if (s6 !== peg$FAILED) {
              s7 = peg$parsev();
              if (s7 !== peg$FAILED) {
                s6 = [s6, s7];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            peg$silentFails--;
            if (s5 === peg$FAILED) {
              s4 = void 0;
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c38(s1, s3);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsec() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = peg$parsec_explicit();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseinteger();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c39(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseff() {
      var s0, s1, s2, s3, s4, s5, s6;

      s0 = peg$currPos;
      s1 = peg$parsebcv();
      if (s1 === peg$FAILED) {
        s1 = peg$parsebcv_weak();
        if (s1 === peg$FAILED) {
          s1 = peg$parsebc();
          if (s1 === peg$FAILED) {
            s1 = peg$parsebv();
            if (s1 === peg$FAILED) {
              s1 = peg$parsecv();
              if (s1 === peg$FAILED) {
                s1 = peg$parsecv_weak();
                if (s1 === peg$FAILED) {
                  s1 = peg$parseinteger();
                  if (s1 === peg$FAILED) {
                    s1 = peg$parsec();
                    if (s1 === peg$FAILED) {
                      s1 = peg$parsev();
                    }
                  }
                }
              }
            }
          }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parsesp();
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          if (input.substr(peg$currPos, 2) === peg$c40) {
            s4 = peg$c40;
            peg$currPos += 2;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c41); }
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$currPos;
            peg$silentFails++;
            if (peg$c42.test(input.charAt(peg$currPos))) {
              s6 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c43); }
            }
            peg$silentFails--;
            if (s6 === peg$FAILED) {
              s5 = void 0;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            if (s5 !== peg$FAILED) {
              s4 = [s4, s5];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 === peg$FAILED) {
            s3 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 102) {
              s4 = peg$c44;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c45); }
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$currPos;
              peg$silentFails++;
              if (peg$c42.test(input.charAt(peg$currPos))) {
                s6 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s6 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c43); }
              }
              peg$silentFails--;
              if (s6 === peg$FAILED) {
                s5 = void 0;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
              if (s5 !== peg$FAILED) {
                s4 = [s4, s5];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parseabbrev();
            if (s4 === peg$FAILED) {
              s4 = null;
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$currPos;
              peg$silentFails++;
              if (peg$c46.test(input.charAt(peg$currPos))) {
                s6 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s6 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c47); }
              }
              peg$silentFails--;
              if (s6 === peg$FAILED) {
                s5 = void 0;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c48(s1);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseinteger_title() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      s1 = peg$parseinteger();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsecv_sep();
        if (s2 === peg$FAILED) {
          s2 = peg$parsesequence_sep();
        }
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 5) === peg$c49) {
            s3 = peg$c49;
            peg$currPos += 5;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c50); }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c51(s1);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsecontext() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 31) {
        s1 = peg$c7;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c8); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseany_integer();
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 3) === peg$c52) {
            s3 = peg$c52;
            peg$currPos += 3;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c53); }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c54(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseps151_b() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 31) {
        s1 = peg$c7;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c8); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseany_integer();
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 3) === peg$c55) {
            s3 = peg$c55;
            peg$currPos += 3;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c56); }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c13(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseps151_bc() {
      var s0, s1, s2, s3, s4;

      s0 = peg$currPos;
      s1 = peg$parseps151_b();
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 2) === peg$c57) {
          s2 = peg$c57;
          peg$currPos += 2;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c58); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          peg$silentFails++;
          if (peg$c59.test(input.charAt(peg$currPos))) {
            s4 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c60); }
          }
          peg$silentFails--;
          if (s4 === peg$FAILED) {
            s3 = void 0;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c61(s1);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseps151_bcv() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      s1 = peg$parseps151_bc();
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 46) {
          s2 = peg$c18;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c19); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseinteger();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c62(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsev_letter() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      s0 = peg$currPos;
      s1 = peg$parsev_explicit();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseinteger();
        if (s2 !== peg$FAILED) {
          s3 = peg$parsesp();
          if (s3 !== peg$FAILED) {
            s4 = peg$currPos;
            peg$silentFails++;
            s5 = peg$currPos;
            if (input.substr(peg$currPos, 2) === peg$c40) {
              s6 = peg$c40;
              peg$currPos += 2;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c41); }
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$currPos;
              peg$silentFails++;
              if (peg$c42.test(input.charAt(peg$currPos))) {
                s8 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s8 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c43); }
              }
              peg$silentFails--;
              if (s8 === peg$FAILED) {
                s7 = void 0;
              } else {
                peg$currPos = s7;
                s7 = peg$FAILED;
              }
              if (s7 !== peg$FAILED) {
                s6 = [s6, s7];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            if (s5 === peg$FAILED) {
              s5 = peg$currPos;
              if (input.charCodeAt(peg$currPos) === 102) {
                s6 = peg$c44;
                peg$currPos++;
              } else {
                s6 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c45); }
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$currPos;
                peg$silentFails++;
                if (peg$c42.test(input.charAt(peg$currPos))) {
                  s8 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s8 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c43); }
                }
                peg$silentFails--;
                if (s8 === peg$FAILED) {
                  s7 = void 0;
                } else {
                  peg$currPos = s7;
                  s7 = peg$FAILED;
                }
                if (s7 !== peg$FAILED) {
                  s6 = [s6, s7];
                  s5 = s6;
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            }
            peg$silentFails--;
            if (s5 === peg$FAILED) {
              s4 = void 0;
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
            if (s4 !== peg$FAILED) {
              if (peg$c63.test(input.charAt(peg$currPos))) {
                s5 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c64); }
              }
              if (s5 !== peg$FAILED) {
                s6 = peg$currPos;
                peg$silentFails++;
                if (peg$c46.test(input.charAt(peg$currPos))) {
                  s7 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s7 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c47); }
                }
                peg$silentFails--;
                if (s7 === peg$FAILED) {
                  s6 = void 0;
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
                if (s6 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c65(s2);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsev() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = peg$parsev_explicit();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseinteger();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c65(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsec_explicit() {
      var s0, s1, s2, s3, s4, s5, s6;

      s0 = peg$currPos;
      s1 = peg$parsesp();
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c66) {
          s3 = peg$c66;
          peg$currPos += 2;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c67); }
        }
        if (s3 !== peg$FAILED) {
          if (input.substr(peg$currPos, 6) === peg$c68) {
            s4 = peg$c68;
            peg$currPos += 6;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c69); }
          }
          if (s4 === peg$FAILED) {
            if (input.substr(peg$currPos, 5) === peg$c70) {
              s4 = peg$c70;
              peg$currPos += 5;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c71); }
            }
            if (s4 === peg$FAILED) {
              s4 = peg$currPos;
              if (input.substr(peg$currPos, 4) === peg$c72) {
                s5 = peg$c72;
                peg$currPos += 4;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c73); }
              }
              if (s5 !== peg$FAILED) {
                s6 = peg$parseabbrev();
                if (s6 === peg$FAILED) {
                  s6 = null;
                }
                if (s6 !== peg$FAILED) {
                  s5 = [s5, s6];
                  s4 = s5;
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
              if (s4 === peg$FAILED) {
                s4 = peg$currPos;
                if (input.substr(peg$currPos, 3) === peg$c74) {
                  s5 = peg$c74;
                  peg$currPos += 3;
                } else {
                  s5 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c75); }
                }
                if (s5 !== peg$FAILED) {
                  s6 = peg$parseabbrev();
                  if (s6 === peg$FAILED) {
                    s6 = null;
                  }
                  if (s6 !== peg$FAILED) {
                    s5 = [s5, s6];
                    s4 = s5;
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
                if (s4 === peg$FAILED) {
                  s4 = peg$currPos;
                  if (input.substr(peg$currPos, 3) === peg$c76) {
                    s5 = peg$c76;
                    peg$currPos += 3;
                  } else {
                    s5 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c77); }
                  }
                  if (s5 !== peg$FAILED) {
                    s6 = peg$parseabbrev();
                    if (s6 === peg$FAILED) {
                      s6 = null;
                    }
                    if (s6 !== peg$FAILED) {
                      s5 = [s5, s6];
                      s4 = s5;
                    } else {
                      peg$currPos = s4;
                      s4 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                  if (s4 === peg$FAILED) {
                    s4 = peg$currPos;
                    if (input.substr(peg$currPos, 3) === peg$c78) {
                      s5 = peg$c78;
                      peg$currPos += 3;
                    } else {
                      s5 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c79); }
                    }
                    if (s5 !== peg$FAILED) {
                      s6 = peg$parseabbrev();
                      if (s6 === peg$FAILED) {
                        s6 = null;
                      }
                      if (s6 !== peg$FAILED) {
                        s5 = [s5, s6];
                        s4 = s5;
                      } else {
                        peg$currPos = s4;
                        s4 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s4;
                      s4 = peg$FAILED;
                    }
                    if (s4 === peg$FAILED) {
                      s4 = peg$currPos;
                      if (input.substr(peg$currPos, 2) === peg$c80) {
                        s5 = peg$c80;
                        peg$currPos += 2;
                      } else {
                        s5 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c81); }
                      }
                      if (s5 !== peg$FAILED) {
                        s6 = peg$parseabbrev();
                        if (s6 === peg$FAILED) {
                          s6 = null;
                        }
                        if (s6 !== peg$FAILED) {
                          s5 = [s5, s6];
                          s4 = s5;
                        } else {
                          peg$currPos = s4;
                          s4 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s4;
                        s4 = peg$FAILED;
                      }
                      if (s4 === peg$FAILED) {
                        s4 = peg$currPos;
                        if (input.charCodeAt(peg$currPos) === 112) {
                          s5 = peg$c82;
                          peg$currPos++;
                        } else {
                          s5 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c83); }
                        }
                        if (s5 !== peg$FAILED) {
                          s6 = peg$parseabbrev();
                          if (s6 === peg$FAILED) {
                            s6 = null;
                          }
                          if (s6 !== peg$FAILED) {
                            s5 = [s5, s6];
                            s4 = s5;
                          } else {
                            peg$currPos = s4;
                            s4 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s4;
                          s4 = peg$FAILED;
                        }
                        if (s4 === peg$FAILED) {
                          s4 = peg$currPos;
                          if (input.charCodeAt(peg$currPos) === 115) {
                            s5 = peg$c84;
                            peg$currPos++;
                          } else {
                            s5 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c85); }
                          }
                          if (s5 !== peg$FAILED) {
                            s6 = peg$parseabbrev();
                            if (s6 === peg$FAILED) {
                              s6 = null;
                            }
                            if (s6 !== peg$FAILED) {
                              s5 = [s5, s6];
                              s4 = s5;
                            } else {
                              peg$currPos = s4;
                              s4 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s4;
                            s4 = peg$FAILED;
                          }
                          if (s4 === peg$FAILED) {
                            s4 = peg$currPos;
                            if (input.charCodeAt(peg$currPos) === 97) {
                              s5 = peg$c86;
                              peg$currPos++;
                            } else {
                              s5 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c87); }
                            }
                            if (s5 !== peg$FAILED) {
                              s6 = peg$parseabbrev();
                              if (s6 === peg$FAILED) {
                                s6 = null;
                              }
                              if (s6 !== peg$FAILED) {
                                s5 = [s5, s6];
                                s4 = s5;
                              } else {
                                peg$currPos = s4;
                                s4 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s4;
                              s4 = peg$FAILED;
                            }
                            if (s4 === peg$FAILED) {
                              s4 = peg$parseabbrev();
                              if (s4 === peg$FAILED) {
                                s4 = null;
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
          if (s4 !== peg$FAILED) {
            s3 = [s3, s4];
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsesp();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c88();
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsev_explicit() {
      var s0, s1, s2, s3, s4, s5, s6;

      s0 = peg$currPos;
      s1 = peg$parsesp();
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 118) {
          s3 = peg$c89;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c90); }
        }
        if (s3 !== peg$FAILED) {
          if (input.substr(peg$currPos, 5) === peg$c91) {
            s4 = peg$c91;
            peg$currPos += 5;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c92); }
          }
          if (s4 === peg$FAILED) {
            if (input.substr(peg$currPos, 4) === peg$c93) {
              s4 = peg$c93;
              peg$currPos += 4;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c94); }
            }
            if (s4 === peg$FAILED) {
              s4 = peg$currPos;
              if (input.substr(peg$currPos, 2) === peg$c95) {
                s5 = peg$c95;
                peg$currPos += 2;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c96); }
              }
              if (s5 !== peg$FAILED) {
                s6 = peg$parseabbrev();
                if (s6 === peg$FAILED) {
                  s6 = null;
                }
                if (s6 !== peg$FAILED) {
                  s5 = [s5, s6];
                  s4 = s5;
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
              if (s4 === peg$FAILED) {
                s4 = peg$currPos;
                if (input.substr(peg$currPos, 2) === peg$c97) {
                  s5 = peg$c97;
                  peg$currPos += 2;
                } else {
                  s5 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c98); }
                }
                if (s5 !== peg$FAILED) {
                  s6 = peg$parseabbrev();
                  if (s6 === peg$FAILED) {
                    s6 = null;
                  }
                  if (s6 !== peg$FAILED) {
                    s5 = [s5, s6];
                    s4 = s5;
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
                if (s4 === peg$FAILED) {
                  s4 = peg$currPos;
                  if (input.charCodeAt(peg$currPos) === 115) {
                    s5 = peg$c84;
                    peg$currPos++;
                  } else {
                    s5 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c85); }
                  }
                  if (s5 !== peg$FAILED) {
                    s6 = peg$parseabbrev();
                    if (s6 === peg$FAILED) {
                      s6 = null;
                    }
                    if (s6 !== peg$FAILED) {
                      s5 = [s5, s6];
                      s4 = s5;
                    } else {
                      peg$currPos = s4;
                      s4 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                  if (s4 === peg$FAILED) {
                    s4 = peg$currPos;
                    if (input.charCodeAt(peg$currPos) === 118) {
                      s5 = peg$c89;
                      peg$currPos++;
                    } else {
                      s5 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c90); }
                    }
                    if (s5 !== peg$FAILED) {
                      s6 = peg$parseabbrev();
                      if (s6 === peg$FAILED) {
                        s6 = null;
                      }
                      if (s6 !== peg$FAILED) {
                        s5 = [s5, s6];
                        s4 = s5;
                      } else {
                        peg$currPos = s4;
                        s4 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s4;
                      s4 = peg$FAILED;
                    }
                    if (s4 === peg$FAILED) {
                      s4 = peg$parseabbrev();
                      if (s4 === peg$FAILED) {
                        s4 = null;
                      }
                    }
                  }
                }
              }
            }
          }
          if (s4 !== peg$FAILED) {
            s3 = [s3, s4];
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          peg$silentFails++;
          if (peg$c46.test(input.charAt(peg$currPos))) {
            s4 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c47); }
          }
          peg$silentFails--;
          if (s4 === peg$FAILED) {
            s3 = void 0;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parsesp();
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c99();
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsecv_sep() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

      s0 = peg$currPos;
      s1 = peg$parsesp();
      if (s1 !== peg$FAILED) {
        s2 = [];
        if (input.charCodeAt(peg$currPos) === 58) {
          s3 = peg$c100;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c101); }
        }
        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            if (input.charCodeAt(peg$currPos) === 58) {
              s3 = peg$c100;
              peg$currPos++;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c101); }
            }
          }
        } else {
          s2 = peg$FAILED;
        }
        if (s2 === peg$FAILED) {
          s2 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 46) {
            s3 = peg$c18;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c19); }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$currPos;
            peg$silentFails++;
            s5 = peg$currPos;
            s6 = peg$parsesp();
            if (s6 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 46) {
                s7 = peg$c18;
                peg$currPos++;
              } else {
                s7 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c19); }
              }
              if (s7 !== peg$FAILED) {
                s8 = peg$parsesp();
                if (s8 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 46) {
                    s9 = peg$c18;
                    peg$currPos++;
                  } else {
                    s9 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c19); }
                  }
                  if (s9 !== peg$FAILED) {
                    s6 = [s6, s7, s8, s9];
                    s5 = s6;
                  } else {
                    peg$currPos = s5;
                    s5 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            peg$silentFails--;
            if (s5 === peg$FAILED) {
              s4 = void 0;
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
            if (s4 !== peg$FAILED) {
              s3 = [s3, s4];
              s2 = s3;
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsesp();
          if (s3 !== peg$FAILED) {
            s1 = [s1, s2, s3];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsecv_sep_weak() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      s1 = peg$parsesp();
      if (s1 !== peg$FAILED) {
        if (peg$c102.test(input.charAt(peg$currPos))) {
          s2 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c103); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsesp();
          if (s3 !== peg$FAILED) {
            s1 = [s1, s2, s3];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$parsespace();
      }

      return s0;
    }

    function peg$parsesequence_sep() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

      s0 = peg$currPos;
      s1 = [];
      if (peg$c104.test(input.charAt(peg$currPos))) {
        s2 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c105); }
      }
      if (s2 === peg$FAILED) {
        s2 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 46) {
          s3 = peg$c18;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c19); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$currPos;
          peg$silentFails++;
          s5 = peg$currPos;
          s6 = peg$parsesp();
          if (s6 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 46) {
              s7 = peg$c18;
              peg$currPos++;
            } else {
              s7 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c19); }
            }
            if (s7 !== peg$FAILED) {
              s8 = peg$parsesp();
              if (s8 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 46) {
                  s9 = peg$c18;
                  peg$currPos++;
                } else {
                  s9 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c19); }
                }
                if (s9 !== peg$FAILED) {
                  s6 = [s6, s7, s8, s9];
                  s5 = s6;
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          peg$silentFails--;
          if (s5 === peg$FAILED) {
            s4 = void 0;
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          if (s4 !== peg$FAILED) {
            s3 = [s3, s4];
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 3) === peg$c106) {
            s2 = peg$c106;
            peg$currPos += 3;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c107); }
          }
          if (s2 === peg$FAILED) {
            if (input.substr(peg$currPos, 7) === peg$c108) {
              s2 = peg$c108;
              peg$currPos += 7;
            } else {
              s2 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c109); }
            }
            if (s2 === peg$FAILED) {
              s2 = peg$currPos;
              if (input.substr(peg$currPos, 2) === peg$c110) {
                s3 = peg$c110;
                peg$currPos += 2;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c111); }
              }
              if (s3 !== peg$FAILED) {
                s4 = peg$parseabbrev();
                if (s4 === peg$FAILED) {
                  s4 = null;
                }
                if (s4 !== peg$FAILED) {
                  s3 = [s3, s4];
                  s2 = s3;
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
              if (s2 === peg$FAILED) {
                s2 = peg$currPos;
                if (input.substr(peg$currPos, 3) === peg$c112) {
                  s3 = peg$c112;
                  peg$currPos += 3;
                } else {
                  s3 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c113); }
                }
                if (s3 !== peg$FAILED) {
                  s4 = peg$parsespace();
                  if (s4 !== peg$FAILED) {
                    if (input.substr(peg$currPos, 4) === peg$c114) {
                      s5 = peg$c114;
                      peg$currPos += 4;
                    } else {
                      s5 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c115); }
                    }
                    if (s5 !== peg$FAILED) {
                      s3 = [s3, s4, s5];
                      s2 = s3;
                    } else {
                      peg$currPos = s2;
                      s2 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s2;
                    s2 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }
                if (s2 === peg$FAILED) {
                  if (input.substr(peg$currPos, 4) === peg$c114) {
                    s2 = peg$c114;
                    peg$currPos += 4;
                  } else {
                    s2 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c115); }
                  }
                  if (s2 === peg$FAILED) {
                    if (input.substr(peg$currPos, 3) === peg$c112) {
                      s2 = peg$c112;
                      peg$currPos += 3;
                    } else {
                      s2 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c113); }
                    }
                    if (s2 === peg$FAILED) {
                      s2 = peg$parsespace();
                    }
                  }
                }
              }
            }
          }
        }
      }
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          if (peg$c104.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c105); }
          }
          if (s2 === peg$FAILED) {
            s2 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 46) {
              s3 = peg$c18;
              peg$currPos++;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c19); }
            }
            if (s3 !== peg$FAILED) {
              s4 = peg$currPos;
              peg$silentFails++;
              s5 = peg$currPos;
              s6 = peg$parsesp();
              if (s6 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 46) {
                  s7 = peg$c18;
                  peg$currPos++;
                } else {
                  s7 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c19); }
                }
                if (s7 !== peg$FAILED) {
                  s8 = peg$parsesp();
                  if (s8 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 46) {
                      s9 = peg$c18;
                      peg$currPos++;
                    } else {
                      s9 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c19); }
                    }
                    if (s9 !== peg$FAILED) {
                      s6 = [s6, s7, s8, s9];
                      s5 = s6;
                    } else {
                      peg$currPos = s5;
                      s5 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s5;
                    s5 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
              peg$silentFails--;
              if (s5 === peg$FAILED) {
                s4 = void 0;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
              if (s4 !== peg$FAILED) {
                s3 = [s3, s4];
                s2 = s3;
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
            if (s2 === peg$FAILED) {
              if (input.substr(peg$currPos, 3) === peg$c106) {
                s2 = peg$c106;
                peg$currPos += 3;
              } else {
                s2 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c107); }
              }
              if (s2 === peg$FAILED) {
                if (input.substr(peg$currPos, 7) === peg$c108) {
                  s2 = peg$c108;
                  peg$currPos += 7;
                } else {
                  s2 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c109); }
                }
                if (s2 === peg$FAILED) {
                  s2 = peg$currPos;
                  if (input.substr(peg$currPos, 2) === peg$c110) {
                    s3 = peg$c110;
                    peg$currPos += 2;
                  } else {
                    s3 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c111); }
                  }
                  if (s3 !== peg$FAILED) {
                    s4 = peg$parseabbrev();
                    if (s4 === peg$FAILED) {
                      s4 = null;
                    }
                    if (s4 !== peg$FAILED) {
                      s3 = [s3, s4];
                      s2 = s3;
                    } else {
                      peg$currPos = s2;
                      s2 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s2;
                    s2 = peg$FAILED;
                  }
                  if (s2 === peg$FAILED) {
                    s2 = peg$currPos;
                    if (input.substr(peg$currPos, 3) === peg$c112) {
                      s3 = peg$c112;
                      peg$currPos += 3;
                    } else {
                      s3 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c113); }
                    }
                    if (s3 !== peg$FAILED) {
                      s4 = peg$parsespace();
                      if (s4 !== peg$FAILED) {
                        if (input.substr(peg$currPos, 4) === peg$c114) {
                          s5 = peg$c114;
                          peg$currPos += 4;
                        } else {
                          s5 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c115); }
                        }
                        if (s5 !== peg$FAILED) {
                          s3 = [s3, s4, s5];
                          s2 = s3;
                        } else {
                          peg$currPos = s2;
                          s2 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s2;
                        s2 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s2;
                      s2 = peg$FAILED;
                    }
                    if (s2 === peg$FAILED) {
                      if (input.substr(peg$currPos, 4) === peg$c114) {
                        s2 = peg$c114;
                        peg$currPos += 4;
                      } else {
                        s2 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c115); }
                      }
                      if (s2 === peg$FAILED) {
                        if (input.substr(peg$currPos, 3) === peg$c112) {
                          s2 = peg$c112;
                          peg$currPos += 3;
                        } else {
                          s2 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c113); }
                        }
                        if (s2 === peg$FAILED) {
                          s2 = peg$parsespace();
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      } else {
        s1 = peg$FAILED;
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c116();
      }
      s0 = s1;

      return s0;
    }

    function peg$parserange_sep() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      s1 = peg$parsesp();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        if (peg$c117.test(input.charAt(peg$currPos))) {
          s4 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c118); }
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parsesp();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 === peg$FAILED) {
          s3 = peg$currPos;
          if (input.substr(peg$currPos, 7) === peg$c119) {
            s4 = peg$c119;
            peg$currPos += 7;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c120); }
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parsesp();
            if (s5 !== peg$FAILED) {
              s4 = [s4, s5];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 === peg$FAILED) {
            s3 = peg$currPos;
            if (input.substr(peg$currPos, 4) === peg$c121) {
              s4 = peg$c121;
              peg$currPos += 4;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c122); }
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parsesp();
              if (s5 !== peg$FAILED) {
                s4 = [s4, s5];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
            if (s3 === peg$FAILED) {
              s3 = peg$currPos;
              if (input.substr(peg$currPos, 2) === peg$c123) {
                s4 = peg$c123;
                peg$currPos += 2;
              } else {
                s4 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c124); }
              }
              if (s4 !== peg$FAILED) {
                s5 = peg$parsesp();
                if (s5 !== peg$FAILED) {
                  s4 = [s4, s5];
                  s3 = s4;
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            }
          }
        }
        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$currPos;
            if (peg$c117.test(input.charAt(peg$currPos))) {
              s4 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c118); }
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parsesp();
              if (s5 !== peg$FAILED) {
                s4 = [s4, s5];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
            if (s3 === peg$FAILED) {
              s3 = peg$currPos;
              if (input.substr(peg$currPos, 7) === peg$c119) {
                s4 = peg$c119;
                peg$currPos += 7;
              } else {
                s4 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c120); }
              }
              if (s4 !== peg$FAILED) {
                s5 = peg$parsesp();
                if (s5 !== peg$FAILED) {
                  s4 = [s4, s5];
                  s3 = s4;
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
              if (s3 === peg$FAILED) {
                s3 = peg$currPos;
                if (input.substr(peg$currPos, 4) === peg$c121) {
                  s4 = peg$c121;
                  peg$currPos += 4;
                } else {
                  s4 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c122); }
                }
                if (s4 !== peg$FAILED) {
                  s5 = peg$parsesp();
                  if (s5 !== peg$FAILED) {
                    s4 = [s4, s5];
                    s3 = s4;
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
                if (s3 === peg$FAILED) {
                  s3 = peg$currPos;
                  if (input.substr(peg$currPos, 2) === peg$c123) {
                    s4 = peg$c123;
                    peg$currPos += 2;
                  } else {
                    s4 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c124); }
                  }
                  if (s4 !== peg$FAILED) {
                    s5 = peg$parsesp();
                    if (s5 !== peg$FAILED) {
                      s4 = [s4, s5];
                      s3 = s4;
                    } else {
                      peg$currPos = s3;
                      s3 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                }
              }
            }
          }
        } else {
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          s1 = [s1, s2];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsetitle() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = peg$parsecv_sep();
      if (s1 === peg$FAILED) {
        s1 = peg$parsesequence_sep();
      }
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 5) === peg$c49) {
          s2 = peg$c49;
          peg$currPos += 5;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c50); }
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c125(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsein_book_of() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10;

      s0 = peg$currPos;
      s1 = peg$parsesp();
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 4) === peg$c126) {
          s2 = peg$c126;
          peg$currPos += 4;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c127); }
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 2) === peg$c128) {
            s2 = peg$c128;
            peg$currPos += 2;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c129); }
          }
          if (s2 === peg$FAILED) {
            if (input.substr(peg$currPos, 2) === peg$c130) {
              s2 = peg$c130;
              peg$currPos += 2;
            } else {
              s2 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c131); }
            }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsesp();
          if (s3 !== peg$FAILED) {
            s4 = peg$currPos;
            if (input.substr(peg$currPos, 3) === peg$c132) {
              s5 = peg$c132;
              peg$currPos += 3;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c133); }
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parsesp();
              if (s6 !== peg$FAILED) {
                if (input.substr(peg$currPos, 4) === peg$c134) {
                  s7 = peg$c134;
                  peg$currPos += 4;
                } else {
                  s7 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c135); }
                }
                if (s7 !== peg$FAILED) {
                  s8 = peg$parsesp();
                  if (s8 !== peg$FAILED) {
                    if (input.substr(peg$currPos, 2) === peg$c128) {
                      s9 = peg$c128;
                      peg$currPos += 2;
                    } else {
                      s9 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c129); }
                    }
                    if (s9 !== peg$FAILED) {
                      s10 = peg$parsesp();
                      if (s10 !== peg$FAILED) {
                        s5 = [s5, s6, s7, s8, s9, s10];
                        s4 = s5;
                      } else {
                        peg$currPos = s4;
                        s4 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s4;
                      s4 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
            if (s4 === peg$FAILED) {
              s4 = null;
            }
            if (s4 !== peg$FAILED) {
              s1 = [s1, s2, s3, s4];
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseabbrev() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      s0 = peg$currPos;
      s1 = peg$parsesp();
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 46) {
          s2 = peg$c18;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c19); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          peg$silentFails++;
          s4 = peg$currPos;
          s5 = peg$parsesp();
          if (s5 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 46) {
              s6 = peg$c18;
              peg$currPos++;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c19); }
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$parsesp();
              if (s7 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 46) {
                  s8 = peg$c18;
                  peg$currPos++;
                } else {
                  s8 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c19); }
                }
                if (s8 !== peg$FAILED) {
                  s5 = [s5, s6, s7, s8];
                  s4 = s5;
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          peg$silentFails--;
          if (s4 === peg$FAILED) {
            s3 = void 0;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 !== peg$FAILED) {
            s1 = [s1, s2, s3];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseeu_cv_sep() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      s1 = peg$parsesp();
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 44) {
          s2 = peg$c15;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c16); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsesp();
          if (s3 !== peg$FAILED) {
            s1 = [s1, s2, s3];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsetranslation_sequence_enclosed() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

      s0 = peg$currPos;
      s1 = peg$parsesp();
      if (s1 !== peg$FAILED) {
        if (peg$c136.test(input.charAt(peg$currPos))) {
          s2 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c137); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsesp();
          if (s3 !== peg$FAILED) {
            s4 = peg$currPos;
            s5 = peg$parsetranslation();
            if (s5 !== peg$FAILED) {
              s6 = [];
              s7 = peg$currPos;
              s8 = peg$parsesequence_sep();
              if (s8 !== peg$FAILED) {
                s9 = peg$parsetranslation();
                if (s9 !== peg$FAILED) {
                  s8 = [s8, s9];
                  s7 = s8;
                } else {
                  peg$currPos = s7;
                  s7 = peg$FAILED;
                }
              } else {
                peg$currPos = s7;
                s7 = peg$FAILED;
              }
              while (s7 !== peg$FAILED) {
                s6.push(s7);
                s7 = peg$currPos;
                s8 = peg$parsesequence_sep();
                if (s8 !== peg$FAILED) {
                  s9 = peg$parsetranslation();
                  if (s9 !== peg$FAILED) {
                    s8 = [s8, s9];
                    s7 = s8;
                  } else {
                    peg$currPos = s7;
                    s7 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s7;
                  s7 = peg$FAILED;
                }
              }
              if (s6 !== peg$FAILED) {
                s5 = [s5, s6];
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parsesp();
              if (s5 !== peg$FAILED) {
                if (peg$c138.test(input.charAt(peg$currPos))) {
                  s6 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s6 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c139); }
                }
                if (s6 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c140(s4);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsetranslation_sequence() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      s0 = peg$currPos;
      s1 = peg$parsesp();
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 44) {
          s3 = peg$c15;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c16); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsesp();
          if (s4 !== peg$FAILED) {
            s3 = [s3, s4];
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          s4 = peg$parsetranslation();
          if (s4 !== peg$FAILED) {
            s5 = [];
            s6 = peg$currPos;
            s7 = peg$parsesequence_sep();
            if (s7 !== peg$FAILED) {
              s8 = peg$parsetranslation();
              if (s8 !== peg$FAILED) {
                s7 = [s7, s8];
                s6 = s7;
              } else {
                peg$currPos = s6;
                s6 = peg$FAILED;
              }
            } else {
              peg$currPos = s6;
              s6 = peg$FAILED;
            }
            while (s6 !== peg$FAILED) {
              s5.push(s6);
              s6 = peg$currPos;
              s7 = peg$parsesequence_sep();
              if (s7 !== peg$FAILED) {
                s8 = peg$parsetranslation();
                if (s8 !== peg$FAILED) {
                  s7 = [s7, s8];
                  s6 = s7;
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
              } else {
                peg$currPos = s6;
                s6 = peg$FAILED;
              }
            }
            if (s5 !== peg$FAILED) {
              s4 = [s4, s5];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c140(s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsetranslation() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 30) {
        s1 = peg$c141;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c142); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseany_integer();
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 30) {
            s3 = peg$c141;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c142); }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c143(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseinteger() {
      var res;
      if (res = /^[0-9]{1,3}(?!\d|,000)/.exec(input.substr(peg$currPos))) {
      	peg$savedPos = peg$currPos;
        peg$currPos += res[0].length;
        return {"type": "integer", "value": parseInt(res[0], 10), "indices": [peg$savedPos, peg$currPos - 1]}
      } else {
        return peg$FAILED;
      }
    }

    function peg$parseany_integer() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = [];
      if (peg$c59.test(input.charAt(peg$currPos))) {
        s2 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c60); }
      }
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          if (peg$c59.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c60); }
          }
        }
      } else {
        s1 = peg$FAILED;
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c146(s1);
      }
      s0 = s1;

      return s0;
    }

    function peg$parseword() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = [];
      if (peg$c147.test(input.charAt(peg$currPos))) {
        s2 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c148); }
      }
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          if (peg$c147.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c148); }
          }
        }
      } else {
        s1 = peg$FAILED;
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c149(s1);
      }
      s0 = s1;

      return s0;
    }

    function peg$parseword_parenthesis() {
      var s0, s1;

      s0 = peg$currPos;
      if (peg$c136.test(input.charAt(peg$currPos))) {
        s1 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c137); }
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c150(s1);
      }
      s0 = s1;

      return s0;
    }

    function peg$parsesp() {
      var s0;

      s0 = peg$parsespace();
      if (s0 === peg$FAILED) {
        s0 = null;
      }

      return s0;
    }

    function peg$parsespace() {
      var res;
      if (res = /^[\s\xa0*]+/.exec(input.substr(peg$currPos))) {
        peg$currPos += res[0].length;
        return [];
      }
      return peg$FAILED;
    }

    peg$result = peg$startRuleFunction();

    if (peg$result !== peg$FAILED && peg$currPos === input.length) {
      return peg$result;
    } else {
      if (peg$result !== peg$FAILED && peg$currPos < input.length) {
        peg$fail({ type: "end", description: "end of input" });
      }

      throw peg$buildException(
        null,
        peg$maxFailExpected,
        peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null,
        peg$maxFailPos < input.length
          ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
          : peg$computeLocation(peg$maxFailPos, peg$maxFailPos)
      );
    }
  }

  return {
    SyntaxError: peg$SyntaxError,
    parse:       peg$parse
  };
})();


}).call(this);
